/*  window_name.cc
 *     ̾ϥɥط
 */
/*
 *
 *  Copyright (C) 2001-   Kazunori Ueno(JAGARL) <jagarl@creator.club.ne.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

#include <unistd.h>
#include <string>
#include <vector>
#include <list>
#include <gtk--/style.h>
#include <gtk--/table.h>
#include <gtk--/button.h>
#include <gtk--/entry.h>
#include <gtk--/label.h>
#include "window.h"

using namespace SigC;

//class NameSubWindow : public Gtk::Window {
class NameSubWindow : public Gtk::Fixed {
	struct NameInfo {
		string title;
		string old_name;
		Gtk::Label title_label;
		Gtk::Entry old_entry;
		Gtk::Entry new_entry;
		NameInfo(const char* t, const char* old_n) :
			old_entry(10), new_entry(10)
		{
			if (t == 0) t = "";
			if (old_n == 0) old_n = "";
			char* tmp_title = new char[strlen(t)*2+1];
			kconv((unsigned char*)t, (unsigned char*)tmp_title);
			char* tmp_name = new char[strlen(old_n)*2+1];
			kconv((unsigned char*)old_n, (unsigned char*)tmp_name);
			title = tmp_title;
			old_name = tmp_name;
			title_label.set_text(tmp_title);
			old_entry.set_text(tmp_name);
			old_entry.set_editable(False);
			new_entry.set_text(tmp_name);
			delete[] tmp_name;
		};
		void Attach(Gtk::Table& table, int row) {
			table.attach(title_label, 0, 1, row, row+1, GTK_EXPAND, GTK_EXPAND);
			table.attach(old_entry, 1, 2, row, row+1, GTK_EXPAND, GTK_EXPAND);
			table.attach(new_entry, 3, 4, row, row+1, GTK_EXPAND, GTK_EXPAND);
			title_label.show();
			old_entry.show();
			new_entry.show();
		}
		char* NewName(void) {
			const char* name = new_entry.get_text().c_str();
			char* ret = new char[strlen(name)*2+1];
			kconv_rev((unsigned char*)name, (unsigned char*)ret);
			return ret;
		}
	};
	AyuWindow* main_window;
	Gtk::Fixed& root_widget;
	vector<NameInfo*> info;
	Gtk::VBox main;
	Gtk::Table table;
	Gtk::HBox button_box;
	Gtk::Label label[3];
	Gtk::Button ok_button;
	Gtk::Button cancel_button;
	int pos_x, pos_y, size_x, size_y;
	int state; /* 1 ǽλ 2 ǥ󥻥 */
	int is_init;
public:
	NameSubWindow(AyuWindow* main, Gtk::Fixed& root, AyuSys::NameInfo* info,int list_len);
	~NameSubWindow();
	void GetNames(AyuSys::NameInfo* new_name);
	int State() { return state; }
	gint ButtonPressEvent(GdkEventButton* button, int new_state) {
		state = new_state;
		return FALSE;
	}
	void ClearState(void) { state = 0; }
	gint destroy_event_impl(GdkEventAny*) {
		state = 2;
		return FALSE;
	}
	gint focus_out_event_impl(GdkEventFocus* event) {
		state = 2;
		return FALSE;
	}
	/* ƥɥο˰ư */
//	gint visibility_notify_event_impl(GdkEventVisibility* event) {
//	gint map_notify_event_impl(GdkEventVisibility* event) {
//	gint configure_notify_event_impl(GdkEventVisibility* event) {
	gint configure_event_impl(GdkEventConfigure* event) {
		if (is_init) return FALSE;
		is_init = 1;
		int root_width, root_height;
		int window_width = event->width;
		int window_height = event->height;
		root_widget.get_window().get_size(root_width, root_height);
		int x = 0, y = 0;
		if (root_width > window_width) x += (root_width-window_width)/2;
		if (root_height > window_height) y += (root_height-window_height)/2;
		root_widget.move(*this, x, y);
		return FALSE;
	}
	gint enter_notify_event_impl(GdkEventCrossing* event) {
		get_window().set_cursor(Gdk_Cursor(GDK_ARROW));
		return FALSE;
	}

};

NameSubWindow::NameSubWindow(AyuWindow* root_window, Gtk::Fixed& root_wid, AyuSys::NameInfo* sysinfo,int list_len) :
	//	Gtk::Window(GTK_WINDOW_DIALOG),
	Gtk::Fixed(),
		root_widget(root_wid),
		table(4, list_len <= 0 ? 1 : list_len+1,FALSE) ,
		ok_button(gettext("Ok")), cancel_button(gettext("Cancel"))
{
	// ɥν
	add(main); main.show();
	set_events( get_events() |
		GDK_VISIBILITY_NOTIFY_MASK |
GDK_STRUCTURE_MASK|
		GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK);
	state = 0; is_init = 0;
	if (list_len <= 0) list_len = 0;
	main_window = root_window;
	main.pack_start(table, true, false);
	/* ܥκ */
	button_box.pack_start(ok_button, true, false);
	button_box.pack_start(cancel_button, true, false);
	ok_button.button_press_event.connect(bind(slot(this, &NameSubWindow::ButtonPressEvent), 1));
	cancel_button.button_press_event.connect(bind(slot(this, &NameSubWindow::ButtonPressEvent), 2));
	main.pack_start(button_box, true, false);

	/* ȥʤɤĤ */
	label[0].set_text(gettext("old name"));
	label[1].set_text(gettext("->"));
	label[2].set_text(gettext("new name"));
	label[0].show(); label[1].show(); label[2].show();
	table.attach(label[0], 1, 2, 0, 1, GTK_EXPAND, GTK_EXPAND);
	table.attach(label[1], 2, 3, 0, 1, GTK_EXPAND, GTK_EXPAND);
	table.attach(label[2], 3, 4, 0, 1, GTK_EXPAND, GTK_EXPAND);
	int i;
	for (i=0; i<list_len; i++) {
		NameInfo* new_info = new NameInfo(sysinfo[i].title, sysinfo[i].old_name);
		new_info->Attach(table, i+1);
		info.push_back(new_info);
	}
	table.show(); button_box.show_all(); show();
}

NameSubWindow::~NameSubWindow() {
	vector<NameInfo*>::iterator it;
	for (it=info.begin(); it != info.end(); it++)
		delete *it;
}

void NameSubWindow::GetNames(AyuSys::NameInfo* sysinfo) {
	vector<NameInfo*>::iterator it;
	for (it=info.begin(); it != info.end(); it++, sysinfo++)
		sysinfo->new_name = (*it)->NewName();
}

int AyuWindow::OpenNameDialog(AyuSys::NameInfo* names, int list_deal)
{
	int old_brightness = text_window_brightness;
	int old_window_type = text_window_type;
	DrawTextWindow(0, 50); // ̤Ť

	/* ̾ѥɥ */
	NameSubWindow* sub_window = new NameSubWindow(this, main, names, list_deal);
	main.put(*sub_window,100,100);
	sub_window->ClearState();
	while(sub_window->State() == 0 && (!local_system.IsIntterupted())) {
		local_system.WaitNextEvent();
	}
	int ret = 0;
	if ( local_system.IsIntterupted() || sub_window->State() == 2) {
		ret = 1;
	} else {
		sub_window->GetNames(names);
	}
	delete sub_window;
	DrawTextWindow(old_window_type, old_brightness);
	return ret;
}

/* ̾ϥȥʰĤ */
class NameSubEntry : public Gtk::Entry {
	Gtk::Fixed& root_widget;
	static list<NameSubEntry*> all_entries;
	char name[1024];
public:
	NameSubEntry(Gtk::Fixed& root) : root_widget(root) {
		all_entries.push_back(this);
	};
	~NameSubEntry(void) {
		root_widget.remove(*this);
		all_entries.remove(this);
	}
	const char* GetName(void) {
		kconv_rev( (unsigned char*)get_text().c_str(), (unsigned char*)name);
		return name;
	}
	void SetName(const char* new_name) {
		kconv( (unsigned char*)new_name, (unsigned char*)name);
		set_text(name);
	}
	static void CloseAll(void) {
		list<NameSubEntry*>::iterator it;
		for (it = all_entries.begin(); it != all_entries.end(); it++) {
			delete (*it);
		}
		all_entries.clear();
	}
};
list<NameSubEntry*> NameSubEntry::all_entries;

NameSubEntry* AyuSys::OpenNameEntry(int x, int y, int width, int height, const COLOR_TABLE& fore, const COLOR_TABLE& back) {
	if (main_window) return main_window->OpenNameEntry(x,y,width,height,fore,back);
	else return 0;
}
NameSubEntry* AyuWindow::OpenNameEntry(int x, int y, int width, int height, const COLOR_TABLE& fore, const COLOR_TABLE& back) {
	if (x < 0) { width += x; x = 0; }
	if (y < 0) { height += y; y = 0;}
	if (x+width >= 640) { width = 640-x; }
	if (y+height>= 480) { height = 480-y; }
	if (width <= 0 || height <= 0) return 0;

	/* ȥ */
	NameSubEntry* new_entry = new NameSubEntry(main);
	new_entry->set_usize(width, height);
	main.put(*new_entry, x, y);
	new_entry->show();
	/*  */
	Gdk_Color fore_color, back_color;
	fore_color.set_rgb(fore.c1*65535/255, fore.c2*65535/255, fore.c3*65535/255);
	back_color.set_rgb(back.c1*65535/255, back.c2*65535/255, back.c3*65535/255);
	Gdk_Colormap::get_system().alloc(fore_color);
	Gdk_Colormap::get_system().alloc(back_color);

	Gtk::Style* style = new_entry->get_style()->copy();
	style->set_fg(GTK_STATE_NORMAL, fore_color);
	style->set_bg(GTK_STATE_NORMAL, back_color);
	style->set_base(GTK_STATE_NORMAL, back_color);
	new_entry->set_style(*style);
	return new_entry;
}

const char* AyuSys::GetNameFromEntry(NameSubEntry* entry) {
	if (entry) return entry->GetName();
	else return "";
}
void AyuSys::SetNameToEntry(NameSubEntry* entry, const char* name) {
	if (entry) entry->SetName(name);
}
void AyuSys::CloseNameEntry(NameSubEntry* entry){
	if (entry) delete entry;
}
void AyuSys::CloseAllNameEntry(void) {
	NameSubEntry::CloseAll();
}

#if 0

	int old_brightness = text_window_brightness;
	int old_window_type = text_window_type;
	DrawTextWindow(0, 50); // ̤Ť

	Gtk::Button* ok_button = new Gtk::Button("Ok");
	Gtk::Button* cancel_button = new Gtk::Button("Cancel");
	Gtk::Entry* old_entry = new Gtk::Entry(); old_entry->set_max_length(20);
	Gtk::Entry* new_entry = new Gtk::Entry(); new_entry->set_max_length(20);
	Gtk::Label* label1 = new Gtk::Label("");
	Gtk::Label* label2 = new Gtk::Label("̾ʹ졡");

	main.put(*label1,200,200); label1->show();
	main.put(*label2,200,250); label2->show();
	main.put(*old_entry,300,200); old_entry->show();
	main.put(*new_entry,300,250); new_entry->show();
	main.put(*ok_button,250,300); ok_button->show();
	main.put(*cancel_button,300,300); cancel_button->show();
	ok_button->button_press_event.connect(SigC::bind<int>(SigC::slot(button_press),1));
	cancel_button->button_press_event.connect(SigC::bind<int>(SigC::slot(button_press),2));
	state = 0;
	while(state == 0) {
		local_system.CallProcessMessages();
		usleep(10000);
	}
	main.remove(*label1); main.remove(*label2);
	main.remove(*old_entry); main.remove(*new_entry);
	main.remove(*ok_button); main.remove(*cancel_button);
	delete ok_button; delete cancel_button;
	delete old_entry; delete new_entry;
	delete label1; delete label2;
	DrawTextWindow(old_window_type, old_brightness);
#endif

