/*-
 * @(#)gdkmm_test.cc -- Code using ttfont functions
 */

#include <gtk--/window.h>
#include <gtk--/style.h>
#include <gtk--/main.h>

#include "gdkmm_font.h"
#include "gdkmm_pixmap.h"

class Gdk_Test_FreeType : public Gtk::Window {
protected:
    /* Gdk-- relates */
    Gdk_Window		 win;
    Gdk_GC		 gc;
    Gdk_Pixmap_FreeType	 pixmap;

    /* event implements */ 
    gint delete_event_impl(GdkEventAny *);
    gint configure_event_impl(GdkEventConfigure *);
    gint expose_event_impl(GdkEventExpose *);

public:
    /* constructor and destructor */
    Gdk_Test_FreeType();
    ~Gdk_Test_FreeType() {}
};

Gdk_Test_FreeType::Gdk_Test_FreeType()
    : Gtk::Window(GTK_WINDOW_TOPLEVEL)
{
    set_events(GDK_EXPOSURE_MASK);
    show_all();
}

gint
Gdk_Test_FreeType::delete_event_impl(GdkEventAny *)
{
    Gtk::Main::quit();
    return 0;
}

gint
Gdk_Test_FreeType::configure_event_impl(GdkEventConfigure *event)
{
    win = get_window();

    if (pixmap)
	pixmap.release();
    pixmap = Gdk_Pixmap_FreeType(win, width(), height());

    gc = get_style()->get_white_gc();
    pixmap.draw_rectangle(gc, TRUE, 0, 0, width(), height());

    char *text = "\xcb\xa8";  /* Moe in Japanese */
    char ch[3] = { text[0], text[1], 0 };

    Gdk_Color col;
    Gdk_GC    gc_pen(win);
    Gdk_Font_FreeType font("default.ttc", 30.0);

    for (int j = 0; j < 4; j++) {
	for (int i = 0; i < 4; i++) {
	    col.set_random();
	    get_colormap().alloc(col);
	    gc_pen.set_foreground(col);
	    pixmap.draw_string(font, gc_pen, i * 38 + 20, j * 38 + 60, ch);
	}
    }

    return TRUE;
}

gint
Gdk_Test_FreeType::expose_event_impl(GdkEventExpose *event)
{
    gc = get_style()->get_fg_gc(get_state());
    win.draw_pixmap(gc, pixmap,
		    event->area.x, event->area.y,
		    event->area.x, event->area.y,
		    event->area.width, event->area.height);

    return FALSE;
}

int
main(int argc, char *argv[])
{
    Gtk::Main app(argc, argv);
    Gdk_Test_FreeType gdk_test;

    app.run();

    return 0;
}

/* gdkmm_test.cc ends here */
