/*-
 * @(#)chconv.c -- Kanji converter
 */

#include "chconv.h"
#include "chconv_tbl.h"

unsigned int
chconv_null(unsigned int x)
{
    return x;
}

unsigned int
chconv_euc_to_jis(unsigned int euc)
{
    unsigned int hi, low;

    hi = (euc >> 8) & 0xff;
    low = euc & 0xff;

    if (hi < 0x81) {
	low = hi;
	hi = 0;
    } else if (low == 0x8e)
	hi = 0;
    else {
	hi -= 0x80;
	low -= 0x80;
    }

    return (hi << 8) | low;
}

unsigned int
chconv_jis_to_unicode(unsigned int jis)
{
    int k0, k1;

    k0 = (jis >> 8) - 0x20;
    if (k0 < 1 || k0 > 92)
	return 0;

    k1 = (jis % 0x100) - 0x20;
    if (k1 < 1 || k1 > 94)
	return 0;

    return unicode_tbl[k0 - 1][k1 - 1];
}

unsigned int
chconv_euc_to_unicode(unsigned int euc)
{
    unsigned int jis, unicode;

    jis = chconv_euc_to_jis(euc);
    unicode = chconv_jis_to_unicode(jis);

    return unicode;
}

unsigned int
chconv_unicode_to_jis(unsigned int unicode)
{
    int k0, k1;
    unsigned int jis;

    k0 = (unicode >> 8) & 0xff;
    k1 = unicode & 0xff;
    jis = unicode_rev_table[k0][k1];
    
    return jis;
}

unsigned int
chconv_jis_to_euc(unsigned int jis)
{
    unsigned int hi, low;

    hi = (jis >> 8) & 0x7f | 0x80;
    low = jis & 0x7f | 0x80;

    return (hi << 8) | low;
}

unsigned int
chconv_unicode_to_euc(unsigned int unicode)
{
    unsigned int jis, euc;

    /* in case of half-spaced KATAKANA */
    if (unicode >= 0xff61 && unicode <= 0xff9f)
	return unicode - 0xff61 + 0x8ea1;

    jis = chconv_unicode_to_jis(unicode);
    if (jis == 0)
	return 0x7878;
    euc = chconv_jis_to_euc(jis);

    return euc;
}

unsigned int
chconv_jis_to_sjis(unsigned int jis)
{
    unsigned int hi, low;

    hi = (jis >> 8) & 0xff;
    low = jis & 0xff;

    low += (hi & 0x01) ? 0x1f : 0x7d;
    if (low >= 0x7f)
	low++;
    hi = ((hi - 0x21) >> 1) + 0x81;
    if (hi > 0x9f)
	hi += 0x40;

    return (hi << 8) | low;
}

unsigned int
chconv_euc_to_sjis(unsigned int euc)
{
    unsigned int jis, sjis;

    jis = chconv_euc_to_jis(euc);
    sjis = chconv_jis_to_sjis(jis);

    return sjis;
}

unsigned int
chconv_sjis_to_jis(unsigned int sjis)
{
    unsigned int hi, low;

    hi = (sjis >> 8) & 0xff;
    low = sjis & 0xff;

    hi -= (hi <= 0x9f) ? 0x71 : 0xb1;
    hi = (hi << 1) + 1;
    if (low > 0x7f)
	low--;
    if (low >= 0x9e) {
	low -= 0x7d;
	hi++;
    } else
	low -= 0x1f;

    return (hi << 8) | low;
}

unsigned int
chconv_sjis_to_euc(unsigned int sjis)
{
    unsigned int jis, euc;

    jis = chconv_sjis_to_jis(sjis);
    euc = chconv_jis_to_euc(jis);

    return euc;
}

/* chconv.c ends here */
