/* option.cc
 *   ޥɥ饤󡦥ץ
 */

/*
 *
 *  Copyright (C) 2001-   Kazunori Ueno(JAGARL) <jagarl@creator.club.ne.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

#include<string.h>
#include<stdlib.h>
#include"system.h"
#include"senario.h"

void parse_option(int& argc, char** argv, AyuSys& local_system,
	char** fontname, char** ttfontname, int * fontsize, char** savepath) {
	int i;
	for (i=1; i<argc; i++) {
		// option  parse
		if (argv[i][0] == '-' && argv[i][1] == '-') {
			int flag = 0;
		// without_opt:
			if (strcmp(argv[i], "--no-music") == 0) {
				local_system.DisableMusic();
				flag = 2;
				goto end_parse;
			} else if (strcmp(argv[i], "--no-mixer") == 0) {
				local_system.SetWaveMixer(0);
				flag = 2;
				goto end_parse;
			} else if (strcmp(argv[i], "--with-text") == 0) {
				local_system.SetTextDump();
				flag = 2;
			}
			if (i == argc-1) goto end_parse; // without optional string
		// with_opt:
			if (strcmp(argv[i], "--path") == 0) {
				flag = 1;
			} else if (strcmp(argv[i], "--savepath") == 0) {
				if (savepath) *savepath = argv[i+1];
				flag = 1;
			} else if (strcmp(argv[i], "--title") == 0) {
				char buf[1024];
				strncpy(buf,argv[i+1],200); buf[200]=0;
				kconv_rev( (unsigned char*)(buf), (unsigned char*)(buf+200));
				local_system.config->SetParaStr("#CAPTION",buf+200);
				flag = 1;
			} else if (strcmp(argv[i], "--version") == 0 ) {
				int version = atoi(argv[i+1]);
				if (version < 0 || version > 3) version = 1;
				local_system.SetVersion(version);
				flag = 1;
			} else if (strcmp(argv[i], "--mouse-pos") == 0) {
				if (strcmp(argv[i+1], "lt") == 0) {
					local_system.SetMouseCursorPos(0,0);
				} else if (strcmp(argv[i+1], "lb") == 0) {
					local_system.SetMouseCursorPos(0,32);
				} else if (strcmp(argv[i+1], "rt") == 0) {
					local_system.SetMouseCursorPos(32,0);
				} else if (strcmp(argv[i+1], "rb") == 0) {
					local_system.SetMouseCursorPos(32,32);
				}
				flag = 1;
			} else if (strcmp(argv[i], "--patch") == 0) {
				SENARIO_PATCH::AddPatch(argv[i+1]);
				flag = 1;
			} else if (strcmp(argv[i], "--speed") == 0 ) {
				int sp = atoi(argv[i+1]);
				if (sp <= 0) sp = 1;
				if (sp > 1000) sp = 1000;
				local_system.SetTextSpeed(sp);
				flag = 1;
			} else if (strcmp(argv[i], "--pcmrate") == 0) {
				local_system.SetPCMRate(atoi(argv[i+1]));
				flag = 1;
			} else if (strcmp(argv[i], "--font") == 0) {
				if (fontname) *fontname = argv[i+1];
				flag = 1;
			} else if (strcmp(argv[i], "--ttfont") == 0) {
				if (ttfontname) *ttfontname = argv[i+1];
				flag = 1;
			} else if (strcmp(argv[i], "--fontsize") == 0) {
				if (fontsize) *fontsize = atoi(argv[i+1]);
				flag = 1;
			} else if (strcmp(argv[i], "--pcmdev") == 0) {
				local_system.SetPCMDevice(argv[i+1]);
				flag = 1;
			} else if (strcmp(argv[i], "--mixdev") == 0) {
				local_system.SetMixDevice(argv[i+1]);
				flag = 1;
			} else if (strcmp(argv[i], "--cddev") == 0) {
				local_system.SetCDROMDevice(argv[i+1]);
				flag = 1;
			} else {
				fprintf(stderr, "unknown option %s\n",argv[i]);
				flag = 2;
			}
		end_parse:
			if (flag == 1) {
				int j; for (j=i+2; j<argc; j++) argv[j-2] = argv[j];
				argc -= 2; i--;
			} else if (flag == 2) {
				int j; for (j=i+1; j<argc; j++) argv[j-1] = argv[j];
				argc -= 1; i--;
			}
		}
	}
}
