#include<unistd.h>
#include<signal.h>
#include<stdio.h>
#include<string.h>
extern "C" {
#include "contrib/music.h"
#include "contrib/mixer.h"
}

static char* path = 0;

static void signal_handler(int sig_num) {
	mus_exit();
	exit(-1);
}

int main(int argc, char* argv[]) {
	if (argc != 2) return 0;
	signal(SIGINT, signal_handler);
	signal(SIGTERM, signal_handler);
	path = argv[1];
	mus_init();
	if (pcm_enable)
		mus_bgm_start(path, 1);
	sleep(1000);
	mus_exit();
	return 0;
}
extern "C" void MakeMusicPath(char* fname, char* buf) {
	strcpy(buf, path);
	return;
}
extern "C" void MakeKoePath(int pointer, char* buf, int* index) {
	char file_ext[1024];
	int file_no = pointer / 10000;
	*index = pointer % 10000;

	sprintf(buf, "z%03d.koe", file_no);
	return;
}

char* System_tmpDir = "/tmp";
void System_error(const char* msg) {
	fprintf(stderr, "Error  : %s\n",msg);
	fflush(stderr);
}
void System_errorOutOfMemory(const char* msg) {
	System_error(msg);
}

