/* gtest_main.cc
 *    եåطΥƥѡ
 *    AyuWindow κȡ̤ΥƥȤԤ
 */
/*
 *
 *  Copyright (C) 2000-   Kazunori Ueno(JAGARL) <jagarl@creator.club.ne.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/

#include <gtk--/main.h>
#include <gtk--/window.h>
#include <gtk--/button.h>
#include <gtk--/pixmap.h>
#include <gtk--/box.h>
#include <gtk--/packer.h>
#include <gtk--/menu.h>
#include <gtk--/label.h>
#include <gtk--/eventbox.h>
#include <gtk--/fixed.h>
#include <glib.h>
#include <X11/Xlib.h>
#include <gdk/gdkx.h>
#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include "initial.h"
#include "window.h"


static int first_senario = 1;
static int first_point = 0;
#ifdef DEFAULT_VERSION
static int version = DEFAULT_VERSION;
#else
static int version = 1; // Ǥǥե
#endif

void gtest(AyuSys& system);

static int is_quit = 0;
#include<pthread.h>
void QuitAll(void)
{
	global_system.Finalize();
	// gtk_main_quit();
}

static int idle_isProcess = 0;
gint idle_handler(void) {
	
	// window ƤʤФʤˤ⤷ʤ
	if (global_system.main_window == 0) return FALSE;
	if (! global_system.main_window->IsInitialized() ) return FALSE;
	if (! idle_isProcess) {
		// ʥꥪǥɳ˥ʥäƤСλ
		if (is_quit) {
			QuitAll();
			gtk_main_quit();
			return FALSE;
		}
		
		idle_isProcess = 1;
		gtest(global_system);
		global_system.Finalize();
		idle_isProcess = 0;
		/* ƥཪλ */
		gtk_main_quit();
	}
	// idle_handler ϰ󤷤Фʤ false ֤
	return FALSE ;
}

gint timer(void) {
	// window ޤǡʤˤ⤷ʤ
	if (global_system.main_window == 0) return TRUE;
	if (! global_system.main_window->IsInitialized() ) return TRUE;
	// window¸ߤʤ顢100 ms ˣ󡢥꥿󡦥ηѹ
	global_system.main_window->ChangeRetnCursor();
	// ʥꥪΥǥɳ(ǥʤʤˤ⤷ʤ)
	if (! idle_isProcess)
		Gtk::Main::idle.connect(SigC::slot(idle_handler));
	return TRUE;
}

void SaveFile(int n) {}
int main(int argc, char *argv[])
{
	char buf[1024];

	Initialize::Exec();
	gtk_set_locale();

#ifdef DEFAULT_DATAPATH
	char* datpath = DEFAULT_DATAPATH;
#else
	char* datpath = "/tmp/kanon";
#endif

#ifdef DEFAULT_SAVEPATH
	char* savepath = DEFAULT_SAVEPATH;
#else
	char* savepath = "~/.kanon";
#endif

	// 26 24 ȤʻԤʤ
	char* fontname_orig = "-*-*-*-r-*--24-*-*-*-*-*-jisx0208.1983-*";
	char* fontname = fontname_orig;
	int fontsize = 0;
	
	int i; for (i=1; i<argc; i++) {
		// option  parse
		if (argv[i][0] == '-' && argv[i][1] == '-') {
			int flag = 0;
			if (strcmp(argv[i], "--path") == 0) {
				datpath = argv[i+1];
				flag = 1;
			} else if (strcmp(argv[i], "--font") == 0) {
				fontname = argv[i+1];
				flag = 1;
			} else if (strcmp(argv[i], "--fontsize") == 0) {
				fontsize = atoi(argv[i+1]);
				flag = 1;
			}
			if (flag == 1) {
				int j; for (j=i+2; j<argc; j++) argv[j-2] = argv[j];
				argc -= 2; i--;
			} else if (flag == 2) {
				int j; for (j=i+1; j<argc; j++) argv[j-1] = argv[j];
				argc -= 1; i--;
			}
		}
	}
        // config եɤ߹
        if (file_searcher.InitRoot(datpath) == -1) {
                fprintf(stderr, "Cannot use %s as root directory ; it cannot be read or there is no dat/ directory.\n",datpath);
                return -1;
        }
        global_system.LoadInitFile();

	Gtk::Main* kit = new Gtk::Main(argc, argv);
	if (fontname == fontname_orig && fontsize != 0) {
		fontname = buf;
		sprintf(buf, "-*-*-*-r-*--%d-*-*-*-*-*-jisx0208.1983-*", fontsize);
	}
	AyuWindow* view = new AyuWindow(global_system, fontname);
	if (fontsize != 0) view->SetFontSize(fontsize);
	
	int point;

	Gtk::Main::timeout.connect(SigC::slot(timer),100);

        kit->run();  // λˤ ^C ɬפ롣

	/* Ѥʬ return ˲Ƥ
	** (memory profiling )
	*/
	delete view;

        return(0);
}
#include"senario.h"

void SENARIO_PATCH::AddPatch(char* identifier) {}
