/*
  Copyright (C) 1997-2005  Dimitrios P. Bouras

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   For author contact information, look in the README file.
*/

/* Constants for xisp, xispdial, rcio.c and xisprccv.c */

#define MAXLEN_DESCR     32	/* configuration description string length */
#define MAXLEN_PHONE     64	/* phone string length */
#define MAXNUM_TELS       8	/* maximum telephone numbers in options */
#define MAXLEN_ACCOUNT   64	/* account number of characters */
#define MAXLEN_PASSWD    64	/* password characters */
#define MAXLEN_UNR       64	/* name/user/remote pppd opt arg maximum chars */ 
#define MAXDIG_RETRY      3	/* number of retries maximum digits */
#define MAXDIG_DELAY      3	/* inter-dialing delay seconds # maximum digits */
#define MAXDIG_CNWAIT     3	/* modem connection wait seconds # of digits */
#define MAXDIG_LCPWAIT    3	/* network connection wait seconds # of digits */
#define MAXDIG_CBDELAY    3	/* call-back delay seconds # maximum digits */
#define MAXNUM_SLINES    16	/* maximum number of saved script lines */
#define MAXLEN_SLINE     64	/* characters in each script line */
#define MAXLEN_MDMCMD    64	/* modem commands maximum length */
#define MAXLEN_MDMSTR    16	/* modem result strings maximum length */
#define MAXLEN_DEVICE    32	/* modem device name string length */
#define MAXDIG_BSDCOMP    2	/* BSD compression level number digits */
#define MAXLEN_DIALEXTRA  8	/* extra chars between "AT" and "D" commands */
#define MAXDIG_ASYNCMAP   8	/* pppd asyncmap number of digits */
#define MAXLEN_ESCAPE    16	/* pppd escape character list length */
#define MAXLEN_IP        15	/* all IP input strings length */
#define MAXDIG_MTRU       4	/* MTU and MRU maximum number of digits */
#define MAXLEN_TTPARM    64	/* xispterm parameter string maximum length */
#define MAXBUF_CHILD    128	/* buffer size for dialer output reads by xISP */
#define MAXNUM_RETRY     10	/* default total number of dialing tries */
#define MAXSEC_DELAY      5	/* default delay between dials */
#define MAXSEC_CBDELAY   60	/* default delay for call-back wait */
#define MAXSEC_CNWAIT    50	/* default maximum wait for modem connection */
#define MAXSEC_LCPWAIT   30	/* default maximum wait for network connection */
#define MINSEC_MODEM_TO  10	/* minimum timeout for modem connection */
#define MINSEC_LINK_TO   15 /* minimum timeout for link connection */
#define MAXLEN_PATH     256 /* maximum path length for all program paths */
#define MAXLEN_FNAME    512	/* maximum complete file-name string length */
#define MAXLEN_DNNAME    64	/* default domain name maximum string length */
#define MAXDIG_BAUDRATE   7 /* modem speed maximum digits */
#define MIN_COMPLEVEL     8 /* minimum (usefull) S/W compression level */
#define MAX_COMPLEVEL    15 /* maximum S/W compression level */

/* xISP file names */

#define RCFNAME      ".xisprc"		/* for all program options */
#define PIPEFNAME    ".xisppipe"	/* named pipe for reporting */
#ifdef ISPENV_USEVARS
 #define ENVVAR      "XISPDIAL"		/* generated dialer environment var */
#else
 #define ENVFNAME    ".xispenv"		/* generated dialer environment file */
#endif
#define SCRIPTFNAME  ".xispscript"	/* generated dialing script */
#define PAPFNAME     ".xisppap"		/* the login data file for PAP */
#define LOGDIRNAME   ".xisplogs"	/* directory holding xisp logs */
#define LOGFNROOT    "xisplog"		/* root-name for xisp log files */
#define COSTFNROOT   "xispcost"		/* root-name for xisp total cost files */
#define PTTFNAME     "xispPTTs"		/* the PTT data base file */
#define XISPUPNAME   ".xisp-up"		/* user's "ip-up" file */
#define XISPDOWNNAME ".xisp-down"	/* user's "ip-down" file */
#define XISPPIDFNAME ".xisppid"		/* file containing PID of running xisp */

/* xISP/xispdial default paths and files. System defaults for
   BINPATH, RUNDIR LIBPATH and OPTPATH are defined in Makefile */

#ifndef PPPD_PATH
 #define PPPD_PATH	 BINPATH					/* pppd executable */
#endif
#define PPPD         "/pppd"
#ifdef RUNDIR
 #define RUN_PATH	 RUNDIR						/* pppd PID files */
#else
 #define RUN_PATH	 ""
#endif
#ifndef LOCK_PATH
 #define LOCK_PATH   PPPDLCKDIR					/* modem device lock file */
#endif
#ifndef CHAT_PATH
 #define CHAT_PATH	 BINPATH					/* chat executable */
#endif
#define CHAT		 "/chat"
#define UTILS_PATH	 LIBPATH					/* xispterm and xispdial */
#define PPPD_CONNECT "/xispdial"				/* pppd connect prog */
#define TERMINAL     "/xispterm"				/* manual login terminal */
#define PIPE_PATH	 "/tmp"						/* named-pipe node */
#define PPPD_OPTIONS OPTPATH "/options.xisp"	/* default options file */

/* Modem and communication defines */

#ifndef MODEM_PATH
 #define MODEM_PATH    "/dev/modem"			/* default modem device */
#endif
#define MAXNUM_SPEEDS   8					/* DTE<->DCE speeds: a subset */
#define MS_0            1200				/* of the "standard" ones */
#define MS_1            2400
#define MS_2            4800
#define MS_3            9600
#define MS_4            19200
#define MS_5            38400
#define MS_6            57600
#define MS_7            115200
#define MODEM_SPEED     MS_5				/* 38400 Baud set by default */
#define MIN_BAUDRATE    150					/* min and max custom */
#define MAX_BAUDRATE    1024000				/* Baud rates */
#define MODEM_INIT	    "AT"				/* default init string */
#define MODEM_RESET	    "ATZ"				/* default reset string */
#define MODEM_CONNECT   "CONNECT"			/* default connect string */
#define BSDCOMP         "bsdcomp"			/* pppd BSD compression option */
#define DIAL_EXTRA      ""					/* default extra dialing chars */
#define COMP_LEVEL      12					/* default S/W compression level */
#define PPPD_SASYNCMAP  "20A0000"			/* pppd asyncmap for software */
#define PPPD_HASYNCMAP  "00"				/* and hardware flow contol */
#define PPPD_ESCAPE     "FF"				/* default pppd escape list */
#define DEFLCOMP        "deflate"			/* pppd deflate compression opt */

/* Manual terminal size defines */

#define TERMW         30
#define MINCHAR_TERMW 20
#define TERMH         12
#define MINCHAR_TERMH  6

/* TCP/IP defines */

#define LOCAL_IP     "\x00\x00\x00\x00"		/* default local IP address */
#define LOCAL_IPSTR  "0.0.0.0"
#define REMOTE_IP    "\x00\x00\x00\x00"		/* default remote IP address */
#define REMOTE_IPSTR "0.0.0.0"
#define NETMASK      "\xFF\xFF\xFF\x00"		/* default netmask */
#define NETMASKSTR   "255.255.255.0"
#define DNS          "\x00\x00\x00\x00"		/* default DNS address */
#define DNS_IPSTR    "0.0.0.0"
#define MTU          1500					/* MTU and MRU defaults */
#define MRU          1500

/* Operating mode options flags */

#define MODEM_TONEDIAL	0x00000001
#define BSD_COMPRESS	0x00000002
#define HW_FLOWCTRL		0x00000004
#define ACCEPT_LOCALIP	0x00000008
#define ACCEPT_REMOTEIP	0x00000010
#define DEFAULT_ROUTE	0x00000020
#define MANUAL_LOGIN	0x00000040
#define PAP_LOGIN		0x00000080
#define AUTO_REDIAL		0x00000100
#define CALL_BACK		0x00000200
#define ESCAPE_ON		0x00000400
#define IP_UPDOWN		0x00000800
#define PAPS_LOGIN		0x00001000
#define CHAPS_LOGIN		0x00002000
#define CONNECT_BELL	0x00004000
#define STARTUP_DIAL    0x00008000
#define CBMAN_LOGIN		0x00010000
#define CB_NT_RAS		0x00020000
#define DEFL_COMPRESS	0x00040000
#define MODEM_ISDNDIAL	0x00080000
#define AUTO_DNS		0x00100000
#define DEFAULT_DOMAIN	0x00200000

/* Default operating mode */

#define OPER_OPTS (MODEM_TONEDIAL|BSD_COMPRESS|HW_FLOWCTRL| \
				   ACCEPT_LOCALIP|ACCEPT_REMOTEIP|DEFAULT_ROUTE)

/* The data file structure for all xisp options */

typedef struct {
	char descr[MAXLEN_DESCR+1];					/* ISP entry description */
	char account[MAXLEN_ACCOUNT+1];				/* user account name */
	char passwd[MAXLEN_PASSWD+1];				/* and password */
	char name[MAXLEN_UNR+1];					/* name/user pppd arg */
	char rname[MAXLEN_UNR+1];					/* and remotename pppd arg */
	unsigned char maxAttempts;					/* maximum dialing attempts */
	unsigned char sleepDelay;					/* delay between dials */
	unsigned char connectWait;					/* modem connection timeout */
	unsigned char LCPWait;						/* net connection timeout */
	unsigned char numPhones;					/* # of phone-number entries */
	char phone[MAXNUM_TELS][MAXLEN_PHONE+1];	/* phone number table */
	unsigned char numSlines;					/* # of script lines */
	char sline[2*MAXNUM_SLINES][MAXLEN_SLINE+1];/* script line table */
	unsigned char CBDelay;						/* delay for call-back dials */
	unsigned char numCBSlns;					/* # call-back script lines */
	char CBsln[2*MAXNUM_SLINES][MAXLEN_SLINE+1];/* call-back script table */
	unsigned char termW;						/* manual terminal width */
	unsigned char termH;						/* and height in characters */
	unsigned char CBtermW;						/* manual terminal size */
	unsigned char CBtermH;						/* for call-back connections */
	char CBphone[MAXLEN_PHONE+1];				/* NT-RAS call-back phone # */
	char modemDevice[MAXLEN_DEVICE+1];			/* modem device path */
	unsigned int modemSpeed;					/* DTE<->DCE Baud rate */
	char modemReset[MAXLEN_MDMCMD+1];			/* modem reset command */
	char modemInit[MAXLEN_MDMCMD+1];			/* modem init command */
	char modemConnect[MAXLEN_MDMCMD+1];			/* modem connect string */
	unsigned long operOpts;						/* operating options flags */
	char dialExtra[MAXLEN_DIALEXTRA+1];			/* dialing command char(s) */
	unsigned char compLevel;					/* SW compression level */
	char asyncmap[MAXDIG_ASYNCMAP+1];			/* pppd asyncmap */
	char escape[MAXLEN_ESCAPE+1];				/* and escape options */
	unsigned char localIP[4];					/* local IP entry */
	unsigned char remoteIP[4];					/* remote IP entry */
	unsigned char netmask[4];					/* netmask entry */
	unsigned char dns1[4];						/* primary DNS entry */
	unsigned char dns2[4];						/* secondary DNS entry */
	unsigned int mtu;							/* the MTU */
	unsigned int mru;							/* and the MRU */
	char domainname[MAXLEN_DNNAME+1];			/* default domain name */
	unsigned char ispPTT;						/* PTT selected for ISP */
	unsigned char ispZone;						/* and its default zone */
} xisprc_t;

#define XISPRC_DEFAULT {{0},{0},{0},{0},{0},MAXNUM_RETRY,MAXSEC_DELAY,\
						MAXSEC_CNWAIT,MAXSEC_LCPWAIT,0,{{0}},0,{{0}},\
						MAXSEC_CBDELAY,TERMW,TERMH,MODEM_DEVICE,\
						MODEM_SPEED,MODEM_RESET,MODEM_INIT,OPER_OPTS,\
						DIAL_EXTRA,COMP_LEVEL,PPPD_HASYNCMAP,PPPD_ESCAPE,\
						LOCAL_IP,REMOTE_IP,NETMASK,DNS,DNS,MTU,MRU,{0},\
						PTT_GR_EPAK,0}

/* Logging mode options flags */

#define LOG_NONE		0x0001
#define LOG_WEEKLY 		0x0002
#define LOG_MONTHLY		0x0004
#define LOG_BIMONTHLY	0x0008
#define COST_READOUT	0x0010
#define LOG_HINTS		0x1000

/* Default logging mode */

#define LOG_OPTS (LOG_NONE|LOG_HINTS)

/* Associated strings */

#define RTIME_STR		" Time\n On-Line:"
#define RCOST_STR		" Cost\n Charged:"
#define CUNIT_STR		"(seconds per unit)"
#define CTIME_STR		"(%s per minute)"

/* The global information structure */

typedef struct {
	unsigned char numISPs;			/* number of ISPs in .xisprc */
	unsigned char dfltISP;			/* default ISP to select after startup */
	unsigned char numPTTs;			/* total number of PTTs in database */
	unsigned char costPTT;			/* total cost currency def'ed in this PTT */
	unsigned short logOpts;			/* logging options flags */
	char pppdPath[MAXLEN_PATH+1];	/* path to the pppd daemon */
	char runPath[MAXLEN_PATH+1];	/* path to the pppd process ID files */
	char lockPath[MAXLEN_PATH+1];	/* path to the modem device lock file */
	char chatPath[MAXLEN_PATH+1];	/* path to the chat utility */
	char utilsPath[MAXLEN_PATH+1];	/* path to xispdial and xispterm */
	char pipePath[MAXLEN_PATH+1];	/* path to the xisp named-pipe node */
} glob_t;

#define GLOB_DEFAULT {0, 0, MAXNUM_PTT, PTT_GR_EPAK, LOG_OPTS, PPPD_PATH, \
					  RUN_PATH, LOCK_PATH, CHAT_PATH, UTILS_PATH, PIPE_PATH};

/* Connection mode basic types (ORed for combinations) */

#define SCRIPT_DIALIN		0x01
#define SCRIPT_CALLBACK		0x02
#define MANUAL_DIALIN		0x04
#define MANUAL_CALLBACK		0x08
#define AUTH_DIALIN			0x10
#define AUTH_CALLBACK		0x20
#define NT_RAS_DIALIN		0x40
#define NT_RAS_CALLBACK		0x80

