/*
 *  Xeukleides  version 1.0.1
 *  Copyright (c) Christian Obrecht 2000-2004
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

typedef struct {
  double x,y;
} _point;

typedef struct {
  double x,y;
} _vector;

typedef struct {
  double x,y,angle;
} _line;

typedef struct {
  double x1,y1,x2,y2;
} _segment;

typedef struct {
  double x,y,radius;
} _circle;

typedef struct {
  double x,y,d,a,b;
  int kind;
} _conic;

struct interrec {
  double value, step;
  int free;
};

typedef struct interrec interrec;

struct assignrec {
  unsigned int pos, len;
  int i, j, f;
};

typedef struct assignrec assignrec;

struct symrec {
  char *name;
  int type;
  union {
    double number;
    _point *point;
    _vector *vector;
    _line *line;
    _segment *segment;
    _circle *circle;
    _conic *conic;
    interrec *interactive;
  } object;
  struct symrec *next;
};

typedef struct symrec symrec;

struct saverec {
  void * s;
  struct saverec * next;
};

typedef struct saverec saverec;

#define NORMAL_MODE 0
#define TRACE_MODE 1
#define STRING_MODE 2
#define COMMENT_MODE 3

#define PARSING 0
#define STARTING 1
#define TRACING 2
#define RESTARTING 3
