# example RPM spec file for xcdroast
%define		prefix /usr
%define		majorversion 1
Name:		xcdroast
Version:	%{majorversion}.18
Release:	1 
Summary:	A user friendly GUI for copying and creating Audio-CDs and Data-Discs
Copyright:	GPL 
Vendor:		Thomas Niederreiter
Group:		Applications/Multimedia
Source:		http://www.xcdroast.org/download/xcdroast-%{version}.tar.gz
Url:		http://www.xcdroast.org
BuildRoot:	/tmp/%{name}-%{version}-root
Requires:	cdrtools-cdrecord, cdrtools-mkisofs, cdrtools-cdda2wav
Recommends: 	gksu
BuildRequires:	gtk2-devel >= 2.24
 
%description
X-CD-Roast is a flexible frontend for optical disc authoring.
It combines command line tools like "cdrecord", "cdda2wav", "readcd"
and "mkisofs" into a nice GTK based graphical user interface.

%prep
%setup -n xcdroast-%{version}

%build
CC="gcc $RPM_OPT_FLAGS" ./configure --prefix=%{prefix} --mandir=%{prefix}/share/man --sysconfdir /etc 
make
 
%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT 

chmod 4711 $RPM_BUILD_ROOT%{prefix}/lib/xcdroast/bin/xcdrwrap
cp -f extra/xcdroast.desktop $RPM_BUILD_ROOT/usr/share/applications/
strip -R .comment $RPM_BUILD_ROOT%{prefix}/bin/xcdroast


%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc doc/*
%{prefix}/bin/xcdroast
%{prefix}/share/man/man1/xcdroast.1*
%{prefix}/lib/xcdroast-%{majorversion}/*
%{prefix}/share/locale/*
/usr/share/applications/xcdroast.desktop

%changelog

