
/*
 *
 *   Xbreaky: A breakout game for X11
 *
 *   Copyright (C) 2000  Dave Brul
 *   
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *
 *   Coded by Dave Brul  <davebrul@hotmail.com>
 */

#include <X11/Xlib.h> 
#include <X11/Xutil.h>
#include <X11/xpm.h>
#include <assert.h> 
#include <sys/time.h> 
#include <fcntl.h> 
#include <unistd.h>   
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <ctype.h>
#include <string.h>
#include "font.cpp"
#include "xbreaky.xpm"

#define LEVELS PREFIX"/share/games/xbreaky/level"
#define NIL (0)      
#define COLORS 35


int RGB[COLORS][3] =
{
  	0,	0,	0,	// black
        65535,	65535,	65535, 	// white
       	65280,	65280,	0,	// yellow
	0,	65280, 	0,      // green
	65280, 	32512, 	0,   	// orange
	65280,	0,	0,	// red
	0, 	0,	65280,	// bal blue1
	0, 	0, 	35584,	// bal blue3
	55552, 	55552, 	55552,	// beam grey	
	
	// and now for the block colors ..
	
	46336, 	46336, 	46336,	// gray block middle
	20992, 	20992, 	20992,	// gray block rim
	32512, 	65280, 	0,	// chartruese block middle
	17664, 	35584, 	0,	// chartruese block rim
	51712, 	65280, 	2,	// darkolivegreen block middle
	28160, 	35584, 	15616,	// darkolivegreen block rim
	65280, 	65280, 	0,	// yellow block middle
	35584, 	35584, 	0,	// yellow block rim
	65280, 	55040, 	0,	// gold block middle
	35584, 	29952, 	0,	// gold block rim
	65280, 	12288, 	12288,	// firebrick block middle
	35584, 	6656, 	6656,	// firebrick block rim
	65280, 	32512, 	9216,	// choclate block middle
	35584, 	17664, 	4864,	// choclate block rim		
	49408, 	65280, 	49408,	// darkseegreen block middle
	26880, 	35584, 	26880,	// darkseegreen block rim
	43776, 	33280, 	65280,  // MediumPurple4 block middle
	23808, 	18176, 	35584,  // MediumPurple4 block rim
	65280, 	57600, 	65280,	// darkorchid block middle
	35584, 	31488, 	35584,  // darkorchid block rim
	
	// valbal colors
	
	0,	65280, 	0,      // green
	0, 	35584, 	0,	// green valbal rim
	65280, 	32512, 	0,   	// orange
	35584, 	17664, 	0,	// darkorange rim
	65280,	0,	0,	// red
	35584, 	0, 	0,	// red valbal rim

};


typedef struct {
                int  score;
                char naam[7];
               } Item;


typedef struct {
		int  aantal;
		Item rij[3];
	       } Scorelijst;
	       

typedef struct {
	        int x;
	        int lastx;
	        int lengte;
	        int mode;
	        int lastmode;
		int timer;
	       } Beam;

	  
typedef struct {
		int x;
		int y;
		int lastx;
		int lasty;
		int r;
		int mode;
		int lastmode;
		int timer;
		int color;
	       } Bal;

	  
typedef struct {
		int x;
		int y;
		int mode;
		int color;
		int onderweg;
	       } Modus;
	       

typedef struct {
		int  x;
		int  y;
		int  onderweg;
	       } Kogel;	       
	       

// globale variabelen ...


Scorelijst	scorelijst;
Modus		valbal[10];
int		numberoflevels=0, color[COLORS], times=2, togglesound=1, grabpointer=1;
int 		soundfd, audio_ok=1;
unsigned char	bk[28][22];                 


// functie prototipes


void initscherm(Display *dpy, Window w, GC gc);
void initialize_colors(Display *disp);
void drawtext(int x, int y, int color, char string[], Display *dpy, Window w, GC gc);
void putball(int x, int y, int col, Display *dpy, Window w, GC gc);
void drawbeam(Beam beam, Display *dpy, Window w, GC gc);
void writestatus(int score, int balls, int blocks, int level, Display *dpy, Window w, GC gc);
void drawblock(int x, int y, int colfor, Display *dpy, Window w, GC gc);
void changemode(int balmode, int beammode, Display *dpy, Window w, GC gc);
void drawball(Bal & bal, Beam & beam, int score, int balls, int blocks, int level, Display *dpy, Window w, GC gc);
void shootball(Bal & bal, Beam & beam, int score, int balls, int blocks, int level,  Display *dpy, Window w, GC gc);
void gethighscores(Display *dpy, Window w, GC gc);
void clearfield(Display *dpy, Window w, GC gc);
void clearnames(Display *dpy, Window w, GC gc);
int  gameover(int score, Display *dpy, Window w, GC gc);
void getstring(char string[], int lengte, int x, int y, Display *dpy, Window w, GC gc);
void countlevels(void);
int  bouwlevel(int &blocks, Display *dpy, Window w, GC gc);
void redrawlevel(Display *dpy, Window w, GC gc);
void check4bots(Bal & bal, Beam & beam, int &score, int &blocks, Display *dpy, Window w, GC gc);
int  isblock(int x, int y);
void blockhit(int x, int y, int &score, int &blocks, int &balmode, int &beammode, Display *dpy, Window w, GC gc);
int  warp(int &blocks, int &score, Display *dpy, Window w, GC gc);
void dropvalbal(int x, int y, Display *dpy, Window w, GC gc);
void movevalbal(Beam & beam, int & balmode, Display *dpy, Window w, GC gc);
void putvalbal(int x, int y, int col, Display *dpy, Window w, GC gc);
void pause(Beam beam, Bal bal, int score, int balls, int blocks, int level, Display *dpy, Window w, GC gc);
void movekogels(Kogel kogels[10], int &score, int &blocks, Display *dpy, Window w, GC gc);
void putkogel(Kogel & kogel, Display *dpy, Window w, GC gc);
void clearkogel(Kogel & kogel, Display *dpy, Window w, GC gc);
void shootblock(int x, int y, int &score, int &blocks, Display *dpy, Window w, GC gc);
void wait(int usec);
void usage(void);
void play_sound(int k);
void init_sound(void);

       
int main(int argc, char *argv[])
{

// object definition ...

	Beam  beam;
	Bal   bal;
	Kogel kogels[10];

// object initialisation ..
	
        beam.x       =	100;
	beam.lengte  =	 24;
	beam.mode    =	  0;
	beam.timer   =    0;
	beam.lastx   =    0;
	bal.r        =	  0;
	bal.mode     =    0;
	bal.color    =    6;
	bal.timer    =    0;
	
// eof object stuff ...	
// variables ..

      int score=0, balls=4, blocks=0, level=0, index=0, blocks_temp;
      int fire=0, mousex, mousey=150, mousebutton, bye=0, oldtime, newtime, teller=0;
      unsigned char ascii=0;	
      struct timeval randomnumber;
      Pixmap pointerpix, maskpix, icon, iconmask;
      const char pointer=1, mask=0;
      XColor dummy;
      struct timeval before, after;
      XSizeHints wmhints;
      XWMHints wmhint;
	
      // check arguments ...
      
      argc--; 
      argv++;
      
      for(int counter=0; counter < argc; counter++)
      {
       if(strcmp(argv[counter], "-nosound") == 0)
       {
        togglesound=0;
       }
       else if(strcmp(argv[counter], "-nograb") == 0)
       {
        grabpointer=0;
       }
       else if(strcmp(argv[counter], "-size") == 0)
       {
        counter++;
        if(counter < argc)
        {
         times = atoi(argv[counter]);
         if(times<1||times>5) times=2;
        }
        else 
        {
         fprintf(stderr, "Xbreaky: -size option error.\n");
         exit(1); 
        }  
       }
       else if(strcmp(argv[counter], "-help") == 0)
       {
        usage();
        exit(0);
       }
       else if(strcmp(argv[counter], "-h") == 0)
       {
        usage();
        exit(0);
       }
       else
       {
        fprintf(stderr,"Xbreaky: Unknown option \"%s\".\n",argv[counter]);
        usage();
        exit(1);
       } 
      } 
      
      // sound init
      
      
      if(togglesound) 
      {
       init_sound();
      }
      else
      {
       audio_ok=0;
      } 
         
      // Open the display
          

     
      Display *dpy = XOpenDisplay(NIL);
      assert(dpy);

      // Get some colors

      initialize_colors(dpy);
      
      // Create the window

      Window w = XCreateSimpleWindow(dpy, DefaultRootWindow(dpy), 0, 0, 
				     320*times, 200*times, 0, color[0], color[0]);

      wmhints.flags=USPosition|USSize|PMinSize|PMaxSize;
      wmhints.x=wmhints.y=0;
      wmhints.flags=PSize|PMinSize|PMaxSize;
      wmhints.width=wmhints.min_width=wmhints.max_width=320*times;
      wmhints.height=wmhints.min_height=wmhints.max_height=200*times;
      XSetWMNormalHints(dpy, w , &wmhints);
      XCreatePixmapFromData(dpy, w, xbreaky_xpm, &icon, NULL, NULL);
      wmhint.flags=IconPixmapHint;
      wmhint.icon_pixmap=icon;
      XSetWMHints(dpy, w, &wmhint);
      XSelectInput(dpy, w, StructureNotifyMask);
      
      XStoreName(dpy, w, "Xbreaky");
      
      // "Map" the window (that is, make it appear on the screen)

      XMapWindow(dpy, w);

      // Create a "Graphics Context"

      GC gc = XCreateGC(dpy, w, 0, NIL);

     // Wait for the MapNotify event

      for(;;) {
	    XEvent event;
	    XNextEvent(dpy, &event);
	    if (event.type == MapNotify)
		  break;
  
             } 
      XSelectInput(dpy, w, KeyReleaseMask| ButtonPressMask| ButtonReleaseMask| PointerMotionMask| ExposureMask);
      XSync(dpy, 0); 
      
      // removing cursor ..
      
      pointerpix = XCreateBitmapFromData(dpy, w, &pointer, 1 ,1);
      maskpix    = XCreateBitmapFromData(dpy, w, &mask, 1 ,1);
      dummy.red=0; dummy.green=0; dummy.blue=0;
      Cursor gone = XCreatePixmapCursor(dpy, pointerpix, maskpix,  &dummy, &dummy, 1, 1);
      
      if(grabpointer)
      {
       XGrabPointer(dpy, w, 1, ButtonPressMask| ButtonReleaseMask| PointerMotionMask, 
                   GrabModeAsync, GrabModeAsync, w, gone, CurrentTime);
       XGrabKeyboard(dpy, w, 0, GrabModeAsync, GrabModeAsync, CurrentTime); 
      }
      else
      { 
       XDefineCursor(dpy, w, gone);
      } 
      
      // cursor gone .. 
      
      for(int tel=0; tel<10; tel++)
      {
       kogels[tel].onderweg=0;
       valbal[tel].onderweg=0;
      }
      gettimeofday(&randomnumber,NULL);
      srand(randomnumber.tv_usec%10);
      initscherm(dpy, w, gc);
      drawtext(274,45,1,"Running", dpy, w, gc);
      changemode(bal.mode, beam.mode, dpy, w, gc);
      gethighscores(dpy, w, gc);
      countlevels();
      level=bouwlevel(blocks, dpy, w, gc);
      writestatus(score,balls,blocks,level,dpy, w, gc);
      XSync(dpy, 0); 
      sleep(1);
      shootball(bal,beam,score, balls, blocks, level,dpy, w, gc);
      
      do
      { 
       gettimeofday(&before,NULL);
       oldtime=before.tv_usec+1000000*before.tv_sec;
  //     do
  //     {  
        if(XPending(dpy))
        {
         XEvent event;     
         XNextEvent(dpy,&event);
         switch (event.type)
	  {
	   case Expose:        if(event.xexpose.count == 0) 
	   			       {  
	                       initscherm(dpy, w, gc);
	                       drawtext(274,45,1,"Running", dpy, w, gc);
	                       changemode(bal.mode, beam.mode, dpy, w, gc);
	                       redrawlevel(dpy, w, gc);  
	                       gethighscores(dpy, w, gc);
                               writestatus(score, balls, blocks, level, dpy, w, gc);
                               drawbeam(beam, dpy, w, gc); 
                               putball(bal.x,bal.y, bal.color,dpy, w, gc);
                               }
			       break; 
           case KeyRelease:   {KeySym keysym = XLookupKeysym( &event.xkey, 0 );
                               if(event.xkey.keycode == 9)   bye=1; 
                               if(event.xkey.keycode == 33)  
                               {
                                 if(grabpointer) 
                                 {
                                  XUngrabKeyboard(dpy, CurrentTime);
                                  XUngrabPointer(dpy, CurrentTime); 
                                 }
                                 pause(beam, bal, score, balls, blocks, level, dpy, w, gc);
                                 if(grabpointer)
                                 { 
                                  XGrabPointer(dpy, w, 1, ButtonPressMask| ButtonReleaseMask| PointerMotionMask,
                                               GrabModeAsync, GrabModeAsync, w, gone, CurrentTime);
                                  XGrabKeyboard(dpy, w, 0, GrabModeAsync, GrabModeAsync, CurrentTime);  
                                 } 
                               }
                               if(event.xkey.keycode == 27)  redrawlevel(dpy, w, gc);       
                              } break; 
       	   case MotionNotify: { beam.x=event.xmotion.x;  
       	                        if(beam.x>239-beam.lengte) beam.x=239-beam.lengte; 
       	                        if(beam.x<2) beam.x=2;
       	                        if(beam.mode==4) beam.x=215-beam.x+2;
       	                        drawbeam(beam, dpy, w, gc); } break;
       	    case ButtonPress:   if(beam.mode==6) fire=1;
break;
            case ButtonRelease: fire=0; break;                     
	 }
        }
      
  //    }
  //    while(newtime < (oldtime+waittime*1000)); 
      if(beam.mode!=6) fire=0; 
      if(fire)
      {
       index++;
       if(index>=15&&bal.mode!=3&&bal.mode!=4||index>=22&&bal.mode==4||index>=9&&bal.mode==3)
       {
	index=0;
	int teller=0;
	while(kogels[teller].onderweg) teller++;
	if(teller<10)
	{
	 kogels[teller].x=beam.x+22/2;
	 kogels[teller].y=182;
	 putkogel(kogels[teller], dpy, w, gc);
         play_sound(1);       
        }
       }
      }  
        if(beam.lastmode!=beam.mode)
        {
 	 beam.timer=0;
	 if(beam.mode!=2&&beam.mode!=3) beam.lengte=24;
	 if(beam.mode==2)				beam.lengte=48;
	 if(beam.mode==3)				beam.lengte=12;
	 beam.lastmode=beam.mode;
	 changemode(bal.mode, beam.mode,dpy, w, gc);
	 if(beam.x>239-beam.lengte) beam.x=239-beam.lengte; 
	 drawbeam(beam, dpy, w, gc);
        }
        if(bal.lastmode!=bal.mode)
        {
	 bal.timer=0;
	 changemode(bal.mode, beam.mode,dpy, w, gc);
	 if(bal.mode==8)
	 {
	  bal.mode=bal.lastmode;
	  putball(bal.x,bal.y,0,dpy, w, gc);
	  for(int tt=0; tt<10; tt++)
	  {
	   if(kogels[tt].onderweg)
           {
	    clearkogel(kogels[tt], dpy, w, gc);
	   }
           if(valbal[tt].onderweg)
	   {
	    valbal[tt].onderweg=0;
	    putball(valbal[tt].x,valbal[tt].y,0,dpy, w, gc);
	   }
	  }
	  level=warp(blocks,score,dpy, w, gc);
	  changemode(bal.mode, beam.mode,dpy, w, gc);
          writestatus(score,balls,blocks,level,dpy, w, gc);
          shootball(bal,beam,score, balls, blocks, level,dpy, w, gc);
  	 }
	 if(bal.mode==3) bal.timer=3000;
	 if(bal.mode==4) bal.timer=-1000;
	 if(bal.mode==6)
	 {
	  balls++;
/*	  for(int t=0; t<100; t++)
	  {
	   sound(800+t*10);
	   delay(3);
	  }
	  nosound();
*/
	  bal.mode=bal.lastmode;
	  changemode(bal.mode, beam.mode,dpy, w, gc);
	 } 
	 if(bal.mode==7)
	 {
	  if(balls>0) balls--;
 /*	 for(int p=0; p<100; p++)
	  {
           sound(1800-p*10);
	   delay(3);
	  }
	  nosound();
*/
          bal.mode=bal.lastmode;
	  changemode(bal.mode, beam.mode,dpy, w, gc);
	 }
	 bal.lastmode=bal.mode;
      	 }
        if(blocks_temp!=blocks)
        {
	 blocks_temp=blocks;
	 writestatus(score,balls,blocks,level, dpy, w, gc);
        } 
        if(bal.y>=195)
        {
         for(int tt=0; tt<10; tt++)
         {
          if(kogels[tt].onderweg)
	  { 
	   clearkogel(kogels[tt], dpy, w, gc);
	  }
	  if(valbal[tt].onderweg)
	  {
	   valbal[tt].onderweg=0;
	   putball(valbal[tt].x,valbal[tt].y,0,dpy, w, gc);
	  }
         }
         putball(bal.x,bal.y, 0,dpy, w, gc);
	 balls--;
         bal.mode=0;
	 if(balls<0)
	 {
	  if(gameover(score,dpy, w, gc)) 
	  {
	   bye=1;
	  }  
	  else
 	  {
	   balls=4;
	   score=0;
	   bal.mode=0;
           beam.mode=0;
	   changemode(bal.mode, beam.mode, dpy, w, gc);
	   level=bouwlevel(blocks, dpy, w, gc);
	   writestatus(score,balls,blocks,level, dpy, w, gc);
	   drawbeam(beam, dpy, w, gc);
	   shootball(bal,beam,score, balls, blocks, level,dpy, w, gc);
	  } 
         }
         if(bye != 1)
         { 
          changemode(bal.mode, beam.mode, dpy, w, gc);
          writestatus(score,balls,blocks,level, dpy, w, gc);
          shootball(bal,beam,score, balls, blocks, level,dpy, w, gc);
         }
        }
        if(blocks<=0)
        {
	 for(int tt=0; tt<10; tt++)
	 {
	  if(kogels[tt].onderweg)
	  {
	   clearkogel(kogels[tt], dpy, w, gc);
	  }
	  if(valbal[tt].onderweg)
	  {
	   valbal[tt].onderweg=0;
	   putball(valbal[tt].x,valbal[tt].y,0,dpy, w, gc);
          }
         }
	 putball(bal.x,bal.y,0, dpy, w, gc);
	 level=bouwlevel(blocks, dpy, w, gc);
	 writestatus(score, balls, blocks, level, dpy, w, gc);
	 shootball(bal,beam,score, balls, blocks, level,dpy, w, gc);
        }
        if(bal.mode!=0)
        {
         bal.timer++;
         if(bal.timer>6000)
	 { 
	  bal.timer=0;
	  bal.mode=0;
	 }
        }
        if(beam.mode!=0)
        {
	 beam.timer++;
	 if(beam.timer>6000)
	 {
	  beam.timer=0;
	  beam.mode=0;
	  drawbeam(beam, dpy, w, gc);
	 }
        }
 		
        if(bal.mode==4)
        {
         drawball(bal,beam,score, balls, blocks, level, dpy, w, gc);
         check4bots(bal, beam, score, blocks,dpy, w, gc);
         drawball(bal,beam,score, balls, blocks, level, dpy, w, gc);
         check4bots(bal, beam, score, blocks,dpy, w, gc);
        } 
        else if(bal.mode==3)
        {
         teller++;
         if(teller>1) 
         {
          teller=0;
          drawball(bal,beam,score, balls, blocks, level, dpy, w, gc);
          check4bots(bal, beam, score, blocks,dpy, w, gc);
         }
        }
        else 
        {
         drawball(bal,beam,score, balls, blocks, level, dpy, w, gc);
         check4bots(bal, beam, score, blocks,dpy, w, gc);         
        }
        movevalbal(beam, bal.mode, dpy, w, gc);  
        movekogels(kogels, score, blocks,dpy, w, gc);
        XSync(dpy, 0);
        gettimeofday(&after,NULL);
        if(after.tv_sec>before.tv_sec) after.tv_usec +=1000000;
        newtime=after.tv_usec+1000000*after.tv_sec; 
        
        wait(10000-(newtime-oldtime)); 
   }  
 while(bye != 1);  
 XSync(dpy, 0);
 XDestroyWindow(dpy, w);    
 XCloseDisplay(dpy);
 
 exit(0);   
}


void wait(int usec)
{
 struct timeval before,after;
     
     
 gettimeofday(&before,NULL);
 gettimeofday(&after,NULL);
 while((after.tv_usec+1000000*after.tv_sec)-(before.tv_usec+1000000*before.tv_sec) < usec)
 {
  gettimeofday(&after,NULL);
 }

/* struct timeval timer;
     
 timer.tv_sec= usec / 1000000;
 timer.tv_usec=usec % 1000000;
 (void) select (0, 0, 0, 0, &timer);*/    
}  	
 
 
void usage(void)
{
 printf("\nUsage: xbreaky [<options>]\n\n");
 printf("Options are:\n");
 printf("-nosound            : toggles sound off \n");
 printf("-size <1 2 3 4> [2] : sets window size at <> * original \n");
 printf("-nograb             : pointer is not grabbed but hidden\n");
 printf("-help               : \n");
 printf("-h                  : prints out this message \n\n");
}
 
 	
void initialize_colors(Display *dpy)
{
 int i;
 XColor dummy;
 Colormap colormap;
 int screen;

 screen=DefaultScreen(dpy);
 colormap=DefaultColormap(dpy,screen);
 for (i=0; i<COLORS; i++)
  {
   dummy.red=RGB[i][0];
   dummy.green=RGB[i][1];
   dummy.blue=RGB[i][2];
   XAllocColor(dpy,colormap,&dummy);
   color[i]=dummy.pixel; 
  }
}	


void pause(Beam beam, Bal bal, int score, int balls, int blocks, int level, Display *dpy, Window w, GC gc)
{
 int keycode=0;

 drawtext(274,45,1,"Paused@", dpy, w, gc);
 while(keycode!=33&&keycode!=9) 
 {
  XEvent event;     
  XNextEvent(dpy,&event);
  switch (event.type)
  {
   case KeyRelease:    keycode=event.xkey.keycode; 
                       break;
   case Expose:        if(event.xexpose.count ==0) 
   			{ 	
                       	initscherm(dpy, w, gc);
                      	drawtext(274,45,1,"Paused@", dpy, w, gc);
                       	changemode(bal.mode, beam.mode, dpy, w, gc);
                       	redrawlevel(dpy, w, gc);  
	               	gethighscores(dpy, w, gc);
                       	writestatus(score, balls, blocks, level, dpy, w, gc);
                       	drawbeam(beam, dpy, w, gc); 
                       	putball(bal.x,bal.y, bal.color,dpy, w, gc);
                       	}
			 break;
  }
  wait(8);
 }                       
 drawtext(274,45,1,"Running", dpy, w, gc);
}


void movevalbal(Beam & beam, int & balmode, Display *dpy, Window w, GC gc)
{
 for(int t=0; t<10; t++)
 {
  if(valbal[t].onderweg)
  {
   if(valbal[t].y>=179&&valbal[t].x>=beam.x-4&&valbal[t].x<=beam.x+beam.lengte)
   {
    putball(valbal[t].x, valbal[t].y, 0, dpy, w, gc);
    valbal[t].onderweg=0;
    if(valbal[t].color <= 5)
    {
     beam.mode=valbal[t].color+1;
    }
    else
    {
     balmode=valbal[t].color-5;
    }
   play_sound(0);
   }
   else
   {
    if(isblock(valbal[t].x,valbal[t].y+5)>=9 && valbal[t].y<=160 || 
       isblock(valbal[t].x,valbal[t].y+1)>=9 && valbal[t].y<=160)
    {
     valbal[t].y++;
    }
    else
    {
     putball(valbal[t].x, valbal[t].y, 0, dpy, w, gc);
     valbal[t].y++;
     putvalbal(valbal[t].x, valbal[t].y, valbal[t].color, dpy, w, gc);
     if(isblock(valbal[t].x,valbal[t].y+5)>=9 && valbal[t].y<=160) putball(valbal[t].x, valbal[t].y, 0, dpy, w, gc);
    }
 
   }
   if(valbal[t].y>=194)
   {
    valbal[t].onderweg=0;
    putball(valbal[t].x,valbal[t].y,0, dpy, w, gc);
   }
 
  }
 }
}


void dropvalbal(int x, int y, Display *dpy, Window w, GC gc)
{
 int gevonden=0;

 while(valbal[gevonden].onderweg&&gevonden<=9) gevonden++;
 if(gevonden<=9)
 {
  valbal[gevonden].onderweg=1;
  valbal[gevonden].x=x+1;
  valbal[gevonden].y=y;
  valbal[gevonden].color=(int)(14.0*rand()/(RAND_MAX+1.0));
 }
}


int warp(int &blocks, int &score, Display *dpy, Window w, GC gc)
{
 char tekst[10];

 drawtext(274,53,3,"Warpin@", dpy, w, gc);
 while(blocks)
 {
  score=score+2;
  blocks--;
  sprintf(tekst,"%i", score);              
  strcat(tekst,"@@@");
  tekst[6]=0;
  drawtext(280,145,1,tekst, dpy, w, gc);
  sprintf(tekst,"%i", blocks);
  strcat(tekst,"@@@");
  tekst[6]=0;
  drawtext(280,153,1,tekst, dpy, w, gc);
/*  sound(10000);
   delay(2);
   nosound();
   delay(13);
*/
   wait(20000);
   for(int times=0; times<15; times++) 
   {
    drawblock(5+11*(int)(21.0*rand()/(RAND_MAX+1.0)),4+6*(int)(25.0*rand()/(RAND_MAX+1.0)),0, dpy, w, gc);
   } 
 }

 return bouwlevel(blocks, dpy, w, gc);
}


int bouwlevel(int &blocks, Display *dpy, Window w, GC gc)
{
 int x=0,y=0,level=0;
 char filenaam[100], levels[3], regel[26]="";
 FILE *fp;

 blocks=0;
 for(int p=0; p<28; p++)
for(int t=0; t<22; t++) bk[p][t]=0; 
 clearfield(dpy, w, gc);
 level=(int)((float) numberoflevels*rand()/(RAND_MAX+1.0)); // random maal het aantal levels ..
 sprintf(levels,"%i", level);
 strcpy(filenaam,LEVELS);
 strcat(filenaam,levels);
 strcat(filenaam,".dat");
 blocks=0;
 if((fp=fopen(filenaam,"r")) == NULL) 
 {
 
 // als geen levelfile: ffies snel een leveltje tekenen ..

 for(y=22; y<107; y=y+6) for(x=27; x<210; x=x+11) { int kleur=11+2*(int)(9.0*rand()/(RAND_MAX+1.0));
                                                  drawblock(x,y, kleur, dpy, w, gc); blocks++;
                                                  bk[(y)/6][(x)/11]=kleur;  }
 }

 // level klaar ..
 
 else
 {
 while (fgets(regel, 26, fp))
  {
   for(x=0; x<26; x++)
   {
    if     (regel[x]==35)   drawblock(x*11+5,y*6+4, 0, dpy, w, gc);
    else if(regel[x]==42) { int kleur=11+2*(int)(9.0*rand()/(RAND_MAX+1.0));
                            drawblock(x*11+5,y*6+4, kleur, dpy, w, gc); blocks++; bk[y][x]=kleur; }
    else if(regel[x]=='@'){ drawblock(x*11+5,y*6+4, 9, dpy, w, gc);     blocks++; bk[y][x]=9;     }
   } 
   y++; 
  }
  fclose(fp);
 } 

 return level;
}


void redrawlevel(Display *dpy, Window w, GC gc)
{
 for(int y=0; y<27; y++) for(int x=0; x<21; x++) drawblock(x*11+5,y*6+4, bk[y][x], dpy, w, gc);
}   


void countlevels(void)
{
 FILE *fp;
 char filename[128], number[4];
 
 strcpy(filename,LEVELS);
 sprintf(number, "%i", numberoflevels);
 strcat(filename, number);
 strcat(filename, ".dat");
 while((fp=fopen(filename,"r")) != NULL && numberoflevels<9999)
 {
  fclose(fp);
  numberoflevels++;
  strcpy(filename,LEVELS);
  sprintf(number, "%i", numberoflevels);
  strcat(filename, number);
  strcat(filename, ".dat");
 }
}


void gethighscores(Display *dpy, Window w, GC gc)
{
 FILE *fp;
 char getal[5],filename[128];

 clearnames(dpy, w, gc);
 if ((void *)getenv("HOME") != NULL) 
 {
  strcpy(filename,(char *)getenv("HOME"));
  if (filename[strlen(filename)-1] != '/') strcat(filename,"/");
  strcat(filename,".breakyhighscores");
  if ((fp=fopen(filename,"r")) == NULL)
  {
   drawtext(244,99,1,"No@Scores", dpy, w, gc);
   scorelijst.aantal=0;		
  }
  else
  {
   scorelijst.aantal=fread((char *)scorelijst.rij,sizeof(Item), 3, fp);
   fclose(fp);
   for(int i=0; i<scorelijst.aantal; i++)
   {
    drawtext(244,99+i*8,1,scorelijst.rij[i].naam, dpy, w, gc);
    sprintf(getal, "%i", scorelijst.rij[i].score);
    drawtext(244+12*6-6*strlen(getal),99+i*8,1,getal, dpy, w, gc);
   }
   if(scorelijst.aantal<3)
for(int i=scorelijst.aantal; i<3; i++) 
                            { scorelijst.rij[i].score=0; scorelijst.rij[i].naam[0]=0; }
  } 
 }
}


int gameover(int score, Display *dpy, Window w, GC gc)
{
 int i=3, keycode=0;
 char filename[128];
 FILE *fp;


 clearfield(dpy, w, gc);
 sleep(1);
 drawtext(100,88,1,"Game@Over@", dpy, w, gc);
 sleep(2);
 if(score>scorelijst.rij[0].score)
 {
  scorelijst.rij[2]=scorelijst.rij[1];
  scorelijst.rij[1]=scorelijst.rij[0];
  scorelijst.rij[0].score=score;
  i=0;
  if(scorelijst.aantal<3) scorelijst.aantal++;
 }
 else if(score>scorelijst.rij[1].score)
 {
  scorelijst.rij[2]=scorelijst.rij[1];
  scorelijst.rij[1].score=score;
  i=1;
  if(scorelijst.aantal<3) scorelijst.aantal++;
 }
 else if(score>scorelijst.rij[2].score)
 {
  scorelijst.rij[2].score=score;
  i=2;
  if(scorelijst.aantal<3) scorelijst.aantal++;
 }
 if(i!=3)
 {
  scorelijst.rij[i].naam[0]=0;
  if ((void *)getenv("HOME") != NULL)
  {
   strcpy(filename,(char *)getenv("HOME"));
   if (filename[strlen(filename)-1] != '/') strcat(filename,"/");
   strcat(filename,".breakyhighscores");	
   fp=fopen(filename,"w");
   fwrite((char *)scorelijst.rij,sizeof(Item), scorelijst.aantal, fp);
   fclose(fp);
   usleep(1);
   gethighscores(dpy, w, gc);
   clearfield(dpy, w, gc);
   drawtext(10,104,1,"Enter@your@name@for@the@hall@of@fame@@", dpy, w, gc);
   getstring(scorelijst.rij[i].naam,6,244,99+i*8, dpy, w, gc);
   fp=fopen(filename,"w");
   fwrite((char *)scorelijst.rij,sizeof(Item), scorelijst.aantal, fp);
   fclose(fp);
   usleep(1);
   gethighscores(dpy, w, gc);
  }
 } 
 clearfield(dpy, w, gc);
 drawtext(4,104,1,"Press@n@to@get@back@to@your@boring@life", dpy, w, gc);
 drawtext(44,112,1,"or@y@to@take@another@shot", dpy, w, gc);
 while(keycode!=29&&keycode!=57) 
 {
  XEvent event; 
  XNextEvent(dpy,&event);
  switch (event.type)
  {
   case KeyRelease: keycode=event.xkey.keycode;
  }
 }                       
 clearfield(dpy, w, gc);
 if(keycode==29)
 {
  return 0;
 } 
 return 1;
}


void getstring(char string[], int lengte, int x, int y, Display *dpy, Window w, GC gc)
{
 int i=0, keycode=0;
 char temp[2];

 XSetForeground(dpy, gc, color[0]);
 XFillRectangle(dpy, w, gc, x, y, 12*6, 7);
 XSync(dpy, 0);
 XSelectInput(dpy, w, KeyReleaseMask);
 temp[1]=0;
 do
 {
  XEvent event;      
  XNextEvent(dpy,&event);
  if(event.type == KeyRelease)
   {
    KeySym keysym = XLookupKeysym( &event.xkey, 0 );
    keycode=event.xkey.keycode;
    if(keycode>=24&&keycode<=58&&keycode!=36) 
    {
     strcpy(temp,XKeysymToString(keysym));
     string[i]=temp[0];
     temp[1]=0;
     drawtext(x+6*i,y,1,temp, dpy, w, gc);
    }
    else
    {
     if(keycode == 22)
     {
      if(i>0) i--;
      temp[0]='@';
      drawtext(x+6*i,y,1,temp, dpy, w, gc);
      if(i>=0) i--;
     }
    }
    i++;
   } 
 }
 while(i<lengte&&keycode!=36);
 if(i<lengte) string[i-1]=0;
 else string[i]=0;
 XSelectInput(dpy, w, KeyReleaseMask| ButtonPressMask| PointerMotionMask| ExposureMask);
}


void movekogels(Kogel kogels[10], int &score, int &blocks, Display *dpy, Window w, GC gc)
{
 for(int tt=0; tt<10; tt++)
 {
  if(kogels[tt].onderweg)
  {
   clearkogel(kogels[tt], dpy, w, gc);
   if(kogels[tt].y>2)
   {
    kogels[tt].y--; 
    putkogel(kogels[tt], dpy, w, gc);
   }
   else kogels[tt].onderweg=0;
   if(kogels[tt].y<160)
   {
    if(isblock(kogels[tt].x,kogels[tt].y-1))
    {
     shootblock(kogels[tt].x,kogels[tt].y-4,score,blocks, dpy, w, gc);
     clearkogel(kogels[tt], dpy, w, gc);
    }
    if(isblock(kogels[tt].x+1,kogels[tt].y-1)>=9)
    {
     shootblock(kogels[tt].x+1,kogels[tt].y-4,score,blocks, dpy, w, gc);
     clearkogel(kogels[tt], dpy, w, gc);
    }
   } 
  }
 }
 XSync(dpy, 0);
}


void putkogel(Kogel & kogel, Display *dpy, Window w, GC gc)
{
 XSetForeground(dpy, gc, color[2]);
 XFillRectangle(dpy, w, gc, kogel.x*times, kogel.y*times, 2*times, 2*times); 
 kogel.onderweg=1;
}


void clearkogel(Kogel & kogel, Display *dpy, Window w, GC gc)
{
 XSetForeground(dpy, gc, color[0]);
 XFillRectangle(dpy, w, gc, kogel.x*times, kogel.y*times, 2*times, 2*times); 
 kogel.onderweg=0;
}


void shootblock(int x, int y, int &score, int &blocks, Display *dpy, Window w, GC gc)
{
 int x_temp=((x-5)/11)*11+5, y_temp=((y-4)/6)*6+4, col;

 
 col=bk[(y-4)/6][(x-5)/11];
 int kleur=11+2*(int)(9.0*rand()/(RAND_MAX+1.0));
 if(col >= 11)
 {
  drawblock(x_temp,y_temp, 0, dpy, w, gc);
  bk[(y-4)/6][(x-5)/11]=0;
  score=score+2;
  blocks--; 
 }
}


void shootball(Bal & bal, Beam & beam, int score, int balls, int blocks, int level,  Display *dpy, Window w, GC gc)
{
 int but=0, bye=0;

 bal.r=0;
 bal.color=6;
 drawbeam(beam, dpy, w, gc); 
 beam.lastx=beam.x;
 putball(beam.x+beam.lengte/2-2,179,bal.color, dpy, w, gc);
 if(bal.mode==1)  bal.color=9;
 while(but!=1&&but!=2&&!bye)
  {
   if(XPending(dpy))
   {
    XEvent event;
    XNextEvent(dpy,&event);
    switch (event.type)
    {
     case MotionNotify: { beam.x=event.xmotion.x;  
        	          if(beam.x>239-beam.lengte) beam.x=239-beam.lengte; 
       	                  if(beam.x<2) beam.x=2;
       	                  if(beam.mode==4) beam.x=215-beam.x+2;
       	                  drawbeam(beam, dpy, w, gc); 
       	                  putball(beam.lastx+beam.lengte/2-2,179,0, dpy, w, gc);
       	                  beam.lastx=beam.x;
		          putball(beam.x+beam.lengte/2-2,179,bal.color, dpy, w, gc);
		          XSync(dpy, 0);
		        } break;
     case ButtonPress:    but=event.xbutton.button; break; 
     case KeyRelease:     if(event.xkey.keycode == 9) bye=1; 
     case Expose:         if(event.xexpose.count == 0) 
                          {  
                          initscherm(dpy, w, gc);
                          drawtext(274,45,1,"Running", dpy, w, gc);
                          changemode(bal.mode, beam.mode, dpy, w, gc);
	                  redrawlevel(dpy, w, gc);  
	                  gethighscores(dpy, w, gc);
                          writestatus(score, balls, blocks, level, dpy, w, gc);
                          drawbeam(beam, dpy, w, gc);
                          putball(bal.x,bal.y, bal.color,dpy, w, gc); 
                          }
			   break;
    }
   }
   movevalbal(beam, bal.mode, dpy, w, gc);
   wait(7000);
 }
 bal.lastx=bal.x=beam.x+beam.lengte/2-2;
 bal.lasty=bal.y=179;
 if(but==1) bal.r=0;
 if(but==2 || but==3 || but==4 || but==5) bal.r=1;
}


void drawball(Bal & bal, Beam & beam, int score, int balls, int blocks, int level,  Display *dpy, Window w, GC gc)
{
 int balx_temp, baly_temp;

 balx_temp=bal.x;
 baly_temp=bal.y;
 bal.color=6;
 if(bal.mode==2) 
  { bal.x=bal.x+3-(int)(7.0*rand()/(RAND_MAX+1.0));
    if(bal.x<1) bal.x=1;
    if(bal.x>235) bal.x=235;
  }
 switch(bal.r)
 {
  case 0: bal.x--; bal.y--;              			 // linksboven
          if(bal.x<=1){bal.x=1; bal.r=1;}
	  if(bal.y<=1){bal.y=1; bal.r=2;}
          break;
  case 1: bal.x++; bal.y--;              			 // rechtsboven
	  if(bal.x>=235){ bal.x=235; bal.r=0;}
	  if(bal.y<=1){bal.y=1; bal.r=3;}
          break;
  case 2: bal.x--; bal.y++;              			 // linksonder
	  switch(beam.mode) 
	  {
	   case 1:  if(bal.y>=194){bal.y=194; bal.r=0;}
	   default: if(bal.x<=1){ bal.x=1; bal.r=3; }
			if(bal.y>=179&&bal.x>=beam.x-4&&bal.x<=beam.x+beam.lengte)
			 {bal.y=179; bal.r=0; if(beam.mode==5) 
			                      { putball(balx_temp,baly_temp,0, dpy, w, gc); 
			                        shootball(bal,beam,score, balls, blocks, level,dpy, w, gc);}}}
	   break;
	  		 
  case 3: bal.x++; bal.y++;              			 // rechtsonder
          switch(beam.mode) 
          {
	   case 1:  if(bal.y>=194){bal.y=194; bal.r=1;}
	   default: if(bal.x>=235){ bal.x=235; bal.r=2; }
			if(bal.y>=179&&bal.x>=beam.x-4&&bal.x<=beam.x+beam.lengte)
			 {bal.y=179; bal.r=1; if(beam.mode==5) 
			                       { putball(balx_temp,baly_temp,0, dpy, w, gc); 
			                         shootball(bal,beam,score, balls, blocks, level,dpy, w, gc);}}}
 }
 if(bal.mode==1) bal.color=9;
 putball(balx_temp, baly_temp, 0, dpy, w, gc);
 putball(bal.x, bal.y,bal.color, dpy, w, gc);
}


void check4bots(Bal & bal, Beam & beam, int &score, int &blocks, Display *dpy, Window w, GC gc)
{
 int x=bal.x, y=bal.y, b_onder=0, b_boven=0, b_links=0, b_rechts=0, b_londer=0, b_ronder=0, b_rboven=0, b_lboven=0;

 if(y<160){
 if(isblock(x-1,y+2)>=9)                			 // check 4 blok links
  { b_links=1; blockhit(x-1,y+2,score,blocks,bal.mode, beam.mode, dpy, w, gc); }
 if(isblock(x+6,y+2)>=9)            			 // check 4 blok rechts
  { b_rechts=1; blockhit(x+6,y+2,score,blocks,bal.mode, beam.mode, dpy, w, gc);}
 if(isblock(x+2,y-1)>=9)                			 // check 4 blok boven
  { b_boven=1; blockhit(x+2,y-1,score,blocks,bal.mode, beam.mode, dpy, w, gc);}
 if(isblock(x+2,y+6)>=9)                			 // check 4 blok onder
  { b_onder=1; blockhit(x+2,y+6,score,blocks,bal.mode, beam.mode, dpy, w, gc);}
 if(isblock(x-1,y-1)>=9)                			 // check 4 blok links boven
  { b_lboven=1;}
 if(isblock(x+6,y-1)>=9)                			 // check 4 blok rechts boven
  { b_rboven=1;}
 if(isblock(x-1,y+6)>=9)          			         // check 4 blok links onder
  { b_londer=1; }
 if(isblock(x+1,y+6)>=9)                			 // check 4 blok rechts onder
  { b_ronder=1;}
 switch(bal.r)
 {
  case 0: if(bal.mode!=1){
          if(b_boven) bal.r=2;      			 // balrichting linksboven
          if(b_links) bal.r=1;
          if(b_boven&&b_links) bal.r=3; }
          if(!b_boven&&!b_links&&b_lboven)
           { if(bal.mode!=1) bal.r=3; blockhit(x-1,y-1,score,blocks,bal.mode, beam.mode, dpy, w, gc);}
	  break;
  case 1: if(bal.mode!=1) {
	  if(b_boven) bal.r=3;      			 // balrichting rechtsboven
	  if(b_rechts) bal.r=0;
	  if(b_boven&&b_rechts) bal.r=2; }
 	  if(!b_boven&&!b_rechts&&b_rboven)
	    { if(bal.mode!=1) bal.r=2; blockhit(x+6,y-1,score,blocks,bal.mode, beam.mode, dpy, w, gc);}
	  break;
  case 2: if(bal.mode!=1) {
          if(b_onder) bal.r=0;      			 // balrichting linksonder
	  if(b_links) bal.r=3;
	  if(b_links&&b_onder) bal.r=1; }
	  if(!b_links&&!b_onder&&b_londer)
	   { if(bal.mode!=1) bal.r=1; blockhit(x-1,y+6,score,blocks,bal.mode, beam.mode, dpy, w, gc);}
	  break;
 case 3:  if(bal.mode!=1) {
	  if(b_onder) bal.r=1;      			 // balrichting rechtsonder
	  if(b_rechts) bal.r=2;
	  if(b_rechts&&b_onder) bal.r=0; }
	  if(!b_rechts&&!b_onder&&b_ronder)
	   { if(bal.mode!=1) bal.r=0; blockhit(x+1,y+6,score,blocks,bal.mode, beam.mode, dpy, w, gc);}
 }}
}


int isblock(int x, int y)
{
 int x_temp=(x-5)/11, y_temp=(y-4)/6;
 
 return (int)bk[(y_temp)][(x_temp)];
}


void blockhit(int x, int y, int &score, int &blocks, int &balmode, int &beammode, Display *dpy, Window w, GC gc)
{
 int x_temp=((x-5)/11)*11+5, y_temp=((y-4)/6)*6+4, col;

 
 col=bk[(y-4)/6][(x-5)/11];
 int kleur=11+2*(int)(9.0*rand()/(RAND_MAX+1.0));
 if(col==9)
 {
  drawblock(x_temp,y_temp, kleur, dpy, w, gc);
  bk[(y-4)/6][(x-5)/11]=kleur; 
 }
 else
 { 
  drawblock(x_temp,y_temp,0, dpy, w, gc);
  bk[(y-4)/6][(x-5)/11]=0;
  if(col==kleur) dropvalbal(x_temp,y_temp, dpy, w, gc);
  blocks--;
 }
 if(balmode==5) score=score+4;
 else score=score+2;
/* sound(1000);
   delay(8);
   nosound();*/
}


void changemode(int balmode, int beammode, Display *dpy, Window w, GC gc)
{
 if(beammode==0) { drawtext(274,61,1,"Normal@", dpy, w, gc); }
 if(beammode==1) { XSetForeground(dpy, gc, color[1]); XFillRectangle(dpy, w, gc, 4*times ,199*times,232*times,times);
                   drawtext(274,61,4,"Dummy@@", dpy, w, gc); }
 else            { XSetForeground(dpy, gc, color[0]);  XFillRectangle(dpy, w, gc,4*times,199*times,232*times,times);
} 
               
 if(beammode==2) { drawtext(274,61,3,"Tall@@@", dpy, w, gc); }
 if(beammode==3) { drawtext(274,61,5,"Small@@", dpy, w, gc); }
 if(beammode==4) { drawtext(274,61,5,"Crazy@@", dpy, w, gc); }
 if(beammode==5) { drawtext(274,61,4,"Sticky@", dpy, w, gc); }
 if(beammode==6) { drawtext(274,61,3,"Shootin", dpy, w, gc); }

 if(balmode==0) drawtext(274,53,1,"Normal@", dpy, w, gc);
 if(balmode==1) drawtext(274,53,3,"Solid@@", dpy, w, gc);
 if(balmode==2) drawtext(274,53,4,"Shaky@@", dpy, w, gc);
 if(balmode==3) drawtext(274,53,4,"Slow@@@", dpy, w, gc);
 if(balmode==4) drawtext(274,53,5,"Fast@@@", dpy, w, gc);
 if(balmode==5) drawtext(274,53,3,"ScoreX2", dpy, w, gc);
 if(balmode==6) drawtext(274,53,3,"XtraBal", dpy, w, gc);
 if(balmode==7) drawtext(274,53,5,"Balls-1", dpy, w, gc);
}


void writestatus(int score, int balls, int blocks, int level, Display *dpy, Window w, GC gc)
{
 char string[10]="";
 int col=1;

 sprintf(string,"%i",level);
 strcat(string,"@@@");
 drawtext(280,137, col, string, dpy, w, gc);
 sprintf(string,"%i",score);                 // int omzetten naar string ..
 strcat(string,"@@@");
 string[6]=0;
 drawtext(280,145, col, string, dpy, w, gc);
 sprintf(string,"%i",blocks);
 strcat(string,"@@@");
 drawtext(280,153, col, string, dpy, w, gc);
 sprintf(string,"%i",balls);
 strcat(string,"@@@");
 drawtext(280,161, col, string, dpy, w, gc);
}


void clearfield(Display *dpy, Window w, GC gc)
{
 XSetForeground(dpy, gc, color[0]);
 XFillRectangle(dpy, w, gc, 1*times, 1*times, 238*times, 183*times);
 XSync(dpy, 0);
}


void clearnames(Display *dpy, Window w, GC gc)
{
 XSetForeground(dpy, gc, color[0]);
 XFillRectangle(dpy, w, gc, 244*times, 99*times, 74*times, 18*times);
 XSync(dpy, 0);
}


void drawbeam(Beam beam, Display *dpy, Window w, GC gc)
{
 XSetForeground(dpy, gc, color[8]);
 XFillRectangle(dpy, w, gc, beam.x*times, 185*times, beam.lengte*times, 4*times);
 XSetForeground(dpy, gc, color[0]);
 XFillRectangle(dpy, w, gc, 1*times, 185*times, (beam.x-1)*times, 4*times);
 XFillRectangle(dpy, w, gc, (beam.x+beam.lengte)*times, 185*times, (239-(beam.x+beam.lengte))*times, 4*times);
 if(beam.mode==5) 	
 {	
  XSetForeground(dpy, gc, color[10]);
  XFillRectangle(dpy, w, gc, beam.x*times, 185*times, beam.lengte*times, times);
 }
 else if(beam.mode==6) 
 {
  XSetForeground(dpy, gc, color[3]);	
  XFillRectangle(dpy, w, gc, beam.x*times, 185*times, beam.lengte*times, times);
 }
 XSync(dpy, 0);
}


void drawblock(int x, int y, int colfor, Display *dpy, Window w, GC gc)
{
 if(colfor>0)
 {
  XSetForeground(dpy, gc, color[colfor+1]);
  XFillRectangle(dpy, w, gc, x*times, y*times, 10*times, 5*times);
  XSetForeground(dpy, gc, color[colfor]);
  XFillRectangle(dpy, w, gc, (x+1)*times, (y+1)*times, 8*times, 3*times);
 }
 else
 { 
  XSetForeground(dpy, gc, color[colfor]);
  XFillRectangle(dpy, w, gc, x*times, y*times, 10*times, 5*times);
 }
 XSync(dpy, 0);
}


void putball(int x, int y, int col, Display *dpy, Window w, GC gc)
{
 if(col > 0)
 {
   XSetForeground(dpy, gc, color[col+1]);
   XFillRectangle(dpy, w, gc, (x+1)*times, y*times, 3*times, times);
   XFillRectangle(dpy, w, gc, x*times, (y+1)*times, 5*times, times);
   XFillRectangle(dpy, w, gc, x*times, (y+2)*times, 5*times, times);
   XFillRectangle(dpy, w, gc, x*times, (y+3)*times, 5*times, times);
   XFillRectangle(dpy, w, gc, (x+1)*times, (y+4)*times, 3*times, times);
   XSetForeground(dpy, gc, color[col]);
   XFillRectangle(dpy, w, gc, (x+1)*times, (y+1)*times, 3*times, 3*times);
 } 
 else
 {
   XSetForeground(dpy, gc, color[col]);
   XFillRectangle(dpy, w, gc, (x+1)*times, y*times, 3*times, times);
   XFillRectangle(dpy, w, gc, x*times, (y+1)*times, 5*times, times);
   XFillRectangle(dpy, w, gc, x*times, (y+2)*times, 5*times, times);
   XFillRectangle(dpy, w, gc, x*times, (y+3)*times, 5*times, times);
   XFillRectangle(dpy, w, gc, (x+1)*times, (y+4)*times, 3*times, times);
 }
 XSync(dpy, 0);
}


void putvalbal(int x, int y, int col, Display *dpy, Window w, GC gc)
{
 int mid;
 switch(col)
 {
	case 0: mid=31;break;
	case 1: mid=29;break;
	case 2: mid=33;break;
	case 3: mid=33;break;
	case 4: mid=31;break;
	case 5: mid=29;break;
	case 6: mid=29;break;
	case 7: mid=31;break;
	case 8: mid=31;break;
	case 9: mid=33;break;
	case 10:mid=29;break;
	case 11:mid=29;break;
	case 12:mid=33;break;
	case 13:mid=29;break;
 }
 XSetForeground(dpy, gc, color[mid+1]);
 XFillRectangle(dpy, w, gc, (x+1)*times, y*times, 3*times, times);
 XFillRectangle(dpy, w, gc, x*times, (y+1)*times, 5*times, times);
 XFillRectangle(dpy, w, gc, x*times, (y+2)*times, 5*times, times);
 XFillRectangle(dpy, w, gc, x*times, (y+3)*times, 5*times, times);
 XFillRectangle(dpy, w, gc, (x+1)*times, (y+4)*times, 3*times, times);
 XSetForeground(dpy, gc, color[mid]);
 XFillRectangle(dpy, w, gc, (x+1)*times, (y+1)*times, 3*times, 3*times);
 XSync(dpy, 0);
}


void initscherm(Display *dpy, Window w, GC gc)
{
 int colorr=1;
 
 XSetForeground(dpy, gc, color[colorr]);
 XFillRectangle(dpy, w, gc,0,0,319*times,times);
 XFillRectangle(dpy, w, gc,0,199*times,4*times,times);
 XFillRectangle(dpy, w, gc,236*times,199*times,87*times,times);
 XFillRectangle(dpy, w, gc,0,0,1*times,200*times);
 XFillRectangle(dpy, w, gc,319*times,0,times,200*times);
 XFillRectangle(dpy, w, gc,240*times,0,times,199*times);
 drawtext(244,8,colorr, "**@Breaky@**", dpy, w, gc);
 drawtext(244,24,colorr,"@Ver:@0.0.5@", dpy, w, gc);
 drawtext(244,83,colorr,"Highscores:", dpy, w, gc);
 drawtext(244,45,colorr,"Game:", dpy, w, gc);
 drawtext(244,53,colorr,"Ball:", dpy, w, gc);
 drawtext(244,61,colorr,"Beam:", dpy, w, gc);
 drawtext(244,137,colorr,"Level:", dpy, w, gc);
 drawtext(244,145,colorr,"Score:", dpy, w, gc);
 drawtext(244,153,colorr,"Bloks:", dpy, w, gc);
 drawtext(244,161,colorr,"Balls:", dpy, w, gc);
 drawtext(251,179,colorr,"Coded@by:", dpy, w, gc);
 drawtext(245,187,colorr,"*Dave@Brul*", dpy, w, gc);
 XSync(dpy, 0);
}


void drawtext(int x, int y, int col, char string[], Display *dpy, Window w, GC gc)
{
 x=x*times;
 y=y*times;
 for(int i=0; i<strlen(string); i++) 
      {
        XSetForeground(dpy, gc, color[col*font[string[i]-42][0][0]]); 
	XFillRectangle(dpy, w, gc,x+0+6*i*times,y+0*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][0][1]]);
	XFillRectangle(dpy, w, gc,x+1*times+6*i*times,y+0*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][0][2]]);
	XFillRectangle(dpy, w, gc,x+2*times+6*i*times,y+0*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][0][3]]);
	XFillRectangle(dpy, w, gc,x+3*times+6*i*times,y+0*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][0][4]]);
	XFillRectangle(dpy, w, gc,x+4*times+6*i*times,y+0*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][1][0]]);
	XFillRectangle(dpy, w, gc,x+0+6*i*times,y+1*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][1][1]]);
	XFillRectangle(dpy, w, gc,x+1*times+6*i*times,y+1*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][1][2]]);
	XFillRectangle(dpy, w, gc,x+2*times+6*i*times,y+1*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][1][3]]);
	XFillRectangle(dpy, w, gc,x+3*times+6*i*times,y+1*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][1][4]]);
	XFillRectangle(dpy, w, gc,x+4*times+6*i*times,y+1*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][2][0]]);
	XFillRectangle(dpy, w, gc,x+0+6*i*times,y+2*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][2][1]]);
	XFillRectangle(dpy, w, gc,x+1*times+6*i*times,y+2*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][2][2]]);
	XFillRectangle(dpy, w, gc,x+2*times+6*i*times,y+2*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][2][3]]);
	XFillRectangle(dpy, w, gc,x+3*times+6*i*times,y+2*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][2][4]]);
	XFillRectangle(dpy, w, gc,x+4*times+6*i*times,y+2*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][3][0]]);
	XFillRectangle(dpy, w, gc,x+0+6*i*times,y+3*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][3][1]]);
	XFillRectangle(dpy, w, gc,x+1*times+6*i*times,y+3*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][3][2]]);
	XFillRectangle(dpy, w, gc,x+2*times+6*i*times,y+3*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][3][3]]);
	XFillRectangle(dpy, w, gc,x+3*times+6*i*times,y+3*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][3][4]]);
	XFillRectangle(dpy, w, gc,x+4*times+6*i*times,y+3*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][4][0]]);
	XFillRectangle(dpy, w, gc,x+0+6*i*times,y+4*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][4][1]]);
	XFillRectangle(dpy, w, gc,x+1*times+6*i*times,y+4*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][4][2]]);
	XFillRectangle(dpy, w, gc,x+2*times+6*i*times,y+4*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][4][3]]);
	XFillRectangle(dpy, w, gc,x+3*times+6*i*times,y+4*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][4][4]]);
	XFillRectangle(dpy, w, gc,x+4*times+6*i*times,y+4*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][5][0]]);
	XFillRectangle(dpy, w, gc,x+0+6*i*times,y+5*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][5][1]]);
	XFillRectangle(dpy, w, gc,x+1*times+6*i*times,y+5*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][5][2]]);
	XFillRectangle(dpy, w, gc,x+2*times+6*i*times,y+5*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][5][3]]);
	XFillRectangle(dpy, w, gc,x+3*times+6*i*times,y+5*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][5][4]]);
	XFillRectangle(dpy, w, gc,x+4*times+6*i*times,y+5*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][6][0]]);
	XFillRectangle(dpy, w, gc,x+0+6*i*times,y+6*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][6][1]]);
	XFillRectangle(dpy, w, gc,x+1*times+6*i*times,y+6*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][6][2]]);
	XFillRectangle(dpy, w, gc,x+2*times+6*i*times,y+6*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][6][3]]);
	XFillRectangle(dpy, w, gc,x+3*times+6*i*times,y+6*times,times, times);
	XSetForeground(dpy, gc, color[col*font[string[i]-42][6][4]]);
	XFillRectangle(dpy, w, gc,x+4*times+6*i*times,y+6*times,times, times); 
       }
 XSync(dpy, 0);       
}

void init_sound(void)
{ 
 int  child,fd[2];
  
 signal(SIGCHLD, SIG_IGN);
 pipe(fd);
 soundfd=fd[1];
 if( !(child=fork()) )  
 {
  close(fd[1]);
  dup2(fd[0],STDIN_FILENO);
  close(fd[0]);
  execlp("xbreaky.snd", 0 );
  fprintf (stderr, "Couldn't Execute Sound Server xbreaky.snd!\n");
  exit (0);
 }
 close(fd[0]);
 sleep(1);
 if (kill(child, 0))  
 {
  audio_ok = 0;  
  close(soundfd);
  fprintf(stderr, "Some errors sound server didn't start up ..\n");
 }
} 


void play_sound (int k)
{
  char c;

  c = k;
  if (audio_ok) 
  {
   write (soundfd, &c, sizeof (c));
  } 
}



