/* quillOp.c for xpaint copyright 1997-1998 Rick Hohensee humbubba@cqi.com */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include "xpaint.h"
#include "Paint.h"
#include "misc.h"
#include "ops.h"

static int nib=2, nibsize=8;


short
nibs[7][32][2]= 
		/* 90, vertical line */
		{{{0,0}, {0,-1},{0,-1},{0,-1},{0,-1},{0,-1},{0,-1},{0,-1},
		  {0,-1},{0,-1},{0,-1},{0,-1},{0,-1},{0,-1},{0,-1},{0,-1},
                  {0,-1}, {0,-1},{0,-1},{0,-1},{0,-1},{0,-1},{0,-1},{0,-1},
                  {0,-1},{0,-1},{0,-1},{0,-1},{0,-1},{0,-1},{0,-1},{0,-1}},                  

		/* 60 degrees */
		{{0,0},{0,-1},{1,-1},{0,-1},{0,-1},{1,0},{0,-1},{1,-1},
		 {0,-1},{1,-1},{0,-1},{1,-1},{0,-1},{1,-1},{0,-1},{1,-1},
                 {1,-1},{0,-1},{1,-1},{0,-1},{0,-1},{1,0},{0,-1},{1,-1},
		 {0,-1},{1,-1},{0,-1},{1,-1},{0,-1},{1,-1},{0,-1}, {1,-1}},             

		/* 45 */
		{{0,0},{1,-1},{1,-1},{1,-1},{1,-1},{1,-1},{1,-1},{1,-1},
		 {1,-1},{1,-1},{1,-1},{1,-1},{1,-1},{1,-1},{1,-1},{1,-1},
                 {1,-1},{1,-1},{1,-1},{1,-1},{1,-1},{1,-1},{1,-1},{1,-1},
                 {1,-1},{1,-1},{1,-1},{1,-1},{1,-1},{1,-1},{1,-1},{1,-1}},              

		/* 30 */
		{{0,0},{1,0},{1,-1},{1,0},{1,-1},{1,0},{1,-1},{1,0},                           
		 {1,0},{1,-1},{1,0},{1,-1},{1,0},{1,-1},{1,0},{1,-1},
                 {1,0},{1,0},{1,-1},{1,0},{1,-1},{1,0},{1,-1},{1,0},
                 {1,0},{1,-1},{1,0},{1,-1},{1,0},{1,-1},{1,0},{1,-1}},
                                                                                      
		/* horizontal */
		{{0,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},
		 {1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},                     
                 {1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},
                 {1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},

                 /* 135 */
                {{0,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},
                 {1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},
                 {1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},
                 {1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1}},
                                                 
		 /* skippy */
                {{0,0},{0,-1},{2,-3},{0,-1},{0,-1},{1,0},{0,-3},{1,-1},
                 {0,-1},{1,-1},{0,-1},{1,-1},{0,-1},{2,-3},{0,-1},{1,-1},
                 {1,-1},{0,-1},{1,-1},{0,-1},{0,-1},{1,0},{0,-1},{1,-1},
                 {0,-1},{1,-1},{0,-1},{2,-4},{0,-1},{1,-1},{0,-1}, {1,-1}}};
                                   

typedef struct {
    int nib;
    int nibSize; /* must be passed between press and motion */
    Pixmap pixmap;
    int mx, my;
    int bx, by;
    GC gc;
    int startX, startY; /* for undo */
} LocalInfo;


static void 
press(Widget w, LocalInfo * l, XButtonEvent * event, OpInfo * info)
{
    XRectangle undo;   

    if (info->surface == opWindow)
	return;

    if ((event->state & AllButtonsMask) != 0)
	return;

    if (event->button==Button2)
          l->gc=info->second_gc;
      else l->gc= info->first_gc;


    l->startX = event->x;
    l->startY = event->y;

    undo.x = event->x;
    undo.y = event->y;
    undo.width = nibsize;
    undo.height = nibsize;
                                 

    	l->nibSize=nibsize/2;
	l->nib=nib-1;
           /* ## fix factors. Sloppy. */

	l->mx = (int)event->x<<8;           /* scale up on the way in ...........*/
    	l->my = (int)event->y<<8;
	l->bx = (int)event->x<<8;
	l->by = (int)event->y<<8;



    nibs[l->nib][0][0]=event->x;
    nibs[l->nib][0][1]=event->y;                  

    UndoStartPoint(w, info, event->x, event->y);                   
XSetFunction(XtDisplay(w), l->gc, gcFunction);  
    XDrawPoints(XtDisplay(w), info->drawable,\
            l->gc,&nibs[l->nib][0][0],l->nibSize,CoordModePrevious);
    if (!info->isFat)
	XDrawPoints(XtDisplay(w), XtWindow(w),\
	    l->gc,&nibs[l->nib][0][0],l->nibSize,CoordModePrevious);

     PwUpdate(w, &undo, False);  
}



/***************************************************************************************/
static void 
motion(Widget w, LocalInfo * l, XMotionEvent * event, OpInfo * info)
/* this function happens when press is true on every motion event */

{
	XRectangle undo;          

	int dxf, dxb, dyb, dxfi,  dxbi, dybi, dyfi;
	int dyf;
	int i, cdxb, cdxf, cdyf, cdyb, lpx, lpy;
	int newpixel, power;
        int xplusy, loopsteps;
        int fx, fy, xi, yi, apex, j;

        fx=(int)event->x << 8;   /* scale and SIZE it up coming in...... */  
        fy=(int)event->y << 8;

	dxb=l->mx - l->bx; 
	dyb=l->my - l->by;
	dxf=fx - l->mx;
	dyf=fy - l->my;

    	if (info->surface == opWindow)
		return;

  	xplusy = abs(fx - l->mx)  + abs(fy - l->my) ;
        lpx=l->mx;     /* the growth end of our curve, the accumulators */
        lpy=l->my;
       	cdxb=0;
	cdxf=0;
	cdyb=0;
	cdyf=0;
	loopsteps=xplusy / 253;
	for(j=0;j<10;j++){
		power=1<<j;
		if(power>loopsteps)
			break;		
	                 }
	loopsteps=power;
	apex=loopsteps/2;
	for (i=0;i<loopsteps;i++){  
/*x*/
               	dxbi=((dxb<<1)-(((dxb<<2)*i)>>j))>>j;
                cdxb=cdxb+dxbi;

                dxfi=(((dxf<<1)*i)>>j)>>j;
                cdxf=cdxf+dxfi;
                xi=cdxf    +cdxb  +l->mx;
/*y*/
                dybi=((dyb<<1)-(((dyb<<2)*i)>>j))>>j;
                cdyb=cdyb+dybi;

                dyfi=(((dyf<<1)*i)>>j)>>j;
                cdyf=cdyf+dyfi;
                yi=cdyf   +cdyb  +l->my;

/* apex */      if(i==apex){
		 	l->bx=xi;
			l->by=yi;
			   }
               	newpixel=0;
/*new pixel?*/  if(lpx>>8 != xi>>8){
                       	lpx=xi;
                        newpixel=1;
                                   }
                if(lpy>>8 != yi>>8){
                        lpy=yi;
                        newpixel=1;
                                   }
		
		if(newpixel) 	
			nibs[l->nib][0][0]=xi>>8;
		nibs[l->nib][0][1]=yi>>8;
	        XDrawPoints(XtDisplay(w), info->drawable, l->gc,\
				&nibs[l->nib][0][0],l->nibSize,CoordModePrevious); 
        	if (!info->isFat) 
                		XDrawPoints(XtDisplay(w), XtWindow(w),\
				l->gc,&nibs[l->nib][0][0],l->nibSize,CoordModePrevious);
 
			         } /* ## end of loop */
   
    XDrawPoints(XtDisplay(w), info->drawable, l->gc, &nibs[l->nib][0][0],l->nibSize,\
                      CoordModePrevious);
    if (!info->isFat)
		XDrawPoints(XtDisplay(w), XtWindow(w),\
			l->gc,&nibs[l->nib][0][0],l->nibSize,CoordModePrevious);

    /* current is now previous */
    l->mx = fx;
    l->my = fy;

    UndoGrow(w, event->x, event->y);

    undo.x = MIN(l->startX, event->x);
    undo.y = MIN(l->startY, event->y);
    undo.width = MAX(l->startX, event->x) - undo.x + 1;
    undo.height = MAX(l->startY, event->y) - undo.y + 1;

    l->startX = event->x;
    l->startY = event->y;
                                         

    PwUpdate(w, &undo, False);      

} /* ## end of motion */


static void 

release(Widget w, LocalInfo * l, XButtonEvent * event, OpInfo * info)
{
    int mask;
    /*
    **  Check to make sure all buttons are up, before doing this
     */
    mask = AllButtonsMask;
    switch (event->button) {
    case Button1:
	mask ^= Button1Mask;
	break;
    case Button2:
	mask ^= Button2Mask;
	break;
    case Button3:
	mask ^= Button3Mask;
	break;
    case Button4:
	mask ^= Button4Mask;
	break;
    case Button5:
	mask ^= Button5Mask;
	break;
    }
    if ((event->state & mask) != 0)
	return;
}



/*
**  Those public functions
 */

void
setNib(int c)
{
nib=c;
}

void 
setNibsize(int c)
{
nibsize=c*2;
}

void *
QuillAdd(Widget w)
{
    LocalInfo *l = (LocalInfo *) XtMalloc(sizeof(LocalInfo));

    XtVaSetValues(w, XtNcompress, False, NULL);

    OpAddEventHandler(w, opPixmap, ButtonPressMask, FALSE,
		      (OpEventProc) press, l);
    OpAddEventHandler(w, opPixmap, ButtonMotionMask, FALSE,
		      (OpEventProc) motion, l);
    OpAddEventHandler(w, opPixmap, ButtonReleaseMask, FALSE,
		      (OpEventProc) release, l);

    SetCrossHairCursor(w);
    printf("quill tool selected\n");
    return l;
}


void 
QuillRemove(Widget w, void *l)
{
    OpRemoveEventHandler(w, opPixmap, ButtonPressMask, FALSE,
			 (OpEventProc) press, l);
    OpRemoveEventHandler(w, opPixmap, ButtonMotionMask, FALSE,
			 (OpEventProc) motion, l);
    OpRemoveEventHandler(w, opPixmap, ButtonReleaseMask, FALSE,
			 (OpEventProc) release, l);
    XtFree((XtPointer) l);
}
