

/*
 *  Author: Arvin Schnell
 */


#include <stdlib.h>
#include <string.h>

#include <X11/Xlib.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/PushB.h>
#include <Xm/Text.h>

#include "Sample.h"
#include "main.h"
#include "control.h"
#include "config.h"


String help_txt[] = {
#include "help.txt.h"
    0
};

Widget help_w;


void
help_create ()
{
    Arg args[10];
    int n;

    Widget close_w, text_w;

    // form

    n = 0;
    XtSetArg (args[n], XtNiconPixmap, a_iconpixmap); n++;
    XtSetArg (args[n], XtNiconMask, a_iconmask); n++;
    help_w = XmCreateFormDialog (toplevel, "Help", args, n);

    // button: close

    n = 0;
    XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNbottomOffset, 10); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
    XtSetArg (args[n], XmNleftPosition, 40); n++;
    XtSetArg (args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg (args[n], XmNrightPosition, 60); n++;
    close_w = XmCreatePushButton (help_w, "Close", args, n);
    XtManageChild (close_w);

    // scrolled text: text

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
    XtSetArg (args[n], XmNbottomWidget, close_w); n++;
    XtSetArg (args[n], XmNbottomOffset, 10); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
    XtSetArg (args[n], XmNeditable, False); n++;
    XtSetArg (args[n], XmNcursorPositionVisible, False); n++;
    text_w = XmCreateScrolledText (help_w, "HelpText", args, n);
    XtManageChild (text_w);

    int pos = 0;
    for (int i = 0; help_txt[i] != 0; i++) {
	XmTextReplace (text_w, pos, pos, help_txt[i]);
	pos += strlen (help_txt[i]);
	XmTextReplace (text_w, pos, pos, "\n");
	pos += 1;
    }

    XmTextShowPosition (text_w, (XmTextPosition) 0);
}


void
help_manage ()
{
    if (!help_w)
	help_create ();

    if (!XtIsManaged (help_w))
	XtManageChild (help_w);
    else
	XMapRaised (XtDisplay (help_w), XtWindow (XtParent (help_w)));
}
