/*
 * The Apache Software License, Version 1.1
 *
 *
 * Copyright (c) 2000 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Xalan" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation and was
 * originally based on software copyright (c) 1999, Lotus
 * Development Corporation., http://www.lotus.com.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.xalan.xslt.extensions;

import org.w3c.dom.*;
import org.apache.xalan.xslt.ResultTreeFrag;
import org.apache.xalan.xpath.MutableNodeListImpl;

/**
 * <meta name="usage" content="general"/>
 * This class is an extension implementing implements the node-set 
 * function found in xt and saxon as a Xalan extension.
 * The inner class "fools" Xalan into thinking that a result tree 
 * fragment is actually a Document root. 
 * PR:DMAN4M6N29 Submitted by:<garyp@firstech.com>
 */
public class Nodeset 
{
  private static class RootNode implements DocumentFragment 
  {
    private DocumentFragment actualFrag;
    private RootNode(DocumentFragment actualFragP) {
      this.actualFrag = actualFragP;
    }
    public Node appendChild(Node newChild) throws DOMException {
      return this.actualFrag.appendChild(newChild);
    }
    public Node cloneNode(boolean deep) {
      return this.actualFrag.cloneNode(deep);
    }
    public boolean hasAttributes() {
      // attribution: patch submited by rubys@us.ibm.com
      // long term correct fix:
      //   return this.actualFrag.hasAttributes();
      // version that works with Xerces 1.1.2 and prior:
      return (this.actualFrag.getAttributes().getLength() != 0);
    }
    public NamedNodeMap getAttributes() {
      return this.actualFrag.getAttributes();
    }
    public NodeList getChildNodes() {
      return this.actualFrag.getChildNodes();
    }
    public Node getFirstChild() {
      return this.actualFrag.getFirstChild();
    }
    public Node getLastChild() {
      return this.actualFrag.getLastChild();
    }
    public String getLocalName() {
      return this.actualFrag.getLocalName();
    }
    public String getNamespaceURI() {
      return this.actualFrag.getNamespaceURI();
    }
    public Node getNextSibling() {
      return this.actualFrag.getNextSibling();
    }
    public String getNodeName() {
      return "#document";
    }
    public short getNodeType() {
     return Node.DOCUMENT_NODE;
    }
    public String getNodeValue() throws DOMException {
     return null;
    }
    public Document getOwnerDocument() {
     return null;
    }
    public Node getParentNode() {
      return this.actualFrag.getParentNode();
    }
    public String getPrefix() {
      return this.actualFrag.getPrefix();
    }
    public Node getPreviousSibling() {
      return this.actualFrag.getPreviousSibling();
    }
    public boolean hasChildNodes() {
      return this.actualFrag.hasChildNodes();
    }
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
      return this.actualFrag.insertBefore(newChild, refChild);
    }
    public void normalize() {
      this.actualFrag.normalize();
    }
    public Node removeChild(Node oldChild) throws DOMException {
      return this.actualFrag.removeChild(oldChild);
    }
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
      return this.actualFrag.replaceChild(newChild, oldChild);
    }
    public void setNodeValue(String nodeValue) throws DOMException {
      this.actualFrag.setNodeValue(nodeValue);
    }
    public void setPrefix(String prefix) throws DOMException {
      this.actualFrag.setPrefix(prefix);
    }
    public boolean supports(String feature, String version) {
      return this.actualFrag.supports(feature, version);
    }
  }

  public NodeList nodeset(Node rtf) {

    DocumentFragment cloneFrag;
    DocumentFragment retFrag;
    NodeList fragElementList;
    int i;

    if (rtf instanceof DocumentFragment) {
      cloneFrag = (DocumentFragment) rtf.cloneNode(true);
      fragElementList = cloneFrag.getChildNodes();
      retFrag = cloneFrag.getOwnerDocument().createDocumentFragment();
      // Note that retFrag.appendChild(cloneFrag) doesn't work because
      // cloneFrag is actually a ResultTreeFrag which doesn't properly implement
      // getNextSibling() in its children.
      for (i = 0; i < fragElementList.getLength(); i++)
        retFrag.appendChild(fragElementList.item(i));
    }
    else {
      retFrag = rtf.getOwnerDocument().createDocumentFragment();
      retFrag.appendChild(rtf.cloneNode(true));
    }

    return new MutableNodeListImpl(new RootNode(retFrag));
  }                    
}
