/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class Chmod
extends MatchingTask {
    private File srcFile;
    private File srcDir;
    private String mod;

    private void chmod(String file) throws BuildException, IOException {
        Runtime.getRuntime().exec("chmod " + this.mod + " " + file);
    }

    public void execute() throws BuildException {
        try {
            if (System.getProperty("path.separator").equals(":") && !System.getProperty("os.name").startsWith("Mac")) {
                if (this.srcFile != null && this.srcDir == null) {
                    this.chmod(this.srcFile.toString());
                } else {
                    if (this.srcFile == null && this.srcDir == null) {
                        this.log("The attribute 'file' or 'dir' needs to be set.", 1);
                        throw new BuildException("Required attribute not set in Chmod", this.location);
                    }
                    if (this.srcFile == null && this.srcDir != null) {
                        DirectoryScanner ds = this.getDirectoryScanner(this.srcDir);
                        String[] files = ds.getIncludedFiles();
                        int i = 0;
                        while (i < files.length) {
                            this.chmod(files[i]);
                            ++i;
                        }
                    }
                }
            }
        }
        catch (IOException ioe) {
            this.log("Error in Chmod " + ioe.toString(), 1);
        }
    }

    public void setDir(String src) {
        this.srcDir = this.project.resolveFile(src);
    }

    public void setFile(String src) {
        this.srcFile = this.project.resolveFile(src);
    }

    public void setPerm(String perm) {
        this.mod = perm;
    }

    public void setSrc(String src) {
        this.log("The src attribute is deprecated. Please use the file attribute.", 1);
        this.setFile(src);
    }
}

