#include "parser.h"
#include "executer.h"

int main(int argc, char** arg){
  if(argc < 2){
    cout<<"Usage: "<<arg[0]<<" FILE "<<endl;
    return 1;
  }
  
  ifstream inf(arg[1]);
  if( !inf.is_open () ){
    cerr<<"could not open file: "<<arg[1]<<endl;
    return 1;
  }
  
  Parser parser(inf);
  
  if( parser.parse() ){

    TreeNode* root=parser.getTree();
    
#ifdef _DEBUG_
    root->showTree(root); //show parsetree
#endif

    Executer exe(root, argc, arg); //execute this tree and pass arguments
    exe.run();

  }
  else{
    cerr<<"Parsing failed!"<<endl;
  }
  
  return 0;
}


