/* searchop_searchsettings.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "searchop.hh"

SearchOp::SearchSettings::SearchSettings() : _basedir( "" ),
                                             _matchname( "*" ),
                                             _matchname_re( false ),
                                             _matchname_fullpath( false ),
                                             _matchname_case( true ),
                                             _matchcontent( "" ),
                                             _matchcontent_case( false ),
                                             _active_row( -1 ),
                                             _follow_symlinks( false ),
                                             _search_vfs( false )
{
}

SearchOp::SearchSettings::SearchSettings( const std::string &basedir,
                                          const std::string &matchname,
                                          bool matchname_re,
                                          bool matchname_fullpath,
                                          bool matchname_case,
                                          const std::string &matchcontent,
                                          bool matchcontent_case,
                                          bool follow_symlinks,
                                          bool search_vfs ) : _basedir( basedir ),
                                                              _matchname( matchname ),
                                                              _matchname_re( matchname_re ),
                                                              _matchname_fullpath( matchname_fullpath ),
                                                              _matchname_case( matchname_case ),
                                                              _matchcontent( matchcontent ),
                                                              _matchcontent_case( matchcontent_case ),
                                                              _active_row( -1 ),
                                                              _follow_symlinks( follow_symlinks ),
                                                              _search_vfs( search_vfs )
{
}

SearchOp::SearchSettings::~SearchSettings()
{
}

std::string SearchOp::SearchSettings::getBaseDir() const
{
  return _basedir;
}

std::string SearchOp::SearchSettings::getMatchName() const
{
  return _matchname;
}

bool SearchOp::SearchSettings::getMatchNameRE() const
{
  return _matchname_re;
}

bool SearchOp::SearchSettings::getMatchNameFullPath() const
{
  return _matchname_fullpath;
}

bool SearchOp::SearchSettings::getMatchNameCase() const
{
  return _matchname_case;
}

std::string SearchOp::SearchSettings::getMatchContent() const
{
  return _matchcontent;
}

bool SearchOp::SearchSettings::getMatchContentCase() const
{
  return _matchcontent_case;
}

int SearchOp::SearchSettings::getActiveRow() const
{
  return _active_row;
}

void SearchOp::SearchSettings::setActiveRow( int nv )
{
  _active_row = nv;
}

bool SearchOp::SearchSettings::getFollowSymlinks() const
{
  return _follow_symlinks;
}

bool SearchOp::SearchSettings::getSearchVFS() const
{
  return _search_vfs;
}
