/* nmcacheentry.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "nmcacheentry.hh"
#include "wconfig.h"

NMCacheEntry::NMCacheEntry()
{
  int i;
  verz=NULL;
  activefe=NULL;
  pos=0;
  xpos=0;
  checkfe=NULL;
  lastfe = NULL;
  for(i=0;i<2;i++) {
    files[i]=-1;
    dirs[i]=-1;
  }
  for(i=0;i<2;i++) {
    files_s[i]=-1;
    dirs_s[i]=-1;
  }
  actsortmode=-1;
  actshowhidden=-1;
  actfilterlfdnr=-1;
  dontcheck=false;
  firstnullft = NULL;
}

NMCacheEntry::~NMCacheEntry()
{
  if(verz!=NULL) delete verz;
}

void NMCacheEntry::subentry(FileEntry *fe)
{
  if(fe->isDir()==true) {
    if(strcmp(fe->name,"..")!=0) {
      dirs[0]--;
      if ( fe->dirsize >= 0 ) dirs_s[0] -= fe->dirsize; else dirs_s[0] -= fe->size();
      if(fe->select==true) {
        dirs[1]--;
        if ( fe->dirsize >= 0 ) dirs_s[1] -= fe->dirsize; else dirs_s[1] -= fe->size();
      }
    }
  } else {
    files[0]--;
    files_s[0] -= fe->size();
    if(fe->select==true) {
      files[1]--;
      files_s[1] -= fe->size();
    }
  }
}

/*
 * NMCacheEntry::recalcStats
 *
 * recalculate the nr of bytes/files...
 * resets also activefe when it's not visible
 */
void NMCacheEntry::recalcStats()
{
  int i;
  if(verz==NULL) return;
  ArrayList *filelist=verz->getFiles();
  int id=filelist->initEnum();
  for(i=0;i<2;i++) {
    files[i]=0;
    dirs[i]=0;
  }
  for(i=0;i<2;i++) {
    files_s[i]=0;
    dirs_s[i]=0;
  }
  FileEntry *fe=(FileEntry*)filelist->getFirstElement(id);
  while(fe!=NULL) {
    if(fe->use==true) {
      if(fe->isDir()==true) {
        if(strcmp(fe->name,"..")!=0) {
          dirs[0]++;
          if ( fe->dirsize >= 0 ) dirs_s[0] += fe->dirsize; else dirs_s[0] += fe->size();
          if(fe->select==true) {
            dirs[1]++;
            if ( fe->dirsize >= 0 ) dirs_s[1] += fe->dirsize; else dirs_s[1] += fe->size();
          }
        }
      } else {
        files[0]++;
        files_s[0] += fe->size();
        if(fe->select==true) {
          files[1]++;
          files_s[1] += fe->size();
        }
      }
    } else {
      if(fe==activefe) activefe=NULL;
    }
    fe=(FileEntry*)filelist->getNextElement(id);
  }
  filelist->closeEnum(id);
}

/*
 * finds next visible entry without filetype
 * effect: advance checkfe
 */
void NMCacheEntry::next_checkfe()
{
  if(checkfe==NULL) return;
  if(verz!=NULL) {
    ArrayList *fes=verz->getFiles();
    if(fes!=NULL) {
      int tpos=fes->getIndex(checkfe)+1;
      for(;;) {
        checkfe=(FileEntry*)fes->getElementAt(tpos++);
        if(checkfe!=NULL) {
          if(checkfe->use==true) {
            // Pruefen, ob Dateityp noch nicht erkannt wurde
            // TODO: Jetzt reicht noch auf NULL pruefen, spaeter muss auf den NotYetChecked geprueft
            // werden
            if(checkfe->filetype==NULL) {
              if((checkfe->isLink==true)&&(checkfe->isCorrupt==false)&&(checkfe->isDir()==false)) break;
              if(checkfe->isDir()==false) break;
            }
          }
        } else break;
      }
    } else checkfe=NULL;
  } else checkfe=NULL;
}

/*
 * reset all filetypes to NULL
 * effect: reset checkfe and firstnullft
 */
void NMCacheEntry::restartcheck()
{
  if(verz!=NULL) {
    ArrayList *fes=verz->getFiles();
    if(fes!=NULL) {
      int id=fes->initEnum();
      FileEntry *fe=(FileEntry*)fes->getFirstElement(id);
      while(fe!=NULL) {
        fe->filetype=NULL;
	fe->setCustomColors( false );
        fe=(FileEntry*)fes->getNextElement(id);
      }
      fes->closeEnum(id);
      checkfe=(FileEntry*)fes->getFirstElement();
    } else checkfe=NULL;
  } else checkfe=NULL;
  next_checkfe();
  firstnullft = checkfe;
}

/*
 * resets checkfe to first null filetype
 * effect: reset checkfe and firstnullft
 */
void NMCacheEntry::reset_checkfe()
{
  if(verz!=NULL) {
    ArrayList *fes=verz->getFiles();
    if(fes!=NULL) {
      checkfe=(FileEntry*)fes->getFirstElement();
    } else checkfe=NULL;
  } else checkfe=NULL;
  next_checkfe();
  firstnullft = checkfe;
}

/*
 * resets firstnullft to first null filetype
 * effect: advance firstnullft
 */
void NMCacheEntry::reset_firstnullft()
{
  if(verz!=NULL) {
    ArrayList *fes=verz->getFiles();
    if(fes!=NULL) {
      firstnullft=(FileEntry*)fes->getFirstElement();
      next_firstnullft();
    } else firstnullft=NULL;
  } else firstnullft=NULL;
}

/*
 * finds next visible entry without filetype
 * effect: advance firstnullft
 */
void NMCacheEntry::next_firstnullft()
{
  if(firstnullft==NULL) return;
  if(verz!=NULL) {
    ArrayList *fes=verz->getFiles();
    if(fes!=NULL) {
      int tpos=fes->getIndex(firstnullft)+1;
      for(;;) {
        firstnullft=(FileEntry*)fes->getElementAt(tpos++);
        if(firstnullft!=NULL) {
          if(firstnullft->use==true) {
            // Pruefen, ob Dateityp noch nicht erkannt wurde
            // TODO: Jetzt reicht noch auf NULL pruefen, spaeter muss auf den NotYetChecked geprueft
            // werden
            if(firstnullft->filetype==NULL) {
              if((firstnullft->isLink==true)&&(firstnullft->isCorrupt==false)&&(firstnullft->isDir()==false)) break;
              if(firstnullft->isDir()==false) break;
            }
          }
        } else break;
      }
    } else firstnullft=NULL;
  } else firstnullft=NULL;
}

void NMCacheEntry::checkfordcd()
{
  List *dcd=wconfig->getDontCheckDirs();
  char *tstr;
  const char *dirstr;
  int id;

  dontcheck=false;
  if(verz!=NULL) {
    dirstr=verz->getDir();
    if(dcd!=NULL) {
      id=dcd->initEnum();
      tstr=(char*)dcd->getFirstElement(id);
      while(tstr!=NULL) {
        if(strncmp(tstr,dirstr,strlen(tstr))==0) {
          dontcheck=true;
          break;
        }
        tstr=(char*)dcd->getNextElement(id);
      }
      dcd->closeEnum(id);
    }
  }
}

void NMCacheEntry::reset_dirsizes()
{
  if(verz==NULL) return;
  ArrayList *filelist=verz->getFiles();
  int id=filelist->initEnum();
  FileEntry *fe=(FileEntry*)filelist->getFirstElement(id);
  while(fe!=NULL) {
    if(fe->isDir()==true) {
      fe->dirsize=-1;
    }
    fe=(FileEntry*)filelist->getNextElement(id);
  }
  filelist->closeEnum(id);
}
