/* thread.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "thread.hh"

Thread::Thread() : _id( 0 )
{
}

Thread::~Thread()
{
  join();
}

int Thread::start()
{
  int erg;

  erg = pthread_create( &_id, NULL, thread_entry, this );
  return erg;
}

void *Thread::thread_entry( void *me )
{
  ((Thread*)me)->run();
  return NULL;
}

int Thread::join()
{
  int erg = 0;

  if ( _id != 0 ) {
    erg = pthread_join( _id, NULL );
    _id = 0;
  }
  return erg;
}

bool Thread::amIThisThread() const
{
  if ( pthread_equal( _id, pthread_self() ) )
    return true;
  return false;
}
