/* automatically generated by rust-bindgen 0.71.1 */

#![allow(non_snake_case)]
#![allow(non_camel_case_types)]
#![allow(non_upper_case_globals)]
#![allow(clippy::unreadable_literal)]
#![allow(clippy::upper_case_acronyms)]

pub type hb_bool_t = ::std::os::raw::c_int;
pub type hb_codepoint_t = u32;
pub type hb_position_t = i32;
pub type hb_mask_t = u32;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _hb_var_int_t {
    pub u32_: u32,
    pub i32_: i32,
    pub u16_: [u16; 2usize],
    pub i16_: [i16; 2usize],
    pub u8_: [u8; 4usize],
    pub i8_: [i8; 4usize],
}
pub type hb_var_int_t = _hb_var_int_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _hb_var_num_t {
    pub f: f32,
    pub u32_: u32,
    pub i32_: i32,
    pub u16_: [u16; 2usize],
    pub i16_: [i16; 2usize],
    pub u8_: [u8; 4usize],
    pub i8_: [i8; 4usize],
}
pub type hb_var_num_t = _hb_var_num_t;
pub type hb_tag_t = u32;
unsafe extern "C" {
    pub fn hb_tag_from_string(
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> hb_tag_t;
}
unsafe extern "C" {
    pub fn hb_tag_to_string(tag: hb_tag_t, buf: *mut ::std::os::raw::c_char);
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_direction_t {
    HB_DIRECTION_INVALID = 0,
    HB_DIRECTION_LTR = 4,
    HB_DIRECTION_RTL = 5,
    HB_DIRECTION_TTB = 6,
    HB_DIRECTION_BTT = 7,
}
unsafe extern "C" {
    pub fn hb_direction_from_string(
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> hb_direction_t;
}
unsafe extern "C" {
    pub fn hb_direction_to_string(direction: hb_direction_t) -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_language_impl_t {
    _unused: [u8; 0],
}
pub type hb_language_t = *const hb_language_impl_t;
unsafe extern "C" {
    pub fn hb_language_from_string(
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> hb_language_t;
}
unsafe extern "C" {
    pub fn hb_language_to_string(language: hb_language_t) -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn hb_language_get_default() -> hb_language_t;
}
unsafe extern "C" {
    pub fn hb_language_matches(language: hb_language_t, specific: hb_language_t) -> hb_bool_t;
}
impl hb_script_t {
    pub const _HB_SCRIPT_MAX_VALUE_SIGNED: hb_script_t = hb_script_t::_HB_SCRIPT_MAX_VALUE;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_script_t {
    HB_SCRIPT_COMMON = 1517910393,
    HB_SCRIPT_INHERITED = 1516858984,
    HB_SCRIPT_UNKNOWN = 1517976186,
    HB_SCRIPT_ARABIC = 1098015074,
    HB_SCRIPT_ARMENIAN = 1098018158,
    HB_SCRIPT_BENGALI = 1113943655,
    HB_SCRIPT_CYRILLIC = 1132032620,
    HB_SCRIPT_DEVANAGARI = 1147500129,
    HB_SCRIPT_GEORGIAN = 1197830002,
    HB_SCRIPT_GREEK = 1198679403,
    HB_SCRIPT_GUJARATI = 1198877298,
    HB_SCRIPT_GURMUKHI = 1198879349,
    HB_SCRIPT_HANGUL = 1214344807,
    HB_SCRIPT_HAN = 1214344809,
    HB_SCRIPT_HEBREW = 1214603890,
    HB_SCRIPT_HIRAGANA = 1214870113,
    HB_SCRIPT_KANNADA = 1265525857,
    HB_SCRIPT_KATAKANA = 1264676449,
    HB_SCRIPT_LAO = 1281453935,
    HB_SCRIPT_LATIN = 1281455214,
    HB_SCRIPT_MALAYALAM = 1298954605,
    HB_SCRIPT_ORIYA = 1332902241,
    HB_SCRIPT_TAMIL = 1415671148,
    HB_SCRIPT_TELUGU = 1415933045,
    HB_SCRIPT_THAI = 1416126825,
    HB_SCRIPT_TIBETAN = 1416192628,
    HB_SCRIPT_BOPOMOFO = 1114599535,
    HB_SCRIPT_BRAILLE = 1114792297,
    HB_SCRIPT_CANADIAN_SYLLABICS = 1130458739,
    HB_SCRIPT_CHEROKEE = 1130915186,
    HB_SCRIPT_ETHIOPIC = 1165256809,
    HB_SCRIPT_KHMER = 1265134962,
    HB_SCRIPT_MONGOLIAN = 1299148391,
    HB_SCRIPT_MYANMAR = 1299803506,
    HB_SCRIPT_OGHAM = 1332175213,
    HB_SCRIPT_RUNIC = 1383427698,
    HB_SCRIPT_SINHALA = 1399418472,
    HB_SCRIPT_SYRIAC = 1400468067,
    HB_SCRIPT_THAANA = 1416126817,
    HB_SCRIPT_YI = 1500080489,
    HB_SCRIPT_DESERET = 1148416628,
    HB_SCRIPT_GOTHIC = 1198486632,
    HB_SCRIPT_OLD_ITALIC = 1232363884,
    HB_SCRIPT_BUHID = 1114990692,
    HB_SCRIPT_HANUNOO = 1214344815,
    HB_SCRIPT_TAGALOG = 1416064103,
    HB_SCRIPT_TAGBANWA = 1415669602,
    HB_SCRIPT_CYPRIOT = 1131442804,
    HB_SCRIPT_LIMBU = 1281977698,
    HB_SCRIPT_LINEAR_B = 1281977954,
    HB_SCRIPT_OSMANYA = 1332964705,
    HB_SCRIPT_SHAVIAN = 1399349623,
    HB_SCRIPT_TAI_LE = 1415670885,
    HB_SCRIPT_UGARITIC = 1432838514,
    HB_SCRIPT_BUGINESE = 1114990441,
    HB_SCRIPT_COPTIC = 1131376756,
    HB_SCRIPT_GLAGOLITIC = 1198285159,
    HB_SCRIPT_KHAROSHTHI = 1265131890,
    HB_SCRIPT_NEW_TAI_LUE = 1415670901,
    HB_SCRIPT_OLD_PERSIAN = 1483761007,
    HB_SCRIPT_SYLOTI_NAGRI = 1400466543,
    HB_SCRIPT_TIFINAGH = 1415999079,
    HB_SCRIPT_BALINESE = 1113681001,
    HB_SCRIPT_CUNEIFORM = 1483961720,
    HB_SCRIPT_NKO = 1315663727,
    HB_SCRIPT_PHAGS_PA = 1349017959,
    HB_SCRIPT_PHOENICIAN = 1349021304,
    HB_SCRIPT_CARIAN = 1130459753,
    HB_SCRIPT_CHAM = 1130914157,
    HB_SCRIPT_KAYAH_LI = 1264675945,
    HB_SCRIPT_LEPCHA = 1281716323,
    HB_SCRIPT_LYCIAN = 1283023721,
    HB_SCRIPT_LYDIAN = 1283023977,
    HB_SCRIPT_OL_CHIKI = 1332503403,
    HB_SCRIPT_REJANG = 1382706791,
    HB_SCRIPT_SAURASHTRA = 1398895986,
    HB_SCRIPT_SUNDANESE = 1400204900,
    HB_SCRIPT_VAI = 1449224553,
    HB_SCRIPT_AVESTAN = 1098281844,
    HB_SCRIPT_BAMUM = 1113681269,
    HB_SCRIPT_EGYPTIAN_HIEROGLYPHS = 1164409200,
    HB_SCRIPT_IMPERIAL_ARAMAIC = 1098018153,
    HB_SCRIPT_INSCRIPTIONAL_PAHLAVI = 1349020777,
    HB_SCRIPT_INSCRIPTIONAL_PARTHIAN = 1349678185,
    HB_SCRIPT_JAVANESE = 1247901281,
    HB_SCRIPT_KAITHI = 1265920105,
    HB_SCRIPT_LISU = 1281979253,
    HB_SCRIPT_MEETEI_MAYEK = 1299473769,
    HB_SCRIPT_OLD_SOUTH_ARABIAN = 1398895202,
    HB_SCRIPT_OLD_TURKIC = 1332898664,
    HB_SCRIPT_SAMARITAN = 1398893938,
    HB_SCRIPT_TAI_THAM = 1281453665,
    HB_SCRIPT_TAI_VIET = 1415673460,
    HB_SCRIPT_BATAK = 1113683051,
    HB_SCRIPT_BRAHMI = 1114792296,
    HB_SCRIPT_MANDAIC = 1298230884,
    HB_SCRIPT_CHAKMA = 1130457965,
    HB_SCRIPT_MEROITIC_CURSIVE = 1298494051,
    HB_SCRIPT_MEROITIC_HIEROGLYPHS = 1298494063,
    HB_SCRIPT_MIAO = 1349284452,
    HB_SCRIPT_SHARADA = 1399353956,
    HB_SCRIPT_SORA_SOMPENG = 1399812705,
    HB_SCRIPT_TAKRI = 1415670642,
    HB_SCRIPT_BASSA_VAH = 1113682803,
    HB_SCRIPT_CAUCASIAN_ALBANIAN = 1097295970,
    HB_SCRIPT_DUPLOYAN = 1148547180,
    HB_SCRIPT_ELBASAN = 1164730977,
    HB_SCRIPT_GRANTHA = 1198678382,
    HB_SCRIPT_KHOJKI = 1265135466,
    HB_SCRIPT_KHUDAWADI = 1399418468,
    HB_SCRIPT_LINEAR_A = 1281977953,
    HB_SCRIPT_MAHAJANI = 1298229354,
    HB_SCRIPT_MANICHAEAN = 1298230889,
    HB_SCRIPT_MENDE_KIKAKUI = 1298493028,
    HB_SCRIPT_MODI = 1299145833,
    HB_SCRIPT_MRO = 1299345263,
    HB_SCRIPT_NABATAEAN = 1315070324,
    HB_SCRIPT_OLD_NORTH_ARABIAN = 1315009122,
    HB_SCRIPT_OLD_PERMIC = 1348825709,
    HB_SCRIPT_PAHAWH_HMONG = 1215131239,
    HB_SCRIPT_PALMYRENE = 1348562029,
    HB_SCRIPT_PAU_CIN_HAU = 1348564323,
    HB_SCRIPT_PSALTER_PAHLAVI = 1349020784,
    HB_SCRIPT_SIDDHAM = 1399415908,
    HB_SCRIPT_TIRHUTA = 1416196712,
    HB_SCRIPT_WARANG_CITI = 1466004065,
    HB_SCRIPT_AHOM = 1097363309,
    HB_SCRIPT_ANATOLIAN_HIEROGLYPHS = 1215067511,
    HB_SCRIPT_HATRAN = 1214346354,
    HB_SCRIPT_MULTANI = 1299541108,
    HB_SCRIPT_OLD_HUNGARIAN = 1215655527,
    HB_SCRIPT_SIGNWRITING = 1399287415,
    HB_SCRIPT_ADLAM = 1097100397,
    HB_SCRIPT_BHAIKSUKI = 1114139507,
    HB_SCRIPT_MARCHEN = 1298231907,
    HB_SCRIPT_OSAGE = 1332963173,
    HB_SCRIPT_TANGUT = 1415671399,
    HB_SCRIPT_NEWA = 1315272545,
    HB_SCRIPT_MASARAM_GONDI = 1198485101,
    HB_SCRIPT_NUSHU = 1316186229,
    HB_SCRIPT_SOYOMBO = 1399814511,
    HB_SCRIPT_ZANABAZAR_SQUARE = 1516334690,
    HB_SCRIPT_DOGRA = 1148151666,
    HB_SCRIPT_GUNJALA_GONDI = 1198485095,
    HB_SCRIPT_HANIFI_ROHINGYA = 1383032935,
    HB_SCRIPT_MAKASAR = 1298230113,
    HB_SCRIPT_MEDEFAIDRIN = 1298490470,
    HB_SCRIPT_OLD_SOGDIAN = 1399809903,
    HB_SCRIPT_SOGDIAN = 1399809892,
    HB_SCRIPT_ELYMAIC = 1164736877,
    HB_SCRIPT_NANDINAGARI = 1315008100,
    HB_SCRIPT_NYIAKENG_PUACHUE_HMONG = 1215131248,
    HB_SCRIPT_WANCHO = 1466132591,
    HB_SCRIPT_CHORASMIAN = 1130918515,
    HB_SCRIPT_DIVES_AKURU = 1147756907,
    HB_SCRIPT_KHITAN_SMALL_SCRIPT = 1265202291,
    HB_SCRIPT_YEZIDI = 1499822697,
    HB_SCRIPT_CYPRO_MINOAN = 1131441518,
    HB_SCRIPT_OLD_UYGHUR = 1333094258,
    HB_SCRIPT_TANGSA = 1416524641,
    HB_SCRIPT_TOTO = 1416590447,
    HB_SCRIPT_VITHKUQI = 1449751656,
    HB_SCRIPT_MATH = 1517122664,
    HB_SCRIPT_KAWI = 1264678761,
    HB_SCRIPT_NAG_MUNDARI = 1315006317,
    HB_SCRIPT_GARAY = 1197568609,
    HB_SCRIPT_GURUNG_KHEMA = 1198877544,
    HB_SCRIPT_KIRAT_RAI = 1265787241,
    HB_SCRIPT_OL_ONAL = 1332633967,
    HB_SCRIPT_SUNUWAR = 1400204917,
    HB_SCRIPT_TODHRI = 1416586354,
    HB_SCRIPT_TULU_TIGALARI = 1416983655,
    HB_SCRIPT_INVALID = 0,
    _HB_SCRIPT_MAX_VALUE = 2147483647,
}
unsafe extern "C" {
    pub fn hb_script_from_iso15924_tag(tag: hb_tag_t) -> hb_script_t;
}
unsafe extern "C" {
    pub fn hb_script_from_string(
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> hb_script_t;
}
unsafe extern "C" {
    pub fn hb_script_to_iso15924_tag(script: hb_script_t) -> hb_tag_t;
}
unsafe extern "C" {
    pub fn hb_script_get_horizontal_direction(script: hb_script_t) -> hb_direction_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_user_data_key_t {
    pub unused: ::std::os::raw::c_char,
}
pub type hb_destroy_func_t =
    ::std::option::Option<unsafe extern "C" fn(user_data: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_feature_t {
    pub tag: hb_tag_t,
    pub value: u32,
    pub start: ::std::os::raw::c_uint,
    pub end: ::std::os::raw::c_uint,
}
unsafe extern "C" {
    pub fn hb_feature_from_string(
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        feature: *mut hb_feature_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_feature_to_string(
        feature: *mut hb_feature_t,
        buf: *mut ::std::os::raw::c_char,
        size: ::std::os::raw::c_uint,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_variation_t {
    pub tag: hb_tag_t,
    pub value: f32,
}
unsafe extern "C" {
    pub fn hb_variation_from_string(
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        variation: *mut hb_variation_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_variation_to_string(
        variation: *mut hb_variation_t,
        buf: *mut ::std::os::raw::c_char,
        size: ::std::os::raw::c_uint,
    );
}
pub type hb_color_t = u32;
unsafe extern "C" {
    pub fn hb_color_get_alpha(color: hb_color_t) -> u8;
}
unsafe extern "C" {
    pub fn hb_color_get_red(color: hb_color_t) -> u8;
}
unsafe extern "C" {
    pub fn hb_color_get_green(color: hb_color_t) -> u8;
}
unsafe extern "C" {
    pub fn hb_color_get_blue(color: hb_color_t) -> u8;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_glyph_extents_t {
    pub x_bearing: hb_position_t,
    pub y_bearing: hb_position_t,
    pub width: hb_position_t,
    pub height: hb_position_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_font_t {
    _unused: [u8; 0],
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_memory_mode_t {
    HB_MEMORY_MODE_DUPLICATE = 0,
    HB_MEMORY_MODE_READONLY = 1,
    HB_MEMORY_MODE_WRITABLE = 2,
    HB_MEMORY_MODE_READONLY_MAY_MAKE_WRITABLE = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_blob_t {
    _unused: [u8; 0],
}
unsafe extern "C" {
    pub fn hb_blob_create(
        data: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_uint,
        mode: hb_memory_mode_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    ) -> *mut hb_blob_t;
}
unsafe extern "C" {
    pub fn hb_blob_create_or_fail(
        data: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_uint,
        mode: hb_memory_mode_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    ) -> *mut hb_blob_t;
}
unsafe extern "C" {
    pub fn hb_blob_create_from_file(file_name: *const ::std::os::raw::c_char) -> *mut hb_blob_t;
}
unsafe extern "C" {
    pub fn hb_blob_create_from_file_or_fail(
        file_name: *const ::std::os::raw::c_char,
    ) -> *mut hb_blob_t;
}
unsafe extern "C" {
    pub fn hb_blob_create_sub_blob(
        parent: *mut hb_blob_t,
        offset: ::std::os::raw::c_uint,
        length: ::std::os::raw::c_uint,
    ) -> *mut hb_blob_t;
}
unsafe extern "C" {
    pub fn hb_blob_copy_writable_or_fail(blob: *mut hb_blob_t) -> *mut hb_blob_t;
}
unsafe extern "C" {
    pub fn hb_blob_get_empty() -> *mut hb_blob_t;
}
unsafe extern "C" {
    pub fn hb_blob_reference(blob: *mut hb_blob_t) -> *mut hb_blob_t;
}
unsafe extern "C" {
    pub fn hb_blob_destroy(blob: *mut hb_blob_t);
}
unsafe extern "C" {
    pub fn hb_blob_set_user_data(
        blob: *mut hb_blob_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_blob_get_user_data(
        blob: *const hb_blob_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    pub fn hb_blob_make_immutable(blob: *mut hb_blob_t);
}
unsafe extern "C" {
    pub fn hb_blob_is_immutable(blob: *mut hb_blob_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_blob_get_length(blob: *mut hb_blob_t) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_blob_get_data(
        blob: *mut hb_blob_t,
        length: *mut ::std::os::raw::c_uint,
    ) -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn hb_blob_get_data_writable(
        blob: *mut hb_blob_t,
        length: *mut ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_char;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_unicode_general_category_t {
    HB_UNICODE_GENERAL_CATEGORY_CONTROL = 0,
    HB_UNICODE_GENERAL_CATEGORY_FORMAT = 1,
    HB_UNICODE_GENERAL_CATEGORY_UNASSIGNED = 2,
    HB_UNICODE_GENERAL_CATEGORY_PRIVATE_USE = 3,
    HB_UNICODE_GENERAL_CATEGORY_SURROGATE = 4,
    HB_UNICODE_GENERAL_CATEGORY_LOWERCASE_LETTER = 5,
    HB_UNICODE_GENERAL_CATEGORY_MODIFIER_LETTER = 6,
    HB_UNICODE_GENERAL_CATEGORY_OTHER_LETTER = 7,
    HB_UNICODE_GENERAL_CATEGORY_TITLECASE_LETTER = 8,
    HB_UNICODE_GENERAL_CATEGORY_UPPERCASE_LETTER = 9,
    HB_UNICODE_GENERAL_CATEGORY_SPACING_MARK = 10,
    HB_UNICODE_GENERAL_CATEGORY_ENCLOSING_MARK = 11,
    HB_UNICODE_GENERAL_CATEGORY_NON_SPACING_MARK = 12,
    HB_UNICODE_GENERAL_CATEGORY_DECIMAL_NUMBER = 13,
    HB_UNICODE_GENERAL_CATEGORY_LETTER_NUMBER = 14,
    HB_UNICODE_GENERAL_CATEGORY_OTHER_NUMBER = 15,
    HB_UNICODE_GENERAL_CATEGORY_CONNECT_PUNCTUATION = 16,
    HB_UNICODE_GENERAL_CATEGORY_DASH_PUNCTUATION = 17,
    HB_UNICODE_GENERAL_CATEGORY_CLOSE_PUNCTUATION = 18,
    HB_UNICODE_GENERAL_CATEGORY_FINAL_PUNCTUATION = 19,
    HB_UNICODE_GENERAL_CATEGORY_INITIAL_PUNCTUATION = 20,
    HB_UNICODE_GENERAL_CATEGORY_OTHER_PUNCTUATION = 21,
    HB_UNICODE_GENERAL_CATEGORY_OPEN_PUNCTUATION = 22,
    HB_UNICODE_GENERAL_CATEGORY_CURRENCY_SYMBOL = 23,
    HB_UNICODE_GENERAL_CATEGORY_MODIFIER_SYMBOL = 24,
    HB_UNICODE_GENERAL_CATEGORY_MATH_SYMBOL = 25,
    HB_UNICODE_GENERAL_CATEGORY_OTHER_SYMBOL = 26,
    HB_UNICODE_GENERAL_CATEGORY_LINE_SEPARATOR = 27,
    HB_UNICODE_GENERAL_CATEGORY_PARAGRAPH_SEPARATOR = 28,
    HB_UNICODE_GENERAL_CATEGORY_SPACE_SEPARATOR = 29,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_unicode_combining_class_t {
    HB_UNICODE_COMBINING_CLASS_NOT_REORDERED = 0,
    HB_UNICODE_COMBINING_CLASS_OVERLAY = 1,
    HB_UNICODE_COMBINING_CLASS_NUKTA = 7,
    HB_UNICODE_COMBINING_CLASS_KANA_VOICING = 8,
    HB_UNICODE_COMBINING_CLASS_VIRAMA = 9,
    HB_UNICODE_COMBINING_CLASS_CCC10 = 10,
    HB_UNICODE_COMBINING_CLASS_CCC11 = 11,
    HB_UNICODE_COMBINING_CLASS_CCC12 = 12,
    HB_UNICODE_COMBINING_CLASS_CCC13 = 13,
    HB_UNICODE_COMBINING_CLASS_CCC14 = 14,
    HB_UNICODE_COMBINING_CLASS_CCC15 = 15,
    HB_UNICODE_COMBINING_CLASS_CCC16 = 16,
    HB_UNICODE_COMBINING_CLASS_CCC17 = 17,
    HB_UNICODE_COMBINING_CLASS_CCC18 = 18,
    HB_UNICODE_COMBINING_CLASS_CCC19 = 19,
    HB_UNICODE_COMBINING_CLASS_CCC20 = 20,
    HB_UNICODE_COMBINING_CLASS_CCC21 = 21,
    HB_UNICODE_COMBINING_CLASS_CCC22 = 22,
    HB_UNICODE_COMBINING_CLASS_CCC23 = 23,
    HB_UNICODE_COMBINING_CLASS_CCC24 = 24,
    HB_UNICODE_COMBINING_CLASS_CCC25 = 25,
    HB_UNICODE_COMBINING_CLASS_CCC26 = 26,
    HB_UNICODE_COMBINING_CLASS_CCC27 = 27,
    HB_UNICODE_COMBINING_CLASS_CCC28 = 28,
    HB_UNICODE_COMBINING_CLASS_CCC29 = 29,
    HB_UNICODE_COMBINING_CLASS_CCC30 = 30,
    HB_UNICODE_COMBINING_CLASS_CCC31 = 31,
    HB_UNICODE_COMBINING_CLASS_CCC32 = 32,
    HB_UNICODE_COMBINING_CLASS_CCC33 = 33,
    HB_UNICODE_COMBINING_CLASS_CCC34 = 34,
    HB_UNICODE_COMBINING_CLASS_CCC35 = 35,
    HB_UNICODE_COMBINING_CLASS_CCC36 = 36,
    HB_UNICODE_COMBINING_CLASS_CCC84 = 84,
    HB_UNICODE_COMBINING_CLASS_CCC91 = 91,
    HB_UNICODE_COMBINING_CLASS_CCC103 = 103,
    HB_UNICODE_COMBINING_CLASS_CCC107 = 107,
    HB_UNICODE_COMBINING_CLASS_CCC118 = 118,
    HB_UNICODE_COMBINING_CLASS_CCC122 = 122,
    HB_UNICODE_COMBINING_CLASS_CCC129 = 129,
    HB_UNICODE_COMBINING_CLASS_CCC130 = 130,
    HB_UNICODE_COMBINING_CLASS_CCC132 = 132,
    HB_UNICODE_COMBINING_CLASS_ATTACHED_BELOW_LEFT = 200,
    HB_UNICODE_COMBINING_CLASS_ATTACHED_BELOW = 202,
    HB_UNICODE_COMBINING_CLASS_ATTACHED_ABOVE = 214,
    HB_UNICODE_COMBINING_CLASS_ATTACHED_ABOVE_RIGHT = 216,
    HB_UNICODE_COMBINING_CLASS_BELOW_LEFT = 218,
    HB_UNICODE_COMBINING_CLASS_BELOW = 220,
    HB_UNICODE_COMBINING_CLASS_BELOW_RIGHT = 222,
    HB_UNICODE_COMBINING_CLASS_LEFT = 224,
    HB_UNICODE_COMBINING_CLASS_RIGHT = 226,
    HB_UNICODE_COMBINING_CLASS_ABOVE_LEFT = 228,
    HB_UNICODE_COMBINING_CLASS_ABOVE = 230,
    HB_UNICODE_COMBINING_CLASS_ABOVE_RIGHT = 232,
    HB_UNICODE_COMBINING_CLASS_DOUBLE_BELOW = 233,
    HB_UNICODE_COMBINING_CLASS_DOUBLE_ABOVE = 234,
    HB_UNICODE_COMBINING_CLASS_IOTA_SUBSCRIPT = 240,
    HB_UNICODE_COMBINING_CLASS_INVALID = 255,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_unicode_funcs_t {
    _unused: [u8; 0],
}
unsafe extern "C" {
    pub fn hb_unicode_funcs_get_default() -> *mut hb_unicode_funcs_t;
}
unsafe extern "C" {
    pub fn hb_unicode_funcs_create(parent: *mut hb_unicode_funcs_t) -> *mut hb_unicode_funcs_t;
}
unsafe extern "C" {
    pub fn hb_unicode_funcs_get_empty() -> *mut hb_unicode_funcs_t;
}
unsafe extern "C" {
    pub fn hb_unicode_funcs_reference(ufuncs: *mut hb_unicode_funcs_t) -> *mut hb_unicode_funcs_t;
}
unsafe extern "C" {
    pub fn hb_unicode_funcs_destroy(ufuncs: *mut hb_unicode_funcs_t);
}
unsafe extern "C" {
    pub fn hb_unicode_funcs_set_user_data(
        ufuncs: *mut hb_unicode_funcs_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_unicode_funcs_get_user_data(
        ufuncs: *const hb_unicode_funcs_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    pub fn hb_unicode_funcs_make_immutable(ufuncs: *mut hb_unicode_funcs_t);
}
unsafe extern "C" {
    pub fn hb_unicode_funcs_is_immutable(ufuncs: *mut hb_unicode_funcs_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_unicode_funcs_get_parent(ufuncs: *mut hb_unicode_funcs_t) -> *mut hb_unicode_funcs_t;
}
pub type hb_unicode_combining_class_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_unicode_combining_class_t,
>;
pub type hb_unicode_general_category_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_unicode_general_category_t,
>;
pub type hb_unicode_mirroring_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_codepoint_t,
>;
pub type hb_unicode_script_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_script_t,
>;
pub type hb_unicode_compose_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        ufuncs: *mut hb_unicode_funcs_t,
        a: hb_codepoint_t,
        b: hb_codepoint_t,
        ab: *mut hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
pub type hb_unicode_decompose_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        ufuncs: *mut hb_unicode_funcs_t,
        ab: hb_codepoint_t,
        a: *mut hb_codepoint_t,
        b: *mut hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
unsafe extern "C" {
    pub fn hb_unicode_funcs_set_combining_class_func(
        ufuncs: *mut hb_unicode_funcs_t,
        func: hb_unicode_combining_class_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_unicode_funcs_set_general_category_func(
        ufuncs: *mut hb_unicode_funcs_t,
        func: hb_unicode_general_category_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_unicode_funcs_set_mirroring_func(
        ufuncs: *mut hb_unicode_funcs_t,
        func: hb_unicode_mirroring_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_unicode_funcs_set_script_func(
        ufuncs: *mut hb_unicode_funcs_t,
        func: hb_unicode_script_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_unicode_funcs_set_compose_func(
        ufuncs: *mut hb_unicode_funcs_t,
        func: hb_unicode_compose_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_unicode_funcs_set_decompose_func(
        ufuncs: *mut hb_unicode_funcs_t,
        func: hb_unicode_decompose_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_unicode_combining_class(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
    ) -> hb_unicode_combining_class_t;
}
unsafe extern "C" {
    pub fn hb_unicode_general_category(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
    ) -> hb_unicode_general_category_t;
}
unsafe extern "C" {
    pub fn hb_unicode_mirroring(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
    ) -> hb_codepoint_t;
}
unsafe extern "C" {
    pub fn hb_unicode_script(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
    ) -> hb_script_t;
}
unsafe extern "C" {
    pub fn hb_unicode_compose(
        ufuncs: *mut hb_unicode_funcs_t,
        a: hb_codepoint_t,
        b: hb_codepoint_t,
        ab: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_unicode_decompose(
        ufuncs: *mut hb_unicode_funcs_t,
        ab: hb_codepoint_t,
        a: *mut hb_codepoint_t,
        b: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_set_t {
    _unused: [u8; 0],
}
unsafe extern "C" {
    pub fn hb_set_create() -> *mut hb_set_t;
}
unsafe extern "C" {
    pub fn hb_set_get_empty() -> *mut hb_set_t;
}
unsafe extern "C" {
    pub fn hb_set_reference(set: *mut hb_set_t) -> *mut hb_set_t;
}
unsafe extern "C" {
    pub fn hb_set_destroy(set: *mut hb_set_t);
}
unsafe extern "C" {
    pub fn hb_set_set_user_data(
        set: *mut hb_set_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_set_get_user_data(
        set: *const hb_set_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    pub fn hb_set_allocation_successful(set: *const hb_set_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_set_copy(set: *const hb_set_t) -> *mut hb_set_t;
}
unsafe extern "C" {
    pub fn hb_set_clear(set: *mut hb_set_t);
}
unsafe extern "C" {
    pub fn hb_set_is_empty(set: *const hb_set_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_set_invert(set: *mut hb_set_t);
}
unsafe extern "C" {
    pub fn hb_set_is_inverted(set: *const hb_set_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_set_has(set: *const hb_set_t, codepoint: hb_codepoint_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_set_add(set: *mut hb_set_t, codepoint: hb_codepoint_t);
}
unsafe extern "C" {
    pub fn hb_set_add_range(set: *mut hb_set_t, first: hb_codepoint_t, last: hb_codepoint_t);
}
unsafe extern "C" {
    pub fn hb_set_add_sorted_array(
        set: *mut hb_set_t,
        sorted_codepoints: *const hb_codepoint_t,
        num_codepoints: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn hb_set_del(set: *mut hb_set_t, codepoint: hb_codepoint_t);
}
unsafe extern "C" {
    pub fn hb_set_del_range(set: *mut hb_set_t, first: hb_codepoint_t, last: hb_codepoint_t);
}
unsafe extern "C" {
    pub fn hb_set_is_equal(set: *const hb_set_t, other: *const hb_set_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_set_hash(set: *const hb_set_t) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_set_is_subset(set: *const hb_set_t, larger_set: *const hb_set_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_set_set(set: *mut hb_set_t, other: *const hb_set_t);
}
unsafe extern "C" {
    pub fn hb_set_union(set: *mut hb_set_t, other: *const hb_set_t);
}
unsafe extern "C" {
    pub fn hb_set_intersect(set: *mut hb_set_t, other: *const hb_set_t);
}
unsafe extern "C" {
    pub fn hb_set_subtract(set: *mut hb_set_t, other: *const hb_set_t);
}
unsafe extern "C" {
    pub fn hb_set_symmetric_difference(set: *mut hb_set_t, other: *const hb_set_t);
}
unsafe extern "C" {
    pub fn hb_set_get_population(set: *const hb_set_t) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_set_get_min(set: *const hb_set_t) -> hb_codepoint_t;
}
unsafe extern "C" {
    pub fn hb_set_get_max(set: *const hb_set_t) -> hb_codepoint_t;
}
unsafe extern "C" {
    pub fn hb_set_next(set: *const hb_set_t, codepoint: *mut hb_codepoint_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_set_previous(set: *const hb_set_t, codepoint: *mut hb_codepoint_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_set_next_range(
        set: *const hb_set_t,
        first: *mut hb_codepoint_t,
        last: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_set_previous_range(
        set: *const hb_set_t,
        first: *mut hb_codepoint_t,
        last: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_set_next_many(
        set: *const hb_set_t,
        codepoint: hb_codepoint_t,
        out: *mut hb_codepoint_t,
        size: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_map_t {
    _unused: [u8; 0],
}
unsafe extern "C" {
    pub fn hb_map_create() -> *mut hb_map_t;
}
unsafe extern "C" {
    pub fn hb_map_get_empty() -> *mut hb_map_t;
}
unsafe extern "C" {
    pub fn hb_map_reference(map: *mut hb_map_t) -> *mut hb_map_t;
}
unsafe extern "C" {
    pub fn hb_map_destroy(map: *mut hb_map_t);
}
unsafe extern "C" {
    pub fn hb_map_set_user_data(
        map: *mut hb_map_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_map_get_user_data(
        map: *const hb_map_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    pub fn hb_map_allocation_successful(map: *const hb_map_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_map_copy(map: *const hb_map_t) -> *mut hb_map_t;
}
unsafe extern "C" {
    pub fn hb_map_clear(map: *mut hb_map_t);
}
unsafe extern "C" {
    pub fn hb_map_is_empty(map: *const hb_map_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_map_get_population(map: *const hb_map_t) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_map_is_equal(map: *const hb_map_t, other: *const hb_map_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_map_hash(map: *const hb_map_t) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_map_set(map: *mut hb_map_t, key: hb_codepoint_t, value: hb_codepoint_t);
}
unsafe extern "C" {
    pub fn hb_map_get(map: *const hb_map_t, key: hb_codepoint_t) -> hb_codepoint_t;
}
unsafe extern "C" {
    pub fn hb_map_del(map: *mut hb_map_t, key: hb_codepoint_t);
}
unsafe extern "C" {
    pub fn hb_map_has(map: *const hb_map_t, key: hb_codepoint_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_map_update(map: *mut hb_map_t, other: *const hb_map_t);
}
unsafe extern "C" {
    pub fn hb_map_next(
        map: *const hb_map_t,
        idx: *mut ::std::os::raw::c_int,
        key: *mut hb_codepoint_t,
        value: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_map_keys(map: *const hb_map_t, keys: *mut hb_set_t);
}
unsafe extern "C" {
    pub fn hb_map_values(map: *const hb_map_t, values: *mut hb_set_t);
}
unsafe extern "C" {
    pub fn hb_face_count(blob: *mut hb_blob_t) -> ::std::os::raw::c_uint;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_face_t {
    _unused: [u8; 0],
}
unsafe extern "C" {
    pub fn hb_face_create(blob: *mut hb_blob_t, index: ::std::os::raw::c_uint) -> *mut hb_face_t;
}
unsafe extern "C" {
    pub fn hb_face_create_or_fail(
        blob: *mut hb_blob_t,
        index: ::std::os::raw::c_uint,
    ) -> *mut hb_face_t;
}
unsafe extern "C" {
    pub fn hb_face_create_from_file_or_fail(
        file_name: *const ::std::os::raw::c_char,
        index: ::std::os::raw::c_uint,
    ) -> *mut hb_face_t;
}
pub type hb_reference_table_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        face: *mut hb_face_t,
        tag: hb_tag_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> *mut hb_blob_t,
>;
unsafe extern "C" {
    pub fn hb_face_create_for_tables(
        reference_table_func: hb_reference_table_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    ) -> *mut hb_face_t;
}
unsafe extern "C" {
    pub fn hb_face_get_empty() -> *mut hb_face_t;
}
unsafe extern "C" {
    pub fn hb_face_reference(face: *mut hb_face_t) -> *mut hb_face_t;
}
unsafe extern "C" {
    pub fn hb_face_destroy(face: *mut hb_face_t);
}
unsafe extern "C" {
    pub fn hb_face_set_user_data(
        face: *mut hb_face_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_face_get_user_data(
        face: *const hb_face_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    pub fn hb_face_make_immutable(face: *mut hb_face_t);
}
unsafe extern "C" {
    pub fn hb_face_is_immutable(face: *const hb_face_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_face_reference_table(face: *const hb_face_t, tag: hb_tag_t) -> *mut hb_blob_t;
}
unsafe extern "C" {
    pub fn hb_face_reference_blob(face: *mut hb_face_t) -> *mut hb_blob_t;
}
unsafe extern "C" {
    pub fn hb_face_set_index(face: *mut hb_face_t, index: ::std::os::raw::c_uint);
}
unsafe extern "C" {
    pub fn hb_face_get_index(face: *const hb_face_t) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_face_set_upem(face: *mut hb_face_t, upem: ::std::os::raw::c_uint);
}
unsafe extern "C" {
    pub fn hb_face_get_upem(face: *const hb_face_t) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_face_set_glyph_count(face: *mut hb_face_t, glyph_count: ::std::os::raw::c_uint);
}
unsafe extern "C" {
    pub fn hb_face_get_glyph_count(face: *const hb_face_t) -> ::std::os::raw::c_uint;
}
pub type hb_get_table_tags_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        face: *const hb_face_t,
        start_offset: ::std::os::raw::c_uint,
        table_count: *mut ::std::os::raw::c_uint,
        table_tags: *mut hb_tag_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_uint,
>;
unsafe extern "C" {
    pub fn hb_face_set_get_table_tags_func(
        face: *mut hb_face_t,
        func: hb_get_table_tags_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_face_get_table_tags(
        face: *const hb_face_t,
        start_offset: ::std::os::raw::c_uint,
        table_count: *mut ::std::os::raw::c_uint,
        table_tags: *mut hb_tag_t,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_face_collect_unicodes(face: *mut hb_face_t, out: *mut hb_set_t);
}
unsafe extern "C" {
    pub fn hb_face_collect_nominal_glyph_mapping(
        face: *mut hb_face_t,
        mapping: *mut hb_map_t,
        unicodes: *mut hb_set_t,
    );
}
unsafe extern "C" {
    pub fn hb_face_collect_variation_selectors(face: *mut hb_face_t, out: *mut hb_set_t);
}
unsafe extern "C" {
    pub fn hb_face_collect_variation_unicodes(
        face: *mut hb_face_t,
        variation_selector: hb_codepoint_t,
        out: *mut hb_set_t,
    );
}
unsafe extern "C" {
    pub fn hb_face_builder_create() -> *mut hb_face_t;
}
unsafe extern "C" {
    pub fn hb_face_builder_add_table(
        face: *mut hb_face_t,
        tag: hb_tag_t,
        blob: *mut hb_blob_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_face_builder_sort_tables(face: *mut hb_face_t, tags: *const hb_tag_t);
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hb_draw_state_t {
    pub path_open: hb_bool_t,
    pub path_start_x: f32,
    pub path_start_y: f32,
    pub current_x: f32,
    pub current_y: f32,
    pub reserved1: hb_var_num_t,
    pub reserved2: hb_var_num_t,
    pub reserved3: hb_var_num_t,
    pub reserved4: hb_var_num_t,
    pub reserved5: hb_var_num_t,
    pub reserved6: hb_var_num_t,
    pub reserved7: hb_var_num_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_draw_funcs_t {
    _unused: [u8; 0],
}
pub type hb_draw_move_to_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        st: *mut hb_draw_state_t,
        to_x: f32,
        to_y: f32,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
pub type hb_draw_line_to_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        st: *mut hb_draw_state_t,
        to_x: f32,
        to_y: f32,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
pub type hb_draw_quadratic_to_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        st: *mut hb_draw_state_t,
        control_x: f32,
        control_y: f32,
        to_x: f32,
        to_y: f32,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
pub type hb_draw_cubic_to_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        st: *mut hb_draw_state_t,
        control1_x: f32,
        control1_y: f32,
        control2_x: f32,
        control2_y: f32,
        to_x: f32,
        to_y: f32,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
pub type hb_draw_close_path_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        st: *mut hb_draw_state_t,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
unsafe extern "C" {
    pub fn hb_draw_funcs_set_move_to_func(
        dfuncs: *mut hb_draw_funcs_t,
        func: hb_draw_move_to_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_draw_funcs_set_line_to_func(
        dfuncs: *mut hb_draw_funcs_t,
        func: hb_draw_line_to_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_draw_funcs_set_quadratic_to_func(
        dfuncs: *mut hb_draw_funcs_t,
        func: hb_draw_quadratic_to_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_draw_funcs_set_cubic_to_func(
        dfuncs: *mut hb_draw_funcs_t,
        func: hb_draw_cubic_to_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_draw_funcs_set_close_path_func(
        dfuncs: *mut hb_draw_funcs_t,
        func: hb_draw_close_path_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_draw_funcs_create() -> *mut hb_draw_funcs_t;
}
unsafe extern "C" {
    pub fn hb_draw_funcs_get_empty() -> *mut hb_draw_funcs_t;
}
unsafe extern "C" {
    pub fn hb_draw_funcs_reference(dfuncs: *mut hb_draw_funcs_t) -> *mut hb_draw_funcs_t;
}
unsafe extern "C" {
    pub fn hb_draw_funcs_destroy(dfuncs: *mut hb_draw_funcs_t);
}
unsafe extern "C" {
    pub fn hb_draw_funcs_set_user_data(
        dfuncs: *mut hb_draw_funcs_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_draw_funcs_get_user_data(
        dfuncs: *const hb_draw_funcs_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    pub fn hb_draw_funcs_make_immutable(dfuncs: *mut hb_draw_funcs_t);
}
unsafe extern "C" {
    pub fn hb_draw_funcs_is_immutable(dfuncs: *mut hb_draw_funcs_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_draw_move_to(
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        st: *mut hb_draw_state_t,
        to_x: f32,
        to_y: f32,
    );
}
unsafe extern "C" {
    pub fn hb_draw_line_to(
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        st: *mut hb_draw_state_t,
        to_x: f32,
        to_y: f32,
    );
}
unsafe extern "C" {
    pub fn hb_draw_quadratic_to(
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        st: *mut hb_draw_state_t,
        control_x: f32,
        control_y: f32,
        to_x: f32,
        to_y: f32,
    );
}
unsafe extern "C" {
    pub fn hb_draw_cubic_to(
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        st: *mut hb_draw_state_t,
        control1_x: f32,
        control1_y: f32,
        control2_x: f32,
        control2_y: f32,
        to_x: f32,
        to_y: f32,
    );
}
unsafe extern "C" {
    pub fn hb_draw_close_path(
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        st: *mut hb_draw_state_t,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_paint_funcs_t {
    _unused: [u8; 0],
}
unsafe extern "C" {
    pub fn hb_paint_funcs_create() -> *mut hb_paint_funcs_t;
}
unsafe extern "C" {
    pub fn hb_paint_funcs_get_empty() -> *mut hb_paint_funcs_t;
}
unsafe extern "C" {
    pub fn hb_paint_funcs_reference(funcs: *mut hb_paint_funcs_t) -> *mut hb_paint_funcs_t;
}
unsafe extern "C" {
    pub fn hb_paint_funcs_destroy(funcs: *mut hb_paint_funcs_t);
}
unsafe extern "C" {
    pub fn hb_paint_funcs_set_user_data(
        funcs: *mut hb_paint_funcs_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_paint_funcs_get_user_data(
        funcs: *const hb_paint_funcs_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    pub fn hb_paint_funcs_make_immutable(funcs: *mut hb_paint_funcs_t);
}
unsafe extern "C" {
    pub fn hb_paint_funcs_is_immutable(funcs: *mut hb_paint_funcs_t) -> hb_bool_t;
}
pub type hb_paint_push_transform_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        xx: f32,
        yx: f32,
        xy: f32,
        yy: f32,
        dx: f32,
        dy: f32,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
pub type hb_paint_pop_transform_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
pub type hb_paint_color_glyph_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        font: *mut hb_font_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
pub type hb_paint_push_clip_glyph_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        font: *mut hb_font_t,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
pub type hb_paint_push_clip_rectangle_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        xmin: f32,
        ymin: f32,
        xmax: f32,
        ymax: f32,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
pub type hb_paint_pop_clip_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
pub type hb_paint_color_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        is_foreground: hb_bool_t,
        color: hb_color_t,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
pub type hb_paint_image_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        image: *mut hb_blob_t,
        width: ::std::os::raw::c_uint,
        height: ::std::os::raw::c_uint,
        format: hb_tag_t,
        slant: f32,
        extents: *mut hb_glyph_extents_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_color_stop_t {
    pub offset: f32,
    pub is_foreground: hb_bool_t,
    pub color: hb_color_t,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_paint_extend_t {
    HB_PAINT_EXTEND_PAD = 0,
    HB_PAINT_EXTEND_REPEAT = 1,
    HB_PAINT_EXTEND_REFLECT = 2,
}
pub type hb_color_line_get_color_stops_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        color_line: *mut hb_color_line_t,
        color_line_data: *mut ::std::os::raw::c_void,
        start: ::std::os::raw::c_uint,
        count: *mut ::std::os::raw::c_uint,
        color_stops: *mut hb_color_stop_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_uint,
>;
pub type hb_color_line_get_extend_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        color_line: *mut hb_color_line_t,
        color_line_data: *mut ::std::os::raw::c_void,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_paint_extend_t,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_color_line_t {
    pub data: *mut ::std::os::raw::c_void,
    pub get_color_stops: hb_color_line_get_color_stops_func_t,
    pub get_color_stops_user_data: *mut ::std::os::raw::c_void,
    pub get_extend: hb_color_line_get_extend_func_t,
    pub get_extend_user_data: *mut ::std::os::raw::c_void,
    pub reserved0: *mut ::std::os::raw::c_void,
    pub reserved1: *mut ::std::os::raw::c_void,
    pub reserved2: *mut ::std::os::raw::c_void,
    pub reserved3: *mut ::std::os::raw::c_void,
    pub reserved5: *mut ::std::os::raw::c_void,
    pub reserved6: *mut ::std::os::raw::c_void,
    pub reserved7: *mut ::std::os::raw::c_void,
    pub reserved8: *mut ::std::os::raw::c_void,
}
unsafe extern "C" {
    pub fn hb_color_line_get_color_stops(
        color_line: *mut hb_color_line_t,
        start: ::std::os::raw::c_uint,
        count: *mut ::std::os::raw::c_uint,
        color_stops: *mut hb_color_stop_t,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_color_line_get_extend(color_line: *mut hb_color_line_t) -> hb_paint_extend_t;
}
pub type hb_paint_linear_gradient_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        color_line: *mut hb_color_line_t,
        x0: f32,
        y0: f32,
        x1: f32,
        y1: f32,
        x2: f32,
        y2: f32,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
pub type hb_paint_radial_gradient_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        color_line: *mut hb_color_line_t,
        x0: f32,
        y0: f32,
        r0: f32,
        x1: f32,
        y1: f32,
        r1: f32,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
pub type hb_paint_sweep_gradient_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        color_line: *mut hb_color_line_t,
        x0: f32,
        y0: f32,
        start_angle: f32,
        end_angle: f32,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_paint_composite_mode_t {
    HB_PAINT_COMPOSITE_MODE_CLEAR = 0,
    HB_PAINT_COMPOSITE_MODE_SRC = 1,
    HB_PAINT_COMPOSITE_MODE_DEST = 2,
    HB_PAINT_COMPOSITE_MODE_SRC_OVER = 3,
    HB_PAINT_COMPOSITE_MODE_DEST_OVER = 4,
    HB_PAINT_COMPOSITE_MODE_SRC_IN = 5,
    HB_PAINT_COMPOSITE_MODE_DEST_IN = 6,
    HB_PAINT_COMPOSITE_MODE_SRC_OUT = 7,
    HB_PAINT_COMPOSITE_MODE_DEST_OUT = 8,
    HB_PAINT_COMPOSITE_MODE_SRC_ATOP = 9,
    HB_PAINT_COMPOSITE_MODE_DEST_ATOP = 10,
    HB_PAINT_COMPOSITE_MODE_XOR = 11,
    HB_PAINT_COMPOSITE_MODE_PLUS = 12,
    HB_PAINT_COMPOSITE_MODE_SCREEN = 13,
    HB_PAINT_COMPOSITE_MODE_OVERLAY = 14,
    HB_PAINT_COMPOSITE_MODE_DARKEN = 15,
    HB_PAINT_COMPOSITE_MODE_LIGHTEN = 16,
    HB_PAINT_COMPOSITE_MODE_COLOR_DODGE = 17,
    HB_PAINT_COMPOSITE_MODE_COLOR_BURN = 18,
    HB_PAINT_COMPOSITE_MODE_HARD_LIGHT = 19,
    HB_PAINT_COMPOSITE_MODE_SOFT_LIGHT = 20,
    HB_PAINT_COMPOSITE_MODE_DIFFERENCE = 21,
    HB_PAINT_COMPOSITE_MODE_EXCLUSION = 22,
    HB_PAINT_COMPOSITE_MODE_MULTIPLY = 23,
    HB_PAINT_COMPOSITE_MODE_HSL_HUE = 24,
    HB_PAINT_COMPOSITE_MODE_HSL_SATURATION = 25,
    HB_PAINT_COMPOSITE_MODE_HSL_COLOR = 26,
    HB_PAINT_COMPOSITE_MODE_HSL_LUMINOSITY = 27,
}
pub type hb_paint_push_group_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
pub type hb_paint_pop_group_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        mode: hb_paint_composite_mode_t,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
pub type hb_paint_custom_palette_color_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        color_index: ::std::os::raw::c_uint,
        color: *mut hb_color_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
unsafe extern "C" {
    pub fn hb_paint_funcs_set_push_transform_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_push_transform_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_paint_funcs_set_pop_transform_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_pop_transform_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_paint_funcs_set_color_glyph_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_color_glyph_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_paint_funcs_set_push_clip_glyph_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_push_clip_glyph_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_paint_funcs_set_push_clip_rectangle_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_push_clip_rectangle_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_paint_funcs_set_pop_clip_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_pop_clip_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_paint_funcs_set_color_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_color_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_paint_funcs_set_image_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_image_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_paint_funcs_set_linear_gradient_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_linear_gradient_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_paint_funcs_set_radial_gradient_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_radial_gradient_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_paint_funcs_set_sweep_gradient_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_sweep_gradient_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_paint_funcs_set_push_group_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_push_group_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_paint_funcs_set_pop_group_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_pop_group_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_paint_funcs_set_custom_palette_color_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_custom_palette_color_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_paint_push_transform(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        xx: f32,
        yx: f32,
        xy: f32,
        yy: f32,
        dx: f32,
        dy: f32,
    );
}
unsafe extern "C" {
    pub fn hb_paint_pop_transform(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
    );
}
unsafe extern "C" {
    pub fn hb_paint_color_glyph(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        font: *mut hb_font_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_paint_push_clip_glyph(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        font: *mut hb_font_t,
    );
}
unsafe extern "C" {
    pub fn hb_paint_push_clip_rectangle(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        xmin: f32,
        ymin: f32,
        xmax: f32,
        ymax: f32,
    );
}
unsafe extern "C" {
    pub fn hb_paint_pop_clip(funcs: *mut hb_paint_funcs_t, paint_data: *mut ::std::os::raw::c_void);
}
unsafe extern "C" {
    pub fn hb_paint_color(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        is_foreground: hb_bool_t,
        color: hb_color_t,
    );
}
unsafe extern "C" {
    pub fn hb_paint_image(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        image: *mut hb_blob_t,
        width: ::std::os::raw::c_uint,
        height: ::std::os::raw::c_uint,
        format: hb_tag_t,
        slant: f32,
        extents: *mut hb_glyph_extents_t,
    );
}
unsafe extern "C" {
    pub fn hb_paint_linear_gradient(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        color_line: *mut hb_color_line_t,
        x0: f32,
        y0: f32,
        x1: f32,
        y1: f32,
        x2: f32,
        y2: f32,
    );
}
unsafe extern "C" {
    pub fn hb_paint_radial_gradient(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        color_line: *mut hb_color_line_t,
        x0: f32,
        y0: f32,
        r0: f32,
        x1: f32,
        y1: f32,
        r1: f32,
    );
}
unsafe extern "C" {
    pub fn hb_paint_sweep_gradient(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        color_line: *mut hb_color_line_t,
        x0: f32,
        y0: f32,
        start_angle: f32,
        end_angle: f32,
    );
}
unsafe extern "C" {
    pub fn hb_paint_push_group(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
    );
}
unsafe extern "C" {
    pub fn hb_paint_pop_group(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        mode: hb_paint_composite_mode_t,
    );
}
unsafe extern "C" {
    pub fn hb_paint_custom_palette_color(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        color_index: ::std::os::raw::c_uint,
        color: *mut hb_color_t,
    ) -> hb_bool_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_font_funcs_t {
    _unused: [u8; 0],
}
unsafe extern "C" {
    pub fn hb_font_funcs_create() -> *mut hb_font_funcs_t;
}
unsafe extern "C" {
    pub fn hb_font_funcs_get_empty() -> *mut hb_font_funcs_t;
}
unsafe extern "C" {
    pub fn hb_font_funcs_reference(ffuncs: *mut hb_font_funcs_t) -> *mut hb_font_funcs_t;
}
unsafe extern "C" {
    pub fn hb_font_funcs_destroy(ffuncs: *mut hb_font_funcs_t);
}
unsafe extern "C" {
    pub fn hb_font_funcs_set_user_data(
        ffuncs: *mut hb_font_funcs_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_font_funcs_get_user_data(
        ffuncs: *const hb_font_funcs_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    pub fn hb_font_funcs_make_immutable(ffuncs: *mut hb_font_funcs_t);
}
unsafe extern "C" {
    pub fn hb_font_funcs_is_immutable(ffuncs: *mut hb_font_funcs_t) -> hb_bool_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_font_extents_t {
    pub ascender: hb_position_t,
    pub descender: hb_position_t,
    pub line_gap: hb_position_t,
    pub reserved9: hb_position_t,
    pub reserved8: hb_position_t,
    pub reserved7: hb_position_t,
    pub reserved6: hb_position_t,
    pub reserved5: hb_position_t,
    pub reserved4: hb_position_t,
    pub reserved3: hb_position_t,
    pub reserved2: hb_position_t,
    pub reserved1: hb_position_t,
}
pub type hb_font_get_font_extents_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        extents: *mut hb_font_extents_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
pub type hb_font_get_font_h_extents_func_t = hb_font_get_font_extents_func_t;
pub type hb_font_get_font_v_extents_func_t = hb_font_get_font_extents_func_t;
pub type hb_font_get_nominal_glyph_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        unicode: hb_codepoint_t,
        glyph: *mut hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
pub type hb_font_get_variation_glyph_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        unicode: hb_codepoint_t,
        variation_selector: hb_codepoint_t,
        glyph: *mut hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
pub type hb_font_get_nominal_glyphs_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        count: ::std::os::raw::c_uint,
        first_unicode: *const hb_codepoint_t,
        unicode_stride: ::std::os::raw::c_uint,
        first_glyph: *mut hb_codepoint_t,
        glyph_stride: ::std::os::raw::c_uint,
        user_data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_uint,
>;
pub type hb_font_get_glyph_advance_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_position_t,
>;
pub type hb_font_get_glyph_h_advance_func_t = hb_font_get_glyph_advance_func_t;
pub type hb_font_get_glyph_v_advance_func_t = hb_font_get_glyph_advance_func_t;
pub type hb_font_get_glyph_advances_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        count: ::std::os::raw::c_uint,
        first_glyph: *const hb_codepoint_t,
        glyph_stride: ::std::os::raw::c_uint,
        first_advance: *mut hb_position_t,
        advance_stride: ::std::os::raw::c_uint,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
pub type hb_font_get_glyph_h_advances_func_t = hb_font_get_glyph_advances_func_t;
pub type hb_font_get_glyph_v_advances_func_t = hb_font_get_glyph_advances_func_t;
pub type hb_font_get_glyph_origin_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
pub type hb_font_get_glyph_h_origin_func_t = hb_font_get_glyph_origin_func_t;
pub type hb_font_get_glyph_v_origin_func_t = hb_font_get_glyph_origin_func_t;
pub type hb_font_get_glyph_kerning_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        first_glyph: hb_codepoint_t,
        second_glyph: hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_position_t,
>;
pub type hb_font_get_glyph_h_kerning_func_t = hb_font_get_glyph_kerning_func_t;
pub type hb_font_get_glyph_extents_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        extents: *mut hb_glyph_extents_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
pub type hb_font_get_glyph_contour_point_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        point_index: ::std::os::raw::c_uint,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
pub type hb_font_get_glyph_name_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        name: *mut ::std::os::raw::c_char,
        size: ::std::os::raw::c_uint,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
pub type hb_font_get_glyph_from_name_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        glyph: *mut hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
pub type hb_font_draw_glyph_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        draw_funcs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
pub type hb_font_paint_glyph_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        paint_funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        palette_index: ::std::os::raw::c_uint,
        foreground: hb_color_t,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
unsafe extern "C" {
    pub fn hb_font_funcs_set_font_h_extents_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_font_h_extents_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_funcs_set_font_v_extents_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_font_v_extents_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_funcs_set_nominal_glyph_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_nominal_glyph_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_funcs_set_nominal_glyphs_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_nominal_glyphs_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_funcs_set_variation_glyph_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_variation_glyph_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_funcs_set_glyph_h_advance_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_h_advance_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_funcs_set_glyph_v_advance_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_v_advance_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_funcs_set_glyph_h_advances_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_h_advances_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_funcs_set_glyph_v_advances_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_v_advances_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_funcs_set_glyph_h_origin_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_h_origin_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_funcs_set_glyph_v_origin_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_v_origin_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_funcs_set_glyph_h_kerning_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_h_kerning_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_funcs_set_glyph_extents_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_extents_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_funcs_set_glyph_contour_point_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_contour_point_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_funcs_set_glyph_name_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_name_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_funcs_set_glyph_from_name_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_from_name_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_funcs_set_draw_glyph_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_draw_glyph_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_funcs_set_paint_glyph_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_paint_glyph_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_get_h_extents(
        font: *mut hb_font_t,
        extents: *mut hb_font_extents_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_font_get_v_extents(
        font: *mut hb_font_t,
        extents: *mut hb_font_extents_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_font_get_nominal_glyph(
        font: *mut hb_font_t,
        unicode: hb_codepoint_t,
        glyph: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_font_get_variation_glyph(
        font: *mut hb_font_t,
        unicode: hb_codepoint_t,
        variation_selector: hb_codepoint_t,
        glyph: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_font_get_nominal_glyphs(
        font: *mut hb_font_t,
        count: ::std::os::raw::c_uint,
        first_unicode: *const hb_codepoint_t,
        unicode_stride: ::std::os::raw::c_uint,
        first_glyph: *mut hb_codepoint_t,
        glyph_stride: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_font_get_glyph_h_advance(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
    ) -> hb_position_t;
}
unsafe extern "C" {
    pub fn hb_font_get_glyph_v_advance(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
    ) -> hb_position_t;
}
unsafe extern "C" {
    pub fn hb_font_get_glyph_h_advances(
        font: *mut hb_font_t,
        count: ::std::os::raw::c_uint,
        first_glyph: *const hb_codepoint_t,
        glyph_stride: ::std::os::raw::c_uint,
        first_advance: *mut hb_position_t,
        advance_stride: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn hb_font_get_glyph_v_advances(
        font: *mut hb_font_t,
        count: ::std::os::raw::c_uint,
        first_glyph: *const hb_codepoint_t,
        glyph_stride: ::std::os::raw::c_uint,
        first_advance: *mut hb_position_t,
        advance_stride: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn hb_font_get_glyph_h_origin(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_font_get_glyph_v_origin(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_font_get_glyph_h_kerning(
        font: *mut hb_font_t,
        left_glyph: hb_codepoint_t,
        right_glyph: hb_codepoint_t,
    ) -> hb_position_t;
}
unsafe extern "C" {
    pub fn hb_font_get_glyph_extents(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        extents: *mut hb_glyph_extents_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_font_get_glyph_contour_point(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        point_index: ::std::os::raw::c_uint,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_font_get_glyph_name(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        name: *mut ::std::os::raw::c_char,
        size: ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_font_get_glyph_from_name(
        font: *mut hb_font_t,
        name: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        glyph: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_font_draw_glyph(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
    );
}
unsafe extern "C" {
    pub fn hb_font_paint_glyph(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        pfuncs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        palette_index: ::std::os::raw::c_uint,
        foreground: hb_color_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_get_glyph(
        font: *mut hb_font_t,
        unicode: hb_codepoint_t,
        variation_selector: hb_codepoint_t,
        glyph: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_font_get_extents_for_direction(
        font: *mut hb_font_t,
        direction: hb_direction_t,
        extents: *mut hb_font_extents_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_get_glyph_advance_for_direction(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        direction: hb_direction_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_get_glyph_advances_for_direction(
        font: *mut hb_font_t,
        direction: hb_direction_t,
        count: ::std::os::raw::c_uint,
        first_glyph: *const hb_codepoint_t,
        glyph_stride: ::std::os::raw::c_uint,
        first_advance: *mut hb_position_t,
        advance_stride: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn hb_font_get_glyph_origin_for_direction(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        direction: hb_direction_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_add_glyph_origin_for_direction(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        direction: hb_direction_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_subtract_glyph_origin_for_direction(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        direction: hb_direction_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_get_glyph_kerning_for_direction(
        font: *mut hb_font_t,
        first_glyph: hb_codepoint_t,
        second_glyph: hb_codepoint_t,
        direction: hb_direction_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_get_glyph_extents_for_origin(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        direction: hb_direction_t,
        extents: *mut hb_glyph_extents_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_font_get_glyph_contour_point_for_origin(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        point_index: ::std::os::raw::c_uint,
        direction: hb_direction_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_font_glyph_to_string(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        s: *mut ::std::os::raw::c_char,
        size: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn hb_font_glyph_from_string(
        font: *mut hb_font_t,
        s: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        glyph: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_font_create(face: *mut hb_face_t) -> *mut hb_font_t;
}
unsafe extern "C" {
    pub fn hb_font_create_sub_font(parent: *mut hb_font_t) -> *mut hb_font_t;
}
unsafe extern "C" {
    pub fn hb_font_get_empty() -> *mut hb_font_t;
}
unsafe extern "C" {
    pub fn hb_font_reference(font: *mut hb_font_t) -> *mut hb_font_t;
}
unsafe extern "C" {
    pub fn hb_font_destroy(font: *mut hb_font_t);
}
unsafe extern "C" {
    pub fn hb_font_set_user_data(
        font: *mut hb_font_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_font_get_user_data(
        font: *const hb_font_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    pub fn hb_font_make_immutable(font: *mut hb_font_t);
}
unsafe extern "C" {
    pub fn hb_font_is_immutable(font: *mut hb_font_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_font_get_serial(font: *mut hb_font_t) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_font_changed(font: *mut hb_font_t);
}
unsafe extern "C" {
    pub fn hb_font_set_parent(font: *mut hb_font_t, parent: *mut hb_font_t);
}
unsafe extern "C" {
    pub fn hb_font_get_parent(font: *mut hb_font_t) -> *mut hb_font_t;
}
unsafe extern "C" {
    pub fn hb_font_set_face(font: *mut hb_font_t, face: *mut hb_face_t);
}
unsafe extern "C" {
    pub fn hb_font_get_face(font: *mut hb_font_t) -> *mut hb_face_t;
}
unsafe extern "C" {
    pub fn hb_font_set_funcs(
        font: *mut hb_font_t,
        klass: *mut hb_font_funcs_t,
        font_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_set_funcs_data(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_set_scale(
        font: *mut hb_font_t,
        x_scale: ::std::os::raw::c_int,
        y_scale: ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    pub fn hb_font_get_scale(
        font: *mut hb_font_t,
        x_scale: *mut ::std::os::raw::c_int,
        y_scale: *mut ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    pub fn hb_font_set_ppem(
        font: *mut hb_font_t,
        x_ppem: ::std::os::raw::c_uint,
        y_ppem: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn hb_font_get_ppem(
        font: *mut hb_font_t,
        x_ppem: *mut ::std::os::raw::c_uint,
        y_ppem: *mut ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn hb_font_set_ptem(font: *mut hb_font_t, ptem: f32);
}
unsafe extern "C" {
    pub fn hb_font_get_ptem(font: *mut hb_font_t) -> f32;
}
unsafe extern "C" {
    pub fn hb_font_set_synthetic_bold(
        font: *mut hb_font_t,
        x_embolden: f32,
        y_embolden: f32,
        in_place: hb_bool_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_get_synthetic_bold(
        font: *mut hb_font_t,
        x_embolden: *mut f32,
        y_embolden: *mut f32,
        in_place: *mut hb_bool_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_set_synthetic_slant(font: *mut hb_font_t, slant: f32);
}
unsafe extern "C" {
    pub fn hb_font_get_synthetic_slant(font: *mut hb_font_t) -> f32;
}
unsafe extern "C" {
    pub fn hb_font_set_variations(
        font: *mut hb_font_t,
        variations: *const hb_variation_t,
        variations_length: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn hb_font_set_variation(font: *mut hb_font_t, tag: hb_tag_t, value: f32);
}
unsafe extern "C" {
    pub fn hb_font_set_var_coords_design(
        font: *mut hb_font_t,
        coords: *const f32,
        coords_length: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn hb_font_get_var_coords_design(
        font: *mut hb_font_t,
        length: *mut ::std::os::raw::c_uint,
    ) -> *const f32;
}
unsafe extern "C" {
    pub fn hb_font_set_var_coords_normalized(
        font: *mut hb_font_t,
        coords: *const ::std::os::raw::c_int,
        coords_length: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn hb_font_get_var_coords_normalized(
        font: *mut hb_font_t,
        length: *mut ::std::os::raw::c_uint,
    ) -> *const ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn hb_font_set_var_named_instance(
        font: *mut hb_font_t,
        instance_index: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn hb_font_get_var_named_instance(font: *mut hb_font_t) -> ::std::os::raw::c_uint;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hb_glyph_info_t {
    pub codepoint: hb_codepoint_t,
    pub mask: hb_mask_t,
    pub cluster: u32,
    pub var1: hb_var_int_t,
    pub var2: hb_var_int_t,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_glyph_flags_t {
    HB_GLYPH_FLAG_UNSAFE_TO_BREAK = 1,
    HB_GLYPH_FLAG_UNSAFE_TO_CONCAT = 2,
    HB_GLYPH_FLAG_SAFE_TO_INSERT_TATWEEL = 4,
    HB_GLYPH_FLAG_DEFINED = 7,
}
unsafe extern "C" {
    pub fn hb_glyph_info_get_glyph_flags(info: *const hb_glyph_info_t) -> hb_glyph_flags_t;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hb_glyph_position_t {
    pub x_advance: hb_position_t,
    pub y_advance: hb_position_t,
    pub x_offset: hb_position_t,
    pub y_offset: hb_position_t,
    pub var: hb_var_int_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_segment_properties_t {
    pub direction: hb_direction_t,
    pub script: hb_script_t,
    pub language: hb_language_t,
    pub reserved1: *mut ::std::os::raw::c_void,
    pub reserved2: *mut ::std::os::raw::c_void,
}
unsafe extern "C" {
    pub fn hb_segment_properties_equal(
        a: *const hb_segment_properties_t,
        b: *const hb_segment_properties_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_segment_properties_hash(p: *const hb_segment_properties_t) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_segment_properties_overlay(
        p: *mut hb_segment_properties_t,
        src: *const hb_segment_properties_t,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_buffer_t {
    _unused: [u8; 0],
}
unsafe extern "C" {
    pub fn hb_buffer_create() -> *mut hb_buffer_t;
}
unsafe extern "C" {
    pub fn hb_buffer_create_similar(src: *const hb_buffer_t) -> *mut hb_buffer_t;
}
unsafe extern "C" {
    pub fn hb_buffer_reset(buffer: *mut hb_buffer_t);
}
unsafe extern "C" {
    pub fn hb_buffer_get_empty() -> *mut hb_buffer_t;
}
unsafe extern "C" {
    pub fn hb_buffer_reference(buffer: *mut hb_buffer_t) -> *mut hb_buffer_t;
}
unsafe extern "C" {
    pub fn hb_buffer_destroy(buffer: *mut hb_buffer_t);
}
unsafe extern "C" {
    pub fn hb_buffer_set_user_data(
        buffer: *mut hb_buffer_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_buffer_get_user_data(
        buffer: *const hb_buffer_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_buffer_content_type_t {
    HB_BUFFER_CONTENT_TYPE_INVALID = 0,
    HB_BUFFER_CONTENT_TYPE_UNICODE = 1,
    HB_BUFFER_CONTENT_TYPE_GLYPHS = 2,
}
unsafe extern "C" {
    pub fn hb_buffer_set_content_type(
        buffer: *mut hb_buffer_t,
        content_type: hb_buffer_content_type_t,
    );
}
unsafe extern "C" {
    pub fn hb_buffer_get_content_type(buffer: *const hb_buffer_t) -> hb_buffer_content_type_t;
}
unsafe extern "C" {
    pub fn hb_buffer_set_unicode_funcs(
        buffer: *mut hb_buffer_t,
        unicode_funcs: *mut hb_unicode_funcs_t,
    );
}
unsafe extern "C" {
    pub fn hb_buffer_get_unicode_funcs(buffer: *const hb_buffer_t) -> *mut hb_unicode_funcs_t;
}
unsafe extern "C" {
    pub fn hb_buffer_set_direction(buffer: *mut hb_buffer_t, direction: hb_direction_t);
}
unsafe extern "C" {
    pub fn hb_buffer_get_direction(buffer: *const hb_buffer_t) -> hb_direction_t;
}
unsafe extern "C" {
    pub fn hb_buffer_set_script(buffer: *mut hb_buffer_t, script: hb_script_t);
}
unsafe extern "C" {
    pub fn hb_buffer_get_script(buffer: *const hb_buffer_t) -> hb_script_t;
}
unsafe extern "C" {
    pub fn hb_buffer_set_language(buffer: *mut hb_buffer_t, language: hb_language_t);
}
unsafe extern "C" {
    pub fn hb_buffer_get_language(buffer: *const hb_buffer_t) -> hb_language_t;
}
unsafe extern "C" {
    pub fn hb_buffer_set_segment_properties(
        buffer: *mut hb_buffer_t,
        props: *const hb_segment_properties_t,
    );
}
unsafe extern "C" {
    pub fn hb_buffer_get_segment_properties(
        buffer: *const hb_buffer_t,
        props: *mut hb_segment_properties_t,
    );
}
unsafe extern "C" {
    pub fn hb_buffer_guess_segment_properties(buffer: *mut hb_buffer_t);
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_buffer_flags_t {
    HB_BUFFER_FLAG_DEFAULT = 0,
    HB_BUFFER_FLAG_BOT = 1,
    HB_BUFFER_FLAG_EOT = 2,
    HB_BUFFER_FLAG_PRESERVE_DEFAULT_IGNORABLES = 4,
    HB_BUFFER_FLAG_REMOVE_DEFAULT_IGNORABLES = 8,
    HB_BUFFER_FLAG_DO_NOT_INSERT_DOTTED_CIRCLE = 16,
    HB_BUFFER_FLAG_VERIFY = 32,
    HB_BUFFER_FLAG_PRODUCE_UNSAFE_TO_CONCAT = 64,
    HB_BUFFER_FLAG_PRODUCE_SAFE_TO_INSERT_TATWEEL = 128,
    HB_BUFFER_FLAG_DEFINED = 255,
}
unsafe extern "C" {
    pub fn hb_buffer_set_flags(buffer: *mut hb_buffer_t, flags: hb_buffer_flags_t);
}
unsafe extern "C" {
    pub fn hb_buffer_get_flags(buffer: *const hb_buffer_t) -> hb_buffer_flags_t;
}
impl hb_buffer_cluster_level_t {
    pub const HB_BUFFER_CLUSTER_LEVEL_DEFAULT: hb_buffer_cluster_level_t =
        hb_buffer_cluster_level_t::HB_BUFFER_CLUSTER_LEVEL_MONOTONE_GRAPHEMES;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_buffer_cluster_level_t {
    HB_BUFFER_CLUSTER_LEVEL_MONOTONE_GRAPHEMES = 0,
    HB_BUFFER_CLUSTER_LEVEL_MONOTONE_CHARACTERS = 1,
    HB_BUFFER_CLUSTER_LEVEL_CHARACTERS = 2,
}
unsafe extern "C" {
    pub fn hb_buffer_set_cluster_level(
        buffer: *mut hb_buffer_t,
        cluster_level: hb_buffer_cluster_level_t,
    );
}
unsafe extern "C" {
    pub fn hb_buffer_get_cluster_level(buffer: *const hb_buffer_t) -> hb_buffer_cluster_level_t;
}
unsafe extern "C" {
    pub fn hb_buffer_set_replacement_codepoint(
        buffer: *mut hb_buffer_t,
        replacement: hb_codepoint_t,
    );
}
unsafe extern "C" {
    pub fn hb_buffer_get_replacement_codepoint(buffer: *const hb_buffer_t) -> hb_codepoint_t;
}
unsafe extern "C" {
    pub fn hb_buffer_set_invisible_glyph(buffer: *mut hb_buffer_t, invisible: hb_codepoint_t);
}
unsafe extern "C" {
    pub fn hb_buffer_get_invisible_glyph(buffer: *const hb_buffer_t) -> hb_codepoint_t;
}
unsafe extern "C" {
    pub fn hb_buffer_set_not_found_glyph(buffer: *mut hb_buffer_t, not_found: hb_codepoint_t);
}
unsafe extern "C" {
    pub fn hb_buffer_get_not_found_glyph(buffer: *const hb_buffer_t) -> hb_codepoint_t;
}
unsafe extern "C" {
    pub fn hb_buffer_set_not_found_variation_selector_glyph(
        buffer: *mut hb_buffer_t,
        not_found_variation_selector: hb_codepoint_t,
    );
}
unsafe extern "C" {
    pub fn hb_buffer_get_not_found_variation_selector_glyph(
        buffer: *const hb_buffer_t,
    ) -> hb_codepoint_t;
}
unsafe extern "C" {
    pub fn hb_buffer_set_random_state(buffer: *mut hb_buffer_t, state: ::std::os::raw::c_uint);
}
unsafe extern "C" {
    pub fn hb_buffer_get_random_state(buffer: *const hb_buffer_t) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_buffer_clear_contents(buffer: *mut hb_buffer_t);
}
unsafe extern "C" {
    pub fn hb_buffer_pre_allocate(
        buffer: *mut hb_buffer_t,
        size: ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_buffer_allocation_successful(buffer: *mut hb_buffer_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_buffer_reverse(buffer: *mut hb_buffer_t);
}
unsafe extern "C" {
    pub fn hb_buffer_reverse_range(
        buffer: *mut hb_buffer_t,
        start: ::std::os::raw::c_uint,
        end: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn hb_buffer_reverse_clusters(buffer: *mut hb_buffer_t);
}
unsafe extern "C" {
    pub fn hb_buffer_add(
        buffer: *mut hb_buffer_t,
        codepoint: hb_codepoint_t,
        cluster: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn hb_buffer_add_utf8(
        buffer: *mut hb_buffer_t,
        text: *const ::std::os::raw::c_char,
        text_length: ::std::os::raw::c_int,
        item_offset: ::std::os::raw::c_uint,
        item_length: ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    pub fn hb_buffer_add_utf16(
        buffer: *mut hb_buffer_t,
        text: *const u16,
        text_length: ::std::os::raw::c_int,
        item_offset: ::std::os::raw::c_uint,
        item_length: ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    pub fn hb_buffer_add_utf32(
        buffer: *mut hb_buffer_t,
        text: *const u32,
        text_length: ::std::os::raw::c_int,
        item_offset: ::std::os::raw::c_uint,
        item_length: ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    pub fn hb_buffer_add_latin1(
        buffer: *mut hb_buffer_t,
        text: *const u8,
        text_length: ::std::os::raw::c_int,
        item_offset: ::std::os::raw::c_uint,
        item_length: ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    pub fn hb_buffer_add_codepoints(
        buffer: *mut hb_buffer_t,
        text: *const hb_codepoint_t,
        text_length: ::std::os::raw::c_int,
        item_offset: ::std::os::raw::c_uint,
        item_length: ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    pub fn hb_buffer_append(
        buffer: *mut hb_buffer_t,
        source: *const hb_buffer_t,
        start: ::std::os::raw::c_uint,
        end: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn hb_buffer_set_length(
        buffer: *mut hb_buffer_t,
        length: ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_buffer_get_length(buffer: *const hb_buffer_t) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_buffer_get_glyph_infos(
        buffer: *mut hb_buffer_t,
        length: *mut ::std::os::raw::c_uint,
    ) -> *mut hb_glyph_info_t;
}
unsafe extern "C" {
    pub fn hb_buffer_get_glyph_positions(
        buffer: *mut hb_buffer_t,
        length: *mut ::std::os::raw::c_uint,
    ) -> *mut hb_glyph_position_t;
}
unsafe extern "C" {
    pub fn hb_buffer_has_positions(buffer: *mut hb_buffer_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_buffer_normalize_glyphs(buffer: *mut hb_buffer_t);
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_buffer_serialize_flags_t {
    HB_BUFFER_SERIALIZE_FLAG_DEFAULT = 0,
    HB_BUFFER_SERIALIZE_FLAG_NO_CLUSTERS = 1,
    HB_BUFFER_SERIALIZE_FLAG_NO_POSITIONS = 2,
    HB_BUFFER_SERIALIZE_FLAG_NO_GLYPH_NAMES = 4,
    HB_BUFFER_SERIALIZE_FLAG_GLYPH_EXTENTS = 8,
    HB_BUFFER_SERIALIZE_FLAG_GLYPH_FLAGS = 16,
    HB_BUFFER_SERIALIZE_FLAG_NO_ADVANCES = 32,
    HB_BUFFER_SERIALIZE_FLAG_DEFINED = 63,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_buffer_serialize_format_t {
    HB_BUFFER_SERIALIZE_FORMAT_TEXT = 1413830740,
    HB_BUFFER_SERIALIZE_FORMAT_JSON = 1246973774,
    HB_BUFFER_SERIALIZE_FORMAT_INVALID = 0,
}
unsafe extern "C" {
    pub fn hb_buffer_serialize_format_from_string(
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> hb_buffer_serialize_format_t;
}
unsafe extern "C" {
    pub fn hb_buffer_serialize_format_to_string(
        format: hb_buffer_serialize_format_t,
    ) -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn hb_buffer_serialize_list_formats() -> *mut *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn hb_buffer_serialize_glyphs(
        buffer: *mut hb_buffer_t,
        start: ::std::os::raw::c_uint,
        end: ::std::os::raw::c_uint,
        buf: *mut ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_uint,
        buf_consumed: *mut ::std::os::raw::c_uint,
        font: *mut hb_font_t,
        format: hb_buffer_serialize_format_t,
        flags: hb_buffer_serialize_flags_t,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_buffer_serialize_unicode(
        buffer: *mut hb_buffer_t,
        start: ::std::os::raw::c_uint,
        end: ::std::os::raw::c_uint,
        buf: *mut ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_uint,
        buf_consumed: *mut ::std::os::raw::c_uint,
        format: hb_buffer_serialize_format_t,
        flags: hb_buffer_serialize_flags_t,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_buffer_serialize(
        buffer: *mut hb_buffer_t,
        start: ::std::os::raw::c_uint,
        end: ::std::os::raw::c_uint,
        buf: *mut ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_uint,
        buf_consumed: *mut ::std::os::raw::c_uint,
        font: *mut hb_font_t,
        format: hb_buffer_serialize_format_t,
        flags: hb_buffer_serialize_flags_t,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_buffer_deserialize_glyphs(
        buffer: *mut hb_buffer_t,
        buf: *const ::std::os::raw::c_char,
        buf_len: ::std::os::raw::c_int,
        end_ptr: *mut *const ::std::os::raw::c_char,
        font: *mut hb_font_t,
        format: hb_buffer_serialize_format_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_buffer_deserialize_unicode(
        buffer: *mut hb_buffer_t,
        buf: *const ::std::os::raw::c_char,
        buf_len: ::std::os::raw::c_int,
        end_ptr: *mut *const ::std::os::raw::c_char,
        format: hb_buffer_serialize_format_t,
    ) -> hb_bool_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_buffer_diff_flags_t {
    HB_BUFFER_DIFF_FLAG_EQUAL = 0,
    HB_BUFFER_DIFF_FLAG_CONTENT_TYPE_MISMATCH = 1,
    HB_BUFFER_DIFF_FLAG_LENGTH_MISMATCH = 2,
    HB_BUFFER_DIFF_FLAG_NOTDEF_PRESENT = 4,
    HB_BUFFER_DIFF_FLAG_DOTTED_CIRCLE_PRESENT = 8,
    HB_BUFFER_DIFF_FLAG_CODEPOINT_MISMATCH = 16,
    HB_BUFFER_DIFF_FLAG_CLUSTER_MISMATCH = 32,
    HB_BUFFER_DIFF_FLAG_GLYPH_FLAGS_MISMATCH = 64,
    HB_BUFFER_DIFF_FLAG_POSITION_MISMATCH = 128,
}
unsafe extern "C" {
    pub fn hb_buffer_diff(
        buffer: *mut hb_buffer_t,
        reference: *mut hb_buffer_t,
        dottedcircle_glyph: hb_codepoint_t,
        position_fuzz: ::std::os::raw::c_uint,
    ) -> hb_buffer_diff_flags_t;
}
pub type hb_buffer_message_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        buffer: *mut hb_buffer_t,
        font: *mut hb_font_t,
        message: *const ::std::os::raw::c_char,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
unsafe extern "C" {
    pub fn hb_buffer_set_message_func(
        buffer: *mut hb_buffer_t,
        func: hb_buffer_message_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
pub type hb_font_get_glyph_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        unicode: hb_codepoint_t,
        variation_selector: hb_codepoint_t,
        glyph: *mut hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
unsafe extern "C" {
    pub fn hb_font_funcs_set_glyph_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
pub type hb_unicode_eastasian_width_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_uint,
>;
unsafe extern "C" {
    pub fn hb_unicode_funcs_set_eastasian_width_func(
        ufuncs: *mut hb_unicode_funcs_t,
        func: hb_unicode_eastasian_width_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_unicode_eastasian_width(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
    ) -> ::std::os::raw::c_uint;
}
pub type hb_unicode_decompose_compatibility_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        ufuncs: *mut hb_unicode_funcs_t,
        u: hb_codepoint_t,
        decomposed: *mut hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_uint,
>;
unsafe extern "C" {
    pub fn hb_unicode_funcs_set_decompose_compatibility_func(
        ufuncs: *mut hb_unicode_funcs_t,
        func: hb_unicode_decompose_compatibility_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_unicode_decompose_compatibility(
        ufuncs: *mut hb_unicode_funcs_t,
        u: hb_codepoint_t,
        decomposed: *mut hb_codepoint_t,
    ) -> ::std::os::raw::c_uint;
}
pub type hb_font_get_glyph_v_kerning_func_t = hb_font_get_glyph_kerning_func_t;
unsafe extern "C" {
    pub fn hb_font_funcs_set_glyph_v_kerning_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_v_kerning_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_get_glyph_v_kerning(
        font: *mut hb_font_t,
        top_glyph: hb_codepoint_t,
        bottom_glyph: hb_codepoint_t,
    ) -> hb_position_t;
}
pub type hb_font_get_glyph_shape_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        draw_funcs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
unsafe extern "C" {
    pub fn hb_font_funcs_set_glyph_shape_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_shape_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
unsafe extern "C" {
    pub fn hb_font_get_glyph_shape(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
    );
}
unsafe extern "C" {
    pub fn hb_shape(
        font: *mut hb_font_t,
        buffer: *mut hb_buffer_t,
        features: *const hb_feature_t,
        num_features: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn hb_shape_full(
        font: *mut hb_font_t,
        buffer: *mut hb_buffer_t,
        features: *const hb_feature_t,
        num_features: ::std::os::raw::c_uint,
        shaper_list: *const *const ::std::os::raw::c_char,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_shape_list_shapers() -> *mut *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_shape_plan_t {
    _unused: [u8; 0],
}
unsafe extern "C" {
    pub fn hb_shape_plan_create(
        face: *mut hb_face_t,
        props: *const hb_segment_properties_t,
        user_features: *const hb_feature_t,
        num_user_features: ::std::os::raw::c_uint,
        shaper_list: *const *const ::std::os::raw::c_char,
    ) -> *mut hb_shape_plan_t;
}
unsafe extern "C" {
    pub fn hb_shape_plan_create_cached(
        face: *mut hb_face_t,
        props: *const hb_segment_properties_t,
        user_features: *const hb_feature_t,
        num_user_features: ::std::os::raw::c_uint,
        shaper_list: *const *const ::std::os::raw::c_char,
    ) -> *mut hb_shape_plan_t;
}
unsafe extern "C" {
    pub fn hb_shape_plan_create2(
        face: *mut hb_face_t,
        props: *const hb_segment_properties_t,
        user_features: *const hb_feature_t,
        num_user_features: ::std::os::raw::c_uint,
        coords: *const ::std::os::raw::c_int,
        num_coords: ::std::os::raw::c_uint,
        shaper_list: *const *const ::std::os::raw::c_char,
    ) -> *mut hb_shape_plan_t;
}
unsafe extern "C" {
    pub fn hb_shape_plan_create_cached2(
        face: *mut hb_face_t,
        props: *const hb_segment_properties_t,
        user_features: *const hb_feature_t,
        num_user_features: ::std::os::raw::c_uint,
        coords: *const ::std::os::raw::c_int,
        num_coords: ::std::os::raw::c_uint,
        shaper_list: *const *const ::std::os::raw::c_char,
    ) -> *mut hb_shape_plan_t;
}
unsafe extern "C" {
    pub fn hb_shape_plan_get_empty() -> *mut hb_shape_plan_t;
}
unsafe extern "C" {
    pub fn hb_shape_plan_reference(shape_plan: *mut hb_shape_plan_t) -> *mut hb_shape_plan_t;
}
unsafe extern "C" {
    pub fn hb_shape_plan_destroy(shape_plan: *mut hb_shape_plan_t);
}
unsafe extern "C" {
    pub fn hb_shape_plan_set_user_data(
        shape_plan: *mut hb_shape_plan_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_shape_plan_get_user_data(
        shape_plan: *const hb_shape_plan_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    pub fn hb_shape_plan_execute(
        shape_plan: *mut hb_shape_plan_t,
        font: *mut hb_font_t,
        buffer: *mut hb_buffer_t,
        features: *const hb_feature_t,
        num_features: ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_shape_plan_get_shaper(
        shape_plan: *mut hb_shape_plan_t,
    ) -> *const ::std::os::raw::c_char;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_style_tag_t {
    HB_STYLE_TAG_ITALIC = 1769234796,
    HB_STYLE_TAG_OPTICAL_SIZE = 1869640570,
    HB_STYLE_TAG_SLANT_ANGLE = 1936486004,
    HB_STYLE_TAG_SLANT_RATIO = 1399615092,
    HB_STYLE_TAG_WIDTH = 2003072104,
    HB_STYLE_TAG_WEIGHT = 2003265652,
    _HB_STYLE_TAG_MAX_VALUE = 2147483647,
}
unsafe extern "C" {
    pub fn hb_style_get_value(font: *mut hb_font_t, style_tag: hb_style_tag_t) -> f32;
}
unsafe extern "C" {
    pub fn hb_version(
        major: *mut ::std::os::raw::c_uint,
        minor: *mut ::std::os::raw::c_uint,
        micro: *mut ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn hb_version_string() -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn hb_version_atleast(
        major: ::std::os::raw::c_uint,
        minor: ::std::os::raw::c_uint,
        micro: ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
pub type FT_Memory = *mut FT_MemoryRec_;
pub type FT_Alloc_Func = ::std::option::Option<
    unsafe extern "C" fn(
        memory: FT_Memory,
        size: ::std::os::raw::c_long,
    ) -> *mut ::std::os::raw::c_void,
>;
pub type FT_Free_Func = ::std::option::Option<
    unsafe extern "C" fn(memory: FT_Memory, block: *mut ::std::os::raw::c_void),
>;
pub type FT_Realloc_Func = ::std::option::Option<
    unsafe extern "C" fn(
        memory: FT_Memory,
        cur_size: ::std::os::raw::c_long,
        new_size: ::std::os::raw::c_long,
        block: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FT_MemoryRec_ {
    pub user: *mut ::std::os::raw::c_void,
    pub alloc: FT_Alloc_Func,
    pub free: FT_Free_Func,
    pub realloc: FT_Realloc_Func,
}
pub type FT_Stream = *mut FT_StreamRec_;
#[repr(C)]
#[derive(Copy, Clone)]
pub union FT_StreamDesc_ {
    pub value: ::std::os::raw::c_long,
    pub pointer: *mut ::std::os::raw::c_void,
}
pub type FT_StreamDesc = FT_StreamDesc_;
pub type FT_Stream_IoFunc = ::std::option::Option<
    unsafe extern "C" fn(
        stream: FT_Stream,
        offset: ::std::os::raw::c_ulong,
        buffer: *mut ::std::os::raw::c_uchar,
        count: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong,
>;
pub type FT_Stream_CloseFunc = ::std::option::Option<unsafe extern "C" fn(stream: FT_Stream)>;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct FT_StreamRec_ {
    pub base: *mut ::std::os::raw::c_uchar,
    pub size: ::std::os::raw::c_ulong,
    pub pos: ::std::os::raw::c_ulong,
    pub descriptor: FT_StreamDesc,
    pub pathname: FT_StreamDesc,
    pub read: FT_Stream_IoFunc,
    pub close: FT_Stream_CloseFunc,
    pub memory: FT_Memory,
    pub cursor: *mut ::std::os::raw::c_uchar,
    pub limit: *mut ::std::os::raw::c_uchar,
}
pub type FT_Pos = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FT_Vector_ {
    pub x: FT_Pos,
    pub y: FT_Pos,
}
pub type FT_Vector = FT_Vector_;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FT_BBox_ {
    pub xMin: FT_Pos,
    pub yMin: FT_Pos,
    pub xMax: FT_Pos,
    pub yMax: FT_Pos,
}
pub type FT_BBox = FT_BBox_;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FT_Bitmap_ {
    pub rows: ::std::os::raw::c_uint,
    pub width: ::std::os::raw::c_uint,
    pub pitch: ::std::os::raw::c_int,
    pub buffer: *mut ::std::os::raw::c_uchar,
    pub num_grays: ::std::os::raw::c_ushort,
    pub pixel_mode: ::std::os::raw::c_uchar,
    pub palette_mode: ::std::os::raw::c_uchar,
    pub palette: *mut ::std::os::raw::c_void,
}
pub type FT_Bitmap = FT_Bitmap_;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FT_Outline_ {
    pub n_contours: ::std::os::raw::c_ushort,
    pub n_points: ::std::os::raw::c_ushort,
    pub points: *mut FT_Vector,
    pub tags: *mut ::std::os::raw::c_uchar,
    pub contours: *mut ::std::os::raw::c_ushort,
    pub flags: ::std::os::raw::c_int,
}
pub type FT_Outline = FT_Outline_;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum FT_Glyph_Format_ {
    FT_GLYPH_FORMAT_NONE = 0,
    FT_GLYPH_FORMAT_COMPOSITE = 1668246896,
    FT_GLYPH_FORMAT_BITMAP = 1651078259,
    FT_GLYPH_FORMAT_OUTLINE = 1869968492,
    FT_GLYPH_FORMAT_PLOTTER = 1886154612,
    FT_GLYPH_FORMAT_SVG = 1398163232,
}
pub use self::FT_Glyph_Format_ as FT_Glyph_Format;
pub type FT_String = ::std::os::raw::c_char;
pub type FT_Short = ::std::os::raw::c_short;
pub type FT_UShort = ::std::os::raw::c_ushort;
pub type FT_Int = ::std::os::raw::c_int;
pub type FT_UInt = ::std::os::raw::c_uint;
pub type FT_Long = ::std::os::raw::c_long;
pub type FT_Fixed = ::std::os::raw::c_long;
pub type FT_Generic_Finalizer =
    ::std::option::Option<unsafe extern "C" fn(object: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FT_Generic_ {
    pub data: *mut ::std::os::raw::c_void,
    pub finalizer: FT_Generic_Finalizer,
}
pub type FT_Generic = FT_Generic_;
pub type FT_ListNode = *mut FT_ListNodeRec_;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FT_ListNodeRec_ {
    pub prev: FT_ListNode,
    pub next: FT_ListNode,
    pub data: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FT_ListRec_ {
    pub head: FT_ListNode,
    pub tail: FT_ListNode,
}
pub type FT_ListRec = FT_ListRec_;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FT_Glyph_Metrics_ {
    pub width: FT_Pos,
    pub height: FT_Pos,
    pub horiBearingX: FT_Pos,
    pub horiBearingY: FT_Pos,
    pub horiAdvance: FT_Pos,
    pub vertBearingX: FT_Pos,
    pub vertBearingY: FT_Pos,
    pub vertAdvance: FT_Pos,
}
pub type FT_Glyph_Metrics = FT_Glyph_Metrics_;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FT_Bitmap_Size_ {
    pub height: FT_Short,
    pub width: FT_Short,
    pub size: FT_Pos,
    pub x_ppem: FT_Pos,
    pub y_ppem: FT_Pos,
}
pub type FT_Bitmap_Size = FT_Bitmap_Size_;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FT_LibraryRec_ {
    _unused: [u8; 0],
}
pub type FT_Library = *mut FT_LibraryRec_;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FT_DriverRec_ {
    _unused: [u8; 0],
}
pub type FT_Driver = *mut FT_DriverRec_;
pub type FT_Face = *mut FT_FaceRec_;
pub type FT_Size = *mut FT_SizeRec_;
pub type FT_GlyphSlot = *mut FT_GlyphSlotRec_;
pub type FT_CharMap = *mut FT_CharMapRec_;
impl FT_Encoding_ {
    pub const FT_ENCODING_GB2312: FT_Encoding_ = FT_Encoding_::FT_ENCODING_PRC;
}
impl FT_Encoding_ {
    pub const FT_ENCODING_MS_SJIS: FT_Encoding_ = FT_Encoding_::FT_ENCODING_SJIS;
}
impl FT_Encoding_ {
    pub const FT_ENCODING_MS_GB2312: FT_Encoding_ = FT_Encoding_::FT_ENCODING_PRC;
}
impl FT_Encoding_ {
    pub const FT_ENCODING_MS_BIG5: FT_Encoding_ = FT_Encoding_::FT_ENCODING_BIG5;
}
impl FT_Encoding_ {
    pub const FT_ENCODING_MS_WANSUNG: FT_Encoding_ = FT_Encoding_::FT_ENCODING_WANSUNG;
}
impl FT_Encoding_ {
    pub const FT_ENCODING_MS_JOHAB: FT_Encoding_ = FT_Encoding_::FT_ENCODING_JOHAB;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum FT_Encoding_ {
    FT_ENCODING_NONE = 0,
    FT_ENCODING_MS_SYMBOL = 1937337698,
    FT_ENCODING_UNICODE = 1970170211,
    FT_ENCODING_SJIS = 1936353651,
    FT_ENCODING_PRC = 1734484000,
    FT_ENCODING_BIG5 = 1651074869,
    FT_ENCODING_WANSUNG = 2002873971,
    FT_ENCODING_JOHAB = 1785686113,
    FT_ENCODING_ADOBE_STANDARD = 1094995778,
    FT_ENCODING_ADOBE_EXPERT = 1094992453,
    FT_ENCODING_ADOBE_CUSTOM = 1094992451,
    FT_ENCODING_ADOBE_LATIN_1 = 1818326065,
    FT_ENCODING_OLD_LATIN_2 = 1818326066,
    FT_ENCODING_APPLE_ROMAN = 1634889070,
}
pub use self::FT_Encoding_ as FT_Encoding;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FT_CharMapRec_ {
    pub face: FT_Face,
    pub encoding: FT_Encoding,
    pub platform_id: FT_UShort,
    pub encoding_id: FT_UShort,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FT_Face_InternalRec_ {
    _unused: [u8; 0],
}
pub type FT_Face_Internal = *mut FT_Face_InternalRec_;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FT_FaceRec_ {
    pub num_faces: FT_Long,
    pub face_index: FT_Long,
    pub face_flags: FT_Long,
    pub style_flags: FT_Long,
    pub num_glyphs: FT_Long,
    pub family_name: *mut FT_String,
    pub style_name: *mut FT_String,
    pub num_fixed_sizes: FT_Int,
    pub available_sizes: *mut FT_Bitmap_Size,
    pub num_charmaps: FT_Int,
    pub charmaps: *mut FT_CharMap,
    pub generic: FT_Generic,
    pub bbox: FT_BBox,
    pub units_per_EM: FT_UShort,
    pub ascender: FT_Short,
    pub descender: FT_Short,
    pub height: FT_Short,
    pub max_advance_width: FT_Short,
    pub max_advance_height: FT_Short,
    pub underline_position: FT_Short,
    pub underline_thickness: FT_Short,
    pub glyph: FT_GlyphSlot,
    pub size: FT_Size,
    pub charmap: FT_CharMap,
    pub driver: FT_Driver,
    pub memory: FT_Memory,
    pub stream: FT_Stream,
    pub sizes_list: FT_ListRec,
    pub autohint: FT_Generic,
    pub extensions: *mut ::std::os::raw::c_void,
    pub internal: FT_Face_Internal,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FT_Size_InternalRec_ {
    _unused: [u8; 0],
}
pub type FT_Size_Internal = *mut FT_Size_InternalRec_;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FT_Size_Metrics_ {
    pub x_ppem: FT_UShort,
    pub y_ppem: FT_UShort,
    pub x_scale: FT_Fixed,
    pub y_scale: FT_Fixed,
    pub ascender: FT_Pos,
    pub descender: FT_Pos,
    pub height: FT_Pos,
    pub max_advance: FT_Pos,
}
pub type FT_Size_Metrics = FT_Size_Metrics_;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FT_SizeRec_ {
    pub face: FT_Face,
    pub generic: FT_Generic,
    pub metrics: FT_Size_Metrics,
    pub internal: FT_Size_Internal,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FT_SubGlyphRec_ {
    _unused: [u8; 0],
}
pub type FT_SubGlyph = *mut FT_SubGlyphRec_;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FT_Slot_InternalRec_ {
    _unused: [u8; 0],
}
pub type FT_Slot_Internal = *mut FT_Slot_InternalRec_;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FT_GlyphSlotRec_ {
    pub library: FT_Library,
    pub face: FT_Face,
    pub next: FT_GlyphSlot,
    pub glyph_index: FT_UInt,
    pub generic: FT_Generic,
    pub metrics: FT_Glyph_Metrics,
    pub linearHoriAdvance: FT_Fixed,
    pub linearVertAdvance: FT_Fixed,
    pub advance: FT_Vector,
    pub format: FT_Glyph_Format,
    pub bitmap: FT_Bitmap,
    pub bitmap_left: FT_Int,
    pub bitmap_top: FT_Int,
    pub outline: FT_Outline,
    pub num_subglyphs: FT_UInt,
    pub subglyphs: FT_SubGlyph,
    pub control_data: *mut ::std::os::raw::c_void,
    pub control_len: ::std::os::raw::c_long,
    pub lsb_delta: FT_Pos,
    pub rsb_delta: FT_Pos,
    pub other: *mut ::std::os::raw::c_void,
    pub internal: FT_Slot_Internal,
}
unsafe extern "C" {
    pub fn hb_ft_face_create(ft_face: FT_Face, destroy: hb_destroy_func_t) -> *mut hb_face_t;
}
unsafe extern "C" {
    pub fn hb_ft_face_create_cached(ft_face: FT_Face) -> *mut hb_face_t;
}
unsafe extern "C" {
    pub fn hb_ft_face_create_referenced(ft_face: FT_Face) -> *mut hb_face_t;
}
unsafe extern "C" {
    pub fn hb_ft_face_create_from_file_or_fail(
        file_name: *const ::std::os::raw::c_char,
        index: ::std::os::raw::c_uint,
    ) -> *mut hb_face_t;
}
unsafe extern "C" {
    pub fn hb_ft_font_create(ft_face: FT_Face, destroy: hb_destroy_func_t) -> *mut hb_font_t;
}
unsafe extern "C" {
    pub fn hb_ft_font_create_referenced(ft_face: FT_Face) -> *mut hb_font_t;
}
unsafe extern "C" {
    pub fn hb_ft_font_get_ft_face(font: *mut hb_font_t) -> FT_Face;
}
unsafe extern "C" {
    pub fn hb_ft_font_lock_face(font: *mut hb_font_t) -> FT_Face;
}
unsafe extern "C" {
    pub fn hb_ft_font_unlock_face(font: *mut hb_font_t);
}
unsafe extern "C" {
    pub fn hb_ft_font_set_load_flags(font: *mut hb_font_t, load_flags: ::std::os::raw::c_int);
}
unsafe extern "C" {
    pub fn hb_ft_font_get_load_flags(font: *mut hb_font_t) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn hb_ft_font_changed(font: *mut hb_font_t);
}
unsafe extern "C" {
    pub fn hb_ft_hb_font_changed(font: *mut hb_font_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ft_font_set_funcs(font: *mut hb_font_t);
}
unsafe extern "C" {
    pub fn hb_ft_font_get_face(font: *mut hb_font_t) -> FT_Face;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_ot_name_id_predefined_t {
    HB_OT_NAME_ID_COPYRIGHT = 0,
    HB_OT_NAME_ID_FONT_FAMILY = 1,
    HB_OT_NAME_ID_FONT_SUBFAMILY = 2,
    HB_OT_NAME_ID_UNIQUE_ID = 3,
    HB_OT_NAME_ID_FULL_NAME = 4,
    HB_OT_NAME_ID_VERSION_STRING = 5,
    HB_OT_NAME_ID_POSTSCRIPT_NAME = 6,
    HB_OT_NAME_ID_TRADEMARK = 7,
    HB_OT_NAME_ID_MANUFACTURER = 8,
    HB_OT_NAME_ID_DESIGNER = 9,
    HB_OT_NAME_ID_DESCRIPTION = 10,
    HB_OT_NAME_ID_VENDOR_URL = 11,
    HB_OT_NAME_ID_DESIGNER_URL = 12,
    HB_OT_NAME_ID_LICENSE = 13,
    HB_OT_NAME_ID_LICENSE_URL = 14,
    HB_OT_NAME_ID_TYPOGRAPHIC_FAMILY = 16,
    HB_OT_NAME_ID_TYPOGRAPHIC_SUBFAMILY = 17,
    HB_OT_NAME_ID_MAC_FULL_NAME = 18,
    HB_OT_NAME_ID_SAMPLE_TEXT = 19,
    HB_OT_NAME_ID_CID_FINDFONT_NAME = 20,
    HB_OT_NAME_ID_WWS_FAMILY = 21,
    HB_OT_NAME_ID_WWS_SUBFAMILY = 22,
    HB_OT_NAME_ID_LIGHT_BACKGROUND = 23,
    HB_OT_NAME_ID_DARK_BACKGROUND = 24,
    HB_OT_NAME_ID_VARIATIONS_PS_PREFIX = 25,
    HB_OT_NAME_ID_INVALID = 65535,
}
pub type hb_ot_name_id_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hb_ot_name_entry_t {
    pub name_id: hb_ot_name_id_t,
    pub var: hb_var_int_t,
    pub language: hb_language_t,
}
unsafe extern "C" {
    pub fn hb_ot_name_list_names(
        face: *mut hb_face_t,
        num_entries: *mut ::std::os::raw::c_uint,
    ) -> *const hb_ot_name_entry_t;
}
unsafe extern "C" {
    pub fn hb_ot_name_get_utf8(
        face: *mut hb_face_t,
        name_id: hb_ot_name_id_t,
        language: hb_language_t,
        text_size: *mut ::std::os::raw::c_uint,
        text: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_name_get_utf16(
        face: *mut hb_face_t,
        name_id: hb_ot_name_id_t,
        language: hb_language_t,
        text_size: *mut ::std::os::raw::c_uint,
        text: *mut u16,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_name_get_utf32(
        face: *mut hb_face_t,
        name_id: hb_ot_name_id_t,
        language: hb_language_t,
        text_size: *mut ::std::os::raw::c_uint,
        text: *mut u32,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_color_has_palettes(face: *mut hb_face_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_color_palette_get_count(face: *mut hb_face_t) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_color_palette_get_name_id(
        face: *mut hb_face_t,
        palette_index: ::std::os::raw::c_uint,
    ) -> hb_ot_name_id_t;
}
unsafe extern "C" {
    pub fn hb_ot_color_palette_color_get_name_id(
        face: *mut hb_face_t,
        color_index: ::std::os::raw::c_uint,
    ) -> hb_ot_name_id_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_ot_color_palette_flags_t {
    HB_OT_COLOR_PALETTE_FLAG_DEFAULT = 0,
    HB_OT_COLOR_PALETTE_FLAG_USABLE_WITH_LIGHT_BACKGROUND = 1,
    HB_OT_COLOR_PALETTE_FLAG_USABLE_WITH_DARK_BACKGROUND = 2,
}
unsafe extern "C" {
    pub fn hb_ot_color_palette_get_flags(
        face: *mut hb_face_t,
        palette_index: ::std::os::raw::c_uint,
    ) -> hb_ot_color_palette_flags_t;
}
unsafe extern "C" {
    pub fn hb_ot_color_palette_get_colors(
        face: *mut hb_face_t,
        palette_index: ::std::os::raw::c_uint,
        start_offset: ::std::os::raw::c_uint,
        color_count: *mut ::std::os::raw::c_uint,
        colors: *mut hb_color_t,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_color_has_layers(face: *mut hb_face_t) -> hb_bool_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_ot_color_layer_t {
    pub glyph: hb_codepoint_t,
    pub color_index: ::std::os::raw::c_uint,
}
unsafe extern "C" {
    pub fn hb_ot_color_glyph_get_layers(
        face: *mut hb_face_t,
        glyph: hb_codepoint_t,
        start_offset: ::std::os::raw::c_uint,
        layer_count: *mut ::std::os::raw::c_uint,
        layers: *mut hb_ot_color_layer_t,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_color_has_paint(face: *mut hb_face_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_color_glyph_has_paint(face: *mut hb_face_t, glyph: hb_codepoint_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_color_has_svg(face: *mut hb_face_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_color_glyph_reference_svg(
        face: *mut hb_face_t,
        glyph: hb_codepoint_t,
    ) -> *mut hb_blob_t;
}
unsafe extern "C" {
    pub fn hb_ot_color_has_png(face: *mut hb_face_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_color_glyph_reference_png(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
    ) -> *mut hb_blob_t;
}
unsafe extern "C" {
    pub fn hb_ot_layout_table_choose_script(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_tags: *const hb_tag_t,
        script_index: *mut ::std::os::raw::c_uint,
        chosen_script: *mut hb_tag_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_layout_script_find_language(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_tag: hb_tag_t,
        language_index: *mut ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_tags_from_script(
        script: hb_script_t,
        script_tag_1: *mut hb_tag_t,
        script_tag_2: *mut hb_tag_t,
    );
}
unsafe extern "C" {
    pub fn hb_ot_tag_from_language(language: hb_language_t) -> hb_tag_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_ot_var_axis_t {
    pub tag: hb_tag_t,
    pub name_id: hb_ot_name_id_t,
    pub min_value: f32,
    pub default_value: f32,
    pub max_value: f32,
}
unsafe extern "C" {
    pub fn hb_ot_var_get_axes(
        face: *mut hb_face_t,
        start_offset: ::std::os::raw::c_uint,
        axes_count: *mut ::std::os::raw::c_uint,
        axes_array: *mut hb_ot_var_axis_t,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_var_find_axis(
        face: *mut hb_face_t,
        axis_tag: hb_tag_t,
        axis_index: *mut ::std::os::raw::c_uint,
        axis_info: *mut hb_ot_var_axis_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_font_set_funcs(font: *mut hb_font_t);
}
unsafe extern "C" {
    pub fn hb_ot_tags_from_script_and_language(
        script: hb_script_t,
        language: hb_language_t,
        script_count: *mut ::std::os::raw::c_uint,
        script_tags: *mut hb_tag_t,
        language_count: *mut ::std::os::raw::c_uint,
        language_tags: *mut hb_tag_t,
    );
}
unsafe extern "C" {
    pub fn hb_ot_tag_to_script(tag: hb_tag_t) -> hb_script_t;
}
unsafe extern "C" {
    pub fn hb_ot_tag_to_language(tag: hb_tag_t) -> hb_language_t;
}
unsafe extern "C" {
    pub fn hb_ot_tags_to_script_and_language(
        script_tag: hb_tag_t,
        language_tag: hb_tag_t,
        script: *mut hb_script_t,
        language: *mut hb_language_t,
    );
}
unsafe extern "C" {
    pub fn hb_ot_layout_has_glyph_classes(face: *mut hb_face_t) -> hb_bool_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_ot_layout_glyph_class_t {
    HB_OT_LAYOUT_GLYPH_CLASS_UNCLASSIFIED = 0,
    HB_OT_LAYOUT_GLYPH_CLASS_BASE_GLYPH = 1,
    HB_OT_LAYOUT_GLYPH_CLASS_LIGATURE = 2,
    HB_OT_LAYOUT_GLYPH_CLASS_MARK = 3,
    HB_OT_LAYOUT_GLYPH_CLASS_COMPONENT = 4,
}
unsafe extern "C" {
    pub fn hb_ot_layout_get_glyph_class(
        face: *mut hb_face_t,
        glyph: hb_codepoint_t,
    ) -> hb_ot_layout_glyph_class_t;
}
unsafe extern "C" {
    pub fn hb_ot_layout_get_glyphs_in_class(
        face: *mut hb_face_t,
        klass: hb_ot_layout_glyph_class_t,
        glyphs: *mut hb_set_t,
    );
}
unsafe extern "C" {
    pub fn hb_ot_layout_get_attach_points(
        face: *mut hb_face_t,
        glyph: hb_codepoint_t,
        start_offset: ::std::os::raw::c_uint,
        point_count: *mut ::std::os::raw::c_uint,
        point_array: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_layout_get_ligature_carets(
        font: *mut hb_font_t,
        direction: hb_direction_t,
        glyph: hb_codepoint_t,
        start_offset: ::std::os::raw::c_uint,
        caret_count: *mut ::std::os::raw::c_uint,
        caret_array: *mut hb_position_t,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_layout_table_get_script_tags(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        start_offset: ::std::os::raw::c_uint,
        script_count: *mut ::std::os::raw::c_uint,
        script_tags: *mut hb_tag_t,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_layout_table_find_script(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_tag: hb_tag_t,
        script_index: *mut ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_layout_table_select_script(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_count: ::std::os::raw::c_uint,
        script_tags: *const hb_tag_t,
        script_index: *mut ::std::os::raw::c_uint,
        chosen_script: *mut hb_tag_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_layout_table_get_feature_tags(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        start_offset: ::std::os::raw::c_uint,
        feature_count: *mut ::std::os::raw::c_uint,
        feature_tags: *mut hb_tag_t,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_layout_script_get_language_tags(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        start_offset: ::std::os::raw::c_uint,
        language_count: *mut ::std::os::raw::c_uint,
        language_tags: *mut hb_tag_t,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_layout_script_select_language(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_count: ::std::os::raw::c_uint,
        language_tags: *const hb_tag_t,
        language_index: *mut ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_layout_script_select_language2(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_count: ::std::os::raw::c_uint,
        language_tags: *const hb_tag_t,
        language_index: *mut ::std::os::raw::c_uint,
        chosen_language: *mut hb_tag_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_layout_language_get_required_feature_index(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_index: ::std::os::raw::c_uint,
        feature_index: *mut ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_layout_language_get_required_feature(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_index: ::std::os::raw::c_uint,
        feature_index: *mut ::std::os::raw::c_uint,
        feature_tag: *mut hb_tag_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_layout_language_get_feature_indexes(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_index: ::std::os::raw::c_uint,
        start_offset: ::std::os::raw::c_uint,
        feature_count: *mut ::std::os::raw::c_uint,
        feature_indexes: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_layout_language_get_feature_tags(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_index: ::std::os::raw::c_uint,
        start_offset: ::std::os::raw::c_uint,
        feature_count: *mut ::std::os::raw::c_uint,
        feature_tags: *mut hb_tag_t,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_layout_language_find_feature(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_index: ::std::os::raw::c_uint,
        feature_tag: hb_tag_t,
        feature_index: *mut ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_layout_feature_get_lookups(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        feature_index: ::std::os::raw::c_uint,
        start_offset: ::std::os::raw::c_uint,
        lookup_count: *mut ::std::os::raw::c_uint,
        lookup_indexes: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_layout_table_get_lookup_count(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_layout_collect_features(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        scripts: *const hb_tag_t,
        languages: *const hb_tag_t,
        features: *const hb_tag_t,
        feature_indexes: *mut hb_set_t,
    );
}
unsafe extern "C" {
    pub fn hb_ot_layout_collect_features_map(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_index: ::std::os::raw::c_uint,
        feature_map: *mut hb_map_t,
    );
}
unsafe extern "C" {
    pub fn hb_ot_layout_collect_lookups(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        scripts: *const hb_tag_t,
        languages: *const hb_tag_t,
        features: *const hb_tag_t,
        lookup_indexes: *mut hb_set_t,
    );
}
unsafe extern "C" {
    pub fn hb_ot_layout_lookup_collect_glyphs(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        lookup_index: ::std::os::raw::c_uint,
        glyphs_before: *mut hb_set_t,
        glyphs_input: *mut hb_set_t,
        glyphs_after: *mut hb_set_t,
        glyphs_output: *mut hb_set_t,
    );
}
unsafe extern "C" {
    pub fn hb_ot_layout_table_find_feature_variations(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        coords: *const ::std::os::raw::c_int,
        num_coords: ::std::os::raw::c_uint,
        variations_index: *mut ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_layout_feature_with_variations_get_lookups(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        feature_index: ::std::os::raw::c_uint,
        variations_index: ::std::os::raw::c_uint,
        start_offset: ::std::os::raw::c_uint,
        lookup_count: *mut ::std::os::raw::c_uint,
        lookup_indexes: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_layout_has_substitution(face: *mut hb_face_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_layout_lookup_get_glyph_alternates(
        face: *mut hb_face_t,
        lookup_index: ::std::os::raw::c_uint,
        glyph: hb_codepoint_t,
        start_offset: ::std::os::raw::c_uint,
        alternate_count: *mut ::std::os::raw::c_uint,
        alternate_glyphs: *mut hb_codepoint_t,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_layout_lookup_would_substitute(
        face: *mut hb_face_t,
        lookup_index: ::std::os::raw::c_uint,
        glyphs: *const hb_codepoint_t,
        glyphs_length: ::std::os::raw::c_uint,
        zero_context: hb_bool_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_layout_lookup_substitute_closure(
        face: *mut hb_face_t,
        lookup_index: ::std::os::raw::c_uint,
        glyphs: *mut hb_set_t,
    );
}
unsafe extern "C" {
    pub fn hb_ot_layout_lookups_substitute_closure(
        face: *mut hb_face_t,
        lookups: *const hb_set_t,
        glyphs: *mut hb_set_t,
    );
}
unsafe extern "C" {
    pub fn hb_ot_layout_has_positioning(face: *mut hb_face_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_layout_get_size_params(
        face: *mut hb_face_t,
        design_size: *mut ::std::os::raw::c_uint,
        subfamily_id: *mut ::std::os::raw::c_uint,
        subfamily_name_id: *mut hb_ot_name_id_t,
        range_start: *mut ::std::os::raw::c_uint,
        range_end: *mut ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_layout_lookup_get_optical_bound(
        font: *mut hb_font_t,
        lookup_index: ::std::os::raw::c_uint,
        direction: hb_direction_t,
        glyph: hb_codepoint_t,
    ) -> hb_position_t;
}
unsafe extern "C" {
    pub fn hb_ot_layout_feature_get_name_ids(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        feature_index: ::std::os::raw::c_uint,
        label_id: *mut hb_ot_name_id_t,
        tooltip_id: *mut hb_ot_name_id_t,
        sample_id: *mut hb_ot_name_id_t,
        num_named_parameters: *mut ::std::os::raw::c_uint,
        first_param_id: *mut hb_ot_name_id_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_layout_feature_get_characters(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        feature_index: ::std::os::raw::c_uint,
        start_offset: ::std::os::raw::c_uint,
        char_count: *mut ::std::os::raw::c_uint,
        characters: *mut hb_codepoint_t,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_layout_get_font_extents(
        font: *mut hb_font_t,
        direction: hb_direction_t,
        script_tag: hb_tag_t,
        language_tag: hb_tag_t,
        extents: *mut hb_font_extents_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_layout_get_font_extents2(
        font: *mut hb_font_t,
        direction: hb_direction_t,
        script: hb_script_t,
        language: hb_language_t,
        extents: *mut hb_font_extents_t,
    ) -> hb_bool_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_ot_layout_baseline_tag_t {
    HB_OT_LAYOUT_BASELINE_TAG_ROMAN = 1919905134,
    HB_OT_LAYOUT_BASELINE_TAG_HANGING = 1751215719,
    HB_OT_LAYOUT_BASELINE_TAG_IDEO_FACE_BOTTOM_OR_LEFT = 1768121954,
    HB_OT_LAYOUT_BASELINE_TAG_IDEO_FACE_TOP_OR_RIGHT = 1768121972,
    HB_OT_LAYOUT_BASELINE_TAG_IDEO_FACE_CENTRAL = 1231251043,
    HB_OT_LAYOUT_BASELINE_TAG_IDEO_EMBOX_BOTTOM_OR_LEFT = 1768187247,
    HB_OT_LAYOUT_BASELINE_TAG_IDEO_EMBOX_TOP_OR_RIGHT = 1768191088,
    HB_OT_LAYOUT_BASELINE_TAG_IDEO_EMBOX_CENTRAL = 1231315813,
    HB_OT_LAYOUT_BASELINE_TAG_MATH = 1835103336,
    _HB_OT_LAYOUT_BASELINE_TAG_MAX_VALUE = 2147483647,
}
unsafe extern "C" {
    pub fn hb_ot_layout_get_horizontal_baseline_tag_for_script(
        script: hb_script_t,
    ) -> hb_ot_layout_baseline_tag_t;
}
unsafe extern "C" {
    pub fn hb_ot_layout_get_baseline(
        font: *mut hb_font_t,
        baseline_tag: hb_ot_layout_baseline_tag_t,
        direction: hb_direction_t,
        script_tag: hb_tag_t,
        language_tag: hb_tag_t,
        coord: *mut hb_position_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_layout_get_baseline2(
        font: *mut hb_font_t,
        baseline_tag: hb_ot_layout_baseline_tag_t,
        direction: hb_direction_t,
        script: hb_script_t,
        language: hb_language_t,
        coord: *mut hb_position_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_layout_get_baseline_with_fallback(
        font: *mut hb_font_t,
        baseline_tag: hb_ot_layout_baseline_tag_t,
        direction: hb_direction_t,
        script_tag: hb_tag_t,
        language_tag: hb_tag_t,
        coord: *mut hb_position_t,
    );
}
unsafe extern "C" {
    pub fn hb_ot_layout_get_baseline_with_fallback2(
        font: *mut hb_font_t,
        baseline_tag: hb_ot_layout_baseline_tag_t,
        direction: hb_direction_t,
        script: hb_script_t,
        language: hb_language_t,
        coord: *mut hb_position_t,
    );
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_ot_math_constant_t {
    HB_OT_MATH_CONSTANT_SCRIPT_PERCENT_SCALE_DOWN = 0,
    HB_OT_MATH_CONSTANT_SCRIPT_SCRIPT_PERCENT_SCALE_DOWN = 1,
    HB_OT_MATH_CONSTANT_DELIMITED_SUB_FORMULA_MIN_HEIGHT = 2,
    HB_OT_MATH_CONSTANT_DISPLAY_OPERATOR_MIN_HEIGHT = 3,
    HB_OT_MATH_CONSTANT_MATH_LEADING = 4,
    HB_OT_MATH_CONSTANT_AXIS_HEIGHT = 5,
    HB_OT_MATH_CONSTANT_ACCENT_BASE_HEIGHT = 6,
    HB_OT_MATH_CONSTANT_FLATTENED_ACCENT_BASE_HEIGHT = 7,
    HB_OT_MATH_CONSTANT_SUBSCRIPT_SHIFT_DOWN = 8,
    HB_OT_MATH_CONSTANT_SUBSCRIPT_TOP_MAX = 9,
    HB_OT_MATH_CONSTANT_SUBSCRIPT_BASELINE_DROP_MIN = 10,
    HB_OT_MATH_CONSTANT_SUPERSCRIPT_SHIFT_UP = 11,
    HB_OT_MATH_CONSTANT_SUPERSCRIPT_SHIFT_UP_CRAMPED = 12,
    HB_OT_MATH_CONSTANT_SUPERSCRIPT_BOTTOM_MIN = 13,
    HB_OT_MATH_CONSTANT_SUPERSCRIPT_BASELINE_DROP_MAX = 14,
    HB_OT_MATH_CONSTANT_SUB_SUPERSCRIPT_GAP_MIN = 15,
    HB_OT_MATH_CONSTANT_SUPERSCRIPT_BOTTOM_MAX_WITH_SUBSCRIPT = 16,
    HB_OT_MATH_CONSTANT_SPACE_AFTER_SCRIPT = 17,
    HB_OT_MATH_CONSTANT_UPPER_LIMIT_GAP_MIN = 18,
    HB_OT_MATH_CONSTANT_UPPER_LIMIT_BASELINE_RISE_MIN = 19,
    HB_OT_MATH_CONSTANT_LOWER_LIMIT_GAP_MIN = 20,
    HB_OT_MATH_CONSTANT_LOWER_LIMIT_BASELINE_DROP_MIN = 21,
    HB_OT_MATH_CONSTANT_STACK_TOP_SHIFT_UP = 22,
    HB_OT_MATH_CONSTANT_STACK_TOP_DISPLAY_STYLE_SHIFT_UP = 23,
    HB_OT_MATH_CONSTANT_STACK_BOTTOM_SHIFT_DOWN = 24,
    HB_OT_MATH_CONSTANT_STACK_BOTTOM_DISPLAY_STYLE_SHIFT_DOWN = 25,
    HB_OT_MATH_CONSTANT_STACK_GAP_MIN = 26,
    HB_OT_MATH_CONSTANT_STACK_DISPLAY_STYLE_GAP_MIN = 27,
    HB_OT_MATH_CONSTANT_STRETCH_STACK_TOP_SHIFT_UP = 28,
    HB_OT_MATH_CONSTANT_STRETCH_STACK_BOTTOM_SHIFT_DOWN = 29,
    HB_OT_MATH_CONSTANT_STRETCH_STACK_GAP_ABOVE_MIN = 30,
    HB_OT_MATH_CONSTANT_STRETCH_STACK_GAP_BELOW_MIN = 31,
    HB_OT_MATH_CONSTANT_FRACTION_NUMERATOR_SHIFT_UP = 32,
    HB_OT_MATH_CONSTANT_FRACTION_NUMERATOR_DISPLAY_STYLE_SHIFT_UP = 33,
    HB_OT_MATH_CONSTANT_FRACTION_DENOMINATOR_SHIFT_DOWN = 34,
    HB_OT_MATH_CONSTANT_FRACTION_DENOMINATOR_DISPLAY_STYLE_SHIFT_DOWN = 35,
    HB_OT_MATH_CONSTANT_FRACTION_NUMERATOR_GAP_MIN = 36,
    HB_OT_MATH_CONSTANT_FRACTION_NUM_DISPLAY_STYLE_GAP_MIN = 37,
    HB_OT_MATH_CONSTANT_FRACTION_RULE_THICKNESS = 38,
    HB_OT_MATH_CONSTANT_FRACTION_DENOMINATOR_GAP_MIN = 39,
    HB_OT_MATH_CONSTANT_FRACTION_DENOM_DISPLAY_STYLE_GAP_MIN = 40,
    HB_OT_MATH_CONSTANT_SKEWED_FRACTION_HORIZONTAL_GAP = 41,
    HB_OT_MATH_CONSTANT_SKEWED_FRACTION_VERTICAL_GAP = 42,
    HB_OT_MATH_CONSTANT_OVERBAR_VERTICAL_GAP = 43,
    HB_OT_MATH_CONSTANT_OVERBAR_RULE_THICKNESS = 44,
    HB_OT_MATH_CONSTANT_OVERBAR_EXTRA_ASCENDER = 45,
    HB_OT_MATH_CONSTANT_UNDERBAR_VERTICAL_GAP = 46,
    HB_OT_MATH_CONSTANT_UNDERBAR_RULE_THICKNESS = 47,
    HB_OT_MATH_CONSTANT_UNDERBAR_EXTRA_DESCENDER = 48,
    HB_OT_MATH_CONSTANT_RADICAL_VERTICAL_GAP = 49,
    HB_OT_MATH_CONSTANT_RADICAL_DISPLAY_STYLE_VERTICAL_GAP = 50,
    HB_OT_MATH_CONSTANT_RADICAL_RULE_THICKNESS = 51,
    HB_OT_MATH_CONSTANT_RADICAL_EXTRA_ASCENDER = 52,
    HB_OT_MATH_CONSTANT_RADICAL_KERN_BEFORE_DEGREE = 53,
    HB_OT_MATH_CONSTANT_RADICAL_KERN_AFTER_DEGREE = 54,
    HB_OT_MATH_CONSTANT_RADICAL_DEGREE_BOTTOM_RAISE_PERCENT = 55,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_ot_math_kern_t {
    HB_OT_MATH_KERN_TOP_RIGHT = 0,
    HB_OT_MATH_KERN_TOP_LEFT = 1,
    HB_OT_MATH_KERN_BOTTOM_RIGHT = 2,
    HB_OT_MATH_KERN_BOTTOM_LEFT = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_ot_math_kern_entry_t {
    pub max_correction_height: hb_position_t,
    pub kern_value: hb_position_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_ot_math_glyph_variant_t {
    pub glyph: hb_codepoint_t,
    pub advance: hb_position_t,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_ot_math_glyph_part_flags_t {
    HB_OT_MATH_GLYPH_PART_FLAG_EXTENDER = 1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_ot_math_glyph_part_t {
    pub glyph: hb_codepoint_t,
    pub start_connector_length: hb_position_t,
    pub end_connector_length: hb_position_t,
    pub full_advance: hb_position_t,
    pub flags: hb_ot_math_glyph_part_flags_t,
}
unsafe extern "C" {
    pub fn hb_ot_math_has_data(face: *mut hb_face_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_math_get_constant(
        font: *mut hb_font_t,
        constant: hb_ot_math_constant_t,
    ) -> hb_position_t;
}
unsafe extern "C" {
    pub fn hb_ot_math_get_glyph_italics_correction(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
    ) -> hb_position_t;
}
unsafe extern "C" {
    pub fn hb_ot_math_get_glyph_top_accent_attachment(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
    ) -> hb_position_t;
}
unsafe extern "C" {
    pub fn hb_ot_math_is_glyph_extended_shape(
        face: *mut hb_face_t,
        glyph: hb_codepoint_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_math_get_glyph_kerning(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        kern: hb_ot_math_kern_t,
        correction_height: hb_position_t,
    ) -> hb_position_t;
}
unsafe extern "C" {
    pub fn hb_ot_math_get_glyph_kernings(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        kern: hb_ot_math_kern_t,
        start_offset: ::std::os::raw::c_uint,
        entries_count: *mut ::std::os::raw::c_uint,
        kern_entries: *mut hb_ot_math_kern_entry_t,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_math_get_glyph_variants(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        direction: hb_direction_t,
        start_offset: ::std::os::raw::c_uint,
        variants_count: *mut ::std::os::raw::c_uint,
        variants: *mut hb_ot_math_glyph_variant_t,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_math_get_min_connector_overlap(
        font: *mut hb_font_t,
        direction: hb_direction_t,
    ) -> hb_position_t;
}
unsafe extern "C" {
    pub fn hb_ot_math_get_glyph_assembly(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        direction: hb_direction_t,
        start_offset: ::std::os::raw::c_uint,
        parts_count: *mut ::std::os::raw::c_uint,
        parts: *mut hb_ot_math_glyph_part_t,
        italics_correction: *mut hb_position_t,
    ) -> ::std::os::raw::c_uint;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_ot_meta_tag_t {
    HB_OT_META_TAG_DESIGN_LANGUAGES = 1684827751,
    HB_OT_META_TAG_SUPPORTED_LANGUAGES = 1936485991,
    _HB_OT_META_TAG_MAX_VALUE = 2147483647,
}
unsafe extern "C" {
    pub fn hb_ot_meta_get_entry_tags(
        face: *mut hb_face_t,
        start_offset: ::std::os::raw::c_uint,
        entries_count: *mut ::std::os::raw::c_uint,
        entries: *mut hb_ot_meta_tag_t,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_meta_reference_entry(
        face: *mut hb_face_t,
        meta_tag: hb_ot_meta_tag_t,
    ) -> *mut hb_blob_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_ot_metrics_tag_t {
    HB_OT_METRICS_TAG_HORIZONTAL_ASCENDER = 1751216995,
    HB_OT_METRICS_TAG_HORIZONTAL_DESCENDER = 1751413603,
    HB_OT_METRICS_TAG_HORIZONTAL_LINE_GAP = 1751934832,
    HB_OT_METRICS_TAG_HORIZONTAL_CLIPPING_ASCENT = 1751346273,
    HB_OT_METRICS_TAG_HORIZONTAL_CLIPPING_DESCENT = 1751346276,
    HB_OT_METRICS_TAG_VERTICAL_ASCENDER = 1986098019,
    HB_OT_METRICS_TAG_VERTICAL_DESCENDER = 1986294627,
    HB_OT_METRICS_TAG_VERTICAL_LINE_GAP = 1986815856,
    HB_OT_METRICS_TAG_HORIZONTAL_CARET_RISE = 1751347827,
    HB_OT_METRICS_TAG_HORIZONTAL_CARET_RUN = 1751347822,
    HB_OT_METRICS_TAG_HORIZONTAL_CARET_OFFSET = 1751347046,
    HB_OT_METRICS_TAG_VERTICAL_CARET_RISE = 1986228851,
    HB_OT_METRICS_TAG_VERTICAL_CARET_RUN = 1986228846,
    HB_OT_METRICS_TAG_VERTICAL_CARET_OFFSET = 1986228070,
    HB_OT_METRICS_TAG_X_HEIGHT = 2020108148,
    HB_OT_METRICS_TAG_CAP_HEIGHT = 1668311156,
    HB_OT_METRICS_TAG_SUBSCRIPT_EM_X_SIZE = 1935833203,
    HB_OT_METRICS_TAG_SUBSCRIPT_EM_Y_SIZE = 1935833459,
    HB_OT_METRICS_TAG_SUBSCRIPT_EM_X_OFFSET = 1935833199,
    HB_OT_METRICS_TAG_SUBSCRIPT_EM_Y_OFFSET = 1935833455,
    HB_OT_METRICS_TAG_SUPERSCRIPT_EM_X_SIZE = 1936750707,
    HB_OT_METRICS_TAG_SUPERSCRIPT_EM_Y_SIZE = 1936750963,
    HB_OT_METRICS_TAG_SUPERSCRIPT_EM_X_OFFSET = 1936750703,
    HB_OT_METRICS_TAG_SUPERSCRIPT_EM_Y_OFFSET = 1936750959,
    HB_OT_METRICS_TAG_STRIKEOUT_SIZE = 1937011315,
    HB_OT_METRICS_TAG_STRIKEOUT_OFFSET = 1937011311,
    HB_OT_METRICS_TAG_UNDERLINE_SIZE = 1970168947,
    HB_OT_METRICS_TAG_UNDERLINE_OFFSET = 1970168943,
    _HB_OT_METRICS_TAG_MAX_VALUE = 2147483647,
}
unsafe extern "C" {
    pub fn hb_ot_metrics_get_position(
        font: *mut hb_font_t,
        metrics_tag: hb_ot_metrics_tag_t,
        position: *mut hb_position_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_metrics_get_position_with_fallback(
        font: *mut hb_font_t,
        metrics_tag: hb_ot_metrics_tag_t,
        position: *mut hb_position_t,
    );
}
unsafe extern "C" {
    pub fn hb_ot_metrics_get_variation(
        font: *mut hb_font_t,
        metrics_tag: hb_ot_metrics_tag_t,
    ) -> f32;
}
unsafe extern "C" {
    pub fn hb_ot_metrics_get_x_variation(
        font: *mut hb_font_t,
        metrics_tag: hb_ot_metrics_tag_t,
    ) -> hb_position_t;
}
unsafe extern "C" {
    pub fn hb_ot_metrics_get_y_variation(
        font: *mut hb_font_t,
        metrics_tag: hb_ot_metrics_tag_t,
    ) -> hb_position_t;
}
unsafe extern "C" {
    pub fn hb_ot_shape_glyphs_closure(
        font: *mut hb_font_t,
        buffer: *mut hb_buffer_t,
        features: *const hb_feature_t,
        num_features: ::std::os::raw::c_uint,
        glyphs: *mut hb_set_t,
    );
}
unsafe extern "C" {
    pub fn hb_ot_shape_plan_collect_lookups(
        shape_plan: *mut hb_shape_plan_t,
        table_tag: hb_tag_t,
        lookup_indexes: *mut hb_set_t,
    );
}
unsafe extern "C" {
    pub fn hb_ot_shape_plan_get_feature_tags(
        shape_plan: *mut hb_shape_plan_t,
        start_offset: ::std::os::raw::c_uint,
        tag_count: *mut ::std::os::raw::c_uint,
        tags: *mut hb_tag_t,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_var_has_data(face: *mut hb_face_t) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_var_get_axis_count(face: *mut hb_face_t) -> ::std::os::raw::c_uint;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum hb_ot_var_axis_flags_t {
    HB_OT_VAR_AXIS_FLAG_HIDDEN = 1,
    _HB_OT_VAR_AXIS_FLAG_MAX_VALUE = 2147483647,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_ot_var_axis_info_t {
    pub axis_index: ::std::os::raw::c_uint,
    pub tag: hb_tag_t,
    pub name_id: hb_ot_name_id_t,
    pub flags: hb_ot_var_axis_flags_t,
    pub min_value: f32,
    pub default_value: f32,
    pub max_value: f32,
    pub reserved: ::std::os::raw::c_uint,
}
unsafe extern "C" {
    pub fn hb_ot_var_get_axis_infos(
        face: *mut hb_face_t,
        start_offset: ::std::os::raw::c_uint,
        axes_count: *mut ::std::os::raw::c_uint,
        axes_array: *mut hb_ot_var_axis_info_t,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_var_find_axis_info(
        face: *mut hb_face_t,
        axis_tag: hb_tag_t,
        axis_info: *mut hb_ot_var_axis_info_t,
    ) -> hb_bool_t;
}
unsafe extern "C" {
    pub fn hb_ot_var_get_named_instance_count(face: *mut hb_face_t) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_var_named_instance_get_subfamily_name_id(
        face: *mut hb_face_t,
        instance_index: ::std::os::raw::c_uint,
    ) -> hb_ot_name_id_t;
}
unsafe extern "C" {
    pub fn hb_ot_var_named_instance_get_postscript_name_id(
        face: *mut hb_face_t,
        instance_index: ::std::os::raw::c_uint,
    ) -> hb_ot_name_id_t;
}
unsafe extern "C" {
    pub fn hb_ot_var_named_instance_get_design_coords(
        face: *mut hb_face_t,
        instance_index: ::std::os::raw::c_uint,
        coords_length: *mut ::std::os::raw::c_uint,
        coords: *mut f32,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn hb_ot_var_normalize_variations(
        face: *mut hb_face_t,
        variations: *const hb_variation_t,
        variations_length: ::std::os::raw::c_uint,
        coords: *mut ::std::os::raw::c_int,
        coords_length: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn hb_ot_var_normalize_coords(
        face: *mut hb_face_t,
        coords_length: ::std::os::raw::c_uint,
        design_coords: *const f32,
        normalized_coords: *mut ::std::os::raw::c_int,
    );
}
