=begin
= test for WebUnit::Utils
  Copyright(C) 2001 yuichi TAKAHASHI
  $Id: test_utils.rb,v 1.1.1.1 2003/01/21 11:50:40 yuichi Exp $
=end

require 'webunit/webunit'
require 'runit/cui/testrunner'

module WebUnit

  class TestUtils < WebUnit::TestCase

    def test_parse_url

      url = "http://localhost/xxxx.html"
      prot, host, port, path = parse_url( url )

      assert_equals( 'http', prot )
      assert_equals( 'localhost', host )
      assert_equals( 80, port )
      assert_equals( '/xxxx.html', path )

      url = "http://localhost/"
      prot, host, port, path = parse_url( url )

      assert_equals( 'http', prot )
      assert_equals( 'localhost', host )
      assert_equals( 80, port )
      assert_equals( '/', path )

      url = "http://localhost"
      prot, host, port, path = parse_url( url )

      assert_equals( 'http', prot )
      assert_equals( 'localhost', host )
      assert_equals( 80, port )
      assert_equals( '', path )

      url = "file:/home/yyyy/xxxx.html"
      prot, host, port, path = parse_url( url )

      assert_equals( 'file', prot )
      assert_equals( nil, host )
      assert_equals( nil, port )
      assert_equals( '/home/yyyy/xxxx.html', path )

      url = "yyyy/xxxx.html"
      prot, host, port, path = parse_url( url )

      assert_equals( nil, prot )
      assert_equals( nil, host )
      assert_equals( nil, port )
      assert_equals( 'yyyy/xxxx.html', path )

    end

    def test_orthop_url

      url = "http://localhost/xxxx.html"
      assert_equals( 'http://localhost:80/xxxx.html', orthop_url( url ) )

      url = "http://local-host/"
      assert_equals( 'http://local-host:80/', orthop_url( url ) )

      url = "http://localhost"
      assert_equals( 'http://localhost:80', orthop_url( url ) )

      url = "http://localhost/a/./xxxx.html"
      assert_equals( 'http://localhost:80/a/xxxx.html', orthop_url( url ) )

      url = "http://localhost/a/../xxxx.html"
      assert_equals( 'http://localhost:80/xxxx.html', orthop_url( url ) )

    end

    def test_complete_url

      base = "http://localhost:80/a/xxxx.html"

      url = 'http://localhost:80/a/yyyy.html'
      assert_equals( url, complete_url( url, base ) )

      url = 'http://localhost:80/yyyy.html'
      assert_equals( url, complete_url( '/yyyy.html', base ) )

      url = 'http://localhost:80/a/yyyy.html'
      assert_equals( url, complete_url( 'yyyy.html', base ) )

      assert_equals( base, complete_url( nil, base ) )

      base = "http://localhost:80/a/xxxx.html?args..."
      url  = 'http://localhost:80/a/xxxx.html'
      assert_equals( url, complete_url( nil, base ) )

      url  = 'xxxx.html'
      assert_equals( url, complete_url( url, nil ) )

      url  = 'http://localhost:80/a/xxxx.html'
      assert_equals( url, complete_url( url, nil ) )

    end

  end

end
