=begin
= test for WebUnit::Response
  Copyright(C) 2001 yuichi TAKAHASHI
  $Id: test_response.rb,v 1.4 2004/04/29 12:34:06 yuichi Exp $
=end

require 'webunit/webunit'
require 'runit/cui/testrunner'

module WebUnit

  class TestResponse < WebUnit::TestCase

    def test_s_new # get and post

      url = @urlbase + "webunit/xxxxx.html" # not exist
      assert_exception( WebUnit::HttpNotFound ){
        response = Response::get( url )
      }

      url = @urlbase + "webunit/badtags.html"
      assert_exception( WebUnit::BadHtmlTags ){
        response = Response::get( url )
      }

      url = "webunit/response.html"
      response = Response::get( url )
      url = @urlbase + "webunit/response.html"
      assert_equals( url, response.url )

      url = "webunit/auth/index.html"
      response = Response::get( url, nil, %w( user badpass ) )
      assert_title( "401 Authorization Required", response );
      response = Response::get( url, nil, %w( user pass ) )
      assert_title( "Success", response );
      
      url = "webunit/document.xml"
      response = Response::get( url )
      assert_instance_of( DomWalker, response );

#      url = "webunit/WikiName.html"
#      response = Response::get( url )

    end

    def test_s_html

      html = <<-EOS
      <html>
      <head>
        <title>test title</title>
      </head>
      <body>
        <a href='xxx.html'>XXX</a>
      </body>
      </html>
      EOS
      response = Response::html( html )
      assert_title( 'test title', response )
      assert_equals( 1, response.links.size )
      assert_equals( 'XXX', response.link.data )
      assert_urls( 'xxx.html', response.link.href )

      response = Response::html( html, 'http://x.y.z/yyy.html' )
      assert_title( 'test title', response )
      assert_equals( 1, response.links.size )
      assert_equals( 'XXX', response.link.data )
      assert_urls( 'http://x.y.z/xxx.html', response.link.href )

      html = <<-EOS
      <body>
        <a href='xxx.html'>XXX</a>
      </body>
      EOS
      response = Response::html( html )
      assert_equals( 'html', response.tree.tag )

    end

    def test_accessor

      url = @urlbase + "webunit/response.html"
      response = Response::get( url )
      assert_title( 'WebUnit::response', response )

      assert_equals( url, response.url )
      assert_equals( 'GET', response.method )
      if RUBY_VERSION[0..2] == "1.6"
        assert_instance_of( Net::HTTPResponse, response.response )
      else
        assert_instance_of( Net::HTTPOK, response.response )
      end
      assert_instance_of( String, response.body )
      assert_equals( '200', response.code )

      assert_instance_of( HtmlElem, response.tree )

      # response.links[0], response.link => test_link.rb
      # response.forms[0], response.form => test_form.rb
      # response.tables[0], response.table => test_table.rb
      # response.frames[0], response.frame => test_frame.rb

      assert_instance_of( Array, response.links )
      assert_instance_of( Array, response.forms )
      assert_instance_of( Array, response.tables )
      assert_instance_of( Array, response.frames )

    end

    # test_click => test_link.rb

    def test_redirect

      url = @urlbase + "webunit/redirect.cgi"
      to = @urlbase + "webunit/response.html"

      response = Response::post( url, "redirect=#{to}" )
      assert_equals( 'POST', response.method )
      assert_equals( '302', response.code )
      assert_equals( to, response.link.href )

      response = response.redirect
      assert_equals( 'WebUnit::response', response.title )
      assert_exception( WebUnit::BadOperation ){
        response = response.redirect
      }

    end

    def test_search

      url = @urlbase + "webunit/link.html"
      response = Response::get( url )
      link = response.tree.search( 'self' )[0]

      assert_equals( 'a', link.tag )
      assert_equals( @urlbase + 'webunit/link.html', link.href )
      assert_equals( 'self', link.data )

      link = response.search( 'other' )[0]

      assert_equals( 'a', link.tag )
      assert_equals( @urlbase + 'webunit/link-0.html', link.href )
      assert_equals( 'other', link.data )

    end

  end

end
