=begin
= test for WebUnit::JSciriptOpenObject
  Copyright(C) 2001 yuichi TAKAHASHI
  $Id: test_jscript.rb,v 1.1.1.1 2003/01/21 11:50:40 yuichi Exp $
=end

require 'webunit/webunit'
require 'runit/cui/testrunner'

module WebUnit

  class TestJSciriptOpenObject < WebUnit::TestCase

    def test_JSciriptOpenObject

      url = @urlbase + "webunit/jscript.html"
      response = Response::get( url )
      assert_title( 'WebUnit::jscript', response )
      assert_equals( response.open.inspect, response.opens[0].inspect )

      opens = response.opens

      assert_urls( 'webunit/jscript-0.html', opens[0].url )
      assert_equals( 'jscript-0.html', opens[0].file )
      assert_equals( 'j0', opens[0].target )

      assert_urls( 'webunit/jscript-1.html', opens[1].url )
      assert_equals( 'jscript-1.html', opens[1].file )
      assert_equals( 'j1', opens[1].target )

      response = opens[0].read
      assert_title( 'WebUnit::jscript-0', response )

    end

    def test_accessor

      hash = { 'file'=>'jscript-1.html', 'target'=>'j1',
        'url'=>complete_url( 'jscript-1.html', @urlbase + 'webunit/x' ) }
      open = JSciriptOpenObject::new( hash )

      assert_urls( 'webunit/jscript-1.html', open.url )
      assert_equals( 'jscript-1.html', open.file )
      assert_equals( 'j1', open.target )

    end

    def test_read
      hash = { 'file'=>'jscript-1.html', 'target'=>'j1',
        'url'=>complete_url( 'jscript-1.html', @urlbase + 'webunit/x' ) }
      open = JSciriptOpenObject::new( hash )
      assert_title( 'WebUnit::jscript-1', open.read )
    end

  end

end
