=begin
= test for WebUnit::Frame
  Copyright(C) 2001 yuichi TAKAHASHI
  $Id: test_frame.rb,v 1.1.1.1 2003/01/21 11:50:40 yuichi Exp $
=end

require 'webunit/webunit'
require 'runit/cui/testrunner'

module WebUnit

  class TestFrame < WebUnit::TestCase

    def test_Response

      url = @urlbase + "webunit/frame.html"
      response = Response::get( url )
      assert_title( 'WebUnit:frame', response )
      assert_equals( response.frame, response.frames[0] )

      frames = response.frames
      assert_urls( 'webunit/frame-0.html', frames[0].src )
      assert_equals( 'f0', frames[0].name )
      assert_urls( 'webunit/frame-1.html', frames[1].src )
      assert_equals( 'f1', frames[1].name )

    end

    def test_accessor
      frame = Frame::new( 'src'=>@urlbase + 'xxx.html', 'name'=>'fx' )
      assert_urls( 'xxx.html', frame.src )
      assert_equals( 'fx', frame.name )
    end

    def test_read
      url = @urlbase + 'webunit/frame-0.html'
      frame = Frame::new( 'src'=>url, 'name'=>'fx' )
      assert_title( 'WebUnit::frame-0', frame.read )
    end

  end

end
