=begin Start of Document
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
<title>htmlsplit.rb</title>
<link href="rubydoc.css" rel="stylesheet">
</head>
<body>
| <a href="./"></a> |
<h1>HTML Split Library</h1>
<p> HTMLɤ߽񤭤롣 ɤ߹ʸϥʸˤʤ롣 to_s᥽åɤHTML᤹Ȥ롣</p>
<h2>饹</h2>
<table bgcolor="#FFFFFF" border="1">
  <tr><td><a href="#HTMLSplit">HTMLSplit</a><td>HTML򥿥ʸǡʬ䤹롣 
<tr>
	<td><a href="#CharacterData">CharacterData</a>
	<td>ʸǡ
  <tr><td><a href="#EmptyElementTag">EmptyElementTag</a>
	<td>ǤΥ
  <tr>
	<td><a href="#StartTag">StartTag</a>
	<td>ϥ
  <tr>
	<td><a href="#EndTag">EndTag</a>
	<td>λ
  <tr>
	<td><a href="#Comment">Comment</a>
	<td>
  <tr>
	<td><a href="#Declaration">Declaration</a>
	<td>(DOCTYPE)
  <tr>
	<td><a href="#SSI">SSI</a>
	<td>SSI
  <tr>
	<td><a href="#ERuby">ERuby</a>
	<td>eRuby/ASP/JSPץȢ
  <tr>
	<td><a href="#PHP">PHP</a>
	<td>PHPץȢ
  </table>
°ͤʤɤޤ줿ץȤǧǤޤ
<h2>Ȥ </h2>
<h3>ɤ߹</h3>
<pre class="Exception"><samp>#!/usr/bin/ruby
require "htmlsplit"

obj = HTMlSplit.new(ARGF.read)</samp></pre>
<h3></h3>
<pre>
obj.document.each {|e|
    print e.to_s
}
</pre>
<h3>°</h3>
<pre>
img = Tag('img/')
img['src']='xxx.png'  #&lt;img src="xxx.png"&gt;

o = Tag('option')
o['selected']=true    #&lt;option selected&gt;
</pre>
=end

require "cgi"
require "kconv"

=begin EmptyElementTag
 
<h2><a name="EmptyElementTag">EmptyElementTag</a></h2>
ǤΥ 
<h3>饹᥽å</h3>
<dl compact>
  <dt>new(<var class="String">name</var>[,<var class="Hash">attr</var>])
  <dd>֥Ȥ롣 <var class="String">name</var>ϥ̾ <var class="Hash">attr</var>ϥ°nilޤHash
</dl>
<h3>᥽å</h3>
<dl compact>
  <dt class="String">name
  <dd>֤̾
  <dt class="Hash">attr 
  <dd>°֤
  <dt class="String">to_s 
  <dd>HTML֤
  <dt class="String">self[<var class="String">key</var>]
  <dd>key˴ϢŤ줿°֤ͤޤ
      륭ϿƤʤˤϡnil֤ޤ
  <dt class="String">self[<var class="String">key</var>]= <var class="String">value</var>
  <dd><var class="String">key</var>Ф<var class="String">value</var>ϢŤޤ
      <var class="String">value</var>nilλ<var class="String">key</var>ФϢޤ
</dl>
=end
class EmptyElementTag
	def initialize(name,attr=nil)
		@name = name.downcase
		@attr = attr
	end
	attr_accessor :name
	attr_accessor :attr
	def to_s
		if @attr
			"<"+@name+@attr.keys.sort.collect{|n|
				v = @attr[n]
				if v==true
					' ' + n
				else
					' ' + n + '="' + CGI::escapeHTML(v) + '"'
				end
			}.to_s+">"
		else
			"<#{@name}>"
		end
	end
	def [](key)
		attr and attr[key]
	end
	def []=(key,value)
		if attr
			attr[key]=value
		else
			attr = value and {key=>value}
		end
	end
end
=begin StartTag
<h2>StartTag</h2>
ϥ
<h3>饹᥽å</h3>
<dl compact>
  <dt>new(<var class="String">name</var>[,<var class="Hash">attr</var>])
  <dd>֥Ȥ롣 <var class="String">name</var>ϥ̾ <var class="Hash">attr</var>ϥ°nilޤHash
</dl>
<h3>᥽å</h3>
<dl compact>
  <dt class="String">name
  <dd>֤̾
  <dt class="Hash">attr 
  <dd>°֤
  <dt class="String">to_s 
  <dd>HTML֤
  <dt class="String">self[<var class="String">key</var>]
  <dd>key˴ϢŤ줿°֤ͤޤ
      륭ϿƤʤˤϡnil֤ޤ
  <dt class="String">self[<var class="String">key</var>]= <var class="String">value</var>
  <dd><var class="String">key</var>Ф<var class="String">value</var>ϢŤޤ
      <var class="String">value</var>nilλ<var class="String">key</var>ФϢޤ
</dl>
=end
class StartTag
	attr_accessor :name
	attr_accessor :attr
	def initialize(name,attr=nil)
		@name = name.downcase
		@attr = attr
	end
	def to_s
		if @attr
			"<"+@name+@attr.keys.sort.collect{|n|
				v = @attr[n]
				if v==true
					' ' + n
				else
					' ' + n + '="' + CGI::escapeHTML(v) + '"'
				end
			}.to_s+">"
		else
			"<#{@name}>"
		end
	end
	def [](key)
		attr and attr[key]
	end
	def []=(key,value)
		if attr
			attr[key]=value
		else
			attr = value and {key=>value}
		end
	end
end
=begin EndTag
<h2>EndTag</h2>
λ
<h3>饹᥽å</h3>
<dl compact>
  <dt>new(<var class="String">name</var>)
  <dd>֥Ȥ롣 <var class="String">name</var>ϥ̾
</dl>
<h3>᥽å</h3>
<dl compact>
  <dt class="String">name 
  <dd>֤̾
  <dt class="String">to_s 
  <dd>HTML֤
</dl>
=end
class EndTag
	def initialize(name)
		@name = name.downcase
	end
	attr_accessor :name
	def to_s
		"</#{@name}>"
	end
end
=begin CharacterData
<h2>CharacterData</h2>
ʸǡ
<h3>饹᥽å</h3>
<dl compact>
  <dt>new(<var class="String">text</var>)
  <dd>֥Ȥ롣 <var class="String">text</var>ϥƥ
</dl>
<h3>᥽å</h3>
<dl compact>
  <dt class="String">text 
  <dd>ƥȤ֤
  <dt class="String">to_s 
  <dd>HTML֤
</dl>
=end
class CharacterData
	def initialize(text)
		@text = text
	end
	attr_accessor :text
	def to_s
		@text
	end
end
=begin Declaraion
<h2>Declaraion</h2>
SGML
<h3>饹᥽å</h3>
<dl compact>
  <dt>new(<var class="String">text</var>)
  <dd>֥Ȥ롣 <var class="String">text</var>ϥƥ
</dl>
<h3>᥽å</h3>
<dl compact>
  <dt class="String">text 
  <dd>ƥȤ֤
  <dt class="String">to_s 
  <dd>HTML֤
</dl>
=end
class Declaration
	def initialize(text)
		@text = text
	end
	attr_accessor :text
	def to_s
		"<!#{@text}>"
	end
end
=begin Comment
<h2>Comment</h2>

<h3>饹᥽å</h3>
<dl compact>
  <dt>new(<var class="String">text</var>)
  <dd>֥Ȥ롣 <var class="String">text</var>ϥƥ
</dl>
<h3>᥽å</h3>
<dl compact>
  <dt class="String">text 
  <dd>ƥȤ֤
  <dt class="String">to_s 
  <dd>HTML֤
</dl>
=end
class Comment
	def initialize(text)
		@text = text
	end
	attr_accessor :text
	def to_s
		"<!--#{@text}-->"
	end
end
=begin SSI
<h2>SSI</h2>
SSI
<h3>饹᥽å</h3>
<dl compact>
  <dt>new(<var class="String">text</var>)
  <dd>֥Ȥ롣 <var class="String">text</var>ϥƥ
</dl>
<h3>᥽å</h3>
<dl compact>
  <dt class="String">text 
  <dd>ƥȤ֤
  <dt class="String">to_s 
  <dd>HTML֤
</dl>
=end
class SSI
	def initialize(text)
		@text = text
	end
	attr_accessor :text
	def to_s
		"<!--#{@text}-->"
	end
end
=begin ERuby
<h2>ERuby</h2>
eRuby/ASP/JSPץ
<h3>饹᥽å</h3>
<dl compact>
  <dt>new(<var class="String">text</var>)
  <dd>֥Ȥ롣 <var class="String">text</var>ϥƥ
</dl>
<h3>᥽å</h3>
<dl compact>
  <dt class="String">text 
  <dd>ƥȤ֤
  <dt class="String">to_s 
  <dd>HTML֤
</dl>
=end
class ERuby
	def initialize(text)
		@text = text
	end
	attr_accessor :text
	def to_s
		"<%#{@text}%>"
	end
end
=begin PHP
<h2>PHP</h2>
PHPץ
<h3>饹᥽å</h3>
<dl compact>
  <dt>new(<var class="String">text</var>)
  <dd>֥Ȥ롣 <var class="String">text</var>ϥƥ
</dl>
<h3>᥽å</h3>
<dl compact>
  <dt class="String">text 
  <dd>ƥȤ֤
  <dt class="String">to_s 
  <dd>HTML֤
</dl>
=end
class PHP
	attr_accessor :text
	def initialize(text)
		@text = text
	end
	def to_s
		"<?#{@text}?>"
	end
end
=begin HTMLSplit
 
<h2><a name="HTMLSplit">HTMLSplit</a></h2>
HTMLɤ߽ 
<h3>饹᥽å</h3>
<dl compact>
  <dt>new(<var class="String">html</var>)
  <dd>֥Ȥ롣 <var class="String">html</var>HTMLʸ
</dl>
<h3>᥽å</h3>
<dl compact>
  <dt class="Array">document 
  <dd>ɥȤ֤
  <dt class="String">to_s 
  <dd>HTML֤
  <dt class="Iterator">each {|<var>obj</var>,<var class="Array">tag</var>| ...}
  <dd>ɥȤγƥ֥(<var>obj</var>)Фƥ֥åɾޤ
      <var class="Array">tag</var>ϳϥΥꥹȡ [ StartTag , <var class="Integer">ǥ</var>] 
  <dt class="Integer">index(<var class="Class">class</var>, <var class="Integer">start</var>, <var class="Integer">end</var>, <var>value</var>, <var class="Integer">count</var>) {|obj| ...}
  <dd><var class="Integer">start</var><var class="Integer">end</var>ޤǤǤ<var class="Class">class</var><var class="Integer">count</var>ܤǤΰ֤֤ޤ
      ǤҤȤĤʤäˤnil֤ޤ<br>
      <var>value</var>nilʳͤꤷˤǤ<var>value</var>åԤޤ<var class="Class">class</var>EmptyElementTag,StartTag,EndTagλϥ̾ʳϥƥȤˤäӤޤ<br>
      ֥åꤷƸƤӽФ줿ˤϥ֥åǤɾ롣
  <dt class="Integer">end_index(<var class="Integer">start</var>)
  <dd><var class="Integer">start</var>бEndTagΥǥ֤ޤ
      бǤʤäˤnil֤ޤ<br>
</dl>
=end
class HTMLSplit
	EMPTY = %w(area base basefont bgsound br col frame hr img input isindex 
	           keygen link meta nextid param spacer wbr)
	def initialize(html)
		@document = []	#ѡHTMLΥꥹ
		name = ''
		text = ''
		attr = {}
		attrname = ''
		state = :TEXT
		#
		html.each_byte {|c|
			char = c.chr
			case state
			when :TEXT
				if c==60
					if text.length>0
						@document << CharacterData.new(text)
					end
					name = ''
					attr={}
					state = :TAGNAME
				else
					text << char
				end
			when :TAGNAME
				case char
				when '>'
					name.downcase!
					if EMPTY.include?(name)
						@document << EmptyElementTag.new(name,nil)
                    elsif name[-1,1]=='/'
					    @document << StartTag.new(name[0..-2],nil)
                        @document << EndTag.new(name[0..-2])
					else
						if name[0,1]=='/'
							@document << EndTag.new(name[1..-1])
						else
							@document << StartTag.new(name,nil)
						end
					end
					text = ''
					state = :TEXT
				when '!'
					text = ''
					state = :DECLARE
				when '%'
					text = ''
					state = :ERUBY
				when '?'
					text = ''
					state = :PHP
				when /\s/
					text=''
					state = :SPACE
				else
					name << char
				end
			when :SPACE	#°֤ζ
				case char
				when '>'
					name.downcase!
					if EMPTY.include?(name)
						@document << EmptyElementTag.new(name,attr)
					else
						if name[0,1]=='/'
							@document << EndTag.new(name[1..-1])
						else
							@document << StartTag.new(name,attr)
						end
					end
					text = ''
					state = :TEXT
				when /\s/
				else
					attrname=char
					state = :ATTRNAME
				end
			when :ATTRNAME	#°̾
				case char
				when /\s/
					state = :BEFOREEQUAL
				when '='
					state = :AFTEREQUAL
				when '>'
					attr[attrname.downcase]=true
					name.downcase!
					if EMPTY.include?(name)
						@document << EmptyElementTag.new(name,attr)
                    elsif attrname=='/'
                        attr.delete('/')
					    @document << StartTag.new(name,attr)
                        @document << EndTag.new(name)
					else
						if name[0,1]=='/'
							@document << EndTag.new(name[1..-1])
						else
							@document << StartTag.new(name,attr)
						end
					end
					text = ''
					state = :TEXT
				else
					attrname << char
				end
			when :BEFOREEQUAL	#=
				case char
				when '='
					state = :AFTEREQUAL
				when '>'
					attr[attrname.downcase]=true
					name.downcase!
					if EMPTY.include?(name)
						@document << EmptyElementTag.new(name,attr)
					else
						if name[0,1]=='/'
							@document << EndTag.new(name[1..-1])
						else
							@document << StartTag.new(name,attr)
						end
					end
					text = ''
					state = :TEXT
				when /\s/
				else
					attr[attrname.downcase]=true
					attrname = char
					state = :ATTRNAME
				end
			when :AFTEREQUAL	#=
				case char
				when "'"
					text=''
					state = :SQVALUE
				when '"'
					text=''
					state = :DQVALUE
				when '>'
					attr[attrname.downcase]=true
					name.downcase!
					if EMPTY.include?(name)
						@document << EmptyElementTag.new(name,attr)
					else
						if name[0,1]=='/'
							@document << EndTag.new(name[1..-1])
						else
							@document << StartTag.new(name,attr)
						end
					end
					text = ''
					state = :TEXT
				when /\s/
				else
					text=char
					state = :VALUE
				end
			when :VALUE		#
				case char
				when /\s/
					attr[attrname.downcase]=CGI::unescapeHTML(text)
					state = :SPACE
				when '>'
					attr[attrname.downcase]=CGI::unescapeHTML(text)
					name.downcase!
					if EMPTY.include?(name)
						@document << EmptyElementTag.new(name,attr)
					else
						if name[0,1]=='/'
							@document << EndTag.new(name[1..-1])
						else
							@document << StartTag.new(name,attr)
						end
					end
					text = ''
					state = :TEXT
				else
					text << char
				end
			when :SQVALUE	#''
				if c==39
					attr[attrname.downcase]=CGI::unescapeHTML(text)
					state = :SPACE
				else
					text << char
				end
			when :DQVALUE	#""
				if c==34
					attr[attrname.downcase]=CGI::unescapeHTML(text)
					state = :SPACE
				else
					text << char
				end
			when :COMMENT
				case char
				when '>'
					if text[-2,2]=='--'	#Ƚλ	
						text = text[0..-3]
						if text=~/^#[a-z]+/	#SSI
							@document << SSI.new(text)
						else
							@document << Comment.new(text)
						end
						text = ''
						state = :TEXT
					else
						text << char
					end
				else
					text << char
				end
			when :ERUBY
				case char
				when '>'
					if text[-1,1]=='%'	#eRubyλ	
						text = text[0..-2]
						@document << ERuby.new(text)
						text = ''
						state = :TEXT
					else
						text << char
					end
				else
					text << char
				end
			when :PHP
				case char
				when '>'
					if text[-1,1]=='?'	#eRubyλ	
						text = text[0..-2]
						@document << PHP.new(text)
						text = ''
						state = :TEXT
					else
						text << char
					end
				else
					text << char
				end
			when :DECLARE
				case char
				when '>'
					@document << Declaration.new(text)
					text = ''
					state = :TEXT
				else
					text << char
					if text=='--'
						text = ''
						state = :COMMENT
					end
				end
			end
		}
		#EOFν
		case state
		when :TEXT
			@document << CharacterData.new(text) if text.length>0
		when :TAGNAME
			@document << CharacterData.new('<'+text)
		when :SPACE	#°֤ζ
			name.downcase!
			if EMPTY.include?(name)
				@document << EmptyElementTag.new(name,attr)
			else
				if name[0,1]=='/'
					@document << EndTag.new(name[1..-1])
				else
					@document << StartTag.new(name,attr)
				end
			end
		when :ATTRNAME	#°̾
			attr[attrname.downcase]=true
			name.downcase!
			if EMPTY.include?(name)
				@document << EmptyElementTag.new(name,attr)
			else
				if name[0,1]=='/'
					@document << EndTag.new(name[1..-1])
				else
					@document << StartTag.new(name,attr)
				end
			end
		when :BEFOREEQUAL	#=
			attr[attrname.downcase]=true
			name.downcase!
			if EMPTY.include?(name)
				@document << EmptyElementTag.new(name,attr)
			else
				if name[0,1]=='/'
					@document << EndTag.new(name[1..-1])
				else
					@document << StartTag.new(name,attr)
				end
			end
		when :AFTEREQUAL	#=
			attr[attrname.downcase]=true
			name.downcase!
			if EMPTY.include?(name)
				@document << EmptyElementTag.new(name,attr)
			else
				if name[0,1]=='/'
					@document << EndTag.new(name[1..-1])
				else
					@document << StartTag.new(name,attr)
				end
			end
		when :VALUE		#
			attr[attrname.downcase]=CGI::unescapeHTML(text)
			name.downcase!
			if EMPTY.include?(name)
				@document << EmptyElementTag.new(name,attr)
			else
				if name[0,1]=='/'
					@document << EndTag.new(name[1..-1])
				else
					@document << StartTag.new(name,attr)
				end
			end
		when :SQVALUE	#''
			attr[attrname.downcase]=CGI::unescapeHTML(text)
		when :DQVALUE	#""
			attr[attrname.downcase]=CGI::unescapeHTML(text)
		when :COMMENT
			if text=~/^#[a-zA-Z]+/	#SSI
				@document << SSI.new(text)
			else
				@document << Comment.new(text)
			end
		when :ERUBY
			@document << ERuby.new(text)
		when :PHP
			@document << PHP.new(text)
		when :DECLARE
			@document << Declaration.new(text)
		end
	end
	#
	attr_accessor :document
	#
	def to_s
		s = ''
		@document.each {|e|
			s<<(e.to_s)
		}
		s
	end
	#
	def each
		tag = []
		i = 0
		@document.each {|e|
			case e
			when StartTag
				tag.push [e,i]
			when EndTag
				idx = nil
				(tag.size-1).downto(0) {|j|
					if tag[j][0].name==e.name
						idx = j
						break
					end
				}
				#
				if idx
					if idx==0
						tag = []
					else
						tag = tag[0..idx-1]
					end
				end
			else
			end
			yield e,tag
			i += 1
		}
	end
	#
	def index(_class,_start=0,_end=-1,value=nil,count=1)
		idx=_start
		found=false
		@document[_start.._end].each {|obj|
			if obj.type==_class
				if value
					case obj
					when StartTag,EmptyElementTag,EndTag
						if value===obj.name
							if (not iterator?) or yield(obj)
								if (count-=1)<=0
									found = true
									break
								end
							end
						end
					else
						if value===obj.text
							if (not iterator?) or yield(obj)
								if (count-=1)<=0
									found = true
									break
								end
							end
						end
					end
				else
					if (not iterator?) or yield(obj)
						if (count-=1)<=0
							found = true
							break
						end
					end
				end
			end
			idx+=1
		}
		if found
			idx
		else
			nil
		end
	end
	#
	def end_index(start_index)
		tag = []
		end_index = nil
		(start_index...@document.size).each {|idx|
			e= @document[idx]
			case e
			when StartTag
				tag.push [e,idx]
			when EndTag
				i = nil
				(tag.size-1).downto(0) {|j|
					if tag[j][0].name==e.name
						i = j
						break
					end
				}
				#
				if i
					if i==0
						tag = []
					else
						tag = tag[0..i-1]
					end
				end
				if tag.size==0
					end_index = idx
					break
				end
			else
			end
		}
		end_index
	end
end
=begin End of Document
</body>
</html>
=end
