// Copyright © 2019 The Vultr-cli Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package cmd

import (
	"context"
	"errors"
	"fmt"
	"os"

	"github.com/spf13/cobra"
	"github.com/vultr/vultr-cli/v2/cmd/printer"
)

// accountCmd represents the account command
var accountCmd = &cobra.Command{
	Use:   "account",
	Short: "Retrieve information about your account",
	Long:  ``,
	Run: func(cmd *cobra.Command, args []string) {
		account, _, err := client.Account.Get(context.Background())
		if err != nil {
			fmt.Printf("Error getting account information : %v\n", err)
			os.Exit(1)
		}

		printer.Account(account)
	},
	PersistentPreRunE: func(cmd *cobra.Command, args []string) error {
		if !cmd.Context().Value(ctxAuthKey{}).(bool) {
			return errors.New(apiKeyError)
		}
		return nil
	},
}
