/*
 * tmpstring.c -- Implementation of temporary string save function
 *
 * (C) m.b (Matthias Blume); Jun 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: tmpstring.c,v 2.6 1994/11/12 22:25:07 blume Exp $
 */

# include "rcs.h"
RCSID ("$Id: tmpstring.c,v 2.6 1994/11/12 22:25:07 blume Exp $")

# include <stdlib.h>
# include <string.h>

# include "realloc.h"

# define TMPBUF_SIZE 256

# include "tmpstring.h"
# include "except.h"

static char *save_buf = NULL;
static unsigned save_buf_len = 0;

static char *tmpbuf = NULL;
static unsigned tmpbuf_buf_len = 0;
static unsigned tmpbuf_len = 0;

static int initialized = 0;

static void deallocate_all (void)
{
  if (save_buf != NULL)
    free (save_buf);
  if (tmpbuf != NULL)
    free (tmpbuf);
}

static void initialize (void)
{
  if (!initialized) {
    initialized = 1;
    atexit (deallocate_all);
  }
}

char *tmpstring (const char *s, unsigned len)
{
  char *tmp;
  if (len >= save_buf_len) {
    initialize ();
    tmp = REALLOC (save_buf, len + 1);
    if (tmp == NULL)
      reset ("Out of space in tmpstring");
    save_buf = tmp;
    save_buf_len = len + 1;
  }
  memcpy (save_buf, s, len);
  save_buf [len] = '\0';
  return save_buf;
}

/*ARGSUSED*/
void tmpbuf_putc (int c, void *ignore)
{
  char *tmp;

  if (tmpbuf_len >= tmpbuf_buf_len) {
    initialize ();
    tmp = REALLOC (tmpbuf, tmpbuf_buf_len + TMPBUF_SIZE);
    if (tmp == NULL)
      reset ("Out of memory in tmpbuf_putc");
    tmpbuf = tmp;
    tmpbuf_buf_len += TMPBUF_SIZE;
  }
  tmpbuf [tmpbuf_len++] = c;
}

const char *tmpbuf_get (size_t *len_ptr)
{
  *len_ptr = tmpbuf_len;
  tmpbuf_putc ('\0', NULL);
  return (const char *) tmpbuf;
}

void tmpbuf_reset (void)
{
  tmpbuf_len = 0;
}
