(define (boot-functor macro-mod be-mod soft-mod)

  (module boot-sig ()

    (use raw-system-sig)
    (use macro-mod macro-sig)
    (use be-mod be-sig)
    (use soft-mod soft-sig soft)

    (define (source->asm exp) (exp->asm (expand exp)))

    (define (gen-boot-loader scm-file asm-file)
      (let* ((source ((soft with-input-from-file) scm-file read))
	     (gen-boot-loader-code (source->asm source))
	     (boot-loader-boot-code
	      `("boot"
		1
		#f
		#(args)
		(,gen-boot-loader-code)
		4
		0
		(get-loc 1)
		(take-false)
		(lambda 0)
		(call 1)
		(call-exit 1))))

	(define (write-it)
	  (write boot-loader-boot-code)
	  (newline))

	((soft with-output-to-file) asm-file write-it)))))
