/*
 * Procedure.c -- Implementation of Scheme Procedures
 *
 * (C) m.b (Matthias Blume); Mar 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: Procedure.c,v 2.6 1994/11/12 22:17:20 blume Exp $
 */

# include "rcs.h"
RCSID ("$Id: Procedure.c,v 2.6 1994/11/12 22:17:20 blume Exp $")

# include <stdio.h>

# include "storext.h"
# include "Procedure.h"
# include "identifier.h"

static void iterator (void *vsproc, MEM_visitor proc, void *cd)
{
  ScmProcedure *sproc = (ScmProcedure *) vsproc;

  (*proc) ((void *)&sproc->env, cd);
  (*proc) ((void *)&sproc->code, cd);
}

/* this is a hack! (should go into a header file...) */
extern void ScmDisplayCode (void *vcode, putc_proc pp, void *cd);

static void display (void *vproc, putc_proc pp, void *cd)
{
  putc_string ("#<Procedure ", pp, cd);
  ScmDisplayCode (((ScmProcedure *)vproc)->code, pp, cd);
  (* pp) ('>', cd);
}

MEM_VECTOR (Procedure,
	    MEM_UNITS (sizeof (ScmProcedure)), MEM_NULL_measure,
	    iterator, MEM_NULL_dumper, MEM_NULL_excavator, MEM_NULL_revisor,
	    MEM_NULL_task, MEM_NULL_task, MEM_NULL_task,
	    EXT (SCM_NO_NUMBER,
		 cannot_cvt_real, display, display, NULL_eq, NULL_eq));
