;;########################################################################
;; ViSta - The Visual Statistics System
;; Copyright (c) 1991-98 by Forrest W. Young
;; Version 5.0.5 Beta, March 29th, 1998 
;; For further information contact the author at forrest@unc.edu
;; This file contains initialization code
;;########################################################################
;;ViSta runs under the Lisp-Stat statistical computing environment.
;;This is the file to load ViSta once Lisp-Stat is running.  
;;ViSta works on Macintosh microcomputers (68040 & PowerPC), and on IBM
;;compatibles with Windows 3.1 (16 or 32 bit), 95, or NT, and with OS/2 
;;This release has not been tested under Unix, though earlier releases 
;;worked with Unix with X11. 
;;########################################################################

(defun strcat (&rest args) (apply #'concatenate 'string args))

(let* ((separator
        #+macintosh ":"
        #+msdos "\\"
        #+X11 "/"
        )
;;
;; CHANGE FOLLOWING LINE FOR UNIX: 
;; For Unix, the following line must be the home location of
;; Vista, i.e. it should be $YourDir/vista

       #+X11(working-directory "/usr/local/lib/vista")
 


;; CHANGE MAY BE NEEDED FOR WINDOWS: 
;; You may need to change which of the two following
;; statements is commented (; is the comment symbol).
;; The value of the variable *default-path* is set by the config.lsp file,
;; and it is saved in the wxls32.ini file, which is loaded on startup.
;; This value is independent of where the exe file is located.
;; The value of the (get-working-directory) function always correpsonds to 
;; the directory in which the exe file is located.

;;     #+msdos (working-directory *default-path*) ;USE WXLS32.INI FILE
       #+msdos (working-directory (strcat (get-working-directory) separator))



       #+X11(working-directory (strcat working-directory separator))
       #+macintosh(working-directory (get-working-directory))
       )
  (setf *separator* separator)
  (setf *startup-dir* working-directory)
  (setf *vista-dir-name*    (strcat *startup-dir* "code" *separator*))
  (setf *data-dir-name*     (strcat *startup-dir* "data" *separator*))
  (setf *code-dir-name*     (strcat *startup-dir* "code" *separator*))
  (setf *base-dir-name*     (strcat *startup-dir* "base" *separator*))
  (setf *user-dir-name*     (strcat *startup-dir* "user" *separator*))
  (setf *prefs-dir-name*    (strcat *startup-dir* "prefs" *separator*))
  (setf *example-dir-name*  (strcat *startup-dir* "examples" *separator*))
  (setf *examples-dir-name* (strcat *startup-dir* "examples" *separator*))
  (setf *examples-data-dir-name* (strcat *startup-dir* "data" *separator*))
  (setf *help-dir-name*  (strcat *startup-dir* "code" separator "help" *separator*))
  (setf *guide-dir-name* (strcat *startup-dir* "code" separator "guidance" *separator*))

;;CHANGE FOR NETWORKED WINDOWS
;;for networked private user space under win 95 and NT use the following
;;statement or a suitable modification of it. To make this statement
;;effective, remove the semicolons - they make it a comment.
;;Note that the double \\ are needed by Lisp to see a single \

;;#+msdos(setf *user-dir-name*  "C:\\ViSta\\user\\")
;;#+X11(setf *user-dir-name*  "$HOME/.vista")
  
  )

(setf *color-mode* 1)
(setf config-vistaxls nil)
(SETF *CHANGE-PROFILES* T)
(SETF *CONFIGURE* T)
(SETF *AUTHOR* NIL)
(SETF *CONFIGURE* T)
(SETF *FULL-SCREEN* NIL)

(load (strcat *prefs-dir-name* "prefload"))

#+msdos (when config-vistaxls 
              (let ((oldbreak *breakenable*)
                    (f (open (strcat *prefs-dir-name* 
                                     "prefload.lsp") 
                             :direction :output)))
                (setq *breakenable* nil)
                (unwind-protect
                 (princ `(SETF ASK-LOAD-VISTA NIL) f)
                 (princ "(SETF *CHANGE-PROFILES* T)" f)
                 (princ "(SETF *CONFIGURE* T)" f)
                 (princ "(SETF *AUTHOR* NIL)" f)
                 (princ "(SETF *COLOR-MODE* 1)" f)
                 (princ "(SETF *CONFIGURE* T)" f)
                 )
                (setq *breakenable* oldbreak)
                (close f))
              (load "config"))

#+macintosh(defun repeat-command ()
"Repeats previous command.  Written by Frederic Udina."
  (send *listener* :paste-string (string-downcase (format nil "~s" -)))
  (send *listener* :show-window))

#+macintosh(defun add-repeat-to-menu ()
; Next statement prevents error if calling the repeat function before
; - is defined by the first read
  (setq - nil)
  (send *command-menu*
        :append-items
        (send menu-item-proto
              :new "Repeat Command"
              :action 'repeat-command
              :key #\')))

#+macintosh(add-repeat-to-menu)

(defun load-vista ()
  (let ((yesno t)
        )
    (when ask-load-vista
          (setf yesno (ok-or-cancel-dialog (format nil "XLisp-Stat has been loaded.~%Proceed to Load ViSta as well?"))))
    (when yesno
          (expand 85)
          (when (not (load (strcat *vista-dir-name* "vista")
                           :if-does-not-exist nil))
                (message-dialog 
                 (format nil "ERROR: ViSta was not found.
~%It was sought in directory: ~%~a~%You must restructure your files~%so that ViSta is in that directory." *vista-dir-name*) t)))))

(provide "statinit")
#+msdos(when (not config-vistaxls) (load-vista))
#-msdos(load-vista)
