;;########################################################################
;; workmap3.lsp
;; code to delete objects from the workmap
;; Copyright (c) 1992-95 by Forrest W. Young
;;########################################################################  

;;the following code is not yet completed and is overridden by 
;;the error message at the end of the file

(defmeth workmap-proto :delete-data ()
  (when (not (equal current-object current-data)) (setcd current-data))
  (send self :delete-current-object))

(defmeth workmap-proto :delete-model () 
  (when (not (equal current-object current-model)) (setcm current-model))
  (send self :delete-current-object))

(defmeth workmap-proto :delete-current-object ()
"Deletes selected non-terminal data icon"
  (let* ((num-icons (send *workmap* :num-icons))
         (num-remaining (1- num-icons))
         (dead-icon-number (send *workmap* :selected-icon))
         (dead-icon-type 
          (select (send *workmap* :icon-type) dead-icon-number))
         (num-list (remove dead-icon-number (iseq num-icons)))
         (cl nil) (locate nil)
         )
;doesn't work for long menus (have to remove menu item)
    (cond
      ((not (first (select (send *workmap* :connection-list)
                           dead-icon-number)))
       (when (or (= 1 dead-icon-type) (= 4 dead-icon-type) 
                 (= 5 dead-icon-type)) ;data being deleted
             (send *workmap* :update-obj-menu-length
                   dead-icon-number (send *workmap* :data-icon-list))
             (send *workmap* :data-icon-list
                   (remove (select (send *workmap* :data-icon-list) 
                      (position (send *workmap* :selected-icon) 
                                (send *workmap* :data-icon-number-list)))
                           (send *workmap* :data-icon-list)))
             (send *workmap* :data-icon-number-list 
                   (send *workmap* :update-icon-number-list 
                         dead-icon-number 
                         (send *workmap* :data-icon-number-list)))
             (send *workmap* :num-data-icons 
                   (1- (send *workmap* :num-data-icons)))
             (when (send *vista* :long-menus)
                   (send *workmap* :num-data-menu-items 
                         (1- (send *workmap* :num-data-menu-items))))
             )
       (when (= 3 dead-icon-type) ; model being deleted
             (send *workmap* :update-obj-menu-length
                   dead-icon-number (send *workmap* :model-icon-list))
             (send *workmap* :model-icon-list
                   (remove (select (send *workmap* :model-icon-list) 
                      (position (send *workmap* :selected-icon) 
                                (send *workmap* :model-icon-number-list)))
                           (send *workmap* :model-icon-list)))
             (send *workmap* :model-icon-number-list
                   (send *workmap* :update-icon-number-list 
                         dead-icon-number
                         (send *workmap* :model-icon-number-list)))
             (send *workmap* :num-model-icons 
                   (1- (send *workmap* :num-model-icons)))
             (when (send *vista* :long-menus)
                   (send *workmap* :num-model-menu-items 
                         (1- (send *workmap* :num-model-menu-items))))
             )
       (send *workmap* :num-icons num-remaining)
       (send *workmap* :icon-list 
             (select (send *workmap* :icon-list) num-list))
       (send *workmap* :x 
             (select (send *workmap* :x) num-list))
       (send *workmap* :y 
             (select (send *workmap* :y) num-list))
       (send *workmap* :icon-type 
             (select (send *workmap* :icon-type) num-list))
       (send *workmap* :icon-title 
             (select (send *workmap* :icon-title) num-list))
       (send *workmap* :connection-list 
             (select (send *workmap* :connection-list) num-list))
       (setf cl (send *workmap* :connection-list))
       (dotimes (i num-remaining)
                (setf locate (position dead-icon-number (select cl i)))
                (when locate 
                      (if (= (length (select cl i)) 1)
                          (setf (select cl i) '(nil))
                          (setf (select cl i) 
                                (reverse (rest (reverse (select cl i))))))))
       (dotimes (i num-remaining)
                (dotimes (j (length (select cl i)))
                         (when (select (select cl i) j)
                               (when (> (select (select cl i) j) 
                                        dead-icon-number)
                                     (setf (select (select cl i) j)
                                           (1- (select (select cl i) j)))))))
       (send *workmap* :redraw-order 
             (send *workmap* :update-icon-number-list 
                   dead-icon-number (send *workmap* :redraw-order)))
;should work to here for any icon but below only for selected icon
;now set redraw order to all but selected icon
       (send *workmap* :selected-icon 
             (first (reverse (send *workmap* :redraw-order))))
       (when (or (= 1 dead-icon-type) (= 4 dead-icon-type) 
                 (= 5 dead-icon-type))
             (send *workmap* :selected-data-icon 
                   (send *workmap* :selected-icon))) ;(break)
       (send *workmap* :set-previous-data-icon)
       (send *workmap* :redraw)
       )
      (t (error-message "Can't delete icon tree.")))
    ))

(defmeth workmap-proto :update-icon-number-list 
  (dead-icon-number icon-number-list)
  (let ((inl (remove dead-icon-number icon-number-list))
        (stat-object nil)
        (menu-length nil))
    (dotimes (i (length inl))
             (when (> (select inl i) dead-icon-number)
                   (setf (select inl i) (1- (select inl i)))
                   ))
    inl))

(defmeth workmap-proto :update-obj-menu-length 
  (dead-icon-number obj-icon-list)
  (let* ((dead-menu-item-number 
          (send (send (select (send self :icon-list) dead-icon-number)
                      :object) :menu-length))
         (live-menu-item-number nil)
         )
    (dotimes (i (length obj-icon-list))
             (setf live-menu-item-number
                   (send (send (select obj-icon-list i)
                               :object) :menu-length))
             (when (> live-menu-item-number dead-menu-item-number)
                   (send (send (select obj-icon-list i)
                               :object) :menu-length 
                         (1- live-menu-item-number))))
    ))

(defmeth workmap-proto :set-previous-data-icon ()
  (let* ((rro (reverse (send *workmap* :redraw-order)))
         (dinl (send *workmap* :data-icon-number-list))
         (numic (length rro)))
    (dotimes (i numic)
             (when (member (select rro i) dinl)
                   (send self :previously-selected-data-icon (select rro i))
                   (return)))))
             
(defmeth workmap-proto :delete-data ()
  (error-message "Delete Data is not yet implemented."))

(defmeth workmap-proto :delete-model () 
  (error-message "Delete Model is not yet implemented."))
