;;************************************************************************
;; graphic0.lsp 
;; contains code for revised graph-proto methods
;; copyright (c) 1991-98 by Forrest W. Young
;;************************************************************************

(defmeth graph-proto :do-nothing (x y m1 m2)); used by do-nothing cursor

(defmeth graph-window-proto :find-again ());prevents edit menu item error

(defmeth graph-proto :plot-buttons 
    (&key (margin (list 0 (+ 17 (send self :text-descent)) 0 0)) 
          (help t) (color t) (mouse-mode t) 
          (new-x t) (new-y t) (new-z nil) (equate nil)
          (normal nil) (density nil) (smooth nil) (bins nil) (box nil) 
          (iterate nil) (undo nil))
  (when margin (apply #'send self :margin margin))
  (when (= *color-mode* 0) (setf color nil))
  (let ((overlay 
         (first (send self :add-overlay 
                      (send vista-graph-overlay-proto :new 
                            :help help :color color :mouse-mode mouse-mode 
                            :new-x new-x :new-y new-y :new-z new-z 
                            :density density :smooth smooth
                            :normal normal :bins bins :box box :equate equate
                            :iterate iterate :undo undo))))
        )
    (defmeth self :do-motion (x y)
      (let* ((margin (send self :margin))
             )
        (cond
          ((and (> (second margin) 0) (<= y (second margin)))
           (send self :cursor 'solid-arrow))
          ((and (> (fourth margin) 0)
                (> y (- (send self :canvas-height) (fourth margin))))
           (send self :cursor 'solid-arrow))
          ((and (> (first margin) 0) (<= x (first margin)))
           (send self :cursor 'solid-arrow))
          ((and (> (third margin) 0) 
                (> x (- (send self :canvas-width) (third margin))))
           (send self :cursor 'solid-arrow))
          (t
           (when (not (eq (send self :cursor) (send self :set-mode-cursor)))
                 (send self :cursor) (send self :set-mode-cursor))
           (send self :do-brush-motion x y)))
        overlay))))

(send *help-menu* :append-items
      (send menu-item-proto :new "Listener"
            :action 'listener-help))

(defmeth graph-window-proto :add-plot-help-item  (&optional title)
  (let* ((g self)
         (m (send menu-item-proto :new (if title title (send g :title))
                  :action '(lambda ()
                      (send (send self :slot-value 'plot-obj) :plot-help)))))
    (send m :add-slot 'plot-obj g)
    (send g :add-slot 'plot-help-menu m)
    (send *help-menu* :append-items m)
    (defmeth g :remove ()
      (send *help-menu* :delete-items 
            (send self :slot-value 'plot-help-menu))
      (call-next-method))
    m))

(defmeth graph-proto :replace-points (matrix labels symbols colors states)
"Method args: (coordinates labels symbols colors states)
Replaces current coordinates of points with new coordinates contained in the coordinates matrix.  Sets labels, symbols, colors and states with appropriate lists.  Forrest W. Young"
  (let ((n (send self :num-points))
        )
    (send self :transformation nil                 :draw nil)
    (send self :clear                              :draw nil)
    (send self :add-points  (column-list matrix)
               :point-labels labels                :draw nil)
    (send self :point-state (iseq n) states        :draw nil)
    (send self :point-symbol (iseq n) symbols      :draw nil)
    (send self :point-color (iseq n) colors        :draw nil)
    (send self :adjust-to-data)))

(defmeth graph-proto :subordinates (&optional (list nil set))
      (if set (setf (slot-value 'subordinates) list))
      (slot-value 'subordinates))

(defmeth graph-proto :add-rays (rays &key ray-labels (ray-color 'black))
"Method args: (rays &key ray-labels ray-color no-points)
Adds rays to spin-plot or scatterplot.  Rays are lines drawn from the center of the spin-plot to locations specified by RAYS, a list of sequences.  There must be one sequence for each dimension of the spin-plot.  The ray-ends are labled when RAY-LABELS, a list of strings, is used.  When RAY-LABELS is specified, the rays have points at their end, but not otherwise. The points can be selected to show the ray labels. Rays (and their points) are colored when RAY-COLOR, a color symbol, is used (black by default). Forrest W. Young"
  (let* (
         (ndim   (send self :num-variables))
         (nrays  (length (select rays 0)))
         (numoldlines (send self :num-lines))
         (numoldpoints (send self :num-points))
         (center (send self :center (iseq ndim)))
         (rays-matrix (transpose (matrix (list ndim nrays) (combine rays))))
         (line-matrix ()))
    (dotimes (i nrays)
             (setf line-matrix 
              (matrix (list 2 ndim) 
                      (combine center (+ center (row rays-matrix i)))))
             (send self :add-lines (column-list line-matrix)))
    (send self :use-color t)
    (send self :linestart-color 
          (iseq numoldlines (- (send self :num-lines) 1)) ray-color)
    (send self :linestart-width 
          (iseq numoldlines (- (send self :num-lines) 1)) 2)
    (when ray-labels
          (send self :add-points 
                (column-list 
                 (+ rays-matrix 
                    (matrix (list nrays ndim) (combine 
                            (make-list nrays :initial-element center)))))
                :point-labels ray-labels
                )
          (send self :point-symbol
                (iseq numoldpoints (- (send self :num-points) 1)) 'dot1)
          (send self :point-color
                (iseq numoldpoints (- (send self :num-points) 1)) 
                ray-color)))
  nil)


(send graph-proto :menu-template '(link showing-labels mouse resize-brush dash 
                                        erase-selection focus-on-selection
                                        show-all symbol
					color
                                        selection dash 
					slicer 
                                        rescale 
                                        options
#+unix                                  save-image
#-unix save-to-clipboard))
         
(defmeth graph-proto :make-menu-item (item-template)
  (if (kind-of-p item-template menu-item-proto)
      item-template
      (case item-template
        (dash (send dash-item-proto :new))
        (link (send link-item-proto :new self))
        (erase-selection
         (send graph-item-proto :new "Remove Selection" self 
               :erase-selection :any-points-selected-p))
        (focus-on-selection
         (send graph-item-proto :new "Focus on Selection" self 
               :focus-on-selection :any-points-selected-p))
        (showing-labels 
         (send graph-item-proto :new "Show Labels" self
               :showing-labels :showing-labels :toggle t))
        (show-all
         (send graph-item-proto :new "Show All" self 
               :show-all-points :all-points-showing-p :negate t))
        (selection
         (send graph-item-proto :new "Selection ..." self 
               :selection-dialog))
        (mouse (send mouse-mode-item-proto :new self))
        (resize-brush 
         (send graph-item-proto :new "Resize Brush" self :resize-brush))
        (redraw 
         (send graph-item-proto :new "Redraw Plot" self :redraw))
        (rescale 
         (send graph-item-proto :new "Rescale Plot" self :adjust-to-data))
        (options 
	 (if (not (small-machine-p))
	     (send graph-item-proto :new "Options ..." self :set-options)))
        (slicer
	 (if (not (small-machine-p))
	     (send graph-item-proto :new
		   "Slicer ..." self :make-slicer-dialog)))
        (symbol
         (send graph-item-proto :new "Selection Symbol" self
               :set-selection-symbol :any-points-selected-p))
        (color
	 (if (screen-has-color)
	     (send graph-item-proto :new "Selection Color" self
		   :set-selection-color :any-points-selected-p)))
        (save-image
         (send graph-item-proto :new "Save to File" self :ask-save-image))
        (save-to-clipboard 
                  (send graph-item-proto :new "Save to Clipboard" self 
                        :save-to-clipboard))
        )))

(defmeth graph-proto :new-menu (&optional title &key (items (send self :menu-template)))
  (unless title (setq title (slot-value 'menu-title)))
  (if (slot-value 'menu) (send (slot-value 'menu) :dispose))
  (flet ((make-item (item) (send self :make-menu-item item)))
    (let ((menu (send menu-proto :new title)))
      (send self :menu menu)
      (apply #'send menu :append-items  (remove nil (mapcar #'make-item items)))
      menu)))