; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "Vic"
!define PRODUCT_VERSION "v2.8ucl1.2.1"
!define PRODUCT_PUBLISHER "UCL"
!define PRODUCT_WEB_SITE "https://mediatools.cs.ucl.ac.uk/nets/mmedia/wiki/VicWiki"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\vic.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

;Local utility macros - mostly from nsis website
!include "win32\utility-macros.nsh"

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"
!define MUI_WELCOMEFINISHPAGE_BITMAP "${NSISDIR}\Contrib\Graphics\Wizard\orange.bmp"
!define MUI_HEADERIMAGE
!define MUI_HEADERIMAGE_BITMAP  "${NSISDIR}\Contrib\Graphics\Header\orange.bmp"
!define MUI_WELCOMEPAGE_TITLE "UCL Media Tools Installer\r\n${PRODUCT_NAME} ${PRODUCT_VERSION}"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "LICENSE.txt"
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "Vic-${PRODUCT_VERSION}-Installer.exe"
InstallDir "$PROGRAMFILES\UCL Media Tools"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Section "MainSection" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite ifnewer
  File "Debug\vic.exe"
  CreateDirectory "$SMPROGRAMS\UCL Media Tools"
  CreateShortCut "$SMPROGRAMS\UCL Media Tools\Vic.lnk" "$INSTDIR\vic.exe"
SectionEnd

Section "Add to path"
  Push $INSTDIR
  Call AddToPath

  ;Add HOME variable - used for .vic.tcl files
  Push "HOME"
  Push $INSTDIR
  Call AddToEnvVar
  
  ;likewise AddToPath could be
  ;Push "PATH"
  ;Push $INSTDIR
  ;Call AddToEnvVar
SectionEnd

Section -AdditionalIcons
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\UCL Media Tools\Vic-Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\UCL Media Tools\Vic-Uninstaller.lnk" "$INSTDIR\Vic-Uninstaller.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\Vic-Uninstaller.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\vic.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\Vic-Uninstaller.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\vic.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\Vic-Uninstaller.exe"
  Delete "$INSTDIR\vic.exe"

  Delete "$SMPROGRAMS\UCL Media Tools\Vic-Uninstaller.lnk"
  Delete "$SMPROGRAMS\UCL Media Tools\Website.lnk"
  Delete "$SMPROGRAMS\UCL Media Tools\Vic.lnk"
  ;Delete "$DESKTOP\Vic.lnk"
  
  Push "$SMPROGRAMS\UCL Media Tools"
  Call un.isEmptyDir
  Pop $0
  StrCmp $0 1 0 +2
    RMDir "$SMPROGRAMS\UCL Media Tools"
    RMDir "$INSTDIR"
    Push $INSTDIR
    Call un.RemoveFromPath
    Push "HOME"
    Push $INSTDIR
    Call un.RemoveFromEnvVar
    
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd