/*
Convert blanks(spaces) to tabs
*/

#define TAB_SIZE 8

#include <stdio.h>
#include <stdlib.h>

void convert(char* filename);


main(int argc, char *argv[]) {
  int i;

  if (argc == 1) {
    printf("\nUsage: unix2dos file1 file2 ...\n\n");
    return 1;
    }
  i = 0;
  fprintf(stderr, "\nStart converting:\n");
  while (--argc)
      convert(argv[++i]);
  fprintf(stderr, "\nFinished\n");
  return 0;
  }


void convert(char* filename)
{
   FILE *fin, *fout;
   int i, j, pos, spaces;
   char buffer[512];
   char bufferout[512];
   char foutname[200];

   fprintf(stderr, "\rConverting %-20s", filename);

   if (!(fin = fopen(filename, "r"))) {
      printf("\nOpen error: %s\n\n", filename);
      return;
   }

   strcpy(foutname, filename);
   strcat(foutname, "_tmp");
   if (!(fout = fopen(foutname, "wb"))) {
      fclose(fout);
      printf("\nCreate error: %s\n\n", foutname);
      return;
   }

   while (fgets(buffer, 512, fin)) {
      j = 0;
      for (i = 0; i < 511 && buffer[i]; i++)
         if (buffer[i] == ' ') {
            spaces = 0;
            while (buffer[i] == ' ' && i % TAB_SIZE  < TAB_SIZE - 1) {
               ++i;
               ++spaces;
            }
            if (buffer[i] == '\t' 
                || i % TAB_SIZE == TAB_SIZE - 1 && buffer[i] == ' ')
               bufferout[j++] = '\t';
            else {
               while (spaces--)
                  bufferout[j++] = ' ';
	       --i;
	    }   
         }
	 else
            bufferout[j++] = buffer[i]; 
      bufferout[j] = 0;
      fputs(bufferout, fout);
   }
   fclose(fin);
   fclose(fout);
   rename(foutname, filename);
}
