/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2023-2025. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

/* !!!Warning: File generated by tmplr; DO NOT EDIT.!!! */
#include <assert.h>
#include <vsync/atomic.h>
#define BYTE_WIDTH 8U
/*****************************************************************************
 * UnitTest: vatomic8_read
 *****************************************************************************/
static inline void
ut_atomic_u8_read(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t val   = vatomic8_read(&obj);
    assert(val == (vuint8_t)1);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic8_read_acq
 *****************************************************************************/
static inline void
ut_atomic_u8_read_acq(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t val   = vatomic8_read_acq(&obj);
    assert(val == (vuint8_t)1);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic8_read_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_read_rlx(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t val   = vatomic8_read_rlx(&obj);
    assert(val == (vuint8_t)1);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic8_init
 *****************************************************************************/
static inline void
ut_atomic_u8_init(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t val   = vatomic8_read(&obj);
    assert(val == (vuint8_t)1);
    vatomic8_init(&obj, VUINT8_MAX);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic8_write
 *****************************************************************************/
static inline void
ut_atomic_u8_write(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t val   = vatomic8_read(&obj);
    assert(val == (vuint8_t)1);
    vatomic8_write(&obj, VUINT8_MAX);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic8_write_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_write_rel(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t val   = vatomic8_read(&obj);
    assert(val == (vuint8_t)1);
    vatomic8_write_rel(&obj, VUINT8_MAX);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic8_write_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_write_rlx(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t val   = vatomic8_read(&obj);
    assert(val == (vuint8_t)1);
    vatomic8_write_rlx(&obj, VUINT8_MAX);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic8_xchg
 *****************************************************************************/
static inline void
ut_atomic_u8_xchg(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t val   = vatomic8_read(&obj);
    assert(val == (vuint8_t)1);
    vuint8_t old = vatomic8_xchg(&obj, VUINT8_MAX);
    assert(old == (vuint8_t)1);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_xchg_acq
 *****************************************************************************/
static inline void
ut_atomic_u8_xchg_acq(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t val   = vatomic8_read(&obj);
    assert(val == (vuint8_t)1);
    vuint8_t old = vatomic8_xchg_acq(&obj, VUINT8_MAX);
    assert(old == (vuint8_t)1);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_xchg_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_xchg_rel(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t val   = vatomic8_read(&obj);
    assert(val == (vuint8_t)1);
    vuint8_t old = vatomic8_xchg_rel(&obj, VUINT8_MAX);
    assert(old == (vuint8_t)1);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_xchg_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_xchg_rlx(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t val   = vatomic8_read(&obj);
    assert(val == (vuint8_t)1);
    vuint8_t old = vatomic8_xchg_rlx(&obj, VUINT8_MAX);
    assert(old == (vuint8_t)1);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_cmpxchg
 *****************************************************************************/
static inline void
ut_atomic_u8_cmpxchg(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    /* test failure */
    vuint8_t old = vatomic8_cmpxchg(&obj, VUINT8_MAX, (vuint8_t)1);
    assert(old == (vuint8_t)1);
    vuint8_t val = vatomic8_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomic8_cmpxchg(&obj, (vuint8_t)1, VUINT8_MAX);
    assert(old == (vuint8_t)1);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_cmpxchg_acq
 *****************************************************************************/
static inline void
ut_atomic_u8_cmpxchg_acq(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    /* test failure */
    vuint8_t old = vatomic8_cmpxchg_acq(&obj, VUINT8_MAX, (vuint8_t)1);
    assert(old == (vuint8_t)1);
    vuint8_t val = vatomic8_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomic8_cmpxchg_acq(&obj, (vuint8_t)1, VUINT8_MAX);
    assert(old == (vuint8_t)1);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_cmpxchg_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_cmpxchg_rel(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    /* test failure */
    vuint8_t old = vatomic8_cmpxchg_rel(&obj, VUINT8_MAX, (vuint8_t)1);
    assert(old == (vuint8_t)1);
    vuint8_t val = vatomic8_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomic8_cmpxchg_rel(&obj, (vuint8_t)1, VUINT8_MAX);
    assert(old == (vuint8_t)1);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_cmpxchg_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_cmpxchg_rlx(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    /* test failure */
    vuint8_t old = vatomic8_cmpxchg_rlx(&obj, VUINT8_MAX, (vuint8_t)1);
    assert(old == (vuint8_t)1);
    vuint8_t val = vatomic8_read(&obj);
    assert(val == old);
    /* test success */
    old = vatomic8_cmpxchg_rlx(&obj, (vuint8_t)1, VUINT8_MAX);
    assert(old == (vuint8_t)1);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);
    V_UNUSED(val, old);
}
/* ****************************************************************************
 * UnitTest: vatomic8_add
 * ****************************************************************************/
static inline void
ut_atomic_u8_add(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        vatomic8_add(&obj, v);
        ref += v;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic8_add_rel
 * ****************************************************************************/
static inline void
ut_atomic_u8_add_rel(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        vatomic8_add_rel(&obj, v);
        ref += v;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic8_add_rlx
 * ****************************************************************************/
static inline void
ut_atomic_u8_add_rlx(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        vatomic8_add_rlx(&obj, v);
        ref += v;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_add
 *****************************************************************************/
static inline void
ut_atomic_u8_get_add(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t val   = 0;
    vuint8_t old   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        old = vatomic8_get_add(&obj, v);
        assert(old == ref);
        ref += v;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_add_get
 *****************************************************************************/
static inline void
ut_atomic_u8_add_get(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t val   = 0;
    vuint8_t cur   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        cur = vatomic8_add_get(&obj, v);
        ref += v;
        assert(cur == ref);
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_add_acq
 *****************************************************************************/
static inline void
ut_atomic_u8_get_add_acq(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t val   = 0;
    vuint8_t old   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        old = vatomic8_get_add_acq(&obj, v);
        assert(old == ref);
        ref += v;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_add_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u8_add_get_acq(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t val   = 0;
    vuint8_t cur   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        cur = vatomic8_add_get_acq(&obj, v);
        ref += v;
        assert(cur == ref);
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_add_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_get_add_rel(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t val   = 0;
    vuint8_t old   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        old = vatomic8_get_add_rel(&obj, v);
        assert(old == ref);
        ref += v;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_add_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_add_get_rel(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t val   = 0;
    vuint8_t cur   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        cur = vatomic8_add_get_rel(&obj, v);
        ref += v;
        assert(cur == ref);
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_add_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_get_add_rlx(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t val   = 0;
    vuint8_t old   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        old = vatomic8_get_add_rlx(&obj, v);
        assert(old == ref);
        ref += v;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_add_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_add_get_rlx(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t val   = 0;
    vuint8_t cur   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        cur = vatomic8_add_get_rlx(&obj, v);
        ref += v;
        assert(cur == ref);
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/* ****************************************************************************
 * UnitTest: vatomic8_inc
 * ****************************************************************************/
static inline void
ut_atomic_u8_inc(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        vatomic8_inc(&obj);
        ref++;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic8_inc_rel
 * ****************************************************************************/
static inline void
ut_atomic_u8_inc_rel(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        vatomic8_inc_rel(&obj);
        ref++;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic8_inc_rlx
 * ****************************************************************************/
static inline void
ut_atomic_u8_inc_rlx(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        vatomic8_inc_rlx(&obj);
        ref++;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_inc
 *****************************************************************************/
static inline void
ut_atomic_u8_get_inc(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t val   = 0;
    vuint8_t old   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        old = vatomic8_get_inc(&obj);
        assert(old == ref);
        ref++;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_inc_get
 *****************************************************************************/
static inline void
ut_atomic_u8_inc_get(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        ref++;
        cur = vatomic8_inc_get(&obj);
        assert(cur == ref);
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_inc_acq
 *****************************************************************************/
static inline void
ut_atomic_u8_get_inc_acq(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t val   = 0;
    vuint8_t old   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        old = vatomic8_get_inc_acq(&obj);
        assert(old == ref);
        ref++;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_inc_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u8_inc_get_acq(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        ref++;
        cur = vatomic8_inc_get_acq(&obj);
        assert(cur == ref);
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_inc_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_get_inc_rel(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t val   = 0;
    vuint8_t old   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        old = vatomic8_get_inc_rel(&obj);
        assert(old == ref);
        ref++;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_inc_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_inc_get_rel(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        ref++;
        cur = vatomic8_inc_get_rel(&obj);
        assert(cur == ref);
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_inc_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_get_inc_rlx(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t val   = 0;
    vuint8_t old   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        old = vatomic8_get_inc_rlx(&obj);
        assert(old == ref);
        ref++;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_inc_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_inc_get_rlx(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        ref++;
        cur = vatomic8_inc_get_rlx(&obj);
        assert(cur == ref);
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/* ****************************************************************************
 * UnitTest: vatomic8_sub
 * ****************************************************************************/
static inline void
ut_atomic_u8_sub(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        vatomic8_sub(&obj, v);
        ref -= v;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic8_sub_rel
 * ****************************************************************************/
static inline void
ut_atomic_u8_sub_rel(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        vatomic8_sub_rel(&obj, v);
        ref -= v;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic8_sub_rlx
 * ****************************************************************************/
static inline void
ut_atomic_u8_sub_rlx(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        vatomic8_sub_rlx(&obj, v);
        ref -= v;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_sub
 *****************************************************************************/
static inline void
ut_atomic_u8_get_sub(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t val   = 0;
    vuint8_t old   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        old = vatomic8_get_sub(&obj, v);
        assert(old == ref);
        ref -= v;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_sub_get
 *****************************************************************************/
static inline void
ut_atomic_u8_sub_get(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t val   = 0;
    vuint8_t cur   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        cur = vatomic8_sub_get(&obj, v);
        ref -= v;
        assert(cur == ref);
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_sub_acq
 *****************************************************************************/
static inline void
ut_atomic_u8_get_sub_acq(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t val   = 0;
    vuint8_t old   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        old = vatomic8_get_sub_acq(&obj, v);
        assert(old == ref);
        ref -= v;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_sub_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u8_sub_get_acq(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t val   = 0;
    vuint8_t cur   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        cur = vatomic8_sub_get_acq(&obj, v);
        ref -= v;
        assert(cur == ref);
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_sub_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_get_sub_rel(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t val   = 0;
    vuint8_t old   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        old = vatomic8_get_sub_rel(&obj, v);
        assert(old == ref);
        ref -= v;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_sub_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_sub_get_rel(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t val   = 0;
    vuint8_t cur   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        cur = vatomic8_sub_get_rel(&obj, v);
        ref -= v;
        assert(cur == ref);
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_sub_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_get_sub_rlx(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t val   = 0;
    vuint8_t old   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        old = vatomic8_get_sub_rlx(&obj, v);
        assert(old == ref);
        ref -= v;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_sub_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_sub_get_rlx(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t val   = 0;
    vuint8_t cur   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        cur = vatomic8_sub_get_rlx(&obj, v);
        ref -= v;
        assert(cur == ref);
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val, cur);
}
/* ****************************************************************************
 * UnitTest: vatomic8_dec
 * ****************************************************************************/
static inline void
ut_atomic_u8_dec(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        vatomic8_dec(&obj);
        ref--;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic8_dec_rel
 * ****************************************************************************/
static inline void
ut_atomic_u8_dec_rel(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        vatomic8_dec_rel(&obj);
        ref--;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/* ****************************************************************************
 * UnitTest: vatomic8_dec_rlx
 * ****************************************************************************/
static inline void
ut_atomic_u8_dec_rlx(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        vatomic8_dec_rlx(&obj);
        ref--;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_dec
 *****************************************************************************/
static inline void
ut_atomic_u8_get_dec(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t old   = 0;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        old = vatomic8_get_dec(&obj);
        assert(old == ref);
        ref--;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(old, val);
}
/*****************************************************************************
 * UnitTest: vatomic8_dec_get
 *****************************************************************************/
static inline void
ut_atomic_u8_dec_get(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t cur   = 0;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        ref--;
        cur = vatomic8_dec_get(&obj);
        assert(cur == ref);
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_dec_acq
 *****************************************************************************/
static inline void
ut_atomic_u8_get_dec_acq(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t old   = 0;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        old = vatomic8_get_dec_acq(&obj);
        assert(old == ref);
        ref--;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(old, val);
}
/*****************************************************************************
 * UnitTest: vatomic8_dec_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u8_dec_get_acq(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t cur   = 0;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        ref--;
        cur = vatomic8_dec_get_acq(&obj);
        assert(cur == ref);
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_dec_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_get_dec_rel(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t old   = 0;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        old = vatomic8_get_dec_rel(&obj);
        assert(old == ref);
        ref--;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(old, val);
}
/*****************************************************************************
 * UnitTest: vatomic8_dec_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_dec_get_rel(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t cur   = 0;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        ref--;
        cur = vatomic8_dec_get_rel(&obj);
        assert(cur == ref);
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_dec_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_get_dec_rlx(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t old   = 0;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        old = vatomic8_get_dec_rlx(&obj);
        assert(old == ref);
        ref--;
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(old, val);
}
/*****************************************************************************
 * UnitTest: vatomic8_dec_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_dec_get_rlx(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t max   = (vuint8_t)1 + (vuint8_t)10;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t cur   = 0;
    vuint8_t val   = 0;

    for (vuint8_t v = (vuint8_t)1; v <= max; v++) {
        ref--;
        cur = vatomic8_dec_get_rlx(&obj);
        assert(cur == ref);
        val = vatomic8_read(&obj);
        assert(val == ref);
    }
    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic8_max
 *****************************************************************************/
static inline void
ut_atomic_u8_max(void)
{
    vatomic8_t obj = {(vuint8_t)1};

    /* test write */
    vatomic8_max(&obj, VUINT8_MAX);
    vuint8_t val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);

    /* test no write */
    vatomic8_max(&obj, (vuint8_t)1);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic8_max_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_max_rel(void)
{
    vatomic8_t obj = {(vuint8_t)1};

    /* test write */
    vatomic8_max_rel(&obj, VUINT8_MAX);
    vuint8_t val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);

    /* test no write */
    vatomic8_max_rel(&obj, (vuint8_t)1);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic8_max_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_max_rlx(void)
{
    vatomic8_t obj = {(vuint8_t)1};

    /* test write */
    vatomic8_max_rlx(&obj, VUINT8_MAX);
    vuint8_t val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);

    /* test no write */
    vatomic8_max_rlx(&obj, (vuint8_t)1);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);
    V_UNUSED(val);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_max
 *****************************************************************************/
static inline void
ut_atomic_u8_get_max(void)
{
    vatomic8_t obj = {(vuint8_t)1};

    /* test write */
    vuint8_t old = vatomic8_get_max(&obj, VUINT8_MAX);
    assert(old == (vuint8_t)1);
    vuint8_t val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);

    /* test no write */
    old = vatomic8_get_max(&obj, (vuint8_t)1);
    assert(old == VUINT8_MAX);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);

    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_max_get
 *****************************************************************************/
static inline void
ut_atomic_u8_max_get(void)
{
    vatomic8_t obj = {(vuint8_t)1};

    /* test write */
    vuint8_t cur = vatomic8_max_get(&obj, VUINT8_MAX);
    assert(cur == VUINT8_MAX);
    vuint8_t val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);

    /* test no write */
    cur = vatomic8_max_get(&obj, (vuint8_t)1);
    assert(cur == VUINT8_MAX);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);

    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_max_acq
 *****************************************************************************/
static inline void
ut_atomic_u8_get_max_acq(void)
{
    vatomic8_t obj = {(vuint8_t)1};

    /* test write */
    vuint8_t old = vatomic8_get_max_acq(&obj, VUINT8_MAX);
    assert(old == (vuint8_t)1);
    vuint8_t val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);

    /* test no write */
    old = vatomic8_get_max_acq(&obj, (vuint8_t)1);
    assert(old == VUINT8_MAX);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);

    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_max_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u8_max_get_acq(void)
{
    vatomic8_t obj = {(vuint8_t)1};

    /* test write */
    vuint8_t cur = vatomic8_max_get_acq(&obj, VUINT8_MAX);
    assert(cur == VUINT8_MAX);
    vuint8_t val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);

    /* test no write */
    cur = vatomic8_max_get_acq(&obj, (vuint8_t)1);
    assert(cur == VUINT8_MAX);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);

    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_max_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_get_max_rel(void)
{
    vatomic8_t obj = {(vuint8_t)1};

    /* test write */
    vuint8_t old = vatomic8_get_max_rel(&obj, VUINT8_MAX);
    assert(old == (vuint8_t)1);
    vuint8_t val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);

    /* test no write */
    old = vatomic8_get_max_rel(&obj, (vuint8_t)1);
    assert(old == VUINT8_MAX);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);

    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_max_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_max_get_rel(void)
{
    vatomic8_t obj = {(vuint8_t)1};

    /* test write */
    vuint8_t cur = vatomic8_max_get_rel(&obj, VUINT8_MAX);
    assert(cur == VUINT8_MAX);
    vuint8_t val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);

    /* test no write */
    cur = vatomic8_max_get_rel(&obj, (vuint8_t)1);
    assert(cur == VUINT8_MAX);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);

    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_max_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_get_max_rlx(void)
{
    vatomic8_t obj = {(vuint8_t)1};

    /* test write */
    vuint8_t old = vatomic8_get_max_rlx(&obj, VUINT8_MAX);
    assert(old == (vuint8_t)1);
    vuint8_t val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);

    /* test no write */
    old = vatomic8_get_max_rlx(&obj, (vuint8_t)1);
    assert(old == VUINT8_MAX);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);

    V_UNUSED(val, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_max_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_max_get_rlx(void)
{
    vatomic8_t obj = {(vuint8_t)1};

    /* test write */
    vuint8_t cur = vatomic8_max_get_rlx(&obj, VUINT8_MAX);
    assert(cur == VUINT8_MAX);
    vuint8_t val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);

    /* test no write */
    cur = vatomic8_max_get_rlx(&obj, (vuint8_t)1);
    assert(cur == VUINT8_MAX);
    val = vatomic8_read(&obj);
    assert(val == VUINT8_MAX);

    V_UNUSED(cur, val);
}
/*****************************************************************************
 * UnitTest: vatomic8_and
 *****************************************************************************/
static inline void
ut_atomic_u8_and(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t mask  = VUINT8_MAX;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        vatomic8_and(&obj, mask);
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_and_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_and_rel(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t mask  = VUINT8_MAX;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        vatomic8_and_rel(&obj, mask);
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_and_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_and_rlx(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t mask  = VUINT8_MAX;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        vatomic8_and_rlx(&obj, mask);
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_and
 *****************************************************************************/
static inline void
ut_atomic_u8_get_and(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t mask  = VUINT8_MAX;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t cur   = 0;
    vuint8_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask >> (BYTE_WIDTH * i));
        old  = vatomic8_get_and(&obj, mask);
        assert(old == ref);
        ref &= mask;
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_and_get
 *****************************************************************************/
static inline void
ut_atomic_u8_and_get(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t mask  = VUINT8_MAX;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        cur = vatomic8_and_get(&obj, mask);
        assert(cur == ref);
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_and_acq
 *****************************************************************************/
static inline void
ut_atomic_u8_get_and_acq(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t mask  = VUINT8_MAX;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t cur   = 0;
    vuint8_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask >> (BYTE_WIDTH * i));
        old  = vatomic8_get_and_acq(&obj, mask);
        assert(old == ref);
        ref &= mask;
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_and_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u8_and_get_acq(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t mask  = VUINT8_MAX;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        cur = vatomic8_and_get_acq(&obj, mask);
        assert(cur == ref);
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_and_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_get_and_rel(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t mask  = VUINT8_MAX;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t cur   = 0;
    vuint8_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask >> (BYTE_WIDTH * i));
        old  = vatomic8_get_and_rel(&obj, mask);
        assert(old == ref);
        ref &= mask;
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_and_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_and_get_rel(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t mask  = VUINT8_MAX;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        cur = vatomic8_and_get_rel(&obj, mask);
        assert(cur == ref);
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_and_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_get_and_rlx(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t mask  = VUINT8_MAX;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t cur   = 0;
    vuint8_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask >> (BYTE_WIDTH * i));
        old  = vatomic8_get_and_rlx(&obj, mask);
        assert(old == ref);
        ref &= mask;
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_and_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_and_get_rlx(void)
{
    vatomic8_t obj = {VUINT8_MAX};
    vuint8_t mask  = VUINT8_MAX;
    vuint8_t ref   = VUINT8_MAX;
    vuint8_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask >> (BYTE_WIDTH * i));
        ref &= mask;
        cur = vatomic8_and_get_rlx(&obj, mask);
        assert(cur == ref);
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_or
 *****************************************************************************/
static inline void
ut_atomic_u8_or(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t mask  = 0xFF;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        vatomic8_or(&obj, mask);
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_or_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_or_rel(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t mask  = 0xFF;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        vatomic8_or_rel(&obj, mask);
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_or_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_or_rlx(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t mask  = 0xFF;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        vatomic8_or_rlx(&obj, mask);
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_or
 *****************************************************************************/
static inline void
ut_atomic_u8_get_or(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t mask  = 0xFF;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;
    vuint8_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask << (BYTE_WIDTH * i));
        old  = vatomic8_get_or(&obj, mask);
        assert(old == ref);
        ref |= mask;
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_or_get
 *****************************************************************************/
static inline void
ut_atomic_u8_or_get(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t mask  = 0xFF;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        cur = vatomic8_or_get(&obj, mask);
        assert(cur == ref);
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_or_acq
 *****************************************************************************/
static inline void
ut_atomic_u8_get_or_acq(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t mask  = 0xFF;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;
    vuint8_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask << (BYTE_WIDTH * i));
        old  = vatomic8_get_or_acq(&obj, mask);
        assert(old == ref);
        ref |= mask;
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_or_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u8_or_get_acq(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t mask  = 0xFF;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        cur = vatomic8_or_get_acq(&obj, mask);
        assert(cur == ref);
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_or_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_get_or_rel(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t mask  = 0xFF;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;
    vuint8_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask << (BYTE_WIDTH * i));
        old  = vatomic8_get_or_rel(&obj, mask);
        assert(old == ref);
        ref |= mask;
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_or_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_or_get_rel(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t mask  = 0xFF;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        cur = vatomic8_or_get_rel(&obj, mask);
        assert(cur == ref);
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_or_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_get_or_rlx(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t mask  = 0xFF;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;
    vuint8_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask << (BYTE_WIDTH * i));
        old  = vatomic8_get_or_rlx(&obj, mask);
        assert(old == ref);
        ref |= mask;
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur, old);
}
/*****************************************************************************
 * UnitTest: vatomic8_or_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_or_get_rlx(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t mask  = 0xFF;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask << (BYTE_WIDTH * i));
        ref |= mask;
        cur = vatomic8_or_get_rlx(&obj, mask);
        assert(cur == ref);
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_xor
 *****************************************************************************/
static inline void
ut_atomic_u8_xor(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t mask  = 0x33;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        vatomic8_xor(&obj, mask);
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_xor_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_xor_rel(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t mask  = 0x33;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        vatomic8_xor_rel(&obj, mask);
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_xor_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_xor_rlx(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t mask  = 0x33;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        vatomic8_xor_rlx(&obj, mask);
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_xor
 *****************************************************************************/
static inline void
ut_atomic_u8_get_xor(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t mask  = 0x33;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;
    vuint8_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask << (BYTE_WIDTH * i)) | mask;
        old  = vatomic8_get_xor(&obj, mask);
        assert(old == ref);
        ref ^= mask;
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(old, cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_or_get
 *****************************************************************************/
static inline void
ut_atomic_u8_xor_get(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t mask  = 0xFF;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        cur = vatomic8_xor_get(&obj, mask);
        assert(cur == ref);
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_xor_acq
 *****************************************************************************/
static inline void
ut_atomic_u8_get_xor_acq(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t mask  = 0x33;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;
    vuint8_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask << (BYTE_WIDTH * i)) | mask;
        old  = vatomic8_get_xor_acq(&obj, mask);
        assert(old == ref);
        ref ^= mask;
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(old, cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_or_get_acq
 *****************************************************************************/
static inline void
ut_atomic_u8_xor_get_acq(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t mask  = 0xFF;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        cur = vatomic8_xor_get_acq(&obj, mask);
        assert(cur == ref);
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_xor_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_get_xor_rel(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t mask  = 0x33;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;
    vuint8_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask << (BYTE_WIDTH * i)) | mask;
        old  = vatomic8_get_xor_rel(&obj, mask);
        assert(old == ref);
        ref ^= mask;
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(old, cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_or_get_rel
 *****************************************************************************/
static inline void
ut_atomic_u8_xor_get_rel(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t mask  = 0xFF;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        cur = vatomic8_xor_get_rel(&obj, mask);
        assert(cur == ref);
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_get_xor_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_get_xor_rlx(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t mask  = 0x33;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;
    vuint8_t old   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask << (BYTE_WIDTH * i)) | mask;
        old  = vatomic8_get_xor_rlx(&obj, mask);
        assert(old == ref);
        ref ^= mask;
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(old, cur);
}
/*****************************************************************************
 * UnitTest: vatomic8_or_get_rlx
 *****************************************************************************/
static inline void
ut_atomic_u8_xor_get_rlx(void)
{
    vatomic8_t obj = {(vuint8_t)1};
    vuint8_t mask  = 0xFF;
    vuint8_t ref   = (vuint8_t)1;
    vuint8_t cur   = 0;

    for (vsize_t i = 0; i < sizeof(vuint8_t); i++) {
        mask = (vuint8_t)(mask << (BYTE_WIDTH * i)) | mask;
        ref ^= mask;
        cur = vatomic8_xor_get_rlx(&obj, mask);
        assert(cur == ref);
        cur = vatomic8_read(&obj);
        assert(cur == ref);
    }
    V_UNUSED(cur);
}
/*****************************************************************************
 * Entry point
 *****************************************************************************/
int
main(void)
{
    ut_atomic_u8_read();
    ut_atomic_u8_read_acq();
    ut_atomic_u8_read_rlx();

    ut_atomic_u8_init();

    ut_atomic_u8_write();
    ut_atomic_u8_write_rel();
    ut_atomic_u8_write_rlx();

    ut_atomic_u8_xchg();
    ut_atomic_u8_xchg_acq();
    ut_atomic_u8_xchg_rel();
    ut_atomic_u8_xchg_rlx();

    ut_atomic_u8_cmpxchg();
    ut_atomic_u8_cmpxchg_acq();
    ut_atomic_u8_cmpxchg_rel();
    ut_atomic_u8_cmpxchg_rlx();

    ut_atomic_u8_add();
    ut_atomic_u8_add_rel();
    ut_atomic_u8_add_rlx();
    ut_atomic_u8_get_add();
    ut_atomic_u8_add_get();
    ut_atomic_u8_get_add_acq();
    ut_atomic_u8_add_get_acq();
    ut_atomic_u8_get_add_rel();
    ut_atomic_u8_add_get_rel();
    ut_atomic_u8_get_add_rlx();
    ut_atomic_u8_add_get_rlx();

    ut_atomic_u8_inc();
    ut_atomic_u8_inc_rel();
    ut_atomic_u8_inc_rlx();
    ut_atomic_u8_get_inc();
    ut_atomic_u8_inc_get();
    ut_atomic_u8_get_inc_acq();
    ut_atomic_u8_inc_get_acq();
    ut_atomic_u8_get_inc_rel();
    ut_atomic_u8_inc_get_rel();
    ut_atomic_u8_get_inc_rlx();
    ut_atomic_u8_inc_get_rlx();

    ut_atomic_u8_sub();
    ut_atomic_u8_sub_rel();
    ut_atomic_u8_sub_rlx();
    ut_atomic_u8_get_sub();
    ut_atomic_u8_sub_get();
    ut_atomic_u8_get_sub_acq();
    ut_atomic_u8_sub_get_acq();
    ut_atomic_u8_get_sub_rel();
    ut_atomic_u8_sub_get_rel();
    ut_atomic_u8_get_sub_rlx();
    ut_atomic_u8_sub_get_rlx();

    ut_atomic_u8_dec();
    ut_atomic_u8_dec_rel();
    ut_atomic_u8_dec_rlx();
    ut_atomic_u8_get_dec();
    ut_atomic_u8_dec_get();
    ut_atomic_u8_get_dec_acq();
    ut_atomic_u8_dec_get_acq();
    ut_atomic_u8_get_dec_rel();
    ut_atomic_u8_dec_get_rel();
    ut_atomic_u8_get_dec_rlx();
    ut_atomic_u8_dec_get_rlx();

    ut_atomic_u8_max();
    ut_atomic_u8_max_rel();
    ut_atomic_u8_max_rlx();
    ut_atomic_u8_get_max();
    ut_atomic_u8_max_get();
    ut_atomic_u8_get_max_acq();
    ut_atomic_u8_max_get_acq();
    ut_atomic_u8_get_max_rel();
    ut_atomic_u8_max_get_rel();
    ut_atomic_u8_get_max_rlx();
    ut_atomic_u8_max_get_rlx();

    ut_atomic_u8_and();
    ut_atomic_u8_and_rel();
    ut_atomic_u8_and_rlx();
    ut_atomic_u8_get_and();
    ut_atomic_u8_and_get();
    ut_atomic_u8_get_and_acq();
    ut_atomic_u8_and_get_acq();
    ut_atomic_u8_get_and_rel();
    ut_atomic_u8_and_get_rel();
    ut_atomic_u8_get_and_rlx();
    ut_atomic_u8_and_get_rlx();

    ut_atomic_u8_or();
    ut_atomic_u8_or_rel();
    ut_atomic_u8_or_rlx();
    ut_atomic_u8_get_or();
    ut_atomic_u8_or_get();
    ut_atomic_u8_get_or_acq();
    ut_atomic_u8_or_get_acq();
    ut_atomic_u8_get_or_rel();
    ut_atomic_u8_or_get_rel();
    ut_atomic_u8_get_or_rlx();
    ut_atomic_u8_or_get_rlx();

    ut_atomic_u8_xor();
    ut_atomic_u8_xor_rel();
    ut_atomic_u8_xor_rlx();
    ut_atomic_u8_get_xor();
    ut_atomic_u8_xor_get();
    ut_atomic_u8_get_xor_acq();
    ut_atomic_u8_xor_get_acq();
    ut_atomic_u8_get_xor_rel();
    ut_atomic_u8_xor_get_rel();
    ut_atomic_u8_get_xor_rlx();
    ut_atomic_u8_xor_get_rlx();
    return 0;
}
