-- Test data for manually populating a VAPOR Repository

BEGIN TRANSACTION;
-- Class-Metadata table

CREATE TABLE ":Vapor::ClassMetaData" (
  _oid		BIGINT PRIMARY KEY,
  _name 	VARCHAR(255),
  _superclass 	VARCHAR(255),
  _table	VARCHAR(64)
);

CREATE TABLE ":Vapor::AttributeMetaData" (
  _oid		BIGINT,
  _name		VARCHAR(255),
  _type		VARCHAR(16),
  _array	BOOLEAN
);

-- List of Objects
CREATE TABLE ":Vapor::ObjectList" (
  _oid	BIGINT PRIMARY KEY,
  _class VARCHAR(64)
);

-- some Information about the Repository
CREATE TABLE ":Vapor::RepositoryInfo" (
  name  TEXT,
  value TEXT
);

INSERT INTO ":Vapor::RepositoryInfo" (name, value) VALUES ('created', 'Wed Jun 18 14:14:27 CEST 2003' );
INSERT INTO ":Vapor::RepositoryInfo" (name, value) VALUES ('last-modofied', 'Wed Jun 18 14:14:27 CEST 2003' );
INSERT INTO ":Vapor::RepositoryInfo" (name, value) VALUES ('schema-version', 3 );

-- counter for OID's higher 48 bits
CREATE SEQUENCE ":Vapor::oid_high" MAXVALUE 281474976710655;
SELECT nextval('":Vapor::oid_high"');

-- metadata and table for transaction log
CREATE TABLE ":Vapor::TransactionLog" (
  _oid      BIGINT PRIMARY KEY,
  _revision BIGINT,
  _last_change BIGINT,
  committer TEXT,
  message   TEXT,
  modified_objects BIGINT[],
  commit_time TIMESTAMP
);
CREATE TABLE "_:Vapor::TransactionLog" (
  _oid      BIGINT,
  _revision BIGINT,
  _last_change BIGINT,
  committer TEXT,
  message   TEXT,
  modified_objects BIGINT[],
  commit_time TIMESTAMP,
  PRIMARY KEY (_oid, _revision)
);


INSERT INTO ":Vapor::ClassMetaData" VALUES ( 0, 'Vapor::TransactionLog', '', ':Vapor::TransactionLog' );
INSERT INTO ":Vapor::AttributeMetaData" VALUES (0, 'committer', 'String', false );
INSERT INTO ":Vapor::AttributeMetaData" VALUES (0, 'message', 'String', false );
INSERT INTO ":Vapor::AttributeMetaData" VALUES (0, 'modified_objects', 'Reference', true );
INSERT INTO ":Vapor::AttributeMetaData" VALUES (0, 'commit_time', 'Date', false ); 

-- Some test Classes

INSERT INTO ":Vapor::ClassMetaData" VALUES ( 1, 'Person',  ''      , 'Person' );
INSERT INTO ":Vapor::AttributeMetaData" VALUES ( 1, 'first_name', 'String',    false );
INSERT INTO ":Vapor::AttributeMetaData" VALUES ( 1, 'last_name',  'String',    false );
INSERT INTO ":Vapor::AttributeMetaData" VALUES ( 1, 'birthday',   'Date',      false );
INSERT INTO ":Vapor::AttributeMetaData" VALUES ( 1, 'inhabits',   'Reference', false );
INSERT INTO ":Vapor::AttributeMetaData" VALUES ( 1, 'friends',    'Reference', true );
INSERT INTO ":Vapor::AttributeMetaData" VALUES ( 1, 'nickNames',  'String'   , true );

CREATE TABLE "Person" (
  _oid		BIGINT PRIMARY KEY,
  _revision     BIGINT,
  _last_change  BIGINT,
  first_name	VARCHAR(255),
  last_name	VARCHAR(255),
  birthday	TIMESTAMP,
  inhabits	BIGINT,
  friends      BIGINT[],
  "nickNames"    VARCHAR(255)[]
);
CREATE TABLE "_Person" (
  _oid		BIGINT,
  _revision     BIGINT,
  _last_change  BIGINT,
  first_name	VARCHAR(255),
  last_name	VARCHAR(255),
  birthday	TIMESTAMP,
  inhabits	BIGINT,
  friends      BIGINT[],
  "nickNames"    VARCHAR(255)[],
  PRIMARY KEY (_oid,_revision)
);

INSERT INTO ":Vapor::ClassMetaData" VALUES ( 2, 'Student', 'Person', 'Student' );
INSERT INTO ":Vapor::AttributeMetaData" VALUES (2, 'student_id', 'Integer', false );
CREATE TABLE "Student" (
  student_id    BIGINT,
  UNIQUE (student_id)
) INHERITS ( "Person" );
CREATE TABLE "_Student" (
  student_id    BIGINT,
  UNIQUE (student_id)
) INHERITS ( "_Person" );



INSERT INTO ":Vapor::ClassMetaData" VALUES ( 3, 'City',    '',       'City' );
INSERT INTO ":Vapor::AttributeMetaData" VALUES ( 3, 'name',     'String',  false );
INSERT INTO ":Vapor::AttributeMetaData" VALUES ( 3, 'altitude', 'Integer', false );
CREATE TABLE "City" (
  _oid		BIGINT PRIMARY KEY,
  _revision     BIGINT,
  _last_change  BIGINT,
  name		VARCHAR(255),
  altitude	BIGINT
);
CREATE TABLE "_City" (
  _oid		BIGINT,
  _revision     BIGINT,
  _last_change  BIGINT,
  name		VARCHAR(255),
  altitude	BIGINT,
  PRIMARY KEY (_oid,_revision)
);

-- Some test objects 
INSERT INTO "Person" VALUES ( 51987, 1, 0, 'Big', 'Seal', '1979-2-28 00:00:00 +0:00', 64212, '{40125}', '{"biggi","Godzilla"}' );
INSERT INTO ":Vapor::ObjectList" VALUES ( 51987, 'Person' ); 
INSERT INTO "Person" VALUES ( 40125, 1, 0, 'Bear', 'Polaris', '2002-6-15 00:00:00 +0:00', 64212, '{51987}', '{ "Pooh"}'   );
INSERT INTO ":Vapor::ObjectList" VALUES ( 40125, 'Person' );
INSERT INTO "Student" VALUES ( 228299, 1, 0, 'Tux', 'Penguin', '1993-6-1 00:00:00 +0:00', 64212, '{}', '{}', 123 );
INSERT INTO ":Vapor::ObjectList" VALUES (228299, 'Student' );

INSERT INTO "City" VALUES ( 1169, 1, 0, 'Antarktikus', 98 );
INSERT INTO ":Vapor::ObjectList" VALUES ( 1169, 'City' );
INSERT INTO "City"  VALUES ( 64212, 5, 0, 'Arktika', 1 );
INSERT INTO "_City" VALUES ( 64212, 4, 0, 'Arktika', 2 );
INSERT INTO "_City" VALUES ( 64212, 3, 0, 'Arktika', 3 );
INSERT INTO "_City" VALUES ( 64212, 2, 0, 'Arktika', 4 );
INSERT INTO "_City" VALUES ( 64212, 1, 0, 'Arktika', 5 );
INSERT INTO ":Vapor::ObjectList" VALUES ( 64212, 'City' );
INSERT INTO "City" VALUES ( 64213, 1, 0, 'Tokyo', 1 );
INSERT INTO ":Vapor::ObjectList" VALUES ( 64213, 'City' );
-- commit the data
COMMIT;

