#!/usr/bin/ruby
#
# Author:: Oliver M. Bolzer <oliver@fakeroot.net>
# Copyright:: Copyright (c) 2002 Oliver M. Bolzer. All rights reserved.
# Licence:: Ruby licence.


require 'test/unit'
require 'vapor/oidgenerator'

## fake Session class responding to next_oid_high
class MockSession

  def initialize
    @oid_high = 0
  end
  def next_oid_high
    @oid_high += 1
    return @oid_high
  end

end

class Test_OIDGenerator < Test::Unit::TestCase

  def setup
    @generator = Vapor::OIDGenerator.new
    @session = MockSession.new
  end

  def teardown
    @generator = nil
  end
  
  ######## actual tests #####
  
  def test_set_high_source
    assert_respond_to( @generator, "high_source=" )

#    assert_raises( Vapor::HighSourceNotSetException ){ @generator.high_source = 1 } 
    assert_nothing_raised{ @generator.high_source = @session }

    assert_nothing_raised{ @generator.next_oid }

  end
  
  def test_next_oid
    assert_respond_to( @generator , "next_oid" )
   
    @generator.high_source = @session

    first_oid = @generator.next_oid
    assert_kind_of( Integer, first_oid )

    second_oid = @generator.next_oid
    assert_not_equal( first_oid, second_oid )

    ## check wheter the value is representable as a 64-bit signed integer
    assert( first_oid >= -9223372036854775808, "OID value out of range: too small" )
    assert( first_oid <= 9223372036854775807, "OID value out of range: too big" )

    assert( second_oid >= -9223372036854775808, "OID value out of range: too small" )
    assert( second_oid <= 9223372036854775807, "OID value out of range: too big" )

  end
end # class Test_OIDGenerator
