;for utilisp on ap1000
(setq dstream (outopen (stream 2)))
;(setq err:catch (function (lambda (tag (where)) 
;                   (debug (list '@@@catch tag where)) (subbreak))))
;(setq err:argument-type (function (lambda (x (where))
;                           (debug (list '@@@argument-type x where)) (subbreak))))
;(setq err:unbound-variable (function (lambda (var (where))
;(setq printlength 0 printlevel 0)
;(debug (backtrace))
;                              (debug (list 'unbound-variable var where))
;                              (subbreak))))
;(setq err:number-of-arguments (function (lambda (dc (where))
;                                 (debug
;                                    (list '@@@number-of-arguments dc where))
;(setq printlength 0 printlevel 0) (debug (list 'backtrace (backtrace)))                
;                 (subbreak))))
;(setq err:buffer-overflow (function (lambda (dc (where))
;                             (debug (list '@@@buffer-overflow dc where))
;                             (subbreak))))
;(setq err:function (function (lambda (x (where)) 
;                       (debug (list '@@@function x where))
;                       (subbreak))))
;(setq err:return (function (lambda (x (where)) 
;                     (lets ((printlength 0))
;         (debug (list '@@@return x where (backtrace))))
;                       (subbreak))))
(defun subbreak ()
  (cond ((> (getcid) 0)
           (lets ((last-input 4095) (prompt "")) (break)))
        (t (lets ((last-input 4096) (prompt "")) (break)))))
(defun stream2string (stream)
   (lets ((string (make-string 4096)) 
          (string-stream (outopen (string-stream string))) 
          (stream-name
             (intern (prog2 (prin1 stream string-stream)
                            (substring
                               string
                               0
                               (string-stream-index string-stream))
                            (close string-stream)))))
    (cond ((null (boundp stream-name)) (set stream-name nil)))
    stream-name))
(defun initialize nil
   (mapcar openfiles 'close)
   (setq printlength 0 printlevel 0) 
   (putd 'ur-read (getd 'read))
   (defun read ((stream standard-input))
      (lets ((stream-name (stream2string stream)) (interrupt-mask 0))
       (cond ((eq stream standard-input)
              (cond ((= last-input 4096) (readhost))
                    ((= last-input 4095) (readany))
                    (t (readstream
                          last-input
                          (intern (string-append
                                     "S#"
                                     (number-image (/+ last-input 256))))))))
             (t (readstream stream stream-name)))))
   (defun readhost nil (lets ((last-input 4096)) (ur-read)))
   (defun readany nil
      (cond (stream-any
              ;(debug (list 'soko (symbolp (car stream-any)) (car stream-any)))
               (setq last-input (/-(number-value (substring (car stream-any) 2))
                                256))
              ;(debug (list 'last-input last-input))
               (readstream nil (car stream-any)))
            (t (setq last-input 4095) (ur-read))))
   (defun readstream (stream stream-name)
      (and (symbolp stream-name)
           (or (boundp stream-name) (set stream-name nil)))
      (cond ((setq stream-queue (eval stream-name))
             (prog1 (car stream-queue)
                   ;(debug (list 'read (car stream-queue)))
                    (cond ((null (set stream-name (cdr stream-queue)))
                           (setq stream-any (remq stream-name stream-any))))))
            ((streamp stream) (ur-read stream))
            (t (lets ((last-input stream) (r (ur-read))) r))))
   (setq interrupt-mask 1)
   (cond ((> (getcid) 0)
	  (setq toplevel
		(function 
		 (lambda ()
		   (setq prompt "")
		   (loop (setq last-input 4095)
			 (lets ((r (read))) 
			   (cond ((and (consp r) (eq (car r) 'broad-message))
				  (eval (cdr r)))
				 (t 
				  (lets ((e (eval r)))
;			  (debug (list 'eval e))
				    (print e))))))))))
         (t 
	  (lets ((last-input 4096)) (princ prompt))))
   (mapcar openfiles 'close)
   (funcall err:end-of-file))
(putd 'ur-read (getd 'read))
(setq message-handler (function (lambda nil 
               (lets ((inputdata) (inputstream) (prompt "") (inputqueue) 
                      (stream-name) (last-input 4095) (mycid (getcid))) 
                (setq inputdata (ur-read)) ;(debug (list 'inputdata inputdata))

                (cond ((eq inputdata '(check)) (debug 'check)))
                (cond ((boundp 'my-break) (funcall my-break inputdata)
                       (setq interrupt-mask 1))
              (t 
                  (cond ((and (consp inputdata) (eq (car inputdata) 'broad))
                      ;(debug inputdata)
                        )
                      ((and (consp inputdata)
                            (eq (car inputdata) 'factor-tag)
                            (null (eq (cadr inputdata) mycid)))
                       ;(debug inputdata)
                       (break-factor (caddr inputdata)))
                      (t (setq inputstream last-input)
                        ;(debug (list 'break inputdata inputstream))
                         (setq stream-name (intern 
                                            (string-append "S#" 
                                             (number-image 
                                              (/+ inputstream 256)))))
                         (cond ((null (boundp stream-name))
                                (set stream-name nil)))
                         (set stream-name
                              (prog2 (cond ((null 
                                             (setq inputqueue 
                                              (eval stream-name)))
                                            (push stream-name stream-any)))
                                     (nconc inputqueue (list inputdata))))))
                (setq interrupt-mask 1)))))))
(setq stream-any 'nil)
;(defun getcid nil (peek))
;(defun getncel nil (peek 1))
(defun getlcel nil
   (lets ((ncel (getncel)) (lcel -1))
    (loop (cond ((zerop ncel) (exit lcel)))
          (setq ncel (logshift ncel -1) lcel (add1 lcel)))))
;(defun getncelx nil (peek 2))
;(defun getncely nil (peek 3))
;(defun sync (no stat) (peek 4 no stat))
;(defun cstat nil (peek 5))
;(defun gstat nil (peek 6))
;(defun pstat (stat) (peek 7 stat 0))
;(defun rand nil (peek 7))
;(defun srand (seed) (peek 8 seed 0))
(defun broadmessage (message)
   (lets ((last-input 4095)) (print (cons 'broad-message message))))
(defmacro collectall (op info) 
   (lets ((ncel (getncel)) (mycid (getcid)))
    (prog nil 
       (sync 0 0)
       (selectq ncel
          (1024 (go l1024))
          (512 (go l512))
          (256 (go l256))
          (128 (go l128))
          (64 (go l64))
          (32 (go l32))
          (16 (go l16))
          (8 (go l8))
          (4 (go l4))
          (2 (go l2))
          (1 (go l1)))
 l1024 (cond ((< mycid 512)
              (set info (funcall op info (receivefrom (/+ mycid 512)))))
             (t (sendto (eval info) (/- mycid 512)) (go l1)))
 l512  (cond ((< mycid 256)
              (set info (funcall op info (receivefrom (/+ mycid 256)))))
             (t (sendto (eval info) (/- mycid 256)) (go l1)))
 l256  (cond ((< mycid 128)
              (set info (funcall op (eval info) (receivefrom (/+ mycid 128)))))
             (t (sendto (eval info) (/- mycid 128)) (go l1)))
 l128  (cond ((< mycid 64)
              (set info (funcall op (eval info) (receivefrom (/+ mycid 64)))))
             (t (sendto (eval info) (/- mycid 64)) (go l1)))
 l64   (cond ((< mycid 32)
              (set info (funcall op (eval info) (receivefrom (/+ mycid 32)))))
             (t (sendto (eval info) (/- mycid 32)) (go l1)))
 l32   (cond ((< mycid 16)
              (set info (funcall op (eval info) (receivefrom (/+ mycid 16)))))
             (t (sendto (eval info) (/- mycid 16)) (go l1)))
 l16   (cond ((< mycid 8)
              (set info (funcall op (eval info) (receivefrom (/+ mycid 8)))))
             (t (sendto (eval info) (/- mycid 8)) (go l1)))
 l8    (cond ((< mycid 4)
              (set info (funcall op (eval info) (receivefrom (/+ mycid 4)))))
             (t (sendto (eval info) (/- mycid 4)) (go l1)))
 l4    (cond ((< mycid 2)
              (set info (funcall op (eval info) (receivefrom (/+ mycid 2)))))
             (t (sendto (eval info) (/- mycid 2)) (go l1)))
 l2    (cond ((< mycid 1)
              (set info (funcall op (eval info) (receivefrom (/+ mycid 1)))))
             (t (sendto (eval info) (/- mycid 1)) (go l1)))
 l1)))
(defun receivefrom (n) 
  (lets ((stream (inopen (stream (+ n 256))))) (prog1 (read stream)
    (close stream))))
(defun sendto (x n) 
  (lets ((stream (outopen (stream (+ n 256))))) (prog1 (print x stream)
    (close stream))))
(defmacro collectall2 (op info)
`(lets ((ncel (getncel)) (mycid (getcid)) (strobe2) (strobe1))
  (sync 0 0)
  (do ((strobe2 2 (+ strobe2 strobe2)) (strobe1 1 (+ strobe1 strobe1)))
      ((= strobe1 ncel))
  (cond ((= (\ mycid strobe2) 0) 
         (setq ,info (funcall ',op ,info (receivefrom (+ mycid strobe1)))))
        ((= (\ mycid strobe2) strobe1) 
         (sendto (eval ',info) (- mycid strobe1)))))))

(defun string-separate (string length)
   (cond ((<= (string-length string) length) (list string))
         (t (cons (substring string 0 length) 
                  (string-separate (substring string length) length)))))

(defun exfile (lispfile (print-result))
   (lets ((string-stream-length 4096)
          (string (make-string string-stream-length))
          (string2 (make-string string-stream-length)) 
          (string-stream (outopen (string-stream string))) 
          (string-stream2 (string-stream string2))
          (stream (inopen (stream lispfile))) 
          (sexpr) (sexprlength)
          (err:end-of-file (function (lambda (stg (dum)) (throw 'exfile))))
          (length 500))
    (catch 'exfile (loop (setq sexpr (read stream))
                      (outopen string-stream2)
                      (prin1 sexpr string-stream2)
                      (setq sexprlength (string-stream-index string-stream2))
                      (close string-stream2)
                      (cond ((> (+ sexprlength 
                                  (string-stream-index string-stream)) 
                               string-stream-length) (execexfile)))
                   (prin1 sexpr string-stream)))
   (execexfile) (close string-stream) nil))

(defun execexfile ()
   (lets ((exfile-string 
           (substring string 0 (string-stream-index string-stream))))
    (close string-stream)
    (broadmessage (list 'exfile* (list 'apply ''string-append
                    (list 'quote (string-separate exfile-string length)))))
    (exfile* exfile-string print-result) (outopen string-stream)))

(defun exfile* (string (print-result))
   (lets ((string-stream (inopen (string-stream string))) 
          (err:end-of-file (function (lambda (stg (dum)) (throw 'exfile)))) 
          (r))
    (catch 'exfile
       (cond (print-result
                (loop (setq r (read string-stream)) (print (eval r))))
             (t (loop (setq r (read string-stream)) (eval r)))))))

(putd 'ur-quit (getd 'quit))
(defun quit ()
  (broadmessage '(ur-quit))
  (ur-quit))

(defmacro cset (cell var val)
`(lets ((stream0 (outopen (stream (+ ,cell 256)))) 
       (stream1 (inopen (stream (+ ,cell 256)))))
(prin1 (list 'setq ',var (eval ,val)) stream0)
(prog1 (read stream1) (close stream0) (close stream1))))

(defmacro cref (cell var)
`(lets ((stream0 (outopen (stream (+ ,cell 256))))
       (stream1 (inopen (stream (+ ,cell 256)))))
(prin1 (list 'eval ',var) stream0) 
(prog1 (read stream1) (close stream0) (close stream1))))

(cond ((0= (getcid)) (tyo 7)))


;(defun break () (funcall break))

;(defun debug (m) (lets ((last-input 4096)) 
;		   (format "[/c]" (getcid))
;		   (print m)))
(defun debug (m) (lets ((last-input 4096))
  (print (cons (getcid) m))))


(initialize)

