/**
 * @file qgl.c
 * @brief This file implements the operating system binding of GL to QGL function pointers
 */

/*
Copyright (C) 1997-2001 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "r_local.h"

#include "qgl.h"

void (APIENTRY * qglAccum) (GLenum op, GLfloat value);
void (APIENTRY * qglAlphaFunc) (GLenum func, GLclampf ref);
GLboolean (APIENTRY * qglAreTexturesResident) (GLsizei n, const GLuint *textures, GLboolean *residences);
void (APIENTRY * qglArrayElement) (GLint i);
void (APIENTRY * qglBegin) (GLenum mode);
void (APIENTRY * qglBindTexture) (GLenum target, GLuint texture);
void (APIENTRY * qglBitmap) (GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove,
			GLfloat ymove, const GLubyte *bitmap);
void (APIENTRY * qglBlendFunc) (GLenum sfactor, GLenum dfactor);
void (APIENTRY * qglCallList) (GLuint list);
void (APIENTRY * qglCallLists) (GLsizei n, GLenum type, const GLvoid *lists);
void (APIENTRY * qglClear) (GLbitfield mask);
void (APIENTRY * qglClearAccum) (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
void (APIENTRY * qglClearColor) (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
void (APIENTRY * qglClearDepth) (GLclampd depth);
void (APIENTRY * qglClearIndex) (GLfloat c);
void (APIENTRY * qglClearStencil) (GLint s);
void (APIENTRY * qglClipPlane) (GLenum plane, const GLdouble *equation);
void (APIENTRY * qglColor3b) (GLbyte red, GLbyte green, GLbyte blue);
void (APIENTRY * qglColor3bv )(const GLbyte *v);
void (APIENTRY * qglColor3d) (GLdouble red, GLdouble green, GLdouble blue);
void (APIENTRY * qglColor3dv )(const GLdouble *v);
void (APIENTRY * qglColor3f) (GLfloat red, GLfloat green, GLfloat blue);
void (APIENTRY * qglColor3fv )(const GLfloat *v);
void (APIENTRY * qglColor3i) (GLint red, GLint green, GLint blue);
void (APIENTRY * qglColor3iv )(const GLint *v);
void (APIENTRY * qglColor3s) (GLshort red, GLshort green, GLshort blue);
void (APIENTRY * qglColor3sv )(const GLshort *v);
void (APIENTRY * qglColor3ub) (GLubyte red, GLubyte green, GLubyte blue);
void (APIENTRY * qglColor3ubv )(const GLubyte *v);
void (APIENTRY * qglColor3ui) (GLuint red, GLuint green, GLuint blue);
void (APIENTRY * qglColor3uiv )(const GLuint *v);
void (APIENTRY * qglColor3us) (GLushort red, GLushort green, GLushort blue);
void (APIENTRY * qglColor3usv )(const GLushort *v);
void (APIENTRY * qglColor4b) (GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha);
void (APIENTRY * qglColor4bv )(const GLbyte *v);
void (APIENTRY * qglColor4d) (GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha);
void (APIENTRY * qglColor4dv )(const GLdouble *v);
void (APIENTRY * qglColor4f) (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
void (APIENTRY * qglColor4fv )(const GLfloat *v);
void (APIENTRY * qglColor4i) (GLint red, GLint green, GLint blue, GLint alpha);
void (APIENTRY * qglColor4iv )(const GLint *v);
void (APIENTRY * qglColor4s) (GLshort red, GLshort green, GLshort blue, GLshort alpha);
void (APIENTRY * qglColor4sv )(const GLshort *v);
void (APIENTRY * qglColor4ub) (GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha);
void (APIENTRY * qglColor4ubv )(const GLubyte *v);
void (APIENTRY * qglColor4ui) (GLuint red, GLuint green, GLuint blue, GLuint alpha);
void (APIENTRY * qglColor4uiv )(const GLuint *v);
void (APIENTRY * qglColor4us) (GLushort red, GLushort green, GLushort blue, GLushort alpha);
void (APIENTRY * qglColor4usv )(const GLushort *v);
void (APIENTRY * qglColorMask) (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
void (APIENTRY * qglColorMaterial) (GLenum face, GLenum mode);
void (APIENTRY * qglColorPointer) (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void (APIENTRY * qglCopyPixels) (GLint x, GLint y, GLsizei width, GLsizei height, GLenum type);
void (APIENTRY * qglCopyTexImage1D) (GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y,
			GLsizei width, GLint border);
void (APIENTRY * qglCopyTexImage2D) (GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y,
			GLsizei width, GLsizei height, GLint border);
void (APIENTRY * qglCopyTexSubImage1D) (GLenum target, GLint level, GLint xoffset, GLint x, GLint y,
			GLsizei width);
void (APIENTRY * qglCopyTexSubImage2D) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x,
			GLint y, GLsizei width, GLsizei height);
void (APIENTRY * qglCullFace) (GLenum mode);
void (APIENTRY * qglDeleteLists) (GLuint list, GLsizei range);
void (APIENTRY * qglDeleteTextures) (GLsizei n, const GLuint *textures);
void (APIENTRY * qglDepthFunc) (GLenum func);
void (APIENTRY * qglDepthMask) (GLboolean flag);
void (APIENTRY * qglDepthRange) (GLclampd zNear, GLclampd zFar);
void (APIENTRY * qglDisable) (GLenum cap);
void (APIENTRY * qglDisableClientState) (GLenum array);
void (APIENTRY * qglDrawArrays) (GLenum mode, GLint first, GLsizei count);
void (APIENTRY * qglDrawBuffer) (GLenum mode);
void (APIENTRY * qglDrawElements) (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices);
void (APIENTRY * qglDrawPixels) (GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
void (APIENTRY * qglEdgeFlag) (GLboolean flag);
void (APIENTRY * qglEdgeFlagPointer) (GLsizei stride, const GLvoid *pointer);
void (APIENTRY * qglEdgeFlagv) (const GLboolean *flag);
void (APIENTRY * qglEnable) (GLenum cap);
void (APIENTRY * qglEnableClientState) (GLenum array);
void (APIENTRY * qglEnd) (void);
void (APIENTRY * qglEndList) (void);
void (APIENTRY * qglEvalCoord1d) (GLdouble u);
void (APIENTRY * qglEvalCoord1dv) (const GLdouble *u);
void (APIENTRY * qglEvalCoord1f) (GLfloat u);
void (APIENTRY * qglEvalCoord1fv) (const GLfloat *u);
void (APIENTRY * qglEvalCoord2d) (GLdouble u, GLdouble v);
void (APIENTRY * qglEvalCoord2dv) (const GLdouble *u);
void (APIENTRY * qglEvalCoord2f) (GLfloat u, GLfloat v);
void (APIENTRY * qglEvalCoord2fv) (const GLfloat *u);
void (APIENTRY * qglEvalMesh1) (GLenum mode, GLint i1, GLint i2);
void (APIENTRY * qglEvalMesh2) (GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2);
void (APIENTRY * qglEvalPoint1) (GLint i);
void (APIENTRY * qglEvalPoint2) (GLint i, GLint j);
void (APIENTRY * qglFeedbackBuffer) (GLsizei size, GLenum type, GLfloat *buffer);
void (APIENTRY * qglFinish) (void);
void (APIENTRY * qglFlush) (void);
void (APIENTRY * qglFogf) (GLenum pname, GLfloat param);
void (APIENTRY * qglFogfv) (GLenum pname, const GLfloat *params);
void (APIENTRY * qglFogi) (GLenum pname, GLint param);
void (APIENTRY * qglFogiv) (GLenum pname, const GLint *params);
void (APIENTRY * qglFrontFace) (GLenum mode);
void (APIENTRY * qglFrustum) (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
GLuint (APIENTRY * qglGenLists) (GLsizei range);
void (APIENTRY * qglGenTextures) (GLsizei n, GLuint *textures);
void (APIENTRY * qglGetBooleanv) (GLenum pname, GLboolean *params);
void (APIENTRY * qglGetClipPlane) (GLenum plane, GLdouble *equation);
void (APIENTRY * qglGetDoublev) (GLenum pname, GLdouble *params);
GLenum (APIENTRY * qglGetError) (void);
void (APIENTRY * qglGetFloatv) (GLenum pname, GLfloat *params);
void (APIENTRY * qglGetIntegerv) (GLenum pname, GLint *params);
void (APIENTRY * qglGetLightfv) (GLenum light, GLenum pname, GLfloat *params);
void (APIENTRY * qglGetLightiv) (GLenum light, GLenum pname, GLint *params);
void (APIENTRY * qglGetMapdv) (GLenum target, GLenum query, GLdouble *v);
void (APIENTRY * qglGetMapfv) (GLenum target, GLenum query, GLfloat *v);
void (APIENTRY * qglGetMapiv) (GLenum target, GLenum query, GLint *v);
void (APIENTRY * qglGetMaterialfv) (GLenum face, GLenum pname, GLfloat *params);
void (APIENTRY * qglGetMaterialiv) (GLenum face, GLenum pname, GLint *params);
void (APIENTRY * qglGetPixelMapfv) (GLenum map, GLfloat *values);
void (APIENTRY * qglGetPixelMapuiv) (GLenum map, GLuint *values);
void (APIENTRY * qglGetPixelMapusv) (GLenum map, GLushort *values);
void (APIENTRY * qglGetPointerv) (GLenum pname, GLvoid* *params);
void (APIENTRY * qglGetPolygonStipple) (GLubyte *mask);
const GLubyte * (APIENTRY * qglGetString) (GLenum name);
void (APIENTRY * qglGetTexEnvfv) (GLenum target, GLenum pname, GLfloat *params);
void (APIENTRY * qglGetTexEnviv) (GLenum target, GLenum pname, GLint *params);
void (APIENTRY * qglGetTexGendv) (GLenum coord, GLenum pname, GLdouble *params);
void (APIENTRY * qglGetTexGenfv) (GLenum coord, GLenum pname, GLfloat *params);
void (APIENTRY * qglGetTexGeniv) (GLenum coord, GLenum pname, GLint *params);
void (APIENTRY * qglGetTexImage) (GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
void (APIENTRY * qglGetTexLevelParameterfv) (GLenum target, GLint level, GLenum pname, GLfloat *params);
void (APIENTRY * qglGetTexLevelParameteriv) (GLenum target, GLint level, GLenum pname, GLint *params);
void (APIENTRY * qglGetTexParameterfv) (GLenum target, GLenum pname, GLfloat *params);
void (APIENTRY * qglGetTexParameteriv) (GLenum target, GLenum pname, GLint *params);
void (APIENTRY * qglHint) (GLenum target, GLenum mode);
void (APIENTRY * qglIndexMask) (GLuint mask);
void (APIENTRY * qglIndexPointer) (GLenum type, GLsizei stride, const GLvoid *pointer);
void (APIENTRY * qglIndexd) (GLdouble c);
void (APIENTRY * qglIndexdv) (const GLdouble *c);
void (APIENTRY * qglIndexf) (GLfloat c);
void (APIENTRY * qglIndexfv) (const GLfloat *c);
void (APIENTRY * qglIndexi) (GLint c);
void (APIENTRY * qglIndexiv) (const GLint *c);
void (APIENTRY * qglIndexs) (GLshort c);
void (APIENTRY * qglIndexsv) (const GLshort *c);
void (APIENTRY * qglIndexub) (GLubyte c);
void (APIENTRY * qglIndexubv) (const GLubyte *c);
void (APIENTRY * qglInitNames) (void);
void (APIENTRY * qglInterleavedArrays) (GLenum format, GLsizei stride, const GLvoid *pointer);
GLboolean (APIENTRY * qglIsEnabled) (GLenum cap);
GLboolean (APIENTRY * qglIsList) (GLuint list);
GLboolean (APIENTRY * qglIsTexture) (GLuint texture);
void (APIENTRY * qglLightModelf) (GLenum pname, GLfloat param);
void (APIENTRY * qglLightModelfv) (GLenum pname, const GLfloat *params);
void (APIENTRY * qglLightModeli) (GLenum pname, GLint param);
void (APIENTRY * qglLightModeliv) (GLenum pname, const GLint *params);
void (APIENTRY * qglLightf) (GLenum light, GLenum pname, GLfloat param);
void (APIENTRY * qglLightfv) (GLenum light, GLenum pname, const GLfloat *params);
void (APIENTRY * qglLighti) (GLenum light, GLenum pname, GLint param);
void (APIENTRY * qglLightiv) (GLenum light, GLenum pname, const GLint *params);
void (APIENTRY * qglLineStipple) (GLint factor, GLushort pattern);
void (APIENTRY * qglLineWidth) (GLfloat width);
void (APIENTRY * qglListBase) (GLuint base);
void (APIENTRY * qglLoadIdentity) (void);
void (APIENTRY * qglLoadMatrixd) (const GLdouble *m);
void (APIENTRY * qglLoadMatrixf) (const GLfloat *m);
void (APIENTRY * qglLoadName) (GLuint name);
void (APIENTRY * qglLogicOp) (GLenum opcode);
void (APIENTRY * qglMap1d) (GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order,
			const GLdouble *points);
void (APIENTRY * qglMap1f) (GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order,
			const GLfloat *points);
void (APIENTRY * qglMap2d) (GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1,
			GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points);
void (APIENTRY * qglMap2f) (GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1,
			GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points);
void (APIENTRY * qglMapGrid1d) (GLint un, GLdouble u1, GLdouble u2);
void (APIENTRY * qglMapGrid1f) (GLint un, GLfloat u1, GLfloat u2);
void (APIENTRY * qglMapGrid2d) (GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2);
void (APIENTRY * qglMapGrid2f) (GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2);
void (APIENTRY * qglMaterialf) (GLenum face, GLenum pname, GLfloat param);
void (APIENTRY * qglMaterialfv) (GLenum face, GLenum pname, const GLfloat *params);
void (APIENTRY * qglMateriali) (GLenum face, GLenum pname, GLint param);
void (APIENTRY * qglMaterialiv) (GLenum face, GLenum pname, const GLint *params);
void (APIENTRY * qglMatrixMode) (GLenum mode);
void (APIENTRY * qglMultMatrixd) (const GLdouble *m);
void (APIENTRY * qglMultMatrixf) (const GLfloat *m);
void (APIENTRY * qglNewList) (GLuint list, GLenum mode);
void (APIENTRY * qglNormal3b) (GLbyte nx, GLbyte ny, GLbyte nz);
void (APIENTRY * qglNormal3bv) (const GLbyte *v);
void (APIENTRY * qglNormal3d) (GLdouble nx, GLdouble ny, GLdouble nz);
void (APIENTRY * qglNormal3dv) (const GLdouble *v);
void (APIENTRY * qglNormal3f) (GLfloat nx, GLfloat ny, GLfloat nz);
void (APIENTRY * qglNormal3fv) (const GLfloat *v);
void (APIENTRY * qglNormal3i) (GLint nx, GLint ny, GLint nz);
void (APIENTRY * qglNormal3iv) (const GLint *v);
void (APIENTRY * qglNormal3s) (GLshort nx, GLshort ny, GLshort nz);
void (APIENTRY * qglNormal3sv) (const GLshort *v);
void (APIENTRY * qglNormalPointer) (GLenum type, GLsizei stride, const GLvoid *pointer);
void (APIENTRY * qglOrtho) (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
void (APIENTRY * qglPassThrough) (GLfloat token);
void (APIENTRY * qglPixelMapfv) (GLenum map, GLsizei mapsize, const GLfloat *values);
void (APIENTRY * qglPixelMapuiv) (GLenum map, GLsizei mapsize, const GLuint *values);
void (APIENTRY * qglPixelMapusv) (GLenum map, GLsizei mapsize, const GLushort *values);
void (APIENTRY * qglPixelStoref) (GLenum pname, GLfloat param);
void (APIENTRY * qglPixelStorei) (GLenum pname, GLint param);
void (APIENTRY * qglPixelTransferf) (GLenum pname, GLfloat param);
void (APIENTRY * qglPixelTransferi) (GLenum pname, GLint param);
void (APIENTRY * qglPixelZoom) (GLfloat xfactor, GLfloat yfactor);
void (APIENTRY * qglPointSize) (GLfloat size);
void (APIENTRY * qglPolygonMode) (GLenum face, GLenum mode);
void (APIENTRY * qglPolygonOffset) (GLfloat factor, GLfloat units);
void (APIENTRY * qglPolygonStipple) (const GLubyte *mask);
void (APIENTRY * qglPopAttrib) (void);
void (APIENTRY * qglPopClientAttrib) (void);
void (APIENTRY * qglPopMatrix) (void);
void (APIENTRY * qglPopName) (void);
void (APIENTRY * qglPrioritizeTextures) (GLsizei n, const GLuint *textures, const GLclampf *priorities);
void (APIENTRY * qglPushAttrib) (GLbitfield mask);
void (APIENTRY * qglPushClientAttrib) (GLbitfield mask);
void (APIENTRY * qglPushMatrix) (void);
void (APIENTRY * qglPushName) (GLuint name);
void (APIENTRY * qglRasterPos2d) (GLdouble x, GLdouble y);
void (APIENTRY * qglRasterPos2dv) (const GLdouble *v);
void (APIENTRY * qglRasterPos2f) (GLfloat x, GLfloat y);
void (APIENTRY * qglRasterPos2fv) (const GLfloat *v);
void (APIENTRY * qglRasterPos2i) (GLint x, GLint y);
void (APIENTRY * qglRasterPos2iv) (const GLint *v);
void (APIENTRY * qglRasterPos2s) (GLshort x, GLshort y);
void (APIENTRY * qglRasterPos2sv) (const GLshort *v);
void (APIENTRY * qglRasterPos3d) (GLdouble x, GLdouble y, GLdouble z);
void (APIENTRY * qglRasterPos3dv) (const GLdouble *v);
void (APIENTRY * qglRasterPos3f) (GLfloat x, GLfloat y, GLfloat z);
void (APIENTRY * qglRasterPos3fv) (const GLfloat *v);
void (APIENTRY * qglRasterPos3i) (GLint x, GLint y, GLint z);
void (APIENTRY * qglRasterPos3iv) (const GLint *v);
void (APIENTRY * qglRasterPos3s) (GLshort x, GLshort y, GLshort z);
void (APIENTRY * qglRasterPos3sv) (const GLshort *v);
void (APIENTRY * qglRasterPos4d) (GLdouble x, GLdouble y, GLdouble z, GLdouble w);
void (APIENTRY * qglRasterPos4dv) (const GLdouble *v);
void (APIENTRY * qglRasterPos4f) (GLfloat x, GLfloat y, GLfloat z, GLfloat w);
void (APIENTRY * qglRasterPos4fv) (const GLfloat *v);
void (APIENTRY * qglRasterPos4i) (GLint x, GLint y, GLint z, GLint w);
void (APIENTRY * qglRasterPos4iv) (const GLint *v);
void (APIENTRY * qglRasterPos4s) (GLshort x, GLshort y, GLshort z, GLshort w);
void (APIENTRY * qglRasterPos4sv) (const GLshort *v);
void (APIENTRY * qglReadBuffer) (GLenum mode);
void (APIENTRY * qglReadPixels) (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels);
void (APIENTRY * qglRectd) (GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2);
void (APIENTRY * qglRectdv )(const GLdouble *v1, const GLdouble *v2);
void (APIENTRY * qglRectf) (GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2);
void (APIENTRY * qglRectfv )(const GLfloat *v1, const GLfloat *v2);
void (APIENTRY * qglRecti) (GLint x1, GLint y1, GLint x2, GLint y2);
void (APIENTRY * qglRectiv )(const GLint *v1, const GLint *v2);
void (APIENTRY * qglRects) (GLshort x1, GLshort y1, GLshort x2, GLshort y2);
void (APIENTRY * qglRectsv )(const GLshort *v1, const GLshort *v2);
GLint (APIENTRY * qglRenderMode) (GLenum mode);
void (APIENTRY * qglRotated) (GLdouble angle, GLdouble x, GLdouble y, GLdouble z);
void (APIENTRY * qglRotatef) (GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
void (APIENTRY * qglScaled) (GLdouble x, GLdouble y, GLdouble z);
void (APIENTRY * qglScalef) (GLfloat x, GLfloat y, GLfloat z);
void (APIENTRY * qglScissor) (GLint x, GLint y, GLsizei width, GLsizei height);
void (APIENTRY * qglSelectBuffer) (GLsizei size, GLuint *buffer);
void (APIENTRY * qglStencilFunc) (GLenum func, GLint ref, GLuint mask);
void (APIENTRY * qglStencilMask) (GLuint mask);
void (APIENTRY * qglStencilOp) (GLenum fail, GLenum zfail, GLenum zpass);
void (APIENTRY * qglTexCoord1d) (GLdouble s);
void (APIENTRY * qglTexCoord1dv )(const GLdouble *v);
void (APIENTRY * qglTexCoord1f) (GLfloat s);
void (APIENTRY * qglTexCoord1fv )(const GLfloat *v);
void (APIENTRY * qglTexCoord1i) (GLint s);
void (APIENTRY * qglTexCoord1iv )(const GLint *v);
void (APIENTRY * qglTexCoord1s) (GLshort s);
void (APIENTRY * qglTexCoord1sv )(const GLshort *v);
void (APIENTRY * qglTexCoord2d) (GLdouble s, GLdouble t);
void (APIENTRY * qglTexCoord2dv )(const GLdouble *v);
void (APIENTRY * qglTexCoord2f) (GLfloat s, GLfloat t);
void (APIENTRY * qglTexCoord2fv )(const GLfloat *v);
void (APIENTRY * qglTexCoord2i) (GLint s, GLint t);
void (APIENTRY * qglTexCoord2iv )(const GLint *v);
void (APIENTRY * qglTexCoord2s) (GLshort s, GLshort t);
void (APIENTRY * qglTexCoord2sv )(const GLshort *v);
void (APIENTRY * qglTexCoord3d) (GLdouble s, GLdouble t, GLdouble r);
void (APIENTRY * qglTexCoord3dv )(const GLdouble *v);
void (APIENTRY * qglTexCoord3f) (GLfloat s, GLfloat t, GLfloat r);
void (APIENTRY * qglTexCoord3fv )(const GLfloat *v);
void (APIENTRY * qglTexCoord3i) (GLint s, GLint t, GLint r);
void (APIENTRY * qglTexCoord3iv )(const GLint *v);
void (APIENTRY * qglTexCoord3s) (GLshort s, GLshort t, GLshort r);
void (APIENTRY * qglTexCoord3sv )(const GLshort *v);
void (APIENTRY * qglTexCoord4d) (GLdouble s, GLdouble t, GLdouble r, GLdouble q);
void (APIENTRY * qglTexCoord4dv )(const GLdouble *v);
void (APIENTRY * qglTexCoord4f) (GLfloat s, GLfloat t, GLfloat r, GLfloat q);
void (APIENTRY * qglTexCoord4fv )(const GLfloat *v);
void (APIENTRY * qglTexCoord4i) (GLint s, GLint t, GLint r, GLint q);
void (APIENTRY * qglTexCoord4iv )(const GLint *v);
void (APIENTRY * qglTexCoord4s) (GLshort s, GLshort t, GLshort r, GLshort q);
void (APIENTRY * qglTexCoord4sv )(const GLshort *v);
void (APIENTRY * qglTexCoordPointer) (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void (APIENTRY * qglTexEnvf) (GLenum target, GLenum pname, GLfloat param);
void (APIENTRY * qglTexEnvfv) (GLenum target, GLenum pname, const GLfloat *params);
void (APIENTRY * qglTexEnvi) (GLenum target, GLenum pname, GLint param);
void (APIENTRY * qglTexEnviv) (GLenum target, GLenum pname, const GLint *params);
void (APIENTRY * qglTexGend) (GLenum coord, GLenum pname, GLdouble param);
void (APIENTRY * qglTexGendv) (GLenum coord, GLenum pname, const GLdouble *params);
void (APIENTRY * qglTexGenf) (GLenum coord, GLenum pname, GLfloat param);
void (APIENTRY * qglTexGenfv) (GLenum coord, GLenum pname, const GLfloat *params);
void (APIENTRY * qglTexGeni) (GLenum coord, GLenum pname, GLint param);
void (APIENTRY * qglTexGeniv) (GLenum coord, GLenum pname, const GLint *params);
void (APIENTRY * qglTexImage1D) (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border,
			GLenum format, GLenum type, const GLvoid *pixels);
void (APIENTRY * qglTexImage2D) (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height,
			GLint border, GLenum format, GLenum type, const GLvoid *pixels);
void (APIENTRY * qglTexImageProxy1D) (GLenum target, GLint level, GLenum internalformat, GLsizei width,
			GLint border, GLenum format, GLenum type, const GLvoid *pixels);
void (APIENTRY * qglTexImageProxy2D) (GLenum target, GLint level, GLenum internalformat, GLsizei width,
			GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
void (APIENTRY * qglTexParameterf) (GLenum target, GLenum pname, GLfloat param);
void (APIENTRY * qglTexParameterfv) (GLenum target, GLenum pname, const GLfloat *params);
void (APIENTRY * qglTexParameteri) (GLenum target, GLenum pname, GLint param);
void (APIENTRY * qglTexParameteriv) (GLenum target, GLenum pname, const GLint *params);
void (APIENTRY * qglTexSubImage1D) (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format,
			GLenum type, const GLvoid *pixels);
void (APIENTRY * qglTexSubImage2D) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width,
			GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
void (APIENTRY * qglTranslated) (GLdouble x, GLdouble y, GLdouble z);
void (APIENTRY * qglTranslatef) (GLfloat x, GLfloat y, GLfloat z);
void (APIENTRY * qglVertex2d) (GLdouble x, GLdouble y);
void (APIENTRY * qglVertex2dv )(const GLdouble *v);
void (APIENTRY * qglVertex2f) (GLfloat x, GLfloat y);
void (APIENTRY * qglVertex2fv )(const GLfloat *v);
void (APIENTRY * qglVertex2i) (GLint x, GLint y);
void (APIENTRY * qglVertex2iv )(const GLint *v);
void (APIENTRY * qglVertex2s) (GLshort x, GLshort y);
void (APIENTRY * qglVertex2sv )(const GLshort *v);
void (APIENTRY * qglVertex3d) (GLdouble x, GLdouble y, GLdouble z);
void (APIENTRY * qglVertex3dv )(const GLdouble *v);
void (APIENTRY * qglVertex3f) (GLfloat x, GLfloat y, GLfloat z);
void (APIENTRY * qglVertex3fv )(const GLfloat *v);
void (APIENTRY * qglVertex3i) (GLint x, GLint y, GLint z);
void (APIENTRY * qglVertex3iv )(const GLint *v);
void (APIENTRY * qglVertex3s) (GLshort x, GLshort y, GLshort z);
void (APIENTRY * qglVertex3sv )(const GLshort *v);
void (APIENTRY * qglVertex4d) (GLdouble x, GLdouble y, GLdouble z, GLdouble w);
void (APIENTRY * qglVertex4dv )(const GLdouble *v);
void (APIENTRY * qglVertex4f) (GLfloat x, GLfloat y, GLfloat z, GLfloat w);
void (APIENTRY * qglVertex4fv )(const GLfloat *v);
void (APIENTRY * qglVertex4i) (GLint x, GLint y, GLint z, GLint w);
void (APIENTRY * qglVertex4iv )(const GLint *v);
void (APIENTRY * qglVertex4s) (GLshort x, GLshort y, GLshort z, GLshort w);
void (APIENTRY * qglVertex4sv )(const GLshort *v);
void (APIENTRY * qglVertexPointer) (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void (APIENTRY * qglViewport) (GLint x, GLint y, GLsizei width, GLsizei height);

void (APIENTRY * qglLockArraysEXT)(int, int);
void (APIENTRY * qglUnlockArraysEXT) (void);

void (APIENTRY * qglPointParameterfEXT) (GLenum param, GLfloat value);
void (APIENTRY * qglPointParameterfvEXT) (GLenum param, const GLfloat *value);
void (APIENTRY * qglColorTableEXT)(int, int, int, int, int, const void *);
void (APIENTRY * qglSelectTextureSGIS) (GLenum);
void (APIENTRY * qglMultiTexCoord2fARB) (GLenum, GLfloat, GLfloat);
void (APIENTRY * qglActiveTextureARB) (GLenum);
void (APIENTRY * qglClientActiveTextureARB) (GLenum);
void (APIENTRY * qglMultiTexCoord3fARB) (GLenum, GLfloat, GLfloat, GLfloat);
void (APIENTRY * qglMultiTexCoord3fvARB) (GLenum, GLfloat *);

void (APIENTRY * qglActiveStencilFaceEXT) (GLenum face);
void (APIENTRY * qglStencilOpSeparateATI) (GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass);
void (APIENTRY * qglStencilFuncSeparateATI) (GLenum frontfunc, GLenum backfunc, GLint red, GLuint mask);

#ifdef HAVE_SHADERS
/* arb shader stuff */
void (APIENTRY * qglProgramStringARB)  (GLenum, GLenum, GLsizei, const GLvoid *);
void (APIENTRY * qglBindProgramARB)  (GLenum, GLuint);
void (APIENTRY * qglDeleteProgramsARB)  (GLsizei, const GLuint *);
void (APIENTRY * qglGenProgramsARB)  (GLsizei, GLuint *);
void (APIENTRY * qglProgramEnvParameter4dARB)  (GLenum, GLuint, GLdouble, GLdouble, GLdouble, GLdouble);
void (APIENTRY * qglProgramEnvParameter4dvARB)  (GLenum, GLuint, const GLdouble *);
void (APIENTRY * qglProgramEnvParameter4fARB)  (GLenum, GLuint, GLfloat, GLfloat, GLfloat, GLfloat);
void (APIENTRY * qglProgramEnvParameter4fvARB)  (GLenum, GLuint, const GLfloat *);
void (APIENTRY * qglProgramLocalParameter4dARB)  (GLenum, GLuint, GLdouble, GLdouble, GLdouble, GLdouble);
void (APIENTRY * qglProgramLocalParameter4dvARB)  (GLenum, GLuint, const GLdouble *);
void (APIENTRY * qglProgramLocalParameter4fARB)  (GLenum, GLuint, GLfloat, GLfloat, GLfloat, GLfloat);
void (APIENTRY * qglProgramLocalParameter4fvARB)  (GLenum, GLuint, const GLfloat *);
void (APIENTRY * qglGetProgramEnvParameterdvARB)  (GLenum, GLuint, GLdouble *);
void (APIENTRY * qglGetProgramEnvParameterfvARB)  (GLenum, GLuint, GLfloat *);
void (APIENTRY * qglGetProgramLocalParameterdvARB)  (GLenum, GLuint, GLdouble *);
void (APIENTRY * qglGetProgramLocalParameterfvARB)  (GLenum, GLuint, GLfloat *);
void (APIENTRY * qglGetProgramivARB)  (GLenum, GLenum, GLint *);
void (APIENTRY * qglGetProgramStringARB)  (GLenum, GLenum, GLvoid *);
void (APIENTRY * qglGetVertexAttribdvARB)  (GLuint, GLenum, GLdouble *);
void (APIENTRY * qglGetVertexAttribfvARB)  (GLuint, GLenum, GLfloat *);
void (APIENTRY * qglGetVertexAttribivARB)  (GLuint, GLenum, GLint *);
void (APIENTRY * qglGetVertexAttribPointervARB)  (GLuint, GLenum, GLvoid * *);
GLboolean(APIENTRY * qglIsProgramARB)  (GLuint);

/* GLSL */
GLuint (APIENTRY * qglCreateShader)  (GLenum  shaderType);
void (APIENTRY * qglShaderSource)  (GLuint shader, int numOfStrings, const char **strings, int *lenOfStrings);
void (APIENTRY * qglCompileShader)  (GLuint shader);
GLuint (APIENTRY * qglCreateProgram) (void);
void (APIENTRY * qglAttachShader)  (GLuint program, GLuint shader);
void (APIENTRY * qglLinkProgram)  (GLuint program);
void (APIENTRY * qglUseProgram)  (GLuint program);
void (APIENTRY * qglDeleteShader)  (GLuint id);
void (APIENTRY * qglDeleteProgram)  (GLuint id);

#endif /* HAVE_SHADERS */

/**
 * @brief Reset all pointers to null
 */
void QR_UnLink (void)
{
	qglAccum                     = NULL;
	qglAlphaFunc                 = NULL;
	qglAreTexturesResident       = NULL;
	qglArrayElement              = NULL;
	qglBegin                     = NULL;
	qglBindTexture               = NULL;
	qglBitmap                    = NULL;
	qglBlendFunc                 = NULL;
	qglCallList                  = NULL;
	qglCallLists                 = NULL;
	qglClear                     = NULL;
	qglClearAccum                = NULL;
	qglClearColor                = NULL;
	qglClearDepth                = NULL;
	qglClearIndex                = NULL;
	qglClearStencil              = NULL;
	qglClipPlane                 = NULL;
	qglColor3b                   = NULL;
	qglColor3bv                  = NULL;
	qglColor3d                   = NULL;
	qglColor3dv                  = NULL;
	qglColor3f                   = NULL;
	qglColor3fv                  = NULL;
	qglColor3i                   = NULL;
	qglColor3iv                  = NULL;
	qglColor3s                   = NULL;
	qglColor3sv                  = NULL;
	qglColor3ub                  = NULL;
	qglColor3ubv                 = NULL;
	qglColor3ui                  = NULL;
	qglColor3uiv                 = NULL;
	qglColor3us                  = NULL;
	qglColor3usv                 = NULL;
	qglColor4b                   = NULL;
	qglColor4bv                  = NULL;
	qglColor4d                   = NULL;
	qglColor4dv                  = NULL;
	qglColor4f                   = NULL;
	qglColor4fv                  = NULL;
	qglColor4i                   = NULL;
	qglColor4iv                  = NULL;
	qglColor4s                   = NULL;
	qglColor4sv                  = NULL;
	qglColor4ub                  = NULL;
	qglColor4ubv                 = NULL;
	qglColor4ui                  = NULL;
	qglColor4uiv                 = NULL;
	qglColor4us                  = NULL;
	qglColor4usv                 = NULL;
	qglColorMask                 = NULL;
	qglColorMaterial             = NULL;
	qglColorPointer              = NULL;
	qglCopyPixels                = NULL;
	qglCopyTexImage1D            = NULL;
	qglCopyTexImage2D            = NULL;
	qglCopyTexSubImage1D         = NULL;
	qglCopyTexSubImage2D         = NULL;
	qglCullFace                  = NULL;
	qglDeleteLists               = NULL;
	qglDeleteTextures            = NULL;
	qglDepthFunc                 = NULL;
	qglDepthMask                 = NULL;
	qglDepthRange                = NULL;
	qglDisable                   = NULL;
	qglDisableClientState        = NULL;
	qglDrawArrays                = NULL;
	qglDrawBuffer                = NULL;
	qglDrawElements              = NULL;
	qglDrawPixels                = NULL;
	qglEdgeFlag                  = NULL;
	qglEdgeFlagPointer           = NULL;
	qglEdgeFlagv                 = NULL;
	qglEnable                    = NULL;
	qglEnableClientState         = NULL;
	qglEnd                       = NULL;
	qglEndList                   = NULL;
	qglEvalCoord1d               = NULL;
	qglEvalCoord1dv              = NULL;
	qglEvalCoord1f               = NULL;
	qglEvalCoord1fv              = NULL;
	qglEvalCoord2d               = NULL;
	qglEvalCoord2dv              = NULL;
	qglEvalCoord2f               = NULL;
	qglEvalCoord2fv              = NULL;
	qglEvalMesh1                 = NULL;
	qglEvalMesh2                 = NULL;
	qglEvalPoint1                = NULL;
	qglEvalPoint2                = NULL;
	qglFeedbackBuffer            = NULL;
	qglFinish                    = NULL;
	qglFlush                     = NULL;
	qglFogf                      = NULL;
	qglFogfv                     = NULL;
	qglFogi                      = NULL;
	qglFogiv                     = NULL;
	qglFrontFace                 = NULL;
	qglFrustum                   = NULL;
	qglGenLists                  = NULL;
	qglGenTextures               = NULL;
	qglGetBooleanv               = NULL;
	qglGetClipPlane              = NULL;
	qglGetDoublev                = NULL;
	qglGetError                  = NULL;
	qglGetFloatv                 = NULL;
	qglGetIntegerv               = NULL;
	qglGetLightfv                = NULL;
	qglGetLightiv                = NULL;
	qglGetMapdv                  = NULL;
	qglGetMapfv                  = NULL;
	qglGetMapiv                  = NULL;
	qglGetMaterialfv             = NULL;
	qglGetMaterialiv             = NULL;
	qglGetPixelMapfv             = NULL;
	qglGetPixelMapuiv            = NULL;
	qglGetPixelMapusv            = NULL;
	qglGetPointerv               = NULL;
	qglGetPolygonStipple         = NULL;
	qglGetString                 = NULL;
	qglGetTexEnvfv               = NULL;
	qglGetTexEnviv               = NULL;
	qglGetTexGendv               = NULL;
	qglGetTexGenfv               = NULL;
	qglGetTexGeniv               = NULL;
	qglGetTexImage               = NULL;
	qglGetTexLevelParameterfv    = NULL;
	qglGetTexLevelParameteriv    = NULL;
	qglGetTexParameterfv         = NULL;
	qglGetTexParameteriv         = NULL;
	qglHint                      = NULL;
	qglIndexMask                 = NULL;
	qglIndexPointer              = NULL;
	qglIndexd                    = NULL;
	qglIndexdv                   = NULL;
	qglIndexf                    = NULL;
	qglIndexfv                   = NULL;
	qglIndexi                    = NULL;
	qglIndexiv                   = NULL;
	qglIndexs                    = NULL;
	qglIndexsv                   = NULL;
	qglIndexub                   = NULL;
	qglIndexubv                  = NULL;
	qglInitNames                 = NULL;
	qglInterleavedArrays         = NULL;
	qglIsEnabled                 = NULL;
	qglIsList                    = NULL;
	qglIsTexture                 = NULL;
	qglLightModelf               = NULL;
	qglLightModelfv              = NULL;
	qglLightModeli               = NULL;
	qglLightModeliv              = NULL;
	qglLightf                    = NULL;
	qglLightfv                   = NULL;
	qglLighti                    = NULL;
	qglLightiv                   = NULL;
	qglLineStipple               = NULL;
	qglLineWidth                 = NULL;
	qglListBase                  = NULL;
	qglLoadIdentity              = NULL;
	qglLoadMatrixd               = NULL;
	qglLoadMatrixf               = NULL;
	qglLoadName                  = NULL;
	qglLogicOp                   = NULL;
	qglMap1d                     = NULL;
	qglMap1f                     = NULL;
	qglMap2d                     = NULL;
	qglMap2f                     = NULL;
	qglMapGrid1d                 = NULL;
	qglMapGrid1f                 = NULL;
	qglMapGrid2d                 = NULL;
	qglMapGrid2f                 = NULL;
	qglMaterialf                 = NULL;
	qglMaterialfv                = NULL;
	qglMateriali                 = NULL;
	qglMaterialiv                = NULL;
	qglMatrixMode                = NULL;
	qglMultMatrixd               = NULL;
	qglMultMatrixf               = NULL;
	qglNewList                   = NULL;
	qglNormal3b                  = NULL;
	qglNormal3bv                 = NULL;
	qglNormal3d                  = NULL;
	qglNormal3dv                 = NULL;
	qglNormal3f                  = NULL;
	qglNormal3fv                 = NULL;
	qglNormal3i                  = NULL;
	qglNormal3iv                 = NULL;
	qglNormal3s                  = NULL;
	qglNormal3sv                 = NULL;
	qglNormalPointer             = NULL;
	qglOrtho                     = NULL;
	qglPassThrough               = NULL;
	qglPixelMapfv                = NULL;
	qglPixelMapuiv               = NULL;
	qglPixelMapusv               = NULL;
	qglPixelStoref               = NULL;
	qglPixelStorei               = NULL;
	qglPixelTransferf            = NULL;
	qglPixelTransferi            = NULL;
	qglPixelZoom                 = NULL;
	qglPointSize                 = NULL;
	qglPolygonMode               = NULL;
	qglPolygonOffset             = NULL;
	qglPolygonStipple            = NULL;
	qglPopAttrib                 = NULL;
	qglPopClientAttrib           = NULL;
	qglPopMatrix                 = NULL;
	qglPopName                   = NULL;
	qglPrioritizeTextures        = NULL;
	qglPushAttrib                = NULL;
	qglPushClientAttrib          = NULL;
	qglPushMatrix                = NULL;
	qglPushName                  = NULL;
	qglRasterPos2d               = NULL;
	qglRasterPos2dv              = NULL;
	qglRasterPos2f               = NULL;
	qglRasterPos2fv              = NULL;
	qglRasterPos2i               = NULL;
	qglRasterPos2iv              = NULL;
	qglRasterPos2s               = NULL;
	qglRasterPos2sv              = NULL;
	qglRasterPos3d               = NULL;
	qglRasterPos3dv              = NULL;
	qglRasterPos3f               = NULL;
	qglRasterPos3fv              = NULL;
	qglRasterPos3i               = NULL;
	qglRasterPos3iv              = NULL;
	qglRasterPos3s               = NULL;
	qglRasterPos3sv              = NULL;
	qglRasterPos4d               = NULL;
	qglRasterPos4dv              = NULL;
	qglRasterPos4f               = NULL;
	qglRasterPos4fv              = NULL;
	qglRasterPos4i               = NULL;
	qglRasterPos4iv              = NULL;
	qglRasterPos4s               = NULL;
	qglRasterPos4sv              = NULL;
	qglReadBuffer                = NULL;
	qglReadPixels                = NULL;
	qglRectd                     = NULL;
	qglRectdv                    = NULL;
	qglRectf                     = NULL;
	qglRectfv                    = NULL;
	qglRecti                     = NULL;
	qglRectiv                    = NULL;
	qglRects                     = NULL;
	qglRectsv                    = NULL;
	qglRenderMode                = NULL;
	qglRotated                   = NULL;
	qglRotatef                   = NULL;
	qglScaled                    = NULL;
	qglScalef                    = NULL;
	qglScissor                   = NULL;
	qglSelectBuffer              = NULL;
	qglStencilFunc               = NULL;
	qglStencilMask               = NULL;
	qglStencilOp                 = NULL;
	qglTexCoord1d                = NULL;
	qglTexCoord1dv               = NULL;
	qglTexCoord1f                = NULL;
	qglTexCoord1fv               = NULL;
	qglTexCoord1i                = NULL;
	qglTexCoord1iv               = NULL;
	qglTexCoord1s                = NULL;
	qglTexCoord1sv               = NULL;
	qglTexCoord2d                = NULL;
	qglTexCoord2dv               = NULL;
	qglTexCoord2f                = NULL;
	qglTexCoord2fv               = NULL;
	qglTexCoord2i                = NULL;
	qglTexCoord2iv               = NULL;
	qglTexCoord2s                = NULL;
	qglTexCoord2sv               = NULL;
	qglTexCoord3d                = NULL;
	qglTexCoord3dv               = NULL;
	qglTexCoord3f                = NULL;
	qglTexCoord3fv               = NULL;
	qglTexCoord3i                = NULL;
	qglTexCoord3iv               = NULL;
	qglTexCoord3s                = NULL;
	qglTexCoord3sv               = NULL;
	qglTexCoord4d                = NULL;
	qglTexCoord4dv               = NULL;
	qglTexCoord4f                = NULL;
	qglTexCoord4fv               = NULL;
	qglTexCoord4i                = NULL;
	qglTexCoord4iv               = NULL;
	qglTexCoord4s                = NULL;
	qglTexCoord4sv               = NULL;
	qglTexCoordPointer           = NULL;
	qglTexEnvf                   = NULL;
	qglTexEnvfv                  = NULL;
	qglTexEnvi                   = NULL;
	qglTexEnviv                  = NULL;
	qglTexGend                   = NULL;
	qglTexGendv                  = NULL;
	qglTexGenf                   = NULL;
	qglTexGenfv                  = NULL;
	qglTexGeni                   = NULL;
	qglTexGeniv                  = NULL;
	qglTexImage1D                = NULL;
	qglTexImage2D                = NULL;
	qglTexParameterf             = NULL;
	qglTexParameterfv            = NULL;
	qglTexParameteri             = NULL;
	qglTexParameteriv            = NULL;
	qglTexSubImage1D             = NULL;
	qglTexSubImage2D             = NULL;
	qglTranslated                = NULL;
	qglTranslatef                = NULL;
	qglVertex2d                  = NULL;
	qglVertex2dv                 = NULL;
	qglVertex2f                  = NULL;
	qglVertex2fv                 = NULL;
	qglVertex2i                  = NULL;
	qglVertex2iv                 = NULL;
	qglVertex2s                  = NULL;
	qglVertex2sv                 = NULL;
	qglVertex3d                  = NULL;
	qglVertex3dv                 = NULL;
	qglVertex3f                  = NULL;
	qglVertex3fv                 = NULL;
	qglVertex3i                  = NULL;
	qglVertex3iv                 = NULL;
	qglVertex3s                  = NULL;
	qglVertex3sv                 = NULL;
	qglVertex4d                  = NULL;
	qglVertex4dv                 = NULL;
	qglVertex4f                  = NULL;
	qglVertex4fv                 = NULL;
	qglVertex4i                  = NULL;
	qglVertex4iv                 = NULL;
	qglVertex4s                  = NULL;
	qglVertex4sv                 = NULL;
	qglVertexPointer             = NULL;
	qglViewport                  = NULL;
	qglActiveStencilFaceEXT      = NULL;
	qglStencilOpSeparateATI      = NULL;
	qglStencilFuncSeparateATI    = NULL;
#ifdef HAVE_SHADERS
	qglProgramStringARB          = NULL;
	qglBindProgramARB            = NULL;
	qglDeleteProgramsARB         = NULL;
	qglGenProgramsARB            = NULL;
	qglProgramEnvParameter4dARB  = NULL;
	qglProgramEnvParameter4dvARB = NULL;
	qglProgramEnvParameter4fARB  = NULL;
	qglProgramEnvParameter4fvARB = NULL;
	qglProgramLocalParameter4dARB    = NULL;
	qglProgramLocalParameter4dvARB   = NULL;
	qglProgramLocalParameter4fARB    = NULL;
	qglProgramLocalParameter4fvARB   = NULL;
	qglGetProgramEnvParameterdvARB   = NULL;
	qglGetProgramEnvParameterfvARB   = NULL;
	qglGetProgramLocalParameterdvARB = NULL;
	qglGetProgramLocalParameterfvARB = NULL;
	qglGetProgramivARB            = NULL;
	qglGetProgramStringARB        = NULL;
	qglGetVertexAttribdvARB       = NULL;
	qglGetVertexAttribfvARB       = NULL;
	qglGetVertexAttribivARB       = NULL;
	qglGetVertexAttribPointervARB = NULL;
	qglIsProgramARB               = NULL;

	qglCreateShader  = NULL;
	qglShaderSource  = NULL;
	qglCompileShader = NULL;
	qglCreateProgram = NULL;
	qglAttachShader  = NULL;
	qglLinkProgram   = NULL;
	qglUseProgram    = NULL;
	qglDeleteShader  = NULL;
	qglDeleteProgram = NULL;
#endif
}

/**
 * @brief Link the qgl function pointers
 */
void QR_Link (void)
{
	qglAccum                     = SDL_GL_GetProcAddress("glAccum");
	qglAlphaFunc                 = SDL_GL_GetProcAddress("glAlphaFunc");
	qglAreTexturesResident       = SDL_GL_GetProcAddress("glAreTexturesResident");
	qglArrayElement              = SDL_GL_GetProcAddress("glArrayElement");
	qglBegin                     = SDL_GL_GetProcAddress("glBegin");
	qglBindTexture               = SDL_GL_GetProcAddress("glBindTexture");
	qglBitmap                    = SDL_GL_GetProcAddress("glBitmap");
	qglBlendFunc                 = SDL_GL_GetProcAddress("glBlendFunc");
	qglCallList                  = SDL_GL_GetProcAddress("glCallList");
	qglCallLists                 = SDL_GL_GetProcAddress("glCallLists");
	qglClear                     = SDL_GL_GetProcAddress("glClear");
	qglClearAccum                = SDL_GL_GetProcAddress("glClearAccum");
	qglClearColor                = SDL_GL_GetProcAddress("glClearColor");
	qglClearDepth                = SDL_GL_GetProcAddress("glClearDepth");
	qglClearIndex                = SDL_GL_GetProcAddress("glClearIndex");
	qglClearStencil              = SDL_GL_GetProcAddress("glClearStencil");
	qglClipPlane                 = SDL_GL_GetProcAddress("glClipPlane");
	qglColor3b                   = SDL_GL_GetProcAddress("glColor3b");
	qglColor3bv                  = SDL_GL_GetProcAddress("glColor3bv");
	qglColor3d                   = SDL_GL_GetProcAddress("glColor3d");
	qglColor3dv                  = SDL_GL_GetProcAddress("glColor3dv");
	qglColor3f                   = SDL_GL_GetProcAddress("glColor3f");
	qglColor3fv                  = SDL_GL_GetProcAddress("glColor3fv");
	qglColor3i                   = SDL_GL_GetProcAddress("glColor3i");
	qglColor3iv                  = SDL_GL_GetProcAddress("glColor3iv");
	qglColor3s                   = SDL_GL_GetProcAddress("glColor3s");
	qglColor3sv                  = SDL_GL_GetProcAddress("glColor3sv");
	qglColor3ub                  = SDL_GL_GetProcAddress("glColor3ub");
	qglColor3ubv                 = SDL_GL_GetProcAddress("glColor3ubv");
	qglColor3ui                  = SDL_GL_GetProcAddress("glColor3ui");
	qglColor3uiv                 = SDL_GL_GetProcAddress("glColor3uiv");
	qglColor3us                  = SDL_GL_GetProcAddress("glColor3us");
	qglColor3usv                 = SDL_GL_GetProcAddress("glColor3usv");
	qglColor4b                   = SDL_GL_GetProcAddress("glColor4b");
	qglColor4bv                  = SDL_GL_GetProcAddress("glColor4bv");
	qglColor4d                   = SDL_GL_GetProcAddress("glColor4d");
	qglColor4dv                  = SDL_GL_GetProcAddress("glColor4dv");
	qglColor4f                   = SDL_GL_GetProcAddress("glColor4f");
	qglColor4fv                  = SDL_GL_GetProcAddress("glColor4fv");
	qglColor4i                   = SDL_GL_GetProcAddress("glColor4i");
	qglColor4iv                  = SDL_GL_GetProcAddress("glColor4iv");
	qglColor4s                   = SDL_GL_GetProcAddress("glColor4s");
	qglColor4sv                  = SDL_GL_GetProcAddress("glColor4sv");
	qglColor4ub                  = SDL_GL_GetProcAddress("glColor4ub");
	qglColor4ubv                 = SDL_GL_GetProcAddress("glColor4ubv");
	qglColor4ui                  = SDL_GL_GetProcAddress("glColor4ui");
	qglColor4uiv                 = SDL_GL_GetProcAddress("glColor4uiv");
	qglColor4us                  = SDL_GL_GetProcAddress("glColor4us");
	qglColor4usv                 = SDL_GL_GetProcAddress("glColor4usv");
	qglColorMask                 = SDL_GL_GetProcAddress("glColorMask");
	qglColorMaterial             = SDL_GL_GetProcAddress("glColorMaterial");
	qglColorPointer              = SDL_GL_GetProcAddress("glColorPointer");
	qglCopyPixels                = SDL_GL_GetProcAddress("glCopyPixels");
	qglCopyTexImage1D            = SDL_GL_GetProcAddress("glCopyTexImage1D");
	qglCopyTexImage2D            = SDL_GL_GetProcAddress("glCopyTexImage2D");
	qglCopyTexSubImage1D         = SDL_GL_GetProcAddress("glCopyTexSubImage1D");
	qglCopyTexSubImage2D         = SDL_GL_GetProcAddress("glCopyTexSubImage2D");
	qglCullFace                  = SDL_GL_GetProcAddress("glCullFace");
	qglDeleteLists               = SDL_GL_GetProcAddress("glDeleteLists");
	qglDeleteTextures            = SDL_GL_GetProcAddress("glDeleteTextures");
	qglDepthFunc                 = SDL_GL_GetProcAddress("glDepthFunc");
	qglDepthMask                 = SDL_GL_GetProcAddress("glDepthMask");
	qglDepthRange                = SDL_GL_GetProcAddress("glDepthRange");
	qglDisable                   = SDL_GL_GetProcAddress("glDisable");
	qglDisableClientState        = SDL_GL_GetProcAddress("glDisableClientState");
	qglDrawArrays                = SDL_GL_GetProcAddress("glDrawArrays");
	qglDrawBuffer                = SDL_GL_GetProcAddress("glDrawBuffer");
	qglDrawElements              = SDL_GL_GetProcAddress("glDrawElements");
	qglDrawPixels                = SDL_GL_GetProcAddress("glDrawPixels");
	qglEdgeFlag                  = SDL_GL_GetProcAddress("glEdgeFlag");
	qglEdgeFlagPointer           = SDL_GL_GetProcAddress("glEdgeFlagPointer");
	qglEdgeFlagv                 = SDL_GL_GetProcAddress("glEdgeFlagv");
	qglEnable                    = SDL_GL_GetProcAddress("glEnable");
	qglEnableClientState         = SDL_GL_GetProcAddress("glEnableClientState");
	qglEnd                       = SDL_GL_GetProcAddress("glEnd");
	qglEndList                   = SDL_GL_GetProcAddress("glEndList");
	qglEvalCoord1d               = SDL_GL_GetProcAddress("glEvalCoord1d");
	qglEvalCoord1dv              = SDL_GL_GetProcAddress("glEvalCoord1dv");
	qglEvalCoord1f               = SDL_GL_GetProcAddress("glEvalCoord1f");
	qglEvalCoord1fv              = SDL_GL_GetProcAddress("glEvalCoord1fv");
	qglEvalCoord2d               = SDL_GL_GetProcAddress("glEvalCoord2d");
	qglEvalCoord2dv              = SDL_GL_GetProcAddress("glEvalCoord2dv");
	qglEvalCoord2f               = SDL_GL_GetProcAddress("glEvalCoord2f");
	qglEvalCoord2fv              = SDL_GL_GetProcAddress("glEvalCoord2fv");
	qglEvalMesh1                 = SDL_GL_GetProcAddress("glEvalMesh1");
	qglEvalMesh2                 = SDL_GL_GetProcAddress("glEvalMesh2");
	qglEvalPoint1                = SDL_GL_GetProcAddress("glEvalPoint1");
	qglEvalPoint2                = SDL_GL_GetProcAddress("glEvalPoint2");
	qglFeedbackBuffer            = SDL_GL_GetProcAddress("glFeedbackBuffer");
	qglFinish                    = SDL_GL_GetProcAddress("glFinish");
	qglFlush                     = SDL_GL_GetProcAddress("glFlush");
	qglFogf                      = SDL_GL_GetProcAddress("glFogf");
	qglFogfv                     = SDL_GL_GetProcAddress("glFogfv");
	qglFogi                      = SDL_GL_GetProcAddress("glFogi");
	qglFogiv                     = SDL_GL_GetProcAddress("glFogiv");
	qglFrontFace                 = SDL_GL_GetProcAddress("glFrontFace");
	qglFrustum                   = SDL_GL_GetProcAddress("glFrustum");
	qglGenLists                  = SDL_GL_GetProcAddress("glGenLists");
	qglGenTextures               = SDL_GL_GetProcAddress("glGenTextures");
	qglGetBooleanv               = SDL_GL_GetProcAddress("glGetBooleanv");
	qglGetClipPlane              = SDL_GL_GetProcAddress("glGetClipPlane");
	qglGetDoublev                = SDL_GL_GetProcAddress("glGetDoublev");
	qglGetError                  = SDL_GL_GetProcAddress("glGetError");
	qglGetFloatv                 = SDL_GL_GetProcAddress("glGetFloatv");
	qglGetIntegerv               = SDL_GL_GetProcAddress("glGetIntegerv");
	qglGetLightfv                = SDL_GL_GetProcAddress("glGetLightfv");
	qglGetLightiv                = SDL_GL_GetProcAddress("glGetLightiv");
	qglGetMapdv                  = SDL_GL_GetProcAddress("glGetMapdv");
	qglGetMapfv                  = SDL_GL_GetProcAddress("glGetMapfv");
	qglGetMapiv                  = SDL_GL_GetProcAddress("glGetMapiv");
	qglGetMaterialfv             = SDL_GL_GetProcAddress("glGetMaterialfv");
	qglGetMaterialiv             = SDL_GL_GetProcAddress("glGetMaterialiv");
	qglGetPixelMapfv             = SDL_GL_GetProcAddress("glGetPixelMapfv");
	qglGetPixelMapuiv            = SDL_GL_GetProcAddress("glGetPixelMapuiv");
	qglGetPixelMapusv            = SDL_GL_GetProcAddress("glGetPixelMapusv");
	qglGetPointerv               = SDL_GL_GetProcAddress("glGetPointerv");
	qglGetPolygonStipple         = SDL_GL_GetProcAddress("glGetPolygonStipple");
	qglGetString                 = SDL_GL_GetProcAddress("glGetString");
	qglGetTexEnvfv               = SDL_GL_GetProcAddress("glGetTexEnvfv");
	qglGetTexEnviv               = SDL_GL_GetProcAddress("glGetTexEnviv");
	qglGetTexGendv               = SDL_GL_GetProcAddress("glGetTexGendv");
	qglGetTexGenfv               = SDL_GL_GetProcAddress("glGetTexGenfv");
	qglGetTexGeniv               = SDL_GL_GetProcAddress("glGetTexGeniv");
	qglGetTexImage               = SDL_GL_GetProcAddress("glGetTexImage");
	qglGetTexLevelParameterfv    = SDL_GL_GetProcAddress("glGetTexLevelParameterfv");
	qglGetTexLevelParameteriv    = SDL_GL_GetProcAddress("glGetTexLevelParameteriv");
	qglGetTexParameterfv         = SDL_GL_GetProcAddress("glGetTexParameterfv");
	qglGetTexParameteriv         = SDL_GL_GetProcAddress("glGetTexParameteriv");
	qglHint                      = SDL_GL_GetProcAddress("glHint");
	qglIndexMask                 = SDL_GL_GetProcAddress("glIndexMask");
	qglIndexPointer              = SDL_GL_GetProcAddress("glIndexPointer");
	qglIndexd                    = SDL_GL_GetProcAddress("glIndexd");
	qglIndexdv                   = SDL_GL_GetProcAddress("glIndexdv");
	qglIndexf                    = SDL_GL_GetProcAddress("glIndexf");
	qglIndexfv                   = SDL_GL_GetProcAddress("glIndexfv");
	qglIndexi                    = SDL_GL_GetProcAddress("glIndexi");
	qglIndexiv                   = SDL_GL_GetProcAddress("glIndexiv");
	qglIndexs                    = SDL_GL_GetProcAddress("glIndexs");
	qglIndexsv                   = SDL_GL_GetProcAddress("glIndexsv");
	qglIndexub                   = SDL_GL_GetProcAddress("glIndexub");
	qglIndexubv                  = SDL_GL_GetProcAddress("glIndexubv");
	qglInitNames                 = SDL_GL_GetProcAddress("glInitNames");
	qglInterleavedArrays         = SDL_GL_GetProcAddress("glInterleavedArrays");
	qglIsEnabled                 = SDL_GL_GetProcAddress("glIsEnabled");
	qglIsList                    = SDL_GL_GetProcAddress("glIsList");
	qglIsTexture                 = SDL_GL_GetProcAddress("glIsTexture");
	qglLightModelf               = SDL_GL_GetProcAddress("glLightModelf");
	qglLightModelfv              = SDL_GL_GetProcAddress("glLightModelfv");
	qglLightModeli               = SDL_GL_GetProcAddress("glLightModeli");
	qglLightModeliv              = SDL_GL_GetProcAddress("glLightModeliv");
	qglLightf                    = SDL_GL_GetProcAddress("glLightf");
	qglLightfv                   = SDL_GL_GetProcAddress("glLightfv");
	qglLighti                    = SDL_GL_GetProcAddress("glLighti");
	qglLightiv                   = SDL_GL_GetProcAddress("glLightiv");
	qglLineStipple               = SDL_GL_GetProcAddress("glLineStipple");
	qglLineWidth                 = SDL_GL_GetProcAddress("glLineWidth");
	qglListBase                  = SDL_GL_GetProcAddress("glListBase");
	qglLoadIdentity              = SDL_GL_GetProcAddress("glLoadIdentity");
	qglLoadMatrixd               = SDL_GL_GetProcAddress("glLoadMatrixd");
	qglLoadMatrixf               = SDL_GL_GetProcAddress("glLoadMatrixf");
	qglLoadName                  = SDL_GL_GetProcAddress("glLoadName");
	qglLogicOp                   = SDL_GL_GetProcAddress("glLogicOp");
	qglMap1d                     = SDL_GL_GetProcAddress("glMap1d");
	qglMap1f                     = SDL_GL_GetProcAddress("glMap1f");
	qglMap2d                     = SDL_GL_GetProcAddress("glMap2d");
	qglMap2f                     = SDL_GL_GetProcAddress("glMap2f");
	qglMapGrid1d                 = SDL_GL_GetProcAddress("glMapGrid1d");
	qglMapGrid1f                 = SDL_GL_GetProcAddress("glMapGrid1f");
	qglMapGrid2d                 = SDL_GL_GetProcAddress("glMapGrid2d");
	qglMapGrid2f                 = SDL_GL_GetProcAddress("glMapGrid2f");
	qglMaterialf                 = SDL_GL_GetProcAddress("glMaterialf");
	qglMaterialfv                = SDL_GL_GetProcAddress("glMaterialfv");
	qglMateriali                 = SDL_GL_GetProcAddress("glMateriali");
	qglMaterialiv                = SDL_GL_GetProcAddress("glMaterialiv");
	qglMatrixMode                = SDL_GL_GetProcAddress("glMatrixMode");
	qglMultMatrixd               = SDL_GL_GetProcAddress("glMultMatrixd");
	qglMultMatrixf               = SDL_GL_GetProcAddress("glMultMatrixf");
	qglNewList                   = SDL_GL_GetProcAddress("glNewList");
	qglNormal3b                  = SDL_GL_GetProcAddress("glNormal3b");
	qglNormal3bv                 = SDL_GL_GetProcAddress("glNormal3bv");
	qglNormal3d                  = SDL_GL_GetProcAddress("glNormal3d");
	qglNormal3dv                 = SDL_GL_GetProcAddress("glNormal3dv");
	qglNormal3f                  = SDL_GL_GetProcAddress("glNormal3f");
	qglNormal3fv                 = SDL_GL_GetProcAddress("glNormal3fv");
	qglNormal3i                  = SDL_GL_GetProcAddress("glNormal3i");
	qglNormal3iv                 = SDL_GL_GetProcAddress("glNormal3iv");
	qglNormal3s                  = SDL_GL_GetProcAddress("glNormal3s");
	qglNormal3sv                 = SDL_GL_GetProcAddress("glNormal3sv");
	qglNormalPointer             = SDL_GL_GetProcAddress("glNormalPointer");
	qglOrtho                     = SDL_GL_GetProcAddress("glOrtho");
	qglPassThrough               = SDL_GL_GetProcAddress("glPassThrough");
	qglPixelMapfv                = SDL_GL_GetProcAddress("glPixelMapfv");
	qglPixelMapuiv               = SDL_GL_GetProcAddress("glPixelMapuiv");
	qglPixelMapusv               = SDL_GL_GetProcAddress("glPixelMapusv");
	qglPixelStoref               = SDL_GL_GetProcAddress("glPixelStoref");
	qglPixelStorei               = SDL_GL_GetProcAddress("glPixelStorei");
	qglPixelTransferf            = SDL_GL_GetProcAddress("glPixelTransferf");
	qglPixelTransferi            = SDL_GL_GetProcAddress("glPixelTransferi");
	qglPixelZoom                 = SDL_GL_GetProcAddress("glPixelZoom");
	qglPointSize                 = SDL_GL_GetProcAddress("glPointSize");
	qglPolygonMode               = SDL_GL_GetProcAddress("glPolygonMode");
	qglPolygonOffset             = SDL_GL_GetProcAddress("glPolygonOffset");
	qglPolygonStipple            = SDL_GL_GetProcAddress("glPolygonStipple");
	qglPopAttrib                 = SDL_GL_GetProcAddress("glPopAttrib");
	qglPopClientAttrib           = SDL_GL_GetProcAddress("glPopClientAttrib");
	qglPopMatrix                 = SDL_GL_GetProcAddress("glPopMatrix");
	qglPopName                   = SDL_GL_GetProcAddress("glPopName");
	qglPrioritizeTextures        = SDL_GL_GetProcAddress("glPrioritizeTextures");
	qglPushAttrib                = SDL_GL_GetProcAddress("glPushAttrib");
	qglPushClientAttrib          = SDL_GL_GetProcAddress("glPushClientAttrib");
	qglPushMatrix                = SDL_GL_GetProcAddress("glPushMatrix");
	qglPushName                  = SDL_GL_GetProcAddress("glPushName");
	qglRasterPos2d               = SDL_GL_GetProcAddress("glRasterPos2d");
	qglRasterPos2dv              = SDL_GL_GetProcAddress("glRasterPos2dv");
	qglRasterPos2f               = SDL_GL_GetProcAddress("glRasterPos2f");
	qglRasterPos2fv              = SDL_GL_GetProcAddress("glRasterPos2fv");
	qglRasterPos2i               = SDL_GL_GetProcAddress("glRasterPos2i");
	qglRasterPos2iv              = SDL_GL_GetProcAddress("glRasterPos2iv");
	qglRasterPos2s               = SDL_GL_GetProcAddress("glRasterPos2s");
	qglRasterPos2sv              = SDL_GL_GetProcAddress("glRasterPos2sv");
	qglRasterPos3d               = SDL_GL_GetProcAddress("glRasterPos3d");
	qglRasterPos3dv              = SDL_GL_GetProcAddress("glRasterPos3dv");
	qglRasterPos3f               = SDL_GL_GetProcAddress("glRasterPos3f");
	qglRasterPos3fv              = SDL_GL_GetProcAddress("glRasterPos3fv");
	qglRasterPos3i               = SDL_GL_GetProcAddress("glRasterPos3i");
	qglRasterPos3iv              = SDL_GL_GetProcAddress("glRasterPos3iv");
	qglRasterPos3s               = SDL_GL_GetProcAddress("glRasterPos3s");
	qglRasterPos3sv              = SDL_GL_GetProcAddress("glRasterPos3sv");
	qglRasterPos4d               = SDL_GL_GetProcAddress("glRasterPos4d");
	qglRasterPos4dv              = SDL_GL_GetProcAddress("glRasterPos4dv");
	qglRasterPos4f               = SDL_GL_GetProcAddress("glRasterPos4f");
	qglRasterPos4fv              = SDL_GL_GetProcAddress("glRasterPos4fv");
	qglRasterPos4i               = SDL_GL_GetProcAddress("glRasterPos4i");
	qglRasterPos4iv              = SDL_GL_GetProcAddress("glRasterPos4iv");
	qglRasterPos4s               = SDL_GL_GetProcAddress("glRasterPos4s");
	qglRasterPos4sv              = SDL_GL_GetProcAddress("glRasterPos4sv");
	qglReadBuffer                = SDL_GL_GetProcAddress("glReadBuffer");
	qglReadPixels                = SDL_GL_GetProcAddress("glReadPixels");
	qglRectd                     = SDL_GL_GetProcAddress("glRectd");
	qglRectdv                    = SDL_GL_GetProcAddress("glRectdv");
	qglRectf                     = SDL_GL_GetProcAddress("glRectf");
	qglRectfv                    = SDL_GL_GetProcAddress("glRectfv");
	qglRecti                     = SDL_GL_GetProcAddress("glRecti");
	qglRectiv                    = SDL_GL_GetProcAddress("glRectiv");
	qglRects                     = SDL_GL_GetProcAddress("glRects");
	qglRectsv                    = SDL_GL_GetProcAddress("glRectsv");
	qglRenderMode                = SDL_GL_GetProcAddress("glRenderMode");
	qglRotated                   = SDL_GL_GetProcAddress("glRotated");
	qglRotatef                   = SDL_GL_GetProcAddress("glRotatef");
	qglScaled                    = SDL_GL_GetProcAddress("glScaled");
	qglScalef                    = SDL_GL_GetProcAddress("glScalef");
	qglScissor                   = SDL_GL_GetProcAddress("glScissor");
	qglSelectBuffer              = SDL_GL_GetProcAddress("glSelectBuffer");
	qglStencilFunc               = SDL_GL_GetProcAddress("glStencilFunc");
	qglStencilMask               = SDL_GL_GetProcAddress("glStencilMask");
	qglStencilOp                 = SDL_GL_GetProcAddress("glStencilOp");
	qglTexCoord1d                = SDL_GL_GetProcAddress("glTexCoord1d");
	qglTexCoord1dv               = SDL_GL_GetProcAddress("glTexCoord1dv");
	qglTexCoord1f                = SDL_GL_GetProcAddress("glTexCoord1f");
	qglTexCoord1fv               = SDL_GL_GetProcAddress("glTexCoord1fv");
	qglTexCoord1i                = SDL_GL_GetProcAddress("glTexCoord1i");
	qglTexCoord1iv               = SDL_GL_GetProcAddress("glTexCoord1iv");
	qglTexCoord1s                = SDL_GL_GetProcAddress("glTexCoord1s");
	qglTexCoord1sv               = SDL_GL_GetProcAddress("glTexCoord1sv");
	qglTexCoord2d                = SDL_GL_GetProcAddress("glTexCoord2d");
	qglTexCoord2dv               = SDL_GL_GetProcAddress("glTexCoord2dv");
	qglTexCoord2f                = SDL_GL_GetProcAddress("glTexCoord2f");
	qglTexCoord2fv               = SDL_GL_GetProcAddress("glTexCoord2fv");
	qglTexCoord2i                = SDL_GL_GetProcAddress("glTexCoord2i");
	qglTexCoord2iv               = SDL_GL_GetProcAddress("glTexCoord2iv");
	qglTexCoord2s                = SDL_GL_GetProcAddress("glTexCoord2s");
	qglTexCoord2sv               = SDL_GL_GetProcAddress("glTexCoord2sv");
	qglTexCoord3d                = SDL_GL_GetProcAddress("glTexCoord3d");
	qglTexCoord3dv               = SDL_GL_GetProcAddress("glTexCoord3dv");
	qglTexCoord3f                = SDL_GL_GetProcAddress("glTexCoord3f");
	qglTexCoord3fv               = SDL_GL_GetProcAddress("glTexCoord3fv");
	qglTexCoord3i                = SDL_GL_GetProcAddress("glTexCoord3i");
	qglTexCoord3iv               = SDL_GL_GetProcAddress("glTexCoord3iv");
	qglTexCoord3s                = SDL_GL_GetProcAddress("glTexCoord3s");
	qglTexCoord3sv               = SDL_GL_GetProcAddress("glTexCoord3sv");
	qglTexCoord4d                = SDL_GL_GetProcAddress("glTexCoord4d");
	qglTexCoord4dv               = SDL_GL_GetProcAddress("glTexCoord4dv");
	qglTexCoord4f                = SDL_GL_GetProcAddress("glTexCoord4f");
	qglTexCoord4fv               = SDL_GL_GetProcAddress("glTexCoord4fv");
	qglTexCoord4i                = SDL_GL_GetProcAddress("glTexCoord4i");
	qglTexCoord4iv               = SDL_GL_GetProcAddress("glTexCoord4iv");
	qglTexCoord4s                = SDL_GL_GetProcAddress("glTexCoord4s");
	qglTexCoord4sv               = SDL_GL_GetProcAddress("glTexCoord4sv");
	qglTexCoordPointer           = SDL_GL_GetProcAddress("glTexCoordPointer");
	qglTexEnvf                   = SDL_GL_GetProcAddress("glTexEnvf");
	qglTexEnvfv                  = SDL_GL_GetProcAddress("glTexEnvfv");
	qglTexEnvi                   = SDL_GL_GetProcAddress("glTexEnvi");
	qglTexEnviv                  = SDL_GL_GetProcAddress("glTexEnviv");
	qglTexGend                   = SDL_GL_GetProcAddress("glTexGend");
	qglTexGendv                  = SDL_GL_GetProcAddress("glTexGendv");
	qglTexGenf                   = SDL_GL_GetProcAddress("glTexGenf");
	qglTexGenfv                  = SDL_GL_GetProcAddress("glTexGenfv");
	qglTexGeni                   = SDL_GL_GetProcAddress("glTexGeni");
	qglTexGeniv                  = SDL_GL_GetProcAddress("glTexGeniv");
	qglTexImage1D                = SDL_GL_GetProcAddress("glTexImage1D");
	qglTexImage2D                = SDL_GL_GetProcAddress("glTexImage2D");
	qglTexParameterf             = SDL_GL_GetProcAddress("glTexParameterf");
	qglTexParameterfv            = SDL_GL_GetProcAddress("glTexParameterfv");
	qglTexParameteri             = SDL_GL_GetProcAddress("glTexParameteri");
	qglTexParameteriv            = SDL_GL_GetProcAddress("glTexParameteriv");
	qglTexSubImage1D             = SDL_GL_GetProcAddress("glTexSubImage1D");
	qglTexSubImage2D             = SDL_GL_GetProcAddress("glTexSubImage2D");
	qglTranslated                = SDL_GL_GetProcAddress("glTranslated");
	qglTranslatef                = SDL_GL_GetProcAddress("glTranslatef");
	qglVertex2d                  = SDL_GL_GetProcAddress("glVertex2d");
	qglVertex2dv                 = SDL_GL_GetProcAddress("glVertex2dv");
	qglVertex2f                  = SDL_GL_GetProcAddress("glVertex2f");
	qglVertex2fv                 = SDL_GL_GetProcAddress("glVertex2fv");
	qglVertex2i                  = SDL_GL_GetProcAddress("glVertex2i");
	qglVertex2iv                 = SDL_GL_GetProcAddress("glVertex2iv");
	qglVertex2s                  = SDL_GL_GetProcAddress("glVertex2s");
	qglVertex2sv                 = SDL_GL_GetProcAddress("glVertex2sv");
	qglVertex3d                  = SDL_GL_GetProcAddress("glVertex3d");
	qglVertex3dv                 = SDL_GL_GetProcAddress("glVertex3dv");
	qglVertex3f                  = SDL_GL_GetProcAddress("glVertex3f");
	qglVertex3fv                 = SDL_GL_GetProcAddress("glVertex3fv");
	qglVertex3i                  = SDL_GL_GetProcAddress("glVertex3i");
	qglVertex3iv                 = SDL_GL_GetProcAddress("glVertex3iv");
	qglVertex3s                  = SDL_GL_GetProcAddress("glVertex3s");
	qglVertex3sv                 = SDL_GL_GetProcAddress("glVertex3sv");
	qglVertex4d                  = SDL_GL_GetProcAddress("glVertex4d");
	qglVertex4dv                 = SDL_GL_GetProcAddress("glVertex4dv");
	qglVertex4f                  = SDL_GL_GetProcAddress("glVertex4f");
	qglVertex4fv                 = SDL_GL_GetProcAddress("glVertex4fv");
	qglVertex4i                  = SDL_GL_GetProcAddress("glVertex4i");
	qglVertex4iv                 = SDL_GL_GetProcAddress("glVertex4iv");
	qglVertex4s                  = SDL_GL_GetProcAddress("glVertex4s");
	qglVertex4sv                 = SDL_GL_GetProcAddress("glVertex4sv");
	qglVertexPointer             = SDL_GL_GetProcAddress("glVertexPointer");
	qglViewport                  = SDL_GL_GetProcAddress("glViewport");
	qglLockArraysEXT             = NULL;
	qglUnlockArraysEXT           = NULL;
	qglPointParameterfEXT        = NULL;
	qglPointParameterfvEXT       = NULL;
	qglSelectTextureSGIS         = NULL;
	qglMultiTexCoord2fARB         = NULL;
	qglActiveTextureARB          = NULL;
	qglMultiTexCoord3fARB        = NULL;
	qglMultiTexCoord3fvARB       = NULL;
	qglClientActiveTextureARB    = NULL;
	qglActiveStencilFaceEXT      = NULL;
	qglStencilOpSeparateATI      = NULL;
	qglStencilFuncSeparateATI    = NULL;

#ifdef HAVE_SHADERS
	qglProgramStringARB          = NULL;
	qglBindProgramARB            = NULL;
	qglDeleteProgramsARB         = NULL;
	qglGenProgramsARB            = NULL;
	qglProgramEnvParameter4dARB  = NULL;
	qglProgramEnvParameter4dvARB = NULL;
	qglProgramEnvParameter4fARB  = NULL;
	qglProgramEnvParameter4fvARB = NULL;
	qglGetProgramivARB           = NULL;
	qglGetProgramStringARB       = NULL;
	qglGetVertexAttribdvARB      = NULL;
	qglGetVertexAttribfvARB      = NULL;
	qglGetVertexAttribivARB      = NULL;
	qglIsProgramARB              = NULL;
	qglProgramLocalParameter4dARB    = NULL;
	qglProgramLocalParameter4dvARB   = NULL;
	qglProgramLocalParameter4fARB    = NULL;
	qglProgramLocalParameter4fvARB   = NULL;
	qglGetProgramEnvParameterdvARB   = NULL;
	qglGetProgramEnvParameterfvARB   = NULL;
	qglGetVertexAttribPointervARB    = NULL;
	qglGetProgramLocalParameterdvARB = NULL;
	qglGetProgramLocalParameterfvARB = NULL;

	qglCreateShader  = NULL;
	qglShaderSource  = NULL;
	qglCompileShader = NULL;
	qglCreateProgram = NULL;
	qglAttachShader  = NULL;
	qglLinkProgram   = NULL;
	qglUseProgram    = NULL;
	qglDeleteShader  = NULL;
	qglDeleteProgram = NULL;
#endif
}
