/**
 * @file cl_console.h
 * @brief Console header file.
 */

/*
All original materal Copyright (C) 2002-2007 UFO: Alien Invasion team.

Original file from Quake 2 v3.21: quake2-2.31/client/console.h
Copyright (C) 1997-2001 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef CLIENT_CL_CONSOLE_H
#define CLIENT_CL_CONSOLE_H

#define	NUM_CON_TIMES 8

#define COLORED_TEXT_MASK 128

#define		CON_TEXTSIZE	32768
typedef struct {
	qboolean initialized;

	char text[CON_TEXTSIZE];
	int current;				/**< line where next message will be printed */
	int x;						/**< offset in current line for next print */
	int display;				/**< bottom of console displays this line */

	int linewidth;				/**< characters across screen */
	int totallines;				/**< total lines in console scrollback */

	float cursorspeed;

	int vislines;

	float times[NUM_CON_TIMES];	/**< cls.realtime time the line was generated
								* for transparent notify lines */
} console_t;

extern console_t con;

void Con_DrawCharacter(int cx, int line, int num);

void Con_CheckResize(void);
void Con_Init(void);
void Con_DrawConsole(float frac);
void Con_Print(const char *txt);
void Con_DrawNotify(void);
void Con_ClearNotify(void);
void Con_ToggleConsole_f(void);
void Con_Close(void);

void Con_SaveConsoleHistory(const char* path);
void Con_LoadConsoleHistory(const char* path);

#endif /* CLIENT_CL_CONSOLE_H */
