/*
 * ufdblocks.h - URLfilterDB
 *
 * ufdbGuard is copyrighted (C) 2005-2020 by URLfilterDB with all rights reserved.
 *
 * Parts of ufdbGuard are based on squidGuard.
 * This module is NOT based on squidGuard.
 *
 * RCS $Id: ufdblocks.h,v 1.5 2020/07/12 07:49:44 root Exp root $
 */

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

#if UFDB_PTHREAD_SUPPORT + UFDB_DPDK_SUPPORT + UFDB_SPINLOCK_SUPPORT + UFDB_CVMX_SPINLOCK_SUPPORT + UFDB_FUTEX_SUPPORT != 1
#error "exactly one of UFDB_PTHREAD_SUPPORT, UFDB_DPDK_SUPPORT, UFDB_SPINLOCK_SUPPORT, UFDB_CVMX_SPINLOCK_SUPPORT or UFDB_FUTEX_SUPPORT must be defined"
#endif


#if UFDB_PTHREAD_SUPPORT
#include <pthread.h>
typedef pthread_mutex_t ufdb_mutex;
#define ufdb_mutex_initializer PTHREAD_MUTEX_INITIALIZER
#endif


#if UFDB_DPDK_SUPPORT
#include "rte_spinlock.h"
typedef rte_spinlock_t ufdb_mutex;
#define ufdb_mutex_initializer RTE_SPINLOCK_INITIALIZER
#endif


#if UFDB_SPINLOCK_SUPPORT
typedef uint32_t ufdb_mutex;
#define ufdb_mutex_initializer 0
#endif


#if UFDB_CVMX_SPINLOCK_SUPPORT
#include <cvmx.h>
#include <cvmx-spinlock.h>
typedef cvmx_spinlock_t ufdb_mutex;
#define ufdb_mutex_initializer CVMX_SPINLOCK_UNLOCKED_INITIALIZER
#endif


#if UFDB_FUTEX_SUPPORT
#include <linux/futex.h>

typedef uint32_t ufdb_mutex;
#define ufdb_mutex_initializer 0
#endif


// If successful, the ufdb_mutex_lock(), ufdb_mutex_trylock(), and  ufdb_mutex_unlock() functions
// shall return zero; otherwise, an error number shall be returned to indicate the error.
// EBUSY  The mutex could not be acquired because it was already locked.
// ENOSYS Not implemented (futex)

void ufdb_mutex_init( ufdb_mutex * m );

int  ufdb_mutex_lock( ufdb_mutex * m );

int  ufdb_mutex_trylock( ufdb_mutex * m );

int  ufdb_mutex_unlock( ufdb_mutex * m );


#ifdef __cplusplus
}
#endif
