/*
 * ufdbdb.h - URLfilterDB
 *
 * ufdbGuard is copyrighted (C) 2005-2021 by URLfilterDB B.V. and others with all rights reserved.
 *
 * RCS $Id: ufdbdb.h,v 1.11 2021/08/27 12:15:50 root Exp root $
 */

#ifndef UFDB_UFDBDB_H_INCLUDED
#define UFDB_UFDBDB_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

#include "ufdb.h"
#include "ufdb_globals.h"

#include <time.h>
#include <stdio.h>
#include <sys/times.h>

#if UFDB_DBFORMAT_3
#include "ufdbdb3.h"
#endif

UFDBrevURL * UFDBgenRevURL( UFDBthreadAdmin * admin, unsigned char * URL );
UFDBrevURL * UFDBgenRevURL4table( UFDBthreadAdmin * admin, unsigned char * URL );

void         UFDBprintRevURL( UFDBrevURL * revURL );
void         UFDBfreeRevURL( UFDBthreadAdmin * admin, UFDBrevURL * revURL );

int  UFDBparseTableHeader( struct UFDBmemTable * memTable );
void UFDBparseTable( struct UFDBmemTable * memTable );
void UFDBfreeTableIndex_1_2( struct UFDBtable * t );

int  UFDBlookup( UFDBthreadAdmin * admin, struct UFDBmemTable * mt, char * request );
int  UFDBlookupRevUrl( struct UFDBtable * t, UFDBrevURL * revUrl );

int  UFDBloadDatabase( struct ufdbGV * gv, struct UFDBmemTable * mtable, char * file );

const char * ufdbCategoryName( const char * domain );

#ifdef __cplusplus
}
#endif

#endif

