/*
 * ufdb_globals.h - URLfilterDB
 *
 * ufdbGuard is copyrighted (C) 2005-2022 by URLfilterDB with all rights reserved.
 *
 * RCS $Id: ufdb_globals.h,v 1.15 2022/12/26 23:20:56 root Exp root $
 */

#ifndef UFDB_UFDB_GLOBALS_H_INCLUDED
#define UFDB_UFDB_GLOBALS_H_INCLUDED

#include "ufdb.h"

#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <time.h>
#include <sys/times.h>
#include <sys/time.h>


#ifdef __cplusplus
"C" {
#endif

#define UFDB_OPTION_OFF          0
#define UFDB_OPTION_ON           1
#define UFDB_OPTION_SYSLOG_FATAL 2

struct ufdbGV
{
   volatile int    status;
   volatile int    databaseStatus;
   volatile int    terminating;
   volatile int    reconfig;
	    int    nWorkers;
	    int    debug;
	    int    debugCoreDump;
	    int    crashOnFatal;
            int    useSyslog;
	    int    logAllRequests;
	    int    logPass;
	    int    logBlock;
            int    fastRefresh;
	    int    safeSearch;
	    int    skipSafeCategory;
	    int    peek;
	    int    stripDomainFromUsername;
	    int    debugRedirect;
	    int    uploadStats;
	    int    YoutubeEdufilter;
	    int    allowGoogleHTTPSusingIP;
	    int    fatalError;
            int    memoryAllocationErrors;

	    time_t databaseLoadTime;
	    time_t databaseCreationTime;
	    char   dateOfCheckedDB[32];
	    char   licenseStatus[512];
	    char   redirectHttps[1024];
	    char   redirectBumpedHttps[1024];
            char   peekServerName[128];

      const char * configFile;
	    int    debugSkype;
	    int    debugGtalk;
	    int    debugYahooMsg;
	    int    debugAim;
	    int    debugFBchat;
	    int    debugCitrixOnline;
	    int    AnydeskOverHttps;
	    int    TeamviewerOverHttps;
	    int    debugHttpd;
	    int    debugRegexp;
	    int    silentLogMessage;
	    int    expressionOptimisation;
	    int    refreshUserlistInterval;
	    int    refreshIPlistInterval;
            time_t lastIPcounterResetDate;
	    int    refreshDomainlistInterval;
	    int    debugExternalScripts;
	    char   userName[31+1];
	    char * pidFilename;
	    char * emailServer;
	    char * myHostname;
	    char * adminEmail;
	    char * senderEmail;
	    char * externalStatusCommand;
	    char * YoutubeEdufilterID;
	    int    URLlookupDelayDBreload;
	    int    URLlookupResultDBreload;
	    int    URLlookupResultFatalError;
	    int    analyseUncategorisedURLs;
	    int    logUncategorisedURLs;
	    int    portNum;
	    int    showURLdetails;
	    int    logURLdetails;
	    int    uploadCrashReports;
            int    madviseHugePages;
	    int    lookupReverseIP;
	    int    useAlsoIPv6onWan;
	    int    tunnelCheckMethod;
	    char * SquidVersion;
	    int    SquidHelperProtocol;
	    int    SquidUsesActiveBumping;
	    int    parseURLparameters;
	    int    httpsWithHostname;
	    int    httpsOfficialCertificate;
	    int    httpsEnforceContentPeek;
	    int    SkypeOverHttps;
	    int    GtalkOverHttps;
	    int    YahooMsgOverHttps;
	    int    AimOverHttps;
	    int    FBchatOverHttps;
	    int    CitrixOnlineOverHttps;
	    int    unknownProtocolOverHttps;
	    int    httpsNoSSLv2;
	    int    httpsNoSSLv3;
	    int    httpsNoTLSv1_0;
	    int    httpdPort;
            char   logDirectory[256];
            char   databaseDirectory[256];
            char   uploadFileDirectory[256];
            char   administrator[256];
	    char   httpdInterface[256];
	    char   httpdImagesDirectory[256];
	    char   interface[256];
	    char   CAcertsFile[1024];
	    char   CAcertsDir[1024];
	    char   fatalErrorRedirect[1024];
	    char   loadingDatabaseRedirect[1024];

	    struct UFDBmemTable checkedDB;
	    struct ufdbRegExp * checkedExpressions;

	    unsigned long maxLogfiles;
	    off_t         maxLogfileSize;
   volatile unsigned long tunnelCounter;
   volatile long          serialno;
            long          upload_seq_no;
	    unsigned long nfree;
	    unsigned long nmalloc;
	    unsigned long nrealloc;

	    struct Source * lastSource;
            struct Source * sourceList;

	    struct Category * lastCat;
	    struct Category * catList;

	    struct sgRewrite *   lastRewrite;
	    struct sgRewrite *   rewrite;
	    struct ufdbRegExp *  lastRewriteRegExec;
	    struct ufdbRegExp * lastRegExpDest;

	    struct ufdbTime * lastTime;
	    struct ufdbTime * timeList;

	    struct TimeElement * lastTimeElement;
	    struct TimeElement * timeElement;

	    struct Acl * lastAcl;
	    struct Acl * defaultAcl;
	    struct AclCategory * lastAclCategory;
	    struct Acl * aclList;

            UFDB_GCC_ALIGN_CL
            struct timeval tod;
	    char    progname[80];
	    char ** Argv;
	    char ** Envp;
	    int     debugTimeDelta;                     // no longer used
	    pid_t   pid;
	    int     failsafe_mode;                      // no longer used
	    int     sig_hup;
	    int     sig_other;
	    int     httpsConnectionCacheSize;
            int     configLogged;

   volatile long    numLookupsInProgress;               // hot

            char    unixSocketName[256];

#define UDFB_API_MAX_CATEGORIES 256
            int            ufdb_presence;               // -1 or index in dbcats[]
            int            num_dbcats;
            UFDBcategory   dbcats[UDFB_API_MAX_CATEGORIES];
};

#if !UFDB_GEN_API
UFDB_SHARED extern struct ufdbGV ufdbNewGV;
UFDB_SHARED extern struct ufdbGV ufdbOldGV;
#endif
UFDB_SHARED extern struct ufdbGV ufdbGV;    // almost all global variables are in the struct 'ufdbGV'

UFDB_SHARED extern FILE * ufdbGlobalLogfile;

void UFDBinitializeGV( struct ufdbGV * gv );
void UFDBresetGV( struct ufdbGV * gv );
void UFDBresetGVcounters( struct ufdbGV * gv );

void UFDBfreeGV( struct ufdbGV * gv );

void UFDBcopyGV( struct ufdbGV * newgv, struct ufdbGV * oldgv );

void ufdbFreeLastBits( struct ufdbGV * gv );
void ufdbFreeAllMemory( struct ufdbGV * gv );

#ifdef __cplusplus
}
#endif

#endif

