/*
 * ufdb-api-private.h - URLfilterDB
 *
 * ufdbGuard API is copyrighted (C) 2007-2022 by URLfilterDB with all rights reserved.
 *
 * ufdbGuard API is used to integrate the functionality of ufdbGuard into
 * programs of 3rd parties.
 *
 * RCS $Id: ufdb-api-private.h,v 1.12 2022/12/26 23:13:04 root Exp root $
 */

#ifndef UFDB_UFDBAPI_PRIVATE_H_INCLUDED
#define UFDB_UFDBAPI_PRIVATE_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

#include "ufdb.h"

#include <sys/time.h>

UFDB_SHARED extern volatile unsigned long UFDB_API_num_threads;             // cold
UFDB_SHARED extern volatile unsigned long UFDB_API_num_views;               // cold
UFDB_SHARED extern volatile unsigned long UFDB_API_num_nxdomain;            // cold
UFDB_SHARED extern volatile unsigned long UFDB_API_num_errors;              // medium
UFDB_SHARED extern volatile unsigned long UFDB_API_upload_seqno;            // cold
UFDB_SHARED extern volatile unsigned long UFDB_API_num_bumps;               // cold
UFDB_SHARED extern volatile unsigned long UFDB_API_num_safesearch;          // probably cold to low hot

UFDB_SHARED extern volatile unsigned long UFDB_API_num_url_lookups;         // hot
UFDB_SHARED extern volatile unsigned long UFDB_API_num_url_matches;         // hot
UFDB_SHARED extern volatile unsigned long UFDB_API_num_https;               // medium hot

UFDB_SHARED extern volatile unsigned long UFDB_API_num_url_localnet;        // medium hot
UFDB_SHARED extern volatile unsigned long UFDB_API_num_regexp_matches;      // medium hot
UFDB_SHARED extern volatile unsigned long UFDB_API_num_uncategorised_URL;   // medium hot
UFDB_SHARED extern volatile unsigned long UFDB_API_num_nodot_URL;           // probably cold

UFDB_SHARED extern volatile unsigned long UFDB_API_num_protocol_matches;    // probably cold

UFDB_SHARED extern struct timeval UFDBcurrentTime;

// UFDB_SHARED extern double UFDBmaxTPS;
// UFDB_SHARED extern struct timeval UFDBmaxTPStime;


void UFDBresetTPScounters( void );

int UFDBnumRegCats( void );


#ifdef __cplusplus
}
#endif

#endif

