/*
Copyright (C) 2003, Nik Reiman - nik@aboleo.net

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/****
  This file contains code used by the search engine in the UBS, which is not altogether functional.  The search engine is intended to be used by the UBS frontend to find filenames based on a search query, which would be useful for song requests and such.  It is important to note that the UBS can only search music that is normally visible and able to be played during regular shows.  It reads the schedule of shows to determine where to look for music, so any shows in there will have their directories searched.
****/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "ubs-sched.h"
#include "ubs-main.h"

/*+
  Rereads all the songs for every known show, and adds them into a big file which is read by the search engine.

  int recache Returns OK on success, NO_FILE if the tmpcache file can't be created, NO_FILE if the searchcache file can't be created
+*/
int recache(void) {
 FILE *fp, *fp_new;
 char buf[BIGBUF];
 struct media_tag song_tag;
 int i;

 // clear out the cache
 if((fp = fopen("tmp/tmpcache.dat", "w")) == NULL) {
  log_error_msg(LOG_ERROR, "Unable to open cache");
  return NO_FILE;
 }

 for(i = 0; i < atoi(ubs_table_data(&SCHED, "numshows")); i++) {
  log_error_msg(LOG_DEBUG, "Parsing top level directory '%s'", ALLSHOWS[i].dir);
  parse_dir(fp, ALLSHOWS[i].dir);
 }
 log_error_msg(LOG_DEBUG, "Parsing misc directory");
 parse_dir(fp, ubs_table_data(&SCHED, "miscdir"));

 fclose(fp);

 // reopen for reading
 if((fp = fopen("tmp/tmpcache.dat", "r")) == NULL) {
  log_error_msg(LOG_ERROR, "Unable to open tmpcache for reading");
  return NO_FILE;
 }

 // clear out the current cache
 if((fp_new = fopen("tmp/searchcache.dat", "w")) == NULL) {
  log_error_msg(LOG_ERROR, "Unable to open searchcache for writing");
  return NO_FILE;
 }
 fclose(fp_new);

 while(fgets(buf, BIGBUF, fp)) {
  chomp_line(buf);
  get_media_tag(buf, &song_tag);
  log_event("tmp/searchcache.dat", buf, song_tag.artist, song_tag.title, LOG_EMERG);
 }
 
 fclose(fp);
 return OK;
}
