/*
Copyright (C) 2003, Nik Reiman - nik@aboleo.net

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/****
  Displays information about the queue, and provides a few basic control operations, such as clearing, appending, and prepending files to the queue.
****/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <dirent.h>
#include <sys/types.h>
#include <errno.h>

#include "ubs-main.h"

/*+
  Displays information about the queue

  int cmd_queue Returns OK on success

  int cmdc Number of arguments

  char **cmdv Argument vector
+*/
int cmd_queue(int cmdc, char **cmdv) {
 int ch, format = ENGLISH;

 while((ch = getopt(cmdc, cmdv, "hwcesdza:p:")) != -1) {
  switch(ch) {
   case 'e':
    format = ENGLISH;
    break;
   case 'c':
    format = CSV;
    break;
   case 'w':
    format = HTML;
    break;
   case 's':
    format = SILENT;
    break;
   case 'd':
    return show_queue(format);
    break;
   case 'a':
    return queue_push(optarg);
    break;
   case 'p':
    return queue_prepush(optarg);
    break;
   case 'z':
    queue_init();
    return OK;
    break;
   case 'h':
    sub_help_cmd("queue");
    return OK;
    break;
   default:
    sub_help_cmd("queue");
    return OK;
    break;
  }
 }

 cmdc -= optind;
 cmdv += optind;

 // display the queue by default
 if(cmdc == 0) {
  return show_queue(format);
 }

 return OK;
}
