/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

#include "SDL.h"

extern SDL_Window *sdl_window;
extern SDL_PixelFormat *sdl_desktop_format;

typedef struct {
    typeof(SDL_PIXELFORMAT_UNKNOWN) format;
} qvidformat_t;

/*
 * Independent subsystems can call this to ensure the main SDL_Init()
 * has been called at least once before they init their subsystem
 * via SDL_InitSubSystem(SDL_INIT_FOO)
 */
void Q_SDL_InitOnce();

void VID_SDL_SetIcon();
void VID_SDL_InitModeList();
void IN_SDL_HandleEvent(SDL_Event *event);
