/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{LitElement as v,html as c,nothing as h}from"lit";import{repeat as m}from"lit/directives/repeat.js";import{classMap as f}from"lit/directives/class-map.js";import{live as u}from"lit/directives/live.js";import{property as s,state as g,customElement as y}from"lit/decorators.js";import"@typo3/backend/element/icon-element.js";var r=function(p,e,t,a){var i=arguments.length,l=i<3?e:a===null?a=Object.getOwnPropertyDescriptor(e,t):a,o;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")l=Reflect.decorate(p,e,t,a);else for(var d=p.length-1;d>=0;d--)(o=p[d])&&(l=(i<3?o(l):i>3?o(e,t,l):o(e,t))||l);return i>3&&l&&Object.defineProperty(e,t,l),l};class b extends Event{static{this.eventName="typo3:backend:form-editor:component:property-grid-editor:update"}constructor(e){super(b.eventName),this.data=e}}let n=class extends v{constructor(){super(...arguments),this.entries=[],this.labelLabel="Label",this.labelValue="Value",this.labelSelected="Selected",this.labelAdd="Add",this.labelRemove="Remove",this.labelMove="Move",this.enableAddRow=!1,this.enableDeleteRow=!1,this.enableSelection=!0,this.enableMultiSelection=!1,this.enableSorting=!1,this.enableLabelAsFallbackValue=!1,this.draggedEntry=null,this.movedEntry=null,this.activeElementRef=null}createRenderRoot(){return this}updated(e){if(this.activeElementRef&&(this.activeElementRef.focus(),this.activeElementRef=null),e.has("entries")){const t=e.get("entries");t!==void 0&&JSON.stringify(t)!==JSON.stringify(this.entries)&&this.dispatchEvent(new b(this.entries))}}render(){return c`<div class=property-grid-editor>${this.entries?.length?c`<div class=property-grid-editor__entries>${m(this.entries,e=>e.id,e=>this.renderEntry(e))}</div>`:h} ${this.enableAddRow?c`<div class=property-grid-editor__actions><button class="btn btn-sm btn-default" title=${this.labelAdd} @click=${this.handleCreate}><typo3-backend-icon identifier=actions-plus size=small></typo3-backend-icon><span class=btn-label>${this.labelAdd}</span></button></div>`:h}</div>`}renderEntry(e){return c`<div class=${f({"property-grid-editor__entry":!0,moving:this.movedEntry===e,dragging:this.draggedEntry===e})} @dragover=${t=>this.handleDragOver(t)} @dragenter=${t=>this.handleDragEnter(t,e)} @drop=${t=>this.handleDrop(t)} @dragend=${t=>this.handleDragEnd(t)}><div class=property-grid-editor__entry-inputs><div class=form-group><label for=${e.id}-label class=form-label>${this.labelLabel}</label> <input id=${e.id}-label class="form-control form-control-sm" type=text @change=${t=>this.handleChange(t,"label",e)} @keyup=${t=>this.handleChange(t,"label",e)} @focusout=${t=>this.handleFocusOut(t,e)} .value=${u(e.label)}></div><div class=form-group><label for=${e.id}-value class=form-label>${this.labelValue}</label> <input id=${e.id}-value class="form-control form-control-sm" type=text @change=${t=>this.handleChange(t,"value",e)} @keyup=${t=>this.handleChange(t,"value",e)} .value=${u(e.value)}></div>${this.enableSelection||this.enableMultiSelection?c`<div class=form-check><input id=${e.id}-selected class=form-check-input type=checkbox @change=${t=>this.handleChange(t,"selected",e)} .checked=${u(e.selected)}> <label for=${e.id}-selected class=form-check-label>${this.labelSelected}</label></div>`:h}</div>${this.enableSorting||this.enableDeleteRow?c`<div class=property-grid-editor__entry-buttons>${this.enableSorting?c`<button class="btn btn-sm btn-default" title=${this.labelMove} draggable=true @click=${t=>this.handleMoveClick(t,e)} @keydown=${this.handleMoveKeyDown} @dragstart=${t=>this.handleDragStart(t,e)}><typo3-backend-icon identifier=${this.movedEntry===e?"actions-thumbtack":"actions-move-move"} size=small></typo3-backend-icon></button>`:h} ${this.enableDeleteRow?c`<button class="btn btn-sm btn-default" title=${this.labelRemove} @click=${()=>this.handleRemove(e)}><typo3-backend-icon identifier=actions-delete size=small></typo3-backend-icon></button>`:h}</div>`:h}</div>`}handleFocusOut(e,t){this.enableLabelAsFallbackValue&&t.value===""&&this.setEntryProperty(t,"value",t.label)}handleChange(e,t,a){const i=e.target,l=i.type==="checkbox"?i.checked:i.value;this.setEntryProperty(a,t,l)}handleRemove(e){this.entries=this.entries.filter(t=>t!==e)}handleCreate(){const e={id:"fe"+Math.floor(Math.random()*42)+Date.now(),label:"",value:"",selected:!1};this.entries=[...this.entries,e]}handleDragStart(e,t){e.stopImmediatePropagation(),this.draggedEntry=t,e.dataTransfer?.setData("text/plain","dragging"),e.dataTransfer?.setDragImage(new Image,0,0)}handleDragOver(e){e.preventDefault(),e.stopImmediatePropagation()}handleDragEnter(e,t){if(e.preventDefault(),e.stopImmediatePropagation(),!this.draggedEntry||this.draggedEntry===t)return;const a=[...this.entries],i=a.indexOf(this.draggedEntry),l=a.indexOf(t);a.splice(i,1);const o=(i<l,l);a.splice(o,0,this.draggedEntry),this.entries=a}handleDrop(e){e.preventDefault(),e.stopImmediatePropagation(),this.draggedEntry=null}handleDragEnd(e){e.stopImmediatePropagation(),this.draggedEntry=null}handleMoveClick(e,t){this.movedEntry===t?this.movedEntry=null:this.movedEntry=t}handleMoveKeyDown(e){if(this.movedEntry===null||!["ArrowDown","ArrowUp","Home","End","Enter","Space","Escape","Tab"].includes(e.code)||e.altKey||e.ctrlKey)return;e.preventDefault();let a;switch(e.code){case"Escape":case"Enter":case"Space":this.movedEntry=null;return;case"ArrowUp":a=-1;break;case"ArrowDown":a=1;break;default:return}const i=[...this.entries],l=i.indexOf(this.movedEntry),o=l+a;if(console.log(l,o),o<0||o>=i.length)return;i.splice(l,1);const d=(l<o,o);i.splice(d,0,this.movedEntry),this.entries=i,this.activeElementRef=e.target.closest("button")}setEntryProperty(e,t,a){const i=this.entries.indexOf(e);if(i===-1)return;const l={...e};if(t==="label"&&(l.label=String(a)),t==="value"&&(l.value=String(a)),t==="selected"&&(l.selected=!!a,l.selected===!0&&!this.enableMultiSelection)){this.entries=this.entries.map((o,d)=>d===i?l:{...o,selected:!1});return}this.entries=this.entries.map((o,d)=>d===i?l:o)}};r([s({type:Array,attribute:"entries"})],n.prototype,"entries",void 0),r([s({type:String,attribute:"label-label"})],n.prototype,"labelLabel",void 0),r([s({type:String,attribute:"label-value"})],n.prototype,"labelValue",void 0),r([s({type:String,attribute:"label-selected"})],n.prototype,"labelSelected",void 0),r([s({type:String,attribute:"label-add"})],n.prototype,"labelAdd",void 0),r([s({type:String,attribute:"label-remove"})],n.prototype,"labelRemove",void 0),r([s({type:String,attribute:"label-move"})],n.prototype,"labelMove",void 0),r([s({type:Boolean})],n.prototype,"enableAddRow",void 0),r([s({type:Boolean})],n.prototype,"enableDeleteRow",void 0),r([s({type:Boolean})],n.prototype,"enableSelection",void 0),r([s({type:Boolean})],n.prototype,"enableMultiSelection",void 0),r([s({type:Boolean})],n.prototype,"enableSorting",void 0),r([s({type:Boolean})],n.prototype,"enableLabelAsFallbackValue",void 0),r([g()],n.prototype,"draggedEntry",void 0),r([g()],n.prototype,"movedEntry",void 0),n=r([y("typo3-form-property-grid-editor")],n);export{n as PropertyGridEditor,b as PropertyGridEditorUpdateEvent};
