/*
  game.h

  For TuxMath
  The main game loop!

  by Bill Kendrick
  bill@newbreedsoftware.com
  http://www.newbreedsoftware.com/


  Part of "Tux4Kids" Project
  http://www.tux4kids.org/
      
  August 26, 2001 - August 31, 2001
*/


#ifndef GAME_H
#define GAME_H

#define MAX_COMETS 10
#define NUM_CITIES 4   /* MUST BE AN EVEN NUMBER! */

#define NUM_BKGDS 5

#define MAX_CITY_COLORS 4

typedef struct comet_type {
  int alive;
  int expl;
  int city;
  int x, y;
  int eq1, oper, eq2;
  int answer;
} comet_type;

typedef struct city_type {
  int alive, expl, shields;
  int x;
} city_type;

typedef struct laser_type {
  int alive;
  int x1, y1;
  int x2, y2;
} laser_type;

enum {
  OPER_ADD,
  OPER_SUB,
  OPER_MULT,
  OPER_DIV,
  NUM_OPERS
};

static char operchars[NUM_OPERS] = {
  "+-*/"
};

static char * oper_opts[NUM_OPERS] = {
  "add", "subtract", "multiply", "divide"
};

int game(void);

#endif
