#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 537
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 132
#define ALIAS_COUNT 3
#define TOKEN_COUNT 70
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 7
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 14

enum {
  anon_sym_DQUOTE = 1,
  aux_sym_string_token1 = 2,
  anon_sym_PERCENT_LPAREN = 3,
  anon_sym_RPAREN = 4,
  aux_sym_raw_string_token1 = 5,
  aux_sym_raw_string_token2 = 6,
  aux_sym_comment_token1 = 7,
  anon_sym_SLASH_STAR = 8,
  anon_sym_STAR_SLASH = 9,
  sym_static_field = 10,
  sym_field = 11,
  sym_name = 12,
  sym_null = 13,
  aux_sym_number_token1 = 14,
  aux_sym_number_token2 = 15,
  aux_sym_number_token3 = 16,
  aux_sym_number_token4 = 17,
  anon_sym_true = 18,
  anon_sym_false = 19,
  anon_sym_return = 20,
  anon_sym_EQ = 21,
  anon_sym_BANG = 22,
  anon_sym_DASH = 23,
  anon_sym_TILDE = 24,
  anon_sym_PLUS = 25,
  anon_sym_EQ_EQ = 26,
  anon_sym_BANG_EQ = 27,
  anon_sym_LT_EQ = 28,
  anon_sym_GT_EQ = 29,
  anon_sym_AMP_AMP = 30,
  anon_sym_PIPE_PIPE = 31,
  anon_sym_SLASH = 32,
  anon_sym_STAR = 33,
  anon_sym_PERCENT = 34,
  anon_sym_GT_GT = 35,
  anon_sym_LT_LT = 36,
  anon_sym_AMP = 37,
  anon_sym_LT = 38,
  anon_sym_GT = 39,
  anon_sym_is = 40,
  anon_sym_LBRACE = 41,
  anon_sym_RBRACE = 42,
  anon_sym_COMMA = 43,
  anon_sym_var = 44,
  anon_sym_LPAREN = 45,
  anon_sym_PIPE = 46,
  anon_sym_class = 47,
  aux_sym_prefix_operator_definition_token1 = 48,
  anon_sym_LBRACK = 49,
  anon_sym_RBRACK = 50,
  anon_sym_construct = 51,
  anon_sym_static = 52,
  anon_sym_QMARK = 53,
  anon_sym_COLON = 54,
  anon_sym_DOT = 55,
  anon_sym_DOT_DOT = 56,
  anon_sym_DOT_DOT_DOT = 57,
  anon_sym_if = 58,
  anon_sym_else = 59,
  anon_sym_for = 60,
  anon_sym_in = 61,
  anon_sym_while = 62,
  sym_break_statement = 63,
  sym_continue_statement = 64,
  anon_sym_POUND = 65,
  anon_sym_POUND_BANG = 66,
  anon_sym_as = 67,
  sym_shebang = 68,
  anon_sym_import = 69,
  sym_source_file = 70,
  sym_string = 71,
  sym_raw_string = 72,
  sym_comment = 73,
  sym_number = 74,
  sym_boolean = 75,
  sym_return_statement = 76,
  sym_assignment = 77,
  sym_unary_expression = 78,
  sym_binary_expression = 79,
  sym_block = 80,
  sym_parameter = 81,
  sym_parameter_list = 82,
  sym_argument_list = 83,
  sym_variable_definition = 84,
  sym_call_expression = 85,
  sym_call_body = 86,
  sym_class_definition = 87,
  sym_class_body = 88,
  sym_getter_definition = 89,
  sym_setter_definition = 90,
  sym_prefix_operator_definition = 91,
  sym_subscript_operator_definition = 92,
  sym_subscript_setter_definition = 93,
  sym_infix_operator_definition = 94,
  sym_method_definition = 95,
  sym_constructor = 96,
  sym_static_method_definition = 97,
  sym_static_getter_definition = 98,
  sym_conditional = 99,
  sym_list = 100,
  sym_index_expression = 101,
  sym_subscript = 102,
  sym_range = 103,
  sym_if_statement = 104,
  sym_for_statement = 105,
  sym_while_statement = 106,
  sym_pair = 107,
  sym_map = 108,
  sym__any_attribute = 109,
  sym_attribute = 110,
  sym_runtime_attribute = 111,
  sym_attribute_value = 112,
  sym_rename = 113,
  sym__import_entry = 114,
  sym_import_statement = 115,
  sym__statement = 116,
  sym__expression = 117,
  aux_sym_source_file_repeat1 = 118,
  aux_sym_string_repeat1 = 119,
  aux_sym_string_repeat2 = 120,
  aux_sym_raw_string_repeat1 = 121,
  aux_sym_comment_repeat1 = 122,
  aux_sym_parameter_list_repeat1 = 123,
  aux_sym_argument_list_repeat1 = 124,
  aux_sym_class_definition_repeat1 = 125,
  aux_sym_class_body_repeat1 = 126,
  aux_sym_class_body_repeat2 = 127,
  aux_sym_map_repeat1 = 128,
  aux_sym_attribute_repeat1 = 129,
  aux_sym_runtime_attribute_repeat1 = 130,
  aux_sym_import_statement_repeat1 = 131,
  alias_sym_else_branch = 132,
  anon_alias_sym_getter = 133,
  anon_alias_sym_parameter = 134,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_PERCENT_LPAREN] = "%(",
  [anon_sym_RPAREN] = ")",
  [aux_sym_raw_string_token1] = "raw_string_token1",
  [aux_sym_raw_string_token2] = "raw_string_token2",
  [aux_sym_comment_token1] = "comment_token1",
  [anon_sym_SLASH_STAR] = "/*",
  [anon_sym_STAR_SLASH] = "*/",
  [sym_static_field] = "static_field",
  [sym_field] = "field",
  [sym_name] = "name",
  [sym_null] = "null",
  [aux_sym_number_token1] = "number_token1",
  [aux_sym_number_token2] = "number_token2",
  [aux_sym_number_token3] = "number_token3",
  [aux_sym_number_token4] = "number_token4",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_return] = "return",
  [anon_sym_EQ] = "=",
  [anon_sym_BANG] = "operator",
  [anon_sym_DASH] = "operator",
  [anon_sym_TILDE] = "operator",
  [anon_sym_PLUS] = "operator",
  [anon_sym_EQ_EQ] = "operator",
  [anon_sym_BANG_EQ] = "operator",
  [anon_sym_LT_EQ] = "operator",
  [anon_sym_GT_EQ] = "operator",
  [anon_sym_AMP_AMP] = "operator",
  [anon_sym_PIPE_PIPE] = "operator",
  [anon_sym_SLASH] = "operator",
  [anon_sym_STAR] = "operator",
  [anon_sym_PERCENT] = "operator",
  [anon_sym_GT_GT] = "operator",
  [anon_sym_LT_LT] = "operator",
  [anon_sym_AMP] = "operator",
  [anon_sym_LT] = "operator",
  [anon_sym_GT] = "operator",
  [anon_sym_is] = "is",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_COMMA] = ",",
  [anon_sym_var] = "var",
  [anon_sym_LPAREN] = "(",
  [anon_sym_PIPE] = "|",
  [anon_sym_class] = "class",
  [aux_sym_prefix_operator_definition_token1] = "operator",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_construct] = "construct",
  [anon_sym_static] = "static",
  [anon_sym_QMARK] = "\?",
  [anon_sym_COLON] = ":",
  [anon_sym_DOT] = ".",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [anon_sym_POUND] = "#",
  [anon_sym_POUND_BANG] = "#!",
  [anon_sym_as] = "as",
  [sym_shebang] = "shebang",
  [anon_sym_import] = "import",
  [sym_source_file] = "source_file",
  [sym_string] = "string",
  [sym_raw_string] = "raw_string",
  [sym_comment] = "comment",
  [sym_number] = "number",
  [sym_boolean] = "boolean",
  [sym_return_statement] = "return_statement",
  [sym_assignment] = "assignment",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_block] = "block",
  [sym_parameter] = "parameter",
  [sym_parameter_list] = "parameter_list",
  [sym_argument_list] = "parameter_list",
  [sym_variable_definition] = "variable_definition",
  [sym_call_expression] = "call_expression",
  [sym_call_body] = "call_body",
  [sym_class_definition] = "class_definition",
  [sym_class_body] = "class_body",
  [sym_getter_definition] = "getter_definition",
  [sym_setter_definition] = "setter_definition",
  [sym_prefix_operator_definition] = "prefix_operator_definition",
  [sym_subscript_operator_definition] = "subscript_operator_definition",
  [sym_subscript_setter_definition] = "subscript_setter_definition",
  [sym_infix_operator_definition] = "infix_operator_definition",
  [sym_method_definition] = "method_definition",
  [sym_constructor] = "constructor",
  [sym_static_method_definition] = "static_method_definition",
  [sym_static_getter_definition] = "static_getter_definition",
  [sym_conditional] = "conditional",
  [sym_list] = "list",
  [sym_index_expression] = "index_expression",
  [sym_subscript] = "subscript",
  [sym_range] = "range",
  [sym_if_statement] = "if_statement",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_pair] = "pair",
  [sym_map] = "map",
  [sym__any_attribute] = "_any_attribute",
  [sym_attribute] = "attribute",
  [sym_runtime_attribute] = "runtime_attribute",
  [sym_attribute_value] = "attribute_value",
  [sym_rename] = "rename",
  [sym__import_entry] = "_import_entry",
  [sym_import_statement] = "import_statement",
  [sym__statement] = "_statement",
  [sym__expression] = "_expression",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_raw_string_repeat1] = "raw_string_repeat1",
  [aux_sym_comment_repeat1] = "comment_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_class_definition_repeat1] = "class_definition_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_class_body_repeat2] = "class_body_repeat2",
  [aux_sym_map_repeat1] = "map_repeat1",
  [aux_sym_attribute_repeat1] = "attribute_repeat1",
  [aux_sym_runtime_attribute_repeat1] = "runtime_attribute_repeat1",
  [aux_sym_import_statement_repeat1] = "import_statement_repeat1",
  [alias_sym_else_branch] = "else_branch",
  [anon_alias_sym_getter] = "getter",
  [anon_alias_sym_parameter] = "parameter",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_PERCENT_LPAREN] = anon_sym_PERCENT_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [aux_sym_raw_string_token1] = aux_sym_raw_string_token1,
  [aux_sym_raw_string_token2] = aux_sym_raw_string_token2,
  [aux_sym_comment_token1] = aux_sym_comment_token1,
  [anon_sym_SLASH_STAR] = anon_sym_SLASH_STAR,
  [anon_sym_STAR_SLASH] = anon_sym_STAR_SLASH,
  [sym_static_field] = sym_static_field,
  [sym_field] = sym_field,
  [sym_name] = sym_name,
  [sym_null] = sym_null,
  [aux_sym_number_token1] = aux_sym_number_token1,
  [aux_sym_number_token2] = aux_sym_number_token2,
  [aux_sym_number_token3] = aux_sym_number_token3,
  [aux_sym_number_token4] = aux_sym_number_token4,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_DASH] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_BANG,
  [anon_sym_PLUS] = anon_sym_BANG,
  [anon_sym_EQ_EQ] = anon_sym_BANG,
  [anon_sym_BANG_EQ] = anon_sym_BANG,
  [anon_sym_LT_EQ] = anon_sym_BANG,
  [anon_sym_GT_EQ] = anon_sym_BANG,
  [anon_sym_AMP_AMP] = anon_sym_BANG,
  [anon_sym_PIPE_PIPE] = anon_sym_BANG,
  [anon_sym_SLASH] = anon_sym_BANG,
  [anon_sym_STAR] = anon_sym_BANG,
  [anon_sym_PERCENT] = anon_sym_BANG,
  [anon_sym_GT_GT] = anon_sym_BANG,
  [anon_sym_LT_LT] = anon_sym_BANG,
  [anon_sym_AMP] = anon_sym_BANG,
  [anon_sym_LT] = anon_sym_BANG,
  [anon_sym_GT] = anon_sym_BANG,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_class] = anon_sym_class,
  [aux_sym_prefix_operator_definition_token1] = anon_sym_BANG,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_construct] = anon_sym_construct,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_POUND_BANG] = anon_sym_POUND_BANG,
  [anon_sym_as] = anon_sym_as,
  [sym_shebang] = sym_shebang,
  [anon_sym_import] = anon_sym_import,
  [sym_source_file] = sym_source_file,
  [sym_string] = sym_string,
  [sym_raw_string] = sym_raw_string,
  [sym_comment] = sym_comment,
  [sym_number] = sym_number,
  [sym_boolean] = sym_boolean,
  [sym_return_statement] = sym_return_statement,
  [sym_assignment] = sym_assignment,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_block] = sym_block,
  [sym_parameter] = sym_parameter,
  [sym_parameter_list] = sym_parameter_list,
  [sym_argument_list] = sym_parameter_list,
  [sym_variable_definition] = sym_variable_definition,
  [sym_call_expression] = sym_call_expression,
  [sym_call_body] = sym_call_body,
  [sym_class_definition] = sym_class_definition,
  [sym_class_body] = sym_class_body,
  [sym_getter_definition] = sym_getter_definition,
  [sym_setter_definition] = sym_setter_definition,
  [sym_prefix_operator_definition] = sym_prefix_operator_definition,
  [sym_subscript_operator_definition] = sym_subscript_operator_definition,
  [sym_subscript_setter_definition] = sym_subscript_setter_definition,
  [sym_infix_operator_definition] = sym_infix_operator_definition,
  [sym_method_definition] = sym_method_definition,
  [sym_constructor] = sym_constructor,
  [sym_static_method_definition] = sym_static_method_definition,
  [sym_static_getter_definition] = sym_static_getter_definition,
  [sym_conditional] = sym_conditional,
  [sym_list] = sym_list,
  [sym_index_expression] = sym_index_expression,
  [sym_subscript] = sym_subscript,
  [sym_range] = sym_range,
  [sym_if_statement] = sym_if_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_pair] = sym_pair,
  [sym_map] = sym_map,
  [sym__any_attribute] = sym__any_attribute,
  [sym_attribute] = sym_attribute,
  [sym_runtime_attribute] = sym_runtime_attribute,
  [sym_attribute_value] = sym_attribute_value,
  [sym_rename] = sym_rename,
  [sym__import_entry] = sym__import_entry,
  [sym_import_statement] = sym_import_statement,
  [sym__statement] = sym__statement,
  [sym__expression] = sym__expression,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_raw_string_repeat1] = aux_sym_raw_string_repeat1,
  [aux_sym_comment_repeat1] = aux_sym_comment_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_class_definition_repeat1] = aux_sym_class_definition_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_class_body_repeat2] = aux_sym_class_body_repeat2,
  [aux_sym_map_repeat1] = aux_sym_map_repeat1,
  [aux_sym_attribute_repeat1] = aux_sym_attribute_repeat1,
  [aux_sym_runtime_attribute_repeat1] = aux_sym_runtime_attribute_repeat1,
  [aux_sym_import_statement_repeat1] = aux_sym_import_statement_repeat1,
  [alias_sym_else_branch] = alias_sym_else_branch,
  [anon_alias_sym_getter] = anon_alias_sym_getter,
  [anon_alias_sym_parameter] = anon_alias_sym_parameter,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_PERCENT_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_raw_string_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_raw_string_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SLASH_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_SLASH] = {
    .visible = true,
    .named = false,
  },
  [sym_static_field] = {
    .visible = true,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym_name] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_number_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_number_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_number_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_number_token4] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_prefix_operator_definition_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_construct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [sym_shebang] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_string] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_body] = {
    .visible = true,
    .named = true,
  },
  [sym_class_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_getter_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_setter_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_prefix_operator_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_operator_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_setter_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_operator_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor] = {
    .visible = true,
    .named = true,
  },
  [sym_static_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_static_getter_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_range] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_map] = {
    .visible = true,
    .named = true,
  },
  [sym__any_attribute] = {
    .visible = false,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_runtime_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [sym_rename] = {
    .visible = true,
    .named = true,
  },
  [sym__import_entry] = {
    .visible = false,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_raw_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_map_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_runtime_attribute_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_else_branch] = {
    .visible = true,
    .named = true,
  },
  [anon_alias_sym_getter] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_parameter] = {
    .visible = true,
    .named = false,
  },
};

enum {
  field_body = 1,
  field_key = 2,
  field_left = 3,
  field_loop_variable = 4,
  field_name = 5,
  field_right = 6,
  field_value = 7,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_body] = "body",
  [field_key] = "key",
  [field_left] = "left",
  [field_loop_variable] = "loop_variable",
  [field_name] = "name",
  [field_right] = "right",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 2},
  [5] = {.index = 5, .length = 1},
  [8] = {.index = 6, .length = 1},
  [10] = {.index = 7, .length = 1},
  [11] = {.index = 8, .length = 1},
  [12] = {.index = 9, .length = 1},
  [13] = {.index = 10, .length = 1},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_left, 0},
    {field_right, 2},
  [2] =
    {field_name, 1},
  [3] =
    {field_key, 0},
    {field_value, 2},
  [5] =
    {field_body, 1},
  [6] =
    {field_body, 3},
  [7] =
    {field_loop_variable, 2},
  [8] =
    {field_body, 4},
  [9] =
    {field_body, 5},
  [10] =
    {field_body, 7},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [2] = {
    [1] = anon_sym_BANG,
  },
  [6] = {
    [0] = anon_alias_sym_parameter,
  },
  [7] = {
    [1] = anon_alias_sym_getter,
  },
  [9] = {
    [6] = alias_sym_else_branch,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_getter_definition, 2,
    sym_getter_definition,
    anon_alias_sym_getter,
  sym__statement, 2,
    sym__statement,
    alias_sym_else_branch,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 3,
  [5] = 2,
  [6] = 3,
  [7] = 2,
  [8] = 8,
  [9] = 2,
  [10] = 3,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 13,
  [15] = 15,
  [16] = 12,
  [17] = 13,
  [18] = 18,
  [19] = 18,
  [20] = 12,
  [21] = 21,
  [22] = 22,
  [23] = 18,
  [24] = 24,
  [25] = 13,
  [26] = 15,
  [27] = 18,
  [28] = 12,
  [29] = 15,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 30,
  [34] = 31,
  [35] = 35,
  [36] = 35,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 43,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 44,
  [50] = 50,
  [51] = 42,
  [52] = 52,
  [53] = 46,
  [54] = 47,
  [55] = 50,
  [56] = 52,
  [57] = 57,
  [58] = 40,
  [59] = 48,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 64,
  [72] = 72,
  [73] = 73,
  [74] = 62,
  [75] = 75,
  [76] = 38,
  [77] = 65,
  [78] = 61,
  [79] = 79,
  [80] = 69,
  [81] = 81,
  [82] = 37,
  [83] = 63,
  [84] = 84,
  [85] = 73,
  [86] = 57,
  [87] = 41,
  [88] = 88,
  [89] = 79,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 70,
  [94] = 66,
  [95] = 95,
  [96] = 88,
  [97] = 66,
  [98] = 84,
  [99] = 99,
  [100] = 90,
  [101] = 72,
  [102] = 95,
  [103] = 99,
  [104] = 75,
  [105] = 81,
  [106] = 106,
  [107] = 67,
  [108] = 39,
  [109] = 60,
  [110] = 68,
  [111] = 92,
  [112] = 66,
  [113] = 50,
  [114] = 52,
  [115] = 43,
  [116] = 116,
  [117] = 42,
  [118] = 47,
  [119] = 46,
  [120] = 84,
  [121] = 57,
  [122] = 72,
  [123] = 90,
  [124] = 81,
  [125] = 40,
  [126] = 95,
  [127] = 39,
  [128] = 99,
  [129] = 69,
  [130] = 37,
  [131] = 41,
  [132] = 75,
  [133] = 88,
  [134] = 62,
  [135] = 67,
  [136] = 38,
  [137] = 61,
  [138] = 64,
  [139] = 79,
  [140] = 63,
  [141] = 73,
  [142] = 70,
  [143] = 65,
  [144] = 40,
  [145] = 41,
  [146] = 38,
  [147] = 37,
  [148] = 39,
  [149] = 50,
  [150] = 43,
  [151] = 52,
  [152] = 47,
  [153] = 46,
  [154] = 42,
  [155] = 95,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 157,
  [161] = 158,
  [162] = 69,
  [163] = 156,
  [164] = 159,
  [165] = 73,
  [166] = 70,
  [167] = 167,
  [168] = 156,
  [169] = 90,
  [170] = 159,
  [171] = 171,
  [172] = 65,
  [173] = 72,
  [174] = 174,
  [175] = 157,
  [176] = 159,
  [177] = 64,
  [178] = 62,
  [179] = 158,
  [180] = 61,
  [181] = 79,
  [182] = 182,
  [183] = 81,
  [184] = 184,
  [185] = 99,
  [186] = 157,
  [187] = 158,
  [188] = 75,
  [189] = 189,
  [190] = 63,
  [191] = 67,
  [192] = 88,
  [193] = 57,
  [194] = 156,
  [195] = 84,
  [196] = 196,
  [197] = 174,
  [198] = 198,
  [199] = 199,
  [200] = 182,
  [201] = 184,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 198,
  [206] = 167,
  [207] = 207,
  [208] = 198,
  [209] = 204,
  [210] = 198,
  [211] = 204,
  [212] = 204,
  [213] = 213,
  [214] = 214,
  [215] = 213,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 202,
  [222] = 203,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 224,
  [229] = 223,
  [230] = 230,
  [231] = 225,
  [232] = 232,
  [233] = 216,
  [234] = 219,
  [235] = 224,
  [236] = 225,
  [237] = 237,
  [238] = 223,
  [239] = 37,
  [240] = 240,
  [241] = 241,
  [242] = 38,
  [243] = 218,
  [244] = 223,
  [245] = 245,
  [246] = 216,
  [247] = 224,
  [248] = 232,
  [249] = 225,
  [250] = 250,
  [251] = 219,
  [252] = 252,
  [253] = 213,
  [254] = 213,
  [255] = 199,
  [256] = 256,
  [257] = 252,
  [258] = 219,
  [259] = 216,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 261,
  [266] = 266,
  [267] = 267,
  [268] = 227,
  [269] = 269,
  [270] = 217,
  [271] = 237,
  [272] = 263,
  [273] = 214,
  [274] = 274,
  [275] = 274,
  [276] = 264,
  [277] = 267,
  [278] = 38,
  [279] = 279,
  [280] = 274,
  [281] = 274,
  [282] = 260,
  [283] = 240,
  [284] = 256,
  [285] = 226,
  [286] = 269,
  [287] = 262,
  [288] = 241,
  [289] = 37,
  [290] = 245,
  [291] = 291,
  [292] = 292,
  [293] = 292,
  [294] = 294,
  [295] = 292,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 294,
  [300] = 300,
  [301] = 294,
  [302] = 292,
  [303] = 294,
  [304] = 304,
  [305] = 298,
  [306] = 300,
  [307] = 297,
  [308] = 296,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 311,
  [313] = 310,
  [314] = 314,
  [315] = 315,
  [316] = 315,
  [317] = 315,
  [318] = 315,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 326,
  [336] = 336,
  [337] = 226,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 37,
  [344] = 38,
  [345] = 345,
  [346] = 39,
  [347] = 40,
  [348] = 41,
  [349] = 320,
  [350] = 350,
  [351] = 340,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 354,
  [359] = 355,
  [360] = 354,
  [361] = 354,
  [362] = 362,
  [363] = 355,
  [364] = 355,
  [365] = 365,
  [366] = 355,
  [367] = 354,
  [368] = 355,
  [369] = 354,
  [370] = 370,
  [371] = 354,
  [372] = 355,
  [373] = 355,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 354,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 384,
  [387] = 342,
  [388] = 388,
  [389] = 389,
  [390] = 382,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 381,
  [395] = 345,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 393,
  [401] = 353,
  [402] = 392,
  [403] = 403,
  [404] = 393,
  [405] = 403,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 407,
  [411] = 382,
  [412] = 412,
  [413] = 413,
  [414] = 384,
  [415] = 415,
  [416] = 409,
  [417] = 389,
  [418] = 418,
  [419] = 353,
  [420] = 420,
  [421] = 421,
  [422] = 407,
  [423] = 423,
  [424] = 407,
  [425] = 384,
  [426] = 403,
  [427] = 427,
  [428] = 382,
  [429] = 429,
  [430] = 430,
  [431] = 341,
  [432] = 403,
  [433] = 433,
  [434] = 434,
  [435] = 434,
  [436] = 393,
  [437] = 429,
  [438] = 413,
  [439] = 439,
  [440] = 385,
  [441] = 441,
  [442] = 40,
  [443] = 443,
  [444] = 444,
  [445] = 443,
  [446] = 446,
  [447] = 340,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 449,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 455,
  [462] = 452,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 444,
  [469] = 37,
  [470] = 38,
  [471] = 39,
  [472] = 472,
  [473] = 41,
  [474] = 474,
  [475] = 475,
  [476] = 476,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 487,
  [488] = 488,
  [489] = 483,
  [490] = 488,
  [491] = 491,
  [492] = 492,
  [493] = 477,
  [494] = 482,
  [495] = 495,
  [496] = 482,
  [497] = 482,
  [498] = 483,
  [499] = 499,
  [500] = 480,
  [501] = 483,
  [502] = 502,
  [503] = 503,
  [504] = 504,
  [505] = 505,
  [506] = 506,
  [507] = 482,
  [508] = 485,
  [509] = 509,
  [510] = 510,
  [511] = 488,
  [512] = 482,
  [513] = 486,
  [514] = 484,
  [515] = 502,
  [516] = 516,
  [517] = 506,
  [518] = 486,
  [519] = 502,
  [520] = 520,
  [521] = 504,
  [522] = 486,
  [523] = 502,
  [524] = 502,
  [525] = 516,
  [526] = 503,
  [527] = 502,
  [528] = 528,
  [529] = 488,
  [530] = 528,
  [531] = 510,
  [532] = 520,
  [533] = 481,
  [534] = 448,
  [535] = 446,
  [536] = 451,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(119);
      if (lookahead == '!') ADVANCE(224);
      if (lookahead == '"') ADVANCE(121);
      if (lookahead == '#') ADVANCE(284);
      if (lookahead == '%') ADVANCE(240);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '(') ADVANCE(253);
      if (lookahead == ')') ADVANCE(128);
      if (lookahead == '*') ADVANCE(238);
      if (lookahead == '+') ADVANCE(229);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(226);
      if (lookahead == '.') ADVANCE(267);
      if (lookahead == '/') ADVANCE(236);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == ':') ADVANCE(266);
      if (lookahead == '<') ADVANCE(244);
      if (lookahead == '=') ADVANCE(222);
      if (lookahead == '>') ADVANCE(245);
      if (lookahead == '?') ADVANCE(265);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(97)
      if (lookahead == ']') ADVANCE(260);
      if (lookahead == '_') ADVANCE(31);
      if (lookahead == 'a') ADVANCE(71);
      if (lookahead == 'b') ADVANCE(67);
      if (lookahead == 'c') ADVANCE(55);
      if (lookahead == 'e') ADVANCE(53);
      if (lookahead == 'f') ADVANCE(36);
      if (lookahead == 'i') ADVANCE(46);
      if (lookahead == 'n') ADVANCE(84);
      if (lookahead == 'r') ADVANCE(44);
      if (lookahead == 's') ADVANCE(81);
      if (lookahead == 't') ADVANCE(66);
      if (lookahead == 'v') ADVANCE(35);
      if (lookahead == 'w') ADVANCE(47);
      if (lookahead == '{') ADVANCE(248);
      if (lookahead == '|') ADVANCE(255);
      if (lookahead == '}') ADVANCE(249);
      if (lookahead == '~') ADVANCE(227);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(209);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(18)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(18)
      if (lookahead == '\r') SKIP(1)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(20)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(20)
      if (lookahead == '\r') SKIP(3)
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(19)
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(19)
      if (lookahead == '\r') SKIP(5)
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(25)
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(25)
      if (lookahead == '\r') SKIP(7)
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(24)
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(24)
      if (lookahead == '\r') SKIP(9)
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(22)
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(22)
      if (lookahead == '\r') ADVANCE(122);
      if (lookahead != 0) ADVANCE(122);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(22)
      if (lookahead == '\r') SKIP(11)
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(26)
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(26)
      if (lookahead == '\r') SKIP(14)
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(16)
      if (lookahead == '"') ADVANCE(131);
      if (lookahead == '/') ADVANCE(133);
      if (lookahead == '\\') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(132);
      if (lookahead != 0) ADVANCE(130);
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(17)
      if (lookahead == '*') ADVANCE(135);
      if (lookahead == '/') ADVANCE(133);
      if (lookahead == '\\') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(134);
      if (lookahead != 0) ADVANCE(130);
      END_STATE();
    case 18:
      if (lookahead == '!') ADVANCE(224);
      if (lookahead == '"') ADVANCE(121);
      if (lookahead == '%') ADVANCE(239);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '(') ADVANCE(253);
      if (lookahead == ')') ADVANCE(128);
      if (lookahead == '*') ADVANCE(237);
      if (lookahead == '+') ADVANCE(229);
      if (lookahead == '-') ADVANCE(226);
      if (lookahead == '.') ADVANCE(267);
      if (lookahead == '/') ADVANCE(236);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == '<') ADVANCE(244);
      if (lookahead == '=') ADVANCE(30);
      if (lookahead == '>') ADVANCE(245);
      if (lookahead == '?') ADVANCE(265);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(2)
      if (lookahead == '_') ADVANCE(31);
      if (lookahead == 'f') ADVANCE(144);
      if (lookahead == 'i') ADVANCE(186);
      if (lookahead == 'n') ADVANCE(199);
      if (lookahead == 't') ADVANCE(180);
      if (lookahead == '{') ADVANCE(248);
      if (lookahead == '|') ADVANCE(89);
      if (lookahead == '~') ADVANCE(227);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(18)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 19:
      if (lookahead == '!') ADVANCE(223);
      if (lookahead == '"') ADVANCE(121);
      if (lookahead == ')') ADVANCE(128);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == '-') ADVANCE(226);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(6)
      if (lookahead == ']') ADVANCE(260);
      if (lookahead == '_') ADVANCE(31);
      if (lookahead == 'f') ADVANCE(144);
      if (lookahead == 'n') ADVANCE(199);
      if (lookahead == 't') ADVANCE(180);
      if (lookahead == '{') ADVANCE(248);
      if (lookahead == '}') ADVANCE(249);
      if (lookahead == '~') ADVANCE(227);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 20:
      if (lookahead == '!') ADVANCE(29);
      if (lookahead == '"') ADVANCE(120);
      if (lookahead == '#') ADVANCE(285);
      if (lookahead == '%') ADVANCE(239);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '(') ADVANCE(253);
      if (lookahead == ')') ADVANCE(128);
      if (lookahead == '*') ADVANCE(237);
      if (lookahead == '+') ADVANCE(228);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(225);
      if (lookahead == '.') ADVANCE(267);
      if (lookahead == '/') ADVANCE(236);
      if (lookahead == ':') ADVANCE(266);
      if (lookahead == '<') ADVANCE(244);
      if (lookahead == '=') ADVANCE(222);
      if (lookahead == '>') ADVANCE(245);
      if (lookahead == '?') ADVANCE(265);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == ']') ADVANCE(260);
      if (lookahead == 'c') ADVANCE(54);
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == '{') ADVANCE(248);
      if (lookahead == '|') ADVANCE(255);
      if (lookahead == '}') ADVANCE(249);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(20)
      END_STATE();
    case 21:
      if (lookahead == '"') ADVANCE(129);
      END_STATE();
    case 22:
      if (lookahead == '"') ADVANCE(120);
      if (lookahead == '%') ADVANCE(27);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '\\') SKIP(13)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(22)
      END_STATE();
    case 23:
      if (lookahead == '"') ADVANCE(120);
      if (lookahead == '%') ADVANCE(27);
      if (lookahead == '/') ADVANCE(124);
      if (lookahead == '\\') ADVANCE(12);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(125);
      if (lookahead != 0) ADVANCE(126);
      END_STATE();
    case 24:
      if (lookahead == '"') ADVANCE(120);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == '\\') SKIP(10)
      if (lookahead == 'f') ADVANCE(144);
      if (lookahead == 't') ADVANCE(180);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(91);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(24)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 25:
      if (lookahead == '#') ADVANCE(283);
      if (lookahead == '(') ADVANCE(253);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '=') ADVANCE(221);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(8)
      if (lookahead == 'c') ADVANCE(175);
      if (lookahead == 's') ADVANCE(197);
      if (lookahead == '}') ADVANCE(249);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(258);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(25)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 26:
      if (lookahead == '(') ADVANCE(253);
      if (lookahead == ')') ADVANCE(128);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '=') ADVANCE(221);
      if (lookahead == '\\') SKIP(15)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(26)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 27:
      if (lookahead == '(') ADVANCE(127);
      END_STATE();
    case 28:
      if (lookahead == '*') ADVANCE(137);
      if (lookahead == '/') ADVANCE(136);
      END_STATE();
    case 29:
      if (lookahead == '=') ADVANCE(231);
      END_STATE();
    case 30:
      if (lookahead == '=') ADVANCE(230);
      END_STATE();
    case 31:
      if (lookahead == '_') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(141);
      END_STATE();
    case 32:
      if (lookahead == 'a') ADVANCE(51);
      END_STATE();
    case 33:
      if (lookahead == 'a') ADVANCE(75);
      END_STATE();
    case 34:
      if (lookahead == 'a') ADVANCE(82);
      END_STATE();
    case 35:
      if (lookahead == 'a') ADVANCE(65);
      END_STATE();
    case 36:
      if (lookahead == 'a') ADVANCE(58);
      if (lookahead == 'o') ADVANCE(64);
      END_STATE();
    case 37:
      if (lookahead == 'c') ADVANCE(263);
      END_STATE();
    case 38:
      if (lookahead == 'c') ADVANCE(79);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(272);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(217);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(277);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(281);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(80);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 46:
      if (lookahead == 'f') ADVANCE(270);
      if (lookahead == 'm') ADVANCE(63);
      if (lookahead == 'n') ADVANCE(276);
      if (lookahead == 's') ADVANCE(246);
      END_STATE();
    case 47:
      if (lookahead == 'h') ADVANCE(50);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(37);
      END_STATE();
    case 49:
      if (lookahead == 'i') ADVANCE(61);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(57);
      END_STATE();
    case 51:
      if (lookahead == 'k') ADVANCE(279);
      END_STATE();
    case 52:
      if (lookahead == 'l') ADVANCE(206);
      END_STATE();
    case 53:
      if (lookahead == 'l') ADVANCE(74);
      END_STATE();
    case 54:
      if (lookahead == 'l') ADVANCE(33);
      END_STATE();
    case 55:
      if (lookahead == 'l') ADVANCE(33);
      if (lookahead == 'o') ADVANCE(59);
      END_STATE();
    case 56:
      if (lookahead == 'l') ADVANCE(52);
      END_STATE();
    case 57:
      if (lookahead == 'l') ADVANCE(42);
      END_STATE();
    case 58:
      if (lookahead == 'l') ADVANCE(77);
      END_STATE();
    case 59:
      if (lookahead == 'n') ADVANCE(76);
      END_STATE();
    case 60:
      if (lookahead == 'n') ADVANCE(219);
      END_STATE();
    case 61:
      if (lookahead == 'n') ADVANCE(88);
      END_STATE();
    case 62:
      if (lookahead == 'o') ADVANCE(70);
      END_STATE();
    case 63:
      if (lookahead == 'p') ADVANCE(62);
      END_STATE();
    case 64:
      if (lookahead == 'r') ADVANCE(274);
      END_STATE();
    case 65:
      if (lookahead == 'r') ADVANCE(251);
      END_STATE();
    case 66:
      if (lookahead == 'r') ADVANCE(86);
      END_STATE();
    case 67:
      if (lookahead == 'r') ADVANCE(45);
      END_STATE();
    case 68:
      if (lookahead == 'r') ADVANCE(60);
      END_STATE();
    case 69:
      if (lookahead == 'r') ADVANCE(85);
      END_STATE();
    case 70:
      if (lookahead == 'r') ADVANCE(78);
      END_STATE();
    case 71:
      if (lookahead == 's') ADVANCE(288);
      END_STATE();
    case 72:
      if (lookahead == 's') ADVANCE(246);
      END_STATE();
    case 73:
      if (lookahead == 's') ADVANCE(256);
      END_STATE();
    case 74:
      if (lookahead == 's') ADVANCE(39);
      END_STATE();
    case 75:
      if (lookahead == 's') ADVANCE(73);
      END_STATE();
    case 76:
      if (lookahead == 's') ADVANCE(83);
      if (lookahead == 't') ADVANCE(49);
      END_STATE();
    case 77:
      if (lookahead == 's') ADVANCE(41);
      END_STATE();
    case 78:
      if (lookahead == 't') ADVANCE(291);
      END_STATE();
    case 79:
      if (lookahead == 't') ADVANCE(261);
      END_STATE();
    case 80:
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 81:
      if (lookahead == 't') ADVANCE(34);
      END_STATE();
    case 82:
      if (lookahead == 't') ADVANCE(48);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 84:
      if (lookahead == 'u') ADVANCE(56);
      END_STATE();
    case 85:
      if (lookahead == 'u') ADVANCE(38);
      END_STATE();
    case 86:
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 87:
      if (lookahead == 'u') ADVANCE(68);
      END_STATE();
    case 88:
      if (lookahead == 'u') ADVANCE(43);
      END_STATE();
    case 89:
      if (lookahead == '|') ADVANCE(235);
      END_STATE();
    case 90:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(94);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(92);
      END_STATE();
    case 91:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(209);
      END_STATE();
    case 92:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(212);
      END_STATE();
    case 93:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      END_STATE();
    case 94:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(92);
      END_STATE();
    case 95:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(139);
      END_STATE();
    case 96:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 97:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(96)
      END_STATE();
    case 98:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(114)
      END_STATE();
    case 99:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(114)
      if (lookahead == '\r') SKIP(98)
      END_STATE();
    case 100:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(115)
      END_STATE();
    case 101:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(115)
      if (lookahead == '\r') SKIP(100)
      END_STATE();
    case 102:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(112)
      END_STATE();
    case 103:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(112)
      if (lookahead == '\r') SKIP(102)
      END_STATE();
    case 104:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(113)
      END_STATE();
    case 105:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(113)
      if (lookahead == '\r') SKIP(104)
      END_STATE();
    case 106:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(116)
      END_STATE();
    case 107:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(116)
      if (lookahead == '\r') SKIP(106)
      END_STATE();
    case 108:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(117)
      END_STATE();
    case 109:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(117)
      if (lookahead == '\r') SKIP(108)
      END_STATE();
    case 110:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(118)
      END_STATE();
    case 111:
      if (eof) ADVANCE(119);
      if (lookahead == '\n') SKIP(118)
      if (lookahead == '\r') SKIP(110)
      END_STATE();
    case 112:
      if (eof) ADVANCE(119);
      if (lookahead == '!') ADVANCE(224);
      if (lookahead == '"') ADVANCE(121);
      if (lookahead == '#') ADVANCE(285);
      if (lookahead == '%') ADVANCE(239);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '(') ADVANCE(253);
      if (lookahead == ')') ADVANCE(128);
      if (lookahead == '*') ADVANCE(237);
      if (lookahead == '+') ADVANCE(229);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(226);
      if (lookahead == '.') ADVANCE(267);
      if (lookahead == '/') ADVANCE(236);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == ':') ADVANCE(266);
      if (lookahead == '<') ADVANCE(244);
      if (lookahead == '=') ADVANCE(222);
      if (lookahead == '>') ADVANCE(245);
      if (lookahead == '?') ADVANCE(265);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(103)
      if (lookahead == '_') ADVANCE(31);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'c') ADVANCE(166);
      if (lookahead == 'f') ADVANCE(143);
      if (lookahead == 'i') ADVANCE(158);
      if (lookahead == 'n') ADVANCE(199);
      if (lookahead == 'r') ADVANCE(151);
      if (lookahead == 't') ADVANCE(180);
      if (lookahead == 'v') ADVANCE(147);
      if (lookahead == 'w') ADVANCE(160);
      if (lookahead == '{') ADVANCE(248);
      if (lookahead == '|') ADVANCE(89);
      if (lookahead == '}') ADVANCE(249);
      if (lookahead == '~') ADVANCE(227);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(112)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 113:
      if (eof) ADVANCE(119);
      if (lookahead == '!') ADVANCE(224);
      if (lookahead == '"') ADVANCE(121);
      if (lookahead == '#') ADVANCE(285);
      if (lookahead == '%') ADVANCE(239);
      if (lookahead == '&') ADVANCE(243);
      if (lookahead == '(') ADVANCE(253);
      if (lookahead == '*') ADVANCE(237);
      if (lookahead == '+') ADVANCE(229);
      if (lookahead == '-') ADVANCE(226);
      if (lookahead == '.') ADVANCE(267);
      if (lookahead == '/') ADVANCE(236);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == '<') ADVANCE(244);
      if (lookahead == '=') ADVANCE(222);
      if (lookahead == '>') ADVANCE(245);
      if (lookahead == '?') ADVANCE(265);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(105)
      if (lookahead == '_') ADVANCE(31);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'c') ADVANCE(166);
      if (lookahead == 'e') ADVANCE(170);
      if (lookahead == 'f') ADVANCE(143);
      if (lookahead == 'i') ADVANCE(158);
      if (lookahead == 'n') ADVANCE(199);
      if (lookahead == 'r') ADVANCE(151);
      if (lookahead == 't') ADVANCE(180);
      if (lookahead == 'v') ADVANCE(147);
      if (lookahead == 'w') ADVANCE(160);
      if (lookahead == '{') ADVANCE(248);
      if (lookahead == '|') ADVANCE(89);
      if (lookahead == '}') ADVANCE(249);
      if (lookahead == '~') ADVANCE(227);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(113)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 114:
      if (eof) ADVANCE(119);
      if (lookahead == '!') ADVANCE(223);
      if (lookahead == '"') ADVANCE(121);
      if (lookahead == '#') ADVANCE(284);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == '-') ADVANCE(226);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(99)
      if (lookahead == '_') ADVANCE(31);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'c') ADVANCE(166);
      if (lookahead == 'f') ADVANCE(143);
      if (lookahead == 'i') ADVANCE(159);
      if (lookahead == 'n') ADVANCE(199);
      if (lookahead == 'r') ADVANCE(151);
      if (lookahead == 't') ADVANCE(180);
      if (lookahead == 'v') ADVANCE(147);
      if (lookahead == 'w') ADVANCE(160);
      if (lookahead == '{') ADVANCE(248);
      if (lookahead == '~') ADVANCE(227);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(114)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 115:
      if (eof) ADVANCE(119);
      if (lookahead == '!') ADVANCE(223);
      if (lookahead == '"') ADVANCE(121);
      if (lookahead == '#') ADVANCE(285);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(226);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(101)
      if (lookahead == '_') ADVANCE(31);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'c') ADVANCE(166);
      if (lookahead == 'f') ADVANCE(143);
      if (lookahead == 'i') ADVANCE(159);
      if (lookahead == 'n') ADVANCE(199);
      if (lookahead == 'r') ADVANCE(151);
      if (lookahead == 't') ADVANCE(180);
      if (lookahead == 'v') ADVANCE(147);
      if (lookahead == 'w') ADVANCE(160);
      if (lookahead == '{') ADVANCE(248);
      if (lookahead == '|') ADVANCE(254);
      if (lookahead == '}') ADVANCE(249);
      if (lookahead == '~') ADVANCE(227);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(115)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 116:
      if (eof) ADVANCE(119);
      if (lookahead == '!') ADVANCE(223);
      if (lookahead == '"') ADVANCE(121);
      if (lookahead == '#') ADVANCE(285);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(226);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(107)
      if (lookahead == '_') ADVANCE(31);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'c') ADVANCE(166);
      if (lookahead == 'e') ADVANCE(170);
      if (lookahead == 'f') ADVANCE(143);
      if (lookahead == 'i') ADVANCE(159);
      if (lookahead == 'n') ADVANCE(199);
      if (lookahead == 'r') ADVANCE(151);
      if (lookahead == 't') ADVANCE(180);
      if (lookahead == 'v') ADVANCE(147);
      if (lookahead == 'w') ADVANCE(160);
      if (lookahead == '{') ADVANCE(248);
      if (lookahead == '}') ADVANCE(249);
      if (lookahead == '~') ADVANCE(227);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(116)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 117:
      if (eof) ADVANCE(119);
      if (lookahead == '!') ADVANCE(223);
      if (lookahead == '"') ADVANCE(121);
      if (lookahead == '#') ADVANCE(285);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(226);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(109)
      if (lookahead == '_') ADVANCE(31);
      if (lookahead == 'a') ADVANCE(187);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'c') ADVANCE(166);
      if (lookahead == 'e') ADVANCE(170);
      if (lookahead == 'f') ADVANCE(143);
      if (lookahead == 'i') ADVANCE(159);
      if (lookahead == 'n') ADVANCE(199);
      if (lookahead == 'r') ADVANCE(151);
      if (lookahead == 't') ADVANCE(180);
      if (lookahead == 'v') ADVANCE(147);
      if (lookahead == 'w') ADVANCE(160);
      if (lookahead == '{') ADVANCE(248);
      if (lookahead == '}') ADVANCE(249);
      if (lookahead == '~') ADVANCE(227);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(117)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 118:
      if (eof) ADVANCE(119);
      if (lookahead == '!') ADVANCE(223);
      if (lookahead == '"') ADVANCE(121);
      if (lookahead == '#') ADVANCE(285);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(250);
      if (lookahead == '-') ADVANCE(226);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == '[') ADVANCE(259);
      if (lookahead == '\\') SKIP(111)
      if (lookahead == '_') ADVANCE(31);
      if (lookahead == 'a') ADVANCE(187);
      if (lookahead == 'b') ADVANCE(181);
      if (lookahead == 'c') ADVANCE(166);
      if (lookahead == 'f') ADVANCE(143);
      if (lookahead == 'i') ADVANCE(159);
      if (lookahead == 'n') ADVANCE(199);
      if (lookahead == 'r') ADVANCE(151);
      if (lookahead == 't') ADVANCE(180);
      if (lookahead == 'v') ADVANCE(147);
      if (lookahead == 'w') ADVANCE(160);
      if (lookahead == '{') ADVANCE(248);
      if (lookahead == '}') ADVANCE(249);
      if (lookahead == '~') ADVANCE(227);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(118)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '"') ADVANCE(21);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym_string_token1);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '\n') ADVANCE(126);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '%' &&
          lookahead != '\\') ADVANCE(123);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(126);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '%' &&
          lookahead != '\\') ADVANCE(126);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '/') ADVANCE(124);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(125);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '%' &&
          lookahead != '\\') ADVANCE(126);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '%' &&
          lookahead != '\\') ADVANCE(126);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_PERCENT_LPAREN);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(aux_sym_raw_string_token1);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(aux_sym_raw_string_token2);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym_raw_string_token2);
      if (lookahead == '"') ADVANCE(21);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym_raw_string_token2);
      if (lookahead == '"') ADVANCE(131);
      if (lookahead == '/') ADVANCE(133);
      if (lookahead == '\\') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(132);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(130);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym_raw_string_token2);
      if (lookahead == '*') ADVANCE(137);
      if (lookahead == '/') ADVANCE(136);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym_raw_string_token2);
      if (lookahead == '*') ADVANCE(135);
      if (lookahead == '/') ADVANCE(133);
      if (lookahead == '\\') ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(134);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(130);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym_raw_string_token2);
      if (lookahead == '/') ADVANCE(138);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(136);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_SLASH_STAR);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_STAR_SLASH);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_static_field);
      if (lookahead == '_') ADVANCE(140);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(139);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_static_field);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(140);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_field);
      if (lookahead == '_') ADVANCE(142);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(141);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_field);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(167);
      if (lookahead == 'o') ADVANCE(178);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(167);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(188);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(164);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(179);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(196);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'c') ADVANCE(264);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'c') ADVANCE(193);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(195);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(216);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(218);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(278);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(282);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(273);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(146);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'f') ADVANCE(271);
      if (lookahead == 'm') ADVANCE(177);
      if (lookahead == 's') ADVANCE(247);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'f') ADVANCE(271);
      if (lookahead == 'm') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'h') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'i') ADVANCE(149);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'i') ADVANCE(174);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'i') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'k') ADVANCE(280);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(145);
      if (lookahead == 'o') ADVANCE(172);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(189);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(165);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(154);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(191);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'n') ADVANCE(220);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'n') ADVANCE(194);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'n') ADVANCE(190);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'n') ADVANCE(203);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'o') ADVANCE(173);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'o') ADVANCE(183);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'p') ADVANCE(176);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(275);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(252);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(201);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(157);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(171);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(192);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(247);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(289);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(156);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(292);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(262);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(162);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(148);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'u') ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'u') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'u') ADVANCE(152);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'u') ADVANCE(182);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'u') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_null);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == 'x') ADVANCE(214);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(209);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(209);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(aux_sym_number_token2);
      if (lookahead == '.') ADVANCE(93);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(aux_sym_number_token2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(aux_sym_number_token3);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(aux_sym_number_token3);
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(aux_sym_number_token4);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'f')) ADVANCE(214);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_true);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_false);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_return);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(230);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(231);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(209);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(209);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(137);
      if (lookahead == '/') ADVANCE(136);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '/') ADVANCE(138);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '(') ADVANCE(127);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(234);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(242);
      if (lookahead == '=') ADVANCE(232);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(233);
      if (lookahead == '>') ADVANCE(241);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_is);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_var);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(235);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_class);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(aux_sym_prefix_operator_definition_token1);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_construct);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_construct);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_static);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(268);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(269);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_else);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_for);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_while);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_break_statement);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_break_statement);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_continue_statement);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_continue_statement);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(287);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(286);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_POUND_BANG);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_POUND_BANG);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(290);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_as);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_shebang);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(290);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_import);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(204);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 114},
  [2] = {.lex_state = 115},
  [3] = {.lex_state = 115},
  [4] = {.lex_state = 115},
  [5] = {.lex_state = 115},
  [6] = {.lex_state = 115},
  [7] = {.lex_state = 115},
  [8] = {.lex_state = 115},
  [9] = {.lex_state = 115},
  [10] = {.lex_state = 115},
  [11] = {.lex_state = 115},
  [12] = {.lex_state = 115},
  [13] = {.lex_state = 115},
  [14] = {.lex_state = 115},
  [15] = {.lex_state = 115},
  [16] = {.lex_state = 115},
  [17] = {.lex_state = 115},
  [18] = {.lex_state = 115},
  [19] = {.lex_state = 115},
  [20] = {.lex_state = 115},
  [21] = {.lex_state = 115},
  [22] = {.lex_state = 115},
  [23] = {.lex_state = 115},
  [24] = {.lex_state = 115},
  [25] = {.lex_state = 115},
  [26] = {.lex_state = 115},
  [27] = {.lex_state = 115},
  [28] = {.lex_state = 115},
  [29] = {.lex_state = 115},
  [30] = {.lex_state = 115},
  [31] = {.lex_state = 115},
  [32] = {.lex_state = 115},
  [33] = {.lex_state = 115},
  [34] = {.lex_state = 115},
  [35] = {.lex_state = 115},
  [36] = {.lex_state = 115},
  [37] = {.lex_state = 112},
  [38] = {.lex_state = 112},
  [39] = {.lex_state = 112},
  [40] = {.lex_state = 112},
  [41] = {.lex_state = 112},
  [42] = {.lex_state = 112},
  [43] = {.lex_state = 112},
  [44] = {.lex_state = 113},
  [45] = {.lex_state = 113},
  [46] = {.lex_state = 112},
  [47] = {.lex_state = 113},
  [48] = {.lex_state = 113},
  [49] = {.lex_state = 113},
  [50] = {.lex_state = 112},
  [51] = {.lex_state = 113},
  [52] = {.lex_state = 112},
  [53] = {.lex_state = 113},
  [54] = {.lex_state = 112},
  [55] = {.lex_state = 113},
  [56] = {.lex_state = 113},
  [57] = {.lex_state = 113},
  [58] = {.lex_state = 113},
  [59] = {.lex_state = 112},
  [60] = {.lex_state = 113},
  [61] = {.lex_state = 113},
  [62] = {.lex_state = 113},
  [63] = {.lex_state = 113},
  [64] = {.lex_state = 113},
  [65] = {.lex_state = 113},
  [66] = {.lex_state = 113},
  [67] = {.lex_state = 113},
  [68] = {.lex_state = 113},
  [69] = {.lex_state = 112},
  [70] = {.lex_state = 113},
  [71] = {.lex_state = 112},
  [72] = {.lex_state = 112},
  [73] = {.lex_state = 113},
  [74] = {.lex_state = 112},
  [75] = {.lex_state = 112},
  [76] = {.lex_state = 113},
  [77] = {.lex_state = 112},
  [78] = {.lex_state = 112},
  [79] = {.lex_state = 112},
  [80] = {.lex_state = 113},
  [81] = {.lex_state = 112},
  [82] = {.lex_state = 113},
  [83] = {.lex_state = 112},
  [84] = {.lex_state = 112},
  [85] = {.lex_state = 112},
  [86] = {.lex_state = 112},
  [87] = {.lex_state = 113},
  [88] = {.lex_state = 113},
  [89] = {.lex_state = 113},
  [90] = {.lex_state = 113},
  [91] = {.lex_state = 112},
  [92] = {.lex_state = 113},
  [93] = {.lex_state = 112},
  [94] = {.lex_state = 113},
  [95] = {.lex_state = 113},
  [96] = {.lex_state = 112},
  [97] = {.lex_state = 112},
  [98] = {.lex_state = 113},
  [99] = {.lex_state = 112},
  [100] = {.lex_state = 112},
  [101] = {.lex_state = 113},
  [102] = {.lex_state = 112},
  [103] = {.lex_state = 113},
  [104] = {.lex_state = 113},
  [105] = {.lex_state = 113},
  [106] = {.lex_state = 112},
  [107] = {.lex_state = 112},
  [108] = {.lex_state = 113},
  [109] = {.lex_state = 112},
  [110] = {.lex_state = 112},
  [111] = {.lex_state = 112},
  [112] = {.lex_state = 112},
  [113] = {.lex_state = 18},
  [114] = {.lex_state = 18},
  [115] = {.lex_state = 18},
  [116] = {.lex_state = 18},
  [117] = {.lex_state = 18},
  [118] = {.lex_state = 18},
  [119] = {.lex_state = 18},
  [120] = {.lex_state = 18},
  [121] = {.lex_state = 18},
  [122] = {.lex_state = 18},
  [123] = {.lex_state = 18},
  [124] = {.lex_state = 18},
  [125] = {.lex_state = 18},
  [126] = {.lex_state = 18},
  [127] = {.lex_state = 18},
  [128] = {.lex_state = 18},
  [129] = {.lex_state = 18},
  [130] = {.lex_state = 18},
  [131] = {.lex_state = 18},
  [132] = {.lex_state = 18},
  [133] = {.lex_state = 18},
  [134] = {.lex_state = 18},
  [135] = {.lex_state = 18},
  [136] = {.lex_state = 18},
  [137] = {.lex_state = 18},
  [138] = {.lex_state = 18},
  [139] = {.lex_state = 18},
  [140] = {.lex_state = 18},
  [141] = {.lex_state = 18},
  [142] = {.lex_state = 18},
  [143] = {.lex_state = 18},
  [144] = {.lex_state = 20},
  [145] = {.lex_state = 20},
  [146] = {.lex_state = 20},
  [147] = {.lex_state = 20},
  [148] = {.lex_state = 20},
  [149] = {.lex_state = 20},
  [150] = {.lex_state = 20},
  [151] = {.lex_state = 20},
  [152] = {.lex_state = 20},
  [153] = {.lex_state = 20},
  [154] = {.lex_state = 20},
  [155] = {.lex_state = 20},
  [156] = {.lex_state = 19},
  [157] = {.lex_state = 19},
  [158] = {.lex_state = 19},
  [159] = {.lex_state = 19},
  [160] = {.lex_state = 19},
  [161] = {.lex_state = 19},
  [162] = {.lex_state = 20},
  [163] = {.lex_state = 19},
  [164] = {.lex_state = 19},
  [165] = {.lex_state = 20},
  [166] = {.lex_state = 20},
  [167] = {.lex_state = 116},
  [168] = {.lex_state = 19},
  [169] = {.lex_state = 20},
  [170] = {.lex_state = 19},
  [171] = {.lex_state = 19},
  [172] = {.lex_state = 20},
  [173] = {.lex_state = 20},
  [174] = {.lex_state = 116},
  [175] = {.lex_state = 19},
  [176] = {.lex_state = 19},
  [177] = {.lex_state = 20},
  [178] = {.lex_state = 20},
  [179] = {.lex_state = 19},
  [180] = {.lex_state = 20},
  [181] = {.lex_state = 20},
  [182] = {.lex_state = 116},
  [183] = {.lex_state = 20},
  [184] = {.lex_state = 117},
  [185] = {.lex_state = 20},
  [186] = {.lex_state = 19},
  [187] = {.lex_state = 19},
  [188] = {.lex_state = 20},
  [189] = {.lex_state = 19},
  [190] = {.lex_state = 20},
  [191] = {.lex_state = 20},
  [192] = {.lex_state = 20},
  [193] = {.lex_state = 20},
  [194] = {.lex_state = 19},
  [195] = {.lex_state = 20},
  [196] = {.lex_state = 19},
  [197] = {.lex_state = 115},
  [198] = {.lex_state = 19},
  [199] = {.lex_state = 116},
  [200] = {.lex_state = 115},
  [201] = {.lex_state = 118},
  [202] = {.lex_state = 116},
  [203] = {.lex_state = 116},
  [204] = {.lex_state = 19},
  [205] = {.lex_state = 19},
  [206] = {.lex_state = 115},
  [207] = {.lex_state = 19},
  [208] = {.lex_state = 19},
  [209] = {.lex_state = 19},
  [210] = {.lex_state = 19},
  [211] = {.lex_state = 19},
  [212] = {.lex_state = 19},
  [213] = {.lex_state = 19},
  [214] = {.lex_state = 116},
  [215] = {.lex_state = 19},
  [216] = {.lex_state = 19},
  [217] = {.lex_state = 19},
  [218] = {.lex_state = 19},
  [219] = {.lex_state = 19},
  [220] = {.lex_state = 19},
  [221] = {.lex_state = 115},
  [222] = {.lex_state = 115},
  [223] = {.lex_state = 19},
  [224] = {.lex_state = 19},
  [225] = {.lex_state = 19},
  [226] = {.lex_state = 116},
  [227] = {.lex_state = 19},
  [228] = {.lex_state = 19},
  [229] = {.lex_state = 19},
  [230] = {.lex_state = 19},
  [231] = {.lex_state = 19},
  [232] = {.lex_state = 19},
  [233] = {.lex_state = 19},
  [234] = {.lex_state = 19},
  [235] = {.lex_state = 19},
  [236] = {.lex_state = 19},
  [237] = {.lex_state = 19},
  [238] = {.lex_state = 19},
  [239] = {.lex_state = 116},
  [240] = {.lex_state = 116},
  [241] = {.lex_state = 116},
  [242] = {.lex_state = 116},
  [243] = {.lex_state = 19},
  [244] = {.lex_state = 19},
  [245] = {.lex_state = 116},
  [246] = {.lex_state = 19},
  [247] = {.lex_state = 19},
  [248] = {.lex_state = 19},
  [249] = {.lex_state = 19},
  [250] = {.lex_state = 20},
  [251] = {.lex_state = 19},
  [252] = {.lex_state = 19},
  [253] = {.lex_state = 19},
  [254] = {.lex_state = 19},
  [255] = {.lex_state = 115},
  [256] = {.lex_state = 116},
  [257] = {.lex_state = 19},
  [258] = {.lex_state = 19},
  [259] = {.lex_state = 19},
  [260] = {.lex_state = 116},
  [261] = {.lex_state = 116},
  [262] = {.lex_state = 116},
  [263] = {.lex_state = 116},
  [264] = {.lex_state = 116},
  [265] = {.lex_state = 116},
  [266] = {.lex_state = 20},
  [267] = {.lex_state = 116},
  [268] = {.lex_state = 19},
  [269] = {.lex_state = 116},
  [270] = {.lex_state = 19},
  [271] = {.lex_state = 19},
  [272] = {.lex_state = 115},
  [273] = {.lex_state = 115},
  [274] = {.lex_state = 20},
  [275] = {.lex_state = 20},
  [276] = {.lex_state = 115},
  [277] = {.lex_state = 115},
  [278] = {.lex_state = 115},
  [279] = {.lex_state = 115},
  [280] = {.lex_state = 20},
  [281] = {.lex_state = 20},
  [282] = {.lex_state = 115},
  [283] = {.lex_state = 115},
  [284] = {.lex_state = 115},
  [285] = {.lex_state = 115},
  [286] = {.lex_state = 115},
  [287] = {.lex_state = 115},
  [288] = {.lex_state = 115},
  [289] = {.lex_state = 115},
  [290] = {.lex_state = 115},
  [291] = {.lex_state = 20},
  [292] = {.lex_state = 20},
  [293] = {.lex_state = 20},
  [294] = {.lex_state = 20},
  [295] = {.lex_state = 20},
  [296] = {.lex_state = 20},
  [297] = {.lex_state = 20},
  [298] = {.lex_state = 20},
  [299] = {.lex_state = 20},
  [300] = {.lex_state = 20},
  [301] = {.lex_state = 20},
  [302] = {.lex_state = 20},
  [303] = {.lex_state = 20},
  [304] = {.lex_state = 20},
  [305] = {.lex_state = 20},
  [306] = {.lex_state = 20},
  [307] = {.lex_state = 20},
  [308] = {.lex_state = 20},
  [309] = {.lex_state = 25},
  [310] = {.lex_state = 25},
  [311] = {.lex_state = 25},
  [312] = {.lex_state = 25},
  [313] = {.lex_state = 25},
  [314] = {.lex_state = 25},
  [315] = {.lex_state = 24},
  [316] = {.lex_state = 24},
  [317] = {.lex_state = 24},
  [318] = {.lex_state = 24},
  [319] = {.lex_state = 25},
  [320] = {.lex_state = 25},
  [321] = {.lex_state = 25},
  [322] = {.lex_state = 25},
  [323] = {.lex_state = 25},
  [324] = {.lex_state = 25},
  [325] = {.lex_state = 25},
  [326] = {.lex_state = 20},
  [327] = {.lex_state = 25},
  [328] = {.lex_state = 25},
  [329] = {.lex_state = 25},
  [330] = {.lex_state = 25},
  [331] = {.lex_state = 25},
  [332] = {.lex_state = 25},
  [333] = {.lex_state = 25},
  [334] = {.lex_state = 25},
  [335] = {.lex_state = 20},
  [336] = {.lex_state = 25},
  [337] = {.lex_state = 25},
  [338] = {.lex_state = 20},
  [339] = {.lex_state = 25},
  [340] = {.lex_state = 25},
  [341] = {.lex_state = 25},
  [342] = {.lex_state = 25},
  [343] = {.lex_state = 25},
  [344] = {.lex_state = 25},
  [345] = {.lex_state = 25},
  [346] = {.lex_state = 25},
  [347] = {.lex_state = 25},
  [348] = {.lex_state = 25},
  [349] = {.lex_state = 20},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 20},
  [352] = {.lex_state = 23},
  [353] = {.lex_state = 20},
  [354] = {.lex_state = 23},
  [355] = {.lex_state = 23},
  [356] = {.lex_state = 0},
  [357] = {.lex_state = 26},
  [358] = {.lex_state = 23},
  [359] = {.lex_state = 23},
  [360] = {.lex_state = 23},
  [361] = {.lex_state = 23},
  [362] = {.lex_state = 0},
  [363] = {.lex_state = 23},
  [364] = {.lex_state = 23},
  [365] = {.lex_state = 0},
  [366] = {.lex_state = 23},
  [367] = {.lex_state = 23},
  [368] = {.lex_state = 23},
  [369] = {.lex_state = 23},
  [370] = {.lex_state = 26},
  [371] = {.lex_state = 23},
  [372] = {.lex_state = 23},
  [373] = {.lex_state = 23},
  [374] = {.lex_state = 26},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 23},
  [378] = {.lex_state = 26},
  [379] = {.lex_state = 26},
  [380] = {.lex_state = 23},
  [381] = {.lex_state = 26},
  [382] = {.lex_state = 16},
  [383] = {.lex_state = 20},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 0},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 20},
  [388] = {.lex_state = 0},
  [389] = {.lex_state = 0},
  [390] = {.lex_state = 16},
  [391] = {.lex_state = 0},
  [392] = {.lex_state = 17},
  [393] = {.lex_state = 16},
  [394] = {.lex_state = 26},
  [395] = {.lex_state = 20},
  [396] = {.lex_state = 20},
  [397] = {.lex_state = 26},
  [398] = {.lex_state = 20},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 16},
  [401] = {.lex_state = 26},
  [402] = {.lex_state = 17},
  [403] = {.lex_state = 0},
  [404] = {.lex_state = 16},
  [405] = {.lex_state = 0},
  [406] = {.lex_state = 0},
  [407] = {.lex_state = 0},
  [408] = {.lex_state = 17},
  [409] = {.lex_state = 17},
  [410] = {.lex_state = 0},
  [411] = {.lex_state = 16},
  [412] = {.lex_state = 23},
  [413] = {.lex_state = 0},
  [414] = {.lex_state = 0},
  [415] = {.lex_state = 20},
  [416] = {.lex_state = 17},
  [417] = {.lex_state = 0},
  [418] = {.lex_state = 20},
  [419] = {.lex_state = 0},
  [420] = {.lex_state = 26},
  [421] = {.lex_state = 16},
  [422] = {.lex_state = 0},
  [423] = {.lex_state = 26},
  [424] = {.lex_state = 0},
  [425] = {.lex_state = 0},
  [426] = {.lex_state = 0},
  [427] = {.lex_state = 0},
  [428] = {.lex_state = 16},
  [429] = {.lex_state = 26},
  [430] = {.lex_state = 0},
  [431] = {.lex_state = 20},
  [432] = {.lex_state = 0},
  [433] = {.lex_state = 23},
  [434] = {.lex_state = 0},
  [435] = {.lex_state = 0},
  [436] = {.lex_state = 16},
  [437] = {.lex_state = 26},
  [438] = {.lex_state = 0},
  [439] = {.lex_state = 0},
  [440] = {.lex_state = 0},
  [441] = {.lex_state = 20},
  [442] = {.lex_state = 26},
  [443] = {.lex_state = 26},
  [444] = {.lex_state = 0},
  [445] = {.lex_state = 26},
  [446] = {.lex_state = 17},
  [447] = {.lex_state = 26},
  [448] = {.lex_state = 17},
  [449] = {.lex_state = 0},
  [450] = {.lex_state = 0},
  [451] = {.lex_state = 17},
  [452] = {.lex_state = 26},
  [453] = {.lex_state = 0},
  [454] = {.lex_state = 0},
  [455] = {.lex_state = 20},
  [456] = {.lex_state = 26},
  [457] = {.lex_state = 26},
  [458] = {.lex_state = 0},
  [459] = {.lex_state = 0},
  [460] = {.lex_state = 0},
  [461] = {.lex_state = 20},
  [462] = {.lex_state = 26},
  [463] = {.lex_state = 0},
  [464] = {.lex_state = 26},
  [465] = {.lex_state = 0},
  [466] = {.lex_state = 26},
  [467] = {.lex_state = 16},
  [468] = {.lex_state = 0},
  [469] = {.lex_state = 26},
  [470] = {.lex_state = 26},
  [471] = {.lex_state = 26},
  [472] = {.lex_state = 26},
  [473] = {.lex_state = 26},
  [474] = {.lex_state = 26},
  [475] = {.lex_state = 26},
  [476] = {.lex_state = 0},
  [477] = {.lex_state = 26},
  [478] = {.lex_state = 0},
  [479] = {.lex_state = 0},
  [480] = {.lex_state = 0},
  [481] = {.lex_state = 26},
  [482] = {.lex_state = 213},
  [483] = {.lex_state = 26},
  [484] = {.lex_state = 26},
  [485] = {.lex_state = 26},
  [486] = {.lex_state = 0},
  [487] = {.lex_state = 0},
  [488] = {.lex_state = 0},
  [489] = {.lex_state = 26},
  [490] = {.lex_state = 0},
  [491] = {.lex_state = 0},
  [492] = {.lex_state = 0},
  [493] = {.lex_state = 26},
  [494] = {.lex_state = 213},
  [495] = {.lex_state = 0},
  [496] = {.lex_state = 213},
  [497] = {.lex_state = 213},
  [498] = {.lex_state = 26},
  [499] = {.lex_state = 0},
  [500] = {.lex_state = 0},
  [501] = {.lex_state = 26},
  [502] = {.lex_state = 210},
  [503] = {.lex_state = 26},
  [504] = {.lex_state = 26},
  [505] = {.lex_state = 0},
  [506] = {.lex_state = 0},
  [507] = {.lex_state = 213},
  [508] = {.lex_state = 26},
  [509] = {.lex_state = 0},
  [510] = {.lex_state = 26},
  [511] = {.lex_state = 0},
  [512] = {.lex_state = 213},
  [513] = {.lex_state = 0},
  [514] = {.lex_state = 26},
  [515] = {.lex_state = 210},
  [516] = {.lex_state = 0},
  [517] = {.lex_state = 0},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 210},
  [520] = {.lex_state = 0},
  [521] = {.lex_state = 26},
  [522] = {.lex_state = 0},
  [523] = {.lex_state = 210},
  [524] = {.lex_state = 210},
  [525] = {.lex_state = 0},
  [526] = {.lex_state = 26},
  [527] = {.lex_state = 210},
  [528] = {.lex_state = 0},
  [529] = {.lex_state = 0},
  [530] = {.lex_state = 0},
  [531] = {.lex_state = 26},
  [532] = {.lex_state = 0},
  [533] = {.lex_state = 26},
  [534] = {(TSStateId)(-1)},
  [535] = {(TSStateId)(-1)},
  [536] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [aux_sym_raw_string_token1] = ACTIONS(1),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [anon_sym_STAR_SLASH] = ACTIONS(1),
    [sym_static_field] = ACTIONS(1),
    [sym_field] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [aux_sym_number_token1] = ACTIONS(1),
    [aux_sym_number_token4] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [aux_sym_prefix_operator_definition_token1] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_construct] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [sym_break_statement] = ACTIONS(1),
    [sym_continue_statement] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_POUND_BANG] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [sym_shebang] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(476),
    [sym_string] = STATE(69),
    [sym_raw_string] = STATE(69),
    [sym_comment] = STATE(1),
    [sym_number] = STATE(69),
    [sym_boolean] = STATE(69),
    [sym_return_statement] = STATE(290),
    [sym_assignment] = STATE(290),
    [sym_unary_expression] = STATE(69),
    [sym_binary_expression] = STATE(69),
    [sym_block] = STATE(290),
    [sym_variable_definition] = STATE(290),
    [sym_call_expression] = STATE(69),
    [sym_class_definition] = STATE(290),
    [sym_conditional] = STATE(69),
    [sym_list] = STATE(69),
    [sym_index_expression] = STATE(69),
    [sym_subscript] = STATE(69),
    [sym_range] = STATE(69),
    [sym_if_statement] = STATE(290),
    [sym_for_statement] = STATE(290),
    [sym_while_statement] = STATE(290),
    [sym_map] = STATE(69),
    [sym__any_attribute] = STATE(396),
    [sym_attribute] = STATE(418),
    [sym_runtime_attribute] = STATE(418),
    [sym_import_statement] = STATE(290),
    [sym__statement] = STATE(279),
    [sym__expression] = STATE(106),
    [aux_sym_source_file_repeat1] = STATE(11),
    [aux_sym_class_definition_repeat1] = STATE(326),
    [ts_builtin_sym_end] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(9),
    [aux_sym_raw_string_token1] = ACTIONS(11),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_SLASH_STAR] = ACTIONS(5),
    [sym_static_field] = ACTIONS(13),
    [sym_field] = ACTIONS(13),
    [sym_name] = ACTIONS(15),
    [sym_null] = ACTIONS(15),
    [aux_sym_number_token1] = ACTIONS(17),
    [aux_sym_number_token4] = ACTIONS(19),
    [anon_sym_true] = ACTIONS(21),
    [anon_sym_false] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_TILDE] = ACTIONS(25),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_class] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_if] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [sym_break_statement] = ACTIONS(43),
    [sym_continue_statement] = ACTIONS(43),
    [anon_sym_POUND] = ACTIONS(45),
    [anon_sym_POUND_BANG] = ACTIONS(47),
    [sym_shebang] = ACTIONS(49),
    [anon_sym_import] = ACTIONS(51),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 34,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(53), 1,
      anon_sym_RBRACE,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    STATE(2), 1,
      sym_comment,
    STATE(29), 1,
      aux_sym_source_file_repeat1,
    STATE(91), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    STATE(414), 1,
      sym_pair,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [129] = 34,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(57), 1,
      anon_sym_RBRACE,
    ACTIONS(59), 1,
      anon_sym_PIPE,
    STATE(3), 1,
      sym_comment,
    STATE(27), 1,
      aux_sym_source_file_repeat1,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [258] = 34,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(61), 1,
      anon_sym_RBRACE,
    ACTIONS(63), 1,
      anon_sym_PIPE,
    STATE(4), 1,
      sym_comment,
    STATE(19), 1,
      aux_sym_source_file_repeat1,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [387] = 34,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(65), 1,
      anon_sym_RBRACE,
    STATE(5), 1,
      sym_comment,
    STATE(26), 1,
      aux_sym_source_file_repeat1,
    STATE(91), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    STATE(414), 1,
      sym_pair,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [516] = 34,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(67), 1,
      anon_sym_RBRACE,
    ACTIONS(69), 1,
      anon_sym_PIPE,
    STATE(6), 1,
      sym_comment,
    STATE(23), 1,
      aux_sym_source_file_repeat1,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [645] = 34,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(71), 1,
      anon_sym_RBRACE,
    STATE(7), 1,
      sym_comment,
    STATE(29), 1,
      aux_sym_source_file_repeat1,
    STATE(91), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(386), 1,
      sym_pair,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [774] = 32,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(78), 1,
      aux_sym_raw_string_token1,
    ACTIONS(87), 1,
      aux_sym_number_token1,
    ACTIONS(90), 1,
      aux_sym_number_token4,
    ACTIONS(96), 1,
      anon_sym_return,
    ACTIONS(102), 1,
      anon_sym_DASH,
    ACTIONS(105), 1,
      anon_sym_LBRACE,
    ACTIONS(108), 1,
      anon_sym_var,
    ACTIONS(111), 1,
      anon_sym_class,
    ACTIONS(114), 1,
      anon_sym_LBRACK,
    ACTIONS(117), 1,
      anon_sym_if,
    ACTIONS(120), 1,
      anon_sym_for,
    ACTIONS(123), 1,
      anon_sym_while,
    ACTIONS(129), 1,
      anon_sym_POUND,
    ACTIONS(132), 1,
      anon_sym_POUND_BANG,
    ACTIONS(135), 1,
      anon_sym_import,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(73), 2,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
    ACTIONS(81), 2,
      sym_static_field,
      sym_field,
    ACTIONS(84), 2,
      sym_name,
      sym_null,
    ACTIONS(93), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(99), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(126), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(8), 2,
      sym_comment,
      aux_sym_source_file_repeat1,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [899] = 34,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(138), 1,
      anon_sym_RBRACE,
    STATE(9), 1,
      sym_comment,
    STATE(26), 1,
      aux_sym_source_file_repeat1,
    STATE(91), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(384), 1,
      sym_pair,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [1028] = 34,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(140), 1,
      anon_sym_RBRACE,
    ACTIONS(142), 1,
      anon_sym_PIPE,
    STATE(10), 1,
      sym_comment,
    STATE(18), 1,
      aux_sym_source_file_repeat1,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [1157] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(144), 1,
      ts_builtin_sym_end,
    STATE(8), 1,
      aux_sym_source_file_repeat1,
    STATE(11), 1,
      sym_comment,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [1283] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(146), 1,
      anon_sym_RBRACE,
    STATE(12), 1,
      sym_comment,
    STATE(25), 1,
      aux_sym_source_file_repeat1,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [1409] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(148), 1,
      anon_sym_RBRACE,
    STATE(8), 1,
      aux_sym_source_file_repeat1,
    STATE(13), 1,
      sym_comment,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [1535] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(150), 1,
      anon_sym_RBRACE,
    STATE(8), 1,
      aux_sym_source_file_repeat1,
    STATE(14), 1,
      sym_comment,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [1661] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(152), 1,
      anon_sym_RBRACE,
    STATE(8), 1,
      aux_sym_source_file_repeat1,
    STATE(15), 1,
      sym_comment,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [1787] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(154), 1,
      anon_sym_RBRACE,
    STATE(16), 1,
      sym_comment,
    STATE(17), 1,
      aux_sym_source_file_repeat1,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [1913] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(156), 1,
      anon_sym_RBRACE,
    STATE(8), 1,
      aux_sym_source_file_repeat1,
    STATE(17), 1,
      sym_comment,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [2039] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(158), 1,
      anon_sym_RBRACE,
    STATE(8), 1,
      aux_sym_source_file_repeat1,
    STATE(18), 1,
      sym_comment,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [2165] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(160), 1,
      anon_sym_RBRACE,
    STATE(8), 1,
      aux_sym_source_file_repeat1,
    STATE(19), 1,
      sym_comment,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [2291] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(162), 1,
      anon_sym_RBRACE,
    STATE(13), 1,
      aux_sym_source_file_repeat1,
    STATE(20), 1,
      sym_comment,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [2417] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(164), 1,
      ts_builtin_sym_end,
    STATE(8), 1,
      aux_sym_source_file_repeat1,
    STATE(21), 1,
      sym_comment,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [2543] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(144), 1,
      ts_builtin_sym_end,
    STATE(21), 1,
      aux_sym_source_file_repeat1,
    STATE(22), 1,
      sym_comment,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [2669] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(166), 1,
      anon_sym_RBRACE,
    STATE(8), 1,
      aux_sym_source_file_repeat1,
    STATE(23), 1,
      sym_comment,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [2795] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(168), 1,
      anon_sym_RBRACE,
    STATE(15), 1,
      aux_sym_source_file_repeat1,
    STATE(24), 1,
      sym_comment,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [2921] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(170), 1,
      anon_sym_RBRACE,
    STATE(8), 1,
      aux_sym_source_file_repeat1,
    STATE(25), 1,
      sym_comment,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [3047] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(172), 1,
      anon_sym_RBRACE,
    STATE(8), 1,
      aux_sym_source_file_repeat1,
    STATE(26), 1,
      sym_comment,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [3173] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(174), 1,
      anon_sym_RBRACE,
    STATE(8), 1,
      aux_sym_source_file_repeat1,
    STATE(27), 1,
      sym_comment,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [3299] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(176), 1,
      anon_sym_RBRACE,
    STATE(14), 1,
      aux_sym_source_file_repeat1,
    STATE(28), 1,
      sym_comment,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [3425] = 33,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(178), 1,
      anon_sym_RBRACE,
    STATE(8), 1,
      aux_sym_source_file_repeat1,
    STATE(29), 1,
      sym_comment,
    STATE(106), 1,
      sym__expression,
    STATE(279), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [3551] = 31,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(180), 1,
      anon_sym_DQUOTE,
    ACTIONS(182), 1,
      aux_sym_raw_string_token1,
    ACTIONS(188), 1,
      aux_sym_number_token1,
    ACTIONS(190), 1,
      aux_sym_number_token4,
    ACTIONS(194), 1,
      anon_sym_return,
    ACTIONS(198), 1,
      anon_sym_DASH,
    ACTIONS(200), 1,
      anon_sym_LBRACE,
    ACTIONS(202), 1,
      anon_sym_var,
    ACTIONS(204), 1,
      anon_sym_class,
    ACTIONS(206), 1,
      anon_sym_LBRACK,
    ACTIONS(208), 1,
      anon_sym_if,
    ACTIONS(210), 1,
      anon_sym_for,
    ACTIONS(212), 1,
      anon_sym_while,
    ACTIONS(216), 1,
      anon_sym_import,
    STATE(30), 1,
      sym_comment,
    STATE(44), 1,
      sym__expression,
    STATE(261), 1,
      sym__statement,
    STATE(335), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(184), 2,
      sym_static_field,
      sym_field,
    ACTIONS(186), 2,
      sym_name,
      sym_null,
    ACTIONS(192), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(196), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(214), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(245), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(80), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [3671] = 31,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(194), 1,
      anon_sym_return,
    ACTIONS(202), 1,
      anon_sym_var,
    ACTIONS(204), 1,
      anon_sym_class,
    ACTIONS(208), 1,
      anon_sym_if,
    ACTIONS(210), 1,
      anon_sym_for,
    ACTIONS(212), 1,
      anon_sym_while,
    ACTIONS(216), 1,
      anon_sym_import,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(236), 1,
      anon_sym_LBRACE,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    STATE(31), 1,
      sym_comment,
    STATE(240), 1,
      sym__statement,
    STATE(306), 1,
      sym__expression,
    STATE(335), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(214), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(245), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [3791] = 31,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(240), 1,
      anon_sym_LBRACE,
    STATE(32), 1,
      sym_comment,
    STATE(273), 1,
      sym__statement,
    STATE(300), 1,
      sym__expression,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [3911] = 31,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(180), 1,
      anon_sym_DQUOTE,
    ACTIONS(182), 1,
      aux_sym_raw_string_token1,
    ACTIONS(188), 1,
      aux_sym_number_token1,
    ACTIONS(190), 1,
      aux_sym_number_token4,
    ACTIONS(194), 1,
      anon_sym_return,
    ACTIONS(198), 1,
      anon_sym_DASH,
    ACTIONS(200), 1,
      anon_sym_LBRACE,
    ACTIONS(202), 1,
      anon_sym_var,
    ACTIONS(204), 1,
      anon_sym_class,
    ACTIONS(206), 1,
      anon_sym_LBRACK,
    ACTIONS(208), 1,
      anon_sym_if,
    ACTIONS(210), 1,
      anon_sym_for,
    ACTIONS(212), 1,
      anon_sym_while,
    ACTIONS(216), 1,
      anon_sym_import,
    STATE(33), 1,
      sym_comment,
    STATE(49), 1,
      sym__expression,
    STATE(265), 1,
      sym__statement,
    STATE(335), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(184), 2,
      sym_static_field,
      sym_field,
    ACTIONS(186), 2,
      sym_name,
      sym_null,
    ACTIONS(192), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(196), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(214), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(245), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(80), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [4031] = 31,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(240), 1,
      anon_sym_LBRACE,
    STATE(34), 1,
      sym_comment,
    STATE(283), 1,
      sym__statement,
    STATE(300), 1,
      sym__expression,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [4151] = 31,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(180), 1,
      anon_sym_DQUOTE,
    ACTIONS(182), 1,
      aux_sym_raw_string_token1,
    ACTIONS(188), 1,
      aux_sym_number_token1,
    ACTIONS(190), 1,
      aux_sym_number_token4,
    ACTIONS(194), 1,
      anon_sym_return,
    ACTIONS(198), 1,
      anon_sym_DASH,
    ACTIONS(200), 1,
      anon_sym_LBRACE,
    ACTIONS(202), 1,
      anon_sym_var,
    ACTIONS(204), 1,
      anon_sym_class,
    ACTIONS(206), 1,
      anon_sym_LBRACK,
    ACTIONS(208), 1,
      anon_sym_if,
    ACTIONS(210), 1,
      anon_sym_for,
    ACTIONS(212), 1,
      anon_sym_while,
    ACTIONS(216), 1,
      anon_sym_import,
    STATE(35), 1,
      sym_comment,
    STATE(48), 1,
      sym__expression,
    STATE(260), 1,
      sym__statement,
    STATE(335), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(184), 2,
      sym_static_field,
      sym_field,
    ACTIONS(186), 2,
      sym_name,
      sym_null,
    ACTIONS(192), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(196), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(214), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(245), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(80), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [4271] = 31,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(23), 1,
      anon_sym_return,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_class,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(37), 1,
      anon_sym_if,
    ACTIONS(39), 1,
      anon_sym_for,
    ACTIONS(41), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(51), 1,
      anon_sym_import,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    STATE(36), 1,
      sym_comment,
    STATE(59), 1,
      sym__expression,
    STATE(282), 1,
      sym__statement,
    STATE(326), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(43), 2,
      sym_break_statement,
      sym_continue_statement,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
    STATE(290), 9,
      sym_return_statement,
      sym_assignment,
      sym_block,
      sym_variable_definition,
      sym_class_definition,
      sym_if_statement,
      sym_for_statement,
      sym_while_statement,
      sym_import_statement,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [4391] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(37), 1,
      sym_comment,
    ACTIONS(242), 26,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(244), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [4458] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(38), 1,
      sym_comment,
    ACTIONS(246), 26,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(248), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [4525] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(39), 1,
      sym_comment,
    ACTIONS(250), 26,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(252), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [4592] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(40), 1,
      sym_comment,
    ACTIONS(254), 26,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(256), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [4659] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(41), 1,
      sym_comment,
    ACTIONS(258), 26,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(260), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [4726] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(270), 1,
      anon_sym_LBRACE,
    ACTIONS(272), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      anon_sym_LBRACK,
    STATE(42), 1,
      sym_comment,
    STATE(72), 1,
      sym_call_body,
    ACTIONS(266), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(268), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(262), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_RBRACE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(264), 20,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [4804] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(270), 1,
      anon_sym_LBRACE,
    ACTIONS(272), 1,
      anon_sym_LPAREN,
    STATE(43), 1,
      sym_comment,
    STATE(72), 1,
      sym_call_body,
    ACTIONS(276), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(278), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [4876] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(284), 1,
      anon_sym_EQ,
    ACTIONS(290), 1,
      anon_sym_LBRACE,
    ACTIONS(292), 1,
      anon_sym_LPAREN,
    ACTIONS(294), 1,
      anon_sym_LBRACK,
    ACTIONS(296), 1,
      anon_sym_QMARK,
    ACTIONS(298), 1,
      anon_sym_DOT,
    ACTIONS(300), 1,
      anon_sym_DOT_DOT,
    ACTIONS(302), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(44), 1,
      sym_comment,
    STATE(101), 1,
      sym_call_body,
    ACTIONS(286), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(280), 8,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(288), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(282), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [4964] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(290), 1,
      anon_sym_LBRACE,
    ACTIONS(292), 1,
      anon_sym_LPAREN,
    STATE(45), 1,
      sym_comment,
    STATE(101), 1,
      sym_call_body,
    ACTIONS(276), 21,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(278), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5036] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(270), 1,
      anon_sym_LBRACE,
    STATE(46), 1,
      sym_comment,
    STATE(77), 1,
      sym_call_body,
    ACTIONS(304), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(306), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5106] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(290), 1,
      anon_sym_LBRACE,
    ACTIONS(292), 1,
      anon_sym_LPAREN,
    ACTIONS(294), 1,
      anon_sym_LBRACK,
    STATE(47), 1,
      sym_comment,
    STATE(101), 1,
      sym_call_body,
    ACTIONS(286), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(288), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(308), 10,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_RBRACE,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(310), 21,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5184] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(284), 1,
      anon_sym_EQ,
    ACTIONS(290), 1,
      anon_sym_LBRACE,
    ACTIONS(292), 1,
      anon_sym_LPAREN,
    ACTIONS(294), 1,
      anon_sym_LBRACK,
    ACTIONS(296), 1,
      anon_sym_QMARK,
    ACTIONS(298), 1,
      anon_sym_DOT,
    ACTIONS(300), 1,
      anon_sym_DOT_DOT,
    ACTIONS(302), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(48), 1,
      sym_comment,
    STATE(101), 1,
      sym_call_body,
    ACTIONS(286), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(312), 8,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(288), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(314), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5272] = 17,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(284), 1,
      anon_sym_EQ,
    ACTIONS(290), 1,
      anon_sym_LBRACE,
    ACTIONS(292), 1,
      anon_sym_LPAREN,
    ACTIONS(294), 1,
      anon_sym_LBRACK,
    ACTIONS(296), 1,
      anon_sym_QMARK,
    ACTIONS(298), 1,
      anon_sym_DOT,
    ACTIONS(300), 1,
      anon_sym_DOT_DOT,
    ACTIONS(302), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(316), 1,
      anon_sym_else,
    STATE(49), 1,
      sym_comment,
    STATE(101), 1,
      sym_call_body,
    ACTIONS(286), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(280), 8,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(288), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(282), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5362] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(270), 1,
      anon_sym_LBRACE,
    ACTIONS(272), 1,
      anon_sym_LPAREN,
    STATE(50), 1,
      sym_comment,
    STATE(72), 1,
      sym_call_body,
    ACTIONS(318), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(320), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5434] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(290), 1,
      anon_sym_LBRACE,
    ACTIONS(292), 1,
      anon_sym_LPAREN,
    ACTIONS(294), 1,
      anon_sym_LBRACK,
    STATE(51), 1,
      sym_comment,
    STATE(101), 1,
      sym_call_body,
    ACTIONS(286), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(262), 10,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_RBRACE,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(288), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(264), 21,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5512] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(270), 1,
      anon_sym_LBRACE,
    STATE(52), 1,
      sym_comment,
    STATE(78), 1,
      sym_call_body,
    ACTIONS(322), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(324), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5582] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(290), 1,
      anon_sym_LBRACE,
    STATE(53), 1,
      sym_comment,
    STATE(65), 1,
      sym_call_body,
    ACTIONS(304), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(306), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5652] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(270), 1,
      anon_sym_LBRACE,
    ACTIONS(272), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      anon_sym_LBRACK,
    STATE(54), 1,
      sym_comment,
    STATE(72), 1,
      sym_call_body,
    ACTIONS(266), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(268), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(308), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_RBRACE,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(310), 20,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5730] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(290), 1,
      anon_sym_LBRACE,
    ACTIONS(292), 1,
      anon_sym_LPAREN,
    STATE(55), 1,
      sym_comment,
    STATE(101), 1,
      sym_call_body,
    ACTIONS(318), 21,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(320), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5802] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(290), 1,
      anon_sym_LBRACE,
    STATE(56), 1,
      sym_comment,
    STATE(61), 1,
      sym_call_body,
    ACTIONS(322), 22,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(324), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5872] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(57), 1,
      sym_comment,
    ACTIONS(326), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(328), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [5937] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(58), 1,
      sym_comment,
    ACTIONS(254), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(256), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6002] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(270), 1,
      anon_sym_LBRACE,
    ACTIONS(272), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      anon_sym_LBRACK,
    ACTIONS(330), 1,
      anon_sym_EQ,
    ACTIONS(332), 1,
      anon_sym_QMARK,
    ACTIONS(334), 1,
      anon_sym_DOT,
    ACTIONS(336), 1,
      anon_sym_DOT_DOT,
    ACTIONS(338), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(59), 1,
      sym_comment,
    STATE(72), 1,
      sym_call_body,
    ACTIONS(266), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(312), 8,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(268), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(314), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6089] = 15,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(290), 1,
      anon_sym_LBRACE,
    ACTIONS(292), 1,
      anon_sym_LPAREN,
    ACTIONS(294), 1,
      anon_sym_LBRACK,
    ACTIONS(296), 1,
      anon_sym_QMARK,
    ACTIONS(298), 1,
      anon_sym_DOT,
    ACTIONS(300), 1,
      anon_sym_DOT_DOT,
    ACTIONS(302), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(60), 1,
      sym_comment,
    STATE(101), 1,
      sym_call_body,
    ACTIONS(286), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(340), 8,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(288), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(342), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6174] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(61), 1,
      sym_comment,
    ACTIONS(304), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(306), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6239] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(62), 1,
      sym_comment,
    ACTIONS(344), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(346), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6304] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(63), 1,
      sym_comment,
    ACTIONS(348), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(350), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6369] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(64), 1,
      sym_comment,
    ACTIONS(352), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(354), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6434] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(65), 1,
      sym_comment,
    ACTIONS(356), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(358), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6499] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(66), 1,
      sym_comment,
    ACTIONS(360), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(362), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6564] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(67), 1,
      sym_comment,
    ACTIONS(364), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(366), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6629] = 15,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(290), 1,
      anon_sym_LBRACE,
    ACTIONS(292), 1,
      anon_sym_LPAREN,
    ACTIONS(294), 1,
      anon_sym_LBRACK,
    ACTIONS(296), 1,
      anon_sym_QMARK,
    ACTIONS(298), 1,
      anon_sym_DOT,
    ACTIONS(300), 1,
      anon_sym_DOT_DOT,
    ACTIONS(302), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(68), 1,
      sym_comment,
    STATE(101), 1,
      sym_call_body,
    ACTIONS(286), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(368), 8,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(288), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(370), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6714] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(69), 1,
      sym_comment,
    ACTIONS(372), 24,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(374), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6779] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(70), 1,
      sym_comment,
    ACTIONS(376), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(378), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6844] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(71), 1,
      sym_comment,
    ACTIONS(352), 24,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(354), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6909] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(72), 1,
      sym_comment,
    ACTIONS(380), 24,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(382), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [6974] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(73), 1,
      sym_comment,
    ACTIONS(384), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(386), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7039] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(74), 1,
      sym_comment,
    ACTIONS(344), 24,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(346), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7104] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(75), 1,
      sym_comment,
    ACTIONS(388), 24,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(390), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7169] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(76), 1,
      sym_comment,
    ACTIONS(246), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(248), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7234] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(77), 1,
      sym_comment,
    ACTIONS(356), 24,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(358), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7299] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(78), 1,
      sym_comment,
    ACTIONS(304), 24,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(306), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7364] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(79), 1,
      sym_comment,
    ACTIONS(392), 24,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(394), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7429] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(80), 1,
      sym_comment,
    ACTIONS(372), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(374), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7494] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(81), 1,
      sym_comment,
    ACTIONS(396), 24,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(398), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7559] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(82), 1,
      sym_comment,
    ACTIONS(242), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(244), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7624] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(83), 1,
      sym_comment,
    ACTIONS(348), 24,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(350), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7689] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(84), 1,
      sym_comment,
    ACTIONS(360), 24,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(362), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7754] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(85), 1,
      sym_comment,
    ACTIONS(384), 24,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(386), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7819] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(86), 1,
      sym_comment,
    ACTIONS(326), 24,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(328), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7884] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(87), 1,
      sym_comment,
    ACTIONS(258), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(260), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [7949] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(88), 1,
      sym_comment,
    ACTIONS(400), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(402), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8014] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(89), 1,
      sym_comment,
    ACTIONS(392), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(394), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8079] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(90), 1,
      sym_comment,
    ACTIONS(404), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(406), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8144] = 17,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(270), 1,
      anon_sym_LBRACE,
    ACTIONS(272), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      anon_sym_LBRACK,
    ACTIONS(330), 1,
      anon_sym_EQ,
    ACTIONS(332), 1,
      anon_sym_QMARK,
    ACTIONS(334), 1,
      anon_sym_DOT,
    ACTIONS(336), 1,
      anon_sym_DOT_DOT,
    ACTIONS(338), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(412), 1,
      anon_sym_COLON,
    STATE(72), 1,
      sym_call_body,
    STATE(91), 1,
      sym_comment,
    ACTIONS(266), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(410), 7,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(268), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8233] = 15,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(290), 1,
      anon_sym_LBRACE,
    ACTIONS(292), 1,
      anon_sym_LPAREN,
    ACTIONS(294), 1,
      anon_sym_LBRACK,
    ACTIONS(296), 1,
      anon_sym_QMARK,
    ACTIONS(298), 1,
      anon_sym_DOT,
    ACTIONS(300), 1,
      anon_sym_DOT_DOT,
    ACTIONS(302), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(92), 1,
      sym_comment,
    STATE(101), 1,
      sym_call_body,
    ACTIONS(286), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(414), 8,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(288), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(416), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8318] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(93), 1,
      sym_comment,
    ACTIONS(376), 24,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(378), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8383] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(94), 1,
      sym_comment,
    ACTIONS(418), 8,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(362), 10,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(360), 15,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(420), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8452] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(95), 1,
      sym_comment,
    ACTIONS(422), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(424), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8517] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(96), 1,
      sym_comment,
    ACTIONS(400), 24,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(402), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8582] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(97), 1,
      sym_comment,
    ACTIONS(360), 24,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(362), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8647] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(98), 1,
      sym_comment,
    ACTIONS(360), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(362), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8712] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(99), 1,
      sym_comment,
    ACTIONS(426), 24,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(428), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8777] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(100), 1,
      sym_comment,
    ACTIONS(404), 24,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(406), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8842] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(101), 1,
      sym_comment,
    ACTIONS(380), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(382), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8907] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(102), 1,
      sym_comment,
    ACTIONS(422), 24,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(424), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [8972] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(103), 1,
      sym_comment,
    ACTIONS(426), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(428), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [9037] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(104), 1,
      sym_comment,
    ACTIONS(388), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(390), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [9102] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(105), 1,
      sym_comment,
    ACTIONS(396), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(398), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [9167] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(270), 1,
      anon_sym_LBRACE,
    ACTIONS(272), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      anon_sym_LBRACK,
    ACTIONS(330), 1,
      anon_sym_EQ,
    ACTIONS(332), 1,
      anon_sym_QMARK,
    ACTIONS(334), 1,
      anon_sym_DOT,
    ACTIONS(336), 1,
      anon_sym_DOT_DOT,
    ACTIONS(338), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(72), 1,
      sym_call_body,
    STATE(106), 1,
      sym_comment,
    ACTIONS(266), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(410), 8,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(268), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(408), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [9254] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(107), 1,
      sym_comment,
    ACTIONS(364), 24,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(366), 27,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [9319] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(108), 1,
      sym_comment,
    ACTIONS(250), 23,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
    ACTIONS(252), 28,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_EQ,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_var,
      anon_sym_class,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [9384] = 15,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(270), 1,
      anon_sym_LBRACE,
    ACTIONS(272), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      anon_sym_LBRACK,
    ACTIONS(332), 1,
      anon_sym_QMARK,
    ACTIONS(334), 1,
      anon_sym_DOT,
    ACTIONS(336), 1,
      anon_sym_DOT_DOT,
    ACTIONS(338), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(72), 1,
      sym_call_body,
    STATE(109), 1,
      sym_comment,
    ACTIONS(266), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(340), 8,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(268), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(342), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [9468] = 15,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(270), 1,
      anon_sym_LBRACE,
    ACTIONS(272), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      anon_sym_LBRACK,
    ACTIONS(332), 1,
      anon_sym_QMARK,
    ACTIONS(334), 1,
      anon_sym_DOT,
    ACTIONS(336), 1,
      anon_sym_DOT_DOT,
    ACTIONS(338), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(72), 1,
      sym_call_body,
    STATE(110), 1,
      sym_comment,
    ACTIONS(266), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(368), 8,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(268), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(370), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [9552] = 15,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(270), 1,
      anon_sym_LBRACE,
    ACTIONS(272), 1,
      anon_sym_LPAREN,
    ACTIONS(274), 1,
      anon_sym_LBRACK,
    ACTIONS(332), 1,
      anon_sym_QMARK,
    ACTIONS(334), 1,
      anon_sym_DOT,
    ACTIONS(336), 1,
      anon_sym_DOT_DOT,
    ACTIONS(338), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(72), 1,
      sym_call_body,
    STATE(111), 1,
      sym_comment,
    ACTIONS(266), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(414), 8,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(268), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
    ACTIONS(416), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [9636] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(112), 1,
      sym_comment,
    ACTIONS(418), 8,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_RBRACE,
      anon_sym_POUND_BANG,
    ACTIONS(362), 10,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(360), 15,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(420), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_BANG,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [9704] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_LPAREN,
    STATE(113), 1,
      sym_comment,
    STATE(122), 1,
      sym_call_body,
    ACTIONS(320), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(318), 19,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [9762] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    STATE(114), 1,
      sym_comment,
    STATE(137), 1,
      sym_call_body,
    ACTIONS(324), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(322), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [9818] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_LPAREN,
    STATE(115), 1,
      sym_comment,
    STATE(122), 1,
      sym_call_body,
    ACTIONS(278), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(276), 19,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [9876] = 15,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_LPAREN,
    ACTIONS(442), 1,
      anon_sym_LBRACK,
    ACTIONS(444), 1,
      anon_sym_QMARK,
    ACTIONS(446), 1,
      anon_sym_DOT,
    ACTIONS(448), 1,
      anon_sym_DOT_DOT,
    ACTIONS(450), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(116), 1,
      sym_comment,
    STATE(122), 1,
      sym_call_body,
    ACTIONS(436), 6,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
    ACTIONS(434), 7,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
    ACTIONS(438), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(440), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
  [9948] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_LPAREN,
    ACTIONS(442), 1,
      anon_sym_LBRACK,
    STATE(117), 1,
      sym_comment,
    STATE(122), 1,
      sym_call_body,
    ACTIONS(438), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(262), 8,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(264), 9,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(440), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
  [10012] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_LPAREN,
    ACTIONS(442), 1,
      anon_sym_LBRACK,
    STATE(118), 1,
      sym_comment,
    STATE(122), 1,
      sym_call_body,
    ACTIONS(438), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
    ACTIONS(308), 8,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(310), 9,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(440), 10,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
  [10076] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    STATE(119), 1,
      sym_comment,
    STATE(143), 1,
      sym_call_body,
    ACTIONS(306), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(304), 20,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10132] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(120), 1,
      sym_comment,
    ACTIONS(362), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(360), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10183] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(121), 1,
      sym_comment,
    ACTIONS(328), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(326), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10234] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(122), 1,
      sym_comment,
    ACTIONS(382), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(380), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10285] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(123), 1,
      sym_comment,
    ACTIONS(406), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(404), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10336] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(124), 1,
      sym_comment,
    ACTIONS(398), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(396), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10387] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(125), 1,
      sym_comment,
    ACTIONS(256), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(254), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10438] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(126), 1,
      sym_comment,
    ACTIONS(424), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(422), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10489] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(127), 1,
      sym_comment,
    ACTIONS(252), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(250), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10540] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(128), 1,
      sym_comment,
    ACTIONS(428), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(426), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10591] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(129), 1,
      sym_comment,
    ACTIONS(374), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(372), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10642] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(130), 1,
      sym_comment,
    ACTIONS(244), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(242), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10693] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(131), 1,
      sym_comment,
    ACTIONS(260), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(258), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10744] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(132), 1,
      sym_comment,
    ACTIONS(390), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(388), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10795] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(133), 1,
      sym_comment,
    ACTIONS(402), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(400), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10846] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(134), 1,
      sym_comment,
    ACTIONS(346), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(344), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10897] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(135), 1,
      sym_comment,
    ACTIONS(366), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(364), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10948] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(136), 1,
      sym_comment,
    ACTIONS(248), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(246), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [10999] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(137), 1,
      sym_comment,
    ACTIONS(306), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(304), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [11050] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(138), 1,
      sym_comment,
    ACTIONS(354), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(352), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [11101] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(139), 1,
      sym_comment,
    ACTIONS(394), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(392), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [11152] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(140), 1,
      sym_comment,
    ACTIONS(350), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(348), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [11203] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(141), 1,
      sym_comment,
    ACTIONS(386), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(384), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [11254] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(142), 1,
      sym_comment,
    ACTIONS(378), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(376), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [11305] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(143), 1,
      sym_comment,
    ACTIONS(358), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_is,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(356), 21,
      anon_sym_RPAREN,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_DOT_DOT_DOT,
  [11356] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(144), 1,
      sym_comment,
    ACTIONS(256), 9,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_POUND,
    ACTIONS(254), 25,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_class,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
  [11404] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(145), 1,
      sym_comment,
    ACTIONS(260), 9,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_POUND,
    ACTIONS(258), 25,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_class,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
  [11452] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(146), 1,
      sym_comment,
    ACTIONS(248), 9,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_POUND,
    ACTIONS(246), 25,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_class,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
  [11500] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(147), 1,
      sym_comment,
    ACTIONS(244), 9,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_POUND,
    ACTIONS(242), 25,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_class,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
  [11548] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(148), 1,
      sym_comment,
    ACTIONS(252), 9,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
      anon_sym_POUND,
    ACTIONS(250), 25,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_class,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_POUND_BANG,
  [11596] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    STATE(149), 1,
      sym_comment,
    STATE(173), 1,
      sym_call_body,
    ACTIONS(320), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(318), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [11648] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    STATE(150), 1,
      sym_comment,
    STATE(173), 1,
      sym_call_body,
    ACTIONS(278), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(276), 21,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [11700] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    STATE(151), 1,
      sym_comment,
    STATE(180), 1,
      sym_call_body,
    ACTIONS(324), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(322), 22,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [11750] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    STATE(152), 1,
      sym_comment,
    STATE(173), 1,
      sym_call_body,
    ACTIONS(310), 4,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(308), 7,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [11808] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    STATE(153), 1,
      sym_comment,
    STATE(172), 1,
      sym_call_body,
    ACTIONS(306), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(304), 22,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [11858] = 11,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    STATE(154), 1,
      sym_comment,
    STATE(173), 1,
      sym_call_body,
    ACTIONS(264), 4,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(262), 7,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [11916] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(155), 1,
      sym_comment,
    ACTIONS(424), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(422), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [11961] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    ACTIONS(464), 1,
      anon_sym_RBRACE,
    STATE(156), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(450), 1,
      sym_pair,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [12032] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    ACTIONS(466), 1,
      anon_sym_RBRACE,
    STATE(157), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(450), 1,
      sym_pair,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [12103] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    ACTIONS(468), 1,
      anon_sym_RBRACE,
    STATE(158), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(425), 1,
      sym_pair,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [12174] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    ACTIONS(470), 1,
      anon_sym_RPAREN,
    STATE(159), 1,
      sym_comment,
    STATE(250), 1,
      sym__expression,
    STATE(529), 1,
      sym_argument_list,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [12245] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    ACTIONS(472), 1,
      anon_sym_RBRACE,
    STATE(160), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(450), 1,
      sym_pair,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [12316] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    ACTIONS(474), 1,
      anon_sym_RBRACE,
    STATE(161), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(414), 1,
      sym_pair,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [12387] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(162), 1,
      sym_comment,
    ACTIONS(374), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(372), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [12432] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    ACTIONS(476), 1,
      anon_sym_RBRACE,
    STATE(163), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(450), 1,
      sym_pair,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [12503] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    ACTIONS(478), 1,
      anon_sym_RPAREN,
    STATE(164), 1,
      sym_comment,
    STATE(250), 1,
      sym__expression,
    STATE(490), 1,
      sym_argument_list,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [12574] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(165), 1,
      sym_comment,
    ACTIONS(386), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(384), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [12619] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(166), 1,
      sym_comment,
    ACTIONS(378), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(376), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [12664] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(484), 1,
      anon_sym_COMMA,
    STATE(167), 2,
      sym_comment,
      aux_sym_import_statement_repeat1,
    ACTIONS(480), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(482), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [12711] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    ACTIONS(487), 1,
      anon_sym_RBRACE,
    STATE(168), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(450), 1,
      sym_pair,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [12782] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(169), 1,
      sym_comment,
    ACTIONS(406), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(404), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [12827] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    ACTIONS(489), 1,
      anon_sym_RPAREN,
    STATE(170), 1,
      sym_comment,
    STATE(250), 1,
      sym__expression,
    STATE(511), 1,
      sym_argument_list,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [12898] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(491), 1,
      anon_sym_DQUOTE,
    ACTIONS(493), 1,
      anon_sym_RPAREN,
    ACTIONS(495), 1,
      aux_sym_raw_string_token1,
    ACTIONS(501), 1,
      aux_sym_number_token1,
    ACTIONS(503), 1,
      aux_sym_number_token4,
    ACTIONS(509), 1,
      anon_sym_DASH,
    ACTIONS(511), 1,
      anon_sym_LBRACE,
    ACTIONS(513), 1,
      anon_sym_LBRACK,
    STATE(116), 1,
      sym__expression,
    STATE(171), 1,
      sym_comment,
    STATE(189), 1,
      aux_sym_string_repeat1,
    ACTIONS(497), 2,
      sym_static_field,
      sym_field,
    ACTIONS(499), 2,
      sym_name,
      sym_null,
    ACTIONS(505), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(507), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(129), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [12969] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(172), 1,
      sym_comment,
    ACTIONS(358), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(356), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [13014] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(173), 1,
      sym_comment,
    ACTIONS(382), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(380), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [13059] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(519), 1,
      anon_sym_COMMA,
    STATE(167), 1,
      aux_sym_import_statement_repeat1,
    STATE(174), 1,
      sym_comment,
    ACTIONS(515), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(517), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [13108] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    ACTIONS(521), 1,
      anon_sym_RBRACE,
    STATE(175), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(450), 1,
      sym_pair,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [13179] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    ACTIONS(523), 1,
      anon_sym_RPAREN,
    STATE(176), 1,
      sym_comment,
    STATE(250), 1,
      sym__expression,
    STATE(488), 1,
      sym_argument_list,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [13250] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(177), 1,
      sym_comment,
    ACTIONS(354), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(352), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [13295] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(178), 1,
      sym_comment,
    ACTIONS(346), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(344), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [13340] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    ACTIONS(525), 1,
      anon_sym_RBRACE,
    STATE(179), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(384), 1,
      sym_pair,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [13411] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(180), 1,
      sym_comment,
    ACTIONS(306), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(304), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [13456] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(181), 1,
      sym_comment,
    ACTIONS(394), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(392), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [13501] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(519), 1,
      anon_sym_COMMA,
    STATE(174), 1,
      aux_sym_import_statement_repeat1,
    STATE(182), 1,
      sym_comment,
    ACTIONS(527), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(529), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [13550] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(183), 1,
      sym_comment,
    ACTIONS(398), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(396), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [13595] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(535), 1,
      anon_sym_as,
    STATE(184), 1,
      sym_comment,
    ACTIONS(531), 12,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(533), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [13642] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(185), 1,
      sym_comment,
    ACTIONS(428), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(426), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [13687] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    ACTIONS(537), 1,
      anon_sym_RBRACE,
    STATE(186), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(450), 1,
      sym_pair,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [13758] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    ACTIONS(539), 1,
      anon_sym_RBRACE,
    STATE(187), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(386), 1,
      sym_pair,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [13829] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(188), 1,
      sym_comment,
    ACTIONS(390), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(388), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [13874] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(491), 1,
      anon_sym_DQUOTE,
    ACTIONS(495), 1,
      aux_sym_raw_string_token1,
    ACTIONS(501), 1,
      aux_sym_number_token1,
    ACTIONS(503), 1,
      aux_sym_number_token4,
    ACTIONS(509), 1,
      anon_sym_DASH,
    ACTIONS(511), 1,
      anon_sym_LBRACE,
    ACTIONS(513), 1,
      anon_sym_LBRACK,
    ACTIONS(541), 1,
      anon_sym_RPAREN,
    STATE(116), 1,
      sym__expression,
    STATE(189), 1,
      sym_comment,
    STATE(196), 1,
      aux_sym_string_repeat1,
    ACTIONS(497), 2,
      sym_static_field,
      sym_field,
    ACTIONS(499), 2,
      sym_name,
      sym_null,
    ACTIONS(505), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(507), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(129), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [13945] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(190), 1,
      sym_comment,
    ACTIONS(350), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(348), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [13990] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(191), 1,
      sym_comment,
    ACTIONS(366), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(364), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [14035] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(192), 1,
      sym_comment,
    ACTIONS(402), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(400), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [14080] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(193), 1,
      sym_comment,
    ACTIONS(328), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(326), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [14125] = 18,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    ACTIONS(543), 1,
      anon_sym_RBRACE,
    STATE(194), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(450), 1,
      sym_pair,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [14196] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(195), 1,
      sym_comment,
    ACTIONS(362), 8,
      anon_sym_EQ,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_DOT,
      anon_sym_DOT_DOT,
    ACTIONS(360), 23,
      anon_sym_RPAREN,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
  [14241] = 17,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(545), 1,
      anon_sym_DQUOTE,
    ACTIONS(548), 1,
      anon_sym_RPAREN,
    ACTIONS(550), 1,
      aux_sym_raw_string_token1,
    ACTIONS(559), 1,
      aux_sym_number_token1,
    ACTIONS(562), 1,
      aux_sym_number_token4,
    ACTIONS(571), 1,
      anon_sym_DASH,
    ACTIONS(574), 1,
      anon_sym_LBRACE,
    ACTIONS(577), 1,
      anon_sym_LBRACK,
    STATE(116), 1,
      sym__expression,
    ACTIONS(553), 2,
      sym_static_field,
      sym_field,
    ACTIONS(556), 2,
      sym_name,
      sym_null,
    ACTIONS(565), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(568), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(196), 2,
      sym_comment,
      aux_sym_string_repeat1,
    STATE(129), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [14310] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(580), 1,
      anon_sym_COMMA,
    STATE(197), 1,
      sym_comment,
    STATE(206), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(515), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(517), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [14358] = 17,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    ACTIONS(582), 1,
      anon_sym_RBRACK,
    STATE(198), 1,
      sym_comment,
    STATE(281), 1,
      sym__expression,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [14426] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(199), 1,
      sym_comment,
    ACTIONS(531), 12,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(533), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [14470] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(580), 1,
      anon_sym_COMMA,
    STATE(197), 1,
      aux_sym_import_statement_repeat1,
    STATE(200), 1,
      sym_comment,
    ACTIONS(527), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(529), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [14518] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(584), 1,
      anon_sym_as,
    STATE(201), 1,
      sym_comment,
    ACTIONS(531), 12,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(533), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [14564] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(202), 1,
      sym_comment,
    ACTIONS(586), 12,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(588), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [14608] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(203), 1,
      sym_comment,
    ACTIONS(480), 12,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(482), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [14652] = 17,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(204), 1,
      sym_comment,
    STATE(250), 1,
      sym__expression,
    STATE(486), 1,
      sym_argument_list,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [14720] = 17,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    ACTIONS(590), 1,
      anon_sym_RBRACK,
    STATE(205), 1,
      sym_comment,
    STATE(280), 1,
      sym__expression,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [14788] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(592), 1,
      anon_sym_COMMA,
    STATE(206), 2,
      sym_comment,
      aux_sym_import_statement_repeat1,
    ACTIONS(480), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(482), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [14834] = 17,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(207), 1,
      sym_comment,
    STATE(304), 1,
      sym__expression,
    STATE(450), 1,
      sym_pair,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [14902] = 17,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    ACTIONS(595), 1,
      anon_sym_RBRACK,
    STATE(208), 1,
      sym_comment,
    STATE(274), 1,
      sym__expression,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [14970] = 17,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(209), 1,
      sym_comment,
    STATE(250), 1,
      sym__expression,
    STATE(513), 1,
      sym_argument_list,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [15038] = 17,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    ACTIONS(597), 1,
      anon_sym_RBRACK,
    STATE(210), 1,
      sym_comment,
    STATE(275), 1,
      sym__expression,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [15106] = 17,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(211), 1,
      sym_comment,
    STATE(250), 1,
      sym__expression,
    STATE(522), 1,
      sym_argument_list,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [15174] = 17,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(212), 1,
      sym_comment,
    STATE(250), 1,
      sym__expression,
    STATE(518), 1,
      sym_argument_list,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [15242] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(154), 1,
      sym__expression,
    STATE(213), 1,
      sym_comment,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [15307] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(214), 1,
      sym_comment,
    ACTIONS(599), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(601), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [15350] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(603), 1,
      anon_sym_LBRACE,
    STATE(42), 1,
      sym__expression,
    STATE(215), 1,
      sym_comment,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [15415] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(180), 1,
      anon_sym_DQUOTE,
    ACTIONS(182), 1,
      aux_sym_raw_string_token1,
    ACTIONS(188), 1,
      aux_sym_number_token1,
    ACTIONS(190), 1,
      aux_sym_number_token4,
    ACTIONS(198), 1,
      anon_sym_DASH,
    ACTIONS(206), 1,
      anon_sym_LBRACK,
    ACTIONS(605), 1,
      anon_sym_LBRACE,
    STATE(47), 1,
      sym__expression,
    STATE(216), 1,
      sym_comment,
    ACTIONS(184), 2,
      sym_static_field,
      sym_field,
    ACTIONS(186), 2,
      sym_name,
      sym_null,
    ACTIONS(192), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(196), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(80), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [15480] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(217), 1,
      sym_comment,
    STATE(296), 1,
      sym__expression,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [15545] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(603), 1,
      anon_sym_LBRACE,
    STATE(110), 1,
      sym__expression,
    STATE(218), 1,
      sym_comment,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [15610] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(180), 1,
      anon_sym_DQUOTE,
    ACTIONS(182), 1,
      aux_sym_raw_string_token1,
    ACTIONS(188), 1,
      aux_sym_number_token1,
    ACTIONS(190), 1,
      aux_sym_number_token4,
    ACTIONS(198), 1,
      anon_sym_DASH,
    ACTIONS(206), 1,
      anon_sym_LBRACK,
    ACTIONS(605), 1,
      anon_sym_LBRACE,
    STATE(55), 1,
      sym__expression,
    STATE(219), 1,
      sym_comment,
    ACTIONS(184), 2,
      sym_static_field,
      sym_field,
    ACTIONS(186), 2,
      sym_name,
      sym_null,
    ACTIONS(192), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(196), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(80), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [15675] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(220), 1,
      sym_comment,
    STATE(266), 1,
      sym__expression,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [15740] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(221), 1,
      sym_comment,
    ACTIONS(586), 12,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(588), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [15783] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(222), 1,
      sym_comment,
    ACTIONS(480), 12,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(482), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [15826] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(603), 1,
      anon_sym_LBRACE,
    STATE(43), 1,
      sym__expression,
    STATE(223), 1,
      sym_comment,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [15891] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(224), 1,
      sym_comment,
    STATE(299), 1,
      sym__expression,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [15956] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(225), 1,
      sym_comment,
    STATE(302), 1,
      sym__expression,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [16021] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(226), 1,
      sym_comment,
    ACTIONS(607), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(609), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [16064] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(603), 1,
      anon_sym_LBRACE,
    STATE(111), 1,
      sym__expression,
    STATE(227), 1,
      sym_comment,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [16129] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(228), 1,
      sym_comment,
    STATE(294), 1,
      sym__expression,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [16194] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(180), 1,
      anon_sym_DQUOTE,
    ACTIONS(182), 1,
      aux_sym_raw_string_token1,
    ACTIONS(188), 1,
      aux_sym_number_token1,
    ACTIONS(190), 1,
      aux_sym_number_token4,
    ACTIONS(198), 1,
      anon_sym_DASH,
    ACTIONS(206), 1,
      anon_sym_LBRACK,
    ACTIONS(605), 1,
      anon_sym_LBRACE,
    STATE(45), 1,
      sym__expression,
    STATE(229), 1,
      sym_comment,
    ACTIONS(184), 2,
      sym_static_field,
      sym_field,
    ACTIONS(186), 2,
      sym_name,
      sym_null,
    ACTIONS(192), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(196), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(80), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [16259] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(230), 1,
      sym_comment,
    STATE(291), 1,
      sym__expression,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [16324] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(231), 1,
      sym_comment,
    STATE(295), 1,
      sym__expression,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [16389] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(232), 1,
      sym_comment,
    STATE(298), 1,
      sym__expression,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [16454] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(491), 1,
      anon_sym_DQUOTE,
    ACTIONS(495), 1,
      aux_sym_raw_string_token1,
    ACTIONS(501), 1,
      aux_sym_number_token1,
    ACTIONS(503), 1,
      aux_sym_number_token4,
    ACTIONS(509), 1,
      anon_sym_DASH,
    ACTIONS(511), 1,
      anon_sym_LBRACE,
    ACTIONS(513), 1,
      anon_sym_LBRACK,
    STATE(118), 1,
      sym__expression,
    STATE(233), 1,
      sym_comment,
    ACTIONS(497), 2,
      sym_static_field,
      sym_field,
    ACTIONS(499), 2,
      sym_name,
      sym_null,
    ACTIONS(505), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(507), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(129), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [16519] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(491), 1,
      anon_sym_DQUOTE,
    ACTIONS(495), 1,
      aux_sym_raw_string_token1,
    ACTIONS(501), 1,
      aux_sym_number_token1,
    ACTIONS(503), 1,
      aux_sym_number_token4,
    ACTIONS(509), 1,
      anon_sym_DASH,
    ACTIONS(511), 1,
      anon_sym_LBRACE,
    ACTIONS(513), 1,
      anon_sym_LBRACK,
    STATE(113), 1,
      sym__expression,
    STATE(234), 1,
      sym_comment,
    ACTIONS(497), 2,
      sym_static_field,
      sym_field,
    ACTIONS(499), 2,
      sym_name,
      sym_null,
    ACTIONS(505), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(507), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(129), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [16584] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(235), 1,
      sym_comment,
    STATE(301), 1,
      sym__expression,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [16649] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(236), 1,
      sym_comment,
    STATE(292), 1,
      sym__expression,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [16714] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(237), 1,
      sym_comment,
    STATE(297), 1,
      sym__expression,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [16779] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(491), 1,
      anon_sym_DQUOTE,
    ACTIONS(495), 1,
      aux_sym_raw_string_token1,
    ACTIONS(501), 1,
      aux_sym_number_token1,
    ACTIONS(503), 1,
      aux_sym_number_token4,
    ACTIONS(509), 1,
      anon_sym_DASH,
    ACTIONS(511), 1,
      anon_sym_LBRACE,
    ACTIONS(513), 1,
      anon_sym_LBRACK,
    STATE(115), 1,
      sym__expression,
    STATE(238), 1,
      sym_comment,
    ACTIONS(497), 2,
      sym_static_field,
      sym_field,
    ACTIONS(499), 2,
      sym_name,
      sym_null,
    ACTIONS(505), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(507), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(129), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [16844] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(239), 1,
      sym_comment,
    ACTIONS(242), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(244), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [16887] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(240), 1,
      sym_comment,
    ACTIONS(611), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(613), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [16930] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(241), 1,
      sym_comment,
    ACTIONS(615), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(617), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [16973] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(242), 1,
      sym_comment,
    ACTIONS(246), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(248), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [17016] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(180), 1,
      anon_sym_DQUOTE,
    ACTIONS(182), 1,
      aux_sym_raw_string_token1,
    ACTIONS(188), 1,
      aux_sym_number_token1,
    ACTIONS(190), 1,
      aux_sym_number_token4,
    ACTIONS(198), 1,
      anon_sym_DASH,
    ACTIONS(206), 1,
      anon_sym_LBRACK,
    ACTIONS(605), 1,
      anon_sym_LBRACE,
    STATE(68), 1,
      sym__expression,
    STATE(243), 1,
      sym_comment,
    ACTIONS(184), 2,
      sym_static_field,
      sym_field,
    ACTIONS(186), 2,
      sym_name,
      sym_null,
    ACTIONS(192), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(196), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(80), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [17081] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(150), 1,
      sym__expression,
    STATE(244), 1,
      sym_comment,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [17146] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(245), 1,
      sym_comment,
    ACTIONS(619), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(621), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [17189] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(603), 1,
      anon_sym_LBRACE,
    STATE(54), 1,
      sym__expression,
    STATE(246), 1,
      sym_comment,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [17254] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(247), 1,
      sym_comment,
    STATE(303), 1,
      sym__expression,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [17319] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(248), 1,
      sym_comment,
    STATE(305), 1,
      sym__expression,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [17384] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(249), 1,
      sym_comment,
    STATE(293), 1,
      sym__expression,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [17449] = 17,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(623), 1,
      anon_sym_RPAREN,
    ACTIONS(625), 1,
      anon_sym_COMMA,
    ACTIONS(627), 1,
      anon_sym_PIPE,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(173), 1,
      sym_call_body,
    STATE(250), 1,
      sym_comment,
    STATE(376), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [17516] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(603), 1,
      anon_sym_LBRACE,
    STATE(50), 1,
      sym__expression,
    STATE(251), 1,
      sym_comment,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [17581] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      aux_sym_raw_string_token1,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(27), 1,
      anon_sym_DASH,
    ACTIONS(35), 1,
      anon_sym_LBRACK,
    ACTIONS(603), 1,
      anon_sym_LBRACE,
    STATE(109), 1,
      sym__expression,
    STATE(252), 1,
      sym_comment,
    ACTIONS(13), 2,
      sym_static_field,
      sym_field,
    ACTIONS(15), 2,
      sym_name,
      sym_null,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(69), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [17646] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(180), 1,
      anon_sym_DQUOTE,
    ACTIONS(182), 1,
      aux_sym_raw_string_token1,
    ACTIONS(188), 1,
      aux_sym_number_token1,
    ACTIONS(190), 1,
      aux_sym_number_token4,
    ACTIONS(198), 1,
      anon_sym_DASH,
    ACTIONS(206), 1,
      anon_sym_LBRACK,
    ACTIONS(605), 1,
      anon_sym_LBRACE,
    STATE(51), 1,
      sym__expression,
    STATE(253), 1,
      sym_comment,
    ACTIONS(184), 2,
      sym_static_field,
      sym_field,
    ACTIONS(186), 2,
      sym_name,
      sym_null,
    ACTIONS(192), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(196), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(80), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [17711] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(491), 1,
      anon_sym_DQUOTE,
    ACTIONS(495), 1,
      aux_sym_raw_string_token1,
    ACTIONS(501), 1,
      aux_sym_number_token1,
    ACTIONS(503), 1,
      aux_sym_number_token4,
    ACTIONS(509), 1,
      anon_sym_DASH,
    ACTIONS(511), 1,
      anon_sym_LBRACE,
    ACTIONS(513), 1,
      anon_sym_LBRACK,
    STATE(117), 1,
      sym__expression,
    STATE(254), 1,
      sym_comment,
    ACTIONS(497), 2,
      sym_static_field,
      sym_field,
    ACTIONS(499), 2,
      sym_name,
      sym_null,
    ACTIONS(505), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(507), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(129), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [17776] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(255), 1,
      sym_comment,
    ACTIONS(531), 12,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(533), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [17819] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(641), 1,
      anon_sym_for,
    STATE(256), 1,
      sym_comment,
    ACTIONS(637), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(639), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [17864] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(180), 1,
      anon_sym_DQUOTE,
    ACTIONS(182), 1,
      aux_sym_raw_string_token1,
    ACTIONS(188), 1,
      aux_sym_number_token1,
    ACTIONS(190), 1,
      aux_sym_number_token4,
    ACTIONS(198), 1,
      anon_sym_DASH,
    ACTIONS(206), 1,
      anon_sym_LBRACK,
    ACTIONS(605), 1,
      anon_sym_LBRACE,
    STATE(60), 1,
      sym__expression,
    STATE(257), 1,
      sym_comment,
    ACTIONS(184), 2,
      sym_static_field,
      sym_field,
    ACTIONS(186), 2,
      sym_name,
      sym_null,
    ACTIONS(192), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(196), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(80), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [17929] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(149), 1,
      sym__expression,
    STATE(258), 1,
      sym_comment,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [17994] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(152), 1,
      sym__expression,
    STATE(259), 1,
      sym_comment,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [18059] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(260), 1,
      sym_comment,
    ACTIONS(312), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(314), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [18102] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(261), 1,
      sym_comment,
    ACTIONS(280), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(282), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [18145] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(262), 1,
      sym_comment,
    ACTIONS(643), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(645), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [18188] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(263), 1,
      sym_comment,
    ACTIONS(647), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(649), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [18231] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(264), 1,
      sym_comment,
    ACTIONS(651), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(653), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [18274] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(316), 1,
      anon_sym_else,
    STATE(265), 1,
      sym_comment,
    ACTIONS(280), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(282), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [18319] = 15,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(657), 1,
      anon_sym_PIPE,
    STATE(173), 1,
      sym_call_body,
    STATE(266), 1,
      sym_comment,
    ACTIONS(655), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [18382] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(267), 1,
      sym_comment,
    ACTIONS(659), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(661), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [18425] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(180), 1,
      anon_sym_DQUOTE,
    ACTIONS(182), 1,
      aux_sym_raw_string_token1,
    ACTIONS(188), 1,
      aux_sym_number_token1,
    ACTIONS(190), 1,
      aux_sym_number_token4,
    ACTIONS(198), 1,
      anon_sym_DASH,
    ACTIONS(206), 1,
      anon_sym_LBRACK,
    ACTIONS(605), 1,
      anon_sym_LBRACE,
    STATE(92), 1,
      sym__expression,
    STATE(268), 1,
      sym_comment,
    ACTIONS(184), 2,
      sym_static_field,
      sym_field,
    ACTIONS(186), 2,
      sym_name,
      sym_null,
    ACTIONS(192), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(196), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(80), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [18490] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(269), 1,
      sym_comment,
    ACTIONS(663), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(665), 18,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [18533] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(270), 1,
      sym_comment,
    STATE(308), 1,
      sym__expression,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [18598] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(218), 1,
      anon_sym_DQUOTE,
    ACTIONS(220), 1,
      aux_sym_raw_string_token1,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(234), 1,
      anon_sym_DASH,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(462), 1,
      anon_sym_LBRACE,
    STATE(271), 1,
      sym_comment,
    STATE(307), 1,
      sym__expression,
    ACTIONS(222), 2,
      sym_static_field,
      sym_field,
    ACTIONS(224), 2,
      sym_name,
      sym_null,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(232), 2,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(162), 13,
      sym_string,
      sym_raw_string,
      sym_number,
      sym_boolean,
      sym_unary_expression,
      sym_binary_expression,
      sym_call_expression,
      sym_conditional,
      sym_list,
      sym_index_expression,
      sym_subscript,
      sym_range,
      sym_map,
  [18663] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(272), 1,
      sym_comment,
    ACTIONS(647), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(649), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [18705] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(273), 1,
      sym_comment,
    ACTIONS(599), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(601), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [18747] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(625), 1,
      anon_sym_COMMA,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(667), 1,
      anon_sym_RBRACK,
    STATE(173), 1,
      sym_call_body,
    STATE(274), 1,
      sym_comment,
    STATE(432), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [18811] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(625), 1,
      anon_sym_COMMA,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(669), 1,
      anon_sym_RBRACK,
    STATE(173), 1,
      sym_call_body,
    STATE(275), 1,
      sym_comment,
    STATE(405), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [18875] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(276), 1,
      sym_comment,
    ACTIONS(651), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(653), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [18917] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(277), 1,
      sym_comment,
    ACTIONS(659), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(661), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [18959] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(278), 1,
      sym_comment,
    ACTIONS(246), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(248), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [19001] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(279), 1,
      sym_comment,
    ACTIONS(410), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(408), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [19043] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(625), 1,
      anon_sym_COMMA,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(671), 1,
      anon_sym_RBRACK,
    STATE(173), 1,
      sym_call_body,
    STATE(280), 1,
      sym_comment,
    STATE(426), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [19107] = 16,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(625), 1,
      anon_sym_COMMA,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(673), 1,
      anon_sym_RBRACK,
    STATE(173), 1,
      sym_call_body,
    STATE(281), 1,
      sym_comment,
    STATE(403), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [19171] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(282), 1,
      sym_comment,
    ACTIONS(312), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(314), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [19213] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(283), 1,
      sym_comment,
    ACTIONS(611), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(613), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [19255] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(675), 1,
      anon_sym_for,
    STATE(284), 1,
      sym_comment,
    ACTIONS(637), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(639), 16,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [19299] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(285), 1,
      sym_comment,
    ACTIONS(607), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(609), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [19341] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(286), 1,
      sym_comment,
    ACTIONS(663), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(665), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [19383] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(287), 1,
      sym_comment,
    ACTIONS(643), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(645), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [19425] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(288), 1,
      sym_comment,
    ACTIONS(615), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(617), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [19467] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(289), 1,
      sym_comment,
    ACTIONS(242), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(244), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [19509] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(290), 1,
      sym_comment,
    ACTIONS(619), 11,
      ts_builtin_sym_end,
      aux_sym_raw_string_token1,
      sym_static_field,
      sym_field,
      aux_sym_number_token4,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_BANG,
    ACTIONS(621), 17,
      anon_sym_DQUOTE,
      sym_name,
      sym_null,
      aux_sym_number_token1,
      anon_sym_true,
      anon_sym_false,
      anon_sym_return,
      anon_sym_DASH,
      anon_sym_var,
      anon_sym_class,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      sym_break_statement,
      sym_continue_statement,
      anon_sym_POUND,
      anon_sym_import,
  [19551] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(173), 1,
      sym_call_body,
    STATE(291), 1,
      sym_comment,
    ACTIONS(677), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [19610] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(679), 1,
      anon_sym_RBRACK,
    STATE(173), 1,
      sym_call_body,
    STATE(292), 1,
      sym_comment,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [19668] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(681), 1,
      anon_sym_RBRACK,
    STATE(173), 1,
      sym_call_body,
    STATE(293), 1,
      sym_comment,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [19726] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(683), 1,
      anon_sym_COLON,
    STATE(173), 1,
      sym_call_body,
    STATE(294), 1,
      sym_comment,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [19784] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(685), 1,
      anon_sym_RBRACK,
    STATE(173), 1,
      sym_call_body,
    STATE(295), 1,
      sym_comment,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [19842] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(687), 1,
      anon_sym_RPAREN,
    STATE(173), 1,
      sym_call_body,
    STATE(296), 1,
      sym_comment,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [19900] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(689), 1,
      anon_sym_RPAREN,
    STATE(173), 1,
      sym_call_body,
    STATE(297), 1,
      sym_comment,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [19958] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(691), 1,
      anon_sym_RPAREN,
    STATE(173), 1,
      sym_call_body,
    STATE(298), 1,
      sym_comment,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20016] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(693), 1,
      anon_sym_COLON,
    STATE(173), 1,
      sym_call_body,
    STATE(299), 1,
      sym_comment,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20074] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(330), 1,
      anon_sym_EQ,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(173), 1,
      sym_call_body,
    STATE(300), 1,
      sym_comment,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20132] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(695), 1,
      anon_sym_COLON,
    STATE(173), 1,
      sym_call_body,
    STATE(301), 1,
      sym_comment,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20190] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(697), 1,
      anon_sym_RBRACK,
    STATE(173), 1,
      sym_call_body,
    STATE(302), 1,
      sym_comment,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20248] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(699), 1,
      anon_sym_COLON,
    STATE(173), 1,
      sym_call_body,
    STATE(303), 1,
      sym_comment,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20306] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(412), 1,
      anon_sym_COLON,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(173), 1,
      sym_call_body,
    STATE(304), 1,
      sym_comment,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20364] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(701), 1,
      anon_sym_RPAREN,
    STATE(173), 1,
      sym_call_body,
    STATE(305), 1,
      sym_comment,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20422] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(284), 1,
      anon_sym_EQ,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(173), 1,
      sym_call_body,
    STATE(306), 1,
      sym_comment,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20480] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(703), 1,
      anon_sym_RPAREN,
    STATE(173), 1,
      sym_call_body,
    STATE(307), 1,
      sym_comment,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20538] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(452), 1,
      anon_sym_LBRACE,
    ACTIONS(454), 1,
      anon_sym_LPAREN,
    ACTIONS(460), 1,
      anon_sym_LBRACK,
    ACTIONS(629), 1,
      anon_sym_QMARK,
    ACTIONS(631), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_DOT_DOT,
    ACTIONS(635), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(705), 1,
      anon_sym_RPAREN,
    STATE(173), 1,
      sym_call_body,
    STATE(308), 1,
      sym_comment,
    ACTIONS(458), 4,
      anon_sym_SLASH,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 13,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_GT,
      anon_sym_LT_LT,
      anon_sym_is,
  [20596] = 13,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(707), 1,
      sym_name,
    ACTIONS(710), 1,
      anon_sym_RBRACE,
    ACTIONS(712), 1,
      aux_sym_prefix_operator_definition_token1,
    ACTIONS(715), 1,
      anon_sym_LBRACK,
    ACTIONS(718), 1,
      anon_sym_construct,
    ACTIONS(721), 1,
      anon_sym_static,
    ACTIONS(724), 1,
      anon_sym_POUND,
    STATE(314), 1,
      aux_sym_class_body_repeat1,
    STATE(339), 1,
      sym_attribute,
    STATE(309), 2,
      sym_comment,
      aux_sym_class_body_repeat2,
    STATE(331), 10,
      sym_getter_definition,
      sym_setter_definition,
      sym_prefix_operator_definition,
      sym_subscript_operator_definition,
      sym_subscript_setter_definition,
      sym_infix_operator_definition,
      sym_method_definition,
      sym_constructor,
      sym_static_method_definition,
      sym_static_getter_definition,
  [20646] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(727), 1,
      sym_name,
    ACTIONS(729), 1,
      anon_sym_RBRACE,
    ACTIONS(731), 1,
      aux_sym_prefix_operator_definition_token1,
    ACTIONS(733), 1,
      anon_sym_LBRACK,
    ACTIONS(735), 1,
      anon_sym_construct,
    ACTIONS(737), 1,
      anon_sym_static,
    ACTIONS(739), 1,
      anon_sym_POUND,
    STATE(309), 1,
      aux_sym_class_body_repeat2,
    STATE(310), 1,
      sym_comment,
    STATE(314), 1,
      aux_sym_class_body_repeat1,
    STATE(339), 1,
      sym_attribute,
    STATE(331), 10,
      sym_getter_definition,
      sym_setter_definition,
      sym_prefix_operator_definition,
      sym_subscript_operator_definition,
      sym_subscript_setter_definition,
      sym_infix_operator_definition,
      sym_method_definition,
      sym_constructor,
      sym_static_method_definition,
      sym_static_getter_definition,
  [20698] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(727), 1,
      sym_name,
    ACTIONS(731), 1,
      aux_sym_prefix_operator_definition_token1,
    ACTIONS(733), 1,
      anon_sym_LBRACK,
    ACTIONS(735), 1,
      anon_sym_construct,
    ACTIONS(737), 1,
      anon_sym_static,
    ACTIONS(739), 1,
      anon_sym_POUND,
    ACTIONS(741), 1,
      anon_sym_RBRACE,
    STATE(310), 1,
      aux_sym_class_body_repeat2,
    STATE(311), 1,
      sym_comment,
    STATE(314), 1,
      aux_sym_class_body_repeat1,
    STATE(339), 1,
      sym_attribute,
    STATE(331), 10,
      sym_getter_definition,
      sym_setter_definition,
      sym_prefix_operator_definition,
      sym_subscript_operator_definition,
      sym_subscript_setter_definition,
      sym_infix_operator_definition,
      sym_method_definition,
      sym_constructor,
      sym_static_method_definition,
      sym_static_getter_definition,
  [20750] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(727), 1,
      sym_name,
    ACTIONS(731), 1,
      aux_sym_prefix_operator_definition_token1,
    ACTIONS(733), 1,
      anon_sym_LBRACK,
    ACTIONS(735), 1,
      anon_sym_construct,
    ACTIONS(737), 1,
      anon_sym_static,
    ACTIONS(739), 1,
      anon_sym_POUND,
    ACTIONS(743), 1,
      anon_sym_RBRACE,
    STATE(312), 1,
      sym_comment,
    STATE(313), 1,
      aux_sym_class_body_repeat2,
    STATE(314), 1,
      aux_sym_class_body_repeat1,
    STATE(339), 1,
      sym_attribute,
    STATE(331), 10,
      sym_getter_definition,
      sym_setter_definition,
      sym_prefix_operator_definition,
      sym_subscript_operator_definition,
      sym_subscript_setter_definition,
      sym_infix_operator_definition,
      sym_method_definition,
      sym_constructor,
      sym_static_method_definition,
      sym_static_getter_definition,
  [20802] = 14,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(727), 1,
      sym_name,
    ACTIONS(731), 1,
      aux_sym_prefix_operator_definition_token1,
    ACTIONS(733), 1,
      anon_sym_LBRACK,
    ACTIONS(735), 1,
      anon_sym_construct,
    ACTIONS(737), 1,
      anon_sym_static,
    ACTIONS(739), 1,
      anon_sym_POUND,
    ACTIONS(745), 1,
      anon_sym_RBRACE,
    STATE(309), 1,
      aux_sym_class_body_repeat2,
    STATE(313), 1,
      sym_comment,
    STATE(314), 1,
      aux_sym_class_body_repeat1,
    STATE(339), 1,
      sym_attribute,
    STATE(331), 10,
      sym_getter_definition,
      sym_setter_definition,
      sym_prefix_operator_definition,
      sym_subscript_operator_definition,
      sym_subscript_setter_definition,
      sym_infix_operator_definition,
      sym_method_definition,
      sym_constructor,
      sym_static_method_definition,
      sym_static_getter_definition,
  [20854] = 12,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(727), 1,
      sym_name,
    ACTIONS(731), 1,
      aux_sym_prefix_operator_definition_token1,
    ACTIONS(733), 1,
      anon_sym_LBRACK,
    ACTIONS(735), 1,
      anon_sym_construct,
    ACTIONS(737), 1,
      anon_sym_static,
    ACTIONS(739), 1,
      anon_sym_POUND,
    STATE(314), 1,
      sym_comment,
    STATE(319), 1,
      aux_sym_class_body_repeat1,
    STATE(339), 1,
      sym_attribute,
    STATE(330), 10,
      sym_getter_definition,
      sym_setter_definition,
      sym_prefix_operator_definition,
      sym_subscript_operator_definition,
      sym_subscript_setter_definition,
      sym_infix_operator_definition,
      sym_method_definition,
      sym_constructor,
      sym_static_method_definition,
      sym_static_getter_definition,
  [20900] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(747), 1,
      anon_sym_DQUOTE,
    ACTIONS(749), 1,
      sym_name,
    ACTIONS(751), 1,
      aux_sym_number_token1,
    ACTIONS(753), 1,
      aux_sym_number_token4,
    STATE(315), 1,
      sym_comment,
    ACTIONS(755), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(447), 3,
      sym_string,
      sym_number,
      sym_boolean,
  [20931] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(757), 1,
      anon_sym_DQUOTE,
    ACTIONS(759), 1,
      sym_name,
    ACTIONS(761), 1,
      aux_sym_number_token1,
    ACTIONS(763), 1,
      aux_sym_number_token4,
    STATE(316), 1,
      sym_comment,
    ACTIONS(765), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(340), 3,
      sym_string,
      sym_number,
      sym_boolean,
  [20962] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(226), 1,
      aux_sym_number_token1,
    ACTIONS(228), 1,
      aux_sym_number_token4,
    ACTIONS(767), 1,
      anon_sym_DQUOTE,
    ACTIONS(769), 1,
      sym_name,
    STATE(317), 1,
      sym_comment,
    ACTIONS(230), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(351), 3,
      sym_string,
      sym_number,
      sym_boolean,
  [20993] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(17), 1,
      aux_sym_number_token1,
    ACTIONS(19), 1,
      aux_sym_number_token4,
    ACTIONS(769), 1,
      sym_name,
    ACTIONS(771), 1,
      anon_sym_DQUOTE,
    STATE(318), 1,
      sym_comment,
    ACTIONS(21), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(351), 3,
      sym_string,
      sym_number,
      sym_boolean,
  [21024] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(777), 1,
      anon_sym_POUND,
    STATE(339), 1,
      sym_attribute,
    ACTIONS(775), 2,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
    STATE(319), 2,
      sym_comment,
      aux_sym_class_body_repeat1,
    ACTIONS(773), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
  [21050] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(782), 1,
      anon_sym_EQ,
    ACTIONS(784), 1,
      anon_sym_LPAREN,
    STATE(320), 1,
      sym_comment,
    ACTIONS(780), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(786), 3,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21076] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(321), 1,
      sym_comment,
    ACTIONS(420), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(418), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21097] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(322), 1,
      sym_comment,
    ACTIONS(788), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(790), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21118] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(323), 1,
      sym_comment,
    ACTIONS(792), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(794), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21139] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(324), 1,
      sym_comment,
    ACTIONS(796), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(798), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21160] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(325), 1,
      sym_comment,
    ACTIONS(800), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(802), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21181] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(804), 1,
      anon_sym_class,
    STATE(326), 1,
      sym_comment,
    STATE(338), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
  [21210] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(327), 1,
      sym_comment,
    ACTIONS(806), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(808), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21231] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(328), 1,
      sym_comment,
    ACTIONS(810), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(812), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21252] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(329), 1,
      sym_comment,
    ACTIONS(814), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(816), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21273] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(330), 1,
      sym_comment,
    ACTIONS(818), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(710), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21294] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(331), 1,
      sym_comment,
    ACTIONS(820), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(822), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21315] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(332), 1,
      sym_comment,
    ACTIONS(824), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(826), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21336] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(333), 1,
      sym_comment,
    ACTIONS(828), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(830), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21357] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(334), 1,
      sym_comment,
    ACTIONS(832), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(834), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21378] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(45), 1,
      anon_sym_POUND,
    ACTIONS(55), 1,
      anon_sym_POUND_BANG,
    ACTIONS(836), 1,
      anon_sym_class,
    STATE(335), 1,
      sym_comment,
    STATE(338), 1,
      aux_sym_class_definition_repeat1,
    STATE(396), 1,
      sym__any_attribute,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
  [21407] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(336), 1,
      sym_comment,
    ACTIONS(838), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(840), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21428] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(337), 1,
      sym_comment,
    ACTIONS(609), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(607), 4,
      anon_sym_RBRACE,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21449] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(842), 1,
      anon_sym_class,
    ACTIONS(844), 1,
      anon_sym_POUND,
    ACTIONS(847), 1,
      anon_sym_POUND_BANG,
    STATE(396), 1,
      sym__any_attribute,
    STATE(338), 2,
      sym_comment,
      aux_sym_class_definition_repeat1,
    STATE(418), 2,
      sym_attribute,
      sym_runtime_attribute,
  [21476] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(339), 1,
      sym_comment,
    ACTIONS(850), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(852), 3,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21496] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(340), 1,
      sym_comment,
    ACTIONS(854), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(856), 3,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21516] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(341), 1,
      sym_comment,
    ACTIONS(858), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(860), 3,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21536] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(342), 1,
      sym_comment,
    ACTIONS(862), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(864), 3,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21556] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(343), 1,
      sym_comment,
    ACTIONS(242), 3,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
    ACTIONS(244), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
  [21576] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(344), 1,
      sym_comment,
    ACTIONS(246), 3,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
    ACTIONS(248), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
  [21596] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(345), 1,
      sym_comment,
    ACTIONS(866), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
    ACTIONS(868), 3,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
  [21616] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(346), 1,
      sym_comment,
    ACTIONS(250), 3,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
    ACTIONS(252), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
  [21636] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(347), 1,
      sym_comment,
    ACTIONS(254), 3,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
    ACTIONS(256), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
  [21656] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(348), 1,
      sym_comment,
    ACTIONS(258), 3,
      aux_sym_prefix_operator_definition_token1,
      anon_sym_LBRACK,
      anon_sym_POUND,
    ACTIONS(260), 3,
      sym_name,
      anon_sym_construct,
      anon_sym_static,
  [21676] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(780), 1,
      anon_sym_POUND,
    ACTIONS(870), 1,
      anon_sym_EQ,
    ACTIONS(872), 1,
      anon_sym_LPAREN,
    STATE(349), 1,
      sym_comment,
    ACTIONS(786), 2,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [21699] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(874), 1,
      anon_sym_COMMA,
    STATE(350), 2,
      sym_comment,
      aux_sym_argument_list_repeat1,
    ACTIONS(655), 3,
      anon_sym_RPAREN,
      anon_sym_PIPE,
      anon_sym_RBRACK,
  [21718] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(854), 1,
      anon_sym_POUND,
    STATE(351), 1,
      sym_comment,
    ACTIONS(856), 4,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [21737] = 6,
    ACTIONS(877), 1,
      anon_sym_DQUOTE,
    ACTIONS(879), 1,
      aux_sym_string_token1,
    ACTIONS(882), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    STATE(352), 2,
      sym_comment,
      aux_sym_string_repeat2,
  [21757] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(780), 1,
      anon_sym_POUND,
    ACTIONS(870), 1,
      anon_sym_EQ,
    STATE(353), 1,
      sym_comment,
    ACTIONS(786), 2,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [21777] = 7,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(889), 1,
      anon_sym_DQUOTE,
    ACTIONS(891), 1,
      aux_sym_string_token1,
    ACTIONS(893), 1,
      anon_sym_PERCENT_LPAREN,
    STATE(352), 1,
      aux_sym_string_repeat2,
    STATE(354), 1,
      sym_comment,
  [21799] = 7,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(891), 1,
      aux_sym_string_token1,
    ACTIONS(893), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(895), 1,
      anon_sym_DQUOTE,
    STATE(354), 1,
      aux_sym_string_repeat2,
    STATE(355), 1,
      sym_comment,
  [21821] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(899), 1,
      anon_sym_COMMA,
    ACTIONS(897), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    STATE(356), 2,
      sym_comment,
      aux_sym_parameter_list_repeat1,
  [21839] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(902), 1,
      anon_sym_RPAREN,
    ACTIONS(904), 1,
      sym_name,
    STATE(357), 1,
      sym_comment,
    STATE(370), 1,
      aux_sym_runtime_attribute_repeat1,
    STATE(487), 1,
      sym_attribute_value,
  [21861] = 7,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(891), 1,
      aux_sym_string_token1,
    ACTIONS(893), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(906), 1,
      anon_sym_DQUOTE,
    STATE(352), 1,
      aux_sym_string_repeat2,
    STATE(358), 1,
      sym_comment,
  [21883] = 7,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(891), 1,
      aux_sym_string_token1,
    ACTIONS(893), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(908), 1,
      anon_sym_DQUOTE,
    STATE(358), 1,
      aux_sym_string_repeat2,
    STATE(359), 1,
      sym_comment,
  [21905] = 7,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(891), 1,
      aux_sym_string_token1,
    ACTIONS(893), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(910), 1,
      anon_sym_DQUOTE,
    STATE(352), 1,
      aux_sym_string_repeat2,
    STATE(360), 1,
      sym_comment,
  [21927] = 7,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(891), 1,
      aux_sym_string_token1,
    ACTIONS(893), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(912), 1,
      anon_sym_DQUOTE,
    STATE(352), 1,
      aux_sym_string_repeat2,
    STATE(361), 1,
      sym_comment,
  [21949] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(914), 1,
      anon_sym_EQ,
    ACTIONS(916), 1,
      anon_sym_LBRACE,
    ACTIONS(918), 1,
      anon_sym_LPAREN,
    STATE(333), 1,
      sym_block,
    STATE(362), 1,
      sym_comment,
  [21971] = 7,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(891), 1,
      aux_sym_string_token1,
    ACTIONS(893), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(920), 1,
      anon_sym_DQUOTE,
    STATE(360), 1,
      aux_sym_string_repeat2,
    STATE(363), 1,
      sym_comment,
  [21993] = 7,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(891), 1,
      aux_sym_string_token1,
    ACTIONS(893), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(922), 1,
      anon_sym_DQUOTE,
    STATE(364), 1,
      sym_comment,
    STATE(369), 1,
      aux_sym_string_repeat2,
  [22015] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(926), 1,
      anon_sym_COMMA,
    STATE(356), 1,
      aux_sym_parameter_list_repeat1,
    STATE(365), 1,
      sym_comment,
    ACTIONS(924), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [22035] = 7,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(891), 1,
      aux_sym_string_token1,
    ACTIONS(893), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(928), 1,
      anon_sym_DQUOTE,
    STATE(361), 1,
      aux_sym_string_repeat2,
    STATE(366), 1,
      sym_comment,
  [22057] = 7,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(891), 1,
      aux_sym_string_token1,
    ACTIONS(893), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(930), 1,
      anon_sym_DQUOTE,
    STATE(352), 1,
      aux_sym_string_repeat2,
    STATE(367), 1,
      sym_comment,
  [22079] = 7,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(891), 1,
      aux_sym_string_token1,
    ACTIONS(893), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(932), 1,
      anon_sym_DQUOTE,
    STATE(367), 1,
      aux_sym_string_repeat2,
    STATE(368), 1,
      sym_comment,
  [22101] = 7,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(891), 1,
      aux_sym_string_token1,
    ACTIONS(893), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(934), 1,
      anon_sym_DQUOTE,
    STATE(352), 1,
      aux_sym_string_repeat2,
    STATE(369), 1,
      sym_comment,
  [22123] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(904), 1,
      sym_name,
    ACTIONS(936), 1,
      anon_sym_RPAREN,
    STATE(370), 1,
      sym_comment,
    STATE(374), 1,
      aux_sym_runtime_attribute_repeat1,
    STATE(487), 1,
      sym_attribute_value,
  [22145] = 7,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(891), 1,
      aux_sym_string_token1,
    ACTIONS(893), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(938), 1,
      anon_sym_DQUOTE,
    STATE(352), 1,
      aux_sym_string_repeat2,
    STATE(371), 1,
      sym_comment,
  [22167] = 7,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(891), 1,
      aux_sym_string_token1,
    ACTIONS(893), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(940), 1,
      anon_sym_DQUOTE,
    STATE(371), 1,
      aux_sym_string_repeat2,
    STATE(372), 1,
      sym_comment,
  [22189] = 7,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(891), 1,
      aux_sym_string_token1,
    ACTIONS(893), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(942), 1,
      anon_sym_DQUOTE,
    STATE(373), 1,
      sym_comment,
    STATE(377), 1,
      aux_sym_string_repeat2,
  [22211] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(944), 1,
      anon_sym_RPAREN,
    ACTIONS(946), 1,
      sym_name,
    STATE(487), 1,
      sym_attribute_value,
    STATE(374), 2,
      sym_comment,
      aux_sym_runtime_attribute_repeat1,
  [22231] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(926), 1,
      anon_sym_COMMA,
    STATE(365), 1,
      aux_sym_parameter_list_repeat1,
    STATE(375), 1,
      sym_comment,
    ACTIONS(949), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [22251] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(625), 1,
      anon_sym_COMMA,
    STATE(350), 1,
      aux_sym_argument_list_repeat1,
    STATE(376), 1,
      sym_comment,
    ACTIONS(951), 2,
      anon_sym_RPAREN,
      anon_sym_PIPE,
  [22271] = 7,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(891), 1,
      aux_sym_string_token1,
    ACTIONS(893), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(953), 1,
      anon_sym_DQUOTE,
    STATE(352), 1,
      aux_sym_string_repeat2,
    STATE(377), 1,
      sym_comment,
  [22293] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(955), 1,
      anon_sym_RPAREN,
    ACTIONS(957), 1,
      sym_name,
    STATE(375), 1,
      sym_parameter,
    STATE(378), 1,
      sym_comment,
    STATE(491), 1,
      sym_parameter_list,
  [22315] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(959), 1,
      sym_name,
    ACTIONS(961), 1,
      anon_sym_LPAREN,
    STATE(379), 1,
      sym_comment,
    STATE(398), 1,
      sym_attribute_value,
  [22334] = 5,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(965), 1,
      aux_sym_string_token1,
    STATE(380), 1,
      sym_comment,
    ACTIONS(963), 2,
      anon_sym_DQUOTE,
      anon_sym_PERCENT_LPAREN,
  [22351] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(967), 1,
      sym_name,
    STATE(222), 1,
      sym__import_entry,
    STATE(255), 1,
      sym_rename,
    STATE(381), 1,
      sym_comment,
  [22370] = 6,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(969), 1,
      aux_sym_raw_string_token1,
    ACTIONS(971), 1,
      aux_sym_raw_string_token2,
    STATE(382), 1,
      sym_comment,
    STATE(421), 1,
      aux_sym_raw_string_repeat1,
  [22389] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(975), 1,
      anon_sym_POUND,
    STATE(383), 1,
      sym_comment,
    ACTIONS(973), 2,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [22406] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(977), 1,
      anon_sym_RBRACE,
    ACTIONS(979), 1,
      anon_sym_COMMA,
    STATE(384), 1,
      sym_comment,
    STATE(422), 1,
      aux_sym_map_repeat1,
  [22425] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(981), 1,
      anon_sym_RPAREN,
    ACTIONS(983), 1,
      anon_sym_COMMA,
    STATE(385), 1,
      sym_comment,
    STATE(439), 1,
      aux_sym_attribute_repeat1,
  [22444] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(985), 1,
      anon_sym_RBRACE,
    ACTIONS(987), 1,
      anon_sym_COMMA,
    STATE(386), 1,
      sym_comment,
    STATE(410), 1,
      aux_sym_map_repeat1,
  [22463] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(862), 1,
      anon_sym_POUND,
    STATE(387), 1,
      sym_comment,
    ACTIONS(864), 2,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [22480] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(916), 1,
      anon_sym_LBRACE,
    ACTIONS(918), 1,
      anon_sym_LPAREN,
    STATE(333), 1,
      sym_block,
    STATE(388), 1,
      sym_comment,
  [22499] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(989), 1,
      anon_sym_is,
    ACTIONS(991), 1,
      anon_sym_LBRACE,
    STATE(286), 1,
      sym_class_body,
    STATE(389), 1,
      sym_comment,
  [22518] = 6,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(971), 1,
      aux_sym_raw_string_token2,
    ACTIONS(993), 1,
      aux_sym_raw_string_token1,
    STATE(390), 1,
      sym_comment,
    STATE(421), 1,
      aux_sym_raw_string_repeat1,
  [22537] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(391), 1,
      sym_comment,
    ACTIONS(995), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [22552] = 6,
    ACTIONS(997), 1,
      aux_sym_raw_string_token2,
    ACTIONS(999), 1,
      aux_sym_comment_token1,
    ACTIONS(1001), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1003), 1,
      anon_sym_STAR_SLASH,
    STATE(392), 1,
      sym_comment,
    STATE(416), 1,
      aux_sym_comment_repeat1,
  [22571] = 6,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(971), 1,
      aux_sym_raw_string_token2,
    ACTIONS(1005), 1,
      aux_sym_raw_string_token1,
    STATE(390), 1,
      aux_sym_raw_string_repeat1,
    STATE(393), 1,
      sym_comment,
  [22590] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1007), 1,
      sym_name,
    STATE(199), 1,
      sym_rename,
    STATE(203), 1,
      sym__import_entry,
    STATE(394), 1,
      sym_comment,
  [22609] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(866), 1,
      anon_sym_POUND,
    STATE(395), 1,
      sym_comment,
    ACTIONS(868), 2,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [22626] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1011), 1,
      anon_sym_POUND,
    STATE(396), 1,
      sym_comment,
    ACTIONS(1009), 2,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [22643] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1013), 1,
      anon_sym_RPAREN,
    ACTIONS(1015), 1,
      sym_name,
    STATE(357), 1,
      sym_attribute_value,
    STATE(397), 1,
      sym_comment,
  [22662] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1019), 1,
      anon_sym_POUND,
    STATE(398), 1,
      sym_comment,
    ACTIONS(1017), 2,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [22679] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(399), 1,
      sym_comment,
    ACTIONS(897), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [22694] = 6,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(971), 1,
      aux_sym_raw_string_token2,
    ACTIONS(1021), 1,
      aux_sym_raw_string_token1,
    STATE(382), 1,
      aux_sym_raw_string_repeat1,
    STATE(400), 1,
      sym_comment,
  [22713] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1023), 1,
      anon_sym_EQ,
    STATE(401), 1,
      sym_comment,
    ACTIONS(786), 2,
      anon_sym_RPAREN,
      sym_name,
  [22730] = 6,
    ACTIONS(999), 1,
      aux_sym_comment_token1,
    ACTIONS(1001), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1025), 1,
      aux_sym_raw_string_token2,
    ACTIONS(1027), 1,
      anon_sym_STAR_SLASH,
    STATE(402), 1,
      sym_comment,
    STATE(409), 1,
      aux_sym_comment_repeat1,
  [22749] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(625), 1,
      anon_sym_COMMA,
    ACTIONS(1029), 1,
      anon_sym_RBRACK,
    STATE(350), 1,
      aux_sym_argument_list_repeat1,
    STATE(403), 1,
      sym_comment,
  [22768] = 6,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(971), 1,
      aux_sym_raw_string_token2,
    ACTIONS(1031), 1,
      aux_sym_raw_string_token1,
    STATE(404), 1,
      sym_comment,
    STATE(411), 1,
      aux_sym_raw_string_repeat1,
  [22787] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(625), 1,
      anon_sym_COMMA,
    ACTIONS(1033), 1,
      anon_sym_RBRACK,
    STATE(350), 1,
      aux_sym_argument_list_repeat1,
    STATE(405), 1,
      sym_comment,
  [22806] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(916), 1,
      anon_sym_LBRACE,
    ACTIONS(1035), 1,
      anon_sym_LPAREN,
    STATE(323), 1,
      sym_block,
    STATE(406), 1,
      sym_comment,
  [22825] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(466), 1,
      anon_sym_RBRACE,
    ACTIONS(1037), 1,
      anon_sym_COMMA,
    STATE(407), 1,
      sym_comment,
    STATE(430), 1,
      aux_sym_map_repeat1,
  [22844] = 5,
    ACTIONS(1039), 1,
      aux_sym_raw_string_token2,
    ACTIONS(1042), 1,
      aux_sym_comment_token1,
    ACTIONS(1045), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1048), 1,
      anon_sym_STAR_SLASH,
    STATE(408), 2,
      sym_comment,
      aux_sym_comment_repeat1,
  [22861] = 6,
    ACTIONS(999), 1,
      aux_sym_comment_token1,
    ACTIONS(1001), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1050), 1,
      aux_sym_raw_string_token2,
    ACTIONS(1052), 1,
      anon_sym_STAR_SLASH,
    STATE(408), 1,
      aux_sym_comment_repeat1,
    STATE(409), 1,
      sym_comment,
  [22880] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(521), 1,
      anon_sym_RBRACE,
    ACTIONS(1054), 1,
      anon_sym_COMMA,
    STATE(410), 1,
      sym_comment,
    STATE(430), 1,
      aux_sym_map_repeat1,
  [22899] = 6,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(971), 1,
      aux_sym_raw_string_token2,
    ACTIONS(1056), 1,
      aux_sym_raw_string_token1,
    STATE(411), 1,
      sym_comment,
    STATE(421), 1,
      aux_sym_raw_string_repeat1,
  [22918] = 5,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1058), 1,
      aux_sym_string_token1,
    STATE(412), 1,
      sym_comment,
    ACTIONS(877), 2,
      anon_sym_DQUOTE,
      anon_sym_PERCENT_LPAREN,
  [22935] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(983), 1,
      anon_sym_COMMA,
    ACTIONS(1060), 1,
      anon_sym_RPAREN,
    STATE(385), 1,
      aux_sym_attribute_repeat1,
    STATE(413), 1,
      sym_comment,
  [22954] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1062), 1,
      anon_sym_RBRACE,
    ACTIONS(1064), 1,
      anon_sym_COMMA,
    STATE(414), 1,
      sym_comment,
    STATE(424), 1,
      aux_sym_map_repeat1,
  [22973] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1068), 1,
      anon_sym_POUND,
    STATE(415), 1,
      sym_comment,
    ACTIONS(1066), 2,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [22990] = 6,
    ACTIONS(999), 1,
      aux_sym_comment_token1,
    ACTIONS(1001), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1050), 1,
      aux_sym_raw_string_token2,
    ACTIONS(1070), 1,
      anon_sym_STAR_SLASH,
    STATE(408), 1,
      aux_sym_comment_repeat1,
    STATE(416), 1,
      sym_comment,
  [23009] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1072), 1,
      anon_sym_is,
    ACTIONS(1074), 1,
      anon_sym_LBRACE,
    STATE(269), 1,
      sym_class_body,
    STATE(417), 1,
      sym_comment,
  [23028] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1078), 1,
      anon_sym_POUND,
    STATE(418), 1,
      sym_comment,
    ACTIONS(1076), 2,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [23045] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1080), 1,
      anon_sym_EQ,
    STATE(419), 1,
      sym_comment,
    ACTIONS(786), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [23062] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1082), 1,
      sym_name,
    STATE(325), 1,
      sym_getter_definition,
    STATE(328), 1,
      sym_method_definition,
    STATE(420), 1,
      sym_comment,
  [23081] = 5,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1084), 1,
      aux_sym_raw_string_token1,
    ACTIONS(1086), 1,
      aux_sym_raw_string_token2,
    STATE(421), 2,
      sym_comment,
      aux_sym_raw_string_repeat1,
  [23098] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(472), 1,
      anon_sym_RBRACE,
    ACTIONS(1089), 1,
      anon_sym_COMMA,
    STATE(422), 1,
      sym_comment,
    STATE(430), 1,
      aux_sym_map_repeat1,
  [23117] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(957), 1,
      sym_name,
    STATE(375), 1,
      sym_parameter,
    STATE(423), 1,
      sym_comment,
    STATE(478), 1,
      sym_parameter_list,
  [23136] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(537), 1,
      anon_sym_RBRACE,
    ACTIONS(1091), 1,
      anon_sym_COMMA,
    STATE(424), 1,
      sym_comment,
    STATE(430), 1,
      aux_sym_map_repeat1,
  [23155] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1093), 1,
      anon_sym_RBRACE,
    ACTIONS(1095), 1,
      anon_sym_COMMA,
    STATE(407), 1,
      aux_sym_map_repeat1,
    STATE(425), 1,
      sym_comment,
  [23174] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(625), 1,
      anon_sym_COMMA,
    ACTIONS(1097), 1,
      anon_sym_RBRACK,
    STATE(350), 1,
      aux_sym_argument_list_repeat1,
    STATE(426), 1,
      sym_comment,
  [23193] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(916), 1,
      anon_sym_LBRACE,
    ACTIONS(1099), 1,
      anon_sym_EQ,
    STATE(327), 1,
      sym_block,
    STATE(427), 1,
      sym_comment,
  [23212] = 6,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(971), 1,
      aux_sym_raw_string_token2,
    ACTIONS(1101), 1,
      aux_sym_raw_string_token1,
    STATE(421), 1,
      aux_sym_raw_string_repeat1,
    STATE(428), 1,
      sym_comment,
  [23231] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1007), 1,
      sym_name,
    STATE(182), 1,
      sym__import_entry,
    STATE(199), 1,
      sym_rename,
    STATE(429), 1,
      sym_comment,
  [23250] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1103), 1,
      anon_sym_RBRACE,
    ACTIONS(1105), 1,
      anon_sym_COMMA,
    STATE(430), 2,
      sym_comment,
      aux_sym_map_repeat1,
  [23267] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(858), 1,
      anon_sym_POUND,
    STATE(431), 1,
      sym_comment,
    ACTIONS(860), 2,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [23284] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(625), 1,
      anon_sym_COMMA,
    ACTIONS(1108), 1,
      anon_sym_RBRACK,
    STATE(350), 1,
      aux_sym_argument_list_repeat1,
    STATE(432), 1,
      sym_comment,
  [23303] = 5,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1112), 1,
      aux_sym_string_token1,
    STATE(433), 1,
      sym_comment,
    ACTIONS(1110), 2,
      anon_sym_DQUOTE,
      anon_sym_PERCENT_LPAREN,
  [23320] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1074), 1,
      anon_sym_LBRACE,
    ACTIONS(1114), 1,
      anon_sym_is,
    STATE(264), 1,
      sym_class_body,
    STATE(434), 1,
      sym_comment,
  [23339] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(991), 1,
      anon_sym_LBRACE,
    ACTIONS(1116), 1,
      anon_sym_is,
    STATE(276), 1,
      sym_class_body,
    STATE(435), 1,
      sym_comment,
  [23358] = 6,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(971), 1,
      aux_sym_raw_string_token2,
    ACTIONS(1118), 1,
      aux_sym_raw_string_token1,
    STATE(428), 1,
      aux_sym_raw_string_repeat1,
    STATE(436), 1,
      sym_comment,
  [23377] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(967), 1,
      sym_name,
    STATE(200), 1,
      sym__import_entry,
    STATE(255), 1,
      sym_rename,
    STATE(437), 1,
      sym_comment,
  [23396] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(983), 1,
      anon_sym_COMMA,
    ACTIONS(1120), 1,
      anon_sym_RPAREN,
    STATE(438), 1,
      sym_comment,
    STATE(440), 1,
      aux_sym_attribute_repeat1,
  [23415] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1122), 1,
      anon_sym_RPAREN,
    ACTIONS(1124), 1,
      anon_sym_COMMA,
    STATE(439), 2,
      sym_comment,
      aux_sym_attribute_repeat1,
  [23432] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(983), 1,
      anon_sym_COMMA,
    ACTIONS(1127), 1,
      anon_sym_RPAREN,
    STATE(439), 1,
      aux_sym_attribute_repeat1,
    STATE(440), 1,
      sym_comment,
  [23451] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1131), 1,
      anon_sym_POUND,
    STATE(441), 1,
      sym_comment,
    ACTIONS(1129), 2,
      anon_sym_class,
      anon_sym_POUND_BANG,
  [23468] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(442), 1,
      sym_comment,
    ACTIONS(254), 2,
      anon_sym_RPAREN,
      sym_name,
  [23482] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(904), 1,
      sym_name,
    STATE(438), 1,
      sym_attribute_value,
    STATE(443), 1,
      sym_comment,
  [23498] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1074), 1,
      anon_sym_LBRACE,
    STATE(241), 1,
      sym_class_body,
    STATE(444), 1,
      sym_comment,
  [23514] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(904), 1,
      sym_name,
    STATE(413), 1,
      sym_attribute_value,
    STATE(445), 1,
      sym_comment,
  [23530] = 2,
    STATE(446), 1,
      sym_comment,
    ACTIONS(1133), 4,
      aux_sym_raw_string_token2,
      aux_sym_comment_token1,
      anon_sym_SLASH_STAR,
      anon_sym_STAR_SLASH,
  [23540] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(447), 1,
      sym_comment,
    ACTIONS(856), 2,
      anon_sym_RPAREN,
      sym_name,
  [23554] = 2,
    STATE(448), 1,
      sym_comment,
    ACTIONS(1135), 4,
      aux_sym_raw_string_token2,
      aux_sym_comment_token1,
      anon_sym_SLASH_STAR,
      anon_sym_STAR_SLASH,
  [23564] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1074), 1,
      anon_sym_LBRACE,
    STATE(263), 1,
      sym_class_body,
    STATE(449), 1,
      sym_comment,
  [23580] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(450), 1,
      sym_comment,
    ACTIONS(1103), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [23594] = 2,
    STATE(451), 1,
      sym_comment,
    ACTIONS(1137), 4,
      aux_sym_raw_string_token2,
      aux_sym_comment_token1,
      anon_sym_SLASH_STAR,
      anon_sym_STAR_SLASH,
  [23604] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1139), 1,
      sym_name,
    STATE(395), 1,
      sym_attribute_value,
    STATE(452), 1,
      sym_comment,
  [23620] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(916), 1,
      anon_sym_LBRACE,
    STATE(336), 1,
      sym_block,
    STATE(453), 1,
      sym_comment,
  [23636] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(991), 1,
      anon_sym_LBRACE,
    STATE(272), 1,
      sym_class_body,
    STATE(454), 1,
      sym_comment,
  [23652] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1141), 1,
      anon_sym_DQUOTE,
    STATE(284), 1,
      sym_string,
    STATE(455), 1,
      sym_comment,
  [23668] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(957), 1,
      sym_name,
    STATE(456), 1,
      sym_comment,
    STATE(505), 1,
      sym_parameter,
  [23684] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1143), 1,
      sym_name,
    STATE(324), 1,
      sym_method_definition,
    STATE(457), 1,
      sym_comment,
  [23700] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(916), 1,
      anon_sym_LBRACE,
    STATE(332), 1,
      sym_block,
    STATE(458), 1,
      sym_comment,
  [23716] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(916), 1,
      anon_sym_LBRACE,
    STATE(334), 1,
      sym_block,
    STATE(459), 1,
      sym_comment,
  [23732] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(916), 1,
      anon_sym_LBRACE,
    STATE(322), 1,
      sym_block,
    STATE(460), 1,
      sym_comment,
  [23748] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1145), 1,
      anon_sym_DQUOTE,
    STATE(256), 1,
      sym_string,
    STATE(461), 1,
      sym_comment,
  [23764] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1147), 1,
      sym_name,
    STATE(345), 1,
      sym_attribute_value,
    STATE(462), 1,
      sym_comment,
  [23780] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(463), 1,
      sym_comment,
    ACTIONS(1122), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [23794] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(957), 1,
      sym_name,
    STATE(399), 1,
      sym_parameter,
    STATE(464), 1,
      sym_comment,
  [23810] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(916), 1,
      anon_sym_LBRACE,
    STATE(329), 1,
      sym_block,
    STATE(465), 1,
      sym_comment,
  [23826] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(957), 1,
      sym_name,
    STATE(466), 1,
      sym_comment,
    STATE(495), 1,
      sym_parameter,
  [23842] = 4,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    STATE(467), 1,
      sym_comment,
    ACTIONS(1149), 2,
      aux_sym_raw_string_token1,
      aux_sym_raw_string_token2,
  [23856] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(991), 1,
      anon_sym_LBRACE,
    STATE(288), 1,
      sym_class_body,
    STATE(468), 1,
      sym_comment,
  [23872] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(469), 1,
      sym_comment,
    ACTIONS(242), 2,
      anon_sym_RPAREN,
      sym_name,
  [23886] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(470), 1,
      sym_comment,
    ACTIONS(246), 2,
      anon_sym_RPAREN,
      sym_name,
  [23900] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(471), 1,
      sym_comment,
    ACTIONS(250), 2,
      anon_sym_RPAREN,
      sym_name,
  [23914] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(472), 1,
      sym_comment,
    ACTIONS(944), 2,
      anon_sym_RPAREN,
      sym_name,
  [23928] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    STATE(473), 1,
      sym_comment,
    ACTIONS(258), 2,
      anon_sym_RPAREN,
      sym_name,
  [23942] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(904), 1,
      sym_name,
    STATE(463), 1,
      sym_attribute_value,
    STATE(474), 1,
      sym_comment,
  [23958] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(957), 1,
      sym_name,
    STATE(475), 1,
      sym_comment,
    STATE(492), 1,
      sym_parameter,
  [23974] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1151), 1,
      ts_builtin_sym_end,
    STATE(476), 1,
      sym_comment,
  [23987] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1153), 1,
      sym_name,
    STATE(477), 1,
      sym_comment,
  [24000] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1155), 1,
      anon_sym_RBRACK,
    STATE(478), 1,
      sym_comment,
  [24013] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(918), 1,
      anon_sym_LPAREN,
    STATE(479), 1,
      sym_comment,
  [24026] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1157), 1,
      anon_sym_EQ,
    STATE(480), 1,
      sym_comment,
  [24039] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1159), 1,
      sym_name,
    STATE(481), 1,
      sym_comment,
  [24052] = 4,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1161), 1,
      aux_sym_number_token3,
    STATE(482), 1,
      sym_comment,
  [24065] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1163), 1,
      sym_name,
    STATE(483), 1,
      sym_comment,
  [24078] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1165), 1,
      sym_name,
    STATE(484), 1,
      sym_comment,
  [24091] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1167), 1,
      sym_name,
    STATE(485), 1,
      sym_comment,
  [24104] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1169), 1,
      anon_sym_PIPE,
    STATE(486), 1,
      sym_comment,
  [24117] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1171), 1,
      anon_sym_COMMA,
    STATE(487), 1,
      sym_comment,
  [24130] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1173), 1,
      anon_sym_RPAREN,
    STATE(488), 1,
      sym_comment,
  [24143] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1175), 1,
      sym_name,
    STATE(489), 1,
      sym_comment,
  [24156] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1177), 1,
      anon_sym_RPAREN,
    STATE(490), 1,
      sym_comment,
  [24169] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1179), 1,
      anon_sym_RPAREN,
    STATE(491), 1,
      sym_comment,
  [24182] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1181), 1,
      anon_sym_RPAREN,
    STATE(492), 1,
      sym_comment,
  [24195] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1183), 1,
      sym_name,
    STATE(493), 1,
      sym_comment,
  [24208] = 4,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1185), 1,
      aux_sym_number_token3,
    STATE(494), 1,
      sym_comment,
  [24221] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1187), 1,
      anon_sym_RPAREN,
    STATE(495), 1,
      sym_comment,
  [24234] = 4,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1189), 1,
      aux_sym_number_token3,
    STATE(496), 1,
      sym_comment,
  [24247] = 4,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1191), 1,
      aux_sym_number_token3,
    STATE(497), 1,
      sym_comment,
  [24260] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1193), 1,
      sym_name,
    STATE(498), 1,
      sym_comment,
  [24273] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1195), 1,
      anon_sym_LPAREN,
    STATE(499), 1,
      sym_comment,
  [24286] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1197), 1,
      anon_sym_EQ,
    STATE(500), 1,
      sym_comment,
  [24299] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1199), 1,
      sym_name,
    STATE(501), 1,
      sym_comment,
  [24312] = 4,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1201), 1,
      aux_sym_number_token2,
    STATE(502), 1,
      sym_comment,
  [24325] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1203), 1,
      sym_name,
    STATE(503), 1,
      sym_comment,
  [24338] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1205), 1,
      sym_name,
    STATE(504), 1,
      sym_comment,
  [24351] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1207), 1,
      anon_sym_RPAREN,
    STATE(505), 1,
      sym_comment,
  [24364] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1209), 1,
      anon_sym_LPAREN,
    STATE(506), 1,
      sym_comment,
  [24377] = 4,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1211), 1,
      aux_sym_number_token3,
    STATE(507), 1,
      sym_comment,
  [24390] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1213), 1,
      sym_name,
    STATE(508), 1,
      sym_comment,
  [24403] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    STATE(509), 1,
      sym_comment,
  [24416] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1217), 1,
      sym_name,
    STATE(510), 1,
      sym_comment,
  [24429] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1219), 1,
      anon_sym_RPAREN,
    STATE(511), 1,
      sym_comment,
  [24442] = 4,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1221), 1,
      aux_sym_number_token3,
    STATE(512), 1,
      sym_comment,
  [24455] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1223), 1,
      anon_sym_PIPE,
    STATE(513), 1,
      sym_comment,
  [24468] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1225), 1,
      sym_name,
    STATE(514), 1,
      sym_comment,
  [24481] = 4,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1227), 1,
      aux_sym_number_token2,
    STATE(515), 1,
      sym_comment,
  [24494] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1229), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      sym_comment,
  [24507] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1231), 1,
      anon_sym_LPAREN,
    STATE(517), 1,
      sym_comment,
  [24520] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1233), 1,
      anon_sym_PIPE,
    STATE(518), 1,
      sym_comment,
  [24533] = 4,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1235), 1,
      aux_sym_number_token2,
    STATE(519), 1,
      sym_comment,
  [24546] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1237), 1,
      anon_sym_LPAREN,
    STATE(520), 1,
      sym_comment,
  [24559] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1239), 1,
      sym_name,
    STATE(521), 1,
      sym_comment,
  [24572] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1241), 1,
      anon_sym_PIPE,
    STATE(522), 1,
      sym_comment,
  [24585] = 4,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1243), 1,
      aux_sym_number_token2,
    STATE(523), 1,
      sym_comment,
  [24598] = 4,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1245), 1,
      aux_sym_number_token2,
    STATE(524), 1,
      sym_comment,
  [24611] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1247), 1,
      anon_sym_LPAREN,
    STATE(525), 1,
      sym_comment,
  [24624] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1249), 1,
      sym_name,
    STATE(526), 1,
      sym_comment,
  [24637] = 4,
    ACTIONS(885), 1,
      aux_sym_comment_token1,
    ACTIONS(887), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1251), 1,
      aux_sym_number_token2,
    STATE(527), 1,
      sym_comment,
  [24650] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1253), 1,
      anon_sym_in,
    STATE(528), 1,
      sym_comment,
  [24663] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1255), 1,
      anon_sym_RPAREN,
    STATE(529), 1,
      sym_comment,
  [24676] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1257), 1,
      anon_sym_in,
    STATE(530), 1,
      sym_comment,
  [24689] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1259), 1,
      sym_name,
    STATE(531), 1,
      sym_comment,
  [24702] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1261), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      sym_comment,
  [24715] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(5), 1,
      anon_sym_SLASH_STAR,
    ACTIONS(1263), 1,
      sym_name,
    STATE(533), 1,
      sym_comment,
  [24728] = 1,
    ACTIONS(1265), 1,
      ts_builtin_sym_end,
  [24732] = 1,
    ACTIONS(1267), 1,
      ts_builtin_sym_end,
  [24736] = 1,
    ACTIONS(1269), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 129,
  [SMALL_STATE(4)] = 258,
  [SMALL_STATE(5)] = 387,
  [SMALL_STATE(6)] = 516,
  [SMALL_STATE(7)] = 645,
  [SMALL_STATE(8)] = 774,
  [SMALL_STATE(9)] = 899,
  [SMALL_STATE(10)] = 1028,
  [SMALL_STATE(11)] = 1157,
  [SMALL_STATE(12)] = 1283,
  [SMALL_STATE(13)] = 1409,
  [SMALL_STATE(14)] = 1535,
  [SMALL_STATE(15)] = 1661,
  [SMALL_STATE(16)] = 1787,
  [SMALL_STATE(17)] = 1913,
  [SMALL_STATE(18)] = 2039,
  [SMALL_STATE(19)] = 2165,
  [SMALL_STATE(20)] = 2291,
  [SMALL_STATE(21)] = 2417,
  [SMALL_STATE(22)] = 2543,
  [SMALL_STATE(23)] = 2669,
  [SMALL_STATE(24)] = 2795,
  [SMALL_STATE(25)] = 2921,
  [SMALL_STATE(26)] = 3047,
  [SMALL_STATE(27)] = 3173,
  [SMALL_STATE(28)] = 3299,
  [SMALL_STATE(29)] = 3425,
  [SMALL_STATE(30)] = 3551,
  [SMALL_STATE(31)] = 3671,
  [SMALL_STATE(32)] = 3791,
  [SMALL_STATE(33)] = 3911,
  [SMALL_STATE(34)] = 4031,
  [SMALL_STATE(35)] = 4151,
  [SMALL_STATE(36)] = 4271,
  [SMALL_STATE(37)] = 4391,
  [SMALL_STATE(38)] = 4458,
  [SMALL_STATE(39)] = 4525,
  [SMALL_STATE(40)] = 4592,
  [SMALL_STATE(41)] = 4659,
  [SMALL_STATE(42)] = 4726,
  [SMALL_STATE(43)] = 4804,
  [SMALL_STATE(44)] = 4876,
  [SMALL_STATE(45)] = 4964,
  [SMALL_STATE(46)] = 5036,
  [SMALL_STATE(47)] = 5106,
  [SMALL_STATE(48)] = 5184,
  [SMALL_STATE(49)] = 5272,
  [SMALL_STATE(50)] = 5362,
  [SMALL_STATE(51)] = 5434,
  [SMALL_STATE(52)] = 5512,
  [SMALL_STATE(53)] = 5582,
  [SMALL_STATE(54)] = 5652,
  [SMALL_STATE(55)] = 5730,
  [SMALL_STATE(56)] = 5802,
  [SMALL_STATE(57)] = 5872,
  [SMALL_STATE(58)] = 5937,
  [SMALL_STATE(59)] = 6002,
  [SMALL_STATE(60)] = 6089,
  [SMALL_STATE(61)] = 6174,
  [SMALL_STATE(62)] = 6239,
  [SMALL_STATE(63)] = 6304,
  [SMALL_STATE(64)] = 6369,
  [SMALL_STATE(65)] = 6434,
  [SMALL_STATE(66)] = 6499,
  [SMALL_STATE(67)] = 6564,
  [SMALL_STATE(68)] = 6629,
  [SMALL_STATE(69)] = 6714,
  [SMALL_STATE(70)] = 6779,
  [SMALL_STATE(71)] = 6844,
  [SMALL_STATE(72)] = 6909,
  [SMALL_STATE(73)] = 6974,
  [SMALL_STATE(74)] = 7039,
  [SMALL_STATE(75)] = 7104,
  [SMALL_STATE(76)] = 7169,
  [SMALL_STATE(77)] = 7234,
  [SMALL_STATE(78)] = 7299,
  [SMALL_STATE(79)] = 7364,
  [SMALL_STATE(80)] = 7429,
  [SMALL_STATE(81)] = 7494,
  [SMALL_STATE(82)] = 7559,
  [SMALL_STATE(83)] = 7624,
  [SMALL_STATE(84)] = 7689,
  [SMALL_STATE(85)] = 7754,
  [SMALL_STATE(86)] = 7819,
  [SMALL_STATE(87)] = 7884,
  [SMALL_STATE(88)] = 7949,
  [SMALL_STATE(89)] = 8014,
  [SMALL_STATE(90)] = 8079,
  [SMALL_STATE(91)] = 8144,
  [SMALL_STATE(92)] = 8233,
  [SMALL_STATE(93)] = 8318,
  [SMALL_STATE(94)] = 8383,
  [SMALL_STATE(95)] = 8452,
  [SMALL_STATE(96)] = 8517,
  [SMALL_STATE(97)] = 8582,
  [SMALL_STATE(98)] = 8647,
  [SMALL_STATE(99)] = 8712,
  [SMALL_STATE(100)] = 8777,
  [SMALL_STATE(101)] = 8842,
  [SMALL_STATE(102)] = 8907,
  [SMALL_STATE(103)] = 8972,
  [SMALL_STATE(104)] = 9037,
  [SMALL_STATE(105)] = 9102,
  [SMALL_STATE(106)] = 9167,
  [SMALL_STATE(107)] = 9254,
  [SMALL_STATE(108)] = 9319,
  [SMALL_STATE(109)] = 9384,
  [SMALL_STATE(110)] = 9468,
  [SMALL_STATE(111)] = 9552,
  [SMALL_STATE(112)] = 9636,
  [SMALL_STATE(113)] = 9704,
  [SMALL_STATE(114)] = 9762,
  [SMALL_STATE(115)] = 9818,
  [SMALL_STATE(116)] = 9876,
  [SMALL_STATE(117)] = 9948,
  [SMALL_STATE(118)] = 10012,
  [SMALL_STATE(119)] = 10076,
  [SMALL_STATE(120)] = 10132,
  [SMALL_STATE(121)] = 10183,
  [SMALL_STATE(122)] = 10234,
  [SMALL_STATE(123)] = 10285,
  [SMALL_STATE(124)] = 10336,
  [SMALL_STATE(125)] = 10387,
  [SMALL_STATE(126)] = 10438,
  [SMALL_STATE(127)] = 10489,
  [SMALL_STATE(128)] = 10540,
  [SMALL_STATE(129)] = 10591,
  [SMALL_STATE(130)] = 10642,
  [SMALL_STATE(131)] = 10693,
  [SMALL_STATE(132)] = 10744,
  [SMALL_STATE(133)] = 10795,
  [SMALL_STATE(134)] = 10846,
  [SMALL_STATE(135)] = 10897,
  [SMALL_STATE(136)] = 10948,
  [SMALL_STATE(137)] = 10999,
  [SMALL_STATE(138)] = 11050,
  [SMALL_STATE(139)] = 11101,
  [SMALL_STATE(140)] = 11152,
  [SMALL_STATE(141)] = 11203,
  [SMALL_STATE(142)] = 11254,
  [SMALL_STATE(143)] = 11305,
  [SMALL_STATE(144)] = 11356,
  [SMALL_STATE(145)] = 11404,
  [SMALL_STATE(146)] = 11452,
  [SMALL_STATE(147)] = 11500,
  [SMALL_STATE(148)] = 11548,
  [SMALL_STATE(149)] = 11596,
  [SMALL_STATE(150)] = 11648,
  [SMALL_STATE(151)] = 11700,
  [SMALL_STATE(152)] = 11750,
  [SMALL_STATE(153)] = 11808,
  [SMALL_STATE(154)] = 11858,
  [SMALL_STATE(155)] = 11916,
  [SMALL_STATE(156)] = 11961,
  [SMALL_STATE(157)] = 12032,
  [SMALL_STATE(158)] = 12103,
  [SMALL_STATE(159)] = 12174,
  [SMALL_STATE(160)] = 12245,
  [SMALL_STATE(161)] = 12316,
  [SMALL_STATE(162)] = 12387,
  [SMALL_STATE(163)] = 12432,
  [SMALL_STATE(164)] = 12503,
  [SMALL_STATE(165)] = 12574,
  [SMALL_STATE(166)] = 12619,
  [SMALL_STATE(167)] = 12664,
  [SMALL_STATE(168)] = 12711,
  [SMALL_STATE(169)] = 12782,
  [SMALL_STATE(170)] = 12827,
  [SMALL_STATE(171)] = 12898,
  [SMALL_STATE(172)] = 12969,
  [SMALL_STATE(173)] = 13014,
  [SMALL_STATE(174)] = 13059,
  [SMALL_STATE(175)] = 13108,
  [SMALL_STATE(176)] = 13179,
  [SMALL_STATE(177)] = 13250,
  [SMALL_STATE(178)] = 13295,
  [SMALL_STATE(179)] = 13340,
  [SMALL_STATE(180)] = 13411,
  [SMALL_STATE(181)] = 13456,
  [SMALL_STATE(182)] = 13501,
  [SMALL_STATE(183)] = 13550,
  [SMALL_STATE(184)] = 13595,
  [SMALL_STATE(185)] = 13642,
  [SMALL_STATE(186)] = 13687,
  [SMALL_STATE(187)] = 13758,
  [SMALL_STATE(188)] = 13829,
  [SMALL_STATE(189)] = 13874,
  [SMALL_STATE(190)] = 13945,
  [SMALL_STATE(191)] = 13990,
  [SMALL_STATE(192)] = 14035,
  [SMALL_STATE(193)] = 14080,
  [SMALL_STATE(194)] = 14125,
  [SMALL_STATE(195)] = 14196,
  [SMALL_STATE(196)] = 14241,
  [SMALL_STATE(197)] = 14310,
  [SMALL_STATE(198)] = 14358,
  [SMALL_STATE(199)] = 14426,
  [SMALL_STATE(200)] = 14470,
  [SMALL_STATE(201)] = 14518,
  [SMALL_STATE(202)] = 14564,
  [SMALL_STATE(203)] = 14608,
  [SMALL_STATE(204)] = 14652,
  [SMALL_STATE(205)] = 14720,
  [SMALL_STATE(206)] = 14788,
  [SMALL_STATE(207)] = 14834,
  [SMALL_STATE(208)] = 14902,
  [SMALL_STATE(209)] = 14970,
  [SMALL_STATE(210)] = 15038,
  [SMALL_STATE(211)] = 15106,
  [SMALL_STATE(212)] = 15174,
  [SMALL_STATE(213)] = 15242,
  [SMALL_STATE(214)] = 15307,
  [SMALL_STATE(215)] = 15350,
  [SMALL_STATE(216)] = 15415,
  [SMALL_STATE(217)] = 15480,
  [SMALL_STATE(218)] = 15545,
  [SMALL_STATE(219)] = 15610,
  [SMALL_STATE(220)] = 15675,
  [SMALL_STATE(221)] = 15740,
  [SMALL_STATE(222)] = 15783,
  [SMALL_STATE(223)] = 15826,
  [SMALL_STATE(224)] = 15891,
  [SMALL_STATE(225)] = 15956,
  [SMALL_STATE(226)] = 16021,
  [SMALL_STATE(227)] = 16064,
  [SMALL_STATE(228)] = 16129,
  [SMALL_STATE(229)] = 16194,
  [SMALL_STATE(230)] = 16259,
  [SMALL_STATE(231)] = 16324,
  [SMALL_STATE(232)] = 16389,
  [SMALL_STATE(233)] = 16454,
  [SMALL_STATE(234)] = 16519,
  [SMALL_STATE(235)] = 16584,
  [SMALL_STATE(236)] = 16649,
  [SMALL_STATE(237)] = 16714,
  [SMALL_STATE(238)] = 16779,
  [SMALL_STATE(239)] = 16844,
  [SMALL_STATE(240)] = 16887,
  [SMALL_STATE(241)] = 16930,
  [SMALL_STATE(242)] = 16973,
  [SMALL_STATE(243)] = 17016,
  [SMALL_STATE(244)] = 17081,
  [SMALL_STATE(245)] = 17146,
  [SMALL_STATE(246)] = 17189,
  [SMALL_STATE(247)] = 17254,
  [SMALL_STATE(248)] = 17319,
  [SMALL_STATE(249)] = 17384,
  [SMALL_STATE(250)] = 17449,
  [SMALL_STATE(251)] = 17516,
  [SMALL_STATE(252)] = 17581,
  [SMALL_STATE(253)] = 17646,
  [SMALL_STATE(254)] = 17711,
  [SMALL_STATE(255)] = 17776,
  [SMALL_STATE(256)] = 17819,
  [SMALL_STATE(257)] = 17864,
  [SMALL_STATE(258)] = 17929,
  [SMALL_STATE(259)] = 17994,
  [SMALL_STATE(260)] = 18059,
  [SMALL_STATE(261)] = 18102,
  [SMALL_STATE(262)] = 18145,
  [SMALL_STATE(263)] = 18188,
  [SMALL_STATE(264)] = 18231,
  [SMALL_STATE(265)] = 18274,
  [SMALL_STATE(266)] = 18319,
  [SMALL_STATE(267)] = 18382,
  [SMALL_STATE(268)] = 18425,
  [SMALL_STATE(269)] = 18490,
  [SMALL_STATE(270)] = 18533,
  [SMALL_STATE(271)] = 18598,
  [SMALL_STATE(272)] = 18663,
  [SMALL_STATE(273)] = 18705,
  [SMALL_STATE(274)] = 18747,
  [SMALL_STATE(275)] = 18811,
  [SMALL_STATE(276)] = 18875,
  [SMALL_STATE(277)] = 18917,
  [SMALL_STATE(278)] = 18959,
  [SMALL_STATE(279)] = 19001,
  [SMALL_STATE(280)] = 19043,
  [SMALL_STATE(281)] = 19107,
  [SMALL_STATE(282)] = 19171,
  [SMALL_STATE(283)] = 19213,
  [SMALL_STATE(284)] = 19255,
  [SMALL_STATE(285)] = 19299,
  [SMALL_STATE(286)] = 19341,
  [SMALL_STATE(287)] = 19383,
  [SMALL_STATE(288)] = 19425,
  [SMALL_STATE(289)] = 19467,
  [SMALL_STATE(290)] = 19509,
  [SMALL_STATE(291)] = 19551,
  [SMALL_STATE(292)] = 19610,
  [SMALL_STATE(293)] = 19668,
  [SMALL_STATE(294)] = 19726,
  [SMALL_STATE(295)] = 19784,
  [SMALL_STATE(296)] = 19842,
  [SMALL_STATE(297)] = 19900,
  [SMALL_STATE(298)] = 19958,
  [SMALL_STATE(299)] = 20016,
  [SMALL_STATE(300)] = 20074,
  [SMALL_STATE(301)] = 20132,
  [SMALL_STATE(302)] = 20190,
  [SMALL_STATE(303)] = 20248,
  [SMALL_STATE(304)] = 20306,
  [SMALL_STATE(305)] = 20364,
  [SMALL_STATE(306)] = 20422,
  [SMALL_STATE(307)] = 20480,
  [SMALL_STATE(308)] = 20538,
  [SMALL_STATE(309)] = 20596,
  [SMALL_STATE(310)] = 20646,
  [SMALL_STATE(311)] = 20698,
  [SMALL_STATE(312)] = 20750,
  [SMALL_STATE(313)] = 20802,
  [SMALL_STATE(314)] = 20854,
  [SMALL_STATE(315)] = 20900,
  [SMALL_STATE(316)] = 20931,
  [SMALL_STATE(317)] = 20962,
  [SMALL_STATE(318)] = 20993,
  [SMALL_STATE(319)] = 21024,
  [SMALL_STATE(320)] = 21050,
  [SMALL_STATE(321)] = 21076,
  [SMALL_STATE(322)] = 21097,
  [SMALL_STATE(323)] = 21118,
  [SMALL_STATE(324)] = 21139,
  [SMALL_STATE(325)] = 21160,
  [SMALL_STATE(326)] = 21181,
  [SMALL_STATE(327)] = 21210,
  [SMALL_STATE(328)] = 21231,
  [SMALL_STATE(329)] = 21252,
  [SMALL_STATE(330)] = 21273,
  [SMALL_STATE(331)] = 21294,
  [SMALL_STATE(332)] = 21315,
  [SMALL_STATE(333)] = 21336,
  [SMALL_STATE(334)] = 21357,
  [SMALL_STATE(335)] = 21378,
  [SMALL_STATE(336)] = 21407,
  [SMALL_STATE(337)] = 21428,
  [SMALL_STATE(338)] = 21449,
  [SMALL_STATE(339)] = 21476,
  [SMALL_STATE(340)] = 21496,
  [SMALL_STATE(341)] = 21516,
  [SMALL_STATE(342)] = 21536,
  [SMALL_STATE(343)] = 21556,
  [SMALL_STATE(344)] = 21576,
  [SMALL_STATE(345)] = 21596,
  [SMALL_STATE(346)] = 21616,
  [SMALL_STATE(347)] = 21636,
  [SMALL_STATE(348)] = 21656,
  [SMALL_STATE(349)] = 21676,
  [SMALL_STATE(350)] = 21699,
  [SMALL_STATE(351)] = 21718,
  [SMALL_STATE(352)] = 21737,
  [SMALL_STATE(353)] = 21757,
  [SMALL_STATE(354)] = 21777,
  [SMALL_STATE(355)] = 21799,
  [SMALL_STATE(356)] = 21821,
  [SMALL_STATE(357)] = 21839,
  [SMALL_STATE(358)] = 21861,
  [SMALL_STATE(359)] = 21883,
  [SMALL_STATE(360)] = 21905,
  [SMALL_STATE(361)] = 21927,
  [SMALL_STATE(362)] = 21949,
  [SMALL_STATE(363)] = 21971,
  [SMALL_STATE(364)] = 21993,
  [SMALL_STATE(365)] = 22015,
  [SMALL_STATE(366)] = 22035,
  [SMALL_STATE(367)] = 22057,
  [SMALL_STATE(368)] = 22079,
  [SMALL_STATE(369)] = 22101,
  [SMALL_STATE(370)] = 22123,
  [SMALL_STATE(371)] = 22145,
  [SMALL_STATE(372)] = 22167,
  [SMALL_STATE(373)] = 22189,
  [SMALL_STATE(374)] = 22211,
  [SMALL_STATE(375)] = 22231,
  [SMALL_STATE(376)] = 22251,
  [SMALL_STATE(377)] = 22271,
  [SMALL_STATE(378)] = 22293,
  [SMALL_STATE(379)] = 22315,
  [SMALL_STATE(380)] = 22334,
  [SMALL_STATE(381)] = 22351,
  [SMALL_STATE(382)] = 22370,
  [SMALL_STATE(383)] = 22389,
  [SMALL_STATE(384)] = 22406,
  [SMALL_STATE(385)] = 22425,
  [SMALL_STATE(386)] = 22444,
  [SMALL_STATE(387)] = 22463,
  [SMALL_STATE(388)] = 22480,
  [SMALL_STATE(389)] = 22499,
  [SMALL_STATE(390)] = 22518,
  [SMALL_STATE(391)] = 22537,
  [SMALL_STATE(392)] = 22552,
  [SMALL_STATE(393)] = 22571,
  [SMALL_STATE(394)] = 22590,
  [SMALL_STATE(395)] = 22609,
  [SMALL_STATE(396)] = 22626,
  [SMALL_STATE(397)] = 22643,
  [SMALL_STATE(398)] = 22662,
  [SMALL_STATE(399)] = 22679,
  [SMALL_STATE(400)] = 22694,
  [SMALL_STATE(401)] = 22713,
  [SMALL_STATE(402)] = 22730,
  [SMALL_STATE(403)] = 22749,
  [SMALL_STATE(404)] = 22768,
  [SMALL_STATE(405)] = 22787,
  [SMALL_STATE(406)] = 22806,
  [SMALL_STATE(407)] = 22825,
  [SMALL_STATE(408)] = 22844,
  [SMALL_STATE(409)] = 22861,
  [SMALL_STATE(410)] = 22880,
  [SMALL_STATE(411)] = 22899,
  [SMALL_STATE(412)] = 22918,
  [SMALL_STATE(413)] = 22935,
  [SMALL_STATE(414)] = 22954,
  [SMALL_STATE(415)] = 22973,
  [SMALL_STATE(416)] = 22990,
  [SMALL_STATE(417)] = 23009,
  [SMALL_STATE(418)] = 23028,
  [SMALL_STATE(419)] = 23045,
  [SMALL_STATE(420)] = 23062,
  [SMALL_STATE(421)] = 23081,
  [SMALL_STATE(422)] = 23098,
  [SMALL_STATE(423)] = 23117,
  [SMALL_STATE(424)] = 23136,
  [SMALL_STATE(425)] = 23155,
  [SMALL_STATE(426)] = 23174,
  [SMALL_STATE(427)] = 23193,
  [SMALL_STATE(428)] = 23212,
  [SMALL_STATE(429)] = 23231,
  [SMALL_STATE(430)] = 23250,
  [SMALL_STATE(431)] = 23267,
  [SMALL_STATE(432)] = 23284,
  [SMALL_STATE(433)] = 23303,
  [SMALL_STATE(434)] = 23320,
  [SMALL_STATE(435)] = 23339,
  [SMALL_STATE(436)] = 23358,
  [SMALL_STATE(437)] = 23377,
  [SMALL_STATE(438)] = 23396,
  [SMALL_STATE(439)] = 23415,
  [SMALL_STATE(440)] = 23432,
  [SMALL_STATE(441)] = 23451,
  [SMALL_STATE(442)] = 23468,
  [SMALL_STATE(443)] = 23482,
  [SMALL_STATE(444)] = 23498,
  [SMALL_STATE(445)] = 23514,
  [SMALL_STATE(446)] = 23530,
  [SMALL_STATE(447)] = 23540,
  [SMALL_STATE(448)] = 23554,
  [SMALL_STATE(449)] = 23564,
  [SMALL_STATE(450)] = 23580,
  [SMALL_STATE(451)] = 23594,
  [SMALL_STATE(452)] = 23604,
  [SMALL_STATE(453)] = 23620,
  [SMALL_STATE(454)] = 23636,
  [SMALL_STATE(455)] = 23652,
  [SMALL_STATE(456)] = 23668,
  [SMALL_STATE(457)] = 23684,
  [SMALL_STATE(458)] = 23700,
  [SMALL_STATE(459)] = 23716,
  [SMALL_STATE(460)] = 23732,
  [SMALL_STATE(461)] = 23748,
  [SMALL_STATE(462)] = 23764,
  [SMALL_STATE(463)] = 23780,
  [SMALL_STATE(464)] = 23794,
  [SMALL_STATE(465)] = 23810,
  [SMALL_STATE(466)] = 23826,
  [SMALL_STATE(467)] = 23842,
  [SMALL_STATE(468)] = 23856,
  [SMALL_STATE(469)] = 23872,
  [SMALL_STATE(470)] = 23886,
  [SMALL_STATE(471)] = 23900,
  [SMALL_STATE(472)] = 23914,
  [SMALL_STATE(473)] = 23928,
  [SMALL_STATE(474)] = 23942,
  [SMALL_STATE(475)] = 23958,
  [SMALL_STATE(476)] = 23974,
  [SMALL_STATE(477)] = 23987,
  [SMALL_STATE(478)] = 24000,
  [SMALL_STATE(479)] = 24013,
  [SMALL_STATE(480)] = 24026,
  [SMALL_STATE(481)] = 24039,
  [SMALL_STATE(482)] = 24052,
  [SMALL_STATE(483)] = 24065,
  [SMALL_STATE(484)] = 24078,
  [SMALL_STATE(485)] = 24091,
  [SMALL_STATE(486)] = 24104,
  [SMALL_STATE(487)] = 24117,
  [SMALL_STATE(488)] = 24130,
  [SMALL_STATE(489)] = 24143,
  [SMALL_STATE(490)] = 24156,
  [SMALL_STATE(491)] = 24169,
  [SMALL_STATE(492)] = 24182,
  [SMALL_STATE(493)] = 24195,
  [SMALL_STATE(494)] = 24208,
  [SMALL_STATE(495)] = 24221,
  [SMALL_STATE(496)] = 24234,
  [SMALL_STATE(497)] = 24247,
  [SMALL_STATE(498)] = 24260,
  [SMALL_STATE(499)] = 24273,
  [SMALL_STATE(500)] = 24286,
  [SMALL_STATE(501)] = 24299,
  [SMALL_STATE(502)] = 24312,
  [SMALL_STATE(503)] = 24325,
  [SMALL_STATE(504)] = 24338,
  [SMALL_STATE(505)] = 24351,
  [SMALL_STATE(506)] = 24364,
  [SMALL_STATE(507)] = 24377,
  [SMALL_STATE(508)] = 24390,
  [SMALL_STATE(509)] = 24403,
  [SMALL_STATE(510)] = 24416,
  [SMALL_STATE(511)] = 24429,
  [SMALL_STATE(512)] = 24442,
  [SMALL_STATE(513)] = 24455,
  [SMALL_STATE(514)] = 24468,
  [SMALL_STATE(515)] = 24481,
  [SMALL_STATE(516)] = 24494,
  [SMALL_STATE(517)] = 24507,
  [SMALL_STATE(518)] = 24520,
  [SMALL_STATE(519)] = 24533,
  [SMALL_STATE(520)] = 24546,
  [SMALL_STATE(521)] = 24559,
  [SMALL_STATE(522)] = 24572,
  [SMALL_STATE(523)] = 24585,
  [SMALL_STATE(524)] = 24598,
  [SMALL_STATE(525)] = 24611,
  [SMALL_STATE(526)] = 24624,
  [SMALL_STATE(527)] = 24637,
  [SMALL_STATE(528)] = 24650,
  [SMALL_STATE(529)] = 24663,
  [SMALL_STATE(530)] = 24676,
  [SMALL_STATE(531)] = 24689,
  [SMALL_STATE(532)] = 24702,
  [SMALL_STATE(533)] = 24715,
  [SMALL_STATE(534)] = 24728,
  [SMALL_STATE(535)] = 24732,
  [SMALL_STATE(536)] = 24736,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(536),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [7] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(364),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(69),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(527),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(40),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(218),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(223),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(526),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(521),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(520),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(517),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(516),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(290),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(452),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(379),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(455),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [73] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [75] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(364),
  [78] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(400),
  [81] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(69),
  [84] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(69),
  [87] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(527),
  [90] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(41),
  [93] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(40),
  [96] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(218),
  [99] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(223),
  [102] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(223),
  [105] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(9),
  [108] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(526),
  [111] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(521),
  [114] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(208),
  [117] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(520),
  [120] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(517),
  [123] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(516),
  [126] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(290),
  [129] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(452),
  [132] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(379),
  [135] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(455),
  [138] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [142] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [144] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [150] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [152] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [154] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [164] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 2),
  [166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [180] = {.entry = {.count = 1, .reusable = false}}, SHIFT(363),
  [182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [186] = {.entry = {.count = 1, .reusable = false}}, SHIFT(80),
  [188] = {.entry = {.count = 1, .reusable = false}}, SHIFT(519),
  [190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [192] = {.entry = {.count = 1, .reusable = false}}, SHIFT(58),
  [194] = {.entry = {.count = 1, .reusable = false}}, SHIFT(243),
  [196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [198] = {.entry = {.count = 1, .reusable = false}}, SHIFT(229),
  [200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [202] = {.entry = {.count = 1, .reusable = false}}, SHIFT(503),
  [204] = {.entry = {.count = 1, .reusable = false}}, SHIFT(504),
  [206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [208] = {.entry = {.count = 1, .reusable = false}}, SHIFT(532),
  [210] = {.entry = {.count = 1, .reusable = false}}, SHIFT(506),
  [212] = {.entry = {.count = 1, .reusable = false}}, SHIFT(525),
  [214] = {.entry = {.count = 1, .reusable = false}}, SHIFT(245),
  [216] = {.entry = {.count = 1, .reusable = false}}, SHIFT(461),
  [218] = {.entry = {.count = 1, .reusable = false}}, SHIFT(368),
  [220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [224] = {.entry = {.count = 1, .reusable = false}}, SHIFT(162),
  [226] = {.entry = {.count = 1, .reusable = false}}, SHIFT(502),
  [228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [230] = {.entry = {.count = 1, .reusable = false}}, SHIFT(144),
  [232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [234] = {.entry = {.count = 1, .reusable = false}}, SHIFT(244),
  [236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [242] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3),
  [244] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3),
  [246] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2),
  [248] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2),
  [250] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number, 3),
  [252] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number, 3),
  [254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1),
  [256] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean, 1),
  [258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number, 1),
  [260] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number, 1),
  [262] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conditional, 5),
  [264] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional, 5),
  [266] = {.entry = {.count = 1, .reusable = false}}, SHIFT(251),
  [268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [276] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2),
  [278] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2),
  [280] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 5),
  [282] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 5),
  [284] = {.entry = {.count = 1, .reusable = false}}, SHIFT(257),
  [286] = {.entry = {.count = 1, .reusable = false}}, SHIFT(219),
  [288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [298] = {.entry = {.count = 1, .reusable = false}}, SHIFT(483),
  [300] = {.entry = {.count = 1, .reusable = false}}, SHIFT(216),
  [302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [304] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_expression, 4),
  [306] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_expression, 4),
  [308] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 3),
  [310] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_range, 3),
  [312] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_statement, 5),
  [314] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 5),
  [316] = {.entry = {.count = 1, .reusable = false}}, SHIFT(32),
  [318] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, .production_id = 2),
  [320] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, .production_id = 2),
  [322] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_expression, 3),
  [324] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_expression, 3),
  [326] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map, 3),
  [328] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_map, 3),
  [330] = {.entry = {.count = 1, .reusable = false}}, SHIFT(252),
  [332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [334] = {.entry = {.count = 1, .reusable = false}}, SHIFT(489),
  [336] = {.entry = {.count = 1, .reusable = false}}, SHIFT(246),
  [338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [340] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment, 3, .production_id = 1),
  [342] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignment, 3, .production_id = 1),
  [344] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_subscript, 4),
  [346] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_subscript, 4),
  [348] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_index_expression, 3),
  [350] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_index_expression, 3),
  [352] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map, 5),
  [354] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_map, 5),
  [356] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_expression, 5),
  [358] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_expression, 5),
  [360] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map, 2),
  [362] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_map, 2),
  [364] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_body, 2),
  [366] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_body, 2),
  [368] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 2),
  [370] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 2),
  [372] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1),
  [374] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1),
  [376] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_body, 5),
  [378] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_body, 5),
  [380] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_expression, 2),
  [382] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_expression, 2),
  [384] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_body, 6, .production_id = 11),
  [386] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_body, 6, .production_id = 11),
  [388] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map, 4),
  [390] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_map, 4),
  [392] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_body, 3, .production_id = 5),
  [394] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_body, 3, .production_id = 5),
  [396] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_raw_string, 3),
  [398] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_raw_string, 3),
  [400] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 3),
  [402] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 3),
  [404] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_raw_string, 2),
  [406] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_raw_string, 2),
  [408] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 1),
  [410] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 1),
  [412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [414] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_definition, 4, .production_id = 3),
  [416] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_definition, 4, .production_id = 3),
  [418] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block, 2),
  [420] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block, 2),
  [422] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 2),
  [424] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 2),
  [426] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 4),
  [428] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 4),
  [430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [434] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 1),
  [436] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 1),
  [438] = {.entry = {.count = 1, .reusable = false}}, SHIFT(234),
  [440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [446] = {.entry = {.count = 1, .reusable = false}}, SHIFT(498),
  [448] = {.entry = {.count = 1, .reusable = false}}, SHIFT(233),
  [450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [456] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [458] = {.entry = {.count = 1, .reusable = false}}, SHIFT(258),
  [460] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [480] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_import_statement_repeat1, 2),
  [482] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_import_statement_repeat1, 2),
  [484] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_import_statement_repeat1, 2), SHIFT_REPEAT(394),
  [487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [491] = {.entry = {.count = 1, .reusable = false}}, SHIFT(373),
  [493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [499] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [501] = {.entry = {.count = 1, .reusable = false}}, SHIFT(515),
  [503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [505] = {.entry = {.count = 1, .reusable = false}}, SHIFT(125),
  [507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [509] = {.entry = {.count = 1, .reusable = false}}, SHIFT(238),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [515] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 5),
  [517] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_statement, 5),
  [519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [527] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 4),
  [529] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_statement, 4),
  [531] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__import_entry, 1),
  [533] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__import_entry, 1),
  [535] = {.entry = {.count = 1, .reusable = false}}, SHIFT(508),
  [537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [545] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(373),
  [548] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2),
  [550] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(436),
  [553] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(129),
  [556] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(129),
  [559] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(515),
  [562] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(131),
  [565] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(125),
  [568] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(238),
  [571] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(238),
  [574] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(158),
  [577] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(210),
  [580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [584] = {.entry = {.count = 1, .reusable = false}}, SHIFT(485),
  [586] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rename, 3),
  [588] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rename, 3),
  [590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [592] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_import_statement_repeat1, 2), SHIFT_REPEAT(381),
  [595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [599] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 7, .production_id = 9),
  [601] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 7, .production_id = 9),
  [603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [607] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block, 3),
  [609] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block, 3),
  [611] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 7, .production_id = 10),
  [613] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 7, .production_id = 10),
  [615] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_definition, 6),
  [617] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_definition, 6),
  [619] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__statement, 1),
  [621] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__statement, 1),
  [623] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 1),
  [625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [627] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 1),
  [629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [631] = {.entry = {.count = 1, .reusable = false}}, SHIFT(501),
  [633] = {.entry = {.count = 1, .reusable = false}}, SHIFT(259),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [637] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 2),
  [639] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_statement, 2),
  [641] = {.entry = {.count = 1, .reusable = false}}, SHIFT(429),
  [643] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_body, 3),
  [645] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_body, 3),
  [647] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_definition, 5),
  [649] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_definition, 5),
  [651] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_definition, 4),
  [653] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_definition, 4),
  [655] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2),
  [657] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_argument_list_repeat1, 2),
  [659] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_body, 2),
  [661] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_body, 2),
  [663] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_definition, 3),
  [665] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_definition, 3),
  [667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [669] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [675] = {.entry = {.count = 1, .reusable = false}}, SHIFT(437),
  [677] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pair, 3),
  [679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [693] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [695] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [697] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [707] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_class_body_repeat2, 2), SHIFT_REPEAT(362),
  [710] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_body_repeat2, 2),
  [712] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_class_body_repeat2, 2), SHIFT_REPEAT(406),
  [715] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_class_body_repeat2, 2), SHIFT_REPEAT(423),
  [718] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_class_body_repeat2, 2), SHIFT_REPEAT(457),
  [721] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_class_body_repeat2, 2), SHIFT_REPEAT(420),
  [724] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_class_body_repeat2, 2), SHIFT_REPEAT(462),
  [727] = {.entry = {.count = 1, .reusable = false}}, SHIFT(362),
  [729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [735] = {.entry = {.count = 1, .reusable = false}}, SHIFT(457),
  [737] = {.entry = {.count = 1, .reusable = false}}, SHIFT(420),
  [739] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [741] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [743] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [747] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [749] = {.entry = {.count = 1, .reusable = false}}, SHIFT(447),
  [751] = {.entry = {.count = 1, .reusable = false}}, SHIFT(523),
  [753] = {.entry = {.count = 1, .reusable = true}}, SHIFT(473),
  [755] = {.entry = {.count = 1, .reusable = false}}, SHIFT(442),
  [757] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [759] = {.entry = {.count = 1, .reusable = false}}, SHIFT(340),
  [761] = {.entry = {.count = 1, .reusable = false}}, SHIFT(524),
  [763] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [765] = {.entry = {.count = 1, .reusable = false}}, SHIFT(347),
  [767] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [769] = {.entry = {.count = 1, .reusable = false}}, SHIFT(351),
  [771] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [773] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_class_body_repeat1, 2),
  [775] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_body_repeat1, 2),
  [777] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_class_body_repeat1, 2), SHIFT_REPEAT(462),
  [780] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute_value, 1),
  [782] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [784] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [786] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_value, 1),
  [788] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method_definition, 5, .production_id = 11),
  [790] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_definition, 5, .production_id = 11),
  [792] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_prefix_operator_definition, 2, .production_id = 5),
  [794] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_prefix_operator_definition, 2, .production_id = 5),
  [796] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constructor, 2),
  [798] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constructor, 2),
  [800] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_static_getter_definition, 2, .production_id = 7),
  [802] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_static_getter_definition, 2, .production_id = 7),
  [804] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [806] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_subscript_operator_definition, 4, .production_id = 8),
  [808] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_subscript_operator_definition, 4, .production_id = 8),
  [810] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_static_method_definition, 2),
  [812] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_static_method_definition, 2),
  [814] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method_definition, 4, .production_id = 8),
  [816] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_definition, 4, .production_id = 8),
  [818] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_class_body_repeat2, 2),
  [820] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_class_body_repeat2, 1),
  [822] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_body_repeat2, 1),
  [824] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_setter_definition, 6, .production_id = 12),
  [826] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_setter_definition, 6, .production_id = 12),
  [828] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_getter_definition, 2, .production_id = 5),
  [830] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_getter_definition, 2, .production_id = 5),
  [832] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_infix_operator_definition, 5, .production_id = 11),
  [834] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_infix_operator_definition, 5, .production_id = 11),
  [836] = {.entry = {.count = 1, .reusable = true}}, SHIFT(493),
  [838] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_subscript_setter_definition, 8, .production_id = 13),
  [840] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_subscript_setter_definition, 8, .production_id = 13),
  [842] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_definition_repeat1, 2),
  [844] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_class_definition_repeat1, 2), SHIFT_REPEAT(452),
  [847] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_class_definition_repeat1, 2), SHIFT_REPEAT(379),
  [850] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_class_body_repeat1, 1),
  [852] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_body_repeat1, 1),
  [854] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute_value, 3, .production_id = 4),
  [856] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_value, 3, .production_id = 4),
  [858] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute, 6),
  [860] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 6),
  [862] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute, 5),
  [864] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 5),
  [866] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute, 2),
  [868] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 2),
  [870] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [872] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [874] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2), SHIFT_REPEAT(220),
  [877] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat2, 2),
  [879] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat2, 2), SHIFT_REPEAT(380),
  [882] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat2, 2), SHIFT_REPEAT(171),
  [885] = {.entry = {.count = 1, .reusable = false}}, SHIFT(536),
  [887] = {.entry = {.count = 1, .reusable = false}}, SHIFT(392),
  [889] = {.entry = {.count = 1, .reusable = false}}, SHIFT(239),
  [891] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [893] = {.entry = {.count = 1, .reusable = false}}, SHIFT(171),
  [895] = {.entry = {.count = 1, .reusable = false}}, SHIFT(242),
  [897] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2),
  [899] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2), SHIFT_REPEAT(464),
  [902] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [904] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [906] = {.entry = {.count = 1, .reusable = false}}, SHIFT(469),
  [908] = {.entry = {.count = 1, .reusable = false}}, SHIFT(470),
  [910] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [912] = {.entry = {.count = 1, .reusable = false}}, SHIFT(289),
  [914] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [916] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [918] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [920] = {.entry = {.count = 1, .reusable = false}}, SHIFT(76),
  [922] = {.entry = {.count = 1, .reusable = false}}, SHIFT(38),
  [924] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 2),
  [926] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [928] = {.entry = {.count = 1, .reusable = false}}, SHIFT(278),
  [930] = {.entry = {.count = 1, .reusable = false}}, SHIFT(147),
  [932] = {.entry = {.count = 1, .reusable = false}}, SHIFT(146),
  [934] = {.entry = {.count = 1, .reusable = false}}, SHIFT(37),
  [936] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [938] = {.entry = {.count = 1, .reusable = false}}, SHIFT(343),
  [940] = {.entry = {.count = 1, .reusable = false}}, SHIFT(344),
  [942] = {.entry = {.count = 1, .reusable = false}}, SHIFT(136),
  [944] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_runtime_attribute_repeat1, 2),
  [946] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_runtime_attribute_repeat1, 2), SHIFT_REPEAT(419),
  [949] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 1),
  [951] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 2),
  [953] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [955] = {.entry = {.count = 1, .reusable = true}}, SHIFT(465),
  [957] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [959] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [961] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [963] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat2, 1),
  [965] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat2, 1),
  [967] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [969] = {.entry = {.count = 1, .reusable = false}}, SHIFT(81),
  [971] = {.entry = {.count = 1, .reusable = false}}, SHIFT(467),
  [973] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_runtime_attribute, 5),
  [975] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_runtime_attribute, 5),
  [977] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [979] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [981] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [983] = {.entry = {.count = 1, .reusable = true}}, SHIFT(474),
  [985] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [987] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [989] = {.entry = {.count = 1, .reusable = true}}, SHIFT(510),
  [991] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [993] = {.entry = {.count = 1, .reusable = false}}, SHIFT(105),
  [995] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 1, .production_id = 6),
  [997] = {.entry = {.count = 1, .reusable = false}}, SHIFT(416),
  [999] = {.entry = {.count = 1, .reusable = false}}, SHIFT(451),
  [1001] = {.entry = {.count = 1, .reusable = false}}, SHIFT(402),
  [1003] = {.entry = {.count = 1, .reusable = false}}, SHIFT(534),
  [1005] = {.entry = {.count = 1, .reusable = false}}, SHIFT(90),
  [1007] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [1009] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_definition_repeat1, 1),
  [1011] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_class_definition_repeat1, 1),
  [1013] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [1015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [1017] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_runtime_attribute, 2),
  [1019] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_runtime_attribute, 2),
  [1021] = {.entry = {.count = 1, .reusable = false}}, SHIFT(100),
  [1023] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [1025] = {.entry = {.count = 1, .reusable = false}}, SHIFT(409),
  [1027] = {.entry = {.count = 1, .reusable = false}}, SHIFT(448),
  [1029] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [1031] = {.entry = {.count = 1, .reusable = false}}, SHIFT(169),
  [1033] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [1035] = {.entry = {.count = 1, .reusable = true}}, SHIFT(475),
  [1037] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [1039] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_comment_repeat1, 2), SHIFT_REPEAT(408),
  [1042] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_comment_repeat1, 2), SHIFT_REPEAT(451),
  [1045] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_comment_repeat1, 2), SHIFT_REPEAT(402),
  [1048] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_comment_repeat1, 2),
  [1050] = {.entry = {.count = 1, .reusable = false}}, SHIFT(408),
  [1052] = {.entry = {.count = 1, .reusable = false}}, SHIFT(446),
  [1054] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [1056] = {.entry = {.count = 1, .reusable = false}}, SHIFT(183),
  [1058] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat2, 2),
  [1060] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [1062] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [1064] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [1066] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_runtime_attribute, 4),
  [1068] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_runtime_attribute, 4),
  [1070] = {.entry = {.count = 1, .reusable = false}}, SHIFT(535),
  [1072] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [1074] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [1076] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__any_attribute, 1),
  [1078] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__any_attribute, 1),
  [1080] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [1082] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [1084] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_raw_string_repeat1, 2),
  [1086] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_raw_string_repeat1, 2), SHIFT_REPEAT(467),
  [1089] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [1091] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [1093] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [1095] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [1097] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [1099] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [1101] = {.entry = {.count = 1, .reusable = false}}, SHIFT(124),
  [1103] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_map_repeat1, 2),
  [1105] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_map_repeat1, 2), SHIFT_REPEAT(207),
  [1108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [1110] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat2, 3),
  [1112] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat2, 3),
  [1114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [1116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [1118] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [1120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [1122] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_attribute_repeat1, 2),
  [1124] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_attribute_repeat1, 2), SHIFT_REPEAT(474),
  [1127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [1129] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_runtime_attribute, 3),
  [1131] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_runtime_attribute, 3),
  [1133] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comment, 3),
  [1135] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comment, 2),
  [1137] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comment, 1),
  [1139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [1141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [1143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(479),
  [1145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [1147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [1149] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_raw_string_repeat1, 1),
  [1151] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [1155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [1157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [1159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [1161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [1163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [1165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [1167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [1169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [1171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [1173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [1175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [1177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [1179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [1181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [1183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [1185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [1187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [1189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [1191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [1193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [1195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(456),
  [1197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [1199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [1201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [1203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(500),
  [1205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [1207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(453),
  [1209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(533),
  [1211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [1213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [1215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [1217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(454),
  [1219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [1221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [1223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [1225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [1227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [1229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [1231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [1233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [1235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(507),
  [1237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [1239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [1241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [1243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [1245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
  [1247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [1249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [1251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [1253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [1255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [1257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [1259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [1261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [1263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(528),
  [1265] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 2),
  [1267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 3),
  [1269] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 1),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_wren(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
