#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 587
#define LARGE_STATE_COUNT 249
#define SYMBOL_COUNT 215
#define ALIAS_COUNT 5
#define TOKEN_COUNT 143
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 12
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 26

enum {
  anon_sym_export = 1,
  anon_sym_struct = 2,
  anon_sym_LBRACE = 3,
  anon_sym_COLON = 4,
  anon_sym_COMMA = 5,
  anon_sym_RBRACE = 6,
  anon_sym_as = 7,
  anon_sym_global = 8,
  anon_sym_import = 9,
  anon_sym_from = 10,
  anon_sym_SEMI = 11,
  anon_sym_component = 12,
  anon_sym_COLON_EQ = 13,
  anon_sym_inherits = 14,
  anon_sym_if = 15,
  anon_sym_AT = 16,
  anon_sym_transitions = 17,
  anon_sym_LBRACK = 18,
  anon_sym_in = 19,
  anon_sym_out = 20,
  anon_sym_RBRACK = 21,
  anon_sym_states = 22,
  anon_sym_animate = 23,
  anon_sym_STAR = 24,
  anon_sym_for = 25,
  anon_sym_callback = 26,
  anon_sym_DASH_GT = 27,
  anon_sym_LT_EQ_GT = 28,
  anon_sym_LPAREN = 29,
  anon_sym_RPAREN = 30,
  anon_sym_EQ_GT = 31,
  anon_sym_in_DASHout = 32,
  anon_sym_property = 33,
  anon_sym_LT = 34,
  anon_sym_GT = 35,
  anon_sym_else = 36,
  anon_sym_when = 37,
  anon_sym_EQ = 38,
  anon_sym_PLUS_EQ = 39,
  anon_sym_DASH_EQ = 40,
  anon_sym_STAR_EQ = 41,
  anon_sym_SLASH_EQ = 42,
  anon_sym_PERCENT_EQ = 43,
  anon_sym_AMP_EQ = 44,
  anon_sym_PIPE_EQ = 45,
  anon_sym_CARET_EQ = 46,
  anon_sym_LT_LT_EQ = 47,
  anon_sym_GT_GT_EQ = 48,
  anon_sym_DOT = 49,
  anon_sym_true = 50,
  anon_sym_false = 51,
  anon_sym_DASH = 52,
  anon_sym_BANG = 53,
  anon_sym_AMP_AMP = 54,
  anon_sym_PIPE_PIPE = 55,
  anon_sym_AMP = 56,
  anon_sym_PIPE = 57,
  anon_sym_CARET = 58,
  anon_sym_EQ_EQ = 59,
  anon_sym_BANG_EQ = 60,
  anon_sym_LT_EQ = 61,
  anon_sym_GT_EQ = 62,
  anon_sym_LT_LT = 63,
  anon_sym_GT_GT = 64,
  anon_sym_PLUS = 65,
  anon_sym_SLASH = 66,
  anon_sym_QMARK = 67,
  sym_children_macro = 68,
  anon_sym_linear_DASHgradient = 69,
  anon_sym_radial_DASHgradient = 70,
  anon_sym_circle = 71,
  anon_sym_image_DASHurl = 72,
  anon_sym_DQUOTE = 73,
  anon_sym_SQUOTE = 74,
  sym__unescaped_double_string_fragment = 75,
  sym__unescaped_single_string_fragment = 76,
  sym_escape_sequence = 77,
  sym__ident_reg = 78,
  anon_sym_POUND = 79,
  aux_sym_color_literal_token1 = 80,
  aux_sym_color_literal_token2 = 81,
  aux_sym_color_literal_token3 = 82,
  sym_int_literal = 83,
  sym_float_literal = 84,
  anon_sym_px = 85,
  anon_sym_ms = 86,
  anon_sym_PERCENT = 87,
  anon_sym_deg = 88,
  anon_sym_rad = 89,
  anon_sym_ease = 90,
  anon_sym_ease_DASHin = 91,
  anon_sym_ease_in = 92,
  anon_sym_ease_in_out = 93,
  anon_sym_ease_DASHin_DASHout = 94,
  anon_sym_ease_out = 95,
  anon_sym_ease_DASHout = 96,
  anon_sym_start = 97,
  anon_sym_end = 98,
  anon_sym_black = 99,
  anon_sym_blue = 100,
  anon_sym_green = 101,
  anon_sym_red = 102,
  anon_sym_yellow = 103,
  anon_sym_white = 104,
  anon_sym_gray = 105,
  anon_sym_transparent = 106,
  anon_sym_angle = 107,
  anon_sym_bool = 108,
  anon_sym_brush = 109,
  anon_sym_color = 110,
  anon_sym_float = 111,
  anon_sym_image = 112,
  anon_sym_int = 113,
  anon_sym_length = 114,
  anon_sym_percent = 115,
  anon_sym_physical_DASHlength = 116,
  anon_sym_physical_length = 117,
  anon_sym_string = 118,
  anon_sym_debug = 119,
  anon_sym_animation_DASHtick = 120,
  anon_sym_min = 121,
  anon_sym_max = 122,
  anon_sym_mod = 123,
  anon_sym_abs = 124,
  anon_sym_round = 125,
  anon_sym_ceil = 126,
  anon_sym_floor = 127,
  anon_sym_sin = 128,
  anon_sym_cos = 129,
  anon_sym_tan = 130,
  anon_sym_asin = 131,
  anon_sym_acos = 132,
  anon_sym_atan = 133,
  anon_sym_sqrt = 134,
  anon_sym_pow = 135,
  anon_sym_log = 136,
  anon_sym_rgb = 137,
  anon_sym_easing = 138,
  anon_sym_duration = 139,
  anon_sym_parent = 140,
  anon_sym_root = 141,
  sym_comment = 142,
  sym_source_file = 143,
  sym__item = 144,
  sym_struct_item = 145,
  sym_struct_block_definition = 146,
  sym_export_statement = 147,
  sym_global_single = 148,
  sym_import_statement = 149,
  sym_component_item = 150,
  sym__conditional_element = 151,
  sym__component_body = 152,
  sym_transition_statement = 153,
  sym_state_statement = 154,
  sym_animate_statement = 155,
  sym_for_loop = 156,
  sym__property = 157,
  sym_call_back_definition = 158,
  sym_call_back_parameters = 159,
  sym_call_back_handler = 160,
  sym_handler_body = 161,
  sym_two_way_property = 162,
  sym_define_assign_property = 163,
  sym__define_property = 164,
  sym__assign_property = 165,
  sym__expression = 166,
  sym__all_expressions = 167,
  sym_if_expression = 168,
  sym_consequence_body = 169,
  sym_state_expression = 170,
  sym_index_expression = 171,
  sym_assign_expression = 172,
  sym_comp_assign_expression = 173,
  sym_call_expression = 174,
  sym_function_call_args = 175,
  sym_field_expression = 176,
  sym_bool_literal = 177,
  sym_unary_expression = 178,
  sym_binary_expression = 179,
  sym_ternary_expression = 180,
  sym__macro = 181,
  sym_linear_grad_macro = 182,
  sym_radial_grad_macro = 183,
  sym_image_macro = 184,
  sym__literal = 185,
  sym_array_literal = 186,
  sym_string_literal = 187,
  sym_vis = 188,
  sym_identifier = 189,
  sym_color_literal = 190,
  sym__number = 191,
  sym_num_units = 192,
  sym_units = 193,
  sym__type_identifier = 194,
  sym__function_identifier = 195,
  sym__builtin = 196,
  sym_constant_builtin = 197,
  sym_type_builtin = 198,
  sym_function_builtin = 199,
  sym_variable_builtin = 200,
  aux_sym_source_file_repeat1 = 201,
  aux_sym_struct_block_definition_repeat1 = 202,
  aux_sym_export_statement_repeat1 = 203,
  aux_sym_import_statement_repeat1 = 204,
  aux_sym__component_body_repeat1 = 205,
  aux_sym_transition_statement_repeat1 = 206,
  aux_sym_state_statement_repeat1 = 207,
  aux_sym_state_statement_repeat2 = 208,
  aux_sym_animate_statement_repeat1 = 209,
  aux_sym_call_back_parameters_repeat1 = 210,
  aux_sym_consequence_body_repeat1 = 211,
  aux_sym_linear_grad_macro_repeat1 = 212,
  aux_sym_string_literal_repeat1 = 213,
  aux_sym_string_literal_repeat2 = 214,
  alias_sym_assign_property = 215,
  alias_sym_comp_body = 216,
  alias_sym_define_property = 217,
  alias_sym_function_identifier = 218,
  alias_sym_type_identifier = 219,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_export] = "export",
  [anon_sym_struct] = "struct",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COLON] = ":",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_as] = "as",
  [anon_sym_global] = "global",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_SEMI] = ";",
  [anon_sym_component] = "component",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_inherits] = "inherits",
  [anon_sym_if] = "if",
  [anon_sym_AT] = "@",
  [anon_sym_transitions] = "transitions",
  [anon_sym_LBRACK] = "[",
  [anon_sym_in] = "in",
  [anon_sym_out] = "out",
  [anon_sym_RBRACK] = "]",
  [anon_sym_states] = "states",
  [anon_sym_animate] = "animate",
  [anon_sym_STAR] = "*",
  [anon_sym_for] = "for",
  [anon_sym_callback] = "callback",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_LT_EQ_GT] = "<=>",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_in_DASHout] = "in-out",
  [anon_sym_property] = "property",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_else] = "else",
  [anon_sym_when] = "when",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_DOT] = ".",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_DASH] = "-",
  [anon_sym_BANG] = "!",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP] = "&",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_PLUS] = "+",
  [anon_sym_SLASH] = "/",
  [anon_sym_QMARK] = "\?",
  [sym_children_macro] = "children_macro",
  [anon_sym_linear_DASHgradient] = "linear-gradient",
  [anon_sym_radial_DASHgradient] = "radial-gradient",
  [anon_sym_circle] = "circle",
  [anon_sym_image_DASHurl] = "image-url",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [sym__unescaped_double_string_fragment] = "_unescaped_double_string_fragment",
  [sym__unescaped_single_string_fragment] = "_unescaped_single_string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [sym__ident_reg] = "_ident_reg",
  [anon_sym_POUND] = "#",
  [aux_sym_color_literal_token1] = "color_literal_token1",
  [aux_sym_color_literal_token2] = "color_literal_token2",
  [aux_sym_color_literal_token3] = "color_literal_token3",
  [sym_int_literal] = "int_literal",
  [sym_float_literal] = "float_literal",
  [anon_sym_px] = "px",
  [anon_sym_ms] = "ms",
  [anon_sym_PERCENT] = "%",
  [anon_sym_deg] = "deg",
  [anon_sym_rad] = "rad",
  [anon_sym_ease] = "ease",
  [anon_sym_ease_DASHin] = "ease-in",
  [anon_sym_ease_in] = "ease_in",
  [anon_sym_ease_in_out] = "ease_in_out",
  [anon_sym_ease_DASHin_DASHout] = "ease-in-out",
  [anon_sym_ease_out] = "ease_out",
  [anon_sym_ease_DASHout] = "ease-out",
  [anon_sym_start] = "start",
  [anon_sym_end] = "end",
  [anon_sym_black] = "black",
  [anon_sym_blue] = "blue",
  [anon_sym_green] = "green",
  [anon_sym_red] = "red",
  [anon_sym_yellow] = "yellow",
  [anon_sym_white] = "white",
  [anon_sym_gray] = "gray",
  [anon_sym_transparent] = "transparent",
  [anon_sym_angle] = "angle",
  [anon_sym_bool] = "bool",
  [anon_sym_brush] = "brush",
  [anon_sym_color] = "color",
  [anon_sym_float] = "float",
  [anon_sym_image] = "image",
  [anon_sym_int] = "int",
  [anon_sym_length] = "length",
  [anon_sym_percent] = "percent",
  [anon_sym_physical_DASHlength] = "physical-length",
  [anon_sym_physical_length] = "physical_length",
  [anon_sym_string] = "string",
  [anon_sym_debug] = "debug",
  [anon_sym_animation_DASHtick] = "animation-tick",
  [anon_sym_min] = "min",
  [anon_sym_max] = "max",
  [anon_sym_mod] = "mod",
  [anon_sym_abs] = "abs",
  [anon_sym_round] = "round",
  [anon_sym_ceil] = "ceil",
  [anon_sym_floor] = "floor",
  [anon_sym_sin] = "sin",
  [anon_sym_cos] = "cos",
  [anon_sym_tan] = "tan",
  [anon_sym_asin] = "asin",
  [anon_sym_acos] = "acos",
  [anon_sym_atan] = "atan",
  [anon_sym_sqrt] = "sqrt",
  [anon_sym_pow] = "pow",
  [anon_sym_log] = "log",
  [anon_sym_rgb] = "rgb",
  [anon_sym_easing] = "easing",
  [anon_sym_duration] = "duration",
  [anon_sym_parent] = "parent",
  [anon_sym_root] = "root",
  [sym_comment] = "comment",
  [sym_source_file] = "source_file",
  [sym__item] = "_item",
  [sym_struct_item] = "struct_item",
  [sym_struct_block_definition] = "struct_block_definition",
  [sym_export_statement] = "export_statement",
  [sym_global_single] = "global_single",
  [sym_import_statement] = "import_statement",
  [sym_component_item] = "component_item",
  [sym__conditional_element] = "_conditional_element",
  [sym__component_body] = "_component_body",
  [sym_transition_statement] = "transition_statement",
  [sym_state_statement] = "state_statement",
  [sym_animate_statement] = "animate_statement",
  [sym_for_loop] = "for_loop",
  [sym__property] = "_property",
  [sym_call_back_definition] = "call_back_definition",
  [sym_call_back_parameters] = "call_back_parameters",
  [sym_call_back_handler] = "call_back_handler",
  [sym_handler_body] = "handler_body",
  [sym_two_way_property] = "two_way_property",
  [sym_define_assign_property] = "define_assign_property",
  [sym__define_property] = "_define_property",
  [sym__assign_property] = "_assign_property",
  [sym__expression] = "_expression",
  [sym__all_expressions] = "_all_expressions",
  [sym_if_expression] = "if_expression",
  [sym_consequence_body] = "consequence_body",
  [sym_state_expression] = "state_expression",
  [sym_index_expression] = "index_expression",
  [sym_assign_expression] = "assign_expression",
  [sym_comp_assign_expression] = "comp_assign_expression",
  [sym_call_expression] = "call_expression",
  [sym_function_call_args] = "function_call_args",
  [sym_field_expression] = "field_expression",
  [sym_bool_literal] = "bool_literal",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_ternary_expression] = "ternary_expression",
  [sym__macro] = "_macro",
  [sym_linear_grad_macro] = "linear_grad_macro",
  [sym_radial_grad_macro] = "radial_grad_macro",
  [sym_image_macro] = "image_macro",
  [sym__literal] = "_literal",
  [sym_array_literal] = "array_literal",
  [sym_string_literal] = "string_literal",
  [sym_vis] = "vis",
  [sym_identifier] = "identifier",
  [sym_color_literal] = "color_literal",
  [sym__number] = "_number",
  [sym_num_units] = "num_units",
  [sym_units] = "units",
  [sym__type_identifier] = "_type_identifier",
  [sym__function_identifier] = "_function_identifier",
  [sym__builtin] = "_builtin",
  [sym_constant_builtin] = "constant_builtin",
  [sym_type_builtin] = "type_builtin",
  [sym_function_builtin] = "function_builtin",
  [sym_variable_builtin] = "variable_builtin",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_struct_block_definition_repeat1] = "struct_block_definition_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_import_statement_repeat1] = "import_statement_repeat1",
  [aux_sym__component_body_repeat1] = "_component_body_repeat1",
  [aux_sym_transition_statement_repeat1] = "transition_statement_repeat1",
  [aux_sym_state_statement_repeat1] = "state_statement_repeat1",
  [aux_sym_state_statement_repeat2] = "state_statement_repeat2",
  [aux_sym_animate_statement_repeat1] = "animate_statement_repeat1",
  [aux_sym_call_back_parameters_repeat1] = "call_back_parameters_repeat1",
  [aux_sym_consequence_body_repeat1] = "consequence_body_repeat1",
  [aux_sym_linear_grad_macro_repeat1] = "linear_grad_macro_repeat1",
  [aux_sym_string_literal_repeat1] = "string_literal_repeat1",
  [aux_sym_string_literal_repeat2] = "string_literal_repeat2",
  [alias_sym_assign_property] = "assign_property",
  [alias_sym_comp_body] = "comp_body",
  [alias_sym_define_property] = "define_property",
  [alias_sym_function_identifier] = "function_identifier",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_component] = anon_sym_component,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_inherits] = anon_sym_inherits,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_transitions] = anon_sym_transitions,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_out] = anon_sym_out,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_states] = anon_sym_states,
  [anon_sym_animate] = anon_sym_animate,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_callback] = anon_sym_callback,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_LT_EQ_GT] = anon_sym_LT_EQ_GT,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_in_DASHout] = anon_sym_in_DASHout,
  [anon_sym_property] = anon_sym_property,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_when] = anon_sym_when,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [sym_children_macro] = sym_children_macro,
  [anon_sym_linear_DASHgradient] = anon_sym_linear_DASHgradient,
  [anon_sym_radial_DASHgradient] = anon_sym_radial_DASHgradient,
  [anon_sym_circle] = anon_sym_circle,
  [anon_sym_image_DASHurl] = anon_sym_image_DASHurl,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym__unescaped_double_string_fragment] = sym__unescaped_double_string_fragment,
  [sym__unescaped_single_string_fragment] = sym__unescaped_single_string_fragment,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__ident_reg] = sym__ident_reg,
  [anon_sym_POUND] = anon_sym_POUND,
  [aux_sym_color_literal_token1] = aux_sym_color_literal_token1,
  [aux_sym_color_literal_token2] = aux_sym_color_literal_token2,
  [aux_sym_color_literal_token3] = aux_sym_color_literal_token3,
  [sym_int_literal] = sym_int_literal,
  [sym_float_literal] = sym_float_literal,
  [anon_sym_px] = anon_sym_px,
  [anon_sym_ms] = anon_sym_ms,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_deg] = anon_sym_deg,
  [anon_sym_rad] = anon_sym_rad,
  [anon_sym_ease] = anon_sym_ease,
  [anon_sym_ease_DASHin] = anon_sym_ease_DASHin,
  [anon_sym_ease_in] = anon_sym_ease_in,
  [anon_sym_ease_in_out] = anon_sym_ease_in_out,
  [anon_sym_ease_DASHin_DASHout] = anon_sym_ease_DASHin_DASHout,
  [anon_sym_ease_out] = anon_sym_ease_out,
  [anon_sym_ease_DASHout] = anon_sym_ease_DASHout,
  [anon_sym_start] = anon_sym_start,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_black] = anon_sym_black,
  [anon_sym_blue] = anon_sym_blue,
  [anon_sym_green] = anon_sym_green,
  [anon_sym_red] = anon_sym_red,
  [anon_sym_yellow] = anon_sym_yellow,
  [anon_sym_white] = anon_sym_white,
  [anon_sym_gray] = anon_sym_gray,
  [anon_sym_transparent] = anon_sym_transparent,
  [anon_sym_angle] = anon_sym_angle,
  [anon_sym_bool] = anon_sym_bool,
  [anon_sym_brush] = anon_sym_brush,
  [anon_sym_color] = anon_sym_color,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_image] = anon_sym_image,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_length] = anon_sym_length,
  [anon_sym_percent] = anon_sym_percent,
  [anon_sym_physical_DASHlength] = anon_sym_physical_DASHlength,
  [anon_sym_physical_length] = anon_sym_physical_length,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_debug] = anon_sym_debug,
  [anon_sym_animation_DASHtick] = anon_sym_animation_DASHtick,
  [anon_sym_min] = anon_sym_min,
  [anon_sym_max] = anon_sym_max,
  [anon_sym_mod] = anon_sym_mod,
  [anon_sym_abs] = anon_sym_abs,
  [anon_sym_round] = anon_sym_round,
  [anon_sym_ceil] = anon_sym_ceil,
  [anon_sym_floor] = anon_sym_floor,
  [anon_sym_sin] = anon_sym_sin,
  [anon_sym_cos] = anon_sym_cos,
  [anon_sym_tan] = anon_sym_tan,
  [anon_sym_asin] = anon_sym_asin,
  [anon_sym_acos] = anon_sym_acos,
  [anon_sym_atan] = anon_sym_atan,
  [anon_sym_sqrt] = anon_sym_sqrt,
  [anon_sym_pow] = anon_sym_pow,
  [anon_sym_log] = anon_sym_log,
  [anon_sym_rgb] = anon_sym_rgb,
  [anon_sym_easing] = anon_sym_easing,
  [anon_sym_duration] = anon_sym_duration,
  [anon_sym_parent] = anon_sym_parent,
  [anon_sym_root] = anon_sym_root,
  [sym_comment] = sym_comment,
  [sym_source_file] = sym_source_file,
  [sym__item] = sym__item,
  [sym_struct_item] = sym_struct_item,
  [sym_struct_block_definition] = sym_struct_block_definition,
  [sym_export_statement] = sym_export_statement,
  [sym_global_single] = sym_global_single,
  [sym_import_statement] = sym_import_statement,
  [sym_component_item] = sym_component_item,
  [sym__conditional_element] = sym__conditional_element,
  [sym__component_body] = sym__component_body,
  [sym_transition_statement] = sym_transition_statement,
  [sym_state_statement] = sym_state_statement,
  [sym_animate_statement] = sym_animate_statement,
  [sym_for_loop] = sym_for_loop,
  [sym__property] = sym__property,
  [sym_call_back_definition] = sym_call_back_definition,
  [sym_call_back_parameters] = sym_call_back_parameters,
  [sym_call_back_handler] = sym_call_back_handler,
  [sym_handler_body] = sym_handler_body,
  [sym_two_way_property] = sym_two_way_property,
  [sym_define_assign_property] = sym_define_assign_property,
  [sym__define_property] = sym__define_property,
  [sym__assign_property] = sym__assign_property,
  [sym__expression] = sym__expression,
  [sym__all_expressions] = sym__all_expressions,
  [sym_if_expression] = sym_if_expression,
  [sym_consequence_body] = sym_consequence_body,
  [sym_state_expression] = sym_state_expression,
  [sym_index_expression] = sym_index_expression,
  [sym_assign_expression] = sym_assign_expression,
  [sym_comp_assign_expression] = sym_comp_assign_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_function_call_args] = sym_function_call_args,
  [sym_field_expression] = sym_field_expression,
  [sym_bool_literal] = sym_bool_literal,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym__macro] = sym__macro,
  [sym_linear_grad_macro] = sym_linear_grad_macro,
  [sym_radial_grad_macro] = sym_radial_grad_macro,
  [sym_image_macro] = sym_image_macro,
  [sym__literal] = sym__literal,
  [sym_array_literal] = sym_array_literal,
  [sym_string_literal] = sym_string_literal,
  [sym_vis] = sym_vis,
  [sym_identifier] = sym_identifier,
  [sym_color_literal] = sym_color_literal,
  [sym__number] = sym__number,
  [sym_num_units] = sym_num_units,
  [sym_units] = sym_units,
  [sym__type_identifier] = sym__type_identifier,
  [sym__function_identifier] = sym__function_identifier,
  [sym__builtin] = sym__builtin,
  [sym_constant_builtin] = sym_constant_builtin,
  [sym_type_builtin] = sym_type_builtin,
  [sym_function_builtin] = sym_function_builtin,
  [sym_variable_builtin] = sym_variable_builtin,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_struct_block_definition_repeat1] = aux_sym_struct_block_definition_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_import_statement_repeat1] = aux_sym_import_statement_repeat1,
  [aux_sym__component_body_repeat1] = aux_sym__component_body_repeat1,
  [aux_sym_transition_statement_repeat1] = aux_sym_transition_statement_repeat1,
  [aux_sym_state_statement_repeat1] = aux_sym_state_statement_repeat1,
  [aux_sym_state_statement_repeat2] = aux_sym_state_statement_repeat2,
  [aux_sym_animate_statement_repeat1] = aux_sym_animate_statement_repeat1,
  [aux_sym_call_back_parameters_repeat1] = aux_sym_call_back_parameters_repeat1,
  [aux_sym_consequence_body_repeat1] = aux_sym_consequence_body_repeat1,
  [aux_sym_linear_grad_macro_repeat1] = aux_sym_linear_grad_macro_repeat1,
  [aux_sym_string_literal_repeat1] = aux_sym_string_literal_repeat1,
  [aux_sym_string_literal_repeat2] = aux_sym_string_literal_repeat2,
  [alias_sym_assign_property] = alias_sym_assign_property,
  [alias_sym_comp_body] = alias_sym_comp_body,
  [alias_sym_define_property] = alias_sym_define_property,
  [alias_sym_function_identifier] = alias_sym_function_identifier,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_component] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inherits] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transitions] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_out] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_states] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_animate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_callback] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in_DASHout] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_property] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_when] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [sym_children_macro] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_linear_DASHgradient] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_radial_DASHgradient] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_circle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_image_DASHurl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym__unescaped_double_string_fragment] = {
    .visible = false,
    .named = true,
  },
  [sym__unescaped_single_string_fragment] = {
    .visible = false,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__ident_reg] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_color_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_color_literal_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_color_literal_token3] = {
    .visible = false,
    .named = false,
  },
  [sym_int_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_float_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_px] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ms] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_deg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rad] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_in_out] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHout] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_out] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHout] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_start] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_black] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_blue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_green] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_red] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yellow] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_white] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gray] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transparent] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_angle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_brush] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_color] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_image] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_length] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_percent] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_physical_DASHlength] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_physical_length] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debug] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_animation_DASHtick] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_min] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_max] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_round] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ceil] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_floor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cos] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_tan] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_acos] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_atan] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sqrt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pow] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_log] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rgb] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_easing] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_duration] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_parent] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_root] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__item] = {
    .visible = false,
    .named = true,
  },
  [sym_struct_item] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_block_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_global_single] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_component_item] = {
    .visible = true,
    .named = true,
  },
  [sym__conditional_element] = {
    .visible = false,
    .named = true,
  },
  [sym__component_body] = {
    .visible = false,
    .named = true,
  },
  [sym_transition_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_state_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_animate_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_loop] = {
    .visible = true,
    .named = true,
  },
  [sym__property] = {
    .visible = false,
    .named = true,
  },
  [sym_call_back_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_call_back_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_call_back_handler] = {
    .visible = true,
    .named = true,
  },
  [sym_handler_body] = {
    .visible = true,
    .named = true,
  },
  [sym_two_way_property] = {
    .visible = true,
    .named = true,
  },
  [sym_define_assign_property] = {
    .visible = true,
    .named = true,
  },
  [sym__define_property] = {
    .visible = false,
    .named = true,
  },
  [sym__assign_property] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym__all_expressions] = {
    .visible = false,
    .named = true,
  },
  [sym_if_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_consequence_body] = {
    .visible = true,
    .named = true,
  },
  [sym_state_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assign_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_comp_assign_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call_args] = {
    .visible = true,
    .named = true,
  },
  [sym_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_bool_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__macro] = {
    .visible = false,
    .named = true,
  },
  [sym_linear_grad_macro] = {
    .visible = true,
    .named = true,
  },
  [sym_radial_grad_macro] = {
    .visible = true,
    .named = true,
  },
  [sym_image_macro] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym_array_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_vis] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_color_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = false,
    .named = true,
  },
  [sym_num_units] = {
    .visible = true,
    .named = true,
  },
  [sym_units] = {
    .visible = true,
    .named = true,
  },
  [sym__type_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__function_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__builtin] = {
    .visible = false,
    .named = true,
  },
  [sym_constant_builtin] = {
    .visible = true,
    .named = true,
  },
  [sym_type_builtin] = {
    .visible = true,
    .named = true,
  },
  [sym_function_builtin] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_builtin] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_block_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__component_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_transition_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_state_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_state_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_animate_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_call_back_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_consequence_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_linear_grad_macro_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat2] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_assign_property] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_comp_body] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_define_property] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_function_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_arguments = 2,
  field_field = 3,
  field_function = 4,
  field_left = 5,
  field_operator = 6,
  field_return_type = 7,
  field_right = 8,
  field_state = 9,
  field_transition = 10,
  field_type = 11,
  field_value = 12,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_arguments] = "arguments",
  [field_field] = "field",
  [field_function] = "function",
  [field_left] = "left",
  [field_operator] = "operator",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_state] = "state",
  [field_transition] = "transition",
  [field_type] = "type",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [4] = {.index = 0, .length = 2},
  [7] = {.index = 2, .length = 3},
  [8] = {.index = 5, .length = 2},
  [9] = {.index = 7, .length = 2},
  [13] = {.index = 9, .length = 2},
  [15] = {.index = 11, .length = 2},
  [16] = {.index = 13, .length = 4},
  [17] = {.index = 17, .length = 4},
  [18] = {.index = 21, .length = 4},
  [20] = {.index = 25, .length = 1},
  [21] = {.index = 26, .length = 1},
  [22] = {.index = 27, .length = 1},
  [23] = {.index = 28, .length = 1},
  [24] = {.index = 29, .length = 1},
  [25] = {.index = 30, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_arguments, 1},
    {field_function, 0},
  [2] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [5] =
    {field_left, 0},
    {field_right, 2},
  [7] =
    {field_field, 2},
    {field_value, 0},
  [9] =
    {field_field, 1},
    {field_type, 3},
  [11] =
    {field_state, 2, .inherited = true},
    {field_transition, 2, .inherited = true},
  [13] =
    {field_state, 0, .inherited = true},
    {field_state, 1, .inherited = true},
    {field_transition, 0, .inherited = true},
    {field_transition, 1, .inherited = true},
  [17] =
    {field_field, 1},
    {field_field, 4, .inherited = true},
    {field_type, 3},
    {field_type, 4, .inherited = true},
  [21] =
    {field_field, 0, .inherited = true},
    {field_field, 1, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [25] =
    {field_state, 0},
  [26] =
    {field_return_type, 3},
  [27] =
    {field_alias, 3},
  [28] =
    {field_return_type, 4},
  [29] =
    {field_alias, 4},
  [30] =
    {field_state, 1},
    {field_transition, 0},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_type_identifier,
  },
  [2] = {
    [1] = alias_sym_comp_body,
  },
  [3] = {
    [2] = alias_sym_comp_body,
  },
  [5] = {
    [0] = alias_sym_assign_property,
  },
  [6] = {
    [0] = alias_sym_function_identifier,
  },
  [10] = {
    [3] = alias_sym_comp_body,
  },
  [11] = {
    [0] = alias_sym_define_property,
  },
  [12] = {
    [4] = alias_sym_comp_body,
  },
  [14] = {
    [5] = alias_sym_comp_body,
  },
  [19] = {
    [6] = alias_sym_comp_body,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__component_body, 2,
    sym__component_body,
    alias_sym_comp_body,
  sym__define_property, 2,
    sym__define_property,
    alias_sym_define_property,
  sym__assign_property, 2,
    sym__assign_property,
    alias_sym_assign_property,
  sym_identifier, 3,
    sym_identifier,
    alias_sym_function_identifier,
    alias_sym_type_identifier,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 4,
  [6] = 6,
  [7] = 7,
  [8] = 7,
  [9] = 6,
  [10] = 3,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 13,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 26,
  [65] = 36,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 30,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 66,
  [84] = 68,
  [85] = 67,
  [86] = 86,
  [87] = 87,
  [88] = 87,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 90,
  [94] = 92,
  [95] = 95,
  [96] = 90,
  [97] = 95,
  [98] = 92,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 100,
  [104] = 104,
  [105] = 104,
  [106] = 106,
  [107] = 107,
  [108] = 106,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 101,
  [113] = 89,
  [114] = 109,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 116,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 123,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 131,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 136,
  [143] = 143,
  [144] = 144,
  [145] = 140,
  [146] = 143,
  [147] = 132,
  [148] = 127,
  [149] = 149,
  [150] = 150,
  [151] = 123,
  [152] = 133,
  [153] = 134,
  [154] = 154,
  [155] = 137,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 119,
  [162] = 144,
  [163] = 163,
  [164] = 135,
  [165] = 129,
  [166] = 132,
  [167] = 116,
  [168] = 137,
  [169] = 157,
  [170] = 143,
  [171] = 158,
  [172] = 160,
  [173] = 144,
  [174] = 141,
  [175] = 140,
  [176] = 154,
  [177] = 117,
  [178] = 160,
  [179] = 141,
  [180] = 140,
  [181] = 118,
  [182] = 140,
  [183] = 154,
  [184] = 125,
  [185] = 119,
  [186] = 136,
  [187] = 117,
  [188] = 159,
  [189] = 158,
  [190] = 157,
  [191] = 163,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 219,
  [229] = 192,
  [230] = 206,
  [231] = 201,
  [232] = 203,
  [233] = 202,
  [234] = 204,
  [235] = 198,
  [236] = 197,
  [237] = 213,
  [238] = 195,
  [239] = 214,
  [240] = 216,
  [241] = 209,
  [242] = 221,
  [243] = 224,
  [244] = 194,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 249,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 258,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 265,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 208,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 199,
  [280] = 276,
  [281] = 281,
  [282] = 282,
  [283] = 217,
  [284] = 284,
  [285] = 285,
  [286] = 272,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 218,
  [292] = 292,
  [293] = 225,
  [294] = 269,
  [295] = 295,
  [296] = 296,
  [297] = 277,
  [298] = 222,
  [299] = 290,
  [300] = 223,
  [301] = 265,
  [302] = 302,
  [303] = 281,
  [304] = 196,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 284,
  [310] = 292,
  [311] = 311,
  [312] = 311,
  [313] = 313,
  [314] = 311,
  [315] = 315,
  [316] = 315,
  [317] = 317,
  [318] = 317,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 23,
  [325] = 42,
  [326] = 61,
  [327] = 72,
  [328] = 73,
  [329] = 63,
  [330] = 38,
  [331] = 36,
  [332] = 26,
  [333] = 30,
  [334] = 49,
  [335] = 43,
  [336] = 27,
  [337] = 25,
  [338] = 56,
  [339] = 60,
  [340] = 33,
  [341] = 39,
  [342] = 45,
  [343] = 71,
  [344] = 69,
  [345] = 75,
  [346] = 37,
  [347] = 70,
  [348] = 46,
  [349] = 47,
  [350] = 48,
  [351] = 34,
  [352] = 62,
  [353] = 44,
  [354] = 24,
  [355] = 74,
  [356] = 53,
  [357] = 59,
  [358] = 58,
  [359] = 29,
  [360] = 31,
  [361] = 57,
  [362] = 28,
  [363] = 55,
  [364] = 40,
  [365] = 54,
  [366] = 32,
  [367] = 30,
  [368] = 41,
  [369] = 51,
  [370] = 52,
  [371] = 50,
  [372] = 35,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 375,
  [380] = 380,
  [381] = 377,
  [382] = 382,
  [383] = 383,
  [384] = 383,
  [385] = 380,
  [386] = 377,
  [387] = 376,
  [388] = 37,
  [389] = 33,
  [390] = 32,
  [391] = 31,
  [392] = 29,
  [393] = 28,
  [394] = 24,
  [395] = 27,
  [396] = 25,
  [397] = 39,
  [398] = 30,
  [399] = 35,
  [400] = 400,
  [401] = 30,
  [402] = 402,
  [403] = 402,
  [404] = 34,
  [405] = 405,
  [406] = 12,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 408,
  [411] = 68,
  [412] = 412,
  [413] = 67,
  [414] = 407,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 63,
  [420] = 420,
  [421] = 409,
  [422] = 73,
  [423] = 423,
  [424] = 66,
  [425] = 72,
  [426] = 61,
  [427] = 42,
  [428] = 428,
  [429] = 418,
  [430] = 430,
  [431] = 431,
  [432] = 416,
  [433] = 415,
  [434] = 434,
  [435] = 409,
  [436] = 423,
  [437] = 430,
  [438] = 431,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 443,
  [445] = 440,
  [446] = 442,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 449,
  [451] = 451,
  [452] = 451,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 453,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 455,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 473,
  [474] = 474,
  [475] = 471,
  [476] = 472,
  [477] = 473,
  [478] = 474,
  [479] = 454,
  [480] = 480,
  [481] = 466,
  [482] = 470,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 487,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 486,
  [495] = 486,
  [496] = 462,
  [497] = 497,
  [498] = 498,
  [499] = 487,
  [500] = 485,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 504,
  [505] = 505,
  [506] = 501,
  [507] = 507,
  [508] = 508,
  [509] = 509,
  [510] = 510,
  [511] = 511,
  [512] = 488,
  [513] = 513,
  [514] = 514,
  [515] = 493,
  [516] = 516,
  [517] = 513,
  [518] = 492,
  [519] = 519,
  [520] = 520,
  [521] = 521,
  [522] = 522,
  [523] = 523,
  [524] = 524,
  [525] = 525,
  [526] = 523,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 522,
  [531] = 531,
  [532] = 524,
  [533] = 533,
  [534] = 527,
  [535] = 519,
  [536] = 536,
  [537] = 521,
  [538] = 538,
  [539] = 520,
  [540] = 540,
  [541] = 541,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 545,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 551,
  [554] = 554,
  [555] = 541,
  [556] = 556,
  [557] = 557,
  [558] = 558,
  [559] = 559,
  [560] = 560,
  [561] = 561,
  [562] = 562,
  [563] = 563,
  [564] = 564,
  [565] = 546,
  [566] = 566,
  [567] = 567,
  [568] = 568,
  [569] = 569,
  [570] = 570,
  [571] = 571,
  [572] = 570,
  [573] = 573,
  [574] = 574,
  [575] = 567,
  [576] = 576,
  [577] = 558,
  [578] = 578,
  [579] = 569,
  [580] = 580,
  [581] = 549,
  [582] = 573,
  [583] = 558,
  [584] = 544,
  [585] = 559,
  [586] = 561,
};

static inline bool sym__ident_reg_character_set_1(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 910
            ? (c < 736
              ? (c < 186
                ? (c < 'h'
                  ? (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= '_')
                  : (c <= 'z' || (c < 181
                    ? c == 170
                    : c <= 181)))
                : (c <= 186 || (c < 248
                  ? (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))))
              : (c <= 740 || (c < 891
                ? (c < 880
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c >= 886 && c <= 887)))
                : (c <= 893 || (c < 904
                  ? (c < 902
                    ? c == 895
                    : c <= 902)
                  : (c <= 906 || c == 908))))))
            : (c <= 929 || (c < 1649
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym__ident_reg_character_set_2(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 931
            ? (c < 748
              ? (c < 192
                ? (c < 170
                  ? (c < 'h'
                    ? (c >= 'A' && c <= '_')
                    : c <= 'z')
                  : (c <= 170 || (c < 186
                    ? c == 181
                    : c <= 186)))
                : (c <= 214 || (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))))
              : (c <= 748 || (c < 895
                ? (c < 886
                  ? (c < 880
                    ? c == 750
                    : c <= 884)
                  : (c <= 887 || (c >= 891 && c <= 893)))
                : (c <= 895 || (c < 908
                  ? (c < 904
                    ? c == 902
                    : c <= 906)
                  : (c <= 908 || (c >= 910 && c <= 929)))))))
            : (c <= 1013 || (c < 1649
              ? (c < 1376
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)
                  : (c <= 1366 || c == 1369))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym__ident_reg_character_set_3(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2741
        ? (c < 2042
          ? (c < 931
            ? (c < 248
              ? (c < 170
                ? (c < 'A'
                  ? (c < '0'
                    ? c == '-'
                    : c <= '9')
                  : (c <= 'Z' || (c < 'a'
                    ? c == '_'
                    : c <= 'z')))
                : (c <= 170 || (c < 186
                  ? (c < 183
                    ? c == 181
                    : c <= 183)
                  : (c <= 186 || (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)))))
              : (c <= 705 || (c < 886
                ? (c < 748
                  ? (c < 736
                    ? (c >= 710 && c <= 721)
                    : c <= 740)
                  : (c <= 748 || (c < 768
                    ? c == 750
                    : c <= 884)))
                : (c <= 887 || (c < 902
                  ? (c < 895
                    ? (c >= 891 && c <= 893)
                    : c <= 895)
                  : (c <= 906 || (c < 910
                    ? c == 908
                    : c <= 929)))))))
            : (c <= 1013 || (c < 1488
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1155
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1159)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1473
                  ? (c < 1471
                    ? (c >= 1425 && c <= 1469)
                    : c <= 1471)
                  : (c <= 1474 || (c < 1479
                    ? (c >= 1476 && c <= 1477)
                    : c <= 1479)))))
              : (c <= 1514 || (c < 1759
                ? (c < 1568
                  ? (c < 1552
                    ? (c >= 1519 && c <= 1522)
                    : c <= 1562)
                  : (c <= 1641 || (c < 1749
                    ? (c >= 1646 && c <= 1747)
                    : c <= 1756)))
                : (c <= 1768 || (c < 1808
                  ? (c < 1791
                    ? (c >= 1770 && c <= 1788)
                    : c <= 1791)
                  : (c <= 1866 || (c < 1984
                    ? (c >= 1869 && c <= 1969)
                    : c <= 2037)))))))))
          : (c <= 2042 || (c < 2556
            ? (c < 2447
              ? (c < 2185
                ? (c < 2112
                  ? (c < 2048
                    ? c == 2045
                    : c <= 2093)
                  : (c <= 2139 || (c < 2160
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2183)))
                : (c <= 2190 || (c < 2406
                  ? (c < 2275
                    ? (c >= 2200 && c <= 2273)
                    : c <= 2403)
                  : (c <= 2415 || (c < 2437
                    ? (c >= 2417 && c <= 2435)
                    : c <= 2444)))))
              : (c <= 2448 || (c < 2503
                ? (c < 2482
                  ? (c < 2474
                    ? (c >= 2451 && c <= 2472)
                    : c <= 2480)
                  : (c <= 2482 || (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2500)))
                : (c <= 2504 || (c < 2524
                  ? (c < 2519
                    ? (c >= 2507 && c <= 2510)
                    : c <= 2519)
                  : (c <= 2525 || (c < 2534
                    ? (c >= 2527 && c <= 2531)
                    : c <= 2545)))))))
            : (c <= 2556 || (c < 2631
              ? (c < 2602
                ? (c < 2565
                  ? (c < 2561
                    ? c == 2558
                    : c <= 2563)
                  : (c <= 2570 || (c < 2579
                    ? (c >= 2575 && c <= 2576)
                    : c <= 2600)))
                : (c <= 2608 || (c < 2616
                  ? (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)
                  : (c <= 2617 || (c < 2622
                    ? c == 2620
                    : c <= 2626)))))
              : (c <= 2632 || (c < 2689
                ? (c < 2649
                  ? (c < 2641
                    ? (c >= 2635 && c <= 2637)
                    : c <= 2641)
                  : (c <= 2652 || (c < 2662
                    ? c == 2654
                    : c <= 2677)))
                : (c <= 2691 || (c < 2707
                  ? (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)
                  : (c <= 2728 || (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)))))))))))
        : (c <= 2745 || (c < 3165
          ? (c < 2949
            ? (c < 2858
              ? (c < 2790
                ? (c < 2763
                  ? (c < 2759
                    ? (c >= 2748 && c <= 2757)
                    : c <= 2761)
                  : (c <= 2765 || (c < 2784
                    ? c == 2768
                    : c <= 2787)))
                : (c <= 2799 || (c < 2821
                  ? (c < 2817
                    ? (c >= 2809 && c <= 2815)
                    : c <= 2819)
                  : (c <= 2828 || (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : c <= 2856)))))
              : (c <= 2864 || (c < 2901
                ? (c < 2876
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2884 || (c < 2891
                    ? (c >= 2887 && c <= 2888)
                    : c <= 2893)))
                : (c <= 2903 || (c < 2918
                  ? (c < 2911
                    ? (c >= 2908 && c <= 2909)
                    : c <= 2915)
                  : (c <= 2927 || (c < 2946
                    ? c == 2929
                    : c <= 2947)))))))
            : (c <= 2954 || (c < 3024
              ? (c < 2979
                ? (c < 2969
                  ? (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)
                  : (c <= 2970 || (c < 2974
                    ? c == 2972
                    : c <= 2975)))
                : (c <= 2980 || (c < 3006
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3010 || (c < 3018
                    ? (c >= 3014 && c <= 3016)
                    : c <= 3021)))))
              : (c <= 3024 || (c < 3114
                ? (c < 3072
                  ? (c < 3046
                    ? c == 3031
                    : c <= 3055)
                  : (c <= 3084 || (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)))
                : (c <= 3129 || (c < 3146
                  ? (c < 3142
                    ? (c >= 3132 && c <= 3140)
                    : c <= 3144)
                  : (c <= 3149 || (c < 3160
                    ? (c >= 3157 && c <= 3158)
                    : c <= 3162)))))))))
          : (c <= 3165 || (c < 3430
            ? (c < 3285
              ? (c < 3218
                ? (c < 3200
                  ? (c < 3174
                    ? (c >= 3168 && c <= 3171)
                    : c <= 3183)
                  : (c <= 3203 || (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)))
                : (c <= 3240 || (c < 3260
                  ? (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)
                  : (c <= 3268 || (c < 3274
                    ? (c >= 3270 && c <= 3272)
                    : c <= 3277)))))
              : (c <= 3286 || (c < 3342
                ? (c < 3302
                  ? (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3299)
                  : (c <= 3311 || (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)))
                : (c <= 3344 || (c < 3402
                  ? (c < 3398
                    ? (c >= 3346 && c <= 3396)
                    : c <= 3400)
                  : (c <= 3406 || (c < 3423
                    ? (c >= 3412 && c <= 3415)
                    : c <= 3427)))))))
            : (c <= 3439 || (c < 3558
              ? (c < 3517
                ? (c < 3461
                  ? (c < 3457
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3459)
                  : (c <= 3478 || (c < 3507
                    ? (c >= 3482 && c <= 3505)
                    : c <= 3515)))
                : (c <= 3517 || (c < 3535
                  ? (c < 3530
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3530)
                  : (c <= 3540 || (c < 3544
                    ? c == 3542
                    : c <= 3551)))))
              : (c <= 3567 || (c < 3716
                ? (c < 3648
                  ? (c < 3585
                    ? (c >= 3570 && c <= 3571)
                    : c <= 3642)
                  : (c <= 3662 || (c < 3713
                    ? (c >= 3664 && c <= 3673)
                    : c <= 3714)))
                : (c <= 3716 || (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c < 3776
                    ? (c >= 3751 && c <= 3773)
                    : c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool sym__ident_reg_character_set_4(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2748
        ? (c < 2045
          ? (c < 1015
            ? (c < 710
              ? (c < 181
                ? (c < '_'
                  ? (c < 'A'
                    ? (c >= '0' && c <= '9')
                    : c <= 'Z')
                  : (c <= '_' || (c < 170
                    ? (c >= 'a' && c <= 'z')
                    : c <= 170)))
                : (c <= 181 || (c < 192
                  ? (c < 186
                    ? c == 183
                    : c <= 186)
                  : (c <= 214 || (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)))))
              : (c <= 721 || (c < 891
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c < 886
                    ? (c >= 768 && c <= 884)
                    : c <= 887)))
                : (c <= 893 || (c < 908
                  ? (c < 902
                    ? c == 895
                    : c <= 906)
                  : (c <= 908 || (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)))))))
            : (c <= 1153 || (c < 1519
              ? (c < 1425
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1155 && c <= 1159)
                    : c <= 1327)
                  : (c <= 1366 || (c < 1376
                    ? c == 1369
                    : c <= 1416)))
                : (c <= 1469 || (c < 1476
                  ? (c < 1473
                    ? c == 1471
                    : c <= 1474)
                  : (c <= 1477 || (c < 1488
                    ? c == 1479
                    : c <= 1514)))))
              : (c <= 1522 || (c < 1770
                ? (c < 1646
                  ? (c < 1568
                    ? (c >= 1552 && c <= 1562)
                    : c <= 1641)
                  : (c <= 1747 || (c < 1759
                    ? (c >= 1749 && c <= 1756)
                    : c <= 1768)))
                : (c <= 1788 || (c < 1869
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1866)
                  : (c <= 1969 || (c < 2042
                    ? (c >= 1984 && c <= 2037)
                    : c <= 2042)))))))))
          : (c <= 2045 || (c < 2558
            ? (c < 2451
              ? (c < 2200
                ? (c < 2144
                  ? (c < 2112
                    ? (c >= 2048 && c <= 2093)
                    : c <= 2139)
                  : (c <= 2154 || (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)))
                : (c <= 2273 || (c < 2417
                  ? (c < 2406
                    ? (c >= 2275 && c <= 2403)
                    : c <= 2415)
                  : (c <= 2435 || (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)))))
              : (c <= 2472 || (c < 2507
                ? (c < 2486
                  ? (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)
                  : (c <= 2489 || (c < 2503
                    ? (c >= 2492 && c <= 2500)
                    : c <= 2504)))
                : (c <= 2510 || (c < 2527
                  ? (c < 2524
                    ? c == 2519
                    : c <= 2525)
                  : (c <= 2531 || (c < 2556
                    ? (c >= 2534 && c <= 2545)
                    : c <= 2556)))))))
            : (c <= 2558 || (c < 2635
              ? (c < 2610
                ? (c < 2575
                  ? (c < 2565
                    ? (c >= 2561 && c <= 2563)
                    : c <= 2570)
                  : (c <= 2576 || (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)))
                : (c <= 2611 || (c < 2620
                  ? (c < 2616
                    ? (c >= 2613 && c <= 2614)
                    : c <= 2617)
                  : (c <= 2620 || (c < 2631
                    ? (c >= 2622 && c <= 2626)
                    : c <= 2632)))))
              : (c <= 2637 || (c < 2693
                ? (c < 2654
                  ? (c < 2649
                    ? c == 2641
                    : c <= 2652)
                  : (c <= 2654 || (c < 2689
                    ? (c >= 2662 && c <= 2677)
                    : c <= 2691)))
                : (c <= 2701 || (c < 2730
                  ? (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)
                  : (c <= 2736 || (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)))))))))))
        : (c <= 2757 || (c < 3168
          ? (c < 2958
            ? (c < 2866
              ? (c < 2809
                ? (c < 2768
                  ? (c < 2763
                    ? (c >= 2759 && c <= 2761)
                    : c <= 2765)
                  : (c <= 2768 || (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)))
                : (c <= 2815 || (c < 2831
                  ? (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)
                  : (c <= 2832 || (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)))))
              : (c <= 2867 || (c < 2908
                ? (c < 2887
                  ? (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)
                  : (c <= 2888 || (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)))
                : (c <= 2909 || (c < 2929
                  ? (c < 2918
                    ? (c >= 2911 && c <= 2915)
                    : c <= 2927)
                  : (c <= 2929 || (c < 2949
                    ? (c >= 2946 && c <= 2947)
                    : c <= 2954)))))))
            : (c <= 2960 || (c < 3031
              ? (c < 2984
                ? (c < 2972
                  ? (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)
                  : (c <= 2972 || (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)))
                : (c <= 2986 || (c < 3014
                  ? (c < 3006
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3010)
                  : (c <= 3016 || (c < 3024
                    ? (c >= 3018 && c <= 3021)
                    : c <= 3024)))))
              : (c <= 3031 || (c < 3132
                ? (c < 3086
                  ? (c < 3072
                    ? (c >= 3046 && c <= 3055)
                    : c <= 3084)
                  : (c <= 3088 || (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)))
                : (c <= 3140 || (c < 3157
                  ? (c < 3146
                    ? (c >= 3142 && c <= 3144)
                    : c <= 3149)
                  : (c <= 3158 || (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)))))))))
          : (c <= 3171 || (c < 3450
            ? (c < 3293
              ? (c < 3242
                ? (c < 3205
                  ? (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : c <= 3203)
                  : (c <= 3212 || (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)))
                : (c <= 3251 || (c < 3270
                  ? (c < 3260
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3268)
                  : (c <= 3272 || (c < 3285
                    ? (c >= 3274 && c <= 3277)
                    : c <= 3286)))))
              : (c <= 3294 || (c < 3346
                ? (c < 3313
                  ? (c < 3302
                    ? (c >= 3296 && c <= 3299)
                    : c <= 3311)
                  : (c <= 3314 || (c < 3342
                    ? (c >= 3328 && c <= 3340)
                    : c <= 3344)))
                : (c <= 3396 || (c < 3412
                  ? (c < 3402
                    ? (c >= 3398 && c <= 3400)
                    : c <= 3406)
                  : (c <= 3415 || (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : c <= 3439)))))))
            : (c <= 3455 || (c < 3570
              ? (c < 3520
                ? (c < 3482
                  ? (c < 3461
                    ? (c >= 3457 && c <= 3459)
                    : c <= 3478)
                  : (c <= 3505 || (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)))
                : (c <= 3526 || (c < 3542
                  ? (c < 3535
                    ? c == 3530
                    : c <= 3540)
                  : (c <= 3542 || (c < 3558
                    ? (c >= 3544 && c <= 3551)
                    : c <= 3567)))))
              : (c <= 3571 || (c < 3718
                ? (c < 3664
                  ? (c < 3648
                    ? (c >= 3585 && c <= 3642)
                    : c <= 3662)
                  : (c <= 3673 || (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)))
                : (c <= 3722 || (c < 3751
                  ? (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool sym__ident_reg_character_set_5(int32_t c) {
  return (c < 43642
    ? (c < 3784
      ? (c < 2759
        ? (c < 2048
          ? (c < 1155
            ? (c < 736
              ? (c < 183
                ? (c < 'a'
                  ? (c < 'A'
                    ? (c >= '0' && c <= '9')
                    : c <= 'Z')
                  : (c <= 'z' || (c < 181
                    ? c == 170
                    : c <= 181)))
                : (c <= 183 || (c < 216
                  ? (c < 192
                    ? c == 186
                    : c <= 214)
                  : (c <= 246 || (c < 710
                    ? (c >= 248 && c <= 705)
                    : c <= 721)))))
              : (c <= 740 || (c < 895
                ? (c < 768
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c < 891
                    ? (c >= 886 && c <= 887)
                    : c <= 893)))
                : (c <= 895 || (c < 910
                  ? (c < 908
                    ? (c >= 902 && c <= 906)
                    : c <= 908)
                  : (c <= 929 || (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)))))))
            : (c <= 1159 || (c < 1552
              ? (c < 1471
                ? (c < 1369
                  ? (c < 1329
                    ? (c >= 1162 && c <= 1327)
                    : c <= 1366)
                  : (c <= 1369 || (c < 1425
                    ? (c >= 1376 && c <= 1416)
                    : c <= 1469)))
                : (c <= 1471 || (c < 1479
                  ? (c < 1476
                    ? (c >= 1473 && c <= 1474)
                    : c <= 1477)
                  : (c <= 1479 || (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)))))
              : (c <= 1562 || (c < 1791
                ? (c < 1749
                  ? (c < 1646
                    ? (c >= 1568 && c <= 1641)
                    : c <= 1747)
                  : (c <= 1756 || (c < 1770
                    ? (c >= 1759 && c <= 1768)
                    : c <= 1788)))
                : (c <= 1791 || (c < 1984
                  ? (c < 1869
                    ? (c >= 1808 && c <= 1866)
                    : c <= 1969)
                  : (c <= 2037 || (c < 2045
                    ? c == 2042
                    : c <= 2045)))))))))
          : (c <= 2093 || (c < 2561
            ? (c < 2474
              ? (c < 2275
                ? (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2139)
                    : c <= 2154)
                  : (c <= 2183 || (c < 2200
                    ? (c >= 2185 && c <= 2190)
                    : c <= 2273)))
                : (c <= 2403 || (c < 2437
                  ? (c < 2417
                    ? (c >= 2406 && c <= 2415)
                    : c <= 2435)
                  : (c <= 2444 || (c < 2451
                    ? (c >= 2447 && c <= 2448)
                    : c <= 2472)))))
              : (c <= 2480 || (c < 2519
                ? (c < 2492
                  ? (c < 2486
                    ? c == 2482
                    : c <= 2489)
                  : (c <= 2500 || (c < 2507
                    ? (c >= 2503 && c <= 2504)
                    : c <= 2510)))
                : (c <= 2519 || (c < 2534
                  ? (c < 2527
                    ? (c >= 2524 && c <= 2525)
                    : c <= 2531)
                  : (c <= 2545 || (c < 2558
                    ? c == 2556
                    : c <= 2558)))))))
            : (c <= 2563 || (c < 2641
              ? (c < 2613
                ? (c < 2579
                  ? (c < 2575
                    ? (c >= 2565 && c <= 2570)
                    : c <= 2576)
                  : (c <= 2600 || (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)))
                : (c <= 2614 || (c < 2622
                  ? (c < 2620
                    ? (c >= 2616 && c <= 2617)
                    : c <= 2620)
                  : (c <= 2626 || (c < 2635
                    ? (c >= 2631 && c <= 2632)
                    : c <= 2637)))))
              : (c <= 2641 || (c < 2703
                ? (c < 2662
                  ? (c < 2654
                    ? (c >= 2649 && c <= 2652)
                    : c <= 2654)
                  : (c <= 2677 || (c < 2693
                    ? (c >= 2689 && c <= 2691)
                    : c <= 2701)))
                : (c <= 2705 || (c < 2738
                  ? (c < 2730
                    ? (c >= 2707 && c <= 2728)
                    : c <= 2736)
                  : (c <= 2739 || (c < 2748
                    ? (c >= 2741 && c <= 2745)
                    : c <= 2757)))))))))))
        : (c <= 2761 || (c < 3174
          ? (c < 2962
            ? (c < 2869
              ? (c < 2817
                ? (c < 2784
                  ? (c < 2768
                    ? (c >= 2763 && c <= 2765)
                    : c <= 2768)
                  : (c <= 2787 || (c < 2809
                    ? (c >= 2790 && c <= 2799)
                    : c <= 2815)))
                : (c <= 2819 || (c < 2835
                  ? (c < 2831
                    ? (c >= 2821 && c <= 2828)
                    : c <= 2832)
                  : (c <= 2856 || (c < 2866
                    ? (c >= 2858 && c <= 2864)
                    : c <= 2867)))))
              : (c <= 2873 || (c < 2911
                ? (c < 2891
                  ? (c < 2887
                    ? (c >= 2876 && c <= 2884)
                    : c <= 2888)
                  : (c <= 2893 || (c < 2908
                    ? (c >= 2901 && c <= 2903)
                    : c <= 2909)))
                : (c <= 2915 || (c < 2946
                  ? (c < 2929
                    ? (c >= 2918 && c <= 2927)
                    : c <= 2929)
                  : (c <= 2947 || (c < 2958
                    ? (c >= 2949 && c <= 2954)
                    : c <= 2960)))))))
            : (c <= 2965 || (c < 3046
              ? (c < 2990
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c < 2984
                    ? (c >= 2979 && c <= 2980)
                    : c <= 2986)))
                : (c <= 3001 || (c < 3018
                  ? (c < 3014
                    ? (c >= 3006 && c <= 3010)
                    : c <= 3016)
                  : (c <= 3021 || (c < 3031
                    ? c == 3024
                    : c <= 3031)))))
              : (c <= 3055 || (c < 3142
                ? (c < 3090
                  ? (c < 3086
                    ? (c >= 3072 && c <= 3084)
                    : c <= 3088)
                  : (c <= 3112 || (c < 3132
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3140)))
                : (c <= 3144 || (c < 3160
                  ? (c < 3157
                    ? (c >= 3146 && c <= 3149)
                    : c <= 3158)
                  : (c <= 3162 || (c < 3168
                    ? c == 3165
                    : c <= 3171)))))))))
          : (c <= 3183 || (c < 3457
            ? (c < 3296
              ? (c < 3253
                ? (c < 3214
                  ? (c < 3205
                    ? (c >= 3200 && c <= 3203)
                    : c <= 3212)
                  : (c <= 3216 || (c < 3242
                    ? (c >= 3218 && c <= 3240)
                    : c <= 3251)))
                : (c <= 3257 || (c < 3274
                  ? (c < 3270
                    ? (c >= 3260 && c <= 3268)
                    : c <= 3272)
                  : (c <= 3277 || (c < 3293
                    ? (c >= 3285 && c <= 3286)
                    : c <= 3294)))))
              : (c <= 3299 || (c < 3398
                ? (c < 3328
                  ? (c < 3313
                    ? (c >= 3302 && c <= 3311)
                    : c <= 3314)
                  : (c <= 3340 || (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3396)))
                : (c <= 3400 || (c < 3423
                  ? (c < 3412
                    ? (c >= 3402 && c <= 3406)
                    : c <= 3415)
                  : (c <= 3427 || (c < 3450
                    ? (c >= 3430 && c <= 3439)
                    : c <= 3455)))))))
            : (c <= 3459 || (c < 3585
              ? (c < 3530
                ? (c < 3507
                  ? (c < 3482
                    ? (c >= 3461 && c <= 3478)
                    : c <= 3505)
                  : (c <= 3515 || (c < 3520
                    ? c == 3517
                    : c <= 3526)))
                : (c <= 3530 || (c < 3544
                  ? (c < 3542
                    ? (c >= 3535 && c <= 3540)
                    : c <= 3542)
                  : (c <= 3551 || (c < 3570
                    ? (c >= 3558 && c <= 3567)
                    : c <= 3571)))))
              : (c <= 3642 || (c < 3724
                ? (c < 3713
                  ? (c < 3664
                    ? (c >= 3648 && c <= 3662)
                    : c <= 3673)
                  : (c <= 3714 || (c < 3718
                    ? c == 3716
                    : c <= 3722)))
                : (c <= 3747 || (c < 3776
                  ? (c < 3751
                    ? c == 3749
                    : c <= 3773)
                  : (c <= 3780 || c == 3782))))))))))))
      : (c <= 3789 || (c < 8027
        ? (c < 5919
          ? (c < 4696
            ? (c < 3974
              ? (c < 3893
                ? (c < 3840
                  ? (c < 3804
                    ? (c >= 3792 && c <= 3801)
                    : c <= 3807)
                  : (c <= 3840 || (c < 3872
                    ? (c >= 3864 && c <= 3865)
                    : c <= 3881)))
                : (c <= 3893 || (c < 3902
                  ? (c < 3897
                    ? c == 3895
                    : c <= 3897)
                  : (c <= 3911 || (c < 3953
                    ? (c >= 3913 && c <= 3948)
                    : c <= 3972)))))
              : (c <= 3991 || (c < 4295
                ? (c < 4096
                  ? (c < 4038
                    ? (c >= 3993 && c <= 4028)
                    : c <= 4038)
                  : (c <= 4169 || (c < 4256
                    ? (c >= 4176 && c <= 4253)
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c < 4688
                    ? (c >= 4682 && c <= 4685)
                    : c <= 4694)))))))
            : (c <= 4696 || (c < 4888
              ? (c < 4792
                ? (c < 4746
                  ? (c < 4704
                    ? (c >= 4698 && c <= 4701)
                    : c <= 4744)
                  : (c <= 4749 || (c < 4786
                    ? (c >= 4752 && c <= 4784)
                    : c <= 4789)))
                : (c <= 4798 || (c < 4808
                  ? (c < 4802
                    ? c == 4800
                    : c <= 4805)
                  : (c <= 4822 || (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)))))
              : (c <= 4954 || (c < 5121
                ? (c < 4992
                  ? (c < 4969
                    ? (c >= 4957 && c <= 4959)
                    : c <= 4977)
                  : (c <= 5007 || (c < 5112
                    ? (c >= 5024 && c <= 5109)
                    : c <= 5117)))
                : (c <= 5740 || (c < 5792
                  ? (c < 5761
                    ? (c >= 5743 && c <= 5759)
                    : c <= 5786)
                  : (c <= 5866 || (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5909)))))))))
          : (c <= 5940 || (c < 6752
            ? (c < 6272
              ? (c < 6103
                ? (c < 5998
                  ? (c < 5984
                    ? (c >= 5952 && c <= 5971)
                    : c <= 5996)
                  : (c <= 6000 || (c < 6016
                    ? (c >= 6002 && c <= 6003)
                    : c <= 6099)))
                : (c <= 6103 || (c < 6155
                  ? (c < 6112
                    ? (c >= 6108 && c <= 6109)
                    : c <= 6121)
                  : (c <= 6157 || (c < 6176
                    ? (c >= 6159 && c <= 6169)
                    : c <= 6264)))))
              : (c <= 6314 || (c < 6512
                ? (c < 6432
                  ? (c < 6400
                    ? (c >= 6320 && c <= 6389)
                    : c <= 6430)
                  : (c <= 6443 || (c < 6470
                    ? (c >= 6448 && c <= 6459)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6608
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6618 || (c < 6688
                    ? (c >= 6656 && c <= 6683)
                    : c <= 6750)))))))
            : (c <= 6780 || (c < 7245
              ? (c < 6912
                ? (c < 6823
                  ? (c < 6800
                    ? (c >= 6783 && c <= 6793)
                    : c <= 6809)
                  : (c <= 6823 || (c < 6847
                    ? (c >= 6832 && c <= 6845)
                    : c <= 6862)))
                : (c <= 6988 || (c < 7040
                  ? (c < 7019
                    ? (c >= 6992 && c <= 7001)
                    : c <= 7027)
                  : (c <= 7155 || (c < 7232
                    ? (c >= 7168 && c <= 7223)
                    : c <= 7241)))))
              : (c <= 7293 || (c < 7424
                ? (c < 7357
                  ? (c < 7312
                    ? (c >= 7296 && c <= 7304)
                    : c <= 7354)
                  : (c <= 7359 || (c < 7380
                    ? (c >= 7376 && c <= 7378)
                    : c <= 7418)))
                : (c <= 7957 || (c < 8008
                  ? (c < 7968
                    ? (c >= 7960 && c <= 7965)
                    : c <= 8005)
                  : (c <= 8013 || (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)))))))))))
        : (c <= 8027 || (c < 11728
          ? (c < 8469
            ? (c < 8182
              ? (c < 8130
                ? (c < 8064
                  ? (c < 8031
                    ? c == 8029
                    : c <= 8061)
                  : (c <= 8116 || (c < 8126
                    ? (c >= 8118 && c <= 8124)
                    : c <= 8126)))
                : (c <= 8132 || (c < 8150
                  ? (c < 8144
                    ? (c >= 8134 && c <= 8140)
                    : c <= 8147)
                  : (c <= 8155 || (c < 8178
                    ? (c >= 8160 && c <= 8172)
                    : c <= 8180)))))
              : (c <= 8188 || (c < 8400
                ? (c < 8305
                  ? (c < 8276
                    ? (c >= 8255 && c <= 8256)
                    : c <= 8276)
                  : (c <= 8305 || (c < 8336
                    ? c == 8319
                    : c <= 8348)))
                : (c <= 8412 || (c < 8450
                  ? (c < 8421
                    ? c == 8417
                    : c <= 8432)
                  : (c <= 8450 || (c < 8458
                    ? c == 8455
                    : c <= 8467)))))))
            : (c <= 8469 || (c < 11520
              ? (c < 8508
                ? (c < 8486
                  ? (c < 8484
                    ? (c >= 8472 && c <= 8477)
                    : c <= 8484)
                  : (c <= 8486 || (c < 8490
                    ? c == 8488
                    : c <= 8505)))
                : (c <= 8511 || (c < 8544
                  ? (c < 8526
                    ? (c >= 8517 && c <= 8521)
                    : c <= 8526)
                  : (c <= 8584 || (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11507)))))
              : (c <= 11557 || (c < 11680
                ? (c < 11568
                  ? (c < 11565
                    ? c == 11559
                    : c <= 11565)
                  : (c <= 11623 || (c < 11647
                    ? c == 11631
                    : c <= 11670)))
                : (c <= 11686 || (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c < 11720
                    ? (c >= 11712 && c <= 11718)
                    : c <= 11726)))))))))
          : (c <= 11734 || (c < 42775
            ? (c < 12549
              ? (c < 12344
                ? (c < 12293
                  ? (c < 11744
                    ? (c >= 11736 && c <= 11742)
                    : c <= 11775)
                  : (c <= 12295 || (c < 12337
                    ? (c >= 12321 && c <= 12335)
                    : c <= 12341)))
                : (c <= 12348 || (c < 12445
                  ? (c < 12441
                    ? (c >= 12353 && c <= 12438)
                    : c <= 12442)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))))
              : (c <= 12591 || (c < 42192
                ? (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c < 19968
                    ? (c >= 13312 && c <= 19903)
                    : c <= 42124)))
                : (c <= 42237 || (c < 42560
                  ? (c < 42512
                    ? (c >= 42240 && c <= 42508)
                    : c <= 42539)
                  : (c <= 42607 || (c < 42623
                    ? (c >= 42612 && c <= 42621)
                    : c <= 42737)))))))
            : (c <= 42783 || (c < 43259
              ? (c < 42994
                ? (c < 42960
                  ? (c < 42891
                    ? (c >= 42786 && c <= 42888)
                    : c <= 42954)
                  : (c <= 42961 || (c < 42965
                    ? c == 42963
                    : c <= 42969)))
                : (c <= 43047 || (c < 43136
                  ? (c < 43072
                    ? c == 43052
                    : c <= 43123)
                  : (c <= 43205 || (c < 43232
                    ? (c >= 43216 && c <= 43225)
                    : c <= 43255)))))
              : (c <= 43259 || (c < 43488
                ? (c < 43360
                  ? (c < 43312
                    ? (c >= 43261 && c <= 43309)
                    : c <= 43347)
                  : (c <= 43388 || (c < 43471
                    ? (c >= 43392 && c <= 43456)
                    : c <= 43481)))
                : (c <= 43518 || (c < 43600
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43574)
                    : c <= 43597)
                  : (c <= 43609 || (c >= 43616 && c <= 43638)))))))))))))))
    : (c <= 43714 || (c < 71472
      ? (c < 67644
        ? (c < 65382
          ? (c < 64318
            ? (c < 44012
              ? (c < 43793
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43759)
                  : (c <= 43766 || (c < 43785
                    ? (c >= 43777 && c <= 43782)
                    : c <= 43790)))
                : (c <= 43798 || (c < 43824
                  ? (c < 43816
                    ? (c >= 43808 && c <= 43814)
                    : c <= 43822)
                  : (c <= 43866 || (c < 43888
                    ? (c >= 43868 && c <= 43881)
                    : c <= 44010)))))
              : (c <= 44013 || (c < 64112
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 44016 && c <= 44025)
                    : c <= 55203)
                  : (c <= 55238 || (c < 63744
                    ? (c >= 55243 && c <= 55291)
                    : c <= 64109)))
                : (c <= 64217 || (c < 64285
                  ? (c < 64275
                    ? (c >= 64256 && c <= 64262)
                    : c <= 64279)
                  : (c <= 64296 || (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)))))))
            : (c <= 64318 || (c < 65101
              ? (c < 64848
                ? (c < 64326
                  ? (c < 64323
                    ? (c >= 64320 && c <= 64321)
                    : c <= 64324)
                  : (c <= 64433 || (c < 64612
                    ? (c >= 64467 && c <= 64605)
                    : c <= 64829)))
                : (c <= 64911 || (c < 65024
                  ? (c < 65008
                    ? (c >= 64914 && c <= 64967)
                    : c <= 65017)
                  : (c <= 65039 || (c < 65075
                    ? (c >= 65056 && c <= 65071)
                    : c <= 65076)))))
              : (c <= 65103 || (c < 65149
                ? (c < 65143
                  ? (c < 65139
                    ? c == 65137
                    : c <= 65139)
                  : (c <= 65143 || (c < 65147
                    ? c == 65145
                    : c <= 65147)))
                : (c <= 65149 || (c < 65313
                  ? (c < 65296
                    ? (c >= 65151 && c <= 65276)
                    : c <= 65305)
                  : (c <= 65338 || (c < 65345
                    ? c == 65343
                    : c <= 65370)))))))))
          : (c <= 65470 || (c < 66560
            ? (c < 65856
              ? (c < 65549
                ? (c < 65490
                  ? (c < 65482
                    ? (c >= 65474 && c <= 65479)
                    : c <= 65487)
                  : (c <= 65495 || (c < 65536
                    ? (c >= 65498 && c <= 65500)
                    : c <= 65547)))
                : (c <= 65574 || (c < 65599
                  ? (c < 65596
                    ? (c >= 65576 && c <= 65594)
                    : c <= 65597)
                  : (c <= 65613 || (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)))))
              : (c <= 65908 || (c < 66349
                ? (c < 66208
                  ? (c < 66176
                    ? c == 66045
                    : c <= 66204)
                  : (c <= 66256 || (c < 66304
                    ? c == 66272
                    : c <= 66335)))
                : (c <= 66378 || (c < 66464
                  ? (c < 66432
                    ? (c >= 66384 && c <= 66426)
                    : c <= 66461)
                  : (c <= 66499 || (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)))))))
            : (c <= 66717 || (c < 66995
              ? (c < 66928
                ? (c < 66776
                  ? (c < 66736
                    ? (c >= 66720 && c <= 66729)
                    : c <= 66771)
                  : (c <= 66811 || (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)))
                : (c <= 66938 || (c < 66964
                  ? (c < 66956
                    ? (c >= 66940 && c <= 66954)
                    : c <= 66962)
                  : (c <= 66965 || (c < 66979
                    ? (c >= 66967 && c <= 66977)
                    : c <= 66993)))))
              : (c <= 67001 || (c < 67463
                ? (c < 67392
                  ? (c < 67072
                    ? (c >= 67003 && c <= 67004)
                    : c <= 67382)
                  : (c <= 67413 || (c < 67456
                    ? (c >= 67424 && c <= 67431)
                    : c <= 67461)))
                : (c <= 67504 || (c < 67592
                  ? (c < 67584
                    ? (c >= 67506 && c <= 67514)
                    : c <= 67589)
                  : (c <= 67592 || (c < 67639
                    ? (c >= 67594 && c <= 67637)
                    : c <= 67640)))))))))))
        : (c <= 67644 || (c < 69968
          ? (c < 68480
            ? (c < 68108
              ? (c < 67840
                ? (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c < 67828
                    ? (c >= 67808 && c <= 67826)
                    : c <= 67829)))
                : (c <= 67861 || (c < 68030
                  ? (c < 67968
                    ? (c >= 67872 && c <= 67897)
                    : c <= 68023)
                  : (c <= 68031 || (c < 68101
                    ? (c >= 68096 && c <= 68099)
                    : c <= 68102)))))
              : (c <= 68115 || (c < 68224
                ? (c < 68152
                  ? (c < 68121
                    ? (c >= 68117 && c <= 68119)
                    : c <= 68149)
                  : (c <= 68154 || (c < 68192
                    ? c == 68159
                    : c <= 68220)))
                : (c <= 68252 || (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68326)
                  : (c <= 68405 || (c < 68448
                    ? (c >= 68416 && c <= 68437)
                    : c <= 68466)))))))
            : (c <= 68497 || (c < 69488
              ? (c < 69248
                ? (c < 68800
                  ? (c < 68736
                    ? (c >= 68608 && c <= 68680)
                    : c <= 68786)
                  : (c <= 68850 || (c < 68912
                    ? (c >= 68864 && c <= 68903)
                    : c <= 68921)))
                : (c <= 69289 || (c < 69376
                  ? (c < 69296
                    ? (c >= 69291 && c <= 69292)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69456)))))
              : (c <= 69509 || (c < 69826
                ? (c < 69632
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69702 || (c < 69759
                    ? (c >= 69734 && c <= 69749)
                    : c <= 69818)))
                : (c <= 69826 || (c < 69888
                  ? (c < 69872
                    ? (c >= 69840 && c <= 69864)
                    : c <= 69881)
                  : (c <= 69940 || (c < 69956
                    ? (c >= 69942 && c <= 69951)
                    : c <= 69959)))))))))
          : (c <= 70003 || (c < 70471
            ? (c < 70287
              ? (c < 70144
                ? (c < 70089
                  ? (c < 70016
                    ? c == 70006
                    : c <= 70084)
                  : (c <= 70092 || (c < 70108
                    ? (c >= 70094 && c <= 70106)
                    : c <= 70108)))
                : (c <= 70161 || (c < 70272
                  ? (c < 70206
                    ? (c >= 70163 && c <= 70199)
                    : c <= 70206)
                  : (c <= 70278 || (c < 70282
                    ? c == 70280
                    : c <= 70285)))))
              : (c <= 70301 || (c < 70415
                ? (c < 70384
                  ? (c < 70320
                    ? (c >= 70303 && c <= 70312)
                    : c <= 70378)
                  : (c <= 70393 || (c < 70405
                    ? (c >= 70400 && c <= 70403)
                    : c <= 70412)))
                : (c <= 70416 || (c < 70450
                  ? (c < 70442
                    ? (c >= 70419 && c <= 70440)
                    : c <= 70448)
                  : (c <= 70451 || (c < 70459
                    ? (c >= 70453 && c <= 70457)
                    : c <= 70468)))))))
            : (c <= 70472 || (c < 70864
              ? (c < 70512
                ? (c < 70487
                  ? (c < 70480
                    ? (c >= 70475 && c <= 70477)
                    : c <= 70480)
                  : (c <= 70487 || (c < 70502
                    ? (c >= 70493 && c <= 70499)
                    : c <= 70508)))
                : (c <= 70516 || (c < 70750
                  ? (c < 70736
                    ? (c >= 70656 && c <= 70730)
                    : c <= 70745)
                  : (c <= 70753 || (c < 70855
                    ? (c >= 70784 && c <= 70853)
                    : c <= 70855)))))
              : (c <= 70873 || (c < 71248
                ? (c < 71128
                  ? (c < 71096
                    ? (c >= 71040 && c <= 71093)
                    : c <= 71104)
                  : (c <= 71133 || (c < 71236
                    ? (c >= 71168 && c <= 71232)
                    : c <= 71236)))
                : (c <= 71257 || (c < 71424
                  ? (c < 71360
                    ? (c >= 71296 && c <= 71352)
                    : c <= 71369)
                  : (c <= 71450 || (c >= 71453 && c <= 71467)))))))))))))
      : (c <= 71481 || (c < 119973
        ? (c < 82944
          ? (c < 72784
            ? (c < 72096
              ? (c < 71948
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71738)
                  : (c <= 71913 || (c < 71945
                    ? (c >= 71935 && c <= 71942)
                    : c <= 71945)))
                : (c <= 71955 || (c < 71991
                  ? (c < 71960
                    ? (c >= 71957 && c <= 71958)
                    : c <= 71989)
                  : (c <= 71992 || (c < 72016
                    ? (c >= 71995 && c <= 72003)
                    : c <= 72025)))))
              : (c <= 72103 || (c < 72272
                ? (c < 72163
                  ? (c < 72154
                    ? (c >= 72106 && c <= 72151)
                    : c <= 72161)
                  : (c <= 72164 || (c < 72263
                    ? (c >= 72192 && c <= 72254)
                    : c <= 72263)))
                : (c <= 72345 || (c < 72704
                  ? (c < 72368
                    ? c == 72349
                    : c <= 72440)
                  : (c <= 72712 || (c < 72760
                    ? (c >= 72714 && c <= 72758)
                    : c <= 72768)))))))
            : (c <= 72793 || (c < 73063
              ? (c < 72971
                ? (c < 72873
                  ? (c < 72850
                    ? (c >= 72818 && c <= 72847)
                    : c <= 72871)
                  : (c <= 72886 || (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)))
                : (c <= 73014 || (c < 73023
                  ? (c < 73020
                    ? c == 73018
                    : c <= 73021)
                  : (c <= 73031 || (c < 73056
                    ? (c >= 73040 && c <= 73049)
                    : c <= 73061)))))
              : (c <= 73064 || (c < 73648
                ? (c < 73107
                  ? (c < 73104
                    ? (c >= 73066 && c <= 73102)
                    : c <= 73105)
                  : (c <= 73112 || (c < 73440
                    ? (c >= 73120 && c <= 73129)
                    : c <= 73462)))
                : (c <= 73648 || (c < 74880
                  ? (c < 74752
                    ? (c >= 73728 && c <= 74649)
                    : c <= 74862)
                  : (c <= 75075 || (c < 77824
                    ? (c >= 77712 && c <= 77808)
                    : c <= 78894)))))))))
          : (c <= 83526 || (c < 110581
            ? (c < 93053
              ? (c < 92880
                ? (c < 92768
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92777 || (c < 92864
                    ? (c >= 92784 && c <= 92862)
                    : c <= 92873)))
                : (c <= 92909 || (c < 92992
                  ? (c < 92928
                    ? (c >= 92912 && c <= 92916)
                    : c <= 92982)
                  : (c <= 92995 || (c < 93027
                    ? (c >= 93008 && c <= 93017)
                    : c <= 93047)))))
              : (c <= 93071 || (c < 94179
                ? (c < 94031
                  ? (c < 93952
                    ? (c >= 93760 && c <= 93823)
                    : c <= 94026)
                  : (c <= 94087 || (c < 94176
                    ? (c >= 94095 && c <= 94111)
                    : c <= 94177)))
                : (c <= 94180 || (c < 100352
                  ? (c < 94208
                    ? (c >= 94192 && c <= 94193)
                    : c <= 100343)
                  : (c <= 101589 || (c < 110576
                    ? (c >= 101632 && c <= 101640)
                    : c <= 110579)))))))
            : (c <= 110587 || (c < 118576
              ? (c < 113664
                ? (c < 110928
                  ? (c < 110592
                    ? (c >= 110589 && c <= 110590)
                    : c <= 110882)
                  : (c <= 110930 || (c < 110960
                    ? (c >= 110948 && c <= 110951)
                    : c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c < 118528
                    ? (c >= 113821 && c <= 113822)
                    : c <= 118573)))))
              : (c <= 118598 || (c < 119362
                ? (c < 119163
                  ? (c < 119149
                    ? (c >= 119141 && c <= 119145)
                    : c <= 119154)
                  : (c <= 119170 || (c < 119210
                    ? (c >= 119173 && c <= 119179)
                    : c <= 119213)))
                : (c <= 119364 || (c < 119966
                  ? (c < 119894
                    ? (c >= 119808 && c <= 119892)
                    : c <= 119964)
                  : (c <= 119967 || c == 119970))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool sym__ident_reg_character_set_6(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2741
        ? (c < 2042
          ? (c < 931
            ? (c < 248
              ? (c < 170
                ? (c < 'A'
                  ? (c < '0'
                    ? c == '-'
                    : c <= '9')
                  : (c <= 'Z' || (c < 'b'
                    ? c == '_'
                    : c <= 'z')))
                : (c <= 170 || (c < 186
                  ? (c < 183
                    ? c == 181
                    : c <= 183)
                  : (c <= 186 || (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)))))
              : (c <= 705 || (c < 886
                ? (c < 748
                  ? (c < 736
                    ? (c >= 710 && c <= 721)
                    : c <= 740)
                  : (c <= 748 || (c < 768
                    ? c == 750
                    : c <= 884)))
                : (c <= 887 || (c < 902
                  ? (c < 895
                    ? (c >= 891 && c <= 893)
                    : c <= 895)
                  : (c <= 906 || (c < 910
                    ? c == 908
                    : c <= 929)))))))
            : (c <= 1013 || (c < 1488
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1155
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1159)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1473
                  ? (c < 1471
                    ? (c >= 1425 && c <= 1469)
                    : c <= 1471)
                  : (c <= 1474 || (c < 1479
                    ? (c >= 1476 && c <= 1477)
                    : c <= 1479)))))
              : (c <= 1514 || (c < 1759
                ? (c < 1568
                  ? (c < 1552
                    ? (c >= 1519 && c <= 1522)
                    : c <= 1562)
                  : (c <= 1641 || (c < 1749
                    ? (c >= 1646 && c <= 1747)
                    : c <= 1756)))
                : (c <= 1768 || (c < 1808
                  ? (c < 1791
                    ? (c >= 1770 && c <= 1788)
                    : c <= 1791)
                  : (c <= 1866 || (c < 1984
                    ? (c >= 1869 && c <= 1969)
                    : c <= 2037)))))))))
          : (c <= 2042 || (c < 2556
            ? (c < 2447
              ? (c < 2185
                ? (c < 2112
                  ? (c < 2048
                    ? c == 2045
                    : c <= 2093)
                  : (c <= 2139 || (c < 2160
                    ? (c >= 2144 && c <= 2154)
                    : c <= 2183)))
                : (c <= 2190 || (c < 2406
                  ? (c < 2275
                    ? (c >= 2200 && c <= 2273)
                    : c <= 2403)
                  : (c <= 2415 || (c < 2437
                    ? (c >= 2417 && c <= 2435)
                    : c <= 2444)))))
              : (c <= 2448 || (c < 2503
                ? (c < 2482
                  ? (c < 2474
                    ? (c >= 2451 && c <= 2472)
                    : c <= 2480)
                  : (c <= 2482 || (c < 2492
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2500)))
                : (c <= 2504 || (c < 2524
                  ? (c < 2519
                    ? (c >= 2507 && c <= 2510)
                    : c <= 2519)
                  : (c <= 2525 || (c < 2534
                    ? (c >= 2527 && c <= 2531)
                    : c <= 2545)))))))
            : (c <= 2556 || (c < 2631
              ? (c < 2602
                ? (c < 2565
                  ? (c < 2561
                    ? c == 2558
                    : c <= 2563)
                  : (c <= 2570 || (c < 2579
                    ? (c >= 2575 && c <= 2576)
                    : c <= 2600)))
                : (c <= 2608 || (c < 2616
                  ? (c < 2613
                    ? (c >= 2610 && c <= 2611)
                    : c <= 2614)
                  : (c <= 2617 || (c < 2622
                    ? c == 2620
                    : c <= 2626)))))
              : (c <= 2632 || (c < 2689
                ? (c < 2649
                  ? (c < 2641
                    ? (c >= 2635 && c <= 2637)
                    : c <= 2641)
                  : (c <= 2652 || (c < 2662
                    ? c == 2654
                    : c <= 2677)))
                : (c <= 2691 || (c < 2707
                  ? (c < 2703
                    ? (c >= 2693 && c <= 2701)
                    : c <= 2705)
                  : (c <= 2728 || (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)))))))))))
        : (c <= 2745 || (c < 3165
          ? (c < 2949
            ? (c < 2858
              ? (c < 2790
                ? (c < 2763
                  ? (c < 2759
                    ? (c >= 2748 && c <= 2757)
                    : c <= 2761)
                  : (c <= 2765 || (c < 2784
                    ? c == 2768
                    : c <= 2787)))
                : (c <= 2799 || (c < 2821
                  ? (c < 2817
                    ? (c >= 2809 && c <= 2815)
                    : c <= 2819)
                  : (c <= 2828 || (c < 2835
                    ? (c >= 2831 && c <= 2832)
                    : c <= 2856)))))
              : (c <= 2864 || (c < 2901
                ? (c < 2876
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2884 || (c < 2891
                    ? (c >= 2887 && c <= 2888)
                    : c <= 2893)))
                : (c <= 2903 || (c < 2918
                  ? (c < 2911
                    ? (c >= 2908 && c <= 2909)
                    : c <= 2915)
                  : (c <= 2927 || (c < 2946
                    ? c == 2929
                    : c <= 2947)))))))
            : (c <= 2954 || (c < 3024
              ? (c < 2979
                ? (c < 2969
                  ? (c < 2962
                    ? (c >= 2958 && c <= 2960)
                    : c <= 2965)
                  : (c <= 2970 || (c < 2974
                    ? c == 2972
                    : c <= 2975)))
                : (c <= 2980 || (c < 3006
                  ? (c < 2990
                    ? (c >= 2984 && c <= 2986)
                    : c <= 3001)
                  : (c <= 3010 || (c < 3018
                    ? (c >= 3014 && c <= 3016)
                    : c <= 3021)))))
              : (c <= 3024 || (c < 3114
                ? (c < 3072
                  ? (c < 3046
                    ? c == 3031
                    : c <= 3055)
                  : (c <= 3084 || (c < 3090
                    ? (c >= 3086 && c <= 3088)
                    : c <= 3112)))
                : (c <= 3129 || (c < 3146
                  ? (c < 3142
                    ? (c >= 3132 && c <= 3140)
                    : c <= 3144)
                  : (c <= 3149 || (c < 3160
                    ? (c >= 3157 && c <= 3158)
                    : c <= 3162)))))))))
          : (c <= 3165 || (c < 3430
            ? (c < 3285
              ? (c < 3218
                ? (c < 3200
                  ? (c < 3174
                    ? (c >= 3168 && c <= 3171)
                    : c <= 3183)
                  : (c <= 3203 || (c < 3214
                    ? (c >= 3205 && c <= 3212)
                    : c <= 3216)))
                : (c <= 3240 || (c < 3260
                  ? (c < 3253
                    ? (c >= 3242 && c <= 3251)
                    : c <= 3257)
                  : (c <= 3268 || (c < 3274
                    ? (c >= 3270 && c <= 3272)
                    : c <= 3277)))))
              : (c <= 3286 || (c < 3342
                ? (c < 3302
                  ? (c < 3296
                    ? (c >= 3293 && c <= 3294)
                    : c <= 3299)
                  : (c <= 3311 || (c < 3328
                    ? (c >= 3313 && c <= 3314)
                    : c <= 3340)))
                : (c <= 3344 || (c < 3402
                  ? (c < 3398
                    ? (c >= 3346 && c <= 3396)
                    : c <= 3400)
                  : (c <= 3406 || (c < 3423
                    ? (c >= 3412 && c <= 3415)
                    : c <= 3427)))))))
            : (c <= 3439 || (c < 3558
              ? (c < 3517
                ? (c < 3461
                  ? (c < 3457
                    ? (c >= 3450 && c <= 3455)
                    : c <= 3459)
                  : (c <= 3478 || (c < 3507
                    ? (c >= 3482 && c <= 3505)
                    : c <= 3515)))
                : (c <= 3517 || (c < 3535
                  ? (c < 3530
                    ? (c >= 3520 && c <= 3526)
                    : c <= 3530)
                  : (c <= 3540 || (c < 3544
                    ? c == 3542
                    : c <= 3551)))))
              : (c <= 3567 || (c < 3716
                ? (c < 3648
                  ? (c < 3585
                    ? (c >= 3570 && c <= 3571)
                    : c <= 3642)
                  : (c <= 3662 || (c < 3713
                    ? (c >= 3664 && c <= 3673)
                    : c <= 3714)))
                : (c <= 3716 || (c < 3749
                  ? (c < 3724
                    ? (c >= 3718 && c <= 3722)
                    : c <= 3747)
                  : (c <= 3749 || (c < 3776
                    ? (c >= 3751 && c <= 3773)
                    : c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static inline bool sym__ident_reg_character_set_7(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2748
        ? (c < 2045
          ? (c < 1015
            ? (c < 710
              ? (c < 181
                ? (c < 'A'
                  ? (c < '0'
                    ? c == '-'
                    : c <= '9')
                  : (c <= 'Z' || (c < 170
                    ? (c >= 'a' && c <= 'z')
                    : c <= 170)))
                : (c <= 181 || (c < 192
                  ? (c < 186
                    ? c == 183
                    : c <= 186)
                  : (c <= 214 || (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)))))
              : (c <= 721 || (c < 891
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c < 886
                    ? (c >= 768 && c <= 884)
                    : c <= 887)))
                : (c <= 893 || (c < 908
                  ? (c < 902
                    ? c == 895
                    : c <= 906)
                  : (c <= 908 || (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)))))))
            : (c <= 1153 || (c < 1519
              ? (c < 1425
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1155 && c <= 1159)
                    : c <= 1327)
                  : (c <= 1366 || (c < 1376
                    ? c == 1369
                    : c <= 1416)))
                : (c <= 1469 || (c < 1476
                  ? (c < 1473
                    ? c == 1471
                    : c <= 1474)
                  : (c <= 1477 || (c < 1488
                    ? c == 1479
                    : c <= 1514)))))
              : (c <= 1522 || (c < 1770
                ? (c < 1646
                  ? (c < 1568
                    ? (c >= 1552 && c <= 1562)
                    : c <= 1641)
                  : (c <= 1747 || (c < 1759
                    ? (c >= 1749 && c <= 1756)
                    : c <= 1768)))
                : (c <= 1788 || (c < 1869
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1866)
                  : (c <= 1969 || (c < 2042
                    ? (c >= 1984 && c <= 2037)
                    : c <= 2042)))))))))
          : (c <= 2045 || (c < 2558
            ? (c < 2451
              ? (c < 2200
                ? (c < 2144
                  ? (c < 2112
                    ? (c >= 2048 && c <= 2093)
                    : c <= 2139)
                  : (c <= 2154 || (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)))
                : (c <= 2273 || (c < 2417
                  ? (c < 2406
                    ? (c >= 2275 && c <= 2403)
                    : c <= 2415)
                  : (c <= 2435 || (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)))))
              : (c <= 2472 || (c < 2507
                ? (c < 2486
                  ? (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)
                  : (c <= 2489 || (c < 2503
                    ? (c >= 2492 && c <= 2500)
                    : c <= 2504)))
                : (c <= 2510 || (c < 2527
                  ? (c < 2524
                    ? c == 2519
                    : c <= 2525)
                  : (c <= 2531 || (c < 2556
                    ? (c >= 2534 && c <= 2545)
                    : c <= 2556)))))))
            : (c <= 2558 || (c < 2635
              ? (c < 2610
                ? (c < 2575
                  ? (c < 2565
                    ? (c >= 2561 && c <= 2563)
                    : c <= 2570)
                  : (c <= 2576 || (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)))
                : (c <= 2611 || (c < 2620
                  ? (c < 2616
                    ? (c >= 2613 && c <= 2614)
                    : c <= 2617)
                  : (c <= 2620 || (c < 2631
                    ? (c >= 2622 && c <= 2626)
                    : c <= 2632)))))
              : (c <= 2637 || (c < 2693
                ? (c < 2654
                  ? (c < 2649
                    ? c == 2641
                    : c <= 2652)
                  : (c <= 2654 || (c < 2689
                    ? (c >= 2662 && c <= 2677)
                    : c <= 2691)))
                : (c <= 2701 || (c < 2730
                  ? (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)
                  : (c <= 2736 || (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)))))))))))
        : (c <= 2757 || (c < 3168
          ? (c < 2958
            ? (c < 2866
              ? (c < 2809
                ? (c < 2768
                  ? (c < 2763
                    ? (c >= 2759 && c <= 2761)
                    : c <= 2765)
                  : (c <= 2768 || (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)))
                : (c <= 2815 || (c < 2831
                  ? (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)
                  : (c <= 2832 || (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)))))
              : (c <= 2867 || (c < 2908
                ? (c < 2887
                  ? (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)
                  : (c <= 2888 || (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)))
                : (c <= 2909 || (c < 2929
                  ? (c < 2918
                    ? (c >= 2911 && c <= 2915)
                    : c <= 2927)
                  : (c <= 2929 || (c < 2949
                    ? (c >= 2946 && c <= 2947)
                    : c <= 2954)))))))
            : (c <= 2960 || (c < 3031
              ? (c < 2984
                ? (c < 2972
                  ? (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)
                  : (c <= 2972 || (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)))
                : (c <= 2986 || (c < 3014
                  ? (c < 3006
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3010)
                  : (c <= 3016 || (c < 3024
                    ? (c >= 3018 && c <= 3021)
                    : c <= 3024)))))
              : (c <= 3031 || (c < 3132
                ? (c < 3086
                  ? (c < 3072
                    ? (c >= 3046 && c <= 3055)
                    : c <= 3084)
                  : (c <= 3088 || (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)))
                : (c <= 3140 || (c < 3157
                  ? (c < 3146
                    ? (c >= 3142 && c <= 3144)
                    : c <= 3149)
                  : (c <= 3158 || (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)))))))))
          : (c <= 3171 || (c < 3450
            ? (c < 3293
              ? (c < 3242
                ? (c < 3205
                  ? (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : c <= 3203)
                  : (c <= 3212 || (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)))
                : (c <= 3251 || (c < 3270
                  ? (c < 3260
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3268)
                  : (c <= 3272 || (c < 3285
                    ? (c >= 3274 && c <= 3277)
                    : c <= 3286)))))
              : (c <= 3294 || (c < 3346
                ? (c < 3313
                  ? (c < 3302
                    ? (c >= 3296 && c <= 3299)
                    : c <= 3311)
                  : (c <= 3314 || (c < 3342
                    ? (c >= 3328 && c <= 3340)
                    : c <= 3344)))
                : (c <= 3396 || (c < 3412
                  ? (c < 3402
                    ? (c >= 3398 && c <= 3400)
                    : c <= 3406)
                  : (c <= 3415 || (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : c <= 3439)))))))
            : (c <= 3455 || (c < 3570
              ? (c < 3520
                ? (c < 3482
                  ? (c < 3461
                    ? (c >= 3457 && c <= 3459)
                    : c <= 3478)
                  : (c <= 3505 || (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)))
                : (c <= 3526 || (c < 3542
                  ? (c < 3535
                    ? c == 3530
                    : c <= 3540)
                  : (c <= 3542 || (c < 3558
                    ? (c >= 3544 && c <= 3551)
                    : c <= 3567)))))
              : (c <= 3571 || (c < 3718
                ? (c < 3664
                  ? (c < 3648
                    ? (c >= 3585 && c <= 3642)
                    : c <= 3662)
                  : (c <= 3673 || (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)))
                : (c <= 3722 || (c < 3751
                  ? (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(347);
      if (lookahead == '!') ADVANCE(425);
      if (lookahead == '"') ADVANCE(446);
      if (lookahead == '#') ADVANCE(711);
      if (lookahead == '%') ADVANCE(730);
      if (lookahead == '&') ADVANCE(428);
      if (lookahead == '\'') ADVANCE(447);
      if (lookahead == '(') ADVANCE(391);
      if (lookahead == ')') ADVANCE(392);
      if (lookahead == '*') ADVANCE(384);
      if (lookahead == '+') ADVANCE(438);
      if (lookahead == ',') ADVANCE(355);
      if (lookahead == '-') ADVANCE(423);
      if (lookahead == '.') ADVANCE(416);
      if (lookahead == '/') ADVANCE(439);
      if (lookahead == ':') ADVANCE(354);
      if (lookahead == ';') ADVANCE(363);
      if (lookahead == '<') ADVANCE(398);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '>') ADVANCE(400);
      if (lookahead == '?') ADVANCE(440);
      if (lookahead == '@') ADVANCE(370);
      if (lookahead == '[') ADVANCE(373);
      if (lookahead == '\\') SKIP(343)
      if (lookahead == ']') ADVANCE(379);
      if (lookahead == '^') ADVANCE(430);
      if (lookahead == 'a') ADVANCE(87);
      if (lookahead == 'b') ADVANCE(180);
      if (lookahead == 'c') ADVANCE(60);
      if (lookahead == 'd') ADVANCE(108);
      if (lookahead == 'e') ADVANCE(64);
      if (lookahead == 'f') ADVANCE(65);
      if (lookahead == 'g') ADVANCE(187);
      if (lookahead == 'i') ADVANCE(139);
      if (lookahead == 'l') ADVANCE(109);
      if (lookahead == 'm') ADVANCE(61);
      if (lookahead == 'o') ADVANCE(314);
      if (lookahead == 'p') ADVANCE(70);
      if (lookahead == 'r') ADVANCE(69);
      if (lookahead == 's') ADVANCE(162);
      if (lookahead == 't') ADVANCE(71);
      if (lookahead == 'w') ADVANCE(154);
      if (lookahead == 'y') ADVANCE(110);
      if (lookahead == '{') ADVANCE(352);
      if (lookahead == '|') ADVANCE(429);
      if (lookahead == '}') ADVANCE(356);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('A' <= lookahead && lookahead <= 'F')) ADVANCE(337);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(723);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(31)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(31)
      if (lookahead == '\r') SKIP(1)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(33)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(33)
      if (lookahead == '\r') SKIP(3)
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(37)
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(37)
      if (lookahead == '\r') SKIP(5)
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(30)
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(30)
      if (lookahead == '\r') SKIP(7)
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(40)
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(40)
      if (lookahead == '\r') SKIP(9)
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(41)
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(41)
      if (lookahead == '\r') SKIP(11)
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(50)
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(50)
      if (lookahead == '\r') SKIP(13)
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(51)
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(51)
      if (lookahead == '\r') SKIP(15)
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(34)
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(34)
      if (lookahead == '\r') SKIP(17)
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(35)
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(35)
      if (lookahead == '\r') SKIP(19)
      END_STATE();
    case 21:
      if (lookahead == '\n') SKIP(36)
      END_STATE();
    case 22:
      if (lookahead == '\n') SKIP(36)
      if (lookahead == '\r') SKIP(21)
      END_STATE();
    case 23:
      if (lookahead == '\n') ADVANCE(460);
      if (lookahead == '\r') ADVANCE(460);
      if (lookahead == 'u') ADVANCE(329);
      if (lookahead == 'x') ADVANCE(339);
      if (lookahead != 0) ADVANCE(460);
      END_STATE();
    case 24:
      if (lookahead == '\n') SKIP(32)
      END_STATE();
    case 25:
      if (lookahead == '\n') SKIP(32)
      if (lookahead == '\r') SKIP(24)
      END_STATE();
    case 26:
      if (lookahead == '\n') SKIP(52)
      END_STATE();
    case 27:
      if (lookahead == '\n') SKIP(52)
      if (lookahead == '\r') SKIP(26)
      END_STATE();
    case 28:
      if (lookahead == '\n') SKIP(53)
      END_STATE();
    case 29:
      if (lookahead == '\n') SKIP(53)
      if (lookahead == '\r') SKIP(28)
      END_STATE();
    case 30:
      if (lookahead == '!') ADVANCE(425);
      if (lookahead == '"') ADVANCE(446);
      if (lookahead == '#') ADVANCE(711);
      if (lookahead == '%') ADVANCE(730);
      if (lookahead == '&') ADVANCE(428);
      if (lookahead == '\'') ADVANCE(447);
      if (lookahead == '(') ADVANCE(391);
      if (lookahead == ')') ADVANCE(392);
      if (lookahead == '*') ADVANCE(384);
      if (lookahead == '+') ADVANCE(438);
      if (lookahead == ',') ADVANCE(355);
      if (lookahead == '-') ADVANCE(422);
      if (lookahead == '.') ADVANCE(416);
      if (lookahead == '/') ADVANCE(439);
      if (lookahead == ':') ADVANCE(353);
      if (lookahead == ';') ADVANCE(363);
      if (lookahead == '<') ADVANCE(398);
      if (lookahead == '=') ADVANCE(404);
      if (lookahead == '>') ADVANCE(400);
      if (lookahead == '?') ADVANCE(440);
      if (lookahead == '@') ADVANCE(370);
      if (lookahead == '[') ADVANCE(373);
      if (lookahead == '\\') SKIP(8)
      if (lookahead == '^') ADVANCE(430);
      if (lookahead == 'a') ADVANCE(498);
      if (lookahead == 'b') ADVANCE(578);
      if (lookahead == 'c') ADVANCE(530);
      if (lookahead == 'd') ADVANCE(526);
      if (lookahead == 'e') ADVANCE(469);
      if (lookahead == 'f') ADVANCE(488);
      if (lookahead == 'g') ADVANCE(643);
      if (lookahead == 'i') ADVANCE(542);
      if (lookahead == 'l') ADVANCE(517);
      if (lookahead == 'm') ADVANCE(463);
      if (lookahead == 'p') ADVANCE(471);
      if (lookahead == 'r') ADVANCE(481);
      if (lookahead == 's') ADVANCE(560);
      if (lookahead == 't') ADVANCE(476);
      if (lookahead == 'w') ADVANCE(558);
      if (lookahead == 'y') ADVANCE(528);
      if (lookahead == '{') ADVANCE(352);
      if (lookahead == '|') ADVANCE(429);
      if (lookahead == '}') ADVANCE(356);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(30)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(722);
      if (sym__ident_reg_character_set_1(lookahead)) ADVANCE(710);
      END_STATE();
    case 31:
      if (lookahead == '!') ADVANCE(425);
      if (lookahead == '"') ADVANCE(446);
      if (lookahead == '#') ADVANCE(711);
      if (lookahead == '%') ADVANCE(55);
      if (lookahead == '&') ADVANCE(428);
      if (lookahead == '\'') ADVANCE(447);
      if (lookahead == '(') ADVANCE(391);
      if (lookahead == ')') ADVANCE(392);
      if (lookahead == '*') ADVANCE(384);
      if (lookahead == '+') ADVANCE(438);
      if (lookahead == ',') ADVANCE(355);
      if (lookahead == '-') ADVANCE(422);
      if (lookahead == '.') ADVANCE(416);
      if (lookahead == '/') ADVANCE(439);
      if (lookahead == ':') ADVANCE(353);
      if (lookahead == ';') ADVANCE(363);
      if (lookahead == '<') ADVANCE(398);
      if (lookahead == '=') ADVANCE(404);
      if (lookahead == '>') ADVANCE(400);
      if (lookahead == '?') ADVANCE(440);
      if (lookahead == '@') ADVANCE(370);
      if (lookahead == '[') ADVANCE(373);
      if (lookahead == '\\') SKIP(2)
      if (lookahead == ']') ADVANCE(379);
      if (lookahead == '^') ADVANCE(430);
      if (lookahead == 'a') ADVANCE(498);
      if (lookahead == 'b') ADVANCE(578);
      if (lookahead == 'c') ADVANCE(530);
      if (lookahead == 'd') ADVANCE(516);
      if (lookahead == 'e') ADVANCE(469);
      if (lookahead == 'f') ADVANCE(488);
      if (lookahead == 'g') ADVANCE(643);
      if (lookahead == 'i') ADVANCE(542);
      if (lookahead == 'l') ADVANCE(517);
      if (lookahead == 'm') ADVANCE(464);
      if (lookahead == 'p') ADVANCE(472);
      if (lookahead == 'r') ADVANCE(531);
      if (lookahead == 's') ADVANCE(560);
      if (lookahead == 't') ADVANCE(476);
      if (lookahead == 'w') ADVANCE(558);
      if (lookahead == 'y') ADVANCE(528);
      if (lookahead == '{') ADVANCE(352);
      if (lookahead == '|') ADVANCE(429);
      if (lookahead == '}') ADVANCE(356);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(31)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(722);
      if (sym__ident_reg_character_set_2(lookahead)) ADVANCE(710);
      END_STATE();
    case 32:
      if (lookahead == '!') ADVANCE(425);
      if (lookahead == '"') ADVANCE(446);
      if (lookahead == '#') ADVANCE(711);
      if (lookahead == '%') ADVANCE(55);
      if (lookahead == '&') ADVANCE(428);
      if (lookahead == '\'') ADVANCE(447);
      if (lookahead == '(') ADVANCE(391);
      if (lookahead == ')') ADVANCE(392);
      if (lookahead == '*') ADVANCE(384);
      if (lookahead == '+') ADVANCE(438);
      if (lookahead == ',') ADVANCE(355);
      if (lookahead == '-') ADVANCE(422);
      if (lookahead == '.') ADVANCE(416);
      if (lookahead == '/') ADVANCE(439);
      if (lookahead == ':') ADVANCE(353);
      if (lookahead == ';') ADVANCE(363);
      if (lookahead == '<') ADVANCE(398);
      if (lookahead == '=') ADVANCE(404);
      if (lookahead == '>') ADVANCE(400);
      if (lookahead == '?') ADVANCE(440);
      if (lookahead == '@') ADVANCE(370);
      if (lookahead == '[') ADVANCE(373);
      if (lookahead == '\\') SKIP(25)
      if (lookahead == '^') ADVANCE(430);
      if (lookahead == 'a') ADVANCE(498);
      if (lookahead == 'b') ADVANCE(578);
      if (lookahead == 'c') ADVANCE(530);
      if (lookahead == 'd') ADVANCE(516);
      if (lookahead == 'e') ADVANCE(467);
      if (lookahead == 'f') ADVANCE(488);
      if (lookahead == 'g') ADVANCE(643);
      if (lookahead == 'i') ADVANCE(542);
      if (lookahead == 'l') ADVANCE(517);
      if (lookahead == 'm') ADVANCE(464);
      if (lookahead == 'p') ADVANCE(472);
      if (lookahead == 'r') ADVANCE(531);
      if (lookahead == 's') ADVANCE(560);
      if (lookahead == 't') ADVANCE(476);
      if (lookahead == 'w') ADVANCE(558);
      if (lookahead == 'y') ADVANCE(528);
      if (lookahead == '{') ADVANCE(352);
      if (lookahead == '|') ADVANCE(429);
      if (lookahead == '}') ADVANCE(356);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(32)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(722);
      if (sym__ident_reg_character_set_1(lookahead)) ADVANCE(710);
      END_STATE();
    case 33:
      if (lookahead == '!') ADVANCE(425);
      if (lookahead == '"') ADVANCE(446);
      if (lookahead == '#') ADVANCE(711);
      if (lookahead == '%') ADVANCE(55);
      if (lookahead == '&') ADVANCE(428);
      if (lookahead == '\'') ADVANCE(447);
      if (lookahead == '(') ADVANCE(391);
      if (lookahead == '*') ADVANCE(384);
      if (lookahead == '+') ADVANCE(438);
      if (lookahead == ',') ADVANCE(355);
      if (lookahead == '-') ADVANCE(422);
      if (lookahead == '.') ADVANCE(416);
      if (lookahead == '/') ADVANCE(439);
      if (lookahead == ':') ADVANCE(353);
      if (lookahead == '<') ADVANCE(399);
      if (lookahead == '=') ADVANCE(404);
      if (lookahead == '>') ADVANCE(400);
      if (lookahead == '?') ADVANCE(440);
      if (lookahead == '@') ADVANCE(370);
      if (lookahead == '[') ADVANCE(373);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == '^') ADVANCE(430);
      if (lookahead == 'a') ADVANCE(499);
      if (lookahead == 'b') ADVANCE(578);
      if (lookahead == 'c') ADVANCE(491);
      if (lookahead == 'd') ADVANCE(516);
      if (lookahead == 'e') ADVANCE(468);
      if (lookahead == 'f') ADVANCE(487);
      if (lookahead == 'g') ADVANCE(643);
      if (lookahead == 'i') ADVANCE(543);
      if (lookahead == 'l') ADVANCE(517);
      if (lookahead == 'm') ADVANCE(464);
      if (lookahead == 'o') ADVANCE(702);
      if (lookahead == 'p') ADVANCE(470);
      if (lookahead == 'r') ADVANCE(531);
      if (lookahead == 's') ADVANCE(561);
      if (lookahead == 't') ADVANCE(478);
      if (lookahead == 'w') ADVANCE(558);
      if (lookahead == 'y') ADVANCE(528);
      if (lookahead == '{') ADVANCE(352);
      if (lookahead == '|') ADVANCE(429);
      if (lookahead == '}') ADVANCE(356);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(33)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(722);
      if (sym__ident_reg_character_set_1(lookahead)) ADVANCE(710);
      END_STATE();
    case 34:
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '%') ADVANCE(730);
      if (lookahead == '&') ADVANCE(428);
      if (lookahead == '(') ADVANCE(391);
      if (lookahead == ')') ADVANCE(392);
      if (lookahead == '*') ADVANCE(384);
      if (lookahead == '+') ADVANCE(438);
      if (lookahead == ',') ADVANCE(355);
      if (lookahead == '-') ADVANCE(422);
      if (lookahead == '.') ADVANCE(416);
      if (lookahead == '/') ADVANCE(439);
      if (lookahead == ':') ADVANCE(353);
      if (lookahead == ';') ADVANCE(363);
      if (lookahead == '<') ADVANCE(399);
      if (lookahead == '=') ADVANCE(404);
      if (lookahead == '>') ADVANCE(400);
      if (lookahead == '?') ADVANCE(440);
      if (lookahead == '[') ADVANCE(373);
      if (lookahead == '\\') SKIP(18)
      if (lookahead == ']') ADVANCE(379);
      if (lookahead == '^') ADVANCE(430);
      if (lookahead == 'd') ADVANCE(121);
      if (lookahead == 'e') ADVANCE(181);
      if (lookahead == 'i') ADVANCE(213);
      if (lookahead == 'm') ADVANCE(273);
      if (lookahead == 'o') ADVANCE(314);
      if (lookahead == 'p') ADVANCE(324);
      if (lookahead == 'r') ADVANCE(68);
      if (lookahead == '{') ADVANCE(352);
      if (lookahead == '|') ADVANCE(429);
      if (lookahead == '}') ADVANCE(356);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(34)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(337);
      END_STATE();
    case 35:
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '%') ADVANCE(55);
      if (lookahead == '&') ADVANCE(428);
      if (lookahead == '(') ADVANCE(391);
      if (lookahead == ')') ADVANCE(392);
      if (lookahead == '*') ADVANCE(384);
      if (lookahead == '+') ADVANCE(438);
      if (lookahead == ',') ADVANCE(355);
      if (lookahead == '-') ADVANCE(423);
      if (lookahead == '.') ADVANCE(416);
      if (lookahead == '/') ADVANCE(439);
      if (lookahead == ':') ADVANCE(354);
      if (lookahead == ';') ADVANCE(363);
      if (lookahead == '<') ADVANCE(398);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '>') ADVANCE(400);
      if (lookahead == '?') ADVANCE(440);
      if (lookahead == '[') ADVANCE(373);
      if (lookahead == '\\') SKIP(20)
      if (lookahead == ']') ADVANCE(379);
      if (lookahead == '^') ADVANCE(430);
      if (lookahead == 'a') ADVANCE(272);
      if (lookahead == 'c') ADVANCE(153);
      if (lookahead == 'i') ADVANCE(201);
      if (lookahead == 'l') ADVANCE(161);
      if (lookahead == 'r') ADVANCE(76);
      if (lookahead == 'w') ADVANCE(160);
      if (lookahead == '{') ADVANCE(352);
      if (lookahead == '|') ADVANCE(429);
      if (lookahead == '}') ADVANCE(356);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(35)
      END_STATE();
    case 36:
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '%') ADVANCE(55);
      if (lookahead == '&') ADVANCE(428);
      if (lookahead == '(') ADVANCE(391);
      if (lookahead == '*') ADVANCE(384);
      if (lookahead == '+') ADVANCE(438);
      if (lookahead == '-') ADVANCE(422);
      if (lookahead == '.') ADVANCE(416);
      if (lookahead == '/') ADVANCE(439);
      if (lookahead == ':') ADVANCE(354);
      if (lookahead == '<') ADVANCE(399);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '>') ADVANCE(400);
      if (lookahead == '?') ADVANCE(440);
      if (lookahead == '[') ADVANCE(373);
      if (lookahead == '\\') SKIP(22)
      if (lookahead == '^') ADVANCE(430);
      if (lookahead == 'i') ADVANCE(222);
      if (lookahead == '{') ADVANCE(352);
      if (lookahead == '|') ADVANCE(429);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(36)
      END_STATE();
    case 37:
      if (lookahead == '!') ADVANCE(424);
      if (lookahead == '"') ADVANCE(446);
      if (lookahead == '#') ADVANCE(711);
      if (lookahead == '\'') ADVANCE(447);
      if (lookahead == '(') ADVANCE(391);
      if (lookahead == '-') ADVANCE(421);
      if (lookahead == '/') ADVANCE(42);
      if (lookahead == ':') ADVANCE(353);
      if (lookahead == '@') ADVANCE(370);
      if (lookahead == '[') ADVANCE(373);
      if (lookahead == '\\') SKIP(6)
      if (lookahead == 'a') ADVANCE(498);
      if (lookahead == 'b') ADVANCE(578);
      if (lookahead == 'c') ADVANCE(492);
      if (lookahead == 'd') ADVANCE(516);
      if (lookahead == 'e') ADVANCE(469);
      if (lookahead == 'f') ADVANCE(488);
      if (lookahead == 'g') ADVANCE(643);
      if (lookahead == 'i') ADVANCE(543);
      if (lookahead == 'l') ADVANCE(517);
      if (lookahead == 'm') ADVANCE(464);
      if (lookahead == 'o') ADVANCE(702);
      if (lookahead == 'p') ADVANCE(470);
      if (lookahead == 'r') ADVANCE(531);
      if (lookahead == 's') ADVANCE(560);
      if (lookahead == 't') ADVANCE(476);
      if (lookahead == 'w') ADVANCE(558);
      if (lookahead == 'y') ADVANCE(528);
      if (lookahead == '{') ADVANCE(352);
      if (lookahead == '}') ADVANCE(356);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(37)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(722);
      if (sym__ident_reg_character_set_1(lookahead)) ADVANCE(710);
      END_STATE();
    case 38:
      if (lookahead == '"') ADVANCE(446);
      if (lookahead == '/') ADVANCE(449);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(452);
      if (lookahead != 0) ADVANCE(453);
      END_STATE();
    case 39:
      if (lookahead == '\'') ADVANCE(447);
      if (lookahead == '/') ADVANCE(455);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(458);
      if (lookahead != 0) ADVANCE(459);
      END_STATE();
    case 40:
      if (lookahead == '(') ADVANCE(391);
      if (lookahead == '-') ADVANCE(57);
      if (lookahead == '/') ADVANCE(42);
      if (lookahead == ';') ADVANCE(363);
      if (lookahead == '<') ADVANCE(56);
      if (lookahead == '=') ADVANCE(58);
      if (lookahead == '\\') SKIP(10)
      if (lookahead == 'a') ADVANCE(498);
      if (lookahead == 'b') ADVANCE(578);
      if (lookahead == 'c') ADVANCE(529);
      if (lookahead == 'd') ADVANCE(516);
      if (lookahead == 'e') ADVANCE(468);
      if (lookahead == 'f') ADVANCE(583);
      if (lookahead == 'g') ADVANCE(643);
      if (lookahead == 'i') ADVANCE(542);
      if (lookahead == 'l') ADVANCE(517);
      if (lookahead == 'm') ADVANCE(464);
      if (lookahead == 'p') ADVANCE(472);
      if (lookahead == 'r') ADVANCE(531);
      if (lookahead == 's') ADVANCE(560);
      if (lookahead == 't') ADVANCE(477);
      if (lookahead == 'w') ADVANCE(558);
      if (lookahead == 'y') ADVANCE(528);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(40)
      if (sym__ident_reg_character_set_1(lookahead)) ADVANCE(710);
      END_STATE();
    case 41:
      if (lookahead == ')') ADVANCE(392);
      if (lookahead == ',') ADVANCE(355);
      if (lookahead == '/') ADVANCE(42);
      if (lookahead == '[') ADVANCE(373);
      if (lookahead == '\\') SKIP(12)
      if (lookahead == ']') ADVANCE(379);
      if (lookahead == 'a') ADVANCE(498);
      if (lookahead == 'b') ADVANCE(578);
      if (lookahead == 'c') ADVANCE(530);
      if (lookahead == 'd') ADVANCE(516);
      if (lookahead == 'e') ADVANCE(469);
      if (lookahead == 'f') ADVANCE(583);
      if (lookahead == 'g') ADVANCE(643);
      if (lookahead == 'i') ADVANCE(595);
      if (lookahead == 'l') ADVANCE(517);
      if (lookahead == 'm') ADVANCE(464);
      if (lookahead == 'p') ADVANCE(472);
      if (lookahead == 'r') ADVANCE(531);
      if (lookahead == 's') ADVANCE(560);
      if (lookahead == 't') ADVANCE(477);
      if (lookahead == 'w') ADVANCE(558);
      if (lookahead == 'y') ADVANCE(528);
      if (lookahead == '{') ADVANCE(352);
      if (lookahead == '}') ADVANCE(356);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(41)
      if (sym__ident_reg_character_set_1(lookahead)) ADVANCE(710);
      END_STATE();
    case 42:
      if (lookahead == '*') ADVANCE(44);
      if (lookahead == '/') ADVANCE(839);
      END_STATE();
    case 43:
      if (lookahead == '*') ADVANCE(43);
      if (lookahead == '/') ADVANCE(838);
      if (lookahead != 0) ADVANCE(44);
      END_STATE();
    case 44:
      if (lookahead == '*') ADVANCE(43);
      if (lookahead != 0) ADVANCE(44);
      END_STATE();
    case 45:
      if (lookahead == '-') ADVANCE(316);
      END_STATE();
    case 46:
      if (lookahead == '-') ADVANCE(148);
      END_STATE();
    case 47:
      if (lookahead == '-') ADVANCE(309);
      END_STATE();
    case 48:
      if (lookahead == '-') ADVANCE(195);
      if (lookahead == '_') ADVANCE(198);
      END_STATE();
    case 49:
      if (lookahead == '-') ADVANCE(152);
      END_STATE();
    case 50:
      if (lookahead == '/') ADVANCE(42);
      if (lookahead == '\\') SKIP(14)
      if (lookahead == 'a') ADVANCE(498);
      if (lookahead == 'b') ADVANCE(578);
      if (lookahead == 'c') ADVANCE(529);
      if (lookahead == 'd') ADVANCE(516);
      if (lookahead == 'e') ADVANCE(468);
      if (lookahead == 'f') ADVANCE(583);
      if (lookahead == 'g') ADVANCE(643);
      if (lookahead == 'i') ADVANCE(595);
      if (lookahead == 'l') ADVANCE(517);
      if (lookahead == 'm') ADVANCE(464);
      if (lookahead == 'p') ADVANCE(472);
      if (lookahead == 'r') ADVANCE(531);
      if (lookahead == 's') ADVANCE(560);
      if (lookahead == 't') ADVANCE(477);
      if (lookahead == 'w') ADVANCE(558);
      if (lookahead == 'y') ADVANCE(528);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(50)
      if (sym__ident_reg_character_set_1(lookahead)) ADVANCE(710);
      END_STATE();
    case 51:
      if (lookahead == '/') ADVANCE(42);
      if (lookahead == '\\') SKIP(16)
      if (lookahead == 'a') ADVANCE(498);
      if (lookahead == 'b') ADVANCE(578);
      if (lookahead == 'c') ADVANCE(529);
      if (lookahead == 'd') ADVANCE(516);
      if (lookahead == 'e') ADVANCE(469);
      if (lookahead == 'f') ADVANCE(583);
      if (lookahead == 'g') ADVANCE(585);
      if (lookahead == 'i') ADVANCE(595);
      if (lookahead == 'l') ADVANCE(517);
      if (lookahead == 'm') ADVANCE(464);
      if (lookahead == 'p') ADVANCE(472);
      if (lookahead == 'r') ADVANCE(531);
      if (lookahead == 's') ADVANCE(560);
      if (lookahead == 't') ADVANCE(477);
      if (lookahead == 'w') ADVANCE(558);
      if (lookahead == 'y') ADVANCE(528);
      if (lookahead == '{') ADVANCE(352);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(51)
      if (sym__ident_reg_character_set_1(lookahead)) ADVANCE(710);
      END_STATE();
    case 52:
      if (lookahead == '/') ADVANCE(42);
      if (lookahead == '\\') SKIP(27)
      if (lookahead == 'a') ADVANCE(498);
      if (lookahead == 'b') ADVANCE(578);
      if (lookahead == 'c') ADVANCE(529);
      if (lookahead == 'd') ADVANCE(516);
      if (lookahead == 'e') ADVANCE(469);
      if (lookahead == 'f') ADVANCE(583);
      if (lookahead == 'g') ADVANCE(643);
      if (lookahead == 'i') ADVANCE(595);
      if (lookahead == 'l') ADVANCE(517);
      if (lookahead == 'm') ADVANCE(464);
      if (lookahead == 'p') ADVANCE(472);
      if (lookahead == 'r') ADVANCE(531);
      if (lookahead == 's') ADVANCE(560);
      if (lookahead == 't') ADVANCE(477);
      if (lookahead == 'w') ADVANCE(558);
      if (lookahead == 'y') ADVANCE(528);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(52)
      if (sym__ident_reg_character_set_1(lookahead)) ADVANCE(710);
      END_STATE();
    case 53:
      if (lookahead == '/') ADVANCE(42);
      if (lookahead == '\\') SKIP(29)
      if (lookahead == 'a') ADVANCE(498);
      if (lookahead == 'b') ADVANCE(578);
      if (lookahead == 'c') ADVANCE(529);
      if (lookahead == 'd') ADVANCE(516);
      if (lookahead == 'e') ADVANCE(469);
      if (lookahead == 'f') ADVANCE(583);
      if (lookahead == 'g') ADVANCE(585);
      if (lookahead == 'i') ADVANCE(595);
      if (lookahead == 'l') ADVANCE(517);
      if (lookahead == 'm') ADVANCE(464);
      if (lookahead == 'p') ADVANCE(472);
      if (lookahead == 'r') ADVANCE(531);
      if (lookahead == 's') ADVANCE(559);
      if (lookahead == 't') ADVANCE(477);
      if (lookahead == 'w') ADVANCE(558);
      if (lookahead == 'y') ADVANCE(528);
      if (lookahead == '{') ADVANCE(352);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(53)
      if (sym__ident_reg_character_set_1(lookahead)) ADVANCE(710);
      END_STATE();
    case 54:
      if (lookahead == '=') ADVANCE(432);
      END_STATE();
    case 55:
      if (lookahead == '=') ADVANCE(410);
      END_STATE();
    case 56:
      if (lookahead == '=') ADVANCE(59);
      END_STATE();
    case 57:
      if (lookahead == '>') ADVANCE(389);
      END_STATE();
    case 58:
      if (lookahead == '>') ADVANCE(393);
      END_STATE();
    case 59:
      if (lookahead == '>') ADVANCE(390);
      END_STATE();
    case 60:
      if (lookahead == 'a') ADVANCE(188);
      if (lookahead == 'e') ADVANCE(163);
      if (lookahead == 'h') ADVANCE(165);
      if (lookahead == 'i') ADVANCE(258);
      if (lookahead == 'o') ADVANCE(190);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('b' <= lookahead && lookahead <= 'f')) ADVANCE(332);
      END_STATE();
    case 61:
      if (lookahead == 'a') ADVANCE(325);
      if (lookahead == 'i') ADVANCE(203);
      if (lookahead == 'o') ADVANCE(100);
      if (lookahead == 's') ADVANCE(728);
      END_STATE();
    case 62:
      if (lookahead == 'a') ADVANCE(92);
      if (lookahead == 'u') ADVANCE(111);
      END_STATE();
    case 63:
      if (lookahead == 'a') ADVANCE(263);
      if (lookahead == 'r') ADVANCE(170);
      END_STATE();
    case 64:
      if (lookahead == 'a') ADVANCE(282);
      if (lookahead == 'l') ADVANCE(283);
      if (lookahead == 'n') ADVANCE(99);
      if (lookahead == 'x') ADVANCE(252);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('b' <= lookahead && lookahead <= 'f')) ADVANCE(332);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(196);
      if (lookahead == 'l') ADVANCE(232);
      if (lookahead == 'o') ADVANCE(253);
      if (lookahead == 'r') ADVANCE(238);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('b' <= lookahead && lookahead <= 'f')) ADVANCE(332);
      END_STATE();
    case 66:
      if (lookahead == 'a') ADVANCE(147);
      if (lookahead == 'p') ADVANCE(247);
      END_STATE();
    case 67:
      if (lookahead == 'a') ADVANCE(326);
      if (lookahead == 'e') ADVANCE(127);
      END_STATE();
    case 68:
      if (lookahead == 'a') ADVANCE(101);
      END_STATE();
    case 69:
      if (lookahead == 'a') ADVANCE(101);
      if (lookahead == 'e') ADVANCE(102);
      if (lookahead == 'g') ADVANCE(89);
      if (lookahead == 'o') ADVANCE(235);
      END_STATE();
    case 70:
      if (lookahead == 'a') ADVANCE(268);
      if (lookahead == 'e') ADVANCE(260);
      if (lookahead == 'h') ADVANCE(328);
      if (lookahead == 'o') ADVANCE(322);
      if (lookahead == 'r') ADVANCE(234);
      if (lookahead == 'x') ADVANCE(726);
      END_STATE();
    case 71:
      if (lookahead == 'a') ADVANCE(205);
      if (lookahead == 'r') ADVANCE(77);
      END_STATE();
    case 72:
      if (lookahead == 'a') ADVANCE(305);
      END_STATE();
    case 73:
      if (lookahead == 'a') ADVANCE(206);
      END_STATE();
    case 74:
      if (lookahead == 'a') ADVANCE(288);
      if (lookahead == 'o') ADVANCE(255);
      END_STATE();
    case 75:
      if (lookahead == 'a') ADVANCE(104);
      END_STATE();
    case 76:
      if (lookahead == 'a') ADVANCE(105);
      END_STATE();
    case 77:
      if (lookahead == 'a') ADVANCE(217);
      if (lookahead == 'u') ADVANCE(114);
      END_STATE();
    case 78:
      if (lookahead == 'a') ADVANCE(184);
      END_STATE();
    case 79:
      if (lookahead == 'a') ADVANCE(256);
      END_STATE();
    case 80:
      if (lookahead == 'a') ADVANCE(307);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(185);
      END_STATE();
    case 82:
      if (lookahead == 'a') ADVANCE(199);
      END_STATE();
    case 83:
      if (lookahead == 'a') ADVANCE(93);
      END_STATE();
    case 84:
      if (lookahead == 'a') ADVANCE(149);
      END_STATE();
    case 85:
      if (lookahead == 'a') ADVANCE(107);
      END_STATE();
    case 86:
      if (lookahead == 'a') ADVANCE(270);
      END_STATE();
    case 87:
      if (lookahead == 'b') ADVANCE(274);
      if (lookahead == 'c') ADVANCE(233);
      if (lookahead == 'n') ADVANCE(145);
      if (lookahead == 's') ADVANCE(357);
      if (lookahead == 't') ADVANCE(73);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(332);
      END_STATE();
    case 88:
      if (lookahead == 'b') ADVANCE(713);
      if (lookahead == 'g') ADVANCE(731);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(714);
      END_STATE();
    case 89:
      if (lookahead == 'b') ADVANCE(828);
      END_STATE();
    case 90:
      if (lookahead == 'b') ADVANCE(78);
      END_STATE();
    case 91:
      if (lookahead == 'b') ADVANCE(83);
      END_STATE();
    case 92:
      if (lookahead == 'c') ADVANCE(177);
      END_STATE();
    case 93:
      if (lookahead == 'c') ADVANCE(178);
      END_STATE();
    case 94:
      if (lookahead == 'c') ADVANCE(179);
      END_STATE();
    case 95:
      if (lookahead == 'c') ADVANCE(294);
      END_STATE();
    case 96:
      if (lookahead == 'c') ADVANCE(194);
      END_STATE();
    case 97:
      if (lookahead == 'c') ADVANCE(81);
      END_STATE();
    case 98:
      if (lookahead == 'c') ADVANCE(131);
      END_STATE();
    case 99:
      if (lookahead == 'd') ADVANCE(751);
      END_STATE();
    case 100:
      if (lookahead == 'd') ADVANCE(801);
      END_STATE();
    case 101:
      if (lookahead == 'd') ADVANCE(733);
      END_STATE();
    case 102:
      if (lookahead == 'd') ADVANCE(759);
      END_STATE();
    case 103:
      if (lookahead == 'd') ADVANCE(805);
      END_STATE();
    case 104:
      if (lookahead == 'd') ADVANCE(174);
      END_STATE();
    case 105:
      if (lookahead == 'd') ADVANCE(172);
      END_STATE();
    case 106:
      if (lookahead == 'd') ADVANCE(269);
      END_STATE();
    case 107:
      if (lookahead == 'd') ADVANCE(175);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(88);
      if (lookahead == 'u') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(332);
      END_STATE();
    case 109:
      if (lookahead == 'e') ADVANCE(215);
      if (lookahead == 'i') ADVANCE(216);
      if (lookahead == 'o') ADVANCE(141);
      END_STATE();
    case 110:
      if (lookahead == 'e') ADVANCE(192);
      END_STATE();
    case 111:
      if (lookahead == 'e') ADVANCE(755);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(735);
      if (lookahead == 'i') ADVANCE(218);
      END_STATE();
    case 113:
      if (lookahead == 'e') ADVANCE(401);
      END_STATE();
    case 114:
      if (lookahead == 'e') ADVANCE(417);
      END_STATE();
    case 115:
      if (lookahead == 'e') ADVANCE(769);
      END_STATE();
    case 116:
      if (lookahead == 'e') ADVANCE(419);
      END_STATE();
    case 117:
      if (lookahead == 'e') ADVANCE(779);
      END_STATE();
    case 118:
      if (lookahead == 'e') ADVANCE(763);
      END_STATE();
    case 119:
      if (lookahead == 'e') ADVANCE(444);
      END_STATE();
    case 120:
      if (lookahead == 'e') ADVANCE(382);
      if (lookahead == 'i') ADVANCE(243);
      END_STATE();
    case 121:
      if (lookahead == 'e') ADVANCE(140);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(332);
      END_STATE();
    case 122:
      if (lookahead == 'e') ADVANCE(45);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(79);
      END_STATE();
    case 124:
      if (lookahead == 'e') ADVANCE(277);
      END_STATE();
    case 125:
      if (lookahead == 'e') ADVANCE(207);
      END_STATE();
    case 126:
      if (lookahead == 'e') ADVANCE(207);
      if (lookahead == 'i') ADVANCE(312);
      END_STATE();
    case 127:
      if (lookahead == 'e') ADVANCE(208);
      END_STATE();
    case 128:
      if (lookahead == 'e') ADVANCE(262);
      END_STATE();
    case 129:
      if (lookahead == 'e') ADVANCE(223);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(211);
      END_STATE();
    case 131:
      if (lookahead == 'e') ADVANCE(224);
      END_STATE();
    case 132:
      if (lookahead == 'e') ADVANCE(267);
      END_STATE();
    case 133:
      if (lookahead == 'e') ADVANCE(225);
      END_STATE();
    case 134:
      if (lookahead == 'e') ADVANCE(226);
      END_STATE();
    case 135:
      if (lookahead == 'e') ADVANCE(227);
      END_STATE();
    case 136:
      if (lookahead == 'e') ADVANCE(228);
      END_STATE();
    case 137:
      if (lookahead == 'e') ADVANCE(229);
      END_STATE();
    case 138:
      if (lookahead == 'e') ADVANCE(230);
      END_STATE();
    case 139:
      if (lookahead == 'f') ADVANCE(368);
      if (lookahead == 'm') ADVANCE(66);
      if (lookahead == 'n') ADVANCE(375);
      END_STATE();
    case 140:
      if (lookahead == 'g') ADVANCE(731);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(714);
      END_STATE();
    case 141:
      if (lookahead == 'g') ADVANCE(826);
      END_STATE();
    case 142:
      if (lookahead == 'g') ADVANCE(793);
      END_STATE();
    case 143:
      if (lookahead == 'g') ADVANCE(830);
      END_STATE();
    case 144:
      if (lookahead == 'g') ADVANCE(791);
      END_STATE();
    case 145:
      if (lookahead == 'g') ADVANCE(191);
      if (lookahead == 'i') ADVANCE(202);
      END_STATE();
    case 146:
      if (lookahead == 'g') ADVANCE(304);
      END_STATE();
    case 147:
      if (lookahead == 'g') ADVANCE(117);
      END_STATE();
    case 148:
      if (lookahead == 'g') ADVANCE(261);
      END_STATE();
    case 149:
      if (lookahead == 'g') ADVANCE(122);
      END_STATE();
    case 150:
      if (lookahead == 'g') ADVANCE(308);
      END_STATE();
    case 151:
      if (lookahead == 'g') ADVANCE(310);
      END_STATE();
    case 152:
      if (lookahead == 'g') ADVANCE(271);
      END_STATE();
    case 153:
      if (lookahead == 'h') ADVANCE(165);
      END_STATE();
    case 154:
      if (lookahead == 'h') ADVANCE(126);
      END_STATE();
    case 155:
      if (lookahead == 'h') ADVANCE(773);
      END_STATE();
    case 156:
      if (lookahead == 'h') ADVANCE(783);
      END_STATE();
    case 157:
      if (lookahead == 'h') ADVANCE(787);
      END_STATE();
    case 158:
      if (lookahead == 'h') ADVANCE(789);
      END_STATE();
    case 159:
      if (lookahead == 'h') ADVANCE(128);
      END_STATE();
    case 160:
      if (lookahead == 'h') ADVANCE(125);
      END_STATE();
    case 161:
      if (lookahead == 'i') ADVANCE(216);
      END_STATE();
    case 162:
      if (lookahead == 'i') ADVANCE(204);
      if (lookahead == 'q') ADVANCE(259);
      if (lookahead == 't') ADVANCE(63);
      END_STATE();
    case 163:
      if (lookahead == 'i') ADVANCE(183);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(714);
      END_STATE();
    case 164:
      if (lookahead == 'i') ADVANCE(97);
      END_STATE();
    case 165:
      if (lookahead == 'i') ADVANCE(189);
      END_STATE();
    case 166:
      if (lookahead == 'i') ADVANCE(242);
      END_STATE();
    case 167:
      if (lookahead == 'i') ADVANCE(209);
      if (lookahead == 'o') ADVANCE(318);
      END_STATE();
    case 168:
      if (lookahead == 'i') ADVANCE(210);
      if (lookahead == 'o') ADVANCE(319);
      END_STATE();
    case 169:
      if (lookahead == 'i') ADVANCE(311);
      END_STATE();
    case 170:
      if (lookahead == 'i') ADVANCE(220);
      if (lookahead == 'u') ADVANCE(95);
      END_STATE();
    case 171:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 172:
      if (lookahead == 'i') ADVANCE(82);
      END_STATE();
    case 173:
      if (lookahead == 'i') ADVANCE(244);
      END_STATE();
    case 174:
      if (lookahead == 'i') ADVANCE(135);
      END_STATE();
    case 175:
      if (lookahead == 'i') ADVANCE(136);
      END_STATE();
    case 176:
      if (lookahead == 'i') ADVANCE(313);
      if (lookahead == 'p') ADVANCE(86);
      END_STATE();
    case 177:
      if (lookahead == 'k') ADVANCE(753);
      END_STATE();
    case 178:
      if (lookahead == 'k') ADVANCE(387);
      END_STATE();
    case 179:
      if (lookahead == 'k') ADVANCE(795);
      END_STATE();
    case 180:
      if (lookahead == 'l') ADVANCE(62);
      if (lookahead == 'o') ADVANCE(239);
      if (lookahead == 'r') ADVANCE(315);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(332);
      END_STATE();
    case 181:
      if (lookahead == 'l') ADVANCE(283);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(332);
      END_STATE();
    case 182:
      if (lookahead == 'l') ADVANCE(771);
      END_STATE();
    case 183:
      if (lookahead == 'l') ADVANCE(807);
      END_STATE();
    case 184:
      if (lookahead == 'l') ADVANCE(358);
      END_STATE();
    case 185:
      if (lookahead == 'l') ADVANCE(48);
      END_STATE();
    case 186:
      if (lookahead == 'l') ADVANCE(445);
      END_STATE();
    case 187:
      if (lookahead == 'l') ADVANCE(237);
      if (lookahead == 'r') ADVANCE(67);
      END_STATE();
    case 188:
      if (lookahead == 'l') ADVANCE(197);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(714);
      END_STATE();
    case 189:
      if (lookahead == 'l') ADVANCE(106);
      END_STATE();
    case 190:
      if (lookahead == 'l') ADVANCE(240);
      if (lookahead == 'm') ADVANCE(250);
      if (lookahead == 's') ADVANCE(813);
      END_STATE();
    case 191:
      if (lookahead == 'l') ADVANCE(115);
      END_STATE();
    case 192:
      if (lookahead == 'l') ADVANCE(193);
      END_STATE();
    case 193:
      if (lookahead == 'l') ADVANCE(236);
      END_STATE();
    case 194:
      if (lookahead == 'l') ADVANCE(119);
      END_STATE();
    case 195:
      if (lookahead == 'l') ADVANCE(137);
      END_STATE();
    case 196:
      if (lookahead == 'l') ADVANCE(284);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(714);
      END_STATE();
    case 197:
      if (lookahead == 'l') ADVANCE(91);
      END_STATE();
    case 198:
      if (lookahead == 'l') ADVANCE(138);
      END_STATE();
    case 199:
      if (lookahead == 'l') ADVANCE(49);
      END_STATE();
    case 200:
      if (lookahead == 'm') ADVANCE(362);
      END_STATE();
    case 201:
      if (lookahead == 'm') ADVANCE(84);
      if (lookahead == 'n') ADVANCE(159);
      END_STATE();
    case 202:
      if (lookahead == 'm') ADVANCE(80);
      END_STATE();
    case 203:
      if (lookahead == 'n') ADVANCE(797);
      END_STATE();
    case 204:
      if (lookahead == 'n') ADVANCE(811);
      END_STATE();
    case 205:
      if (lookahead == 'n') ADVANCE(815);
      END_STATE();
    case 206:
      if (lookahead == 'n') ADVANCE(820);
      END_STATE();
    case 207:
      if (lookahead == 'n') ADVANCE(403);
      END_STATE();
    case 208:
      if (lookahead == 'n') ADVANCE(757);
      END_STATE();
    case 209:
      if (lookahead == 'n') ADVANCE(738);
      END_STATE();
    case 210:
      if (lookahead == 'n') ADVANCE(740);
      END_STATE();
    case 211:
      if (lookahead == 'n') ADVANCE(441);
      END_STATE();
    case 212:
      if (lookahead == 'n') ADVANCE(832);
      END_STATE();
    case 213:
      if (lookahead == 'n') ADVANCE(374);
      END_STATE();
    case 214:
      if (lookahead == 'n') ADVANCE(47);
      END_STATE();
    case 215:
      if (lookahead == 'n') ADVANCE(146);
      END_STATE();
    case 216:
      if (lookahead == 'n') ADVANCE(123);
      END_STATE();
    case 217:
      if (lookahead == 'n') ADVANCE(276);
      END_STATE();
    case 218:
      if (lookahead == 'n') ADVANCE(143);
      END_STATE();
    case 219:
      if (lookahead == 'n') ADVANCE(103);
      END_STATE();
    case 220:
      if (lookahead == 'n') ADVANCE(144);
      END_STATE();
    case 221:
      if (lookahead == 'n') ADVANCE(278);
      END_STATE();
    case 222:
      if (lookahead == 'n') ADVANCE(159);
      END_STATE();
    case 223:
      if (lookahead == 'n') ADVANCE(293);
      END_STATE();
    case 224:
      if (lookahead == 'n') ADVANCE(295);
      END_STATE();
    case 225:
      if (lookahead == 'n') ADVANCE(298);
      END_STATE();
    case 226:
      if (lookahead == 'n') ADVANCE(301);
      END_STATE();
    case 227:
      if (lookahead == 'n') ADVANCE(302);
      END_STATE();
    case 228:
      if (lookahead == 'n') ADVANCE(303);
      END_STATE();
    case 229:
      if (lookahead == 'n') ADVANCE(150);
      END_STATE();
    case 230:
      if (lookahead == 'n') ADVANCE(151);
      END_STATE();
    case 231:
      if (lookahead == 'n') ADVANCE(133);
      END_STATE();
    case 232:
      if (lookahead == 'o') ADVANCE(74);
      END_STATE();
    case 233:
      if (lookahead == 'o') ADVANCE(275);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(714);
      END_STATE();
    case 234:
      if (lookahead == 'o') ADVANCE(251);
      END_STATE();
    case 235:
      if (lookahead == 'o') ADVANCE(286);
      if (lookahead == 'u') ADVANCE(219);
      END_STATE();
    case 236:
      if (lookahead == 'o') ADVANCE(323);
      END_STATE();
    case 237:
      if (lookahead == 'o') ADVANCE(90);
      END_STATE();
    case 238:
      if (lookahead == 'o') ADVANCE(200);
      END_STATE();
    case 239:
      if (lookahead == 'o') ADVANCE(182);
      END_STATE();
    case 240:
      if (lookahead == 'o') ADVANCE(254);
      END_STATE();
    case 241:
      if (lookahead == 'o') ADVANCE(264);
      END_STATE();
    case 242:
      if (lookahead == 'o') ADVANCE(212);
      END_STATE();
    case 243:
      if (lookahead == 'o') ADVANCE(214);
      END_STATE();
    case 244:
      if (lookahead == 'o') ADVANCE(221);
      END_STATE();
    case 245:
      if (lookahead == 'o') ADVANCE(317);
      END_STATE();
    case 246:
      if (lookahead == 'o') ADVANCE(231);
      END_STATE();
    case 247:
      if (lookahead == 'o') ADVANCE(265);
      END_STATE();
    case 248:
      if (lookahead == 'o') ADVANCE(320);
      END_STATE();
    case 249:
      if (lookahead == 'o') ADVANCE(321);
      END_STATE();
    case 250:
      if (lookahead == 'p') ADVANCE(246);
      END_STATE();
    case 251:
      if (lookahead == 'p') ADVANCE(132);
      END_STATE();
    case 252:
      if (lookahead == 'p') ADVANCE(241);
      END_STATE();
    case 253:
      if (lookahead == 'r') ADVANCE(385);
      END_STATE();
    case 254:
      if (lookahead == 'r') ADVANCE(775);
      END_STATE();
    case 255:
      if (lookahead == 'r') ADVANCE(809);
      END_STATE();
    case 256:
      if (lookahead == 'r') ADVANCE(46);
      END_STATE();
    case 257:
      if (lookahead == 'r') ADVANCE(72);
      END_STATE();
    case 258:
      if (lookahead == 'r') ADVANCE(96);
      END_STATE();
    case 259:
      if (lookahead == 'r') ADVANCE(287);
      END_STATE();
    case 260:
      if (lookahead == 'r') ADVANCE(98);
      END_STATE();
    case 261:
      if (lookahead == 'r') ADVANCE(75);
      END_STATE();
    case 262:
      if (lookahead == 'r') ADVANCE(169);
      END_STATE();
    case 263:
      if (lookahead == 'r') ADVANCE(289);
      if (lookahead == 't') ADVANCE(124);
      END_STATE();
    case 264:
      if (lookahead == 'r') ADVANCE(290);
      END_STATE();
    case 265:
      if (lookahead == 'r') ADVANCE(291);
      END_STATE();
    case 266:
      if (lookahead == 'r') ADVANCE(186);
      END_STATE();
    case 267:
      if (lookahead == 'r') ADVANCE(306);
      END_STATE();
    case 268:
      if (lookahead == 'r') ADVANCE(129);
      END_STATE();
    case 269:
      if (lookahead == 'r') ADVANCE(130);
      END_STATE();
    case 270:
      if (lookahead == 'r') ADVANCE(134);
      END_STATE();
    case 271:
      if (lookahead == 'r') ADVANCE(85);
      END_STATE();
    case 272:
      if (lookahead == 's') ADVANCE(357);
      END_STATE();
    case 273:
      if (lookahead == 's') ADVANCE(728);
      END_STATE();
    case 274:
      if (lookahead == 's') ADVANCE(803);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(714);
      END_STATE();
    case 275:
      if (lookahead == 's') ADVANCE(818);
      END_STATE();
    case 276:
      if (lookahead == 's') ADVANCE(176);
      END_STATE();
    case 277:
      if (lookahead == 's') ADVANCE(380);
      END_STATE();
    case 278:
      if (lookahead == 's') ADVANCE(371);
      END_STATE();
    case 279:
      if (lookahead == 's') ADVANCE(367);
      END_STATE();
    case 280:
      if (lookahead == 's') ADVANCE(155);
      END_STATE();
    case 281:
      if (lookahead == 's') ADVANCE(164);
      END_STATE();
    case 282:
      if (lookahead == 's') ADVANCE(112);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(714);
      END_STATE();
    case 283:
      if (lookahead == 's') ADVANCE(113);
      END_STATE();
    case 284:
      if (lookahead == 's') ADVANCE(116);
      END_STATE();
    case 285:
      if (lookahead == 't') ADVANCE(377);
      END_STATE();
    case 286:
      if (lookahead == 't') ADVANCE(836);
      END_STATE();
    case 287:
      if (lookahead == 't') ADVANCE(822);
      END_STATE();
    case 288:
      if (lookahead == 't') ADVANCE(777);
      END_STATE();
    case 289:
      if (lookahead == 't') ADVANCE(749);
      END_STATE();
    case 290:
      if (lookahead == 't') ADVANCE(348);
      END_STATE();
    case 291:
      if (lookahead == 't') ADVANCE(360);
      END_STATE();
    case 292:
      if (lookahead == 't') ADVANCE(394);
      END_STATE();
    case 293:
      if (lookahead == 't') ADVANCE(834);
      END_STATE();
    case 294:
      if (lookahead == 't') ADVANCE(350);
      END_STATE();
    case 295:
      if (lookahead == 't') ADVANCE(785);
      END_STATE();
    case 296:
      if (lookahead == 't') ADVANCE(747);
      END_STATE();
    case 297:
      if (lookahead == 't') ADVANCE(745);
      END_STATE();
    case 298:
      if (lookahead == 't') ADVANCE(364);
      END_STATE();
    case 299:
      if (lookahead == 't') ADVANCE(743);
      END_STATE();
    case 300:
      if (lookahead == 't') ADVANCE(741);
      END_STATE();
    case 301:
      if (lookahead == 't') ADVANCE(767);
      END_STATE();
    case 302:
      if (lookahead == 't') ADVANCE(442);
      END_STATE();
    case 303:
      if (lookahead == 't') ADVANCE(443);
      END_STATE();
    case 304:
      if (lookahead == 't') ADVANCE(156);
      END_STATE();
    case 305:
      if (lookahead == 't') ADVANCE(166);
      END_STATE();
    case 306:
      if (lookahead == 't') ADVANCE(327);
      END_STATE();
    case 307:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 308:
      if (lookahead == 't') ADVANCE(157);
      END_STATE();
    case 309:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 310:
      if (lookahead == 't') ADVANCE(158);
      END_STATE();
    case 311:
      if (lookahead == 't') ADVANCE(279);
      END_STATE();
    case 312:
      if (lookahead == 't') ADVANCE(118);
      END_STATE();
    case 313:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 314:
      if (lookahead == 'u') ADVANCE(285);
      END_STATE();
    case 315:
      if (lookahead == 'u') ADVANCE(280);
      END_STATE();
    case 316:
      if (lookahead == 'u') ADVANCE(266);
      END_STATE();
    case 317:
      if (lookahead == 'u') ADVANCE(292);
      END_STATE();
    case 318:
      if (lookahead == 'u') ADVANCE(296);
      END_STATE();
    case 319:
      if (lookahead == 'u') ADVANCE(297);
      END_STATE();
    case 320:
      if (lookahead == 'u') ADVANCE(299);
      END_STATE();
    case 321:
      if (lookahead == 'u') ADVANCE(300);
      END_STATE();
    case 322:
      if (lookahead == 'w') ADVANCE(824);
      END_STATE();
    case 323:
      if (lookahead == 'w') ADVANCE(761);
      END_STATE();
    case 324:
      if (lookahead == 'x') ADVANCE(726);
      END_STATE();
    case 325:
      if (lookahead == 'x') ADVANCE(799);
      END_STATE();
    case 326:
      if (lookahead == 'y') ADVANCE(765);
      END_STATE();
    case 327:
      if (lookahead == 'y') ADVANCE(396);
      END_STATE();
    case 328:
      if (lookahead == 'y') ADVANCE(281);
      END_STATE();
    case 329:
      if (lookahead == '{') ADVANCE(336);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(340);
      END_STATE();
    case 330:
      if (lookahead == '}') ADVANCE(460);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(330);
      END_STATE();
    case 331:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(725);
      END_STATE();
    case 332:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(714);
      END_STATE();
    case 333:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(716);
      END_STATE();
    case 334:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(717);
      END_STATE();
    case 335:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(460);
      END_STATE();
    case 336:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(330);
      END_STATE();
    case 337:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(332);
      END_STATE();
    case 338:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(333);
      END_STATE();
    case 339:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(335);
      END_STATE();
    case 340:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(339);
      END_STATE();
    case 341:
      if (lookahead != 0 &&
          lookahead != '\r') ADVANCE(839);
      if (lookahead == '\r') ADVANCE(840);
      END_STATE();
    case 342:
      if (eof) ADVANCE(347);
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 343:
      if (eof) ADVANCE(347);
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(342)
      END_STATE();
    case 344:
      if (eof) ADVANCE(347);
      if (lookahead == '\n') SKIP(346)
      END_STATE();
    case 345:
      if (eof) ADVANCE(347);
      if (lookahead == '\n') SKIP(346)
      if (lookahead == '\r') SKIP(344)
      END_STATE();
    case 346:
      if (eof) ADVANCE(347);
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '%') ADVANCE(55);
      if (lookahead == '&') ADVANCE(428);
      if (lookahead == '(') ADVANCE(391);
      if (lookahead == ')') ADVANCE(392);
      if (lookahead == '*') ADVANCE(384);
      if (lookahead == '+') ADVANCE(438);
      if (lookahead == ',') ADVANCE(355);
      if (lookahead == '-') ADVANCE(422);
      if (lookahead == '.') ADVANCE(416);
      if (lookahead == '/') ADVANCE(439);
      if (lookahead == ':') ADVANCE(353);
      if (lookahead == ';') ADVANCE(363);
      if (lookahead == '<') ADVANCE(399);
      if (lookahead == '=') ADVANCE(405);
      if (lookahead == '>') ADVANCE(400);
      if (lookahead == '?') ADVANCE(440);
      if (lookahead == '[') ADVANCE(373);
      if (lookahead == '\\') SKIP(345)
      if (lookahead == ']') ADVANCE(379);
      if (lookahead == '^') ADVANCE(430);
      if (lookahead == 'a') ADVANCE(498);
      if (lookahead == 'b') ADVANCE(578);
      if (lookahead == 'c') ADVANCE(529);
      if (lookahead == 'd') ADVANCE(516);
      if (lookahead == 'e') ADVANCE(468);
      if (lookahead == 'f') ADVANCE(583);
      if (lookahead == 'g') ADVANCE(585);
      if (lookahead == 'i') ADVANCE(541);
      if (lookahead == 'l') ADVANCE(517);
      if (lookahead == 'm') ADVANCE(464);
      if (lookahead == 'p') ADVANCE(472);
      if (lookahead == 'r') ADVANCE(531);
      if (lookahead == 's') ADVANCE(559);
      if (lookahead == 't') ADVANCE(477);
      if (lookahead == 'w') ADVANCE(558);
      if (lookahead == 'y') ADVANCE(528);
      if (lookahead == '{') ADVANCE(352);
      if (lookahead == '|') ADVANCE(429);
      if (lookahead == '}') ADVANCE(356);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(346)
      if (sym__ident_reg_character_set_2(lookahead)) ADVANCE(710);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_export);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_struct);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(366);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(anon_sym_global);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_import);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(anon_sym_component);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_component);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_inherits);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(anon_sym_if);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(anon_sym_transitions);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(anon_sym_transitions);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == '-') ADVANCE(245);
      if (lookahead == 't') ADVANCE(781);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == '-') ADVANCE(638);
      if (lookahead == 't') ADVANCE(782);
      if (sym__ident_reg_character_set_4(lookahead)) ADVANCE(710);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(anon_sym_out);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(anon_sym_out);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(anon_sym_states);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(anon_sym_states);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(anon_sym_animate);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(anon_sym_animate);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(408);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(anon_sym_for);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(anon_sym_callback);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(anon_sym_callback);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(anon_sym_LT_EQ_GT);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(anon_sym_in_DASHout);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(anon_sym_in_DASHout);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(anon_sym_property);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(anon_sym_property);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(436);
      if (lookahead == '=') ADVANCE(434);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(436);
      if (lookahead == '=') ADVANCE(433);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(435);
      if (lookahead == '>') ADVANCE(437);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(anon_sym_else);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(anon_sym_when);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(431);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(431);
      if (lookahead == '>') ADVANCE(393);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(anon_sym_true);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(anon_sym_false);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(407);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(407);
      if (lookahead == '>') ADVANCE(389);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(432);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(426);
      if (lookahead == '=') ADVANCE(411);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(412);
      if (lookahead == '|') ADVANCE(427);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(413);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '>') ADVANCE(390);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(414);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(415);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(406);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(44);
      if (lookahead == '/') ADVANCE(839);
      if (lookahead == '=') ADVANCE(409);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(sym_children_macro);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(anon_sym_linear_DASHgradient);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(anon_sym_radial_DASHgradient);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(anon_sym_circle);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(anon_sym_image_DASHurl);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(sym__unescaped_double_string_fragment);
      if (lookahead == '\n') ADVANCE(453);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(448);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(sym__unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(451);
      if (lookahead == '/') ADVANCE(448);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(453);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(sym__unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(450);
      if (lookahead == '/') ADVANCE(453);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(451);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(sym__unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(450);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(451);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(sym__unescaped_double_string_fragment);
      if (lookahead == '/') ADVANCE(449);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(452);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(453);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(sym__unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(453);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(sym__unescaped_single_string_fragment);
      if (lookahead == '\n') ADVANCE(459);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(454);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(sym__unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(457);
      if (lookahead == '/') ADVANCE(454);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(459);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(sym__unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(456);
      if (lookahead == '/') ADVANCE(459);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(457);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(sym__unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(456);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(457);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(sym__unescaped_single_string_fragment);
      if (lookahead == '/') ADVANCE(455);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(458);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(459);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(sym__unescaped_single_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(459);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == '-') ADVANCE(693);
      if (sym__ident_reg_character_set_4(lookahead)) ADVANCE(710);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == '-') ADVANCE(589);
      if (lookahead == '_') ADVANCE(594);
      if (sym__ident_reg_character_set_5(lookahead)) ADVANCE(710);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(706);
      if (lookahead == 'i') ADVANCE(598);
      if (lookahead == 'o') ADVANCE(512);
      if (lookahead == 's') ADVANCE(729);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(706);
      if (lookahead == 'i') ADVANCE(598);
      if (lookahead == 'o') ADVANCE(512);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(505);
      if (lookahead == 'u') ADVANCE(518);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(650);
      if (lookahead == 'r') ADVANCE(571);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(658);
      if (lookahead == 'l') ADVANCE(667);
      if (lookahead == 'n') ADVANCE(511);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(658);
      if (lookahead == 'n') ADVANCE(511);
      if (lookahead == 'x') ADVANCE(642);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(658);
      if (lookahead == 'n') ADVANCE(511);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(655);
      if (lookahead == 'e') ADVANCE(648);
      if (lookahead == 'h') ADVANCE(709);
      if (lookahead == 'o') ADVANCE(704);
      if (lookahead == 'r') ADVANCE(627);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(655);
      if (lookahead == 'e') ADVANCE(648);
      if (lookahead == 'h') ADVANCE(709);
      if (lookahead == 'o') ADVANCE(704);
      if (lookahead == 'x') ADVANCE(727);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(655);
      if (lookahead == 'e') ADVANCE(648);
      if (lookahead == 'h') ADVANCE(709);
      if (lookahead == 'o') ADVANCE(704);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(550);
      if (lookahead == 'p') ADVANCE(636);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(550);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(707);
      if (lookahead == 'e') ADVANCE(533);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(600);
      if (lookahead == 'r') ADVANCE(489);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(600);
      if (lookahead == 'r') ADVANCE(490);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(600);
      if (lookahead == 'r') ADVANCE(493);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(651);
      if (lookahead == 'r') ADVANCE(570);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(651);
      if (lookahead == 'r') ADVANCE(571);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(515);
      if (lookahead == 'e') ADVANCE(513);
      if (lookahead == 'g') ADVANCE(500);
      if (lookahead == 'o') ADVANCE(623);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(691);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(581);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(671);
      if (lookahead == 'o') ADVANCE(645);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(602);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(582);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(590);
      if (lookahead == 'l') ADVANCE(622);
      if (lookahead == 'o') ADVANCE(646);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(590);
      if (lookahead == 'l') ADVANCE(622);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(611);
      if (lookahead == 'u') ADVANCE(523);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(611);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(592);
      if (lookahead == 'e') ADVANCE(564);
      if (lookahead == 'o') ADVANCE(587);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(592);
      if (lookahead == 'e') ADVANCE(564);
      if (lookahead == 'o') ADVANCE(588);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(613);
      if (lookahead == 'u') ADVANCE(523);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(686);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(507);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(656);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'a') ADVANCE(694);
      if (sym__ident_reg_character_set_6(lookahead)) ADVANCE(710);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'b') ADVANCE(657);
      if (lookahead == 'c') ADVANCE(625);
      if (lookahead == 'n') ADVANCE(548);
      if (lookahead == 's') ADVANCE(565);
      if (lookahead == 't') ADVANCE(485);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'b') ADVANCE(657);
      if (lookahead == 'c') ADVANCE(625);
      if (lookahead == 'n') ADVANCE(549);
      if (lookahead == 's') ADVANCE(565);
      if (lookahead == 't') ADVANCE(485);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'b') ADVANCE(829);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'b') ADVANCE(697);
      if (lookahead == 'g') ADVANCE(732);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'b') ADVANCE(697);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'b') ADVANCE(483);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'b') ADVANCE(495);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'c') ADVANCE(575);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'c') ADVANCE(576);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'c') ADVANCE(577);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'c') ADVANCE(676);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'c') ADVANCE(486);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'c') ADVANCE(535);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'd') ADVANCE(752);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'd') ADVANCE(802);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'd') ADVANCE(760);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'd') ADVANCE(806);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'd') ADVANCE(734);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(502);
      if (lookahead == 'u') ADVANCE(647);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(608);
      if (lookahead == 'o') ADVANCE(544);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(756);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(736);
      if (lookahead == 'i') ADVANCE(610);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(770);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(780);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(764);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(418);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(420);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(383);
      if (lookahead == 'i') ADVANCE(632);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(501);
      if (lookahead == 'u') ADVANCE(647);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(402);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(593);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(564);
      if (lookahead == 'o') ADVANCE(587);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(564);
      if (lookahead == 'o') ADVANCE(588);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(513);
      if (lookahead == 'g') ADVANCE(500);
      if (lookahead == 'o') ADVANCE(623);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(661);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(603);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(615);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(616);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(617);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(654);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(618);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(619);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'e') ADVANCE(620);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'f') ADVANCE(369);
      if (lookahead == 'm') ADVANCE(473);
      if (lookahead == 'n') ADVANCE(668);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'f') ADVANCE(369);
      if (lookahead == 'm') ADVANCE(474);
      if (lookahead == 'n') ADVANCE(668);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'f') ADVANCE(369);
      if (lookahead == 'm') ADVANCE(474);
      if (lookahead == 'n') ADVANCE(376);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'g') ADVANCE(827);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'g') ADVANCE(794);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'g') ADVANCE(831);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'g') ADVANCE(792);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'g') ADVANCE(584);
      if (lookahead == 'i') ADVANCE(597);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'g') ADVANCE(584);
      if (lookahead == 'i') ADVANCE(596);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'g') ADVANCE(521);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'g') ADVANCE(687);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'g') ADVANCE(689);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'g') ADVANCE(690);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'h') ADVANCE(774);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'h') ADVANCE(784);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'h') ADVANCE(788);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'h') ADVANCE(790);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'h') ADVANCE(562);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 559:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'i') ADVANCE(599);
      if (lookahead == 'q') ADVANCE(649);
      if (lookahead == 't') ADVANCE(479);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 560:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'i') ADVANCE(599);
      if (lookahead == 'q') ADVANCE(649);
      if (lookahead == 't') ADVANCE(480);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 561:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'i') ADVANCE(599);
      if (lookahead == 'q') ADVANCE(649);
      if (lookahead == 't') ADVANCE(466);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'i') ADVANCE(692);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 563:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'i') ADVANCE(509);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'i') ADVANCE(580);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 565:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'i') ADVANCE(601);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 566:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'i') ADVANCE(604);
      if (lookahead == 'o') ADVANCE(698);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'i') ADVANCE(605);
      if (lookahead == 'o') ADVANCE(699);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'i') ADVANCE(506);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'i') ADVANCE(631);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'i') ADVANCE(612);
      if (lookahead == 'u') ADVANCE(508);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'i') ADVANCE(612);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'i') ADVANCE(632);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'i') ADVANCE(633);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 574:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'i') ADVANCE(695);
      if (lookahead == 'p') ADVANCE(496);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 575:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'k') ADVANCE(754);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 576:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'k') ADVANCE(796);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'k') ADVANCE(388);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 578:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'l') ADVANCE(465);
      if (lookahead == 'o') ADVANCE(628);
      if (lookahead == 'r') ADVANCE(696);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'l') ADVANCE(772);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 580:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'l') ADVANCE(808);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 581:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'l') ADVANCE(359);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'l') ADVANCE(462);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 583:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'l') ADVANCE(622);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 584:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'l') ADVANCE(520);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'l') ADVANCE(626);
      if (lookahead == 'r') ADVANCE(475);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'l') ADVANCE(504);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'l') ADVANCE(629);
      if (lookahead == 'm') ADVANCE(640);
      if (lookahead == 's') ADVANCE(814);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'l') ADVANCE(629);
      if (lookahead == 's') ADVANCE(814);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 589:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'l') ADVANCE(539);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'l') ADVANCE(666);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'l') ADVANCE(624);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 592:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'l') ADVANCE(586);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'l') ADVANCE(591);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 594:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'l') ADVANCE(540);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 595:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'm') ADVANCE(474);
      if (lookahead == 'n') ADVANCE(668);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 596:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'm') ADVANCE(494);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 597:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'm') ADVANCE(497);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 598:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(798);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 599:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(812);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 600:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(816);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 601:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(817);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 602:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(821);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 603:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(758);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 604:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(737);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 605:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(739);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 606:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(833);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 607:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(461);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(551);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 609:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(514);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 610:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(546);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 611:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(664);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 612:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(547);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 613:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(660);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 614:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(662);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 615:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(675);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 616:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(677);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 617:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(680);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 618:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(683);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 619:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(552);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 620:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(553);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 621:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'n') ADVANCE(536);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 622:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'o') ADVANCE(484);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 623:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'o') ADVANCE(669);
      if (lookahead == 'u') ADVANCE(609);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 624:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'o') ADVANCE(705);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 625:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'o') ADVANCE(659);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 626:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'o') ADVANCE(503);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 627:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'o') ADVANCE(641);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 628:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'o') ADVANCE(579);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 629:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'o') ADVANCE(644);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 630:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'o') ADVANCE(621);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 631:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'o') ADVANCE(606);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 632:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'o') ADVANCE(607);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 633:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'o') ADVANCE(614);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 634:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'o') ADVANCE(652);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 635:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'o') ADVANCE(700);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 636:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'o') ADVANCE(653);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 637:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'o') ADVANCE(701);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 638:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'o') ADVANCE(703);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 639:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'p') ADVANCE(496);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 640:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'p') ADVANCE(630);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 641:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'p') ADVANCE(537);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 642:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'p') ADVANCE(634);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 643:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'r') ADVANCE(475);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 644:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'r') ADVANCE(776);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 645:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'r') ADVANCE(810);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 646:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'r') ADVANCE(386);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 647:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'r') ADVANCE(482);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 648:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'r') ADVANCE(510);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 649:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'r') ADVANCE(670);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 650:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'r') ADVANCE(672);
      if (lookahead == 't') ADVANCE(532);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 651:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'r') ADVANCE(672);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 652:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'r') ADVANCE(673);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 653:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'r') ADVANCE(674);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 654:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'r') ADVANCE(688);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 655:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'r') ADVANCE(534);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 656:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'r') ADVANCE(538);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 657:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 's') ADVANCE(804);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 658:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 's') ADVANCE(519);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 659:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 's') ADVANCE(819);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 660:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 's') ADVANCE(574);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 661:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 's') ADVANCE(381);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 662:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 's') ADVANCE(372);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 663:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 's') ADVANCE(554);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 664:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 's') ADVANCE(639);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 665:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 's') ADVANCE(563);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 666:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 's') ADVANCE(524);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 667:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 's') ADVANCE(527);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 668:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(782);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 669:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(837);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 670:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(823);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 671:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(778);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 672:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(750);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 673:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(349);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 674:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(361);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 675:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(835);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 676:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(351);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 677:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(786);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 678:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(748);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 679:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(746);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 680:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(365);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 681:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(744);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 682:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(742);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 683:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(768);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 684:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(378);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 685:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(395);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 686:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(525);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 687:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(555);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 688:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(708);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 689:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(556);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 690:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(557);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 691:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(569);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 692:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(522);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 693:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(568);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 694:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(572);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 695:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 't') ADVANCE(573);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 696:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'u') ADVANCE(663);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 697:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'u') ADVANCE(545);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 698:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'u') ADVANCE(678);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 699:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'u') ADVANCE(679);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 700:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'u') ADVANCE(681);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 701:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'u') ADVANCE(682);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 702:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'u') ADVANCE(684);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 703:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'u') ADVANCE(685);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 704:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'w') ADVANCE(825);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 705:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'w') ADVANCE(762);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 706:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'x') ADVANCE(800);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 707:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'y') ADVANCE(766);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 708:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'y') ADVANCE(397);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 709:
      ACCEPT_TOKEN(sym__ident_reg);
      if (lookahead == 'y') ADVANCE(665);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 710:
      ACCEPT_TOKEN(sym__ident_reg);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 711:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 712:
      ACCEPT_TOKEN(aux_sym_color_literal_token1);
      if (lookahead == '.') ADVANCE(331);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(724);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(338);
      END_STATE();
    case 713:
      ACCEPT_TOKEN(aux_sym_color_literal_token1);
      if (lookahead == 'u') ADVANCE(142);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(338);
      END_STATE();
    case 714:
      ACCEPT_TOKEN(aux_sym_color_literal_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(338);
      END_STATE();
    case 715:
      ACCEPT_TOKEN(aux_sym_color_literal_token2);
      if (lookahead == '.') ADVANCE(331);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(721);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(334);
      END_STATE();
    case 716:
      ACCEPT_TOKEN(aux_sym_color_literal_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(334);
      END_STATE();
    case 717:
      ACCEPT_TOKEN(aux_sym_color_literal_token3);
      END_STATE();
    case 718:
      ACCEPT_TOKEN(aux_sym_color_literal_token3);
      if (lookahead == '.') ADVANCE(331);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(722);
      END_STATE();
    case 719:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(331);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(712);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(714);
      END_STATE();
    case 720:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(331);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(715);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(716);
      END_STATE();
    case 721:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(331);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(718);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(717);
      END_STATE();
    case 722:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(331);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(722);
      END_STATE();
    case 723:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(331);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(719);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(332);
      END_STATE();
    case 724:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '.') ADVANCE(331);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(720);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(333);
      END_STATE();
    case 725:
      ACCEPT_TOKEN(sym_float_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(725);
      END_STATE();
    case 726:
      ACCEPT_TOKEN(anon_sym_px);
      END_STATE();
    case 727:
      ACCEPT_TOKEN(anon_sym_px);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 728:
      ACCEPT_TOKEN(anon_sym_ms);
      END_STATE();
    case 729:
      ACCEPT_TOKEN(anon_sym_ms);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 730:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(410);
      END_STATE();
    case 731:
      ACCEPT_TOKEN(anon_sym_deg);
      END_STATE();
    case 732:
      ACCEPT_TOKEN(anon_sym_deg);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 733:
      ACCEPT_TOKEN(anon_sym_rad);
      END_STATE();
    case 734:
      ACCEPT_TOKEN(anon_sym_rad);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 735:
      ACCEPT_TOKEN(anon_sym_ease);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '_') ADVANCE(168);
      END_STATE();
    case 736:
      ACCEPT_TOKEN(anon_sym_ease);
      if (lookahead == '-') ADVANCE(566);
      if (lookahead == '_') ADVANCE(567);
      if (sym__ident_reg_character_set_5(lookahead)) ADVANCE(710);
      END_STATE();
    case 737:
      ACCEPT_TOKEN(anon_sym_ease_DASHin);
      if (lookahead == '-') ADVANCE(635);
      if (sym__ident_reg_character_set_4(lookahead)) ADVANCE(710);
      END_STATE();
    case 738:
      ACCEPT_TOKEN(anon_sym_ease_DASHin);
      if (lookahead == '-') ADVANCE(248);
      END_STATE();
    case 739:
      ACCEPT_TOKEN(anon_sym_ease_in);
      if (lookahead == '_') ADVANCE(637);
      if (sym__ident_reg_character_set_7(lookahead)) ADVANCE(710);
      END_STATE();
    case 740:
      ACCEPT_TOKEN(anon_sym_ease_in);
      if (lookahead == '_') ADVANCE(249);
      END_STATE();
    case 741:
      ACCEPT_TOKEN(anon_sym_ease_in_out);
      END_STATE();
    case 742:
      ACCEPT_TOKEN(anon_sym_ease_in_out);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 743:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout);
      END_STATE();
    case 744:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 745:
      ACCEPT_TOKEN(anon_sym_ease_out);
      END_STATE();
    case 746:
      ACCEPT_TOKEN(anon_sym_ease_out);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 747:
      ACCEPT_TOKEN(anon_sym_ease_DASHout);
      END_STATE();
    case 748:
      ACCEPT_TOKEN(anon_sym_ease_DASHout);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 749:
      ACCEPT_TOKEN(anon_sym_start);
      END_STATE();
    case 750:
      ACCEPT_TOKEN(anon_sym_start);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 751:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 752:
      ACCEPT_TOKEN(anon_sym_end);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 753:
      ACCEPT_TOKEN(anon_sym_black);
      END_STATE();
    case 754:
      ACCEPT_TOKEN(anon_sym_black);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 755:
      ACCEPT_TOKEN(anon_sym_blue);
      END_STATE();
    case 756:
      ACCEPT_TOKEN(anon_sym_blue);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 757:
      ACCEPT_TOKEN(anon_sym_green);
      END_STATE();
    case 758:
      ACCEPT_TOKEN(anon_sym_green);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 759:
      ACCEPT_TOKEN(anon_sym_red);
      END_STATE();
    case 760:
      ACCEPT_TOKEN(anon_sym_red);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 761:
      ACCEPT_TOKEN(anon_sym_yellow);
      END_STATE();
    case 762:
      ACCEPT_TOKEN(anon_sym_yellow);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 763:
      ACCEPT_TOKEN(anon_sym_white);
      END_STATE();
    case 764:
      ACCEPT_TOKEN(anon_sym_white);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 765:
      ACCEPT_TOKEN(anon_sym_gray);
      END_STATE();
    case 766:
      ACCEPT_TOKEN(anon_sym_gray);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 767:
      ACCEPT_TOKEN(anon_sym_transparent);
      END_STATE();
    case 768:
      ACCEPT_TOKEN(anon_sym_transparent);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 769:
      ACCEPT_TOKEN(anon_sym_angle);
      END_STATE();
    case 770:
      ACCEPT_TOKEN(anon_sym_angle);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 771:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 772:
      ACCEPT_TOKEN(anon_sym_bool);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 773:
      ACCEPT_TOKEN(anon_sym_brush);
      END_STATE();
    case 774:
      ACCEPT_TOKEN(anon_sym_brush);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 775:
      ACCEPT_TOKEN(anon_sym_color);
      END_STATE();
    case 776:
      ACCEPT_TOKEN(anon_sym_color);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 777:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 778:
      ACCEPT_TOKEN(anon_sym_float);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 779:
      ACCEPT_TOKEN(anon_sym_image);
      END_STATE();
    case 780:
      ACCEPT_TOKEN(anon_sym_image);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 781:
      ACCEPT_TOKEN(anon_sym_int);
      END_STATE();
    case 782:
      ACCEPT_TOKEN(anon_sym_int);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 783:
      ACCEPT_TOKEN(anon_sym_length);
      END_STATE();
    case 784:
      ACCEPT_TOKEN(anon_sym_length);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 785:
      ACCEPT_TOKEN(anon_sym_percent);
      END_STATE();
    case 786:
      ACCEPT_TOKEN(anon_sym_percent);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 787:
      ACCEPT_TOKEN(anon_sym_physical_DASHlength);
      END_STATE();
    case 788:
      ACCEPT_TOKEN(anon_sym_physical_DASHlength);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 789:
      ACCEPT_TOKEN(anon_sym_physical_length);
      END_STATE();
    case 790:
      ACCEPT_TOKEN(anon_sym_physical_length);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 791:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 792:
      ACCEPT_TOKEN(anon_sym_string);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 793:
      ACCEPT_TOKEN(anon_sym_debug);
      END_STATE();
    case 794:
      ACCEPT_TOKEN(anon_sym_debug);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 795:
      ACCEPT_TOKEN(anon_sym_animation_DASHtick);
      END_STATE();
    case 796:
      ACCEPT_TOKEN(anon_sym_animation_DASHtick);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 797:
      ACCEPT_TOKEN(anon_sym_min);
      END_STATE();
    case 798:
      ACCEPT_TOKEN(anon_sym_min);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 799:
      ACCEPT_TOKEN(anon_sym_max);
      END_STATE();
    case 800:
      ACCEPT_TOKEN(anon_sym_max);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 801:
      ACCEPT_TOKEN(anon_sym_mod);
      END_STATE();
    case 802:
      ACCEPT_TOKEN(anon_sym_mod);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 803:
      ACCEPT_TOKEN(anon_sym_abs);
      END_STATE();
    case 804:
      ACCEPT_TOKEN(anon_sym_abs);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 805:
      ACCEPT_TOKEN(anon_sym_round);
      END_STATE();
    case 806:
      ACCEPT_TOKEN(anon_sym_round);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 807:
      ACCEPT_TOKEN(anon_sym_ceil);
      END_STATE();
    case 808:
      ACCEPT_TOKEN(anon_sym_ceil);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 809:
      ACCEPT_TOKEN(anon_sym_floor);
      END_STATE();
    case 810:
      ACCEPT_TOKEN(anon_sym_floor);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 811:
      ACCEPT_TOKEN(anon_sym_sin);
      END_STATE();
    case 812:
      ACCEPT_TOKEN(anon_sym_sin);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 813:
      ACCEPT_TOKEN(anon_sym_cos);
      END_STATE();
    case 814:
      ACCEPT_TOKEN(anon_sym_cos);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 815:
      ACCEPT_TOKEN(anon_sym_tan);
      END_STATE();
    case 816:
      ACCEPT_TOKEN(anon_sym_tan);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 817:
      ACCEPT_TOKEN(anon_sym_asin);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 818:
      ACCEPT_TOKEN(anon_sym_acos);
      END_STATE();
    case 819:
      ACCEPT_TOKEN(anon_sym_acos);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 820:
      ACCEPT_TOKEN(anon_sym_atan);
      END_STATE();
    case 821:
      ACCEPT_TOKEN(anon_sym_atan);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 822:
      ACCEPT_TOKEN(anon_sym_sqrt);
      END_STATE();
    case 823:
      ACCEPT_TOKEN(anon_sym_sqrt);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 824:
      ACCEPT_TOKEN(anon_sym_pow);
      END_STATE();
    case 825:
      ACCEPT_TOKEN(anon_sym_pow);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 826:
      ACCEPT_TOKEN(anon_sym_log);
      END_STATE();
    case 827:
      ACCEPT_TOKEN(anon_sym_log);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 828:
      ACCEPT_TOKEN(anon_sym_rgb);
      END_STATE();
    case 829:
      ACCEPT_TOKEN(anon_sym_rgb);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 830:
      ACCEPT_TOKEN(anon_sym_easing);
      END_STATE();
    case 831:
      ACCEPT_TOKEN(anon_sym_easing);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 832:
      ACCEPT_TOKEN(anon_sym_duration);
      END_STATE();
    case 833:
      ACCEPT_TOKEN(anon_sym_duration);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 834:
      ACCEPT_TOKEN(anon_sym_parent);
      END_STATE();
    case 835:
      ACCEPT_TOKEN(anon_sym_parent);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 836:
      ACCEPT_TOKEN(anon_sym_root);
      END_STATE();
    case 837:
      ACCEPT_TOKEN(anon_sym_root);
      if (sym__ident_reg_character_set_3(lookahead)) ADVANCE(710);
      END_STATE();
    case 838:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 839:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(341);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(839);
      END_STATE();
    case 840:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(839);
      if (lookahead == '\\') ADVANCE(341);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 346},
  [2] = {.lex_state = 31},
  [3] = {.lex_state = 33},
  [4] = {.lex_state = 33},
  [5] = {.lex_state = 33},
  [6] = {.lex_state = 31},
  [7] = {.lex_state = 31},
  [8] = {.lex_state = 31},
  [9] = {.lex_state = 31},
  [10] = {.lex_state = 33},
  [11] = {.lex_state = 33},
  [12] = {.lex_state = 33},
  [13] = {.lex_state = 37},
  [14] = {.lex_state = 37},
  [15] = {.lex_state = 37},
  [16] = {.lex_state = 37},
  [17] = {.lex_state = 37},
  [18] = {.lex_state = 37},
  [19] = {.lex_state = 37},
  [20] = {.lex_state = 37},
  [21] = {.lex_state = 37},
  [22] = {.lex_state = 37},
  [23] = {.lex_state = 30},
  [24] = {.lex_state = 31},
  [25] = {.lex_state = 31},
  [26] = {.lex_state = 32},
  [27] = {.lex_state = 31},
  [28] = {.lex_state = 31},
  [29] = {.lex_state = 31},
  [30] = {.lex_state = 31},
  [31] = {.lex_state = 31},
  [32] = {.lex_state = 31},
  [33] = {.lex_state = 31},
  [34] = {.lex_state = 31},
  [35] = {.lex_state = 31},
  [36] = {.lex_state = 32},
  [37] = {.lex_state = 31},
  [38] = {.lex_state = 32},
  [39] = {.lex_state = 31},
  [40] = {.lex_state = 31},
  [41] = {.lex_state = 31},
  [42] = {.lex_state = 31},
  [43] = {.lex_state = 31},
  [44] = {.lex_state = 31},
  [45] = {.lex_state = 31},
  [46] = {.lex_state = 31},
  [47] = {.lex_state = 31},
  [48] = {.lex_state = 31},
  [49] = {.lex_state = 31},
  [50] = {.lex_state = 31},
  [51] = {.lex_state = 31},
  [52] = {.lex_state = 31},
  [53] = {.lex_state = 31},
  [54] = {.lex_state = 31},
  [55] = {.lex_state = 31},
  [56] = {.lex_state = 31},
  [57] = {.lex_state = 31},
  [58] = {.lex_state = 31},
  [59] = {.lex_state = 31},
  [60] = {.lex_state = 31},
  [61] = {.lex_state = 31},
  [62] = {.lex_state = 31},
  [63] = {.lex_state = 31},
  [64] = {.lex_state = 31},
  [65] = {.lex_state = 31},
  [66] = {.lex_state = 31},
  [67] = {.lex_state = 31},
  [68] = {.lex_state = 31},
  [69] = {.lex_state = 31},
  [70] = {.lex_state = 31},
  [71] = {.lex_state = 31},
  [72] = {.lex_state = 31},
  [73] = {.lex_state = 31},
  [74] = {.lex_state = 31},
  [75] = {.lex_state = 31},
  [76] = {.lex_state = 31},
  [77] = {.lex_state = 31},
  [78] = {.lex_state = 31},
  [79] = {.lex_state = 31},
  [80] = {.lex_state = 31},
  [81] = {.lex_state = 31},
  [82] = {.lex_state = 31},
  [83] = {.lex_state = 346},
  [84] = {.lex_state = 346},
  [85] = {.lex_state = 346},
  [86] = {.lex_state = 31},
  [87] = {.lex_state = 31},
  [88] = {.lex_state = 31},
  [89] = {.lex_state = 31},
  [90] = {.lex_state = 31},
  [91] = {.lex_state = 31},
  [92] = {.lex_state = 31},
  [93] = {.lex_state = 31},
  [94] = {.lex_state = 31},
  [95] = {.lex_state = 31},
  [96] = {.lex_state = 31},
  [97] = {.lex_state = 31},
  [98] = {.lex_state = 31},
  [99] = {.lex_state = 31},
  [100] = {.lex_state = 31},
  [101] = {.lex_state = 31},
  [102] = {.lex_state = 31},
  [103] = {.lex_state = 31},
  [104] = {.lex_state = 31},
  [105] = {.lex_state = 31},
  [106] = {.lex_state = 31},
  [107] = {.lex_state = 31},
  [108] = {.lex_state = 31},
  [109] = {.lex_state = 31},
  [110] = {.lex_state = 31},
  [111] = {.lex_state = 31},
  [112] = {.lex_state = 31},
  [113] = {.lex_state = 31},
  [114] = {.lex_state = 31},
  [115] = {.lex_state = 31},
  [116] = {.lex_state = 31},
  [117] = {.lex_state = 31},
  [118] = {.lex_state = 31},
  [119] = {.lex_state = 31},
  [120] = {.lex_state = 31},
  [121] = {.lex_state = 31},
  [122] = {.lex_state = 31},
  [123] = {.lex_state = 31},
  [124] = {.lex_state = 31},
  [125] = {.lex_state = 31},
  [126] = {.lex_state = 31},
  [127] = {.lex_state = 31},
  [128] = {.lex_state = 31},
  [129] = {.lex_state = 31},
  [130] = {.lex_state = 31},
  [131] = {.lex_state = 31},
  [132] = {.lex_state = 31},
  [133] = {.lex_state = 31},
  [134] = {.lex_state = 31},
  [135] = {.lex_state = 31},
  [136] = {.lex_state = 31},
  [137] = {.lex_state = 31},
  [138] = {.lex_state = 31},
  [139] = {.lex_state = 31},
  [140] = {.lex_state = 31},
  [141] = {.lex_state = 31},
  [142] = {.lex_state = 31},
  [143] = {.lex_state = 31},
  [144] = {.lex_state = 31},
  [145] = {.lex_state = 31},
  [146] = {.lex_state = 31},
  [147] = {.lex_state = 31},
  [148] = {.lex_state = 31},
  [149] = {.lex_state = 31},
  [150] = {.lex_state = 31},
  [151] = {.lex_state = 31},
  [152] = {.lex_state = 31},
  [153] = {.lex_state = 31},
  [154] = {.lex_state = 31},
  [155] = {.lex_state = 31},
  [156] = {.lex_state = 31},
  [157] = {.lex_state = 31},
  [158] = {.lex_state = 31},
  [159] = {.lex_state = 31},
  [160] = {.lex_state = 31},
  [161] = {.lex_state = 31},
  [162] = {.lex_state = 31},
  [163] = {.lex_state = 31},
  [164] = {.lex_state = 31},
  [165] = {.lex_state = 31},
  [166] = {.lex_state = 31},
  [167] = {.lex_state = 31},
  [168] = {.lex_state = 31},
  [169] = {.lex_state = 31},
  [170] = {.lex_state = 31},
  [171] = {.lex_state = 31},
  [172] = {.lex_state = 31},
  [173] = {.lex_state = 31},
  [174] = {.lex_state = 31},
  [175] = {.lex_state = 31},
  [176] = {.lex_state = 31},
  [177] = {.lex_state = 31},
  [178] = {.lex_state = 31},
  [179] = {.lex_state = 31},
  [180] = {.lex_state = 31},
  [181] = {.lex_state = 31},
  [182] = {.lex_state = 31},
  [183] = {.lex_state = 31},
  [184] = {.lex_state = 31},
  [185] = {.lex_state = 31},
  [186] = {.lex_state = 31},
  [187] = {.lex_state = 31},
  [188] = {.lex_state = 31},
  [189] = {.lex_state = 31},
  [190] = {.lex_state = 31},
  [191] = {.lex_state = 31},
  [192] = {.lex_state = 33},
  [193] = {.lex_state = 33},
  [194] = {.lex_state = 33},
  [195] = {.lex_state = 33},
  [196] = {.lex_state = 33},
  [197] = {.lex_state = 33},
  [198] = {.lex_state = 33},
  [199] = {.lex_state = 33},
  [200] = {.lex_state = 33},
  [201] = {.lex_state = 33},
  [202] = {.lex_state = 33},
  [203] = {.lex_state = 33},
  [204] = {.lex_state = 33},
  [205] = {.lex_state = 33},
  [206] = {.lex_state = 33},
  [207] = {.lex_state = 33},
  [208] = {.lex_state = 33},
  [209] = {.lex_state = 33},
  [210] = {.lex_state = 33},
  [211] = {.lex_state = 33},
  [212] = {.lex_state = 33},
  [213] = {.lex_state = 33},
  [214] = {.lex_state = 33},
  [215] = {.lex_state = 33},
  [216] = {.lex_state = 33},
  [217] = {.lex_state = 33},
  [218] = {.lex_state = 33},
  [219] = {.lex_state = 33},
  [220] = {.lex_state = 33},
  [221] = {.lex_state = 33},
  [222] = {.lex_state = 33},
  [223] = {.lex_state = 33},
  [224] = {.lex_state = 33},
  [225] = {.lex_state = 33},
  [226] = {.lex_state = 346},
  [227] = {.lex_state = 346},
  [228] = {.lex_state = 37},
  [229] = {.lex_state = 37},
  [230] = {.lex_state = 37},
  [231] = {.lex_state = 37},
  [232] = {.lex_state = 37},
  [233] = {.lex_state = 37},
  [234] = {.lex_state = 37},
  [235] = {.lex_state = 37},
  [236] = {.lex_state = 37},
  [237] = {.lex_state = 37},
  [238] = {.lex_state = 37},
  [239] = {.lex_state = 37},
  [240] = {.lex_state = 37},
  [241] = {.lex_state = 37},
  [242] = {.lex_state = 37},
  [243] = {.lex_state = 37},
  [244] = {.lex_state = 37},
  [245] = {.lex_state = 31},
  [246] = {.lex_state = 40},
  [247] = {.lex_state = 41},
  [248] = {.lex_state = 41},
  [249] = {.lex_state = 50},
  [250] = {.lex_state = 51},
  [251] = {.lex_state = 50},
  [252] = {.lex_state = 41},
  [253] = {.lex_state = 41},
  [254] = {.lex_state = 41},
  [255] = {.lex_state = 41},
  [256] = {.lex_state = 41},
  [257] = {.lex_state = 41},
  [258] = {.lex_state = 52},
  [259] = {.lex_state = 41},
  [260] = {.lex_state = 52},
  [261] = {.lex_state = 41},
  [262] = {.lex_state = 41},
  [263] = {.lex_state = 52},
  [264] = {.lex_state = 346},
  [265] = {.lex_state = 41},
  [266] = {.lex_state = 346},
  [267] = {.lex_state = 41},
  [268] = {.lex_state = 41},
  [269] = {.lex_state = 41},
  [270] = {.lex_state = 346},
  [271] = {.lex_state = 41},
  [272] = {.lex_state = 41},
  [273] = {.lex_state = 346},
  [274] = {.lex_state = 346},
  [275] = {.lex_state = 346},
  [276] = {.lex_state = 41},
  [277] = {.lex_state = 41},
  [278] = {.lex_state = 346},
  [279] = {.lex_state = 346},
  [280] = {.lex_state = 41},
  [281] = {.lex_state = 41},
  [282] = {.lex_state = 41},
  [283] = {.lex_state = 346},
  [284] = {.lex_state = 41},
  [285] = {.lex_state = 346},
  [286] = {.lex_state = 41},
  [287] = {.lex_state = 346},
  [288] = {.lex_state = 41},
  [289] = {.lex_state = 41},
  [290] = {.lex_state = 41},
  [291] = {.lex_state = 346},
  [292] = {.lex_state = 41},
  [293] = {.lex_state = 346},
  [294] = {.lex_state = 41},
  [295] = {.lex_state = 346},
  [296] = {.lex_state = 41},
  [297] = {.lex_state = 41},
  [298] = {.lex_state = 346},
  [299] = {.lex_state = 41},
  [300] = {.lex_state = 346},
  [301] = {.lex_state = 41},
  [302] = {.lex_state = 346},
  [303] = {.lex_state = 41},
  [304] = {.lex_state = 346},
  [305] = {.lex_state = 346},
  [306] = {.lex_state = 346},
  [307] = {.lex_state = 41},
  [308] = {.lex_state = 346},
  [309] = {.lex_state = 41},
  [310] = {.lex_state = 41},
  [311] = {.lex_state = 41},
  [312] = {.lex_state = 41},
  [313] = {.lex_state = 41},
  [314] = {.lex_state = 41},
  [315] = {.lex_state = 41},
  [316] = {.lex_state = 41},
  [317] = {.lex_state = 41},
  [318] = {.lex_state = 41},
  [319] = {.lex_state = 53},
  [320] = {.lex_state = 50},
  [321] = {.lex_state = 52},
  [322] = {.lex_state = 41},
  [323] = {.lex_state = 41},
  [324] = {.lex_state = 34},
  [325] = {.lex_state = 35},
  [326] = {.lex_state = 35},
  [327] = {.lex_state = 35},
  [328] = {.lex_state = 35},
  [329] = {.lex_state = 35},
  [330] = {.lex_state = 34},
  [331] = {.lex_state = 34},
  [332] = {.lex_state = 34},
  [333] = {.lex_state = 346},
  [334] = {.lex_state = 34},
  [335] = {.lex_state = 34},
  [336] = {.lex_state = 346},
  [337] = {.lex_state = 346},
  [338] = {.lex_state = 34},
  [339] = {.lex_state = 34},
  [340] = {.lex_state = 346},
  [341] = {.lex_state = 346},
  [342] = {.lex_state = 34},
  [343] = {.lex_state = 34},
  [344] = {.lex_state = 34},
  [345] = {.lex_state = 34},
  [346] = {.lex_state = 346},
  [347] = {.lex_state = 34},
  [348] = {.lex_state = 34},
  [349] = {.lex_state = 34},
  [350] = {.lex_state = 34},
  [351] = {.lex_state = 346},
  [352] = {.lex_state = 34},
  [353] = {.lex_state = 34},
  [354] = {.lex_state = 346},
  [355] = {.lex_state = 34},
  [356] = {.lex_state = 34},
  [357] = {.lex_state = 34},
  [358] = {.lex_state = 34},
  [359] = {.lex_state = 346},
  [360] = {.lex_state = 346},
  [361] = {.lex_state = 34},
  [362] = {.lex_state = 346},
  [363] = {.lex_state = 34},
  [364] = {.lex_state = 34},
  [365] = {.lex_state = 34},
  [366] = {.lex_state = 346},
  [367] = {.lex_state = 346},
  [368] = {.lex_state = 34},
  [369] = {.lex_state = 34},
  [370] = {.lex_state = 34},
  [371] = {.lex_state = 34},
  [372] = {.lex_state = 346},
  [373] = {.lex_state = 36},
  [374] = {.lex_state = 346},
  [375] = {.lex_state = 346},
  [376] = {.lex_state = 346},
  [377] = {.lex_state = 346},
  [378] = {.lex_state = 346},
  [379] = {.lex_state = 346},
  [380] = {.lex_state = 346},
  [381] = {.lex_state = 346},
  [382] = {.lex_state = 346},
  [383] = {.lex_state = 346},
  [384] = {.lex_state = 346},
  [385] = {.lex_state = 346},
  [386] = {.lex_state = 346},
  [387] = {.lex_state = 346},
  [388] = {.lex_state = 34},
  [389] = {.lex_state = 34},
  [390] = {.lex_state = 34},
  [391] = {.lex_state = 34},
  [392] = {.lex_state = 34},
  [393] = {.lex_state = 34},
  [394] = {.lex_state = 34},
  [395] = {.lex_state = 34},
  [396] = {.lex_state = 34},
  [397] = {.lex_state = 34},
  [398] = {.lex_state = 34},
  [399] = {.lex_state = 34},
  [400] = {.lex_state = 346},
  [401] = {.lex_state = 34},
  [402] = {.lex_state = 346},
  [403] = {.lex_state = 346},
  [404] = {.lex_state = 34},
  [405] = {.lex_state = 346},
  [406] = {.lex_state = 346},
  [407] = {.lex_state = 346},
  [408] = {.lex_state = 346},
  [409] = {.lex_state = 346},
  [410] = {.lex_state = 346},
  [411] = {.lex_state = 34},
  [412] = {.lex_state = 346},
  [413] = {.lex_state = 34},
  [414] = {.lex_state = 346},
  [415] = {.lex_state = 346},
  [416] = {.lex_state = 346},
  [417] = {.lex_state = 34},
  [418] = {.lex_state = 346},
  [419] = {.lex_state = 34},
  [420] = {.lex_state = 346},
  [421] = {.lex_state = 346},
  [422] = {.lex_state = 34},
  [423] = {.lex_state = 346},
  [424] = {.lex_state = 34},
  [425] = {.lex_state = 34},
  [426] = {.lex_state = 34},
  [427] = {.lex_state = 34},
  [428] = {.lex_state = 346},
  [429] = {.lex_state = 346},
  [430] = {.lex_state = 346},
  [431] = {.lex_state = 346},
  [432] = {.lex_state = 346},
  [433] = {.lex_state = 346},
  [434] = {.lex_state = 346},
  [435] = {.lex_state = 346},
  [436] = {.lex_state = 346},
  [437] = {.lex_state = 346},
  [438] = {.lex_state = 346},
  [439] = {.lex_state = 346},
  [440] = {.lex_state = 346},
  [441] = {.lex_state = 346},
  [442] = {.lex_state = 346},
  [443] = {.lex_state = 346},
  [444] = {.lex_state = 346},
  [445] = {.lex_state = 346},
  [446] = {.lex_state = 346},
  [447] = {.lex_state = 35},
  [448] = {.lex_state = 35},
  [449] = {.lex_state = 35},
  [450] = {.lex_state = 35},
  [451] = {.lex_state = 40},
  [452] = {.lex_state = 40},
  [453] = {.lex_state = 35},
  [454] = {.lex_state = 38},
  [455] = {.lex_state = 35},
  [456] = {.lex_state = 39},
  [457] = {.lex_state = 0},
  [458] = {.lex_state = 34},
  [459] = {.lex_state = 40},
  [460] = {.lex_state = 38},
  [461] = {.lex_state = 0},
  [462] = {.lex_state = 0},
  [463] = {.lex_state = 35},
  [464] = {.lex_state = 34},
  [465] = {.lex_state = 40},
  [466] = {.lex_state = 0},
  [467] = {.lex_state = 35},
  [468] = {.lex_state = 40},
  [469] = {.lex_state = 40},
  [470] = {.lex_state = 35},
  [471] = {.lex_state = 35},
  [472] = {.lex_state = 39},
  [473] = {.lex_state = 38},
  [474] = {.lex_state = 39},
  [475] = {.lex_state = 35},
  [476] = {.lex_state = 39},
  [477] = {.lex_state = 38},
  [478] = {.lex_state = 39},
  [479] = {.lex_state = 38},
  [480] = {.lex_state = 34},
  [481] = {.lex_state = 0},
  [482] = {.lex_state = 35},
  [483] = {.lex_state = 0},
  [484] = {.lex_state = 0},
  [485] = {.lex_state = 0},
  [486] = {.lex_state = 0},
  [487] = {.lex_state = 0},
  [488] = {.lex_state = 34},
  [489] = {.lex_state = 0},
  [490] = {.lex_state = 0},
  [491] = {.lex_state = 0},
  [492] = {.lex_state = 0},
  [493] = {.lex_state = 40},
  [494] = {.lex_state = 0},
  [495] = {.lex_state = 0},
  [496] = {.lex_state = 0},
  [497] = {.lex_state = 0},
  [498] = {.lex_state = 0},
  [499] = {.lex_state = 0},
  [500] = {.lex_state = 0},
  [501] = {.lex_state = 0},
  [502] = {.lex_state = 0},
  [503] = {.lex_state = 0},
  [504] = {.lex_state = 0},
  [505] = {.lex_state = 0},
  [506] = {.lex_state = 0},
  [507] = {.lex_state = 0},
  [508] = {.lex_state = 0},
  [509] = {.lex_state = 0},
  [510] = {.lex_state = 0},
  [511] = {.lex_state = 34},
  [512] = {.lex_state = 34},
  [513] = {.lex_state = 0},
  [514] = {.lex_state = 0},
  [515] = {.lex_state = 40},
  [516] = {.lex_state = 0},
  [517] = {.lex_state = 0},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 0},
  [520] = {.lex_state = 0},
  [521] = {.lex_state = 0},
  [522] = {.lex_state = 0},
  [523] = {.lex_state = 0},
  [524] = {.lex_state = 0},
  [525] = {.lex_state = 0},
  [526] = {.lex_state = 0},
  [527] = {.lex_state = 0},
  [528] = {.lex_state = 0},
  [529] = {.lex_state = 0},
  [530] = {.lex_state = 0},
  [531] = {.lex_state = 0},
  [532] = {.lex_state = 0},
  [533] = {.lex_state = 0},
  [534] = {.lex_state = 0},
  [535] = {.lex_state = 0},
  [536] = {.lex_state = 0},
  [537] = {.lex_state = 0},
  [538] = {.lex_state = 0},
  [539] = {.lex_state = 0},
  [540] = {.lex_state = 0},
  [541] = {.lex_state = 0},
  [542] = {.lex_state = 0},
  [543] = {.lex_state = 0},
  [544] = {.lex_state = 0},
  [545] = {.lex_state = 0},
  [546] = {.lex_state = 0},
  [547] = {.lex_state = 0},
  [548] = {.lex_state = 0},
  [549] = {.lex_state = 0},
  [550] = {.lex_state = 0},
  [551] = {.lex_state = 0},
  [552] = {.lex_state = 0},
  [553] = {.lex_state = 0},
  [554] = {.lex_state = 0},
  [555] = {.lex_state = 0},
  [556] = {.lex_state = 0},
  [557] = {.lex_state = 0},
  [558] = {.lex_state = 0},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 0},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 0},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 0},
  [567] = {.lex_state = 0},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 0},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 0},
  [574] = {.lex_state = 0},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 0},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 0},
  [580] = {.lex_state = 0},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 0},
  [583] = {.lex_state = 0},
  [584] = {.lex_state = 0},
  [585] = {.lex_state = 0},
  [586] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_component] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_transitions] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_out] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_states] = ACTIONS(1),
    [anon_sym_animate] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_callback] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_LT_EQ_GT] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_in_DASHout] = ACTIONS(1),
    [anon_sym_property] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_when] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [sym_children_macro] = ACTIONS(1),
    [anon_sym_linear_DASHgradient] = ACTIONS(1),
    [anon_sym_circle] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [aux_sym_color_literal_token1] = ACTIONS(1),
    [aux_sym_color_literal_token2] = ACTIONS(1),
    [aux_sym_color_literal_token3] = ACTIONS(1),
    [sym_int_literal] = ACTIONS(1),
    [sym_float_literal] = ACTIONS(1),
    [anon_sym_px] = ACTIONS(1),
    [anon_sym_ms] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_deg] = ACTIONS(1),
    [anon_sym_rad] = ACTIONS(1),
    [anon_sym_ease] = ACTIONS(1),
    [anon_sym_ease_DASHin] = ACTIONS(1),
    [anon_sym_ease_in] = ACTIONS(1),
    [anon_sym_ease_in_out] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(1),
    [anon_sym_ease_out] = ACTIONS(1),
    [anon_sym_ease_DASHout] = ACTIONS(1),
    [anon_sym_start] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_black] = ACTIONS(1),
    [anon_sym_blue] = ACTIONS(1),
    [anon_sym_green] = ACTIONS(1),
    [anon_sym_red] = ACTIONS(1),
    [anon_sym_yellow] = ACTIONS(1),
    [anon_sym_white] = ACTIONS(1),
    [anon_sym_gray] = ACTIONS(1),
    [anon_sym_transparent] = ACTIONS(1),
    [anon_sym_angle] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [anon_sym_brush] = ACTIONS(1),
    [anon_sym_color] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_image] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_length] = ACTIONS(1),
    [anon_sym_percent] = ACTIONS(1),
    [anon_sym_physical_DASHlength] = ACTIONS(1),
    [anon_sym_physical_length] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_debug] = ACTIONS(1),
    [anon_sym_animation_DASHtick] = ACTIONS(1),
    [anon_sym_min] = ACTIONS(1),
    [anon_sym_max] = ACTIONS(1),
    [anon_sym_mod] = ACTIONS(1),
    [anon_sym_abs] = ACTIONS(1),
    [anon_sym_round] = ACTIONS(1),
    [anon_sym_ceil] = ACTIONS(1),
    [anon_sym_floor] = ACTIONS(1),
    [anon_sym_sin] = ACTIONS(1),
    [anon_sym_cos] = ACTIONS(1),
    [anon_sym_tan] = ACTIONS(1),
    [anon_sym_acos] = ACTIONS(1),
    [anon_sym_atan] = ACTIONS(1),
    [anon_sym_sqrt] = ACTIONS(1),
    [anon_sym_pow] = ACTIONS(1),
    [anon_sym_log] = ACTIONS(1),
    [anon_sym_rgb] = ACTIONS(1),
    [anon_sym_easing] = ACTIONS(1),
    [anon_sym_duration] = ACTIONS(1),
    [anon_sym_parent] = ACTIONS(1),
    [anon_sym_root] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(563),
    [sym__item] = STATE(227),
    [sym_struct_item] = STATE(227),
    [sym_export_statement] = STATE(227),
    [sym_global_single] = STATE(227),
    [sym_import_statement] = STATE(227),
    [sym_component_item] = STATE(227),
    [sym__conditional_element] = STATE(249),
    [sym_vis] = STATE(250),
    [sym_identifier] = STATE(448),
    [sym__type_identifier] = STATE(470),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [aux_sym_source_file_repeat1] = STATE(227),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_export] = ACTIONS(7),
    [anon_sym_struct] = ACTIONS(9),
    [anon_sym_global] = ACTIONS(11),
    [anon_sym_import] = ACTIONS(13),
    [anon_sym_component] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym_struct_block_definition] = STATE(400),
    [sym__expression] = STATE(400),
    [sym__all_expressions] = STATE(400),
    [sym_if_expression] = STATE(400),
    [sym_index_expression] = STATE(400),
    [sym_assign_expression] = STATE(400),
    [sym_comp_assign_expression] = STATE(400),
    [sym_call_expression] = STATE(400),
    [sym_function_call_args] = STATE(50),
    [sym_field_expression] = STATE(400),
    [sym_bool_literal] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_binary_expression] = STATE(400),
    [sym_ternary_expression] = STATE(400),
    [sym__macro] = STATE(400),
    [sym__literal] = STATE(400),
    [sym_array_literal] = STATE(400),
    [sym_string_literal] = STATE(400),
    [sym_identifier] = STATE(400),
    [sym_color_literal] = STATE(400),
    [sym__number] = STATE(400),
    [sym_num_units] = STATE(400),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(41),
    [anon_sym_EQ] = ACTIONS(43),
    [anon_sym_PLUS_EQ] = ACTIONS(45),
    [anon_sym_DASH_EQ] = ACTIONS(45),
    [anon_sym_STAR_EQ] = ACTIONS(45),
    [anon_sym_SLASH_EQ] = ACTIONS(45),
    [anon_sym_PERCENT_EQ] = ACTIONS(45),
    [anon_sym_AMP_EQ] = ACTIONS(45),
    [anon_sym_PIPE_EQ] = ACTIONS(45),
    [anon_sym_CARET_EQ] = ACTIONS(45),
    [anon_sym_LT_LT_EQ] = ACTIONS(45),
    [anon_sym_GT_GT_EQ] = ACTIONS(45),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_BANG] = ACTIONS(53),
    [anon_sym_AMP_AMP] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_CARET] = ACTIONS(63),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(37),
    [anon_sym_QMARK] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym_struct_block_definition] = STATE(408),
    [sym_component_item] = STATE(11),
    [sym__conditional_element] = STATE(251),
    [sym_transition_statement] = STATE(11),
    [sym_state_statement] = STATE(11),
    [sym_animate_statement] = STATE(11),
    [sym_for_loop] = STATE(11),
    [sym__property] = STATE(11),
    [sym_call_back_definition] = STATE(11),
    [sym_call_back_handler] = STATE(11),
    [sym_two_way_property] = STATE(11),
    [sym_define_assign_property] = STATE(11),
    [sym__define_property] = STATE(88),
    [sym__assign_property] = STATE(206),
    [sym__expression] = STATE(408),
    [sym__all_expressions] = STATE(408),
    [sym_if_expression] = STATE(408),
    [sym_index_expression] = STATE(408),
    [sym_assign_expression] = STATE(408),
    [sym_comp_assign_expression] = STATE(408),
    [sym_call_expression] = STATE(408),
    [sym_field_expression] = STATE(408),
    [sym_bool_literal] = STATE(408),
    [sym_unary_expression] = STATE(408),
    [sym_binary_expression] = STATE(408),
    [sym_ternary_expression] = STATE(408),
    [sym__macro] = STATE(408),
    [sym__literal] = STATE(408),
    [sym_array_literal] = STATE(408),
    [sym_string_literal] = STATE(408),
    [sym_vis] = STATE(260),
    [sym_identifier] = STATE(373),
    [sym_color_literal] = STATE(408),
    [sym__number] = STATE(408),
    [sym_num_units] = STATE(408),
    [sym__type_identifier] = STATE(482),
    [sym__function_identifier] = STATE(518),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [aux_sym__component_body_repeat1] = STATE(11),
    [anon_sym_export] = ACTIONS(83),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_COLON] = ACTIONS(85),
    [anon_sym_RBRACE] = ACTIONS(87),
    [anon_sym_component] = ACTIONS(89),
    [anon_sym_if] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_transitions] = ACTIONS(95),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_in] = ACTIONS(99),
    [anon_sym_out] = ACTIONS(99),
    [anon_sym_states] = ACTIONS(101),
    [anon_sym_animate] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_callback] = ACTIONS(107),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_in_DASHout] = ACTIONS(99),
    [anon_sym_property] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym_struct_block_definition] = STATE(408),
    [sym_component_item] = STATE(3),
    [sym__conditional_element] = STATE(251),
    [sym_transition_statement] = STATE(3),
    [sym_state_statement] = STATE(3),
    [sym_animate_statement] = STATE(3),
    [sym_for_loop] = STATE(3),
    [sym__property] = STATE(3),
    [sym_call_back_definition] = STATE(3),
    [sym_call_back_handler] = STATE(3),
    [sym_two_way_property] = STATE(3),
    [sym_define_assign_property] = STATE(3),
    [sym__define_property] = STATE(88),
    [sym__assign_property] = STATE(206),
    [sym__expression] = STATE(408),
    [sym__all_expressions] = STATE(408),
    [sym_if_expression] = STATE(408),
    [sym_index_expression] = STATE(408),
    [sym_assign_expression] = STATE(408),
    [sym_comp_assign_expression] = STATE(408),
    [sym_call_expression] = STATE(408),
    [sym_field_expression] = STATE(408),
    [sym_bool_literal] = STATE(408),
    [sym_unary_expression] = STATE(408),
    [sym_binary_expression] = STATE(408),
    [sym_ternary_expression] = STATE(408),
    [sym__macro] = STATE(408),
    [sym__literal] = STATE(408),
    [sym_array_literal] = STATE(408),
    [sym_string_literal] = STATE(408),
    [sym_vis] = STATE(260),
    [sym_identifier] = STATE(373),
    [sym_color_literal] = STATE(408),
    [sym__number] = STATE(408),
    [sym_num_units] = STATE(408),
    [sym__type_identifier] = STATE(482),
    [sym__function_identifier] = STATE(518),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [aux_sym__component_body_repeat1] = STATE(3),
    [anon_sym_export] = ACTIONS(83),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_COLON] = ACTIONS(85),
    [anon_sym_RBRACE] = ACTIONS(115),
    [anon_sym_component] = ACTIONS(89),
    [anon_sym_if] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_transitions] = ACTIONS(95),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_in] = ACTIONS(99),
    [anon_sym_out] = ACTIONS(99),
    [anon_sym_states] = ACTIONS(101),
    [anon_sym_animate] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_callback] = ACTIONS(107),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_in_DASHout] = ACTIONS(99),
    [anon_sym_property] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym_struct_block_definition] = STATE(408),
    [sym_component_item] = STATE(10),
    [sym__conditional_element] = STATE(251),
    [sym_transition_statement] = STATE(10),
    [sym_state_statement] = STATE(10),
    [sym_animate_statement] = STATE(10),
    [sym_for_loop] = STATE(10),
    [sym__property] = STATE(10),
    [sym_call_back_definition] = STATE(10),
    [sym_call_back_handler] = STATE(10),
    [sym_two_way_property] = STATE(10),
    [sym_define_assign_property] = STATE(10),
    [sym__define_property] = STATE(88),
    [sym__assign_property] = STATE(206),
    [sym__expression] = STATE(408),
    [sym__all_expressions] = STATE(408),
    [sym_if_expression] = STATE(408),
    [sym_index_expression] = STATE(408),
    [sym_assign_expression] = STATE(408),
    [sym_comp_assign_expression] = STATE(408),
    [sym_call_expression] = STATE(408),
    [sym_field_expression] = STATE(408),
    [sym_bool_literal] = STATE(408),
    [sym_unary_expression] = STATE(408),
    [sym_binary_expression] = STATE(408),
    [sym_ternary_expression] = STATE(408),
    [sym__macro] = STATE(408),
    [sym__literal] = STATE(408),
    [sym_array_literal] = STATE(408),
    [sym_string_literal] = STATE(408),
    [sym_vis] = STATE(260),
    [sym_identifier] = STATE(373),
    [sym_color_literal] = STATE(408),
    [sym__number] = STATE(408),
    [sym_num_units] = STATE(408),
    [sym__type_identifier] = STATE(482),
    [sym__function_identifier] = STATE(518),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [aux_sym__component_body_repeat1] = STATE(10),
    [anon_sym_export] = ACTIONS(83),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_COLON] = ACTIONS(85),
    [anon_sym_RBRACE] = ACTIONS(117),
    [anon_sym_component] = ACTIONS(89),
    [anon_sym_if] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_transitions] = ACTIONS(95),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_in] = ACTIONS(99),
    [anon_sym_out] = ACTIONS(99),
    [anon_sym_states] = ACTIONS(101),
    [anon_sym_animate] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_callback] = ACTIONS(107),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_in_DASHout] = ACTIONS(99),
    [anon_sym_property] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym_struct_block_definition] = STATE(384),
    [sym__expression] = STATE(384),
    [sym__all_expressions] = STATE(384),
    [sym_if_expression] = STATE(384),
    [sym_index_expression] = STATE(384),
    [sym_assign_expression] = STATE(384),
    [sym_comp_assign_expression] = STATE(384),
    [sym_call_expression] = STATE(384),
    [sym_function_call_args] = STATE(50),
    [sym_field_expression] = STATE(384),
    [sym_bool_literal] = STATE(384),
    [sym_unary_expression] = STATE(384),
    [sym_binary_expression] = STATE(384),
    [sym_ternary_expression] = STATE(384),
    [sym__macro] = STATE(384),
    [sym__literal] = STATE(384),
    [sym_array_literal] = STATE(384),
    [sym_string_literal] = STATE(384),
    [sym_identifier] = STATE(384),
    [sym_color_literal] = STATE(384),
    [sym__number] = STATE(384),
    [sym_num_units] = STATE(384),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(41),
    [anon_sym_EQ] = ACTIONS(43),
    [anon_sym_PLUS_EQ] = ACTIONS(45),
    [anon_sym_DASH_EQ] = ACTIONS(45),
    [anon_sym_STAR_EQ] = ACTIONS(45),
    [anon_sym_SLASH_EQ] = ACTIONS(45),
    [anon_sym_PERCENT_EQ] = ACTIONS(45),
    [anon_sym_AMP_EQ] = ACTIONS(45),
    [anon_sym_PIPE_EQ] = ACTIONS(45),
    [anon_sym_CARET_EQ] = ACTIONS(45),
    [anon_sym_LT_LT_EQ] = ACTIONS(45),
    [anon_sym_GT_GT_EQ] = ACTIONS(45),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_BANG] = ACTIONS(53),
    [anon_sym_AMP_AMP] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_CARET] = ACTIONS(63),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(37),
    [anon_sym_QMARK] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym_struct_block_definition] = STATE(375),
    [sym__expression] = STATE(375),
    [sym__all_expressions] = STATE(375),
    [sym_if_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_assign_expression] = STATE(375),
    [sym_comp_assign_expression] = STATE(375),
    [sym_call_expression] = STATE(375),
    [sym_function_call_args] = STATE(50),
    [sym_field_expression] = STATE(375),
    [sym_bool_literal] = STATE(375),
    [sym_unary_expression] = STATE(375),
    [sym_binary_expression] = STATE(375),
    [sym_ternary_expression] = STATE(375),
    [sym__macro] = STATE(375),
    [sym__literal] = STATE(375),
    [sym_array_literal] = STATE(375),
    [sym_string_literal] = STATE(375),
    [sym_identifier] = STATE(375),
    [sym_color_literal] = STATE(375),
    [sym__number] = STATE(375),
    [sym_num_units] = STATE(375),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(41),
    [anon_sym_EQ] = ACTIONS(43),
    [anon_sym_PLUS_EQ] = ACTIONS(45),
    [anon_sym_DASH_EQ] = ACTIONS(45),
    [anon_sym_STAR_EQ] = ACTIONS(45),
    [anon_sym_SLASH_EQ] = ACTIONS(45),
    [anon_sym_PERCENT_EQ] = ACTIONS(45),
    [anon_sym_AMP_EQ] = ACTIONS(45),
    [anon_sym_PIPE_EQ] = ACTIONS(45),
    [anon_sym_CARET_EQ] = ACTIONS(45),
    [anon_sym_LT_LT_EQ] = ACTIONS(45),
    [anon_sym_GT_GT_EQ] = ACTIONS(45),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_BANG] = ACTIONS(53),
    [anon_sym_AMP_AMP] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_CARET] = ACTIONS(63),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(37),
    [anon_sym_QMARK] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym_struct_block_definition] = STATE(379),
    [sym__expression] = STATE(379),
    [sym__all_expressions] = STATE(379),
    [sym_if_expression] = STATE(379),
    [sym_index_expression] = STATE(379),
    [sym_assign_expression] = STATE(379),
    [sym_comp_assign_expression] = STATE(379),
    [sym_call_expression] = STATE(379),
    [sym_function_call_args] = STATE(50),
    [sym_field_expression] = STATE(379),
    [sym_bool_literal] = STATE(379),
    [sym_unary_expression] = STATE(379),
    [sym_binary_expression] = STATE(379),
    [sym_ternary_expression] = STATE(379),
    [sym__macro] = STATE(379),
    [sym__literal] = STATE(379),
    [sym_array_literal] = STATE(379),
    [sym_string_literal] = STATE(379),
    [sym_identifier] = STATE(379),
    [sym_color_literal] = STATE(379),
    [sym__number] = STATE(379),
    [sym_num_units] = STATE(379),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(41),
    [anon_sym_EQ] = ACTIONS(43),
    [anon_sym_PLUS_EQ] = ACTIONS(45),
    [anon_sym_DASH_EQ] = ACTIONS(45),
    [anon_sym_STAR_EQ] = ACTIONS(45),
    [anon_sym_SLASH_EQ] = ACTIONS(45),
    [anon_sym_PERCENT_EQ] = ACTIONS(45),
    [anon_sym_AMP_EQ] = ACTIONS(45),
    [anon_sym_PIPE_EQ] = ACTIONS(45),
    [anon_sym_CARET_EQ] = ACTIONS(45),
    [anon_sym_LT_LT_EQ] = ACTIONS(45),
    [anon_sym_GT_GT_EQ] = ACTIONS(45),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_BANG] = ACTIONS(53),
    [anon_sym_AMP_AMP] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_CARET] = ACTIONS(63),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(37),
    [anon_sym_QMARK] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [sym_struct_block_definition] = STATE(383),
    [sym__expression] = STATE(383),
    [sym__all_expressions] = STATE(383),
    [sym_if_expression] = STATE(383),
    [sym_index_expression] = STATE(383),
    [sym_assign_expression] = STATE(383),
    [sym_comp_assign_expression] = STATE(383),
    [sym_call_expression] = STATE(383),
    [sym_function_call_args] = STATE(50),
    [sym_field_expression] = STATE(383),
    [sym_bool_literal] = STATE(383),
    [sym_unary_expression] = STATE(383),
    [sym_binary_expression] = STATE(383),
    [sym_ternary_expression] = STATE(383),
    [sym__macro] = STATE(383),
    [sym__literal] = STATE(383),
    [sym_array_literal] = STATE(383),
    [sym_string_literal] = STATE(383),
    [sym_identifier] = STATE(383),
    [sym_color_literal] = STATE(383),
    [sym__number] = STATE(383),
    [sym_num_units] = STATE(383),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(41),
    [anon_sym_EQ] = ACTIONS(43),
    [anon_sym_PLUS_EQ] = ACTIONS(45),
    [anon_sym_DASH_EQ] = ACTIONS(45),
    [anon_sym_STAR_EQ] = ACTIONS(45),
    [anon_sym_SLASH_EQ] = ACTIONS(45),
    [anon_sym_PERCENT_EQ] = ACTIONS(45),
    [anon_sym_AMP_EQ] = ACTIONS(45),
    [anon_sym_PIPE_EQ] = ACTIONS(45),
    [anon_sym_CARET_EQ] = ACTIONS(45),
    [anon_sym_LT_LT_EQ] = ACTIONS(45),
    [anon_sym_GT_GT_EQ] = ACTIONS(45),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_BANG] = ACTIONS(53),
    [anon_sym_AMP_AMP] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_CARET] = ACTIONS(63),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(37),
    [anon_sym_QMARK] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym_struct_block_definition] = STATE(408),
    [sym_component_item] = STATE(11),
    [sym__conditional_element] = STATE(251),
    [sym_transition_statement] = STATE(11),
    [sym_state_statement] = STATE(11),
    [sym_animate_statement] = STATE(11),
    [sym_for_loop] = STATE(11),
    [sym__property] = STATE(11),
    [sym_call_back_definition] = STATE(11),
    [sym_call_back_handler] = STATE(11),
    [sym_two_way_property] = STATE(11),
    [sym_define_assign_property] = STATE(11),
    [sym__define_property] = STATE(88),
    [sym__assign_property] = STATE(206),
    [sym__expression] = STATE(408),
    [sym__all_expressions] = STATE(408),
    [sym_if_expression] = STATE(408),
    [sym_index_expression] = STATE(408),
    [sym_assign_expression] = STATE(408),
    [sym_comp_assign_expression] = STATE(408),
    [sym_call_expression] = STATE(408),
    [sym_field_expression] = STATE(408),
    [sym_bool_literal] = STATE(408),
    [sym_unary_expression] = STATE(408),
    [sym_binary_expression] = STATE(408),
    [sym_ternary_expression] = STATE(408),
    [sym__macro] = STATE(408),
    [sym__literal] = STATE(408),
    [sym_array_literal] = STATE(408),
    [sym_string_literal] = STATE(408),
    [sym_vis] = STATE(260),
    [sym_identifier] = STATE(373),
    [sym_color_literal] = STATE(408),
    [sym__number] = STATE(408),
    [sym_num_units] = STATE(408),
    [sym__type_identifier] = STATE(482),
    [sym__function_identifier] = STATE(518),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [aux_sym__component_body_repeat1] = STATE(11),
    [anon_sym_export] = ACTIONS(83),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_COLON] = ACTIONS(85),
    [anon_sym_RBRACE] = ACTIONS(119),
    [anon_sym_component] = ACTIONS(89),
    [anon_sym_if] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_transitions] = ACTIONS(95),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_in] = ACTIONS(99),
    [anon_sym_out] = ACTIONS(99),
    [anon_sym_states] = ACTIONS(101),
    [anon_sym_animate] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(105),
    [anon_sym_callback] = ACTIONS(107),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_in_DASHout] = ACTIONS(99),
    [anon_sym_property] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym_struct_block_definition] = STATE(408),
    [sym_component_item] = STATE(11),
    [sym__conditional_element] = STATE(251),
    [sym_transition_statement] = STATE(11),
    [sym_state_statement] = STATE(11),
    [sym_animate_statement] = STATE(11),
    [sym_for_loop] = STATE(11),
    [sym__property] = STATE(11),
    [sym_call_back_definition] = STATE(11),
    [sym_call_back_handler] = STATE(11),
    [sym_two_way_property] = STATE(11),
    [sym_define_assign_property] = STATE(11),
    [sym__define_property] = STATE(88),
    [sym__assign_property] = STATE(206),
    [sym__expression] = STATE(408),
    [sym__all_expressions] = STATE(408),
    [sym_if_expression] = STATE(408),
    [sym_index_expression] = STATE(408),
    [sym_assign_expression] = STATE(408),
    [sym_comp_assign_expression] = STATE(408),
    [sym_call_expression] = STATE(408),
    [sym_field_expression] = STATE(408),
    [sym_bool_literal] = STATE(408),
    [sym_unary_expression] = STATE(408),
    [sym_binary_expression] = STATE(408),
    [sym_ternary_expression] = STATE(408),
    [sym__macro] = STATE(408),
    [sym__literal] = STATE(408),
    [sym_array_literal] = STATE(408),
    [sym_string_literal] = STATE(408),
    [sym_vis] = STATE(260),
    [sym_identifier] = STATE(373),
    [sym_color_literal] = STATE(408),
    [sym__number] = STATE(408),
    [sym_num_units] = STATE(408),
    [sym__type_identifier] = STATE(482),
    [sym__function_identifier] = STATE(518),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [aux_sym__component_body_repeat1] = STATE(11),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_LBRACE] = ACTIONS(124),
    [anon_sym_COLON] = ACTIONS(127),
    [anon_sym_RBRACE] = ACTIONS(130),
    [anon_sym_component] = ACTIONS(132),
    [anon_sym_if] = ACTIONS(135),
    [anon_sym_AT] = ACTIONS(138),
    [anon_sym_transitions] = ACTIONS(141),
    [anon_sym_LBRACK] = ACTIONS(144),
    [anon_sym_in] = ACTIONS(147),
    [anon_sym_out] = ACTIONS(147),
    [anon_sym_states] = ACTIONS(150),
    [anon_sym_animate] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(156),
    [anon_sym_callback] = ACTIONS(159),
    [anon_sym_LPAREN] = ACTIONS(162),
    [anon_sym_in_DASHout] = ACTIONS(147),
    [anon_sym_property] = ACTIONS(165),
    [anon_sym_true] = ACTIONS(168),
    [anon_sym_false] = ACTIONS(168),
    [anon_sym_DASH] = ACTIONS(171),
    [anon_sym_BANG] = ACTIONS(171),
    [anon_sym_DQUOTE] = ACTIONS(174),
    [anon_sym_SQUOTE] = ACTIONS(177),
    [sym__ident_reg] = ACTIONS(180),
    [anon_sym_POUND] = ACTIONS(183),
    [sym_int_literal] = ACTIONS(186),
    [sym_float_literal] = ACTIONS(189),
    [anon_sym_ease] = ACTIONS(192),
    [anon_sym_ease_DASHin] = ACTIONS(192),
    [anon_sym_ease_in] = ACTIONS(192),
    [anon_sym_ease_in_out] = ACTIONS(192),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(192),
    [anon_sym_ease_out] = ACTIONS(192),
    [anon_sym_ease_DASHout] = ACTIONS(192),
    [anon_sym_start] = ACTIONS(192),
    [anon_sym_end] = ACTIONS(192),
    [anon_sym_black] = ACTIONS(192),
    [anon_sym_blue] = ACTIONS(192),
    [anon_sym_green] = ACTIONS(192),
    [anon_sym_red] = ACTIONS(192),
    [anon_sym_yellow] = ACTIONS(192),
    [anon_sym_white] = ACTIONS(192),
    [anon_sym_gray] = ACTIONS(192),
    [anon_sym_transparent] = ACTIONS(192),
    [anon_sym_angle] = ACTIONS(195),
    [anon_sym_bool] = ACTIONS(195),
    [anon_sym_brush] = ACTIONS(195),
    [anon_sym_color] = ACTIONS(195),
    [anon_sym_float] = ACTIONS(195),
    [anon_sym_image] = ACTIONS(195),
    [anon_sym_int] = ACTIONS(195),
    [anon_sym_length] = ACTIONS(195),
    [anon_sym_percent] = ACTIONS(195),
    [anon_sym_physical_DASHlength] = ACTIONS(195),
    [anon_sym_physical_length] = ACTIONS(195),
    [anon_sym_string] = ACTIONS(195),
    [anon_sym_debug] = ACTIONS(198),
    [anon_sym_animation_DASHtick] = ACTIONS(198),
    [anon_sym_min] = ACTIONS(198),
    [anon_sym_max] = ACTIONS(198),
    [anon_sym_mod] = ACTIONS(198),
    [anon_sym_abs] = ACTIONS(198),
    [anon_sym_round] = ACTIONS(198),
    [anon_sym_ceil] = ACTIONS(198),
    [anon_sym_floor] = ACTIONS(198),
    [anon_sym_sin] = ACTIONS(198),
    [anon_sym_cos] = ACTIONS(198),
    [anon_sym_tan] = ACTIONS(198),
    [anon_sym_asin] = ACTIONS(198),
    [anon_sym_acos] = ACTIONS(198),
    [anon_sym_atan] = ACTIONS(198),
    [anon_sym_sqrt] = ACTIONS(198),
    [anon_sym_pow] = ACTIONS(198),
    [anon_sym_log] = ACTIONS(198),
    [anon_sym_rgb] = ACTIONS(198),
    [anon_sym_easing] = ACTIONS(201),
    [anon_sym_duration] = ACTIONS(201),
    [anon_sym_parent] = ACTIONS(201),
    [anon_sym_root] = ACTIONS(201),
    [sym_comment] = ACTIONS(3),
  },
  [12] = {
    [anon_sym_export] = ACTIONS(204),
    [anon_sym_LBRACE] = ACTIONS(206),
    [anon_sym_COLON] = ACTIONS(206),
    [anon_sym_COMMA] = ACTIONS(208),
    [anon_sym_RBRACE] = ACTIONS(206),
    [anon_sym_component] = ACTIONS(204),
    [anon_sym_if] = ACTIONS(204),
    [anon_sym_AT] = ACTIONS(206),
    [anon_sym_transitions] = ACTIONS(204),
    [anon_sym_LBRACK] = ACTIONS(206),
    [anon_sym_in] = ACTIONS(204),
    [anon_sym_out] = ACTIONS(204),
    [anon_sym_states] = ACTIONS(204),
    [anon_sym_animate] = ACTIONS(204),
    [anon_sym_STAR] = ACTIONS(210),
    [anon_sym_for] = ACTIONS(204),
    [anon_sym_callback] = ACTIONS(204),
    [anon_sym_LPAREN] = ACTIONS(206),
    [anon_sym_in_DASHout] = ACTIONS(204),
    [anon_sym_property] = ACTIONS(204),
    [anon_sym_LT] = ACTIONS(210),
    [anon_sym_GT] = ACTIONS(210),
    [anon_sym_EQ] = ACTIONS(210),
    [anon_sym_PLUS_EQ] = ACTIONS(208),
    [anon_sym_DASH_EQ] = ACTIONS(208),
    [anon_sym_STAR_EQ] = ACTIONS(208),
    [anon_sym_SLASH_EQ] = ACTIONS(208),
    [anon_sym_PERCENT_EQ] = ACTIONS(208),
    [anon_sym_AMP_EQ] = ACTIONS(208),
    [anon_sym_PIPE_EQ] = ACTIONS(208),
    [anon_sym_CARET_EQ] = ACTIONS(208),
    [anon_sym_LT_LT_EQ] = ACTIONS(208),
    [anon_sym_GT_GT_EQ] = ACTIONS(208),
    [anon_sym_DOT] = ACTIONS(208),
    [anon_sym_true] = ACTIONS(204),
    [anon_sym_false] = ACTIONS(204),
    [anon_sym_DASH] = ACTIONS(204),
    [anon_sym_BANG] = ACTIONS(204),
    [anon_sym_AMP_AMP] = ACTIONS(208),
    [anon_sym_PIPE_PIPE] = ACTIONS(208),
    [anon_sym_AMP] = ACTIONS(210),
    [anon_sym_PIPE] = ACTIONS(210),
    [anon_sym_CARET] = ACTIONS(210),
    [anon_sym_EQ_EQ] = ACTIONS(208),
    [anon_sym_BANG_EQ] = ACTIONS(208),
    [anon_sym_LT_EQ] = ACTIONS(208),
    [anon_sym_GT_EQ] = ACTIONS(208),
    [anon_sym_LT_LT] = ACTIONS(210),
    [anon_sym_GT_GT] = ACTIONS(210),
    [anon_sym_PLUS] = ACTIONS(210),
    [anon_sym_SLASH] = ACTIONS(210),
    [anon_sym_QMARK] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(206),
    [anon_sym_SQUOTE] = ACTIONS(206),
    [sym__ident_reg] = ACTIONS(204),
    [anon_sym_POUND] = ACTIONS(206),
    [sym_int_literal] = ACTIONS(204),
    [sym_float_literal] = ACTIONS(206),
    [anon_sym_ease] = ACTIONS(204),
    [anon_sym_ease_DASHin] = ACTIONS(204),
    [anon_sym_ease_in] = ACTIONS(204),
    [anon_sym_ease_in_out] = ACTIONS(204),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(204),
    [anon_sym_ease_out] = ACTIONS(204),
    [anon_sym_ease_DASHout] = ACTIONS(204),
    [anon_sym_start] = ACTIONS(204),
    [anon_sym_end] = ACTIONS(204),
    [anon_sym_black] = ACTIONS(204),
    [anon_sym_blue] = ACTIONS(204),
    [anon_sym_green] = ACTIONS(204),
    [anon_sym_red] = ACTIONS(204),
    [anon_sym_yellow] = ACTIONS(204),
    [anon_sym_white] = ACTIONS(204),
    [anon_sym_gray] = ACTIONS(204),
    [anon_sym_transparent] = ACTIONS(204),
    [anon_sym_angle] = ACTIONS(204),
    [anon_sym_bool] = ACTIONS(204),
    [anon_sym_brush] = ACTIONS(204),
    [anon_sym_color] = ACTIONS(204),
    [anon_sym_float] = ACTIONS(204),
    [anon_sym_image] = ACTIONS(204),
    [anon_sym_int] = ACTIONS(204),
    [anon_sym_length] = ACTIONS(204),
    [anon_sym_percent] = ACTIONS(204),
    [anon_sym_physical_DASHlength] = ACTIONS(204),
    [anon_sym_physical_length] = ACTIONS(204),
    [anon_sym_string] = ACTIONS(204),
    [anon_sym_debug] = ACTIONS(204),
    [anon_sym_animation_DASHtick] = ACTIONS(204),
    [anon_sym_min] = ACTIONS(204),
    [anon_sym_max] = ACTIONS(204),
    [anon_sym_mod] = ACTIONS(204),
    [anon_sym_abs] = ACTIONS(204),
    [anon_sym_round] = ACTIONS(204),
    [anon_sym_ceil] = ACTIONS(204),
    [anon_sym_floor] = ACTIONS(204),
    [anon_sym_sin] = ACTIONS(204),
    [anon_sym_cos] = ACTIONS(204),
    [anon_sym_tan] = ACTIONS(204),
    [anon_sym_asin] = ACTIONS(204),
    [anon_sym_acos] = ACTIONS(204),
    [anon_sym_atan] = ACTIONS(204),
    [anon_sym_sqrt] = ACTIONS(204),
    [anon_sym_pow] = ACTIONS(204),
    [anon_sym_log] = ACTIONS(204),
    [anon_sym_rgb] = ACTIONS(204),
    [anon_sym_easing] = ACTIONS(204),
    [anon_sym_duration] = ACTIONS(204),
    [anon_sym_parent] = ACTIONS(204),
    [anon_sym_root] = ACTIONS(204),
    [sym_comment] = ACTIONS(3),
  },
  [13] = {
    [sym_struct_block_definition] = STATE(410),
    [sym__property] = STATE(16),
    [sym_call_back_definition] = STATE(16),
    [sym_call_back_handler] = STATE(16),
    [sym_two_way_property] = STATE(16),
    [sym_define_assign_property] = STATE(16),
    [sym__define_property] = STATE(87),
    [sym__assign_property] = STATE(230),
    [sym__expression] = STATE(410),
    [sym__all_expressions] = STATE(410),
    [sym_if_expression] = STATE(410),
    [sym_index_expression] = STATE(410),
    [sym_assign_expression] = STATE(410),
    [sym_comp_assign_expression] = STATE(410),
    [sym_call_expression] = STATE(410),
    [sym_field_expression] = STATE(410),
    [sym_bool_literal] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_ternary_expression] = STATE(410),
    [sym__macro] = STATE(410),
    [sym__literal] = STATE(410),
    [sym_array_literal] = STATE(410),
    [sym_string_literal] = STATE(410),
    [sym_identifier] = STATE(412),
    [sym_color_literal] = STATE(410),
    [sym__number] = STATE(410),
    [sym_num_units] = STATE(410),
    [sym__function_identifier] = STATE(492),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [aux_sym_state_statement_repeat1] = STATE(16),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_COLON] = ACTIONS(212),
    [anon_sym_RBRACE] = ACTIONS(214),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_in] = ACTIONS(99),
    [anon_sym_out] = ACTIONS(99),
    [anon_sym_callback] = ACTIONS(216),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_in_DASHout] = ACTIONS(99),
    [anon_sym_property] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym_struct_block_definition] = STATE(410),
    [sym__property] = STATE(21),
    [sym_call_back_definition] = STATE(21),
    [sym_call_back_handler] = STATE(21),
    [sym_two_way_property] = STATE(21),
    [sym_define_assign_property] = STATE(21),
    [sym__define_property] = STATE(87),
    [sym__assign_property] = STATE(230),
    [sym__expression] = STATE(410),
    [sym__all_expressions] = STATE(410),
    [sym_if_expression] = STATE(410),
    [sym_index_expression] = STATE(410),
    [sym_assign_expression] = STATE(410),
    [sym_comp_assign_expression] = STATE(410),
    [sym_call_expression] = STATE(410),
    [sym_field_expression] = STATE(410),
    [sym_bool_literal] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_ternary_expression] = STATE(410),
    [sym__macro] = STATE(410),
    [sym__literal] = STATE(410),
    [sym_array_literal] = STATE(410),
    [sym_string_literal] = STATE(410),
    [sym_identifier] = STATE(434),
    [sym_color_literal] = STATE(410),
    [sym__number] = STATE(410),
    [sym_num_units] = STATE(410),
    [sym__function_identifier] = STATE(492),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [aux_sym_state_statement_repeat1] = STATE(21),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_COLON] = ACTIONS(212),
    [anon_sym_RBRACE] = ACTIONS(218),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_in] = ACTIONS(99),
    [anon_sym_out] = ACTIONS(99),
    [anon_sym_callback] = ACTIONS(216),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_in_DASHout] = ACTIONS(99),
    [anon_sym_property] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [15] = {
    [sym_struct_block_definition] = STATE(410),
    [sym__property] = STATE(18),
    [sym_call_back_definition] = STATE(18),
    [sym_call_back_handler] = STATE(18),
    [sym_two_way_property] = STATE(18),
    [sym_define_assign_property] = STATE(18),
    [sym__define_property] = STATE(87),
    [sym__assign_property] = STATE(230),
    [sym__expression] = STATE(410),
    [sym__all_expressions] = STATE(410),
    [sym_if_expression] = STATE(410),
    [sym_index_expression] = STATE(410),
    [sym_assign_expression] = STATE(410),
    [sym_comp_assign_expression] = STATE(410),
    [sym_call_expression] = STATE(410),
    [sym_field_expression] = STATE(410),
    [sym_bool_literal] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_ternary_expression] = STATE(410),
    [sym__macro] = STATE(410),
    [sym__literal] = STATE(410),
    [sym_array_literal] = STATE(410),
    [sym_string_literal] = STATE(410),
    [sym_identifier] = STATE(434),
    [sym_color_literal] = STATE(410),
    [sym__number] = STATE(410),
    [sym_num_units] = STATE(410),
    [sym__function_identifier] = STATE(492),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [aux_sym_state_statement_repeat1] = STATE(18),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_COLON] = ACTIONS(212),
    [anon_sym_RBRACE] = ACTIONS(220),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_in] = ACTIONS(99),
    [anon_sym_out] = ACTIONS(99),
    [anon_sym_callback] = ACTIONS(216),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_in_DASHout] = ACTIONS(99),
    [anon_sym_property] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [sym_struct_block_definition] = STATE(410),
    [sym__property] = STATE(21),
    [sym_call_back_definition] = STATE(21),
    [sym_call_back_handler] = STATE(21),
    [sym_two_way_property] = STATE(21),
    [sym_define_assign_property] = STATE(21),
    [sym__define_property] = STATE(87),
    [sym__assign_property] = STATE(230),
    [sym__expression] = STATE(410),
    [sym__all_expressions] = STATE(410),
    [sym_if_expression] = STATE(410),
    [sym_index_expression] = STATE(410),
    [sym_assign_expression] = STATE(410),
    [sym_comp_assign_expression] = STATE(410),
    [sym_call_expression] = STATE(410),
    [sym_field_expression] = STATE(410),
    [sym_bool_literal] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_ternary_expression] = STATE(410),
    [sym__macro] = STATE(410),
    [sym__literal] = STATE(410),
    [sym_array_literal] = STATE(410),
    [sym_string_literal] = STATE(410),
    [sym_identifier] = STATE(434),
    [sym_color_literal] = STATE(410),
    [sym__number] = STATE(410),
    [sym_num_units] = STATE(410),
    [sym__function_identifier] = STATE(492),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [aux_sym_state_statement_repeat1] = STATE(21),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_COLON] = ACTIONS(212),
    [anon_sym_RBRACE] = ACTIONS(220),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_in] = ACTIONS(99),
    [anon_sym_out] = ACTIONS(99),
    [anon_sym_callback] = ACTIONS(216),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_in_DASHout] = ACTIONS(99),
    [anon_sym_property] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [17] = {
    [sym_struct_block_definition] = STATE(410),
    [sym__property] = STATE(21),
    [sym_call_back_definition] = STATE(21),
    [sym_call_back_handler] = STATE(21),
    [sym_two_way_property] = STATE(21),
    [sym_define_assign_property] = STATE(21),
    [sym__define_property] = STATE(87),
    [sym__assign_property] = STATE(230),
    [sym__expression] = STATE(410),
    [sym__all_expressions] = STATE(410),
    [sym_if_expression] = STATE(410),
    [sym_index_expression] = STATE(410),
    [sym_assign_expression] = STATE(410),
    [sym_comp_assign_expression] = STATE(410),
    [sym_call_expression] = STATE(410),
    [sym_field_expression] = STATE(410),
    [sym_bool_literal] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_ternary_expression] = STATE(410),
    [sym__macro] = STATE(410),
    [sym__literal] = STATE(410),
    [sym_array_literal] = STATE(410),
    [sym_string_literal] = STATE(410),
    [sym_identifier] = STATE(434),
    [sym_color_literal] = STATE(410),
    [sym__number] = STATE(410),
    [sym_num_units] = STATE(410),
    [sym__function_identifier] = STATE(492),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [aux_sym_state_statement_repeat1] = STATE(21),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_COLON] = ACTIONS(212),
    [anon_sym_RBRACE] = ACTIONS(222),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_in] = ACTIONS(99),
    [anon_sym_out] = ACTIONS(99),
    [anon_sym_callback] = ACTIONS(216),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_in_DASHout] = ACTIONS(99),
    [anon_sym_property] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [18] = {
    [sym_struct_block_definition] = STATE(410),
    [sym__property] = STATE(21),
    [sym_call_back_definition] = STATE(21),
    [sym_call_back_handler] = STATE(21),
    [sym_two_way_property] = STATE(21),
    [sym_define_assign_property] = STATE(21),
    [sym__define_property] = STATE(87),
    [sym__assign_property] = STATE(230),
    [sym__expression] = STATE(410),
    [sym__all_expressions] = STATE(410),
    [sym_if_expression] = STATE(410),
    [sym_index_expression] = STATE(410),
    [sym_assign_expression] = STATE(410),
    [sym_comp_assign_expression] = STATE(410),
    [sym_call_expression] = STATE(410),
    [sym_field_expression] = STATE(410),
    [sym_bool_literal] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_ternary_expression] = STATE(410),
    [sym__macro] = STATE(410),
    [sym__literal] = STATE(410),
    [sym_array_literal] = STATE(410),
    [sym_string_literal] = STATE(410),
    [sym_identifier] = STATE(434),
    [sym_color_literal] = STATE(410),
    [sym__number] = STATE(410),
    [sym_num_units] = STATE(410),
    [sym__function_identifier] = STATE(492),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [aux_sym_state_statement_repeat1] = STATE(21),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_COLON] = ACTIONS(212),
    [anon_sym_RBRACE] = ACTIONS(224),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_in] = ACTIONS(99),
    [anon_sym_out] = ACTIONS(99),
    [anon_sym_callback] = ACTIONS(216),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_in_DASHout] = ACTIONS(99),
    [anon_sym_property] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [19] = {
    [sym_struct_block_definition] = STATE(410),
    [sym__property] = STATE(14),
    [sym_call_back_definition] = STATE(14),
    [sym_call_back_handler] = STATE(14),
    [sym_two_way_property] = STATE(14),
    [sym_define_assign_property] = STATE(14),
    [sym__define_property] = STATE(87),
    [sym__assign_property] = STATE(230),
    [sym__expression] = STATE(410),
    [sym__all_expressions] = STATE(410),
    [sym_if_expression] = STATE(410),
    [sym_index_expression] = STATE(410),
    [sym_assign_expression] = STATE(410),
    [sym_comp_assign_expression] = STATE(410),
    [sym_call_expression] = STATE(410),
    [sym_field_expression] = STATE(410),
    [sym_bool_literal] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_ternary_expression] = STATE(410),
    [sym__macro] = STATE(410),
    [sym__literal] = STATE(410),
    [sym_array_literal] = STATE(410),
    [sym_string_literal] = STATE(410),
    [sym_identifier] = STATE(434),
    [sym_color_literal] = STATE(410),
    [sym__number] = STATE(410),
    [sym_num_units] = STATE(410),
    [sym__function_identifier] = STATE(492),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [aux_sym_state_statement_repeat1] = STATE(14),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_COLON] = ACTIONS(212),
    [anon_sym_RBRACE] = ACTIONS(224),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_in] = ACTIONS(99),
    [anon_sym_out] = ACTIONS(99),
    [anon_sym_callback] = ACTIONS(216),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_in_DASHout] = ACTIONS(99),
    [anon_sym_property] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [sym_struct_block_definition] = STATE(410),
    [sym__property] = STATE(16),
    [sym_call_back_definition] = STATE(16),
    [sym_call_back_handler] = STATE(16),
    [sym_two_way_property] = STATE(16),
    [sym_define_assign_property] = STATE(16),
    [sym__define_property] = STATE(87),
    [sym__assign_property] = STATE(230),
    [sym__expression] = STATE(410),
    [sym__all_expressions] = STATE(410),
    [sym_if_expression] = STATE(410),
    [sym_index_expression] = STATE(410),
    [sym_assign_expression] = STATE(410),
    [sym_comp_assign_expression] = STATE(410),
    [sym_call_expression] = STATE(410),
    [sym_field_expression] = STATE(410),
    [sym_bool_literal] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_ternary_expression] = STATE(410),
    [sym__macro] = STATE(410),
    [sym__literal] = STATE(410),
    [sym_array_literal] = STATE(410),
    [sym_string_literal] = STATE(410),
    [sym_identifier] = STATE(412),
    [sym_color_literal] = STATE(410),
    [sym__number] = STATE(410),
    [sym_num_units] = STATE(410),
    [sym__function_identifier] = STATE(492),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [aux_sym_state_statement_repeat1] = STATE(16),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_COLON] = ACTIONS(212),
    [anon_sym_RBRACE] = ACTIONS(226),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_in] = ACTIONS(99),
    [anon_sym_out] = ACTIONS(99),
    [anon_sym_callback] = ACTIONS(216),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_in_DASHout] = ACTIONS(99),
    [anon_sym_property] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [21] = {
    [sym_struct_block_definition] = STATE(410),
    [sym__property] = STATE(21),
    [sym_call_back_definition] = STATE(21),
    [sym_call_back_handler] = STATE(21),
    [sym_two_way_property] = STATE(21),
    [sym_define_assign_property] = STATE(21),
    [sym__define_property] = STATE(87),
    [sym__assign_property] = STATE(230),
    [sym__expression] = STATE(410),
    [sym__all_expressions] = STATE(410),
    [sym_if_expression] = STATE(410),
    [sym_index_expression] = STATE(410),
    [sym_assign_expression] = STATE(410),
    [sym_comp_assign_expression] = STATE(410),
    [sym_call_expression] = STATE(410),
    [sym_field_expression] = STATE(410),
    [sym_bool_literal] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_ternary_expression] = STATE(410),
    [sym__macro] = STATE(410),
    [sym__literal] = STATE(410),
    [sym_array_literal] = STATE(410),
    [sym_string_literal] = STATE(410),
    [sym_identifier] = STATE(434),
    [sym_color_literal] = STATE(410),
    [sym__number] = STATE(410),
    [sym_num_units] = STATE(410),
    [sym__function_identifier] = STATE(492),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [aux_sym_state_statement_repeat1] = STATE(21),
    [anon_sym_LBRACE] = ACTIONS(228),
    [anon_sym_COLON] = ACTIONS(231),
    [anon_sym_RBRACE] = ACTIONS(234),
    [anon_sym_if] = ACTIONS(236),
    [anon_sym_AT] = ACTIONS(239),
    [anon_sym_LBRACK] = ACTIONS(242),
    [anon_sym_in] = ACTIONS(245),
    [anon_sym_out] = ACTIONS(245),
    [anon_sym_callback] = ACTIONS(248),
    [anon_sym_LPAREN] = ACTIONS(251),
    [anon_sym_in_DASHout] = ACTIONS(245),
    [anon_sym_property] = ACTIONS(254),
    [anon_sym_true] = ACTIONS(257),
    [anon_sym_false] = ACTIONS(257),
    [anon_sym_DASH] = ACTIONS(260),
    [anon_sym_BANG] = ACTIONS(260),
    [anon_sym_DQUOTE] = ACTIONS(263),
    [anon_sym_SQUOTE] = ACTIONS(266),
    [sym__ident_reg] = ACTIONS(269),
    [anon_sym_POUND] = ACTIONS(272),
    [sym_int_literal] = ACTIONS(275),
    [sym_float_literal] = ACTIONS(278),
    [anon_sym_ease] = ACTIONS(281),
    [anon_sym_ease_DASHin] = ACTIONS(281),
    [anon_sym_ease_in] = ACTIONS(281),
    [anon_sym_ease_in_out] = ACTIONS(281),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(281),
    [anon_sym_ease_out] = ACTIONS(281),
    [anon_sym_ease_DASHout] = ACTIONS(281),
    [anon_sym_start] = ACTIONS(281),
    [anon_sym_end] = ACTIONS(281),
    [anon_sym_black] = ACTIONS(281),
    [anon_sym_blue] = ACTIONS(281),
    [anon_sym_green] = ACTIONS(281),
    [anon_sym_red] = ACTIONS(281),
    [anon_sym_yellow] = ACTIONS(281),
    [anon_sym_white] = ACTIONS(281),
    [anon_sym_gray] = ACTIONS(281),
    [anon_sym_transparent] = ACTIONS(281),
    [anon_sym_angle] = ACTIONS(284),
    [anon_sym_bool] = ACTIONS(284),
    [anon_sym_brush] = ACTIONS(284),
    [anon_sym_color] = ACTIONS(284),
    [anon_sym_float] = ACTIONS(284),
    [anon_sym_image] = ACTIONS(284),
    [anon_sym_int] = ACTIONS(284),
    [anon_sym_length] = ACTIONS(284),
    [anon_sym_percent] = ACTIONS(284),
    [anon_sym_physical_DASHlength] = ACTIONS(284),
    [anon_sym_physical_length] = ACTIONS(284),
    [anon_sym_string] = ACTIONS(284),
    [anon_sym_debug] = ACTIONS(287),
    [anon_sym_animation_DASHtick] = ACTIONS(287),
    [anon_sym_min] = ACTIONS(287),
    [anon_sym_max] = ACTIONS(287),
    [anon_sym_mod] = ACTIONS(287),
    [anon_sym_abs] = ACTIONS(287),
    [anon_sym_round] = ACTIONS(287),
    [anon_sym_ceil] = ACTIONS(287),
    [anon_sym_floor] = ACTIONS(287),
    [anon_sym_sin] = ACTIONS(287),
    [anon_sym_cos] = ACTIONS(287),
    [anon_sym_tan] = ACTIONS(287),
    [anon_sym_asin] = ACTIONS(287),
    [anon_sym_acos] = ACTIONS(287),
    [anon_sym_atan] = ACTIONS(287),
    [anon_sym_sqrt] = ACTIONS(287),
    [anon_sym_pow] = ACTIONS(287),
    [anon_sym_log] = ACTIONS(287),
    [anon_sym_rgb] = ACTIONS(287),
    [anon_sym_easing] = ACTIONS(290),
    [anon_sym_duration] = ACTIONS(290),
    [anon_sym_parent] = ACTIONS(290),
    [anon_sym_root] = ACTIONS(290),
    [sym_comment] = ACTIONS(3),
  },
  [22] = {
    [sym_struct_block_definition] = STATE(410),
    [sym__property] = STATE(17),
    [sym_call_back_definition] = STATE(17),
    [sym_call_back_handler] = STATE(17),
    [sym_two_way_property] = STATE(17),
    [sym_define_assign_property] = STATE(17),
    [sym__define_property] = STATE(87),
    [sym__assign_property] = STATE(230),
    [sym__expression] = STATE(410),
    [sym__all_expressions] = STATE(410),
    [sym_if_expression] = STATE(410),
    [sym_index_expression] = STATE(410),
    [sym_assign_expression] = STATE(410),
    [sym_comp_assign_expression] = STATE(410),
    [sym_call_expression] = STATE(410),
    [sym_field_expression] = STATE(410),
    [sym_bool_literal] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_ternary_expression] = STATE(410),
    [sym__macro] = STATE(410),
    [sym__literal] = STATE(410),
    [sym_array_literal] = STATE(410),
    [sym_string_literal] = STATE(410),
    [sym_identifier] = STATE(434),
    [sym_color_literal] = STATE(410),
    [sym__number] = STATE(410),
    [sym_num_units] = STATE(410),
    [sym__function_identifier] = STATE(492),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [aux_sym_state_statement_repeat1] = STATE(17),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_COLON] = ACTIONS(212),
    [anon_sym_RBRACE] = ACTIONS(293),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_in] = ACTIONS(99),
    [anon_sym_out] = ACTIONS(99),
    [anon_sym_callback] = ACTIONS(216),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_in_DASHout] = ACTIONS(99),
    [anon_sym_property] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [23] = {
    [sym_units] = STATE(48),
    [anon_sym_LBRACE] = ACTIONS(295),
    [anon_sym_COLON] = ACTIONS(295),
    [anon_sym_COMMA] = ACTIONS(295),
    [anon_sym_RBRACE] = ACTIONS(295),
    [anon_sym_SEMI] = ACTIONS(295),
    [anon_sym_if] = ACTIONS(297),
    [anon_sym_AT] = ACTIONS(295),
    [anon_sym_LBRACK] = ACTIONS(295),
    [anon_sym_STAR] = ACTIONS(297),
    [anon_sym_LT_EQ_GT] = ACTIONS(295),
    [anon_sym_LPAREN] = ACTIONS(295),
    [anon_sym_RPAREN] = ACTIONS(295),
    [anon_sym_LT] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(297),
    [anon_sym_EQ] = ACTIONS(297),
    [anon_sym_PLUS_EQ] = ACTIONS(295),
    [anon_sym_DASH_EQ] = ACTIONS(295),
    [anon_sym_STAR_EQ] = ACTIONS(295),
    [anon_sym_SLASH_EQ] = ACTIONS(295),
    [anon_sym_PERCENT_EQ] = ACTIONS(295),
    [anon_sym_AMP_EQ] = ACTIONS(295),
    [anon_sym_PIPE_EQ] = ACTIONS(295),
    [anon_sym_CARET_EQ] = ACTIONS(295),
    [anon_sym_LT_LT_EQ] = ACTIONS(295),
    [anon_sym_GT_GT_EQ] = ACTIONS(295),
    [anon_sym_DOT] = ACTIONS(295),
    [anon_sym_true] = ACTIONS(297),
    [anon_sym_false] = ACTIONS(297),
    [anon_sym_DASH] = ACTIONS(297),
    [anon_sym_BANG] = ACTIONS(297),
    [anon_sym_AMP_AMP] = ACTIONS(295),
    [anon_sym_PIPE_PIPE] = ACTIONS(295),
    [anon_sym_AMP] = ACTIONS(297),
    [anon_sym_PIPE] = ACTIONS(297),
    [anon_sym_CARET] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(295),
    [anon_sym_BANG_EQ] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT_EQ] = ACTIONS(295),
    [anon_sym_LT_LT] = ACTIONS(297),
    [anon_sym_GT_GT] = ACTIONS(297),
    [anon_sym_PLUS] = ACTIONS(297),
    [anon_sym_SLASH] = ACTIONS(297),
    [anon_sym_QMARK] = ACTIONS(295),
    [anon_sym_DQUOTE] = ACTIONS(295),
    [anon_sym_SQUOTE] = ACTIONS(295),
    [sym__ident_reg] = ACTIONS(297),
    [anon_sym_POUND] = ACTIONS(295),
    [sym_int_literal] = ACTIONS(297),
    [sym_float_literal] = ACTIONS(295),
    [anon_sym_px] = ACTIONS(299),
    [anon_sym_ms] = ACTIONS(299),
    [anon_sym_PERCENT] = ACTIONS(299),
    [anon_sym_deg] = ACTIONS(299),
    [anon_sym_rad] = ACTIONS(299),
    [anon_sym_ease] = ACTIONS(297),
    [anon_sym_ease_DASHin] = ACTIONS(297),
    [anon_sym_ease_in] = ACTIONS(297),
    [anon_sym_ease_in_out] = ACTIONS(297),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(297),
    [anon_sym_ease_out] = ACTIONS(297),
    [anon_sym_ease_DASHout] = ACTIONS(297),
    [anon_sym_start] = ACTIONS(297),
    [anon_sym_end] = ACTIONS(297),
    [anon_sym_black] = ACTIONS(297),
    [anon_sym_blue] = ACTIONS(297),
    [anon_sym_green] = ACTIONS(297),
    [anon_sym_red] = ACTIONS(297),
    [anon_sym_yellow] = ACTIONS(297),
    [anon_sym_white] = ACTIONS(297),
    [anon_sym_gray] = ACTIONS(297),
    [anon_sym_transparent] = ACTIONS(297),
    [anon_sym_angle] = ACTIONS(297),
    [anon_sym_bool] = ACTIONS(297),
    [anon_sym_brush] = ACTIONS(297),
    [anon_sym_color] = ACTIONS(297),
    [anon_sym_float] = ACTIONS(297),
    [anon_sym_image] = ACTIONS(297),
    [anon_sym_int] = ACTIONS(297),
    [anon_sym_length] = ACTIONS(297),
    [anon_sym_percent] = ACTIONS(297),
    [anon_sym_physical_DASHlength] = ACTIONS(297),
    [anon_sym_physical_length] = ACTIONS(297),
    [anon_sym_string] = ACTIONS(297),
    [anon_sym_debug] = ACTIONS(297),
    [anon_sym_animation_DASHtick] = ACTIONS(297),
    [anon_sym_min] = ACTIONS(297),
    [anon_sym_max] = ACTIONS(297),
    [anon_sym_mod] = ACTIONS(297),
    [anon_sym_abs] = ACTIONS(297),
    [anon_sym_round] = ACTIONS(297),
    [anon_sym_ceil] = ACTIONS(297),
    [anon_sym_floor] = ACTIONS(297),
    [anon_sym_sin] = ACTIONS(297),
    [anon_sym_cos] = ACTIONS(297),
    [anon_sym_tan] = ACTIONS(297),
    [anon_sym_asin] = ACTIONS(297),
    [anon_sym_acos] = ACTIONS(297),
    [anon_sym_atan] = ACTIONS(297),
    [anon_sym_sqrt] = ACTIONS(297),
    [anon_sym_pow] = ACTIONS(297),
    [anon_sym_log] = ACTIONS(297),
    [anon_sym_rgb] = ACTIONS(297),
    [anon_sym_easing] = ACTIONS(297),
    [anon_sym_duration] = ACTIONS(297),
    [anon_sym_parent] = ACTIONS(297),
    [anon_sym_root] = ACTIONS(297),
    [sym_comment] = ACTIONS(3),
  },
  [24] = {
    [sym_function_call_args] = STATE(50),
    [anon_sym_LBRACE] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(301),
    [anon_sym_COMMA] = ACTIONS(301),
    [anon_sym_RBRACE] = ACTIONS(301),
    [anon_sym_SEMI] = ACTIONS(301),
    [anon_sym_if] = ACTIONS(303),
    [anon_sym_AT] = ACTIONS(301),
    [anon_sym_LBRACK] = ACTIONS(305),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_LT_EQ_GT] = ACTIONS(301),
    [anon_sym_LPAREN] = ACTIONS(307),
    [anon_sym_RPAREN] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(303),
    [anon_sym_GT] = ACTIONS(303),
    [anon_sym_EQ] = ACTIONS(303),
    [anon_sym_PLUS_EQ] = ACTIONS(301),
    [anon_sym_DASH_EQ] = ACTIONS(301),
    [anon_sym_STAR_EQ] = ACTIONS(301),
    [anon_sym_SLASH_EQ] = ACTIONS(301),
    [anon_sym_PERCENT_EQ] = ACTIONS(301),
    [anon_sym_AMP_EQ] = ACTIONS(301),
    [anon_sym_PIPE_EQ] = ACTIONS(301),
    [anon_sym_CARET_EQ] = ACTIONS(301),
    [anon_sym_LT_LT_EQ] = ACTIONS(301),
    [anon_sym_GT_GT_EQ] = ACTIONS(301),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(303),
    [anon_sym_false] = ACTIONS(303),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(303),
    [anon_sym_AMP_AMP] = ACTIONS(301),
    [anon_sym_PIPE_PIPE] = ACTIONS(301),
    [anon_sym_AMP] = ACTIONS(303),
    [anon_sym_PIPE] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [anon_sym_EQ_EQ] = ACTIONS(301),
    [anon_sym_BANG_EQ] = ACTIONS(301),
    [anon_sym_LT_EQ] = ACTIONS(303),
    [anon_sym_GT_EQ] = ACTIONS(301),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(37),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [sym__ident_reg] = ACTIONS(303),
    [anon_sym_POUND] = ACTIONS(301),
    [sym_int_literal] = ACTIONS(303),
    [sym_float_literal] = ACTIONS(301),
    [anon_sym_ease] = ACTIONS(303),
    [anon_sym_ease_DASHin] = ACTIONS(303),
    [anon_sym_ease_in] = ACTIONS(303),
    [anon_sym_ease_in_out] = ACTIONS(303),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(303),
    [anon_sym_ease_out] = ACTIONS(303),
    [anon_sym_ease_DASHout] = ACTIONS(303),
    [anon_sym_start] = ACTIONS(303),
    [anon_sym_end] = ACTIONS(303),
    [anon_sym_black] = ACTIONS(303),
    [anon_sym_blue] = ACTIONS(303),
    [anon_sym_green] = ACTIONS(303),
    [anon_sym_red] = ACTIONS(303),
    [anon_sym_yellow] = ACTIONS(303),
    [anon_sym_white] = ACTIONS(303),
    [anon_sym_gray] = ACTIONS(303),
    [anon_sym_transparent] = ACTIONS(303),
    [anon_sym_angle] = ACTIONS(303),
    [anon_sym_bool] = ACTIONS(303),
    [anon_sym_brush] = ACTIONS(303),
    [anon_sym_color] = ACTIONS(303),
    [anon_sym_float] = ACTIONS(303),
    [anon_sym_image] = ACTIONS(303),
    [anon_sym_int] = ACTIONS(303),
    [anon_sym_length] = ACTIONS(303),
    [anon_sym_percent] = ACTIONS(303),
    [anon_sym_physical_DASHlength] = ACTIONS(303),
    [anon_sym_physical_length] = ACTIONS(303),
    [anon_sym_string] = ACTIONS(303),
    [anon_sym_debug] = ACTIONS(303),
    [anon_sym_animation_DASHtick] = ACTIONS(303),
    [anon_sym_min] = ACTIONS(303),
    [anon_sym_max] = ACTIONS(303),
    [anon_sym_mod] = ACTIONS(303),
    [anon_sym_abs] = ACTIONS(303),
    [anon_sym_round] = ACTIONS(303),
    [anon_sym_ceil] = ACTIONS(303),
    [anon_sym_floor] = ACTIONS(303),
    [anon_sym_sin] = ACTIONS(303),
    [anon_sym_cos] = ACTIONS(303),
    [anon_sym_tan] = ACTIONS(303),
    [anon_sym_asin] = ACTIONS(303),
    [anon_sym_acos] = ACTIONS(303),
    [anon_sym_atan] = ACTIONS(303),
    [anon_sym_sqrt] = ACTIONS(303),
    [anon_sym_pow] = ACTIONS(303),
    [anon_sym_log] = ACTIONS(303),
    [anon_sym_rgb] = ACTIONS(303),
    [anon_sym_easing] = ACTIONS(303),
    [anon_sym_duration] = ACTIONS(303),
    [anon_sym_parent] = ACTIONS(303),
    [anon_sym_root] = ACTIONS(303),
    [sym_comment] = ACTIONS(3),
  },
  [25] = {
    [sym_function_call_args] = STATE(50),
    [anon_sym_LBRACE] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(301),
    [anon_sym_COMMA] = ACTIONS(301),
    [anon_sym_RBRACE] = ACTIONS(301),
    [anon_sym_SEMI] = ACTIONS(301),
    [anon_sym_if] = ACTIONS(303),
    [anon_sym_AT] = ACTIONS(301),
    [anon_sym_LBRACK] = ACTIONS(305),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_LT_EQ_GT] = ACTIONS(301),
    [anon_sym_LPAREN] = ACTIONS(307),
    [anon_sym_RPAREN] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(303),
    [anon_sym_GT] = ACTIONS(303),
    [anon_sym_EQ] = ACTIONS(303),
    [anon_sym_PLUS_EQ] = ACTIONS(301),
    [anon_sym_DASH_EQ] = ACTIONS(301),
    [anon_sym_STAR_EQ] = ACTIONS(301),
    [anon_sym_SLASH_EQ] = ACTIONS(301),
    [anon_sym_PERCENT_EQ] = ACTIONS(301),
    [anon_sym_AMP_EQ] = ACTIONS(301),
    [anon_sym_PIPE_EQ] = ACTIONS(301),
    [anon_sym_CARET_EQ] = ACTIONS(301),
    [anon_sym_LT_LT_EQ] = ACTIONS(301),
    [anon_sym_GT_GT_EQ] = ACTIONS(301),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(303),
    [anon_sym_false] = ACTIONS(303),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(303),
    [anon_sym_AMP_AMP] = ACTIONS(301),
    [anon_sym_PIPE_PIPE] = ACTIONS(301),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [anon_sym_EQ_EQ] = ACTIONS(301),
    [anon_sym_BANG_EQ] = ACTIONS(301),
    [anon_sym_LT_EQ] = ACTIONS(303),
    [anon_sym_GT_EQ] = ACTIONS(301),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(37),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [sym__ident_reg] = ACTIONS(303),
    [anon_sym_POUND] = ACTIONS(301),
    [sym_int_literal] = ACTIONS(303),
    [sym_float_literal] = ACTIONS(301),
    [anon_sym_ease] = ACTIONS(303),
    [anon_sym_ease_DASHin] = ACTIONS(303),
    [anon_sym_ease_in] = ACTIONS(303),
    [anon_sym_ease_in_out] = ACTIONS(303),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(303),
    [anon_sym_ease_out] = ACTIONS(303),
    [anon_sym_ease_DASHout] = ACTIONS(303),
    [anon_sym_start] = ACTIONS(303),
    [anon_sym_end] = ACTIONS(303),
    [anon_sym_black] = ACTIONS(303),
    [anon_sym_blue] = ACTIONS(303),
    [anon_sym_green] = ACTIONS(303),
    [anon_sym_red] = ACTIONS(303),
    [anon_sym_yellow] = ACTIONS(303),
    [anon_sym_white] = ACTIONS(303),
    [anon_sym_gray] = ACTIONS(303),
    [anon_sym_transparent] = ACTIONS(303),
    [anon_sym_angle] = ACTIONS(303),
    [anon_sym_bool] = ACTIONS(303),
    [anon_sym_brush] = ACTIONS(303),
    [anon_sym_color] = ACTIONS(303),
    [anon_sym_float] = ACTIONS(303),
    [anon_sym_image] = ACTIONS(303),
    [anon_sym_int] = ACTIONS(303),
    [anon_sym_length] = ACTIONS(303),
    [anon_sym_percent] = ACTIONS(303),
    [anon_sym_physical_DASHlength] = ACTIONS(303),
    [anon_sym_physical_length] = ACTIONS(303),
    [anon_sym_string] = ACTIONS(303),
    [anon_sym_debug] = ACTIONS(303),
    [anon_sym_animation_DASHtick] = ACTIONS(303),
    [anon_sym_min] = ACTIONS(303),
    [anon_sym_max] = ACTIONS(303),
    [anon_sym_mod] = ACTIONS(303),
    [anon_sym_abs] = ACTIONS(303),
    [anon_sym_round] = ACTIONS(303),
    [anon_sym_ceil] = ACTIONS(303),
    [anon_sym_floor] = ACTIONS(303),
    [anon_sym_sin] = ACTIONS(303),
    [anon_sym_cos] = ACTIONS(303),
    [anon_sym_tan] = ACTIONS(303),
    [anon_sym_asin] = ACTIONS(303),
    [anon_sym_acos] = ACTIONS(303),
    [anon_sym_atan] = ACTIONS(303),
    [anon_sym_sqrt] = ACTIONS(303),
    [anon_sym_pow] = ACTIONS(303),
    [anon_sym_log] = ACTIONS(303),
    [anon_sym_rgb] = ACTIONS(303),
    [anon_sym_easing] = ACTIONS(303),
    [anon_sym_duration] = ACTIONS(303),
    [anon_sym_parent] = ACTIONS(303),
    [anon_sym_root] = ACTIONS(303),
    [sym_comment] = ACTIONS(3),
  },
  [26] = {
    [anon_sym_LBRACE] = ACTIONS(309),
    [anon_sym_COLON] = ACTIONS(309),
    [anon_sym_COMMA] = ACTIONS(309),
    [anon_sym_RBRACE] = ACTIONS(309),
    [anon_sym_SEMI] = ACTIONS(309),
    [anon_sym_if] = ACTIONS(311),
    [anon_sym_AT] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_STAR] = ACTIONS(311),
    [anon_sym_LT_EQ_GT] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_RPAREN] = ACTIONS(309),
    [anon_sym_LT] = ACTIONS(311),
    [anon_sym_GT] = ACTIONS(311),
    [anon_sym_else] = ACTIONS(311),
    [anon_sym_EQ] = ACTIONS(311),
    [anon_sym_PLUS_EQ] = ACTIONS(309),
    [anon_sym_DASH_EQ] = ACTIONS(309),
    [anon_sym_STAR_EQ] = ACTIONS(309),
    [anon_sym_SLASH_EQ] = ACTIONS(309),
    [anon_sym_PERCENT_EQ] = ACTIONS(309),
    [anon_sym_AMP_EQ] = ACTIONS(309),
    [anon_sym_PIPE_EQ] = ACTIONS(309),
    [anon_sym_CARET_EQ] = ACTIONS(309),
    [anon_sym_LT_LT_EQ] = ACTIONS(309),
    [anon_sym_GT_GT_EQ] = ACTIONS(309),
    [anon_sym_DOT] = ACTIONS(309),
    [anon_sym_true] = ACTIONS(311),
    [anon_sym_false] = ACTIONS(311),
    [anon_sym_DASH] = ACTIONS(311),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_AMP_AMP] = ACTIONS(309),
    [anon_sym_PIPE_PIPE] = ACTIONS(309),
    [anon_sym_AMP] = ACTIONS(311),
    [anon_sym_PIPE] = ACTIONS(311),
    [anon_sym_CARET] = ACTIONS(311),
    [anon_sym_EQ_EQ] = ACTIONS(309),
    [anon_sym_BANG_EQ] = ACTIONS(309),
    [anon_sym_LT_EQ] = ACTIONS(311),
    [anon_sym_GT_EQ] = ACTIONS(309),
    [anon_sym_LT_LT] = ACTIONS(311),
    [anon_sym_GT_GT] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(311),
    [anon_sym_SLASH] = ACTIONS(311),
    [anon_sym_QMARK] = ACTIONS(309),
    [anon_sym_DQUOTE] = ACTIONS(309),
    [anon_sym_SQUOTE] = ACTIONS(309),
    [sym__ident_reg] = ACTIONS(311),
    [anon_sym_POUND] = ACTIONS(309),
    [sym_int_literal] = ACTIONS(311),
    [sym_float_literal] = ACTIONS(309),
    [anon_sym_ease] = ACTIONS(311),
    [anon_sym_ease_DASHin] = ACTIONS(311),
    [anon_sym_ease_in] = ACTIONS(311),
    [anon_sym_ease_in_out] = ACTIONS(311),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(311),
    [anon_sym_ease_out] = ACTIONS(311),
    [anon_sym_ease_DASHout] = ACTIONS(311),
    [anon_sym_start] = ACTIONS(311),
    [anon_sym_end] = ACTIONS(311),
    [anon_sym_black] = ACTIONS(311),
    [anon_sym_blue] = ACTIONS(311),
    [anon_sym_green] = ACTIONS(311),
    [anon_sym_red] = ACTIONS(311),
    [anon_sym_yellow] = ACTIONS(311),
    [anon_sym_white] = ACTIONS(311),
    [anon_sym_gray] = ACTIONS(311),
    [anon_sym_transparent] = ACTIONS(311),
    [anon_sym_angle] = ACTIONS(311),
    [anon_sym_bool] = ACTIONS(311),
    [anon_sym_brush] = ACTIONS(311),
    [anon_sym_color] = ACTIONS(311),
    [anon_sym_float] = ACTIONS(311),
    [anon_sym_image] = ACTIONS(311),
    [anon_sym_int] = ACTIONS(311),
    [anon_sym_length] = ACTIONS(311),
    [anon_sym_percent] = ACTIONS(311),
    [anon_sym_physical_DASHlength] = ACTIONS(311),
    [anon_sym_physical_length] = ACTIONS(311),
    [anon_sym_string] = ACTIONS(311),
    [anon_sym_debug] = ACTIONS(311),
    [anon_sym_animation_DASHtick] = ACTIONS(311),
    [anon_sym_min] = ACTIONS(311),
    [anon_sym_max] = ACTIONS(311),
    [anon_sym_mod] = ACTIONS(311),
    [anon_sym_abs] = ACTIONS(311),
    [anon_sym_round] = ACTIONS(311),
    [anon_sym_ceil] = ACTIONS(311),
    [anon_sym_floor] = ACTIONS(311),
    [anon_sym_sin] = ACTIONS(311),
    [anon_sym_cos] = ACTIONS(311),
    [anon_sym_tan] = ACTIONS(311),
    [anon_sym_asin] = ACTIONS(311),
    [anon_sym_acos] = ACTIONS(311),
    [anon_sym_atan] = ACTIONS(311),
    [anon_sym_sqrt] = ACTIONS(311),
    [anon_sym_pow] = ACTIONS(311),
    [anon_sym_log] = ACTIONS(311),
    [anon_sym_rgb] = ACTIONS(311),
    [anon_sym_easing] = ACTIONS(311),
    [anon_sym_duration] = ACTIONS(311),
    [anon_sym_parent] = ACTIONS(311),
    [anon_sym_root] = ACTIONS(311),
    [sym_comment] = ACTIONS(3),
  },
  [27] = {
    [sym_function_call_args] = STATE(50),
    [anon_sym_LBRACE] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(301),
    [anon_sym_COMMA] = ACTIONS(301),
    [anon_sym_RBRACE] = ACTIONS(301),
    [anon_sym_SEMI] = ACTIONS(301),
    [anon_sym_if] = ACTIONS(303),
    [anon_sym_AT] = ACTIONS(301),
    [anon_sym_LBRACK] = ACTIONS(305),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_LT_EQ_GT] = ACTIONS(301),
    [anon_sym_LPAREN] = ACTIONS(307),
    [anon_sym_RPAREN] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(303),
    [anon_sym_GT] = ACTIONS(303),
    [anon_sym_EQ] = ACTIONS(303),
    [anon_sym_PLUS_EQ] = ACTIONS(301),
    [anon_sym_DASH_EQ] = ACTIONS(301),
    [anon_sym_STAR_EQ] = ACTIONS(301),
    [anon_sym_SLASH_EQ] = ACTIONS(301),
    [anon_sym_PERCENT_EQ] = ACTIONS(301),
    [anon_sym_AMP_EQ] = ACTIONS(301),
    [anon_sym_PIPE_EQ] = ACTIONS(301),
    [anon_sym_CARET_EQ] = ACTIONS(301),
    [anon_sym_LT_LT_EQ] = ACTIONS(301),
    [anon_sym_GT_GT_EQ] = ACTIONS(301),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(303),
    [anon_sym_false] = ACTIONS(303),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(303),
    [anon_sym_AMP_AMP] = ACTIONS(301),
    [anon_sym_PIPE_PIPE] = ACTIONS(301),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(63),
    [anon_sym_EQ_EQ] = ACTIONS(301),
    [anon_sym_BANG_EQ] = ACTIONS(301),
    [anon_sym_LT_EQ] = ACTIONS(303),
    [anon_sym_GT_EQ] = ACTIONS(301),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(37),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [sym__ident_reg] = ACTIONS(303),
    [anon_sym_POUND] = ACTIONS(301),
    [sym_int_literal] = ACTIONS(303),
    [sym_float_literal] = ACTIONS(301),
    [anon_sym_ease] = ACTIONS(303),
    [anon_sym_ease_DASHin] = ACTIONS(303),
    [anon_sym_ease_in] = ACTIONS(303),
    [anon_sym_ease_in_out] = ACTIONS(303),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(303),
    [anon_sym_ease_out] = ACTIONS(303),
    [anon_sym_ease_DASHout] = ACTIONS(303),
    [anon_sym_start] = ACTIONS(303),
    [anon_sym_end] = ACTIONS(303),
    [anon_sym_black] = ACTIONS(303),
    [anon_sym_blue] = ACTIONS(303),
    [anon_sym_green] = ACTIONS(303),
    [anon_sym_red] = ACTIONS(303),
    [anon_sym_yellow] = ACTIONS(303),
    [anon_sym_white] = ACTIONS(303),
    [anon_sym_gray] = ACTIONS(303),
    [anon_sym_transparent] = ACTIONS(303),
    [anon_sym_angle] = ACTIONS(303),
    [anon_sym_bool] = ACTIONS(303),
    [anon_sym_brush] = ACTIONS(303),
    [anon_sym_color] = ACTIONS(303),
    [anon_sym_float] = ACTIONS(303),
    [anon_sym_image] = ACTIONS(303),
    [anon_sym_int] = ACTIONS(303),
    [anon_sym_length] = ACTIONS(303),
    [anon_sym_percent] = ACTIONS(303),
    [anon_sym_physical_DASHlength] = ACTIONS(303),
    [anon_sym_physical_length] = ACTIONS(303),
    [anon_sym_string] = ACTIONS(303),
    [anon_sym_debug] = ACTIONS(303),
    [anon_sym_animation_DASHtick] = ACTIONS(303),
    [anon_sym_min] = ACTIONS(303),
    [anon_sym_max] = ACTIONS(303),
    [anon_sym_mod] = ACTIONS(303),
    [anon_sym_abs] = ACTIONS(303),
    [anon_sym_round] = ACTIONS(303),
    [anon_sym_ceil] = ACTIONS(303),
    [anon_sym_floor] = ACTIONS(303),
    [anon_sym_sin] = ACTIONS(303),
    [anon_sym_cos] = ACTIONS(303),
    [anon_sym_tan] = ACTIONS(303),
    [anon_sym_asin] = ACTIONS(303),
    [anon_sym_acos] = ACTIONS(303),
    [anon_sym_atan] = ACTIONS(303),
    [anon_sym_sqrt] = ACTIONS(303),
    [anon_sym_pow] = ACTIONS(303),
    [anon_sym_log] = ACTIONS(303),
    [anon_sym_rgb] = ACTIONS(303),
    [anon_sym_easing] = ACTIONS(303),
    [anon_sym_duration] = ACTIONS(303),
    [anon_sym_parent] = ACTIONS(303),
    [anon_sym_root] = ACTIONS(303),
    [sym_comment] = ACTIONS(3),
  },
  [28] = {
    [sym_function_call_args] = STATE(50),
    [anon_sym_LBRACE] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(301),
    [anon_sym_COMMA] = ACTIONS(301),
    [anon_sym_RBRACE] = ACTIONS(301),
    [anon_sym_SEMI] = ACTIONS(301),
    [anon_sym_if] = ACTIONS(303),
    [anon_sym_AT] = ACTIONS(301),
    [anon_sym_LBRACK] = ACTIONS(305),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_LT_EQ_GT] = ACTIONS(301),
    [anon_sym_LPAREN] = ACTIONS(307),
    [anon_sym_RPAREN] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(41),
    [anon_sym_EQ] = ACTIONS(303),
    [anon_sym_PLUS_EQ] = ACTIONS(301),
    [anon_sym_DASH_EQ] = ACTIONS(301),
    [anon_sym_STAR_EQ] = ACTIONS(301),
    [anon_sym_SLASH_EQ] = ACTIONS(301),
    [anon_sym_PERCENT_EQ] = ACTIONS(301),
    [anon_sym_AMP_EQ] = ACTIONS(301),
    [anon_sym_PIPE_EQ] = ACTIONS(301),
    [anon_sym_CARET_EQ] = ACTIONS(301),
    [anon_sym_LT_LT_EQ] = ACTIONS(301),
    [anon_sym_GT_GT_EQ] = ACTIONS(301),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(303),
    [anon_sym_false] = ACTIONS(303),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(303),
    [anon_sym_AMP_AMP] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(301),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_CARET] = ACTIONS(63),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT_EQ] = ACTIONS(41),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(37),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [sym__ident_reg] = ACTIONS(303),
    [anon_sym_POUND] = ACTIONS(301),
    [sym_int_literal] = ACTIONS(303),
    [sym_float_literal] = ACTIONS(301),
    [anon_sym_ease] = ACTIONS(303),
    [anon_sym_ease_DASHin] = ACTIONS(303),
    [anon_sym_ease_in] = ACTIONS(303),
    [anon_sym_ease_in_out] = ACTIONS(303),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(303),
    [anon_sym_ease_out] = ACTIONS(303),
    [anon_sym_ease_DASHout] = ACTIONS(303),
    [anon_sym_start] = ACTIONS(303),
    [anon_sym_end] = ACTIONS(303),
    [anon_sym_black] = ACTIONS(303),
    [anon_sym_blue] = ACTIONS(303),
    [anon_sym_green] = ACTIONS(303),
    [anon_sym_red] = ACTIONS(303),
    [anon_sym_yellow] = ACTIONS(303),
    [anon_sym_white] = ACTIONS(303),
    [anon_sym_gray] = ACTIONS(303),
    [anon_sym_transparent] = ACTIONS(303),
    [anon_sym_angle] = ACTIONS(303),
    [anon_sym_bool] = ACTIONS(303),
    [anon_sym_brush] = ACTIONS(303),
    [anon_sym_color] = ACTIONS(303),
    [anon_sym_float] = ACTIONS(303),
    [anon_sym_image] = ACTIONS(303),
    [anon_sym_int] = ACTIONS(303),
    [anon_sym_length] = ACTIONS(303),
    [anon_sym_percent] = ACTIONS(303),
    [anon_sym_physical_DASHlength] = ACTIONS(303),
    [anon_sym_physical_length] = ACTIONS(303),
    [anon_sym_string] = ACTIONS(303),
    [anon_sym_debug] = ACTIONS(303),
    [anon_sym_animation_DASHtick] = ACTIONS(303),
    [anon_sym_min] = ACTIONS(303),
    [anon_sym_max] = ACTIONS(303),
    [anon_sym_mod] = ACTIONS(303),
    [anon_sym_abs] = ACTIONS(303),
    [anon_sym_round] = ACTIONS(303),
    [anon_sym_ceil] = ACTIONS(303),
    [anon_sym_floor] = ACTIONS(303),
    [anon_sym_sin] = ACTIONS(303),
    [anon_sym_cos] = ACTIONS(303),
    [anon_sym_tan] = ACTIONS(303),
    [anon_sym_asin] = ACTIONS(303),
    [anon_sym_acos] = ACTIONS(303),
    [anon_sym_atan] = ACTIONS(303),
    [anon_sym_sqrt] = ACTIONS(303),
    [anon_sym_pow] = ACTIONS(303),
    [anon_sym_log] = ACTIONS(303),
    [anon_sym_rgb] = ACTIONS(303),
    [anon_sym_easing] = ACTIONS(303),
    [anon_sym_duration] = ACTIONS(303),
    [anon_sym_parent] = ACTIONS(303),
    [anon_sym_root] = ACTIONS(303),
    [sym_comment] = ACTIONS(3),
  },
  [29] = {
    [sym_function_call_args] = STATE(50),
    [anon_sym_LBRACE] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(301),
    [anon_sym_COMMA] = ACTIONS(301),
    [anon_sym_RBRACE] = ACTIONS(301),
    [anon_sym_SEMI] = ACTIONS(301),
    [anon_sym_if] = ACTIONS(303),
    [anon_sym_AT] = ACTIONS(301),
    [anon_sym_LBRACK] = ACTIONS(305),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_LT_EQ_GT] = ACTIONS(301),
    [anon_sym_LPAREN] = ACTIONS(307),
    [anon_sym_RPAREN] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(41),
    [anon_sym_EQ] = ACTIONS(303),
    [anon_sym_PLUS_EQ] = ACTIONS(301),
    [anon_sym_DASH_EQ] = ACTIONS(301),
    [anon_sym_STAR_EQ] = ACTIONS(301),
    [anon_sym_SLASH_EQ] = ACTIONS(301),
    [anon_sym_PERCENT_EQ] = ACTIONS(301),
    [anon_sym_AMP_EQ] = ACTIONS(301),
    [anon_sym_PIPE_EQ] = ACTIONS(301),
    [anon_sym_CARET_EQ] = ACTIONS(301),
    [anon_sym_LT_LT_EQ] = ACTIONS(301),
    [anon_sym_GT_GT_EQ] = ACTIONS(301),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(303),
    [anon_sym_false] = ACTIONS(303),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(303),
    [anon_sym_AMP_AMP] = ACTIONS(301),
    [anon_sym_PIPE_PIPE] = ACTIONS(301),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_CARET] = ACTIONS(63),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT_EQ] = ACTIONS(41),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(37),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [sym__ident_reg] = ACTIONS(303),
    [anon_sym_POUND] = ACTIONS(301),
    [sym_int_literal] = ACTIONS(303),
    [sym_float_literal] = ACTIONS(301),
    [anon_sym_ease] = ACTIONS(303),
    [anon_sym_ease_DASHin] = ACTIONS(303),
    [anon_sym_ease_in] = ACTIONS(303),
    [anon_sym_ease_in_out] = ACTIONS(303),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(303),
    [anon_sym_ease_out] = ACTIONS(303),
    [anon_sym_ease_DASHout] = ACTIONS(303),
    [anon_sym_start] = ACTIONS(303),
    [anon_sym_end] = ACTIONS(303),
    [anon_sym_black] = ACTIONS(303),
    [anon_sym_blue] = ACTIONS(303),
    [anon_sym_green] = ACTIONS(303),
    [anon_sym_red] = ACTIONS(303),
    [anon_sym_yellow] = ACTIONS(303),
    [anon_sym_white] = ACTIONS(303),
    [anon_sym_gray] = ACTIONS(303),
    [anon_sym_transparent] = ACTIONS(303),
    [anon_sym_angle] = ACTIONS(303),
    [anon_sym_bool] = ACTIONS(303),
    [anon_sym_brush] = ACTIONS(303),
    [anon_sym_color] = ACTIONS(303),
    [anon_sym_float] = ACTIONS(303),
    [anon_sym_image] = ACTIONS(303),
    [anon_sym_int] = ACTIONS(303),
    [anon_sym_length] = ACTIONS(303),
    [anon_sym_percent] = ACTIONS(303),
    [anon_sym_physical_DASHlength] = ACTIONS(303),
    [anon_sym_physical_length] = ACTIONS(303),
    [anon_sym_string] = ACTIONS(303),
    [anon_sym_debug] = ACTIONS(303),
    [anon_sym_animation_DASHtick] = ACTIONS(303),
    [anon_sym_min] = ACTIONS(303),
    [anon_sym_max] = ACTIONS(303),
    [anon_sym_mod] = ACTIONS(303),
    [anon_sym_abs] = ACTIONS(303),
    [anon_sym_round] = ACTIONS(303),
    [anon_sym_ceil] = ACTIONS(303),
    [anon_sym_floor] = ACTIONS(303),
    [anon_sym_sin] = ACTIONS(303),
    [anon_sym_cos] = ACTIONS(303),
    [anon_sym_tan] = ACTIONS(303),
    [anon_sym_asin] = ACTIONS(303),
    [anon_sym_acos] = ACTIONS(303),
    [anon_sym_atan] = ACTIONS(303),
    [anon_sym_sqrt] = ACTIONS(303),
    [anon_sym_pow] = ACTIONS(303),
    [anon_sym_log] = ACTIONS(303),
    [anon_sym_rgb] = ACTIONS(303),
    [anon_sym_easing] = ACTIONS(303),
    [anon_sym_duration] = ACTIONS(303),
    [anon_sym_parent] = ACTIONS(303),
    [anon_sym_root] = ACTIONS(303),
    [sym_comment] = ACTIONS(3),
  },
  [30] = {
    [sym_function_call_args] = STATE(50),
    [anon_sym_LBRACE] = ACTIONS(313),
    [anon_sym_COLON] = ACTIONS(313),
    [anon_sym_COMMA] = ACTIONS(313),
    [anon_sym_RBRACE] = ACTIONS(313),
    [anon_sym_SEMI] = ACTIONS(313),
    [anon_sym_if] = ACTIONS(315),
    [anon_sym_AT] = ACTIONS(313),
    [anon_sym_LBRACK] = ACTIONS(305),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_LT_EQ_GT] = ACTIONS(313),
    [anon_sym_LPAREN] = ACTIONS(307),
    [anon_sym_RPAREN] = ACTIONS(313),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(41),
    [anon_sym_EQ] = ACTIONS(315),
    [anon_sym_PLUS_EQ] = ACTIONS(313),
    [anon_sym_DASH_EQ] = ACTIONS(313),
    [anon_sym_STAR_EQ] = ACTIONS(313),
    [anon_sym_SLASH_EQ] = ACTIONS(313),
    [anon_sym_PERCENT_EQ] = ACTIONS(313),
    [anon_sym_AMP_EQ] = ACTIONS(313),
    [anon_sym_PIPE_EQ] = ACTIONS(313),
    [anon_sym_CARET_EQ] = ACTIONS(313),
    [anon_sym_LT_LT_EQ] = ACTIONS(313),
    [anon_sym_GT_GT_EQ] = ACTIONS(313),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(315),
    [anon_sym_false] = ACTIONS(315),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(315),
    [anon_sym_AMP_AMP] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_CARET] = ACTIONS(63),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT_EQ] = ACTIONS(41),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(37),
    [anon_sym_QMARK] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(313),
    [anon_sym_SQUOTE] = ACTIONS(313),
    [sym__ident_reg] = ACTIONS(315),
    [anon_sym_POUND] = ACTIONS(313),
    [sym_int_literal] = ACTIONS(315),
    [sym_float_literal] = ACTIONS(313),
    [anon_sym_ease] = ACTIONS(315),
    [anon_sym_ease_DASHin] = ACTIONS(315),
    [anon_sym_ease_in] = ACTIONS(315),
    [anon_sym_ease_in_out] = ACTIONS(315),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(315),
    [anon_sym_ease_out] = ACTIONS(315),
    [anon_sym_ease_DASHout] = ACTIONS(315),
    [anon_sym_start] = ACTIONS(315),
    [anon_sym_end] = ACTIONS(315),
    [anon_sym_black] = ACTIONS(315),
    [anon_sym_blue] = ACTIONS(315),
    [anon_sym_green] = ACTIONS(315),
    [anon_sym_red] = ACTIONS(315),
    [anon_sym_yellow] = ACTIONS(315),
    [anon_sym_white] = ACTIONS(315),
    [anon_sym_gray] = ACTIONS(315),
    [anon_sym_transparent] = ACTIONS(315),
    [anon_sym_angle] = ACTIONS(315),
    [anon_sym_bool] = ACTIONS(315),
    [anon_sym_brush] = ACTIONS(315),
    [anon_sym_color] = ACTIONS(315),
    [anon_sym_float] = ACTIONS(315),
    [anon_sym_image] = ACTIONS(315),
    [anon_sym_int] = ACTIONS(315),
    [anon_sym_length] = ACTIONS(315),
    [anon_sym_percent] = ACTIONS(315),
    [anon_sym_physical_DASHlength] = ACTIONS(315),
    [anon_sym_physical_length] = ACTIONS(315),
    [anon_sym_string] = ACTIONS(315),
    [anon_sym_debug] = ACTIONS(315),
    [anon_sym_animation_DASHtick] = ACTIONS(315),
    [anon_sym_min] = ACTIONS(315),
    [anon_sym_max] = ACTIONS(315),
    [anon_sym_mod] = ACTIONS(315),
    [anon_sym_abs] = ACTIONS(315),
    [anon_sym_round] = ACTIONS(315),
    [anon_sym_ceil] = ACTIONS(315),
    [anon_sym_floor] = ACTIONS(315),
    [anon_sym_sin] = ACTIONS(315),
    [anon_sym_cos] = ACTIONS(315),
    [anon_sym_tan] = ACTIONS(315),
    [anon_sym_asin] = ACTIONS(315),
    [anon_sym_acos] = ACTIONS(315),
    [anon_sym_atan] = ACTIONS(315),
    [anon_sym_sqrt] = ACTIONS(315),
    [anon_sym_pow] = ACTIONS(315),
    [anon_sym_log] = ACTIONS(315),
    [anon_sym_rgb] = ACTIONS(315),
    [anon_sym_easing] = ACTIONS(315),
    [anon_sym_duration] = ACTIONS(315),
    [anon_sym_parent] = ACTIONS(315),
    [anon_sym_root] = ACTIONS(315),
    [sym_comment] = ACTIONS(3),
  },
  [31] = {
    [sym_function_call_args] = STATE(50),
    [anon_sym_LBRACE] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(301),
    [anon_sym_COMMA] = ACTIONS(301),
    [anon_sym_RBRACE] = ACTIONS(301),
    [anon_sym_SEMI] = ACTIONS(301),
    [anon_sym_if] = ACTIONS(303),
    [anon_sym_AT] = ACTIONS(301),
    [anon_sym_LBRACK] = ACTIONS(305),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_LT_EQ_GT] = ACTIONS(301),
    [anon_sym_LPAREN] = ACTIONS(307),
    [anon_sym_RPAREN] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(303),
    [anon_sym_GT] = ACTIONS(303),
    [anon_sym_EQ] = ACTIONS(303),
    [anon_sym_PLUS_EQ] = ACTIONS(301),
    [anon_sym_DASH_EQ] = ACTIONS(301),
    [anon_sym_STAR_EQ] = ACTIONS(301),
    [anon_sym_SLASH_EQ] = ACTIONS(301),
    [anon_sym_PERCENT_EQ] = ACTIONS(301),
    [anon_sym_AMP_EQ] = ACTIONS(301),
    [anon_sym_PIPE_EQ] = ACTIONS(301),
    [anon_sym_CARET_EQ] = ACTIONS(301),
    [anon_sym_LT_LT_EQ] = ACTIONS(301),
    [anon_sym_GT_GT_EQ] = ACTIONS(301),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(303),
    [anon_sym_false] = ACTIONS(303),
    [anon_sym_DASH] = ACTIONS(303),
    [anon_sym_BANG] = ACTIONS(303),
    [anon_sym_AMP_AMP] = ACTIONS(301),
    [anon_sym_PIPE_PIPE] = ACTIONS(301),
    [anon_sym_AMP] = ACTIONS(303),
    [anon_sym_PIPE] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [anon_sym_EQ_EQ] = ACTIONS(301),
    [anon_sym_BANG_EQ] = ACTIONS(301),
    [anon_sym_LT_EQ] = ACTIONS(303),
    [anon_sym_GT_EQ] = ACTIONS(301),
    [anon_sym_LT_LT] = ACTIONS(303),
    [anon_sym_GT_GT] = ACTIONS(303),
    [anon_sym_PLUS] = ACTIONS(303),
    [anon_sym_SLASH] = ACTIONS(37),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [sym__ident_reg] = ACTIONS(303),
    [anon_sym_POUND] = ACTIONS(301),
    [sym_int_literal] = ACTIONS(303),
    [sym_float_literal] = ACTIONS(301),
    [anon_sym_ease] = ACTIONS(303),
    [anon_sym_ease_DASHin] = ACTIONS(303),
    [anon_sym_ease_in] = ACTIONS(303),
    [anon_sym_ease_in_out] = ACTIONS(303),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(303),
    [anon_sym_ease_out] = ACTIONS(303),
    [anon_sym_ease_DASHout] = ACTIONS(303),
    [anon_sym_start] = ACTIONS(303),
    [anon_sym_end] = ACTIONS(303),
    [anon_sym_black] = ACTIONS(303),
    [anon_sym_blue] = ACTIONS(303),
    [anon_sym_green] = ACTIONS(303),
    [anon_sym_red] = ACTIONS(303),
    [anon_sym_yellow] = ACTIONS(303),
    [anon_sym_white] = ACTIONS(303),
    [anon_sym_gray] = ACTIONS(303),
    [anon_sym_transparent] = ACTIONS(303),
    [anon_sym_angle] = ACTIONS(303),
    [anon_sym_bool] = ACTIONS(303),
    [anon_sym_brush] = ACTIONS(303),
    [anon_sym_color] = ACTIONS(303),
    [anon_sym_float] = ACTIONS(303),
    [anon_sym_image] = ACTIONS(303),
    [anon_sym_int] = ACTIONS(303),
    [anon_sym_length] = ACTIONS(303),
    [anon_sym_percent] = ACTIONS(303),
    [anon_sym_physical_DASHlength] = ACTIONS(303),
    [anon_sym_physical_length] = ACTIONS(303),
    [anon_sym_string] = ACTIONS(303),
    [anon_sym_debug] = ACTIONS(303),
    [anon_sym_animation_DASHtick] = ACTIONS(303),
    [anon_sym_min] = ACTIONS(303),
    [anon_sym_max] = ACTIONS(303),
    [anon_sym_mod] = ACTIONS(303),
    [anon_sym_abs] = ACTIONS(303),
    [anon_sym_round] = ACTIONS(303),
    [anon_sym_ceil] = ACTIONS(303),
    [anon_sym_floor] = ACTIONS(303),
    [anon_sym_sin] = ACTIONS(303),
    [anon_sym_cos] = ACTIONS(303),
    [anon_sym_tan] = ACTIONS(303),
    [anon_sym_asin] = ACTIONS(303),
    [anon_sym_acos] = ACTIONS(303),
    [anon_sym_atan] = ACTIONS(303),
    [anon_sym_sqrt] = ACTIONS(303),
    [anon_sym_pow] = ACTIONS(303),
    [anon_sym_log] = ACTIONS(303),
    [anon_sym_rgb] = ACTIONS(303),
    [anon_sym_easing] = ACTIONS(303),
    [anon_sym_duration] = ACTIONS(303),
    [anon_sym_parent] = ACTIONS(303),
    [anon_sym_root] = ACTIONS(303),
    [sym_comment] = ACTIONS(3),
  },
  [32] = {
    [sym_function_call_args] = STATE(50),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_COLON] = ACTIONS(317),
    [anon_sym_COMMA] = ACTIONS(317),
    [anon_sym_RBRACE] = ACTIONS(317),
    [anon_sym_SEMI] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(319),
    [anon_sym_AT] = ACTIONS(317),
    [anon_sym_LBRACK] = ACTIONS(305),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_LT_EQ_GT] = ACTIONS(317),
    [anon_sym_LPAREN] = ACTIONS(307),
    [anon_sym_RPAREN] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(41),
    [anon_sym_EQ] = ACTIONS(319),
    [anon_sym_PLUS_EQ] = ACTIONS(317),
    [anon_sym_DASH_EQ] = ACTIONS(317),
    [anon_sym_STAR_EQ] = ACTIONS(317),
    [anon_sym_SLASH_EQ] = ACTIONS(317),
    [anon_sym_PERCENT_EQ] = ACTIONS(317),
    [anon_sym_AMP_EQ] = ACTIONS(317),
    [anon_sym_PIPE_EQ] = ACTIONS(317),
    [anon_sym_CARET_EQ] = ACTIONS(317),
    [anon_sym_LT_LT_EQ] = ACTIONS(317),
    [anon_sym_GT_GT_EQ] = ACTIONS(317),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(319),
    [anon_sym_false] = ACTIONS(319),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(319),
    [anon_sym_AMP_AMP] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_CARET] = ACTIONS(63),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT_EQ] = ACTIONS(41),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(37),
    [anon_sym_QMARK] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(317),
    [anon_sym_SQUOTE] = ACTIONS(317),
    [sym__ident_reg] = ACTIONS(319),
    [anon_sym_POUND] = ACTIONS(317),
    [sym_int_literal] = ACTIONS(319),
    [sym_float_literal] = ACTIONS(317),
    [anon_sym_ease] = ACTIONS(319),
    [anon_sym_ease_DASHin] = ACTIONS(319),
    [anon_sym_ease_in] = ACTIONS(319),
    [anon_sym_ease_in_out] = ACTIONS(319),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(319),
    [anon_sym_ease_out] = ACTIONS(319),
    [anon_sym_ease_DASHout] = ACTIONS(319),
    [anon_sym_start] = ACTIONS(319),
    [anon_sym_end] = ACTIONS(319),
    [anon_sym_black] = ACTIONS(319),
    [anon_sym_blue] = ACTIONS(319),
    [anon_sym_green] = ACTIONS(319),
    [anon_sym_red] = ACTIONS(319),
    [anon_sym_yellow] = ACTIONS(319),
    [anon_sym_white] = ACTIONS(319),
    [anon_sym_gray] = ACTIONS(319),
    [anon_sym_transparent] = ACTIONS(319),
    [anon_sym_angle] = ACTIONS(319),
    [anon_sym_bool] = ACTIONS(319),
    [anon_sym_brush] = ACTIONS(319),
    [anon_sym_color] = ACTIONS(319),
    [anon_sym_float] = ACTIONS(319),
    [anon_sym_image] = ACTIONS(319),
    [anon_sym_int] = ACTIONS(319),
    [anon_sym_length] = ACTIONS(319),
    [anon_sym_percent] = ACTIONS(319),
    [anon_sym_physical_DASHlength] = ACTIONS(319),
    [anon_sym_physical_length] = ACTIONS(319),
    [anon_sym_string] = ACTIONS(319),
    [anon_sym_debug] = ACTIONS(319),
    [anon_sym_animation_DASHtick] = ACTIONS(319),
    [anon_sym_min] = ACTIONS(319),
    [anon_sym_max] = ACTIONS(319),
    [anon_sym_mod] = ACTIONS(319),
    [anon_sym_abs] = ACTIONS(319),
    [anon_sym_round] = ACTIONS(319),
    [anon_sym_ceil] = ACTIONS(319),
    [anon_sym_floor] = ACTIONS(319),
    [anon_sym_sin] = ACTIONS(319),
    [anon_sym_cos] = ACTIONS(319),
    [anon_sym_tan] = ACTIONS(319),
    [anon_sym_asin] = ACTIONS(319),
    [anon_sym_acos] = ACTIONS(319),
    [anon_sym_atan] = ACTIONS(319),
    [anon_sym_sqrt] = ACTIONS(319),
    [anon_sym_pow] = ACTIONS(319),
    [anon_sym_log] = ACTIONS(319),
    [anon_sym_rgb] = ACTIONS(319),
    [anon_sym_easing] = ACTIONS(319),
    [anon_sym_duration] = ACTIONS(319),
    [anon_sym_parent] = ACTIONS(319),
    [anon_sym_root] = ACTIONS(319),
    [sym_comment] = ACTIONS(3),
  },
  [33] = {
    [sym_function_call_args] = STATE(50),
    [anon_sym_LBRACE] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(301),
    [anon_sym_COMMA] = ACTIONS(301),
    [anon_sym_RBRACE] = ACTIONS(301),
    [anon_sym_SEMI] = ACTIONS(301),
    [anon_sym_if] = ACTIONS(303),
    [anon_sym_AT] = ACTIONS(301),
    [anon_sym_LBRACK] = ACTIONS(305),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_LT_EQ_GT] = ACTIONS(301),
    [anon_sym_LPAREN] = ACTIONS(307),
    [anon_sym_RPAREN] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(303),
    [anon_sym_GT] = ACTIONS(303),
    [anon_sym_EQ] = ACTIONS(303),
    [anon_sym_PLUS_EQ] = ACTIONS(301),
    [anon_sym_DASH_EQ] = ACTIONS(301),
    [anon_sym_STAR_EQ] = ACTIONS(301),
    [anon_sym_SLASH_EQ] = ACTIONS(301),
    [anon_sym_PERCENT_EQ] = ACTIONS(301),
    [anon_sym_AMP_EQ] = ACTIONS(301),
    [anon_sym_PIPE_EQ] = ACTIONS(301),
    [anon_sym_CARET_EQ] = ACTIONS(301),
    [anon_sym_LT_LT_EQ] = ACTIONS(301),
    [anon_sym_GT_GT_EQ] = ACTIONS(301),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(303),
    [anon_sym_false] = ACTIONS(303),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(303),
    [anon_sym_AMP_AMP] = ACTIONS(301),
    [anon_sym_PIPE_PIPE] = ACTIONS(301),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_CARET] = ACTIONS(63),
    [anon_sym_EQ_EQ] = ACTIONS(301),
    [anon_sym_BANG_EQ] = ACTIONS(301),
    [anon_sym_LT_EQ] = ACTIONS(303),
    [anon_sym_GT_EQ] = ACTIONS(301),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(37),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [sym__ident_reg] = ACTIONS(303),
    [anon_sym_POUND] = ACTIONS(301),
    [sym_int_literal] = ACTIONS(303),
    [sym_float_literal] = ACTIONS(301),
    [anon_sym_ease] = ACTIONS(303),
    [anon_sym_ease_DASHin] = ACTIONS(303),
    [anon_sym_ease_in] = ACTIONS(303),
    [anon_sym_ease_in_out] = ACTIONS(303),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(303),
    [anon_sym_ease_out] = ACTIONS(303),
    [anon_sym_ease_DASHout] = ACTIONS(303),
    [anon_sym_start] = ACTIONS(303),
    [anon_sym_end] = ACTIONS(303),
    [anon_sym_black] = ACTIONS(303),
    [anon_sym_blue] = ACTIONS(303),
    [anon_sym_green] = ACTIONS(303),
    [anon_sym_red] = ACTIONS(303),
    [anon_sym_yellow] = ACTIONS(303),
    [anon_sym_white] = ACTIONS(303),
    [anon_sym_gray] = ACTIONS(303),
    [anon_sym_transparent] = ACTIONS(303),
    [anon_sym_angle] = ACTIONS(303),
    [anon_sym_bool] = ACTIONS(303),
    [anon_sym_brush] = ACTIONS(303),
    [anon_sym_color] = ACTIONS(303),
    [anon_sym_float] = ACTIONS(303),
    [anon_sym_image] = ACTIONS(303),
    [anon_sym_int] = ACTIONS(303),
    [anon_sym_length] = ACTIONS(303),
    [anon_sym_percent] = ACTIONS(303),
    [anon_sym_physical_DASHlength] = ACTIONS(303),
    [anon_sym_physical_length] = ACTIONS(303),
    [anon_sym_string] = ACTIONS(303),
    [anon_sym_debug] = ACTIONS(303),
    [anon_sym_animation_DASHtick] = ACTIONS(303),
    [anon_sym_min] = ACTIONS(303),
    [anon_sym_max] = ACTIONS(303),
    [anon_sym_mod] = ACTIONS(303),
    [anon_sym_abs] = ACTIONS(303),
    [anon_sym_round] = ACTIONS(303),
    [anon_sym_ceil] = ACTIONS(303),
    [anon_sym_floor] = ACTIONS(303),
    [anon_sym_sin] = ACTIONS(303),
    [anon_sym_cos] = ACTIONS(303),
    [anon_sym_tan] = ACTIONS(303),
    [anon_sym_asin] = ACTIONS(303),
    [anon_sym_acos] = ACTIONS(303),
    [anon_sym_atan] = ACTIONS(303),
    [anon_sym_sqrt] = ACTIONS(303),
    [anon_sym_pow] = ACTIONS(303),
    [anon_sym_log] = ACTIONS(303),
    [anon_sym_rgb] = ACTIONS(303),
    [anon_sym_easing] = ACTIONS(303),
    [anon_sym_duration] = ACTIONS(303),
    [anon_sym_parent] = ACTIONS(303),
    [anon_sym_root] = ACTIONS(303),
    [sym_comment] = ACTIONS(3),
  },
  [34] = {
    [sym_function_call_args] = STATE(50),
    [anon_sym_LBRACE] = ACTIONS(321),
    [anon_sym_COLON] = ACTIONS(321),
    [anon_sym_COMMA] = ACTIONS(321),
    [anon_sym_RBRACE] = ACTIONS(321),
    [anon_sym_SEMI] = ACTIONS(321),
    [anon_sym_if] = ACTIONS(323),
    [anon_sym_AT] = ACTIONS(321),
    [anon_sym_LBRACK] = ACTIONS(305),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_LT_EQ_GT] = ACTIONS(321),
    [anon_sym_LPAREN] = ACTIONS(307),
    [anon_sym_RPAREN] = ACTIONS(321),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(41),
    [anon_sym_EQ] = ACTIONS(323),
    [anon_sym_PLUS_EQ] = ACTIONS(321),
    [anon_sym_DASH_EQ] = ACTIONS(321),
    [anon_sym_STAR_EQ] = ACTIONS(321),
    [anon_sym_SLASH_EQ] = ACTIONS(321),
    [anon_sym_PERCENT_EQ] = ACTIONS(321),
    [anon_sym_AMP_EQ] = ACTIONS(321),
    [anon_sym_PIPE_EQ] = ACTIONS(321),
    [anon_sym_CARET_EQ] = ACTIONS(321),
    [anon_sym_LT_LT_EQ] = ACTIONS(321),
    [anon_sym_GT_GT_EQ] = ACTIONS(321),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(323),
    [anon_sym_false] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(323),
    [anon_sym_AMP_AMP] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_CARET] = ACTIONS(63),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT_EQ] = ACTIONS(41),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(37),
    [anon_sym_QMARK] = ACTIONS(321),
    [anon_sym_DQUOTE] = ACTIONS(321),
    [anon_sym_SQUOTE] = ACTIONS(321),
    [sym__ident_reg] = ACTIONS(323),
    [anon_sym_POUND] = ACTIONS(321),
    [sym_int_literal] = ACTIONS(323),
    [sym_float_literal] = ACTIONS(321),
    [anon_sym_ease] = ACTIONS(323),
    [anon_sym_ease_DASHin] = ACTIONS(323),
    [anon_sym_ease_in] = ACTIONS(323),
    [anon_sym_ease_in_out] = ACTIONS(323),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(323),
    [anon_sym_ease_out] = ACTIONS(323),
    [anon_sym_ease_DASHout] = ACTIONS(323),
    [anon_sym_start] = ACTIONS(323),
    [anon_sym_end] = ACTIONS(323),
    [anon_sym_black] = ACTIONS(323),
    [anon_sym_blue] = ACTIONS(323),
    [anon_sym_green] = ACTIONS(323),
    [anon_sym_red] = ACTIONS(323),
    [anon_sym_yellow] = ACTIONS(323),
    [anon_sym_white] = ACTIONS(323),
    [anon_sym_gray] = ACTIONS(323),
    [anon_sym_transparent] = ACTIONS(323),
    [anon_sym_angle] = ACTIONS(323),
    [anon_sym_bool] = ACTIONS(323),
    [anon_sym_brush] = ACTIONS(323),
    [anon_sym_color] = ACTIONS(323),
    [anon_sym_float] = ACTIONS(323),
    [anon_sym_image] = ACTIONS(323),
    [anon_sym_int] = ACTIONS(323),
    [anon_sym_length] = ACTIONS(323),
    [anon_sym_percent] = ACTIONS(323),
    [anon_sym_physical_DASHlength] = ACTIONS(323),
    [anon_sym_physical_length] = ACTIONS(323),
    [anon_sym_string] = ACTIONS(323),
    [anon_sym_debug] = ACTIONS(323),
    [anon_sym_animation_DASHtick] = ACTIONS(323),
    [anon_sym_min] = ACTIONS(323),
    [anon_sym_max] = ACTIONS(323),
    [anon_sym_mod] = ACTIONS(323),
    [anon_sym_abs] = ACTIONS(323),
    [anon_sym_round] = ACTIONS(323),
    [anon_sym_ceil] = ACTIONS(323),
    [anon_sym_floor] = ACTIONS(323),
    [anon_sym_sin] = ACTIONS(323),
    [anon_sym_cos] = ACTIONS(323),
    [anon_sym_tan] = ACTIONS(323),
    [anon_sym_asin] = ACTIONS(323),
    [anon_sym_acos] = ACTIONS(323),
    [anon_sym_atan] = ACTIONS(323),
    [anon_sym_sqrt] = ACTIONS(323),
    [anon_sym_pow] = ACTIONS(323),
    [anon_sym_log] = ACTIONS(323),
    [anon_sym_rgb] = ACTIONS(323),
    [anon_sym_easing] = ACTIONS(323),
    [anon_sym_duration] = ACTIONS(323),
    [anon_sym_parent] = ACTIONS(323),
    [anon_sym_root] = ACTIONS(323),
    [sym_comment] = ACTIONS(3),
  },
  [35] = {
    [sym_function_call_args] = STATE(50),
    [anon_sym_LBRACE] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(301),
    [anon_sym_COMMA] = ACTIONS(301),
    [anon_sym_RBRACE] = ACTIONS(301),
    [anon_sym_SEMI] = ACTIONS(301),
    [anon_sym_if] = ACTIONS(303),
    [anon_sym_AT] = ACTIONS(301),
    [anon_sym_LBRACK] = ACTIONS(305),
    [anon_sym_STAR] = ACTIONS(303),
    [anon_sym_LT_EQ_GT] = ACTIONS(301),
    [anon_sym_LPAREN] = ACTIONS(307),
    [anon_sym_RPAREN] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(303),
    [anon_sym_GT] = ACTIONS(303),
    [anon_sym_EQ] = ACTIONS(303),
    [anon_sym_PLUS_EQ] = ACTIONS(301),
    [anon_sym_DASH_EQ] = ACTIONS(301),
    [anon_sym_STAR_EQ] = ACTIONS(301),
    [anon_sym_SLASH_EQ] = ACTIONS(301),
    [anon_sym_PERCENT_EQ] = ACTIONS(301),
    [anon_sym_AMP_EQ] = ACTIONS(301),
    [anon_sym_PIPE_EQ] = ACTIONS(301),
    [anon_sym_CARET_EQ] = ACTIONS(301),
    [anon_sym_LT_LT_EQ] = ACTIONS(301),
    [anon_sym_GT_GT_EQ] = ACTIONS(301),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(303),
    [anon_sym_false] = ACTIONS(303),
    [anon_sym_DASH] = ACTIONS(303),
    [anon_sym_BANG] = ACTIONS(303),
    [anon_sym_AMP_AMP] = ACTIONS(301),
    [anon_sym_PIPE_PIPE] = ACTIONS(301),
    [anon_sym_AMP] = ACTIONS(303),
    [anon_sym_PIPE] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [anon_sym_EQ_EQ] = ACTIONS(301),
    [anon_sym_BANG_EQ] = ACTIONS(301),
    [anon_sym_LT_EQ] = ACTIONS(303),
    [anon_sym_GT_EQ] = ACTIONS(301),
    [anon_sym_LT_LT] = ACTIONS(303),
    [anon_sym_GT_GT] = ACTIONS(303),
    [anon_sym_PLUS] = ACTIONS(303),
    [anon_sym_SLASH] = ACTIONS(303),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [sym__ident_reg] = ACTIONS(303),
    [anon_sym_POUND] = ACTIONS(301),
    [sym_int_literal] = ACTIONS(303),
    [sym_float_literal] = ACTIONS(301),
    [anon_sym_ease] = ACTIONS(303),
    [anon_sym_ease_DASHin] = ACTIONS(303),
    [anon_sym_ease_in] = ACTIONS(303),
    [anon_sym_ease_in_out] = ACTIONS(303),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(303),
    [anon_sym_ease_out] = ACTIONS(303),
    [anon_sym_ease_DASHout] = ACTIONS(303),
    [anon_sym_start] = ACTIONS(303),
    [anon_sym_end] = ACTIONS(303),
    [anon_sym_black] = ACTIONS(303),
    [anon_sym_blue] = ACTIONS(303),
    [anon_sym_green] = ACTIONS(303),
    [anon_sym_red] = ACTIONS(303),
    [anon_sym_yellow] = ACTIONS(303),
    [anon_sym_white] = ACTIONS(303),
    [anon_sym_gray] = ACTIONS(303),
    [anon_sym_transparent] = ACTIONS(303),
    [anon_sym_angle] = ACTIONS(303),
    [anon_sym_bool] = ACTIONS(303),
    [anon_sym_brush] = ACTIONS(303),
    [anon_sym_color] = ACTIONS(303),
    [anon_sym_float] = ACTIONS(303),
    [anon_sym_image] = ACTIONS(303),
    [anon_sym_int] = ACTIONS(303),
    [anon_sym_length] = ACTIONS(303),
    [anon_sym_percent] = ACTIONS(303),
    [anon_sym_physical_DASHlength] = ACTIONS(303),
    [anon_sym_physical_length] = ACTIONS(303),
    [anon_sym_string] = ACTIONS(303),
    [anon_sym_debug] = ACTIONS(303),
    [anon_sym_animation_DASHtick] = ACTIONS(303),
    [anon_sym_min] = ACTIONS(303),
    [anon_sym_max] = ACTIONS(303),
    [anon_sym_mod] = ACTIONS(303),
    [anon_sym_abs] = ACTIONS(303),
    [anon_sym_round] = ACTIONS(303),
    [anon_sym_ceil] = ACTIONS(303),
    [anon_sym_floor] = ACTIONS(303),
    [anon_sym_sin] = ACTIONS(303),
    [anon_sym_cos] = ACTIONS(303),
    [anon_sym_tan] = ACTIONS(303),
    [anon_sym_asin] = ACTIONS(303),
    [anon_sym_acos] = ACTIONS(303),
    [anon_sym_atan] = ACTIONS(303),
    [anon_sym_sqrt] = ACTIONS(303),
    [anon_sym_pow] = ACTIONS(303),
    [anon_sym_log] = ACTIONS(303),
    [anon_sym_rgb] = ACTIONS(303),
    [anon_sym_easing] = ACTIONS(303),
    [anon_sym_duration] = ACTIONS(303),
    [anon_sym_parent] = ACTIONS(303),
    [anon_sym_root] = ACTIONS(303),
    [sym_comment] = ACTIONS(3),
  },
  [36] = {
    [anon_sym_LBRACE] = ACTIONS(325),
    [anon_sym_COLON] = ACTIONS(325),
    [anon_sym_COMMA] = ACTIONS(325),
    [anon_sym_RBRACE] = ACTIONS(325),
    [anon_sym_SEMI] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(327),
    [anon_sym_AT] = ACTIONS(325),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_STAR] = ACTIONS(327),
    [anon_sym_LT_EQ_GT] = ACTIONS(325),
    [anon_sym_LPAREN] = ACTIONS(325),
    [anon_sym_RPAREN] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(327),
    [anon_sym_GT] = ACTIONS(327),
    [anon_sym_else] = ACTIONS(327),
    [anon_sym_EQ] = ACTIONS(327),
    [anon_sym_PLUS_EQ] = ACTIONS(325),
    [anon_sym_DASH_EQ] = ACTIONS(325),
    [anon_sym_STAR_EQ] = ACTIONS(325),
    [anon_sym_SLASH_EQ] = ACTIONS(325),
    [anon_sym_PERCENT_EQ] = ACTIONS(325),
    [anon_sym_AMP_EQ] = ACTIONS(325),
    [anon_sym_PIPE_EQ] = ACTIONS(325),
    [anon_sym_CARET_EQ] = ACTIONS(325),
    [anon_sym_LT_LT_EQ] = ACTIONS(325),
    [anon_sym_GT_GT_EQ] = ACTIONS(325),
    [anon_sym_DOT] = ACTIONS(325),
    [anon_sym_true] = ACTIONS(327),
    [anon_sym_false] = ACTIONS(327),
    [anon_sym_DASH] = ACTIONS(327),
    [anon_sym_BANG] = ACTIONS(327),
    [anon_sym_AMP_AMP] = ACTIONS(325),
    [anon_sym_PIPE_PIPE] = ACTIONS(325),
    [anon_sym_AMP] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(327),
    [anon_sym_CARET] = ACTIONS(327),
    [anon_sym_EQ_EQ] = ACTIONS(325),
    [anon_sym_BANG_EQ] = ACTIONS(325),
    [anon_sym_LT_EQ] = ACTIONS(327),
    [anon_sym_GT_EQ] = ACTIONS(325),
    [anon_sym_LT_LT] = ACTIONS(327),
    [anon_sym_GT_GT] = ACTIONS(327),
    [anon_sym_PLUS] = ACTIONS(327),
    [anon_sym_SLASH] = ACTIONS(327),
    [anon_sym_QMARK] = ACTIONS(325),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_SQUOTE] = ACTIONS(325),
    [sym__ident_reg] = ACTIONS(327),
    [anon_sym_POUND] = ACTIONS(325),
    [sym_int_literal] = ACTIONS(327),
    [sym_float_literal] = ACTIONS(325),
    [anon_sym_ease] = ACTIONS(327),
    [anon_sym_ease_DASHin] = ACTIONS(327),
    [anon_sym_ease_in] = ACTIONS(327),
    [anon_sym_ease_in_out] = ACTIONS(327),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(327),
    [anon_sym_ease_out] = ACTIONS(327),
    [anon_sym_ease_DASHout] = ACTIONS(327),
    [anon_sym_start] = ACTIONS(327),
    [anon_sym_end] = ACTIONS(327),
    [anon_sym_black] = ACTIONS(327),
    [anon_sym_blue] = ACTIONS(327),
    [anon_sym_green] = ACTIONS(327),
    [anon_sym_red] = ACTIONS(327),
    [anon_sym_yellow] = ACTIONS(327),
    [anon_sym_white] = ACTIONS(327),
    [anon_sym_gray] = ACTIONS(327),
    [anon_sym_transparent] = ACTIONS(327),
    [anon_sym_angle] = ACTIONS(327),
    [anon_sym_bool] = ACTIONS(327),
    [anon_sym_brush] = ACTIONS(327),
    [anon_sym_color] = ACTIONS(327),
    [anon_sym_float] = ACTIONS(327),
    [anon_sym_image] = ACTIONS(327),
    [anon_sym_int] = ACTIONS(327),
    [anon_sym_length] = ACTIONS(327),
    [anon_sym_percent] = ACTIONS(327),
    [anon_sym_physical_DASHlength] = ACTIONS(327),
    [anon_sym_physical_length] = ACTIONS(327),
    [anon_sym_string] = ACTIONS(327),
    [anon_sym_debug] = ACTIONS(327),
    [anon_sym_animation_DASHtick] = ACTIONS(327),
    [anon_sym_min] = ACTIONS(327),
    [anon_sym_max] = ACTIONS(327),
    [anon_sym_mod] = ACTIONS(327),
    [anon_sym_abs] = ACTIONS(327),
    [anon_sym_round] = ACTIONS(327),
    [anon_sym_ceil] = ACTIONS(327),
    [anon_sym_floor] = ACTIONS(327),
    [anon_sym_sin] = ACTIONS(327),
    [anon_sym_cos] = ACTIONS(327),
    [anon_sym_tan] = ACTIONS(327),
    [anon_sym_asin] = ACTIONS(327),
    [anon_sym_acos] = ACTIONS(327),
    [anon_sym_atan] = ACTIONS(327),
    [anon_sym_sqrt] = ACTIONS(327),
    [anon_sym_pow] = ACTIONS(327),
    [anon_sym_log] = ACTIONS(327),
    [anon_sym_rgb] = ACTIONS(327),
    [anon_sym_easing] = ACTIONS(327),
    [anon_sym_duration] = ACTIONS(327),
    [anon_sym_parent] = ACTIONS(327),
    [anon_sym_root] = ACTIONS(327),
    [sym_comment] = ACTIONS(3),
  },
  [37] = {
    [sym_function_call_args] = STATE(50),
    [anon_sym_LBRACE] = ACTIONS(329),
    [anon_sym_COLON] = ACTIONS(329),
    [anon_sym_COMMA] = ACTIONS(329),
    [anon_sym_RBRACE] = ACTIONS(329),
    [anon_sym_SEMI] = ACTIONS(329),
    [anon_sym_if] = ACTIONS(331),
    [anon_sym_AT] = ACTIONS(329),
    [anon_sym_LBRACK] = ACTIONS(305),
    [anon_sym_STAR] = ACTIONS(331),
    [anon_sym_LT_EQ_GT] = ACTIONS(329),
    [anon_sym_LPAREN] = ACTIONS(307),
    [anon_sym_RPAREN] = ACTIONS(329),
    [anon_sym_LT] = ACTIONS(331),
    [anon_sym_GT] = ACTIONS(331),
    [anon_sym_EQ] = ACTIONS(331),
    [anon_sym_PLUS_EQ] = ACTIONS(329),
    [anon_sym_DASH_EQ] = ACTIONS(329),
    [anon_sym_STAR_EQ] = ACTIONS(329),
    [anon_sym_SLASH_EQ] = ACTIONS(329),
    [anon_sym_PERCENT_EQ] = ACTIONS(329),
    [anon_sym_AMP_EQ] = ACTIONS(329),
    [anon_sym_PIPE_EQ] = ACTIONS(329),
    [anon_sym_CARET_EQ] = ACTIONS(329),
    [anon_sym_LT_LT_EQ] = ACTIONS(329),
    [anon_sym_GT_GT_EQ] = ACTIONS(329),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(331),
    [anon_sym_false] = ACTIONS(331),
    [anon_sym_DASH] = ACTIONS(331),
    [anon_sym_BANG] = ACTIONS(331),
    [anon_sym_AMP_AMP] = ACTIONS(329),
    [anon_sym_PIPE_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE] = ACTIONS(331),
    [anon_sym_CARET] = ACTIONS(331),
    [anon_sym_EQ_EQ] = ACTIONS(329),
    [anon_sym_BANG_EQ] = ACTIONS(329),
    [anon_sym_LT_EQ] = ACTIONS(331),
    [anon_sym_GT_EQ] = ACTIONS(329),
    [anon_sym_LT_LT] = ACTIONS(331),
    [anon_sym_GT_GT] = ACTIONS(331),
    [anon_sym_PLUS] = ACTIONS(331),
    [anon_sym_SLASH] = ACTIONS(331),
    [anon_sym_QMARK] = ACTIONS(329),
    [anon_sym_DQUOTE] = ACTIONS(329),
    [anon_sym_SQUOTE] = ACTIONS(329),
    [sym__ident_reg] = ACTIONS(331),
    [anon_sym_POUND] = ACTIONS(329),
    [sym_int_literal] = ACTIONS(331),
    [sym_float_literal] = ACTIONS(329),
    [anon_sym_ease] = ACTIONS(331),
    [anon_sym_ease_DASHin] = ACTIONS(331),
    [anon_sym_ease_in] = ACTIONS(331),
    [anon_sym_ease_in_out] = ACTIONS(331),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(331),
    [anon_sym_ease_out] = ACTIONS(331),
    [anon_sym_ease_DASHout] = ACTIONS(331),
    [anon_sym_start] = ACTIONS(331),
    [anon_sym_end] = ACTIONS(331),
    [anon_sym_black] = ACTIONS(331),
    [anon_sym_blue] = ACTIONS(331),
    [anon_sym_green] = ACTIONS(331),
    [anon_sym_red] = ACTIONS(331),
    [anon_sym_yellow] = ACTIONS(331),
    [anon_sym_white] = ACTIONS(331),
    [anon_sym_gray] = ACTIONS(331),
    [anon_sym_transparent] = ACTIONS(331),
    [anon_sym_angle] = ACTIONS(331),
    [anon_sym_bool] = ACTIONS(331),
    [anon_sym_brush] = ACTIONS(331),
    [anon_sym_color] = ACTIONS(331),
    [anon_sym_float] = ACTIONS(331),
    [anon_sym_image] = ACTIONS(331),
    [anon_sym_int] = ACTIONS(331),
    [anon_sym_length] = ACTIONS(331),
    [anon_sym_percent] = ACTIONS(331),
    [anon_sym_physical_DASHlength] = ACTIONS(331),
    [anon_sym_physical_length] = ACTIONS(331),
    [anon_sym_string] = ACTIONS(331),
    [anon_sym_debug] = ACTIONS(331),
    [anon_sym_animation_DASHtick] = ACTIONS(331),
    [anon_sym_min] = ACTIONS(331),
    [anon_sym_max] = ACTIONS(331),
    [anon_sym_mod] = ACTIONS(331),
    [anon_sym_abs] = ACTIONS(331),
    [anon_sym_round] = ACTIONS(331),
    [anon_sym_ceil] = ACTIONS(331),
    [anon_sym_floor] = ACTIONS(331),
    [anon_sym_sin] = ACTIONS(331),
    [anon_sym_cos] = ACTIONS(331),
    [anon_sym_tan] = ACTIONS(331),
    [anon_sym_asin] = ACTIONS(331),
    [anon_sym_acos] = ACTIONS(331),
    [anon_sym_atan] = ACTIONS(331),
    [anon_sym_sqrt] = ACTIONS(331),
    [anon_sym_pow] = ACTIONS(331),
    [anon_sym_log] = ACTIONS(331),
    [anon_sym_rgb] = ACTIONS(331),
    [anon_sym_easing] = ACTIONS(331),
    [anon_sym_duration] = ACTIONS(331),
    [anon_sym_parent] = ACTIONS(331),
    [anon_sym_root] = ACTIONS(331),
    [sym_comment] = ACTIONS(3),
  },
  [38] = {
    [anon_sym_LBRACE] = ACTIONS(333),
    [anon_sym_COLON] = ACTIONS(333),
    [anon_sym_COMMA] = ACTIONS(333),
    [anon_sym_RBRACE] = ACTIONS(333),
    [anon_sym_SEMI] = ACTIONS(333),
    [anon_sym_if] = ACTIONS(335),
    [anon_sym_AT] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(333),
    [anon_sym_STAR] = ACTIONS(335),
    [anon_sym_LT_EQ_GT] = ACTIONS(333),
    [anon_sym_LPAREN] = ACTIONS(333),
    [anon_sym_RPAREN] = ACTIONS(333),
    [anon_sym_LT] = ACTIONS(335),
    [anon_sym_GT] = ACTIONS(335),
    [anon_sym_else] = ACTIONS(337),
    [anon_sym_EQ] = ACTIONS(335),
    [anon_sym_PLUS_EQ] = ACTIONS(333),
    [anon_sym_DASH_EQ] = ACTIONS(333),
    [anon_sym_STAR_EQ] = ACTIONS(333),
    [anon_sym_SLASH_EQ] = ACTIONS(333),
    [anon_sym_PERCENT_EQ] = ACTIONS(333),
    [anon_sym_AMP_EQ] = ACTIONS(333),
    [anon_sym_PIPE_EQ] = ACTIONS(333),
    [anon_sym_CARET_EQ] = ACTIONS(333),
    [anon_sym_LT_LT_EQ] = ACTIONS(333),
    [anon_sym_GT_GT_EQ] = ACTIONS(333),
    [anon_sym_DOT] = ACTIONS(333),
    [anon_sym_true] = ACTIONS(335),
    [anon_sym_false] = ACTIONS(335),
    [anon_sym_DASH] = ACTIONS(335),
    [anon_sym_BANG] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_AMP] = ACTIONS(335),
    [anon_sym_PIPE] = ACTIONS(335),
    [anon_sym_CARET] = ACTIONS(335),
    [anon_sym_EQ_EQ] = ACTIONS(333),
    [anon_sym_BANG_EQ] = ACTIONS(333),
    [anon_sym_LT_EQ] = ACTIONS(335),
    [anon_sym_GT_EQ] = ACTIONS(333),
    [anon_sym_LT_LT] = ACTIONS(335),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(335),
    [anon_sym_SLASH] = ACTIONS(335),
    [anon_sym_QMARK] = ACTIONS(333),
    [anon_sym_DQUOTE] = ACTIONS(333),
    [anon_sym_SQUOTE] = ACTIONS(333),
    [sym__ident_reg] = ACTIONS(335),
    [anon_sym_POUND] = ACTIONS(333),
    [sym_int_literal] = ACTIONS(335),
    [sym_float_literal] = ACTIONS(333),
    [anon_sym_ease] = ACTIONS(335),
    [anon_sym_ease_DASHin] = ACTIONS(335),
    [anon_sym_ease_in] = ACTIONS(335),
    [anon_sym_ease_in_out] = ACTIONS(335),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(335),
    [anon_sym_ease_out] = ACTIONS(335),
    [anon_sym_ease_DASHout] = ACTIONS(335),
    [anon_sym_start] = ACTIONS(335),
    [anon_sym_end] = ACTIONS(335),
    [anon_sym_black] = ACTIONS(335),
    [anon_sym_blue] = ACTIONS(335),
    [anon_sym_green] = ACTIONS(335),
    [anon_sym_red] = ACTIONS(335),
    [anon_sym_yellow] = ACTIONS(335),
    [anon_sym_white] = ACTIONS(335),
    [anon_sym_gray] = ACTIONS(335),
    [anon_sym_transparent] = ACTIONS(335),
    [anon_sym_angle] = ACTIONS(335),
    [anon_sym_bool] = ACTIONS(335),
    [anon_sym_brush] = ACTIONS(335),
    [anon_sym_color] = ACTIONS(335),
    [anon_sym_float] = ACTIONS(335),
    [anon_sym_image] = ACTIONS(335),
    [anon_sym_int] = ACTIONS(335),
    [anon_sym_length] = ACTIONS(335),
    [anon_sym_percent] = ACTIONS(335),
    [anon_sym_physical_DASHlength] = ACTIONS(335),
    [anon_sym_physical_length] = ACTIONS(335),
    [anon_sym_string] = ACTIONS(335),
    [anon_sym_debug] = ACTIONS(335),
    [anon_sym_animation_DASHtick] = ACTIONS(335),
    [anon_sym_min] = ACTIONS(335),
    [anon_sym_max] = ACTIONS(335),
    [anon_sym_mod] = ACTIONS(335),
    [anon_sym_abs] = ACTIONS(335),
    [anon_sym_round] = ACTIONS(335),
    [anon_sym_ceil] = ACTIONS(335),
    [anon_sym_floor] = ACTIONS(335),
    [anon_sym_sin] = ACTIONS(335),
    [anon_sym_cos] = ACTIONS(335),
    [anon_sym_tan] = ACTIONS(335),
    [anon_sym_asin] = ACTIONS(335),
    [anon_sym_acos] = ACTIONS(335),
    [anon_sym_atan] = ACTIONS(335),
    [anon_sym_sqrt] = ACTIONS(335),
    [anon_sym_pow] = ACTIONS(335),
    [anon_sym_log] = ACTIONS(335),
    [anon_sym_rgb] = ACTIONS(335),
    [anon_sym_easing] = ACTIONS(335),
    [anon_sym_duration] = ACTIONS(335),
    [anon_sym_parent] = ACTIONS(335),
    [anon_sym_root] = ACTIONS(335),
    [sym_comment] = ACTIONS(3),
  },
  [39] = {
    [sym_function_call_args] = STATE(50),
    [anon_sym_LBRACE] = ACTIONS(301),
    [anon_sym_COLON] = ACTIONS(301),
    [anon_sym_COMMA] = ACTIONS(301),
    [anon_sym_RBRACE] = ACTIONS(301),
    [anon_sym_SEMI] = ACTIONS(301),
    [anon_sym_if] = ACTIONS(303),
    [anon_sym_AT] = ACTIONS(301),
    [anon_sym_LBRACK] = ACTIONS(305),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_LT_EQ_GT] = ACTIONS(301),
    [anon_sym_LPAREN] = ACTIONS(307),
    [anon_sym_RPAREN] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(303),
    [anon_sym_GT] = ACTIONS(303),
    [anon_sym_EQ] = ACTIONS(303),
    [anon_sym_PLUS_EQ] = ACTIONS(301),
    [anon_sym_DASH_EQ] = ACTIONS(301),
    [anon_sym_STAR_EQ] = ACTIONS(301),
    [anon_sym_SLASH_EQ] = ACTIONS(301),
    [anon_sym_PERCENT_EQ] = ACTIONS(301),
    [anon_sym_AMP_EQ] = ACTIONS(301),
    [anon_sym_PIPE_EQ] = ACTIONS(301),
    [anon_sym_CARET_EQ] = ACTIONS(301),
    [anon_sym_LT_LT_EQ] = ACTIONS(301),
    [anon_sym_GT_GT_EQ] = ACTIONS(301),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(303),
    [anon_sym_false] = ACTIONS(303),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(303),
    [anon_sym_AMP_AMP] = ACTIONS(301),
    [anon_sym_PIPE_PIPE] = ACTIONS(301),
    [anon_sym_AMP] = ACTIONS(303),
    [anon_sym_PIPE] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [anon_sym_EQ_EQ] = ACTIONS(301),
    [anon_sym_BANG_EQ] = ACTIONS(301),
    [anon_sym_LT_EQ] = ACTIONS(303),
    [anon_sym_GT_EQ] = ACTIONS(301),
    [anon_sym_LT_LT] = ACTIONS(303),
    [anon_sym_GT_GT] = ACTIONS(303),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(37),
    [anon_sym_QMARK] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [sym__ident_reg] = ACTIONS(303),
    [anon_sym_POUND] = ACTIONS(301),
    [sym_int_literal] = ACTIONS(303),
    [sym_float_literal] = ACTIONS(301),
    [anon_sym_ease] = ACTIONS(303),
    [anon_sym_ease_DASHin] = ACTIONS(303),
    [anon_sym_ease_in] = ACTIONS(303),
    [anon_sym_ease_in_out] = ACTIONS(303),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(303),
    [anon_sym_ease_out] = ACTIONS(303),
    [anon_sym_ease_DASHout] = ACTIONS(303),
    [anon_sym_start] = ACTIONS(303),
    [anon_sym_end] = ACTIONS(303),
    [anon_sym_black] = ACTIONS(303),
    [anon_sym_blue] = ACTIONS(303),
    [anon_sym_green] = ACTIONS(303),
    [anon_sym_red] = ACTIONS(303),
    [anon_sym_yellow] = ACTIONS(303),
    [anon_sym_white] = ACTIONS(303),
    [anon_sym_gray] = ACTIONS(303),
    [anon_sym_transparent] = ACTIONS(303),
    [anon_sym_angle] = ACTIONS(303),
    [anon_sym_bool] = ACTIONS(303),
    [anon_sym_brush] = ACTIONS(303),
    [anon_sym_color] = ACTIONS(303),
    [anon_sym_float] = ACTIONS(303),
    [anon_sym_image] = ACTIONS(303),
    [anon_sym_int] = ACTIONS(303),
    [anon_sym_length] = ACTIONS(303),
    [anon_sym_percent] = ACTIONS(303),
    [anon_sym_physical_DASHlength] = ACTIONS(303),
    [anon_sym_physical_length] = ACTIONS(303),
    [anon_sym_string] = ACTIONS(303),
    [anon_sym_debug] = ACTIONS(303),
    [anon_sym_animation_DASHtick] = ACTIONS(303),
    [anon_sym_min] = ACTIONS(303),
    [anon_sym_max] = ACTIONS(303),
    [anon_sym_mod] = ACTIONS(303),
    [anon_sym_abs] = ACTIONS(303),
    [anon_sym_round] = ACTIONS(303),
    [anon_sym_ceil] = ACTIONS(303),
    [anon_sym_floor] = ACTIONS(303),
    [anon_sym_sin] = ACTIONS(303),
    [anon_sym_cos] = ACTIONS(303),
    [anon_sym_tan] = ACTIONS(303),
    [anon_sym_asin] = ACTIONS(303),
    [anon_sym_acos] = ACTIONS(303),
    [anon_sym_atan] = ACTIONS(303),
    [anon_sym_sqrt] = ACTIONS(303),
    [anon_sym_pow] = ACTIONS(303),
    [anon_sym_log] = ACTIONS(303),
    [anon_sym_rgb] = ACTIONS(303),
    [anon_sym_easing] = ACTIONS(303),
    [anon_sym_duration] = ACTIONS(303),
    [anon_sym_parent] = ACTIONS(303),
    [anon_sym_root] = ACTIONS(303),
    [sym_comment] = ACTIONS(3),
  },
  [40] = {
    [anon_sym_LBRACE] = ACTIONS(339),
    [anon_sym_COLON] = ACTIONS(339),
    [anon_sym_COMMA] = ACTIONS(339),
    [anon_sym_RBRACE] = ACTIONS(339),
    [anon_sym_SEMI] = ACTIONS(339),
    [anon_sym_if] = ACTIONS(341),
    [anon_sym_AT] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(339),
    [anon_sym_STAR] = ACTIONS(341),
    [anon_sym_LT_EQ_GT] = ACTIONS(339),
    [anon_sym_LPAREN] = ACTIONS(339),
    [anon_sym_RPAREN] = ACTIONS(339),
    [anon_sym_LT] = ACTIONS(341),
    [anon_sym_GT] = ACTIONS(341),
    [anon_sym_EQ] = ACTIONS(341),
    [anon_sym_PLUS_EQ] = ACTIONS(339),
    [anon_sym_DASH_EQ] = ACTIONS(339),
    [anon_sym_STAR_EQ] = ACTIONS(339),
    [anon_sym_SLASH_EQ] = ACTIONS(339),
    [anon_sym_PERCENT_EQ] = ACTIONS(339),
    [anon_sym_AMP_EQ] = ACTIONS(339),
    [anon_sym_PIPE_EQ] = ACTIONS(339),
    [anon_sym_CARET_EQ] = ACTIONS(339),
    [anon_sym_LT_LT_EQ] = ACTIONS(339),
    [anon_sym_GT_GT_EQ] = ACTIONS(339),
    [anon_sym_DOT] = ACTIONS(339),
    [anon_sym_true] = ACTIONS(341),
    [anon_sym_false] = ACTIONS(341),
    [anon_sym_DASH] = ACTIONS(341),
    [anon_sym_BANG] = ACTIONS(341),
    [anon_sym_AMP_AMP] = ACTIONS(339),
    [anon_sym_PIPE_PIPE] = ACTIONS(339),
    [anon_sym_AMP] = ACTIONS(341),
    [anon_sym_PIPE] = ACTIONS(341),
    [anon_sym_CARET] = ACTIONS(341),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(339),
    [anon_sym_LT_EQ] = ACTIONS(341),
    [anon_sym_GT_EQ] = ACTIONS(339),
    [anon_sym_LT_LT] = ACTIONS(341),
    [anon_sym_GT_GT] = ACTIONS(341),
    [anon_sym_PLUS] = ACTIONS(341),
    [anon_sym_SLASH] = ACTIONS(341),
    [anon_sym_QMARK] = ACTIONS(339),
    [anon_sym_DQUOTE] = ACTIONS(339),
    [anon_sym_SQUOTE] = ACTIONS(339),
    [sym__ident_reg] = ACTIONS(341),
    [anon_sym_POUND] = ACTIONS(339),
    [sym_int_literal] = ACTIONS(341),
    [sym_float_literal] = ACTIONS(339),
    [anon_sym_ease] = ACTIONS(341),
    [anon_sym_ease_DASHin] = ACTIONS(341),
    [anon_sym_ease_in] = ACTIONS(341),
    [anon_sym_ease_in_out] = ACTIONS(341),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(341),
    [anon_sym_ease_out] = ACTIONS(341),
    [anon_sym_ease_DASHout] = ACTIONS(341),
    [anon_sym_start] = ACTIONS(341),
    [anon_sym_end] = ACTIONS(341),
    [anon_sym_black] = ACTIONS(341),
    [anon_sym_blue] = ACTIONS(341),
    [anon_sym_green] = ACTIONS(341),
    [anon_sym_red] = ACTIONS(341),
    [anon_sym_yellow] = ACTIONS(341),
    [anon_sym_white] = ACTIONS(341),
    [anon_sym_gray] = ACTIONS(341),
    [anon_sym_transparent] = ACTIONS(341),
    [anon_sym_angle] = ACTIONS(341),
    [anon_sym_bool] = ACTIONS(341),
    [anon_sym_brush] = ACTIONS(341),
    [anon_sym_color] = ACTIONS(341),
    [anon_sym_float] = ACTIONS(341),
    [anon_sym_image] = ACTIONS(341),
    [anon_sym_int] = ACTIONS(341),
    [anon_sym_length] = ACTIONS(341),
    [anon_sym_percent] = ACTIONS(341),
    [anon_sym_physical_DASHlength] = ACTIONS(341),
    [anon_sym_physical_length] = ACTIONS(341),
    [anon_sym_string] = ACTIONS(341),
    [anon_sym_debug] = ACTIONS(341),
    [anon_sym_animation_DASHtick] = ACTIONS(341),
    [anon_sym_min] = ACTIONS(341),
    [anon_sym_max] = ACTIONS(341),
    [anon_sym_mod] = ACTIONS(341),
    [anon_sym_abs] = ACTIONS(341),
    [anon_sym_round] = ACTIONS(341),
    [anon_sym_ceil] = ACTIONS(341),
    [anon_sym_floor] = ACTIONS(341),
    [anon_sym_sin] = ACTIONS(341),
    [anon_sym_cos] = ACTIONS(341),
    [anon_sym_tan] = ACTIONS(341),
    [anon_sym_asin] = ACTIONS(341),
    [anon_sym_acos] = ACTIONS(341),
    [anon_sym_atan] = ACTIONS(341),
    [anon_sym_sqrt] = ACTIONS(341),
    [anon_sym_pow] = ACTIONS(341),
    [anon_sym_log] = ACTIONS(341),
    [anon_sym_rgb] = ACTIONS(341),
    [anon_sym_easing] = ACTIONS(341),
    [anon_sym_duration] = ACTIONS(341),
    [anon_sym_parent] = ACTIONS(341),
    [anon_sym_root] = ACTIONS(341),
    [sym_comment] = ACTIONS(3),
  },
  [41] = {
    [anon_sym_LBRACE] = ACTIONS(343),
    [anon_sym_COLON] = ACTIONS(343),
    [anon_sym_COMMA] = ACTIONS(343),
    [anon_sym_RBRACE] = ACTIONS(343),
    [anon_sym_SEMI] = ACTIONS(343),
    [anon_sym_if] = ACTIONS(345),
    [anon_sym_AT] = ACTIONS(343),
    [anon_sym_LBRACK] = ACTIONS(343),
    [anon_sym_STAR] = ACTIONS(345),
    [anon_sym_LT_EQ_GT] = ACTIONS(343),
    [anon_sym_LPAREN] = ACTIONS(343),
    [anon_sym_RPAREN] = ACTIONS(343),
    [anon_sym_LT] = ACTIONS(345),
    [anon_sym_GT] = ACTIONS(345),
    [anon_sym_EQ] = ACTIONS(345),
    [anon_sym_PLUS_EQ] = ACTIONS(343),
    [anon_sym_DASH_EQ] = ACTIONS(343),
    [anon_sym_STAR_EQ] = ACTIONS(343),
    [anon_sym_SLASH_EQ] = ACTIONS(343),
    [anon_sym_PERCENT_EQ] = ACTIONS(343),
    [anon_sym_AMP_EQ] = ACTIONS(343),
    [anon_sym_PIPE_EQ] = ACTIONS(343),
    [anon_sym_CARET_EQ] = ACTIONS(343),
    [anon_sym_LT_LT_EQ] = ACTIONS(343),
    [anon_sym_GT_GT_EQ] = ACTIONS(343),
    [anon_sym_DOT] = ACTIONS(343),
    [anon_sym_true] = ACTIONS(345),
    [anon_sym_false] = ACTIONS(345),
    [anon_sym_DASH] = ACTIONS(345),
    [anon_sym_BANG] = ACTIONS(345),
    [anon_sym_AMP_AMP] = ACTIONS(343),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_AMP] = ACTIONS(345),
    [anon_sym_PIPE] = ACTIONS(345),
    [anon_sym_CARET] = ACTIONS(345),
    [anon_sym_EQ_EQ] = ACTIONS(343),
    [anon_sym_BANG_EQ] = ACTIONS(343),
    [anon_sym_LT_EQ] = ACTIONS(345),
    [anon_sym_GT_EQ] = ACTIONS(343),
    [anon_sym_LT_LT] = ACTIONS(345),
    [anon_sym_GT_GT] = ACTIONS(345),
    [anon_sym_PLUS] = ACTIONS(345),
    [anon_sym_SLASH] = ACTIONS(345),
    [anon_sym_QMARK] = ACTIONS(343),
    [anon_sym_DQUOTE] = ACTIONS(343),
    [anon_sym_SQUOTE] = ACTIONS(343),
    [sym__ident_reg] = ACTIONS(345),
    [anon_sym_POUND] = ACTIONS(343),
    [sym_int_literal] = ACTIONS(345),
    [sym_float_literal] = ACTIONS(343),
    [anon_sym_ease] = ACTIONS(345),
    [anon_sym_ease_DASHin] = ACTIONS(345),
    [anon_sym_ease_in] = ACTIONS(345),
    [anon_sym_ease_in_out] = ACTIONS(345),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(345),
    [anon_sym_ease_out] = ACTIONS(345),
    [anon_sym_ease_DASHout] = ACTIONS(345),
    [anon_sym_start] = ACTIONS(345),
    [anon_sym_end] = ACTIONS(345),
    [anon_sym_black] = ACTIONS(345),
    [anon_sym_blue] = ACTIONS(345),
    [anon_sym_green] = ACTIONS(345),
    [anon_sym_red] = ACTIONS(345),
    [anon_sym_yellow] = ACTIONS(345),
    [anon_sym_white] = ACTIONS(345),
    [anon_sym_gray] = ACTIONS(345),
    [anon_sym_transparent] = ACTIONS(345),
    [anon_sym_angle] = ACTIONS(345),
    [anon_sym_bool] = ACTIONS(345),
    [anon_sym_brush] = ACTIONS(345),
    [anon_sym_color] = ACTIONS(345),
    [anon_sym_float] = ACTIONS(345),
    [anon_sym_image] = ACTIONS(345),
    [anon_sym_int] = ACTIONS(345),
    [anon_sym_length] = ACTIONS(345),
    [anon_sym_percent] = ACTIONS(345),
    [anon_sym_physical_DASHlength] = ACTIONS(345),
    [anon_sym_physical_length] = ACTIONS(345),
    [anon_sym_string] = ACTIONS(345),
    [anon_sym_debug] = ACTIONS(345),
    [anon_sym_animation_DASHtick] = ACTIONS(345),
    [anon_sym_min] = ACTIONS(345),
    [anon_sym_max] = ACTIONS(345),
    [anon_sym_mod] = ACTIONS(345),
    [anon_sym_abs] = ACTIONS(345),
    [anon_sym_round] = ACTIONS(345),
    [anon_sym_ceil] = ACTIONS(345),
    [anon_sym_floor] = ACTIONS(345),
    [anon_sym_sin] = ACTIONS(345),
    [anon_sym_cos] = ACTIONS(345),
    [anon_sym_tan] = ACTIONS(345),
    [anon_sym_asin] = ACTIONS(345),
    [anon_sym_acos] = ACTIONS(345),
    [anon_sym_atan] = ACTIONS(345),
    [anon_sym_sqrt] = ACTIONS(345),
    [anon_sym_pow] = ACTIONS(345),
    [anon_sym_log] = ACTIONS(345),
    [anon_sym_rgb] = ACTIONS(345),
    [anon_sym_easing] = ACTIONS(345),
    [anon_sym_duration] = ACTIONS(345),
    [anon_sym_parent] = ACTIONS(345),
    [anon_sym_root] = ACTIONS(345),
    [sym_comment] = ACTIONS(3),
  },
  [42] = {
    [anon_sym_LBRACE] = ACTIONS(347),
    [anon_sym_COLON] = ACTIONS(347),
    [anon_sym_COMMA] = ACTIONS(347),
    [anon_sym_RBRACE] = ACTIONS(347),
    [anon_sym_SEMI] = ACTIONS(347),
    [anon_sym_if] = ACTIONS(349),
    [anon_sym_AT] = ACTIONS(347),
    [anon_sym_LBRACK] = ACTIONS(347),
    [anon_sym_STAR] = ACTIONS(349),
    [anon_sym_LT_EQ_GT] = ACTIONS(347),
    [anon_sym_LPAREN] = ACTIONS(347),
    [anon_sym_RPAREN] = ACTIONS(347),
    [anon_sym_LT] = ACTIONS(349),
    [anon_sym_GT] = ACTIONS(349),
    [anon_sym_EQ] = ACTIONS(349),
    [anon_sym_PLUS_EQ] = ACTIONS(347),
    [anon_sym_DASH_EQ] = ACTIONS(347),
    [anon_sym_STAR_EQ] = ACTIONS(347),
    [anon_sym_SLASH_EQ] = ACTIONS(347),
    [anon_sym_PERCENT_EQ] = ACTIONS(347),
    [anon_sym_AMP_EQ] = ACTIONS(347),
    [anon_sym_PIPE_EQ] = ACTIONS(347),
    [anon_sym_CARET_EQ] = ACTIONS(347),
    [anon_sym_LT_LT_EQ] = ACTIONS(347),
    [anon_sym_GT_GT_EQ] = ACTIONS(347),
    [anon_sym_DOT] = ACTIONS(347),
    [anon_sym_true] = ACTIONS(349),
    [anon_sym_false] = ACTIONS(349),
    [anon_sym_DASH] = ACTIONS(349),
    [anon_sym_BANG] = ACTIONS(349),
    [anon_sym_AMP_AMP] = ACTIONS(347),
    [anon_sym_PIPE_PIPE] = ACTIONS(347),
    [anon_sym_AMP] = ACTIONS(349),
    [anon_sym_PIPE] = ACTIONS(349),
    [anon_sym_CARET] = ACTIONS(349),
    [anon_sym_EQ_EQ] = ACTIONS(347),
    [anon_sym_BANG_EQ] = ACTIONS(347),
    [anon_sym_LT_EQ] = ACTIONS(349),
    [anon_sym_GT_EQ] = ACTIONS(347),
    [anon_sym_LT_LT] = ACTIONS(349),
    [anon_sym_GT_GT] = ACTIONS(349),
    [anon_sym_PLUS] = ACTIONS(349),
    [anon_sym_SLASH] = ACTIONS(349),
    [anon_sym_QMARK] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(347),
    [anon_sym_SQUOTE] = ACTIONS(347),
    [sym__ident_reg] = ACTIONS(349),
    [anon_sym_POUND] = ACTIONS(347),
    [sym_int_literal] = ACTIONS(349),
    [sym_float_literal] = ACTIONS(347),
    [anon_sym_ease] = ACTIONS(349),
    [anon_sym_ease_DASHin] = ACTIONS(349),
    [anon_sym_ease_in] = ACTIONS(349),
    [anon_sym_ease_in_out] = ACTIONS(349),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(349),
    [anon_sym_ease_out] = ACTIONS(349),
    [anon_sym_ease_DASHout] = ACTIONS(349),
    [anon_sym_start] = ACTIONS(349),
    [anon_sym_end] = ACTIONS(349),
    [anon_sym_black] = ACTIONS(349),
    [anon_sym_blue] = ACTIONS(349),
    [anon_sym_green] = ACTIONS(349),
    [anon_sym_red] = ACTIONS(349),
    [anon_sym_yellow] = ACTIONS(349),
    [anon_sym_white] = ACTIONS(349),
    [anon_sym_gray] = ACTIONS(349),
    [anon_sym_transparent] = ACTIONS(349),
    [anon_sym_angle] = ACTIONS(349),
    [anon_sym_bool] = ACTIONS(349),
    [anon_sym_brush] = ACTIONS(349),
    [anon_sym_color] = ACTIONS(349),
    [anon_sym_float] = ACTIONS(349),
    [anon_sym_image] = ACTIONS(349),
    [anon_sym_int] = ACTIONS(349),
    [anon_sym_length] = ACTIONS(349),
    [anon_sym_percent] = ACTIONS(349),
    [anon_sym_physical_DASHlength] = ACTIONS(349),
    [anon_sym_physical_length] = ACTIONS(349),
    [anon_sym_string] = ACTIONS(349),
    [anon_sym_debug] = ACTIONS(349),
    [anon_sym_animation_DASHtick] = ACTIONS(349),
    [anon_sym_min] = ACTIONS(349),
    [anon_sym_max] = ACTIONS(349),
    [anon_sym_mod] = ACTIONS(349),
    [anon_sym_abs] = ACTIONS(349),
    [anon_sym_round] = ACTIONS(349),
    [anon_sym_ceil] = ACTIONS(349),
    [anon_sym_floor] = ACTIONS(349),
    [anon_sym_sin] = ACTIONS(349),
    [anon_sym_cos] = ACTIONS(349),
    [anon_sym_tan] = ACTIONS(349),
    [anon_sym_asin] = ACTIONS(349),
    [anon_sym_acos] = ACTIONS(349),
    [anon_sym_atan] = ACTIONS(349),
    [anon_sym_sqrt] = ACTIONS(349),
    [anon_sym_pow] = ACTIONS(349),
    [anon_sym_log] = ACTIONS(349),
    [anon_sym_rgb] = ACTIONS(349),
    [anon_sym_easing] = ACTIONS(349),
    [anon_sym_duration] = ACTIONS(349),
    [anon_sym_parent] = ACTIONS(349),
    [anon_sym_root] = ACTIONS(349),
    [sym_comment] = ACTIONS(3),
  },
  [43] = {
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_COLON] = ACTIONS(351),
    [anon_sym_COMMA] = ACTIONS(351),
    [anon_sym_RBRACE] = ACTIONS(351),
    [anon_sym_SEMI] = ACTIONS(351),
    [anon_sym_if] = ACTIONS(353),
    [anon_sym_AT] = ACTIONS(351),
    [anon_sym_LBRACK] = ACTIONS(351),
    [anon_sym_STAR] = ACTIONS(353),
    [anon_sym_LT_EQ_GT] = ACTIONS(351),
    [anon_sym_LPAREN] = ACTIONS(351),
    [anon_sym_RPAREN] = ACTIONS(351),
    [anon_sym_LT] = ACTIONS(353),
    [anon_sym_GT] = ACTIONS(353),
    [anon_sym_EQ] = ACTIONS(353),
    [anon_sym_PLUS_EQ] = ACTIONS(351),
    [anon_sym_DASH_EQ] = ACTIONS(351),
    [anon_sym_STAR_EQ] = ACTIONS(351),
    [anon_sym_SLASH_EQ] = ACTIONS(351),
    [anon_sym_PERCENT_EQ] = ACTIONS(351),
    [anon_sym_AMP_EQ] = ACTIONS(351),
    [anon_sym_PIPE_EQ] = ACTIONS(351),
    [anon_sym_CARET_EQ] = ACTIONS(351),
    [anon_sym_LT_LT_EQ] = ACTIONS(351),
    [anon_sym_GT_GT_EQ] = ACTIONS(351),
    [anon_sym_DOT] = ACTIONS(351),
    [anon_sym_true] = ACTIONS(353),
    [anon_sym_false] = ACTIONS(353),
    [anon_sym_DASH] = ACTIONS(353),
    [anon_sym_BANG] = ACTIONS(353),
    [anon_sym_AMP_AMP] = ACTIONS(351),
    [anon_sym_PIPE_PIPE] = ACTIONS(351),
    [anon_sym_AMP] = ACTIONS(353),
    [anon_sym_PIPE] = ACTIONS(353),
    [anon_sym_CARET] = ACTIONS(353),
    [anon_sym_EQ_EQ] = ACTIONS(351),
    [anon_sym_BANG_EQ] = ACTIONS(351),
    [anon_sym_LT_EQ] = ACTIONS(353),
    [anon_sym_GT_EQ] = ACTIONS(351),
    [anon_sym_LT_LT] = ACTIONS(353),
    [anon_sym_GT_GT] = ACTIONS(353),
    [anon_sym_PLUS] = ACTIONS(353),
    [anon_sym_SLASH] = ACTIONS(353),
    [anon_sym_QMARK] = ACTIONS(351),
    [anon_sym_DQUOTE] = ACTIONS(351),
    [anon_sym_SQUOTE] = ACTIONS(351),
    [sym__ident_reg] = ACTIONS(353),
    [anon_sym_POUND] = ACTIONS(351),
    [sym_int_literal] = ACTIONS(353),
    [sym_float_literal] = ACTIONS(351),
    [anon_sym_ease] = ACTIONS(353),
    [anon_sym_ease_DASHin] = ACTIONS(353),
    [anon_sym_ease_in] = ACTIONS(353),
    [anon_sym_ease_in_out] = ACTIONS(353),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(353),
    [anon_sym_ease_out] = ACTIONS(353),
    [anon_sym_ease_DASHout] = ACTIONS(353),
    [anon_sym_start] = ACTIONS(353),
    [anon_sym_end] = ACTIONS(353),
    [anon_sym_black] = ACTIONS(353),
    [anon_sym_blue] = ACTIONS(353),
    [anon_sym_green] = ACTIONS(353),
    [anon_sym_red] = ACTIONS(353),
    [anon_sym_yellow] = ACTIONS(353),
    [anon_sym_white] = ACTIONS(353),
    [anon_sym_gray] = ACTIONS(353),
    [anon_sym_transparent] = ACTIONS(353),
    [anon_sym_angle] = ACTIONS(353),
    [anon_sym_bool] = ACTIONS(353),
    [anon_sym_brush] = ACTIONS(353),
    [anon_sym_color] = ACTIONS(353),
    [anon_sym_float] = ACTIONS(353),
    [anon_sym_image] = ACTIONS(353),
    [anon_sym_int] = ACTIONS(353),
    [anon_sym_length] = ACTIONS(353),
    [anon_sym_percent] = ACTIONS(353),
    [anon_sym_physical_DASHlength] = ACTIONS(353),
    [anon_sym_physical_length] = ACTIONS(353),
    [anon_sym_string] = ACTIONS(353),
    [anon_sym_debug] = ACTIONS(353),
    [anon_sym_animation_DASHtick] = ACTIONS(353),
    [anon_sym_min] = ACTIONS(353),
    [anon_sym_max] = ACTIONS(353),
    [anon_sym_mod] = ACTIONS(353),
    [anon_sym_abs] = ACTIONS(353),
    [anon_sym_round] = ACTIONS(353),
    [anon_sym_ceil] = ACTIONS(353),
    [anon_sym_floor] = ACTIONS(353),
    [anon_sym_sin] = ACTIONS(353),
    [anon_sym_cos] = ACTIONS(353),
    [anon_sym_tan] = ACTIONS(353),
    [anon_sym_asin] = ACTIONS(353),
    [anon_sym_acos] = ACTIONS(353),
    [anon_sym_atan] = ACTIONS(353),
    [anon_sym_sqrt] = ACTIONS(353),
    [anon_sym_pow] = ACTIONS(353),
    [anon_sym_log] = ACTIONS(353),
    [anon_sym_rgb] = ACTIONS(353),
    [anon_sym_easing] = ACTIONS(353),
    [anon_sym_duration] = ACTIONS(353),
    [anon_sym_parent] = ACTIONS(353),
    [anon_sym_root] = ACTIONS(353),
    [sym_comment] = ACTIONS(3),
  },
  [44] = {
    [anon_sym_LBRACE] = ACTIONS(355),
    [anon_sym_COLON] = ACTIONS(355),
    [anon_sym_COMMA] = ACTIONS(355),
    [anon_sym_RBRACE] = ACTIONS(355),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_if] = ACTIONS(357),
    [anon_sym_AT] = ACTIONS(355),
    [anon_sym_LBRACK] = ACTIONS(355),
    [anon_sym_STAR] = ACTIONS(357),
    [anon_sym_LT_EQ_GT] = ACTIONS(355),
    [anon_sym_LPAREN] = ACTIONS(355),
    [anon_sym_RPAREN] = ACTIONS(355),
    [anon_sym_LT] = ACTIONS(357),
    [anon_sym_GT] = ACTIONS(357),
    [anon_sym_EQ] = ACTIONS(357),
    [anon_sym_PLUS_EQ] = ACTIONS(355),
    [anon_sym_DASH_EQ] = ACTIONS(355),
    [anon_sym_STAR_EQ] = ACTIONS(355),
    [anon_sym_SLASH_EQ] = ACTIONS(355),
    [anon_sym_PERCENT_EQ] = ACTIONS(355),
    [anon_sym_AMP_EQ] = ACTIONS(355),
    [anon_sym_PIPE_EQ] = ACTIONS(355),
    [anon_sym_CARET_EQ] = ACTIONS(355),
    [anon_sym_LT_LT_EQ] = ACTIONS(355),
    [anon_sym_GT_GT_EQ] = ACTIONS(355),
    [anon_sym_DOT] = ACTIONS(355),
    [anon_sym_true] = ACTIONS(357),
    [anon_sym_false] = ACTIONS(357),
    [anon_sym_DASH] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(357),
    [anon_sym_AMP_AMP] = ACTIONS(355),
    [anon_sym_PIPE_PIPE] = ACTIONS(355),
    [anon_sym_AMP] = ACTIONS(357),
    [anon_sym_PIPE] = ACTIONS(357),
    [anon_sym_CARET] = ACTIONS(357),
    [anon_sym_EQ_EQ] = ACTIONS(355),
    [anon_sym_BANG_EQ] = ACTIONS(355),
    [anon_sym_LT_EQ] = ACTIONS(357),
    [anon_sym_GT_EQ] = ACTIONS(355),
    [anon_sym_LT_LT] = ACTIONS(357),
    [anon_sym_GT_GT] = ACTIONS(357),
    [anon_sym_PLUS] = ACTIONS(357),
    [anon_sym_SLASH] = ACTIONS(357),
    [anon_sym_QMARK] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(355),
    [anon_sym_SQUOTE] = ACTIONS(355),
    [sym__ident_reg] = ACTIONS(357),
    [anon_sym_POUND] = ACTIONS(355),
    [sym_int_literal] = ACTIONS(357),
    [sym_float_literal] = ACTIONS(355),
    [anon_sym_ease] = ACTIONS(357),
    [anon_sym_ease_DASHin] = ACTIONS(357),
    [anon_sym_ease_in] = ACTIONS(357),
    [anon_sym_ease_in_out] = ACTIONS(357),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(357),
    [anon_sym_ease_out] = ACTIONS(357),
    [anon_sym_ease_DASHout] = ACTIONS(357),
    [anon_sym_start] = ACTIONS(357),
    [anon_sym_end] = ACTIONS(357),
    [anon_sym_black] = ACTIONS(357),
    [anon_sym_blue] = ACTIONS(357),
    [anon_sym_green] = ACTIONS(357),
    [anon_sym_red] = ACTIONS(357),
    [anon_sym_yellow] = ACTIONS(357),
    [anon_sym_white] = ACTIONS(357),
    [anon_sym_gray] = ACTIONS(357),
    [anon_sym_transparent] = ACTIONS(357),
    [anon_sym_angle] = ACTIONS(357),
    [anon_sym_bool] = ACTIONS(357),
    [anon_sym_brush] = ACTIONS(357),
    [anon_sym_color] = ACTIONS(357),
    [anon_sym_float] = ACTIONS(357),
    [anon_sym_image] = ACTIONS(357),
    [anon_sym_int] = ACTIONS(357),
    [anon_sym_length] = ACTIONS(357),
    [anon_sym_percent] = ACTIONS(357),
    [anon_sym_physical_DASHlength] = ACTIONS(357),
    [anon_sym_physical_length] = ACTIONS(357),
    [anon_sym_string] = ACTIONS(357),
    [anon_sym_debug] = ACTIONS(357),
    [anon_sym_animation_DASHtick] = ACTIONS(357),
    [anon_sym_min] = ACTIONS(357),
    [anon_sym_max] = ACTIONS(357),
    [anon_sym_mod] = ACTIONS(357),
    [anon_sym_abs] = ACTIONS(357),
    [anon_sym_round] = ACTIONS(357),
    [anon_sym_ceil] = ACTIONS(357),
    [anon_sym_floor] = ACTIONS(357),
    [anon_sym_sin] = ACTIONS(357),
    [anon_sym_cos] = ACTIONS(357),
    [anon_sym_tan] = ACTIONS(357),
    [anon_sym_asin] = ACTIONS(357),
    [anon_sym_acos] = ACTIONS(357),
    [anon_sym_atan] = ACTIONS(357),
    [anon_sym_sqrt] = ACTIONS(357),
    [anon_sym_pow] = ACTIONS(357),
    [anon_sym_log] = ACTIONS(357),
    [anon_sym_rgb] = ACTIONS(357),
    [anon_sym_easing] = ACTIONS(357),
    [anon_sym_duration] = ACTIONS(357),
    [anon_sym_parent] = ACTIONS(357),
    [anon_sym_root] = ACTIONS(357),
    [sym_comment] = ACTIONS(3),
  },
  [45] = {
    [anon_sym_LBRACE] = ACTIONS(359),
    [anon_sym_COLON] = ACTIONS(359),
    [anon_sym_COMMA] = ACTIONS(359),
    [anon_sym_RBRACE] = ACTIONS(359),
    [anon_sym_SEMI] = ACTIONS(359),
    [anon_sym_if] = ACTIONS(361),
    [anon_sym_AT] = ACTIONS(359),
    [anon_sym_LBRACK] = ACTIONS(359),
    [anon_sym_STAR] = ACTIONS(361),
    [anon_sym_LT_EQ_GT] = ACTIONS(359),
    [anon_sym_LPAREN] = ACTIONS(359),
    [anon_sym_RPAREN] = ACTIONS(359),
    [anon_sym_LT] = ACTIONS(361),
    [anon_sym_GT] = ACTIONS(361),
    [anon_sym_EQ] = ACTIONS(361),
    [anon_sym_PLUS_EQ] = ACTIONS(359),
    [anon_sym_DASH_EQ] = ACTIONS(359),
    [anon_sym_STAR_EQ] = ACTIONS(359),
    [anon_sym_SLASH_EQ] = ACTIONS(359),
    [anon_sym_PERCENT_EQ] = ACTIONS(359),
    [anon_sym_AMP_EQ] = ACTIONS(359),
    [anon_sym_PIPE_EQ] = ACTIONS(359),
    [anon_sym_CARET_EQ] = ACTIONS(359),
    [anon_sym_LT_LT_EQ] = ACTIONS(359),
    [anon_sym_GT_GT_EQ] = ACTIONS(359),
    [anon_sym_DOT] = ACTIONS(359),
    [anon_sym_true] = ACTIONS(361),
    [anon_sym_false] = ACTIONS(361),
    [anon_sym_DASH] = ACTIONS(361),
    [anon_sym_BANG] = ACTIONS(361),
    [anon_sym_AMP_AMP] = ACTIONS(359),
    [anon_sym_PIPE_PIPE] = ACTIONS(359),
    [anon_sym_AMP] = ACTIONS(361),
    [anon_sym_PIPE] = ACTIONS(361),
    [anon_sym_CARET] = ACTIONS(361),
    [anon_sym_EQ_EQ] = ACTIONS(359),
    [anon_sym_BANG_EQ] = ACTIONS(359),
    [anon_sym_LT_EQ] = ACTIONS(361),
    [anon_sym_GT_EQ] = ACTIONS(359),
    [anon_sym_LT_LT] = ACTIONS(361),
    [anon_sym_GT_GT] = ACTIONS(361),
    [anon_sym_PLUS] = ACTIONS(361),
    [anon_sym_SLASH] = ACTIONS(361),
    [anon_sym_QMARK] = ACTIONS(359),
    [anon_sym_DQUOTE] = ACTIONS(359),
    [anon_sym_SQUOTE] = ACTIONS(359),
    [sym__ident_reg] = ACTIONS(361),
    [anon_sym_POUND] = ACTIONS(359),
    [sym_int_literal] = ACTIONS(361),
    [sym_float_literal] = ACTIONS(359),
    [anon_sym_ease] = ACTIONS(361),
    [anon_sym_ease_DASHin] = ACTIONS(361),
    [anon_sym_ease_in] = ACTIONS(361),
    [anon_sym_ease_in_out] = ACTIONS(361),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(361),
    [anon_sym_ease_out] = ACTIONS(361),
    [anon_sym_ease_DASHout] = ACTIONS(361),
    [anon_sym_start] = ACTIONS(361),
    [anon_sym_end] = ACTIONS(361),
    [anon_sym_black] = ACTIONS(361),
    [anon_sym_blue] = ACTIONS(361),
    [anon_sym_green] = ACTIONS(361),
    [anon_sym_red] = ACTIONS(361),
    [anon_sym_yellow] = ACTIONS(361),
    [anon_sym_white] = ACTIONS(361),
    [anon_sym_gray] = ACTIONS(361),
    [anon_sym_transparent] = ACTIONS(361),
    [anon_sym_angle] = ACTIONS(361),
    [anon_sym_bool] = ACTIONS(361),
    [anon_sym_brush] = ACTIONS(361),
    [anon_sym_color] = ACTIONS(361),
    [anon_sym_float] = ACTIONS(361),
    [anon_sym_image] = ACTIONS(361),
    [anon_sym_int] = ACTIONS(361),
    [anon_sym_length] = ACTIONS(361),
    [anon_sym_percent] = ACTIONS(361),
    [anon_sym_physical_DASHlength] = ACTIONS(361),
    [anon_sym_physical_length] = ACTIONS(361),
    [anon_sym_string] = ACTIONS(361),
    [anon_sym_debug] = ACTIONS(361),
    [anon_sym_animation_DASHtick] = ACTIONS(361),
    [anon_sym_min] = ACTIONS(361),
    [anon_sym_max] = ACTIONS(361),
    [anon_sym_mod] = ACTIONS(361),
    [anon_sym_abs] = ACTIONS(361),
    [anon_sym_round] = ACTIONS(361),
    [anon_sym_ceil] = ACTIONS(361),
    [anon_sym_floor] = ACTIONS(361),
    [anon_sym_sin] = ACTIONS(361),
    [anon_sym_cos] = ACTIONS(361),
    [anon_sym_tan] = ACTIONS(361),
    [anon_sym_asin] = ACTIONS(361),
    [anon_sym_acos] = ACTIONS(361),
    [anon_sym_atan] = ACTIONS(361),
    [anon_sym_sqrt] = ACTIONS(361),
    [anon_sym_pow] = ACTIONS(361),
    [anon_sym_log] = ACTIONS(361),
    [anon_sym_rgb] = ACTIONS(361),
    [anon_sym_easing] = ACTIONS(361),
    [anon_sym_duration] = ACTIONS(361),
    [anon_sym_parent] = ACTIONS(361),
    [anon_sym_root] = ACTIONS(361),
    [sym_comment] = ACTIONS(3),
  },
  [46] = {
    [anon_sym_LBRACE] = ACTIONS(363),
    [anon_sym_COLON] = ACTIONS(363),
    [anon_sym_COMMA] = ACTIONS(363),
    [anon_sym_RBRACE] = ACTIONS(363),
    [anon_sym_SEMI] = ACTIONS(363),
    [anon_sym_if] = ACTIONS(365),
    [anon_sym_AT] = ACTIONS(363),
    [anon_sym_LBRACK] = ACTIONS(363),
    [anon_sym_STAR] = ACTIONS(365),
    [anon_sym_LT_EQ_GT] = ACTIONS(363),
    [anon_sym_LPAREN] = ACTIONS(363),
    [anon_sym_RPAREN] = ACTIONS(363),
    [anon_sym_LT] = ACTIONS(365),
    [anon_sym_GT] = ACTIONS(365),
    [anon_sym_EQ] = ACTIONS(365),
    [anon_sym_PLUS_EQ] = ACTIONS(363),
    [anon_sym_DASH_EQ] = ACTIONS(363),
    [anon_sym_STAR_EQ] = ACTIONS(363),
    [anon_sym_SLASH_EQ] = ACTIONS(363),
    [anon_sym_PERCENT_EQ] = ACTIONS(363),
    [anon_sym_AMP_EQ] = ACTIONS(363),
    [anon_sym_PIPE_EQ] = ACTIONS(363),
    [anon_sym_CARET_EQ] = ACTIONS(363),
    [anon_sym_LT_LT_EQ] = ACTIONS(363),
    [anon_sym_GT_GT_EQ] = ACTIONS(363),
    [anon_sym_DOT] = ACTIONS(363),
    [anon_sym_true] = ACTIONS(365),
    [anon_sym_false] = ACTIONS(365),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(365),
    [anon_sym_AMP_AMP] = ACTIONS(363),
    [anon_sym_PIPE_PIPE] = ACTIONS(363),
    [anon_sym_AMP] = ACTIONS(365),
    [anon_sym_PIPE] = ACTIONS(365),
    [anon_sym_CARET] = ACTIONS(365),
    [anon_sym_EQ_EQ] = ACTIONS(363),
    [anon_sym_BANG_EQ] = ACTIONS(363),
    [anon_sym_LT_EQ] = ACTIONS(365),
    [anon_sym_GT_EQ] = ACTIONS(363),
    [anon_sym_LT_LT] = ACTIONS(365),
    [anon_sym_GT_GT] = ACTIONS(365),
    [anon_sym_PLUS] = ACTIONS(365),
    [anon_sym_SLASH] = ACTIONS(365),
    [anon_sym_QMARK] = ACTIONS(363),
    [anon_sym_DQUOTE] = ACTIONS(363),
    [anon_sym_SQUOTE] = ACTIONS(363),
    [sym__ident_reg] = ACTIONS(365),
    [anon_sym_POUND] = ACTIONS(363),
    [sym_int_literal] = ACTIONS(365),
    [sym_float_literal] = ACTIONS(363),
    [anon_sym_ease] = ACTIONS(365),
    [anon_sym_ease_DASHin] = ACTIONS(365),
    [anon_sym_ease_in] = ACTIONS(365),
    [anon_sym_ease_in_out] = ACTIONS(365),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(365),
    [anon_sym_ease_out] = ACTIONS(365),
    [anon_sym_ease_DASHout] = ACTIONS(365),
    [anon_sym_start] = ACTIONS(365),
    [anon_sym_end] = ACTIONS(365),
    [anon_sym_black] = ACTIONS(365),
    [anon_sym_blue] = ACTIONS(365),
    [anon_sym_green] = ACTIONS(365),
    [anon_sym_red] = ACTIONS(365),
    [anon_sym_yellow] = ACTIONS(365),
    [anon_sym_white] = ACTIONS(365),
    [anon_sym_gray] = ACTIONS(365),
    [anon_sym_transparent] = ACTIONS(365),
    [anon_sym_angle] = ACTIONS(365),
    [anon_sym_bool] = ACTIONS(365),
    [anon_sym_brush] = ACTIONS(365),
    [anon_sym_color] = ACTIONS(365),
    [anon_sym_float] = ACTIONS(365),
    [anon_sym_image] = ACTIONS(365),
    [anon_sym_int] = ACTIONS(365),
    [anon_sym_length] = ACTIONS(365),
    [anon_sym_percent] = ACTIONS(365),
    [anon_sym_physical_DASHlength] = ACTIONS(365),
    [anon_sym_physical_length] = ACTIONS(365),
    [anon_sym_string] = ACTIONS(365),
    [anon_sym_debug] = ACTIONS(365),
    [anon_sym_animation_DASHtick] = ACTIONS(365),
    [anon_sym_min] = ACTIONS(365),
    [anon_sym_max] = ACTIONS(365),
    [anon_sym_mod] = ACTIONS(365),
    [anon_sym_abs] = ACTIONS(365),
    [anon_sym_round] = ACTIONS(365),
    [anon_sym_ceil] = ACTIONS(365),
    [anon_sym_floor] = ACTIONS(365),
    [anon_sym_sin] = ACTIONS(365),
    [anon_sym_cos] = ACTIONS(365),
    [anon_sym_tan] = ACTIONS(365),
    [anon_sym_asin] = ACTIONS(365),
    [anon_sym_acos] = ACTIONS(365),
    [anon_sym_atan] = ACTIONS(365),
    [anon_sym_sqrt] = ACTIONS(365),
    [anon_sym_pow] = ACTIONS(365),
    [anon_sym_log] = ACTIONS(365),
    [anon_sym_rgb] = ACTIONS(365),
    [anon_sym_easing] = ACTIONS(365),
    [anon_sym_duration] = ACTIONS(365),
    [anon_sym_parent] = ACTIONS(365),
    [anon_sym_root] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
  },
  [47] = {
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_COLON] = ACTIONS(367),
    [anon_sym_COMMA] = ACTIONS(367),
    [anon_sym_RBRACE] = ACTIONS(367),
    [anon_sym_SEMI] = ACTIONS(367),
    [anon_sym_if] = ACTIONS(369),
    [anon_sym_AT] = ACTIONS(367),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_STAR] = ACTIONS(369),
    [anon_sym_LT_EQ_GT] = ACTIONS(367),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_RPAREN] = ACTIONS(367),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_EQ] = ACTIONS(369),
    [anon_sym_PLUS_EQ] = ACTIONS(367),
    [anon_sym_DASH_EQ] = ACTIONS(367),
    [anon_sym_STAR_EQ] = ACTIONS(367),
    [anon_sym_SLASH_EQ] = ACTIONS(367),
    [anon_sym_PERCENT_EQ] = ACTIONS(367),
    [anon_sym_AMP_EQ] = ACTIONS(367),
    [anon_sym_PIPE_EQ] = ACTIONS(367),
    [anon_sym_CARET_EQ] = ACTIONS(367),
    [anon_sym_LT_LT_EQ] = ACTIONS(367),
    [anon_sym_GT_GT_EQ] = ACTIONS(367),
    [anon_sym_DOT] = ACTIONS(367),
    [anon_sym_true] = ACTIONS(369),
    [anon_sym_false] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(369),
    [anon_sym_BANG] = ACTIONS(369),
    [anon_sym_AMP_AMP] = ACTIONS(367),
    [anon_sym_PIPE_PIPE] = ACTIONS(367),
    [anon_sym_AMP] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(369),
    [anon_sym_CARET] = ACTIONS(369),
    [anon_sym_EQ_EQ] = ACTIONS(367),
    [anon_sym_BANG_EQ] = ACTIONS(367),
    [anon_sym_LT_EQ] = ACTIONS(369),
    [anon_sym_GT_EQ] = ACTIONS(367),
    [anon_sym_LT_LT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_SLASH] = ACTIONS(369),
    [anon_sym_QMARK] = ACTIONS(367),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(367),
    [sym__ident_reg] = ACTIONS(369),
    [anon_sym_POUND] = ACTIONS(367),
    [sym_int_literal] = ACTIONS(369),
    [sym_float_literal] = ACTIONS(367),
    [anon_sym_ease] = ACTIONS(369),
    [anon_sym_ease_DASHin] = ACTIONS(369),
    [anon_sym_ease_in] = ACTIONS(369),
    [anon_sym_ease_in_out] = ACTIONS(369),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(369),
    [anon_sym_ease_out] = ACTIONS(369),
    [anon_sym_ease_DASHout] = ACTIONS(369),
    [anon_sym_start] = ACTIONS(369),
    [anon_sym_end] = ACTIONS(369),
    [anon_sym_black] = ACTIONS(369),
    [anon_sym_blue] = ACTIONS(369),
    [anon_sym_green] = ACTIONS(369),
    [anon_sym_red] = ACTIONS(369),
    [anon_sym_yellow] = ACTIONS(369),
    [anon_sym_white] = ACTIONS(369),
    [anon_sym_gray] = ACTIONS(369),
    [anon_sym_transparent] = ACTIONS(369),
    [anon_sym_angle] = ACTIONS(369),
    [anon_sym_bool] = ACTIONS(369),
    [anon_sym_brush] = ACTIONS(369),
    [anon_sym_color] = ACTIONS(369),
    [anon_sym_float] = ACTIONS(369),
    [anon_sym_image] = ACTIONS(369),
    [anon_sym_int] = ACTIONS(369),
    [anon_sym_length] = ACTIONS(369),
    [anon_sym_percent] = ACTIONS(369),
    [anon_sym_physical_DASHlength] = ACTIONS(369),
    [anon_sym_physical_length] = ACTIONS(369),
    [anon_sym_string] = ACTIONS(369),
    [anon_sym_debug] = ACTIONS(369),
    [anon_sym_animation_DASHtick] = ACTIONS(369),
    [anon_sym_min] = ACTIONS(369),
    [anon_sym_max] = ACTIONS(369),
    [anon_sym_mod] = ACTIONS(369),
    [anon_sym_abs] = ACTIONS(369),
    [anon_sym_round] = ACTIONS(369),
    [anon_sym_ceil] = ACTIONS(369),
    [anon_sym_floor] = ACTIONS(369),
    [anon_sym_sin] = ACTIONS(369),
    [anon_sym_cos] = ACTIONS(369),
    [anon_sym_tan] = ACTIONS(369),
    [anon_sym_asin] = ACTIONS(369),
    [anon_sym_acos] = ACTIONS(369),
    [anon_sym_atan] = ACTIONS(369),
    [anon_sym_sqrt] = ACTIONS(369),
    [anon_sym_pow] = ACTIONS(369),
    [anon_sym_log] = ACTIONS(369),
    [anon_sym_rgb] = ACTIONS(369),
    [anon_sym_easing] = ACTIONS(369),
    [anon_sym_duration] = ACTIONS(369),
    [anon_sym_parent] = ACTIONS(369),
    [anon_sym_root] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
  },
  [48] = {
    [anon_sym_LBRACE] = ACTIONS(371),
    [anon_sym_COLON] = ACTIONS(371),
    [anon_sym_COMMA] = ACTIONS(371),
    [anon_sym_RBRACE] = ACTIONS(371),
    [anon_sym_SEMI] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_AT] = ACTIONS(371),
    [anon_sym_LBRACK] = ACTIONS(371),
    [anon_sym_STAR] = ACTIONS(373),
    [anon_sym_LT_EQ_GT] = ACTIONS(371),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_RPAREN] = ACTIONS(371),
    [anon_sym_LT] = ACTIONS(373),
    [anon_sym_GT] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(373),
    [anon_sym_PLUS_EQ] = ACTIONS(371),
    [anon_sym_DASH_EQ] = ACTIONS(371),
    [anon_sym_STAR_EQ] = ACTIONS(371),
    [anon_sym_SLASH_EQ] = ACTIONS(371),
    [anon_sym_PERCENT_EQ] = ACTIONS(371),
    [anon_sym_AMP_EQ] = ACTIONS(371),
    [anon_sym_PIPE_EQ] = ACTIONS(371),
    [anon_sym_CARET_EQ] = ACTIONS(371),
    [anon_sym_LT_LT_EQ] = ACTIONS(371),
    [anon_sym_GT_GT_EQ] = ACTIONS(371),
    [anon_sym_DOT] = ACTIONS(371),
    [anon_sym_true] = ACTIONS(373),
    [anon_sym_false] = ACTIONS(373),
    [anon_sym_DASH] = ACTIONS(373),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_AMP_AMP] = ACTIONS(371),
    [anon_sym_PIPE_PIPE] = ACTIONS(371),
    [anon_sym_AMP] = ACTIONS(373),
    [anon_sym_PIPE] = ACTIONS(373),
    [anon_sym_CARET] = ACTIONS(373),
    [anon_sym_EQ_EQ] = ACTIONS(371),
    [anon_sym_BANG_EQ] = ACTIONS(371),
    [anon_sym_LT_EQ] = ACTIONS(373),
    [anon_sym_GT_EQ] = ACTIONS(371),
    [anon_sym_LT_LT] = ACTIONS(373),
    [anon_sym_GT_GT] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(373),
    [anon_sym_SLASH] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [sym__ident_reg] = ACTIONS(373),
    [anon_sym_POUND] = ACTIONS(371),
    [sym_int_literal] = ACTIONS(373),
    [sym_float_literal] = ACTIONS(371),
    [anon_sym_ease] = ACTIONS(373),
    [anon_sym_ease_DASHin] = ACTIONS(373),
    [anon_sym_ease_in] = ACTIONS(373),
    [anon_sym_ease_in_out] = ACTIONS(373),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(373),
    [anon_sym_ease_out] = ACTIONS(373),
    [anon_sym_ease_DASHout] = ACTIONS(373),
    [anon_sym_start] = ACTIONS(373),
    [anon_sym_end] = ACTIONS(373),
    [anon_sym_black] = ACTIONS(373),
    [anon_sym_blue] = ACTIONS(373),
    [anon_sym_green] = ACTIONS(373),
    [anon_sym_red] = ACTIONS(373),
    [anon_sym_yellow] = ACTIONS(373),
    [anon_sym_white] = ACTIONS(373),
    [anon_sym_gray] = ACTIONS(373),
    [anon_sym_transparent] = ACTIONS(373),
    [anon_sym_angle] = ACTIONS(373),
    [anon_sym_bool] = ACTIONS(373),
    [anon_sym_brush] = ACTIONS(373),
    [anon_sym_color] = ACTIONS(373),
    [anon_sym_float] = ACTIONS(373),
    [anon_sym_image] = ACTIONS(373),
    [anon_sym_int] = ACTIONS(373),
    [anon_sym_length] = ACTIONS(373),
    [anon_sym_percent] = ACTIONS(373),
    [anon_sym_physical_DASHlength] = ACTIONS(373),
    [anon_sym_physical_length] = ACTIONS(373),
    [anon_sym_string] = ACTIONS(373),
    [anon_sym_debug] = ACTIONS(373),
    [anon_sym_animation_DASHtick] = ACTIONS(373),
    [anon_sym_min] = ACTIONS(373),
    [anon_sym_max] = ACTIONS(373),
    [anon_sym_mod] = ACTIONS(373),
    [anon_sym_abs] = ACTIONS(373),
    [anon_sym_round] = ACTIONS(373),
    [anon_sym_ceil] = ACTIONS(373),
    [anon_sym_floor] = ACTIONS(373),
    [anon_sym_sin] = ACTIONS(373),
    [anon_sym_cos] = ACTIONS(373),
    [anon_sym_tan] = ACTIONS(373),
    [anon_sym_asin] = ACTIONS(373),
    [anon_sym_acos] = ACTIONS(373),
    [anon_sym_atan] = ACTIONS(373),
    [anon_sym_sqrt] = ACTIONS(373),
    [anon_sym_pow] = ACTIONS(373),
    [anon_sym_log] = ACTIONS(373),
    [anon_sym_rgb] = ACTIONS(373),
    [anon_sym_easing] = ACTIONS(373),
    [anon_sym_duration] = ACTIONS(373),
    [anon_sym_parent] = ACTIONS(373),
    [anon_sym_root] = ACTIONS(373),
    [sym_comment] = ACTIONS(3),
  },
  [49] = {
    [anon_sym_LBRACE] = ACTIONS(375),
    [anon_sym_COLON] = ACTIONS(375),
    [anon_sym_COMMA] = ACTIONS(375),
    [anon_sym_RBRACE] = ACTIONS(375),
    [anon_sym_SEMI] = ACTIONS(375),
    [anon_sym_if] = ACTIONS(377),
    [anon_sym_AT] = ACTIONS(375),
    [anon_sym_LBRACK] = ACTIONS(375),
    [anon_sym_STAR] = ACTIONS(377),
    [anon_sym_LT_EQ_GT] = ACTIONS(375),
    [anon_sym_LPAREN] = ACTIONS(375),
    [anon_sym_RPAREN] = ACTIONS(375),
    [anon_sym_LT] = ACTIONS(377),
    [anon_sym_GT] = ACTIONS(377),
    [anon_sym_EQ] = ACTIONS(377),
    [anon_sym_PLUS_EQ] = ACTIONS(375),
    [anon_sym_DASH_EQ] = ACTIONS(375),
    [anon_sym_STAR_EQ] = ACTIONS(375),
    [anon_sym_SLASH_EQ] = ACTIONS(375),
    [anon_sym_PERCENT_EQ] = ACTIONS(375),
    [anon_sym_AMP_EQ] = ACTIONS(375),
    [anon_sym_PIPE_EQ] = ACTIONS(375),
    [anon_sym_CARET_EQ] = ACTIONS(375),
    [anon_sym_LT_LT_EQ] = ACTIONS(375),
    [anon_sym_GT_GT_EQ] = ACTIONS(375),
    [anon_sym_DOT] = ACTIONS(375),
    [anon_sym_true] = ACTIONS(377),
    [anon_sym_false] = ACTIONS(377),
    [anon_sym_DASH] = ACTIONS(377),
    [anon_sym_BANG] = ACTIONS(377),
    [anon_sym_AMP_AMP] = ACTIONS(375),
    [anon_sym_PIPE_PIPE] = ACTIONS(375),
    [anon_sym_AMP] = ACTIONS(377),
    [anon_sym_PIPE] = ACTIONS(377),
    [anon_sym_CARET] = ACTIONS(377),
    [anon_sym_EQ_EQ] = ACTIONS(375),
    [anon_sym_BANG_EQ] = ACTIONS(375),
    [anon_sym_LT_EQ] = ACTIONS(377),
    [anon_sym_GT_EQ] = ACTIONS(375),
    [anon_sym_LT_LT] = ACTIONS(377),
    [anon_sym_GT_GT] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(377),
    [anon_sym_SLASH] = ACTIONS(377),
    [anon_sym_QMARK] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(375),
    [anon_sym_SQUOTE] = ACTIONS(375),
    [sym__ident_reg] = ACTIONS(377),
    [anon_sym_POUND] = ACTIONS(375),
    [sym_int_literal] = ACTIONS(377),
    [sym_float_literal] = ACTIONS(375),
    [anon_sym_ease] = ACTIONS(377),
    [anon_sym_ease_DASHin] = ACTIONS(377),
    [anon_sym_ease_in] = ACTIONS(377),
    [anon_sym_ease_in_out] = ACTIONS(377),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(377),
    [anon_sym_ease_out] = ACTIONS(377),
    [anon_sym_ease_DASHout] = ACTIONS(377),
    [anon_sym_start] = ACTIONS(377),
    [anon_sym_end] = ACTIONS(377),
    [anon_sym_black] = ACTIONS(377),
    [anon_sym_blue] = ACTIONS(377),
    [anon_sym_green] = ACTIONS(377),
    [anon_sym_red] = ACTIONS(377),
    [anon_sym_yellow] = ACTIONS(377),
    [anon_sym_white] = ACTIONS(377),
    [anon_sym_gray] = ACTIONS(377),
    [anon_sym_transparent] = ACTIONS(377),
    [anon_sym_angle] = ACTIONS(377),
    [anon_sym_bool] = ACTIONS(377),
    [anon_sym_brush] = ACTIONS(377),
    [anon_sym_color] = ACTIONS(377),
    [anon_sym_float] = ACTIONS(377),
    [anon_sym_image] = ACTIONS(377),
    [anon_sym_int] = ACTIONS(377),
    [anon_sym_length] = ACTIONS(377),
    [anon_sym_percent] = ACTIONS(377),
    [anon_sym_physical_DASHlength] = ACTIONS(377),
    [anon_sym_physical_length] = ACTIONS(377),
    [anon_sym_string] = ACTIONS(377),
    [anon_sym_debug] = ACTIONS(377),
    [anon_sym_animation_DASHtick] = ACTIONS(377),
    [anon_sym_min] = ACTIONS(377),
    [anon_sym_max] = ACTIONS(377),
    [anon_sym_mod] = ACTIONS(377),
    [anon_sym_abs] = ACTIONS(377),
    [anon_sym_round] = ACTIONS(377),
    [anon_sym_ceil] = ACTIONS(377),
    [anon_sym_floor] = ACTIONS(377),
    [anon_sym_sin] = ACTIONS(377),
    [anon_sym_cos] = ACTIONS(377),
    [anon_sym_tan] = ACTIONS(377),
    [anon_sym_asin] = ACTIONS(377),
    [anon_sym_acos] = ACTIONS(377),
    [anon_sym_atan] = ACTIONS(377),
    [anon_sym_sqrt] = ACTIONS(377),
    [anon_sym_pow] = ACTIONS(377),
    [anon_sym_log] = ACTIONS(377),
    [anon_sym_rgb] = ACTIONS(377),
    [anon_sym_easing] = ACTIONS(377),
    [anon_sym_duration] = ACTIONS(377),
    [anon_sym_parent] = ACTIONS(377),
    [anon_sym_root] = ACTIONS(377),
    [sym_comment] = ACTIONS(3),
  },
  [50] = {
    [anon_sym_LBRACE] = ACTIONS(379),
    [anon_sym_COLON] = ACTIONS(379),
    [anon_sym_COMMA] = ACTIONS(379),
    [anon_sym_RBRACE] = ACTIONS(379),
    [anon_sym_SEMI] = ACTIONS(379),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_AT] = ACTIONS(379),
    [anon_sym_LBRACK] = ACTIONS(379),
    [anon_sym_STAR] = ACTIONS(381),
    [anon_sym_LT_EQ_GT] = ACTIONS(379),
    [anon_sym_LPAREN] = ACTIONS(379),
    [anon_sym_RPAREN] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_GT] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(381),
    [anon_sym_PLUS_EQ] = ACTIONS(379),
    [anon_sym_DASH_EQ] = ACTIONS(379),
    [anon_sym_STAR_EQ] = ACTIONS(379),
    [anon_sym_SLASH_EQ] = ACTIONS(379),
    [anon_sym_PERCENT_EQ] = ACTIONS(379),
    [anon_sym_AMP_EQ] = ACTIONS(379),
    [anon_sym_PIPE_EQ] = ACTIONS(379),
    [anon_sym_CARET_EQ] = ACTIONS(379),
    [anon_sym_LT_LT_EQ] = ACTIONS(379),
    [anon_sym_GT_GT_EQ] = ACTIONS(379),
    [anon_sym_DOT] = ACTIONS(379),
    [anon_sym_true] = ACTIONS(381),
    [anon_sym_false] = ACTIONS(381),
    [anon_sym_DASH] = ACTIONS(381),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_AMP_AMP] = ACTIONS(379),
    [anon_sym_PIPE_PIPE] = ACTIONS(379),
    [anon_sym_AMP] = ACTIONS(381),
    [anon_sym_PIPE] = ACTIONS(381),
    [anon_sym_CARET] = ACTIONS(381),
    [anon_sym_EQ_EQ] = ACTIONS(379),
    [anon_sym_BANG_EQ] = ACTIONS(379),
    [anon_sym_LT_EQ] = ACTIONS(381),
    [anon_sym_GT_EQ] = ACTIONS(379),
    [anon_sym_LT_LT] = ACTIONS(381),
    [anon_sym_GT_GT] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(381),
    [anon_sym_SLASH] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [sym__ident_reg] = ACTIONS(381),
    [anon_sym_POUND] = ACTIONS(379),
    [sym_int_literal] = ACTIONS(381),
    [sym_float_literal] = ACTIONS(379),
    [anon_sym_ease] = ACTIONS(381),
    [anon_sym_ease_DASHin] = ACTIONS(381),
    [anon_sym_ease_in] = ACTIONS(381),
    [anon_sym_ease_in_out] = ACTIONS(381),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(381),
    [anon_sym_ease_out] = ACTIONS(381),
    [anon_sym_ease_DASHout] = ACTIONS(381),
    [anon_sym_start] = ACTIONS(381),
    [anon_sym_end] = ACTIONS(381),
    [anon_sym_black] = ACTIONS(381),
    [anon_sym_blue] = ACTIONS(381),
    [anon_sym_green] = ACTIONS(381),
    [anon_sym_red] = ACTIONS(381),
    [anon_sym_yellow] = ACTIONS(381),
    [anon_sym_white] = ACTIONS(381),
    [anon_sym_gray] = ACTIONS(381),
    [anon_sym_transparent] = ACTIONS(381),
    [anon_sym_angle] = ACTIONS(381),
    [anon_sym_bool] = ACTIONS(381),
    [anon_sym_brush] = ACTIONS(381),
    [anon_sym_color] = ACTIONS(381),
    [anon_sym_float] = ACTIONS(381),
    [anon_sym_image] = ACTIONS(381),
    [anon_sym_int] = ACTIONS(381),
    [anon_sym_length] = ACTIONS(381),
    [anon_sym_percent] = ACTIONS(381),
    [anon_sym_physical_DASHlength] = ACTIONS(381),
    [anon_sym_physical_length] = ACTIONS(381),
    [anon_sym_string] = ACTIONS(381),
    [anon_sym_debug] = ACTIONS(381),
    [anon_sym_animation_DASHtick] = ACTIONS(381),
    [anon_sym_min] = ACTIONS(381),
    [anon_sym_max] = ACTIONS(381),
    [anon_sym_mod] = ACTIONS(381),
    [anon_sym_abs] = ACTIONS(381),
    [anon_sym_round] = ACTIONS(381),
    [anon_sym_ceil] = ACTIONS(381),
    [anon_sym_floor] = ACTIONS(381),
    [anon_sym_sin] = ACTIONS(381),
    [anon_sym_cos] = ACTIONS(381),
    [anon_sym_tan] = ACTIONS(381),
    [anon_sym_asin] = ACTIONS(381),
    [anon_sym_acos] = ACTIONS(381),
    [anon_sym_atan] = ACTIONS(381),
    [anon_sym_sqrt] = ACTIONS(381),
    [anon_sym_pow] = ACTIONS(381),
    [anon_sym_log] = ACTIONS(381),
    [anon_sym_rgb] = ACTIONS(381),
    [anon_sym_easing] = ACTIONS(381),
    [anon_sym_duration] = ACTIONS(381),
    [anon_sym_parent] = ACTIONS(381),
    [anon_sym_root] = ACTIONS(381),
    [sym_comment] = ACTIONS(3),
  },
  [51] = {
    [anon_sym_LBRACE] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(383),
    [anon_sym_COMMA] = ACTIONS(383),
    [anon_sym_RBRACE] = ACTIONS(383),
    [anon_sym_SEMI] = ACTIONS(383),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_AT] = ACTIONS(383),
    [anon_sym_LBRACK] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_LT_EQ_GT] = ACTIONS(383),
    [anon_sym_LPAREN] = ACTIONS(383),
    [anon_sym_RPAREN] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_PLUS_EQ] = ACTIONS(383),
    [anon_sym_DASH_EQ] = ACTIONS(383),
    [anon_sym_STAR_EQ] = ACTIONS(383),
    [anon_sym_SLASH_EQ] = ACTIONS(383),
    [anon_sym_PERCENT_EQ] = ACTIONS(383),
    [anon_sym_AMP_EQ] = ACTIONS(383),
    [anon_sym_PIPE_EQ] = ACTIONS(383),
    [anon_sym_CARET_EQ] = ACTIONS(383),
    [anon_sym_LT_LT_EQ] = ACTIONS(383),
    [anon_sym_GT_GT_EQ] = ACTIONS(383),
    [anon_sym_DOT] = ACTIONS(383),
    [anon_sym_true] = ACTIONS(385),
    [anon_sym_false] = ACTIONS(385),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_CARET] = ACTIONS(385),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_LT_EQ] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_LT_LT] = ACTIONS(385),
    [anon_sym_GT_GT] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [sym__ident_reg] = ACTIONS(385),
    [anon_sym_POUND] = ACTIONS(383),
    [sym_int_literal] = ACTIONS(385),
    [sym_float_literal] = ACTIONS(383),
    [anon_sym_ease] = ACTIONS(385),
    [anon_sym_ease_DASHin] = ACTIONS(385),
    [anon_sym_ease_in] = ACTIONS(385),
    [anon_sym_ease_in_out] = ACTIONS(385),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(385),
    [anon_sym_ease_out] = ACTIONS(385),
    [anon_sym_ease_DASHout] = ACTIONS(385),
    [anon_sym_start] = ACTIONS(385),
    [anon_sym_end] = ACTIONS(385),
    [anon_sym_black] = ACTIONS(385),
    [anon_sym_blue] = ACTIONS(385),
    [anon_sym_green] = ACTIONS(385),
    [anon_sym_red] = ACTIONS(385),
    [anon_sym_yellow] = ACTIONS(385),
    [anon_sym_white] = ACTIONS(385),
    [anon_sym_gray] = ACTIONS(385),
    [anon_sym_transparent] = ACTIONS(385),
    [anon_sym_angle] = ACTIONS(385),
    [anon_sym_bool] = ACTIONS(385),
    [anon_sym_brush] = ACTIONS(385),
    [anon_sym_color] = ACTIONS(385),
    [anon_sym_float] = ACTIONS(385),
    [anon_sym_image] = ACTIONS(385),
    [anon_sym_int] = ACTIONS(385),
    [anon_sym_length] = ACTIONS(385),
    [anon_sym_percent] = ACTIONS(385),
    [anon_sym_physical_DASHlength] = ACTIONS(385),
    [anon_sym_physical_length] = ACTIONS(385),
    [anon_sym_string] = ACTIONS(385),
    [anon_sym_debug] = ACTIONS(385),
    [anon_sym_animation_DASHtick] = ACTIONS(385),
    [anon_sym_min] = ACTIONS(385),
    [anon_sym_max] = ACTIONS(385),
    [anon_sym_mod] = ACTIONS(385),
    [anon_sym_abs] = ACTIONS(385),
    [anon_sym_round] = ACTIONS(385),
    [anon_sym_ceil] = ACTIONS(385),
    [anon_sym_floor] = ACTIONS(385),
    [anon_sym_sin] = ACTIONS(385),
    [anon_sym_cos] = ACTIONS(385),
    [anon_sym_tan] = ACTIONS(385),
    [anon_sym_asin] = ACTIONS(385),
    [anon_sym_acos] = ACTIONS(385),
    [anon_sym_atan] = ACTIONS(385),
    [anon_sym_sqrt] = ACTIONS(385),
    [anon_sym_pow] = ACTIONS(385),
    [anon_sym_log] = ACTIONS(385),
    [anon_sym_rgb] = ACTIONS(385),
    [anon_sym_easing] = ACTIONS(385),
    [anon_sym_duration] = ACTIONS(385),
    [anon_sym_parent] = ACTIONS(385),
    [anon_sym_root] = ACTIONS(385),
    [sym_comment] = ACTIONS(3),
  },
  [52] = {
    [anon_sym_LBRACE] = ACTIONS(387),
    [anon_sym_COLON] = ACTIONS(387),
    [anon_sym_COMMA] = ACTIONS(387),
    [anon_sym_RBRACE] = ACTIONS(387),
    [anon_sym_SEMI] = ACTIONS(387),
    [anon_sym_if] = ACTIONS(389),
    [anon_sym_AT] = ACTIONS(387),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_STAR] = ACTIONS(389),
    [anon_sym_LT_EQ_GT] = ACTIONS(387),
    [anon_sym_LPAREN] = ACTIONS(387),
    [anon_sym_RPAREN] = ACTIONS(387),
    [anon_sym_LT] = ACTIONS(389),
    [anon_sym_GT] = ACTIONS(389),
    [anon_sym_EQ] = ACTIONS(389),
    [anon_sym_PLUS_EQ] = ACTIONS(387),
    [anon_sym_DASH_EQ] = ACTIONS(387),
    [anon_sym_STAR_EQ] = ACTIONS(387),
    [anon_sym_SLASH_EQ] = ACTIONS(387),
    [anon_sym_PERCENT_EQ] = ACTIONS(387),
    [anon_sym_AMP_EQ] = ACTIONS(387),
    [anon_sym_PIPE_EQ] = ACTIONS(387),
    [anon_sym_CARET_EQ] = ACTIONS(387),
    [anon_sym_LT_LT_EQ] = ACTIONS(387),
    [anon_sym_GT_GT_EQ] = ACTIONS(387),
    [anon_sym_DOT] = ACTIONS(387),
    [anon_sym_true] = ACTIONS(389),
    [anon_sym_false] = ACTIONS(389),
    [anon_sym_DASH] = ACTIONS(389),
    [anon_sym_BANG] = ACTIONS(389),
    [anon_sym_AMP_AMP] = ACTIONS(387),
    [anon_sym_PIPE_PIPE] = ACTIONS(387),
    [anon_sym_AMP] = ACTIONS(389),
    [anon_sym_PIPE] = ACTIONS(389),
    [anon_sym_CARET] = ACTIONS(389),
    [anon_sym_EQ_EQ] = ACTIONS(387),
    [anon_sym_BANG_EQ] = ACTIONS(387),
    [anon_sym_LT_EQ] = ACTIONS(389),
    [anon_sym_GT_EQ] = ACTIONS(387),
    [anon_sym_LT_LT] = ACTIONS(389),
    [anon_sym_GT_GT] = ACTIONS(389),
    [anon_sym_PLUS] = ACTIONS(389),
    [anon_sym_SLASH] = ACTIONS(389),
    [anon_sym_QMARK] = ACTIONS(387),
    [anon_sym_DQUOTE] = ACTIONS(387),
    [anon_sym_SQUOTE] = ACTIONS(387),
    [sym__ident_reg] = ACTIONS(389),
    [anon_sym_POUND] = ACTIONS(387),
    [sym_int_literal] = ACTIONS(389),
    [sym_float_literal] = ACTIONS(387),
    [anon_sym_ease] = ACTIONS(389),
    [anon_sym_ease_DASHin] = ACTIONS(389),
    [anon_sym_ease_in] = ACTIONS(389),
    [anon_sym_ease_in_out] = ACTIONS(389),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(389),
    [anon_sym_ease_out] = ACTIONS(389),
    [anon_sym_ease_DASHout] = ACTIONS(389),
    [anon_sym_start] = ACTIONS(389),
    [anon_sym_end] = ACTIONS(389),
    [anon_sym_black] = ACTIONS(389),
    [anon_sym_blue] = ACTIONS(389),
    [anon_sym_green] = ACTIONS(389),
    [anon_sym_red] = ACTIONS(389),
    [anon_sym_yellow] = ACTIONS(389),
    [anon_sym_white] = ACTIONS(389),
    [anon_sym_gray] = ACTIONS(389),
    [anon_sym_transparent] = ACTIONS(389),
    [anon_sym_angle] = ACTIONS(389),
    [anon_sym_bool] = ACTIONS(389),
    [anon_sym_brush] = ACTIONS(389),
    [anon_sym_color] = ACTIONS(389),
    [anon_sym_float] = ACTIONS(389),
    [anon_sym_image] = ACTIONS(389),
    [anon_sym_int] = ACTIONS(389),
    [anon_sym_length] = ACTIONS(389),
    [anon_sym_percent] = ACTIONS(389),
    [anon_sym_physical_DASHlength] = ACTIONS(389),
    [anon_sym_physical_length] = ACTIONS(389),
    [anon_sym_string] = ACTIONS(389),
    [anon_sym_debug] = ACTIONS(389),
    [anon_sym_animation_DASHtick] = ACTIONS(389),
    [anon_sym_min] = ACTIONS(389),
    [anon_sym_max] = ACTIONS(389),
    [anon_sym_mod] = ACTIONS(389),
    [anon_sym_abs] = ACTIONS(389),
    [anon_sym_round] = ACTIONS(389),
    [anon_sym_ceil] = ACTIONS(389),
    [anon_sym_floor] = ACTIONS(389),
    [anon_sym_sin] = ACTIONS(389),
    [anon_sym_cos] = ACTIONS(389),
    [anon_sym_tan] = ACTIONS(389),
    [anon_sym_asin] = ACTIONS(389),
    [anon_sym_acos] = ACTIONS(389),
    [anon_sym_atan] = ACTIONS(389),
    [anon_sym_sqrt] = ACTIONS(389),
    [anon_sym_pow] = ACTIONS(389),
    [anon_sym_log] = ACTIONS(389),
    [anon_sym_rgb] = ACTIONS(389),
    [anon_sym_easing] = ACTIONS(389),
    [anon_sym_duration] = ACTIONS(389),
    [anon_sym_parent] = ACTIONS(389),
    [anon_sym_root] = ACTIONS(389),
    [sym_comment] = ACTIONS(3),
  },
  [53] = {
    [anon_sym_LBRACE] = ACTIONS(391),
    [anon_sym_COLON] = ACTIONS(391),
    [anon_sym_COMMA] = ACTIONS(391),
    [anon_sym_RBRACE] = ACTIONS(391),
    [anon_sym_SEMI] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_AT] = ACTIONS(391),
    [anon_sym_LBRACK] = ACTIONS(391),
    [anon_sym_STAR] = ACTIONS(393),
    [anon_sym_LT_EQ_GT] = ACTIONS(391),
    [anon_sym_LPAREN] = ACTIONS(391),
    [anon_sym_RPAREN] = ACTIONS(391),
    [anon_sym_LT] = ACTIONS(393),
    [anon_sym_GT] = ACTIONS(393),
    [anon_sym_EQ] = ACTIONS(393),
    [anon_sym_PLUS_EQ] = ACTIONS(391),
    [anon_sym_DASH_EQ] = ACTIONS(391),
    [anon_sym_STAR_EQ] = ACTIONS(391),
    [anon_sym_SLASH_EQ] = ACTIONS(391),
    [anon_sym_PERCENT_EQ] = ACTIONS(391),
    [anon_sym_AMP_EQ] = ACTIONS(391),
    [anon_sym_PIPE_EQ] = ACTIONS(391),
    [anon_sym_CARET_EQ] = ACTIONS(391),
    [anon_sym_LT_LT_EQ] = ACTIONS(391),
    [anon_sym_GT_GT_EQ] = ACTIONS(391),
    [anon_sym_DOT] = ACTIONS(391),
    [anon_sym_true] = ACTIONS(393),
    [anon_sym_false] = ACTIONS(393),
    [anon_sym_DASH] = ACTIONS(393),
    [anon_sym_BANG] = ACTIONS(393),
    [anon_sym_AMP_AMP] = ACTIONS(391),
    [anon_sym_PIPE_PIPE] = ACTIONS(391),
    [anon_sym_AMP] = ACTIONS(393),
    [anon_sym_PIPE] = ACTIONS(393),
    [anon_sym_CARET] = ACTIONS(393),
    [anon_sym_EQ_EQ] = ACTIONS(391),
    [anon_sym_BANG_EQ] = ACTIONS(391),
    [anon_sym_LT_EQ] = ACTIONS(393),
    [anon_sym_GT_EQ] = ACTIONS(391),
    [anon_sym_LT_LT] = ACTIONS(393),
    [anon_sym_GT_GT] = ACTIONS(393),
    [anon_sym_PLUS] = ACTIONS(393),
    [anon_sym_SLASH] = ACTIONS(393),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(391),
    [anon_sym_SQUOTE] = ACTIONS(391),
    [sym__ident_reg] = ACTIONS(393),
    [anon_sym_POUND] = ACTIONS(391),
    [sym_int_literal] = ACTIONS(393),
    [sym_float_literal] = ACTIONS(391),
    [anon_sym_ease] = ACTIONS(393),
    [anon_sym_ease_DASHin] = ACTIONS(393),
    [anon_sym_ease_in] = ACTIONS(393),
    [anon_sym_ease_in_out] = ACTIONS(393),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(393),
    [anon_sym_ease_out] = ACTIONS(393),
    [anon_sym_ease_DASHout] = ACTIONS(393),
    [anon_sym_start] = ACTIONS(393),
    [anon_sym_end] = ACTIONS(393),
    [anon_sym_black] = ACTIONS(393),
    [anon_sym_blue] = ACTIONS(393),
    [anon_sym_green] = ACTIONS(393),
    [anon_sym_red] = ACTIONS(393),
    [anon_sym_yellow] = ACTIONS(393),
    [anon_sym_white] = ACTIONS(393),
    [anon_sym_gray] = ACTIONS(393),
    [anon_sym_transparent] = ACTIONS(393),
    [anon_sym_angle] = ACTIONS(393),
    [anon_sym_bool] = ACTIONS(393),
    [anon_sym_brush] = ACTIONS(393),
    [anon_sym_color] = ACTIONS(393),
    [anon_sym_float] = ACTIONS(393),
    [anon_sym_image] = ACTIONS(393),
    [anon_sym_int] = ACTIONS(393),
    [anon_sym_length] = ACTIONS(393),
    [anon_sym_percent] = ACTIONS(393),
    [anon_sym_physical_DASHlength] = ACTIONS(393),
    [anon_sym_physical_length] = ACTIONS(393),
    [anon_sym_string] = ACTIONS(393),
    [anon_sym_debug] = ACTIONS(393),
    [anon_sym_animation_DASHtick] = ACTIONS(393),
    [anon_sym_min] = ACTIONS(393),
    [anon_sym_max] = ACTIONS(393),
    [anon_sym_mod] = ACTIONS(393),
    [anon_sym_abs] = ACTIONS(393),
    [anon_sym_round] = ACTIONS(393),
    [anon_sym_ceil] = ACTIONS(393),
    [anon_sym_floor] = ACTIONS(393),
    [anon_sym_sin] = ACTIONS(393),
    [anon_sym_cos] = ACTIONS(393),
    [anon_sym_tan] = ACTIONS(393),
    [anon_sym_asin] = ACTIONS(393),
    [anon_sym_acos] = ACTIONS(393),
    [anon_sym_atan] = ACTIONS(393),
    [anon_sym_sqrt] = ACTIONS(393),
    [anon_sym_pow] = ACTIONS(393),
    [anon_sym_log] = ACTIONS(393),
    [anon_sym_rgb] = ACTIONS(393),
    [anon_sym_easing] = ACTIONS(393),
    [anon_sym_duration] = ACTIONS(393),
    [anon_sym_parent] = ACTIONS(393),
    [anon_sym_root] = ACTIONS(393),
    [sym_comment] = ACTIONS(3),
  },
  [54] = {
    [anon_sym_LBRACE] = ACTIONS(395),
    [anon_sym_COLON] = ACTIONS(395),
    [anon_sym_COMMA] = ACTIONS(395),
    [anon_sym_RBRACE] = ACTIONS(395),
    [anon_sym_SEMI] = ACTIONS(395),
    [anon_sym_if] = ACTIONS(397),
    [anon_sym_AT] = ACTIONS(395),
    [anon_sym_LBRACK] = ACTIONS(395),
    [anon_sym_STAR] = ACTIONS(397),
    [anon_sym_LT_EQ_GT] = ACTIONS(395),
    [anon_sym_LPAREN] = ACTIONS(395),
    [anon_sym_RPAREN] = ACTIONS(395),
    [anon_sym_LT] = ACTIONS(397),
    [anon_sym_GT] = ACTIONS(397),
    [anon_sym_EQ] = ACTIONS(397),
    [anon_sym_PLUS_EQ] = ACTIONS(395),
    [anon_sym_DASH_EQ] = ACTIONS(395),
    [anon_sym_STAR_EQ] = ACTIONS(395),
    [anon_sym_SLASH_EQ] = ACTIONS(395),
    [anon_sym_PERCENT_EQ] = ACTIONS(395),
    [anon_sym_AMP_EQ] = ACTIONS(395),
    [anon_sym_PIPE_EQ] = ACTIONS(395),
    [anon_sym_CARET_EQ] = ACTIONS(395),
    [anon_sym_LT_LT_EQ] = ACTIONS(395),
    [anon_sym_GT_GT_EQ] = ACTIONS(395),
    [anon_sym_DOT] = ACTIONS(395),
    [anon_sym_true] = ACTIONS(397),
    [anon_sym_false] = ACTIONS(397),
    [anon_sym_DASH] = ACTIONS(397),
    [anon_sym_BANG] = ACTIONS(397),
    [anon_sym_AMP_AMP] = ACTIONS(395),
    [anon_sym_PIPE_PIPE] = ACTIONS(395),
    [anon_sym_AMP] = ACTIONS(397),
    [anon_sym_PIPE] = ACTIONS(397),
    [anon_sym_CARET] = ACTIONS(397),
    [anon_sym_EQ_EQ] = ACTIONS(395),
    [anon_sym_BANG_EQ] = ACTIONS(395),
    [anon_sym_LT_EQ] = ACTIONS(397),
    [anon_sym_GT_EQ] = ACTIONS(395),
    [anon_sym_LT_LT] = ACTIONS(397),
    [anon_sym_GT_GT] = ACTIONS(397),
    [anon_sym_PLUS] = ACTIONS(397),
    [anon_sym_SLASH] = ACTIONS(397),
    [anon_sym_QMARK] = ACTIONS(395),
    [anon_sym_DQUOTE] = ACTIONS(395),
    [anon_sym_SQUOTE] = ACTIONS(395),
    [sym__ident_reg] = ACTIONS(397),
    [anon_sym_POUND] = ACTIONS(395),
    [sym_int_literal] = ACTIONS(397),
    [sym_float_literal] = ACTIONS(395),
    [anon_sym_ease] = ACTIONS(397),
    [anon_sym_ease_DASHin] = ACTIONS(397),
    [anon_sym_ease_in] = ACTIONS(397),
    [anon_sym_ease_in_out] = ACTIONS(397),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(397),
    [anon_sym_ease_out] = ACTIONS(397),
    [anon_sym_ease_DASHout] = ACTIONS(397),
    [anon_sym_start] = ACTIONS(397),
    [anon_sym_end] = ACTIONS(397),
    [anon_sym_black] = ACTIONS(397),
    [anon_sym_blue] = ACTIONS(397),
    [anon_sym_green] = ACTIONS(397),
    [anon_sym_red] = ACTIONS(397),
    [anon_sym_yellow] = ACTIONS(397),
    [anon_sym_white] = ACTIONS(397),
    [anon_sym_gray] = ACTIONS(397),
    [anon_sym_transparent] = ACTIONS(397),
    [anon_sym_angle] = ACTIONS(397),
    [anon_sym_bool] = ACTIONS(397),
    [anon_sym_brush] = ACTIONS(397),
    [anon_sym_color] = ACTIONS(397),
    [anon_sym_float] = ACTIONS(397),
    [anon_sym_image] = ACTIONS(397),
    [anon_sym_int] = ACTIONS(397),
    [anon_sym_length] = ACTIONS(397),
    [anon_sym_percent] = ACTIONS(397),
    [anon_sym_physical_DASHlength] = ACTIONS(397),
    [anon_sym_physical_length] = ACTIONS(397),
    [anon_sym_string] = ACTIONS(397),
    [anon_sym_debug] = ACTIONS(397),
    [anon_sym_animation_DASHtick] = ACTIONS(397),
    [anon_sym_min] = ACTIONS(397),
    [anon_sym_max] = ACTIONS(397),
    [anon_sym_mod] = ACTIONS(397),
    [anon_sym_abs] = ACTIONS(397),
    [anon_sym_round] = ACTIONS(397),
    [anon_sym_ceil] = ACTIONS(397),
    [anon_sym_floor] = ACTIONS(397),
    [anon_sym_sin] = ACTIONS(397),
    [anon_sym_cos] = ACTIONS(397),
    [anon_sym_tan] = ACTIONS(397),
    [anon_sym_asin] = ACTIONS(397),
    [anon_sym_acos] = ACTIONS(397),
    [anon_sym_atan] = ACTIONS(397),
    [anon_sym_sqrt] = ACTIONS(397),
    [anon_sym_pow] = ACTIONS(397),
    [anon_sym_log] = ACTIONS(397),
    [anon_sym_rgb] = ACTIONS(397),
    [anon_sym_easing] = ACTIONS(397),
    [anon_sym_duration] = ACTIONS(397),
    [anon_sym_parent] = ACTIONS(397),
    [anon_sym_root] = ACTIONS(397),
    [sym_comment] = ACTIONS(3),
  },
  [55] = {
    [anon_sym_LBRACE] = ACTIONS(399),
    [anon_sym_COLON] = ACTIONS(399),
    [anon_sym_COMMA] = ACTIONS(399),
    [anon_sym_RBRACE] = ACTIONS(399),
    [anon_sym_SEMI] = ACTIONS(399),
    [anon_sym_if] = ACTIONS(401),
    [anon_sym_AT] = ACTIONS(399),
    [anon_sym_LBRACK] = ACTIONS(399),
    [anon_sym_STAR] = ACTIONS(401),
    [anon_sym_LT_EQ_GT] = ACTIONS(399),
    [anon_sym_LPAREN] = ACTIONS(399),
    [anon_sym_RPAREN] = ACTIONS(399),
    [anon_sym_LT] = ACTIONS(401),
    [anon_sym_GT] = ACTIONS(401),
    [anon_sym_EQ] = ACTIONS(401),
    [anon_sym_PLUS_EQ] = ACTIONS(399),
    [anon_sym_DASH_EQ] = ACTIONS(399),
    [anon_sym_STAR_EQ] = ACTIONS(399),
    [anon_sym_SLASH_EQ] = ACTIONS(399),
    [anon_sym_PERCENT_EQ] = ACTIONS(399),
    [anon_sym_AMP_EQ] = ACTIONS(399),
    [anon_sym_PIPE_EQ] = ACTIONS(399),
    [anon_sym_CARET_EQ] = ACTIONS(399),
    [anon_sym_LT_LT_EQ] = ACTIONS(399),
    [anon_sym_GT_GT_EQ] = ACTIONS(399),
    [anon_sym_DOT] = ACTIONS(399),
    [anon_sym_true] = ACTIONS(401),
    [anon_sym_false] = ACTIONS(401),
    [anon_sym_DASH] = ACTIONS(401),
    [anon_sym_BANG] = ACTIONS(401),
    [anon_sym_AMP_AMP] = ACTIONS(399),
    [anon_sym_PIPE_PIPE] = ACTIONS(399),
    [anon_sym_AMP] = ACTIONS(401),
    [anon_sym_PIPE] = ACTIONS(401),
    [anon_sym_CARET] = ACTIONS(401),
    [anon_sym_EQ_EQ] = ACTIONS(399),
    [anon_sym_BANG_EQ] = ACTIONS(399),
    [anon_sym_LT_EQ] = ACTIONS(401),
    [anon_sym_GT_EQ] = ACTIONS(399),
    [anon_sym_LT_LT] = ACTIONS(401),
    [anon_sym_GT_GT] = ACTIONS(401),
    [anon_sym_PLUS] = ACTIONS(401),
    [anon_sym_SLASH] = ACTIONS(401),
    [anon_sym_QMARK] = ACTIONS(399),
    [anon_sym_DQUOTE] = ACTIONS(399),
    [anon_sym_SQUOTE] = ACTIONS(399),
    [sym__ident_reg] = ACTIONS(401),
    [anon_sym_POUND] = ACTIONS(399),
    [sym_int_literal] = ACTIONS(401),
    [sym_float_literal] = ACTIONS(399),
    [anon_sym_ease] = ACTIONS(401),
    [anon_sym_ease_DASHin] = ACTIONS(401),
    [anon_sym_ease_in] = ACTIONS(401),
    [anon_sym_ease_in_out] = ACTIONS(401),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(401),
    [anon_sym_ease_out] = ACTIONS(401),
    [anon_sym_ease_DASHout] = ACTIONS(401),
    [anon_sym_start] = ACTIONS(401),
    [anon_sym_end] = ACTIONS(401),
    [anon_sym_black] = ACTIONS(401),
    [anon_sym_blue] = ACTIONS(401),
    [anon_sym_green] = ACTIONS(401),
    [anon_sym_red] = ACTIONS(401),
    [anon_sym_yellow] = ACTIONS(401),
    [anon_sym_white] = ACTIONS(401),
    [anon_sym_gray] = ACTIONS(401),
    [anon_sym_transparent] = ACTIONS(401),
    [anon_sym_angle] = ACTIONS(401),
    [anon_sym_bool] = ACTIONS(401),
    [anon_sym_brush] = ACTIONS(401),
    [anon_sym_color] = ACTIONS(401),
    [anon_sym_float] = ACTIONS(401),
    [anon_sym_image] = ACTIONS(401),
    [anon_sym_int] = ACTIONS(401),
    [anon_sym_length] = ACTIONS(401),
    [anon_sym_percent] = ACTIONS(401),
    [anon_sym_physical_DASHlength] = ACTIONS(401),
    [anon_sym_physical_length] = ACTIONS(401),
    [anon_sym_string] = ACTIONS(401),
    [anon_sym_debug] = ACTIONS(401),
    [anon_sym_animation_DASHtick] = ACTIONS(401),
    [anon_sym_min] = ACTIONS(401),
    [anon_sym_max] = ACTIONS(401),
    [anon_sym_mod] = ACTIONS(401),
    [anon_sym_abs] = ACTIONS(401),
    [anon_sym_round] = ACTIONS(401),
    [anon_sym_ceil] = ACTIONS(401),
    [anon_sym_floor] = ACTIONS(401),
    [anon_sym_sin] = ACTIONS(401),
    [anon_sym_cos] = ACTIONS(401),
    [anon_sym_tan] = ACTIONS(401),
    [anon_sym_asin] = ACTIONS(401),
    [anon_sym_acos] = ACTIONS(401),
    [anon_sym_atan] = ACTIONS(401),
    [anon_sym_sqrt] = ACTIONS(401),
    [anon_sym_pow] = ACTIONS(401),
    [anon_sym_log] = ACTIONS(401),
    [anon_sym_rgb] = ACTIONS(401),
    [anon_sym_easing] = ACTIONS(401),
    [anon_sym_duration] = ACTIONS(401),
    [anon_sym_parent] = ACTIONS(401),
    [anon_sym_root] = ACTIONS(401),
    [sym_comment] = ACTIONS(3),
  },
  [56] = {
    [anon_sym_LBRACE] = ACTIONS(403),
    [anon_sym_COLON] = ACTIONS(403),
    [anon_sym_COMMA] = ACTIONS(403),
    [anon_sym_RBRACE] = ACTIONS(403),
    [anon_sym_SEMI] = ACTIONS(403),
    [anon_sym_if] = ACTIONS(405),
    [anon_sym_AT] = ACTIONS(403),
    [anon_sym_LBRACK] = ACTIONS(403),
    [anon_sym_STAR] = ACTIONS(405),
    [anon_sym_LT_EQ_GT] = ACTIONS(403),
    [anon_sym_LPAREN] = ACTIONS(403),
    [anon_sym_RPAREN] = ACTIONS(403),
    [anon_sym_LT] = ACTIONS(405),
    [anon_sym_GT] = ACTIONS(405),
    [anon_sym_EQ] = ACTIONS(405),
    [anon_sym_PLUS_EQ] = ACTIONS(403),
    [anon_sym_DASH_EQ] = ACTIONS(403),
    [anon_sym_STAR_EQ] = ACTIONS(403),
    [anon_sym_SLASH_EQ] = ACTIONS(403),
    [anon_sym_PERCENT_EQ] = ACTIONS(403),
    [anon_sym_AMP_EQ] = ACTIONS(403),
    [anon_sym_PIPE_EQ] = ACTIONS(403),
    [anon_sym_CARET_EQ] = ACTIONS(403),
    [anon_sym_LT_LT_EQ] = ACTIONS(403),
    [anon_sym_GT_GT_EQ] = ACTIONS(403),
    [anon_sym_DOT] = ACTIONS(403),
    [anon_sym_true] = ACTIONS(405),
    [anon_sym_false] = ACTIONS(405),
    [anon_sym_DASH] = ACTIONS(405),
    [anon_sym_BANG] = ACTIONS(405),
    [anon_sym_AMP_AMP] = ACTIONS(403),
    [anon_sym_PIPE_PIPE] = ACTIONS(403),
    [anon_sym_AMP] = ACTIONS(405),
    [anon_sym_PIPE] = ACTIONS(405),
    [anon_sym_CARET] = ACTIONS(405),
    [anon_sym_EQ_EQ] = ACTIONS(403),
    [anon_sym_BANG_EQ] = ACTIONS(403),
    [anon_sym_LT_EQ] = ACTIONS(405),
    [anon_sym_GT_EQ] = ACTIONS(403),
    [anon_sym_LT_LT] = ACTIONS(405),
    [anon_sym_GT_GT] = ACTIONS(405),
    [anon_sym_PLUS] = ACTIONS(405),
    [anon_sym_SLASH] = ACTIONS(405),
    [anon_sym_QMARK] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(403),
    [anon_sym_SQUOTE] = ACTIONS(403),
    [sym__ident_reg] = ACTIONS(405),
    [anon_sym_POUND] = ACTIONS(403),
    [sym_int_literal] = ACTIONS(405),
    [sym_float_literal] = ACTIONS(403),
    [anon_sym_ease] = ACTIONS(405),
    [anon_sym_ease_DASHin] = ACTIONS(405),
    [anon_sym_ease_in] = ACTIONS(405),
    [anon_sym_ease_in_out] = ACTIONS(405),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(405),
    [anon_sym_ease_out] = ACTIONS(405),
    [anon_sym_ease_DASHout] = ACTIONS(405),
    [anon_sym_start] = ACTIONS(405),
    [anon_sym_end] = ACTIONS(405),
    [anon_sym_black] = ACTIONS(405),
    [anon_sym_blue] = ACTIONS(405),
    [anon_sym_green] = ACTIONS(405),
    [anon_sym_red] = ACTIONS(405),
    [anon_sym_yellow] = ACTIONS(405),
    [anon_sym_white] = ACTIONS(405),
    [anon_sym_gray] = ACTIONS(405),
    [anon_sym_transparent] = ACTIONS(405),
    [anon_sym_angle] = ACTIONS(405),
    [anon_sym_bool] = ACTIONS(405),
    [anon_sym_brush] = ACTIONS(405),
    [anon_sym_color] = ACTIONS(405),
    [anon_sym_float] = ACTIONS(405),
    [anon_sym_image] = ACTIONS(405),
    [anon_sym_int] = ACTIONS(405),
    [anon_sym_length] = ACTIONS(405),
    [anon_sym_percent] = ACTIONS(405),
    [anon_sym_physical_DASHlength] = ACTIONS(405),
    [anon_sym_physical_length] = ACTIONS(405),
    [anon_sym_string] = ACTIONS(405),
    [anon_sym_debug] = ACTIONS(405),
    [anon_sym_animation_DASHtick] = ACTIONS(405),
    [anon_sym_min] = ACTIONS(405),
    [anon_sym_max] = ACTIONS(405),
    [anon_sym_mod] = ACTIONS(405),
    [anon_sym_abs] = ACTIONS(405),
    [anon_sym_round] = ACTIONS(405),
    [anon_sym_ceil] = ACTIONS(405),
    [anon_sym_floor] = ACTIONS(405),
    [anon_sym_sin] = ACTIONS(405),
    [anon_sym_cos] = ACTIONS(405),
    [anon_sym_tan] = ACTIONS(405),
    [anon_sym_asin] = ACTIONS(405),
    [anon_sym_acos] = ACTIONS(405),
    [anon_sym_atan] = ACTIONS(405),
    [anon_sym_sqrt] = ACTIONS(405),
    [anon_sym_pow] = ACTIONS(405),
    [anon_sym_log] = ACTIONS(405),
    [anon_sym_rgb] = ACTIONS(405),
    [anon_sym_easing] = ACTIONS(405),
    [anon_sym_duration] = ACTIONS(405),
    [anon_sym_parent] = ACTIONS(405),
    [anon_sym_root] = ACTIONS(405),
    [sym_comment] = ACTIONS(3),
  },
  [57] = {
    [anon_sym_LBRACE] = ACTIONS(407),
    [anon_sym_COLON] = ACTIONS(407),
    [anon_sym_COMMA] = ACTIONS(407),
    [anon_sym_RBRACE] = ACTIONS(407),
    [anon_sym_SEMI] = ACTIONS(407),
    [anon_sym_if] = ACTIONS(409),
    [anon_sym_AT] = ACTIONS(407),
    [anon_sym_LBRACK] = ACTIONS(407),
    [anon_sym_STAR] = ACTIONS(409),
    [anon_sym_LT_EQ_GT] = ACTIONS(407),
    [anon_sym_LPAREN] = ACTIONS(407),
    [anon_sym_RPAREN] = ACTIONS(407),
    [anon_sym_LT] = ACTIONS(409),
    [anon_sym_GT] = ACTIONS(409),
    [anon_sym_EQ] = ACTIONS(409),
    [anon_sym_PLUS_EQ] = ACTIONS(407),
    [anon_sym_DASH_EQ] = ACTIONS(407),
    [anon_sym_STAR_EQ] = ACTIONS(407),
    [anon_sym_SLASH_EQ] = ACTIONS(407),
    [anon_sym_PERCENT_EQ] = ACTIONS(407),
    [anon_sym_AMP_EQ] = ACTIONS(407),
    [anon_sym_PIPE_EQ] = ACTIONS(407),
    [anon_sym_CARET_EQ] = ACTIONS(407),
    [anon_sym_LT_LT_EQ] = ACTIONS(407),
    [anon_sym_GT_GT_EQ] = ACTIONS(407),
    [anon_sym_DOT] = ACTIONS(407),
    [anon_sym_true] = ACTIONS(409),
    [anon_sym_false] = ACTIONS(409),
    [anon_sym_DASH] = ACTIONS(409),
    [anon_sym_BANG] = ACTIONS(409),
    [anon_sym_AMP_AMP] = ACTIONS(407),
    [anon_sym_PIPE_PIPE] = ACTIONS(407),
    [anon_sym_AMP] = ACTIONS(409),
    [anon_sym_PIPE] = ACTIONS(409),
    [anon_sym_CARET] = ACTIONS(409),
    [anon_sym_EQ_EQ] = ACTIONS(407),
    [anon_sym_BANG_EQ] = ACTIONS(407),
    [anon_sym_LT_EQ] = ACTIONS(409),
    [anon_sym_GT_EQ] = ACTIONS(407),
    [anon_sym_LT_LT] = ACTIONS(409),
    [anon_sym_GT_GT] = ACTIONS(409),
    [anon_sym_PLUS] = ACTIONS(409),
    [anon_sym_SLASH] = ACTIONS(409),
    [anon_sym_QMARK] = ACTIONS(407),
    [anon_sym_DQUOTE] = ACTIONS(407),
    [anon_sym_SQUOTE] = ACTIONS(407),
    [sym__ident_reg] = ACTIONS(409),
    [anon_sym_POUND] = ACTIONS(407),
    [sym_int_literal] = ACTIONS(409),
    [sym_float_literal] = ACTIONS(407),
    [anon_sym_ease] = ACTIONS(409),
    [anon_sym_ease_DASHin] = ACTIONS(409),
    [anon_sym_ease_in] = ACTIONS(409),
    [anon_sym_ease_in_out] = ACTIONS(409),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(409),
    [anon_sym_ease_out] = ACTIONS(409),
    [anon_sym_ease_DASHout] = ACTIONS(409),
    [anon_sym_start] = ACTIONS(409),
    [anon_sym_end] = ACTIONS(409),
    [anon_sym_black] = ACTIONS(409),
    [anon_sym_blue] = ACTIONS(409),
    [anon_sym_green] = ACTIONS(409),
    [anon_sym_red] = ACTIONS(409),
    [anon_sym_yellow] = ACTIONS(409),
    [anon_sym_white] = ACTIONS(409),
    [anon_sym_gray] = ACTIONS(409),
    [anon_sym_transparent] = ACTIONS(409),
    [anon_sym_angle] = ACTIONS(409),
    [anon_sym_bool] = ACTIONS(409),
    [anon_sym_brush] = ACTIONS(409),
    [anon_sym_color] = ACTIONS(409),
    [anon_sym_float] = ACTIONS(409),
    [anon_sym_image] = ACTIONS(409),
    [anon_sym_int] = ACTIONS(409),
    [anon_sym_length] = ACTIONS(409),
    [anon_sym_percent] = ACTIONS(409),
    [anon_sym_physical_DASHlength] = ACTIONS(409),
    [anon_sym_physical_length] = ACTIONS(409),
    [anon_sym_string] = ACTIONS(409),
    [anon_sym_debug] = ACTIONS(409),
    [anon_sym_animation_DASHtick] = ACTIONS(409),
    [anon_sym_min] = ACTIONS(409),
    [anon_sym_max] = ACTIONS(409),
    [anon_sym_mod] = ACTIONS(409),
    [anon_sym_abs] = ACTIONS(409),
    [anon_sym_round] = ACTIONS(409),
    [anon_sym_ceil] = ACTIONS(409),
    [anon_sym_floor] = ACTIONS(409),
    [anon_sym_sin] = ACTIONS(409),
    [anon_sym_cos] = ACTIONS(409),
    [anon_sym_tan] = ACTIONS(409),
    [anon_sym_asin] = ACTIONS(409),
    [anon_sym_acos] = ACTIONS(409),
    [anon_sym_atan] = ACTIONS(409),
    [anon_sym_sqrt] = ACTIONS(409),
    [anon_sym_pow] = ACTIONS(409),
    [anon_sym_log] = ACTIONS(409),
    [anon_sym_rgb] = ACTIONS(409),
    [anon_sym_easing] = ACTIONS(409),
    [anon_sym_duration] = ACTIONS(409),
    [anon_sym_parent] = ACTIONS(409),
    [anon_sym_root] = ACTIONS(409),
    [sym_comment] = ACTIONS(3),
  },
  [58] = {
    [anon_sym_LBRACE] = ACTIONS(411),
    [anon_sym_COLON] = ACTIONS(411),
    [anon_sym_COMMA] = ACTIONS(411),
    [anon_sym_RBRACE] = ACTIONS(411),
    [anon_sym_SEMI] = ACTIONS(411),
    [anon_sym_if] = ACTIONS(413),
    [anon_sym_AT] = ACTIONS(411),
    [anon_sym_LBRACK] = ACTIONS(411),
    [anon_sym_STAR] = ACTIONS(413),
    [anon_sym_LT_EQ_GT] = ACTIONS(411),
    [anon_sym_LPAREN] = ACTIONS(411),
    [anon_sym_RPAREN] = ACTIONS(411),
    [anon_sym_LT] = ACTIONS(413),
    [anon_sym_GT] = ACTIONS(413),
    [anon_sym_EQ] = ACTIONS(413),
    [anon_sym_PLUS_EQ] = ACTIONS(411),
    [anon_sym_DASH_EQ] = ACTIONS(411),
    [anon_sym_STAR_EQ] = ACTIONS(411),
    [anon_sym_SLASH_EQ] = ACTIONS(411),
    [anon_sym_PERCENT_EQ] = ACTIONS(411),
    [anon_sym_AMP_EQ] = ACTIONS(411),
    [anon_sym_PIPE_EQ] = ACTIONS(411),
    [anon_sym_CARET_EQ] = ACTIONS(411),
    [anon_sym_LT_LT_EQ] = ACTIONS(411),
    [anon_sym_GT_GT_EQ] = ACTIONS(411),
    [anon_sym_DOT] = ACTIONS(411),
    [anon_sym_true] = ACTIONS(413),
    [anon_sym_false] = ACTIONS(413),
    [anon_sym_DASH] = ACTIONS(413),
    [anon_sym_BANG] = ACTIONS(413),
    [anon_sym_AMP_AMP] = ACTIONS(411),
    [anon_sym_PIPE_PIPE] = ACTIONS(411),
    [anon_sym_AMP] = ACTIONS(413),
    [anon_sym_PIPE] = ACTIONS(413),
    [anon_sym_CARET] = ACTIONS(413),
    [anon_sym_EQ_EQ] = ACTIONS(411),
    [anon_sym_BANG_EQ] = ACTIONS(411),
    [anon_sym_LT_EQ] = ACTIONS(413),
    [anon_sym_GT_EQ] = ACTIONS(411),
    [anon_sym_LT_LT] = ACTIONS(413),
    [anon_sym_GT_GT] = ACTIONS(413),
    [anon_sym_PLUS] = ACTIONS(413),
    [anon_sym_SLASH] = ACTIONS(413),
    [anon_sym_QMARK] = ACTIONS(411),
    [anon_sym_DQUOTE] = ACTIONS(411),
    [anon_sym_SQUOTE] = ACTIONS(411),
    [sym__ident_reg] = ACTIONS(413),
    [anon_sym_POUND] = ACTIONS(411),
    [sym_int_literal] = ACTIONS(413),
    [sym_float_literal] = ACTIONS(411),
    [anon_sym_ease] = ACTIONS(413),
    [anon_sym_ease_DASHin] = ACTIONS(413),
    [anon_sym_ease_in] = ACTIONS(413),
    [anon_sym_ease_in_out] = ACTIONS(413),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(413),
    [anon_sym_ease_out] = ACTIONS(413),
    [anon_sym_ease_DASHout] = ACTIONS(413),
    [anon_sym_start] = ACTIONS(413),
    [anon_sym_end] = ACTIONS(413),
    [anon_sym_black] = ACTIONS(413),
    [anon_sym_blue] = ACTIONS(413),
    [anon_sym_green] = ACTIONS(413),
    [anon_sym_red] = ACTIONS(413),
    [anon_sym_yellow] = ACTIONS(413),
    [anon_sym_white] = ACTIONS(413),
    [anon_sym_gray] = ACTIONS(413),
    [anon_sym_transparent] = ACTIONS(413),
    [anon_sym_angle] = ACTIONS(413),
    [anon_sym_bool] = ACTIONS(413),
    [anon_sym_brush] = ACTIONS(413),
    [anon_sym_color] = ACTIONS(413),
    [anon_sym_float] = ACTIONS(413),
    [anon_sym_image] = ACTIONS(413),
    [anon_sym_int] = ACTIONS(413),
    [anon_sym_length] = ACTIONS(413),
    [anon_sym_percent] = ACTIONS(413),
    [anon_sym_physical_DASHlength] = ACTIONS(413),
    [anon_sym_physical_length] = ACTIONS(413),
    [anon_sym_string] = ACTIONS(413),
    [anon_sym_debug] = ACTIONS(413),
    [anon_sym_animation_DASHtick] = ACTIONS(413),
    [anon_sym_min] = ACTIONS(413),
    [anon_sym_max] = ACTIONS(413),
    [anon_sym_mod] = ACTIONS(413),
    [anon_sym_abs] = ACTIONS(413),
    [anon_sym_round] = ACTIONS(413),
    [anon_sym_ceil] = ACTIONS(413),
    [anon_sym_floor] = ACTIONS(413),
    [anon_sym_sin] = ACTIONS(413),
    [anon_sym_cos] = ACTIONS(413),
    [anon_sym_tan] = ACTIONS(413),
    [anon_sym_asin] = ACTIONS(413),
    [anon_sym_acos] = ACTIONS(413),
    [anon_sym_atan] = ACTIONS(413),
    [anon_sym_sqrt] = ACTIONS(413),
    [anon_sym_pow] = ACTIONS(413),
    [anon_sym_log] = ACTIONS(413),
    [anon_sym_rgb] = ACTIONS(413),
    [anon_sym_easing] = ACTIONS(413),
    [anon_sym_duration] = ACTIONS(413),
    [anon_sym_parent] = ACTIONS(413),
    [anon_sym_root] = ACTIONS(413),
    [sym_comment] = ACTIONS(3),
  },
  [59] = {
    [anon_sym_LBRACE] = ACTIONS(415),
    [anon_sym_COLON] = ACTIONS(415),
    [anon_sym_COMMA] = ACTIONS(415),
    [anon_sym_RBRACE] = ACTIONS(415),
    [anon_sym_SEMI] = ACTIONS(415),
    [anon_sym_if] = ACTIONS(417),
    [anon_sym_AT] = ACTIONS(415),
    [anon_sym_LBRACK] = ACTIONS(415),
    [anon_sym_STAR] = ACTIONS(417),
    [anon_sym_LT_EQ_GT] = ACTIONS(415),
    [anon_sym_LPAREN] = ACTIONS(415),
    [anon_sym_RPAREN] = ACTIONS(415),
    [anon_sym_LT] = ACTIONS(417),
    [anon_sym_GT] = ACTIONS(417),
    [anon_sym_EQ] = ACTIONS(417),
    [anon_sym_PLUS_EQ] = ACTIONS(415),
    [anon_sym_DASH_EQ] = ACTIONS(415),
    [anon_sym_STAR_EQ] = ACTIONS(415),
    [anon_sym_SLASH_EQ] = ACTIONS(415),
    [anon_sym_PERCENT_EQ] = ACTIONS(415),
    [anon_sym_AMP_EQ] = ACTIONS(415),
    [anon_sym_PIPE_EQ] = ACTIONS(415),
    [anon_sym_CARET_EQ] = ACTIONS(415),
    [anon_sym_LT_LT_EQ] = ACTIONS(415),
    [anon_sym_GT_GT_EQ] = ACTIONS(415),
    [anon_sym_DOT] = ACTIONS(415),
    [anon_sym_true] = ACTIONS(417),
    [anon_sym_false] = ACTIONS(417),
    [anon_sym_DASH] = ACTIONS(417),
    [anon_sym_BANG] = ACTIONS(417),
    [anon_sym_AMP_AMP] = ACTIONS(415),
    [anon_sym_PIPE_PIPE] = ACTIONS(415),
    [anon_sym_AMP] = ACTIONS(417),
    [anon_sym_PIPE] = ACTIONS(417),
    [anon_sym_CARET] = ACTIONS(417),
    [anon_sym_EQ_EQ] = ACTIONS(415),
    [anon_sym_BANG_EQ] = ACTIONS(415),
    [anon_sym_LT_EQ] = ACTIONS(417),
    [anon_sym_GT_EQ] = ACTIONS(415),
    [anon_sym_LT_LT] = ACTIONS(417),
    [anon_sym_GT_GT] = ACTIONS(417),
    [anon_sym_PLUS] = ACTIONS(417),
    [anon_sym_SLASH] = ACTIONS(417),
    [anon_sym_QMARK] = ACTIONS(415),
    [anon_sym_DQUOTE] = ACTIONS(415),
    [anon_sym_SQUOTE] = ACTIONS(415),
    [sym__ident_reg] = ACTIONS(417),
    [anon_sym_POUND] = ACTIONS(415),
    [sym_int_literal] = ACTIONS(417),
    [sym_float_literal] = ACTIONS(415),
    [anon_sym_ease] = ACTIONS(417),
    [anon_sym_ease_DASHin] = ACTIONS(417),
    [anon_sym_ease_in] = ACTIONS(417),
    [anon_sym_ease_in_out] = ACTIONS(417),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(417),
    [anon_sym_ease_out] = ACTIONS(417),
    [anon_sym_ease_DASHout] = ACTIONS(417),
    [anon_sym_start] = ACTIONS(417),
    [anon_sym_end] = ACTIONS(417),
    [anon_sym_black] = ACTIONS(417),
    [anon_sym_blue] = ACTIONS(417),
    [anon_sym_green] = ACTIONS(417),
    [anon_sym_red] = ACTIONS(417),
    [anon_sym_yellow] = ACTIONS(417),
    [anon_sym_white] = ACTIONS(417),
    [anon_sym_gray] = ACTIONS(417),
    [anon_sym_transparent] = ACTIONS(417),
    [anon_sym_angle] = ACTIONS(417),
    [anon_sym_bool] = ACTIONS(417),
    [anon_sym_brush] = ACTIONS(417),
    [anon_sym_color] = ACTIONS(417),
    [anon_sym_float] = ACTIONS(417),
    [anon_sym_image] = ACTIONS(417),
    [anon_sym_int] = ACTIONS(417),
    [anon_sym_length] = ACTIONS(417),
    [anon_sym_percent] = ACTIONS(417),
    [anon_sym_physical_DASHlength] = ACTIONS(417),
    [anon_sym_physical_length] = ACTIONS(417),
    [anon_sym_string] = ACTIONS(417),
    [anon_sym_debug] = ACTIONS(417),
    [anon_sym_animation_DASHtick] = ACTIONS(417),
    [anon_sym_min] = ACTIONS(417),
    [anon_sym_max] = ACTIONS(417),
    [anon_sym_mod] = ACTIONS(417),
    [anon_sym_abs] = ACTIONS(417),
    [anon_sym_round] = ACTIONS(417),
    [anon_sym_ceil] = ACTIONS(417),
    [anon_sym_floor] = ACTIONS(417),
    [anon_sym_sin] = ACTIONS(417),
    [anon_sym_cos] = ACTIONS(417),
    [anon_sym_tan] = ACTIONS(417),
    [anon_sym_asin] = ACTIONS(417),
    [anon_sym_acos] = ACTIONS(417),
    [anon_sym_atan] = ACTIONS(417),
    [anon_sym_sqrt] = ACTIONS(417),
    [anon_sym_pow] = ACTIONS(417),
    [anon_sym_log] = ACTIONS(417),
    [anon_sym_rgb] = ACTIONS(417),
    [anon_sym_easing] = ACTIONS(417),
    [anon_sym_duration] = ACTIONS(417),
    [anon_sym_parent] = ACTIONS(417),
    [anon_sym_root] = ACTIONS(417),
    [sym_comment] = ACTIONS(3),
  },
  [60] = {
    [anon_sym_LBRACE] = ACTIONS(419),
    [anon_sym_COLON] = ACTIONS(419),
    [anon_sym_COMMA] = ACTIONS(419),
    [anon_sym_RBRACE] = ACTIONS(419),
    [anon_sym_SEMI] = ACTIONS(419),
    [anon_sym_if] = ACTIONS(421),
    [anon_sym_AT] = ACTIONS(419),
    [anon_sym_LBRACK] = ACTIONS(419),
    [anon_sym_STAR] = ACTIONS(421),
    [anon_sym_LT_EQ_GT] = ACTIONS(419),
    [anon_sym_LPAREN] = ACTIONS(419),
    [anon_sym_RPAREN] = ACTIONS(419),
    [anon_sym_LT] = ACTIONS(421),
    [anon_sym_GT] = ACTIONS(421),
    [anon_sym_EQ] = ACTIONS(421),
    [anon_sym_PLUS_EQ] = ACTIONS(419),
    [anon_sym_DASH_EQ] = ACTIONS(419),
    [anon_sym_STAR_EQ] = ACTIONS(419),
    [anon_sym_SLASH_EQ] = ACTIONS(419),
    [anon_sym_PERCENT_EQ] = ACTIONS(419),
    [anon_sym_AMP_EQ] = ACTIONS(419),
    [anon_sym_PIPE_EQ] = ACTIONS(419),
    [anon_sym_CARET_EQ] = ACTIONS(419),
    [anon_sym_LT_LT_EQ] = ACTIONS(419),
    [anon_sym_GT_GT_EQ] = ACTIONS(419),
    [anon_sym_DOT] = ACTIONS(419),
    [anon_sym_true] = ACTIONS(421),
    [anon_sym_false] = ACTIONS(421),
    [anon_sym_DASH] = ACTIONS(421),
    [anon_sym_BANG] = ACTIONS(421),
    [anon_sym_AMP_AMP] = ACTIONS(419),
    [anon_sym_PIPE_PIPE] = ACTIONS(419),
    [anon_sym_AMP] = ACTIONS(421),
    [anon_sym_PIPE] = ACTIONS(421),
    [anon_sym_CARET] = ACTIONS(421),
    [anon_sym_EQ_EQ] = ACTIONS(419),
    [anon_sym_BANG_EQ] = ACTIONS(419),
    [anon_sym_LT_EQ] = ACTIONS(421),
    [anon_sym_GT_EQ] = ACTIONS(419),
    [anon_sym_LT_LT] = ACTIONS(421),
    [anon_sym_GT_GT] = ACTIONS(421),
    [anon_sym_PLUS] = ACTIONS(421),
    [anon_sym_SLASH] = ACTIONS(421),
    [anon_sym_QMARK] = ACTIONS(419),
    [anon_sym_DQUOTE] = ACTIONS(419),
    [anon_sym_SQUOTE] = ACTIONS(419),
    [sym__ident_reg] = ACTIONS(421),
    [anon_sym_POUND] = ACTIONS(419),
    [sym_int_literal] = ACTIONS(421),
    [sym_float_literal] = ACTIONS(419),
    [anon_sym_ease] = ACTIONS(421),
    [anon_sym_ease_DASHin] = ACTIONS(421),
    [anon_sym_ease_in] = ACTIONS(421),
    [anon_sym_ease_in_out] = ACTIONS(421),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(421),
    [anon_sym_ease_out] = ACTIONS(421),
    [anon_sym_ease_DASHout] = ACTIONS(421),
    [anon_sym_start] = ACTIONS(421),
    [anon_sym_end] = ACTIONS(421),
    [anon_sym_black] = ACTIONS(421),
    [anon_sym_blue] = ACTIONS(421),
    [anon_sym_green] = ACTIONS(421),
    [anon_sym_red] = ACTIONS(421),
    [anon_sym_yellow] = ACTIONS(421),
    [anon_sym_white] = ACTIONS(421),
    [anon_sym_gray] = ACTIONS(421),
    [anon_sym_transparent] = ACTIONS(421),
    [anon_sym_angle] = ACTIONS(421),
    [anon_sym_bool] = ACTIONS(421),
    [anon_sym_brush] = ACTIONS(421),
    [anon_sym_color] = ACTIONS(421),
    [anon_sym_float] = ACTIONS(421),
    [anon_sym_image] = ACTIONS(421),
    [anon_sym_int] = ACTIONS(421),
    [anon_sym_length] = ACTIONS(421),
    [anon_sym_percent] = ACTIONS(421),
    [anon_sym_physical_DASHlength] = ACTIONS(421),
    [anon_sym_physical_length] = ACTIONS(421),
    [anon_sym_string] = ACTIONS(421),
    [anon_sym_debug] = ACTIONS(421),
    [anon_sym_animation_DASHtick] = ACTIONS(421),
    [anon_sym_min] = ACTIONS(421),
    [anon_sym_max] = ACTIONS(421),
    [anon_sym_mod] = ACTIONS(421),
    [anon_sym_abs] = ACTIONS(421),
    [anon_sym_round] = ACTIONS(421),
    [anon_sym_ceil] = ACTIONS(421),
    [anon_sym_floor] = ACTIONS(421),
    [anon_sym_sin] = ACTIONS(421),
    [anon_sym_cos] = ACTIONS(421),
    [anon_sym_tan] = ACTIONS(421),
    [anon_sym_asin] = ACTIONS(421),
    [anon_sym_acos] = ACTIONS(421),
    [anon_sym_atan] = ACTIONS(421),
    [anon_sym_sqrt] = ACTIONS(421),
    [anon_sym_pow] = ACTIONS(421),
    [anon_sym_log] = ACTIONS(421),
    [anon_sym_rgb] = ACTIONS(421),
    [anon_sym_easing] = ACTIONS(421),
    [anon_sym_duration] = ACTIONS(421),
    [anon_sym_parent] = ACTIONS(421),
    [anon_sym_root] = ACTIONS(421),
    [sym_comment] = ACTIONS(3),
  },
  [61] = {
    [anon_sym_LBRACE] = ACTIONS(423),
    [anon_sym_COLON] = ACTIONS(423),
    [anon_sym_COMMA] = ACTIONS(423),
    [anon_sym_RBRACE] = ACTIONS(423),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_if] = ACTIONS(425),
    [anon_sym_AT] = ACTIONS(423),
    [anon_sym_LBRACK] = ACTIONS(423),
    [anon_sym_STAR] = ACTIONS(425),
    [anon_sym_LT_EQ_GT] = ACTIONS(423),
    [anon_sym_LPAREN] = ACTIONS(423),
    [anon_sym_RPAREN] = ACTIONS(423),
    [anon_sym_LT] = ACTIONS(425),
    [anon_sym_GT] = ACTIONS(425),
    [anon_sym_EQ] = ACTIONS(425),
    [anon_sym_PLUS_EQ] = ACTIONS(423),
    [anon_sym_DASH_EQ] = ACTIONS(423),
    [anon_sym_STAR_EQ] = ACTIONS(423),
    [anon_sym_SLASH_EQ] = ACTIONS(423),
    [anon_sym_PERCENT_EQ] = ACTIONS(423),
    [anon_sym_AMP_EQ] = ACTIONS(423),
    [anon_sym_PIPE_EQ] = ACTIONS(423),
    [anon_sym_CARET_EQ] = ACTIONS(423),
    [anon_sym_LT_LT_EQ] = ACTIONS(423),
    [anon_sym_GT_GT_EQ] = ACTIONS(423),
    [anon_sym_DOT] = ACTIONS(423),
    [anon_sym_true] = ACTIONS(425),
    [anon_sym_false] = ACTIONS(425),
    [anon_sym_DASH] = ACTIONS(425),
    [anon_sym_BANG] = ACTIONS(425),
    [anon_sym_AMP_AMP] = ACTIONS(423),
    [anon_sym_PIPE_PIPE] = ACTIONS(423),
    [anon_sym_AMP] = ACTIONS(425),
    [anon_sym_PIPE] = ACTIONS(425),
    [anon_sym_CARET] = ACTIONS(425),
    [anon_sym_EQ_EQ] = ACTIONS(423),
    [anon_sym_BANG_EQ] = ACTIONS(423),
    [anon_sym_LT_EQ] = ACTIONS(425),
    [anon_sym_GT_EQ] = ACTIONS(423),
    [anon_sym_LT_LT] = ACTIONS(425),
    [anon_sym_GT_GT] = ACTIONS(425),
    [anon_sym_PLUS] = ACTIONS(425),
    [anon_sym_SLASH] = ACTIONS(425),
    [anon_sym_QMARK] = ACTIONS(423),
    [anon_sym_DQUOTE] = ACTIONS(423),
    [anon_sym_SQUOTE] = ACTIONS(423),
    [sym__ident_reg] = ACTIONS(425),
    [anon_sym_POUND] = ACTIONS(423),
    [sym_int_literal] = ACTIONS(425),
    [sym_float_literal] = ACTIONS(423),
    [anon_sym_ease] = ACTIONS(425),
    [anon_sym_ease_DASHin] = ACTIONS(425),
    [anon_sym_ease_in] = ACTIONS(425),
    [anon_sym_ease_in_out] = ACTIONS(425),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(425),
    [anon_sym_ease_out] = ACTIONS(425),
    [anon_sym_ease_DASHout] = ACTIONS(425),
    [anon_sym_start] = ACTIONS(425),
    [anon_sym_end] = ACTIONS(425),
    [anon_sym_black] = ACTIONS(425),
    [anon_sym_blue] = ACTIONS(425),
    [anon_sym_green] = ACTIONS(425),
    [anon_sym_red] = ACTIONS(425),
    [anon_sym_yellow] = ACTIONS(425),
    [anon_sym_white] = ACTIONS(425),
    [anon_sym_gray] = ACTIONS(425),
    [anon_sym_transparent] = ACTIONS(425),
    [anon_sym_angle] = ACTIONS(425),
    [anon_sym_bool] = ACTIONS(425),
    [anon_sym_brush] = ACTIONS(425),
    [anon_sym_color] = ACTIONS(425),
    [anon_sym_float] = ACTIONS(425),
    [anon_sym_image] = ACTIONS(425),
    [anon_sym_int] = ACTIONS(425),
    [anon_sym_length] = ACTIONS(425),
    [anon_sym_percent] = ACTIONS(425),
    [anon_sym_physical_DASHlength] = ACTIONS(425),
    [anon_sym_physical_length] = ACTIONS(425),
    [anon_sym_string] = ACTIONS(425),
    [anon_sym_debug] = ACTIONS(425),
    [anon_sym_animation_DASHtick] = ACTIONS(425),
    [anon_sym_min] = ACTIONS(425),
    [anon_sym_max] = ACTIONS(425),
    [anon_sym_mod] = ACTIONS(425),
    [anon_sym_abs] = ACTIONS(425),
    [anon_sym_round] = ACTIONS(425),
    [anon_sym_ceil] = ACTIONS(425),
    [anon_sym_floor] = ACTIONS(425),
    [anon_sym_sin] = ACTIONS(425),
    [anon_sym_cos] = ACTIONS(425),
    [anon_sym_tan] = ACTIONS(425),
    [anon_sym_asin] = ACTIONS(425),
    [anon_sym_acos] = ACTIONS(425),
    [anon_sym_atan] = ACTIONS(425),
    [anon_sym_sqrt] = ACTIONS(425),
    [anon_sym_pow] = ACTIONS(425),
    [anon_sym_log] = ACTIONS(425),
    [anon_sym_rgb] = ACTIONS(425),
    [anon_sym_easing] = ACTIONS(425),
    [anon_sym_duration] = ACTIONS(425),
    [anon_sym_parent] = ACTIONS(425),
    [anon_sym_root] = ACTIONS(425),
    [sym_comment] = ACTIONS(3),
  },
  [62] = {
    [anon_sym_LBRACE] = ACTIONS(427),
    [anon_sym_COLON] = ACTIONS(427),
    [anon_sym_COMMA] = ACTIONS(427),
    [anon_sym_RBRACE] = ACTIONS(427),
    [anon_sym_SEMI] = ACTIONS(427),
    [anon_sym_if] = ACTIONS(429),
    [anon_sym_AT] = ACTIONS(427),
    [anon_sym_LBRACK] = ACTIONS(427),
    [anon_sym_STAR] = ACTIONS(429),
    [anon_sym_LT_EQ_GT] = ACTIONS(427),
    [anon_sym_LPAREN] = ACTIONS(427),
    [anon_sym_RPAREN] = ACTIONS(427),
    [anon_sym_LT] = ACTIONS(429),
    [anon_sym_GT] = ACTIONS(429),
    [anon_sym_EQ] = ACTIONS(429),
    [anon_sym_PLUS_EQ] = ACTIONS(427),
    [anon_sym_DASH_EQ] = ACTIONS(427),
    [anon_sym_STAR_EQ] = ACTIONS(427),
    [anon_sym_SLASH_EQ] = ACTIONS(427),
    [anon_sym_PERCENT_EQ] = ACTIONS(427),
    [anon_sym_AMP_EQ] = ACTIONS(427),
    [anon_sym_PIPE_EQ] = ACTIONS(427),
    [anon_sym_CARET_EQ] = ACTIONS(427),
    [anon_sym_LT_LT_EQ] = ACTIONS(427),
    [anon_sym_GT_GT_EQ] = ACTIONS(427),
    [anon_sym_DOT] = ACTIONS(427),
    [anon_sym_true] = ACTIONS(429),
    [anon_sym_false] = ACTIONS(429),
    [anon_sym_DASH] = ACTIONS(429),
    [anon_sym_BANG] = ACTIONS(429),
    [anon_sym_AMP_AMP] = ACTIONS(427),
    [anon_sym_PIPE_PIPE] = ACTIONS(427),
    [anon_sym_AMP] = ACTIONS(429),
    [anon_sym_PIPE] = ACTIONS(429),
    [anon_sym_CARET] = ACTIONS(429),
    [anon_sym_EQ_EQ] = ACTIONS(427),
    [anon_sym_BANG_EQ] = ACTIONS(427),
    [anon_sym_LT_EQ] = ACTIONS(429),
    [anon_sym_GT_EQ] = ACTIONS(427),
    [anon_sym_LT_LT] = ACTIONS(429),
    [anon_sym_GT_GT] = ACTIONS(429),
    [anon_sym_PLUS] = ACTIONS(429),
    [anon_sym_SLASH] = ACTIONS(429),
    [anon_sym_QMARK] = ACTIONS(427),
    [anon_sym_DQUOTE] = ACTIONS(427),
    [anon_sym_SQUOTE] = ACTIONS(427),
    [sym__ident_reg] = ACTIONS(429),
    [anon_sym_POUND] = ACTIONS(427),
    [sym_int_literal] = ACTIONS(429),
    [sym_float_literal] = ACTIONS(427),
    [anon_sym_ease] = ACTIONS(429),
    [anon_sym_ease_DASHin] = ACTIONS(429),
    [anon_sym_ease_in] = ACTIONS(429),
    [anon_sym_ease_in_out] = ACTIONS(429),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(429),
    [anon_sym_ease_out] = ACTIONS(429),
    [anon_sym_ease_DASHout] = ACTIONS(429),
    [anon_sym_start] = ACTIONS(429),
    [anon_sym_end] = ACTIONS(429),
    [anon_sym_black] = ACTIONS(429),
    [anon_sym_blue] = ACTIONS(429),
    [anon_sym_green] = ACTIONS(429),
    [anon_sym_red] = ACTIONS(429),
    [anon_sym_yellow] = ACTIONS(429),
    [anon_sym_white] = ACTIONS(429),
    [anon_sym_gray] = ACTIONS(429),
    [anon_sym_transparent] = ACTIONS(429),
    [anon_sym_angle] = ACTIONS(429),
    [anon_sym_bool] = ACTIONS(429),
    [anon_sym_brush] = ACTIONS(429),
    [anon_sym_color] = ACTIONS(429),
    [anon_sym_float] = ACTIONS(429),
    [anon_sym_image] = ACTIONS(429),
    [anon_sym_int] = ACTIONS(429),
    [anon_sym_length] = ACTIONS(429),
    [anon_sym_percent] = ACTIONS(429),
    [anon_sym_physical_DASHlength] = ACTIONS(429),
    [anon_sym_physical_length] = ACTIONS(429),
    [anon_sym_string] = ACTIONS(429),
    [anon_sym_debug] = ACTIONS(429),
    [anon_sym_animation_DASHtick] = ACTIONS(429),
    [anon_sym_min] = ACTIONS(429),
    [anon_sym_max] = ACTIONS(429),
    [anon_sym_mod] = ACTIONS(429),
    [anon_sym_abs] = ACTIONS(429),
    [anon_sym_round] = ACTIONS(429),
    [anon_sym_ceil] = ACTIONS(429),
    [anon_sym_floor] = ACTIONS(429),
    [anon_sym_sin] = ACTIONS(429),
    [anon_sym_cos] = ACTIONS(429),
    [anon_sym_tan] = ACTIONS(429),
    [anon_sym_asin] = ACTIONS(429),
    [anon_sym_acos] = ACTIONS(429),
    [anon_sym_atan] = ACTIONS(429),
    [anon_sym_sqrt] = ACTIONS(429),
    [anon_sym_pow] = ACTIONS(429),
    [anon_sym_log] = ACTIONS(429),
    [anon_sym_rgb] = ACTIONS(429),
    [anon_sym_easing] = ACTIONS(429),
    [anon_sym_duration] = ACTIONS(429),
    [anon_sym_parent] = ACTIONS(429),
    [anon_sym_root] = ACTIONS(429),
    [sym_comment] = ACTIONS(3),
  },
  [63] = {
    [anon_sym_LBRACE] = ACTIONS(431),
    [anon_sym_COLON] = ACTIONS(431),
    [anon_sym_COMMA] = ACTIONS(431),
    [anon_sym_RBRACE] = ACTIONS(431),
    [anon_sym_SEMI] = ACTIONS(431),
    [anon_sym_if] = ACTIONS(433),
    [anon_sym_AT] = ACTIONS(431),
    [anon_sym_LBRACK] = ACTIONS(431),
    [anon_sym_STAR] = ACTIONS(433),
    [anon_sym_LT_EQ_GT] = ACTIONS(431),
    [anon_sym_LPAREN] = ACTIONS(431),
    [anon_sym_RPAREN] = ACTIONS(431),
    [anon_sym_LT] = ACTIONS(433),
    [anon_sym_GT] = ACTIONS(433),
    [anon_sym_EQ] = ACTIONS(433),
    [anon_sym_PLUS_EQ] = ACTIONS(431),
    [anon_sym_DASH_EQ] = ACTIONS(431),
    [anon_sym_STAR_EQ] = ACTIONS(431),
    [anon_sym_SLASH_EQ] = ACTIONS(431),
    [anon_sym_PERCENT_EQ] = ACTIONS(431),
    [anon_sym_AMP_EQ] = ACTIONS(431),
    [anon_sym_PIPE_EQ] = ACTIONS(431),
    [anon_sym_CARET_EQ] = ACTIONS(431),
    [anon_sym_LT_LT_EQ] = ACTIONS(431),
    [anon_sym_GT_GT_EQ] = ACTIONS(431),
    [anon_sym_DOT] = ACTIONS(431),
    [anon_sym_true] = ACTIONS(433),
    [anon_sym_false] = ACTIONS(433),
    [anon_sym_DASH] = ACTIONS(433),
    [anon_sym_BANG] = ACTIONS(433),
    [anon_sym_AMP_AMP] = ACTIONS(431),
    [anon_sym_PIPE_PIPE] = ACTIONS(431),
    [anon_sym_AMP] = ACTIONS(433),
    [anon_sym_PIPE] = ACTIONS(433),
    [anon_sym_CARET] = ACTIONS(433),
    [anon_sym_EQ_EQ] = ACTIONS(431),
    [anon_sym_BANG_EQ] = ACTIONS(431),
    [anon_sym_LT_EQ] = ACTIONS(433),
    [anon_sym_GT_EQ] = ACTIONS(431),
    [anon_sym_LT_LT] = ACTIONS(433),
    [anon_sym_GT_GT] = ACTIONS(433),
    [anon_sym_PLUS] = ACTIONS(433),
    [anon_sym_SLASH] = ACTIONS(433),
    [anon_sym_QMARK] = ACTIONS(431),
    [anon_sym_DQUOTE] = ACTIONS(431),
    [anon_sym_SQUOTE] = ACTIONS(431),
    [sym__ident_reg] = ACTIONS(433),
    [anon_sym_POUND] = ACTIONS(431),
    [sym_int_literal] = ACTIONS(433),
    [sym_float_literal] = ACTIONS(431),
    [anon_sym_ease] = ACTIONS(433),
    [anon_sym_ease_DASHin] = ACTIONS(433),
    [anon_sym_ease_in] = ACTIONS(433),
    [anon_sym_ease_in_out] = ACTIONS(433),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(433),
    [anon_sym_ease_out] = ACTIONS(433),
    [anon_sym_ease_DASHout] = ACTIONS(433),
    [anon_sym_start] = ACTIONS(433),
    [anon_sym_end] = ACTIONS(433),
    [anon_sym_black] = ACTIONS(433),
    [anon_sym_blue] = ACTIONS(433),
    [anon_sym_green] = ACTIONS(433),
    [anon_sym_red] = ACTIONS(433),
    [anon_sym_yellow] = ACTIONS(433),
    [anon_sym_white] = ACTIONS(433),
    [anon_sym_gray] = ACTIONS(433),
    [anon_sym_transparent] = ACTIONS(433),
    [anon_sym_angle] = ACTIONS(433),
    [anon_sym_bool] = ACTIONS(433),
    [anon_sym_brush] = ACTIONS(433),
    [anon_sym_color] = ACTIONS(433),
    [anon_sym_float] = ACTIONS(433),
    [anon_sym_image] = ACTIONS(433),
    [anon_sym_int] = ACTIONS(433),
    [anon_sym_length] = ACTIONS(433),
    [anon_sym_percent] = ACTIONS(433),
    [anon_sym_physical_DASHlength] = ACTIONS(433),
    [anon_sym_physical_length] = ACTIONS(433),
    [anon_sym_string] = ACTIONS(433),
    [anon_sym_debug] = ACTIONS(433),
    [anon_sym_animation_DASHtick] = ACTIONS(433),
    [anon_sym_min] = ACTIONS(433),
    [anon_sym_max] = ACTIONS(433),
    [anon_sym_mod] = ACTIONS(433),
    [anon_sym_abs] = ACTIONS(433),
    [anon_sym_round] = ACTIONS(433),
    [anon_sym_ceil] = ACTIONS(433),
    [anon_sym_floor] = ACTIONS(433),
    [anon_sym_sin] = ACTIONS(433),
    [anon_sym_cos] = ACTIONS(433),
    [anon_sym_tan] = ACTIONS(433),
    [anon_sym_asin] = ACTIONS(433),
    [anon_sym_acos] = ACTIONS(433),
    [anon_sym_atan] = ACTIONS(433),
    [anon_sym_sqrt] = ACTIONS(433),
    [anon_sym_pow] = ACTIONS(433),
    [anon_sym_log] = ACTIONS(433),
    [anon_sym_rgb] = ACTIONS(433),
    [anon_sym_easing] = ACTIONS(433),
    [anon_sym_duration] = ACTIONS(433),
    [anon_sym_parent] = ACTIONS(433),
    [anon_sym_root] = ACTIONS(433),
    [sym_comment] = ACTIONS(3),
  },
  [64] = {
    [anon_sym_LBRACE] = ACTIONS(309),
    [anon_sym_COLON] = ACTIONS(309),
    [anon_sym_COMMA] = ACTIONS(309),
    [anon_sym_RBRACE] = ACTIONS(309),
    [anon_sym_SEMI] = ACTIONS(309),
    [anon_sym_if] = ACTIONS(311),
    [anon_sym_AT] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_STAR] = ACTIONS(311),
    [anon_sym_LT_EQ_GT] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_RPAREN] = ACTIONS(309),
    [anon_sym_LT] = ACTIONS(311),
    [anon_sym_GT] = ACTIONS(311),
    [anon_sym_EQ] = ACTIONS(311),
    [anon_sym_PLUS_EQ] = ACTIONS(309),
    [anon_sym_DASH_EQ] = ACTIONS(309),
    [anon_sym_STAR_EQ] = ACTIONS(309),
    [anon_sym_SLASH_EQ] = ACTIONS(309),
    [anon_sym_PERCENT_EQ] = ACTIONS(309),
    [anon_sym_AMP_EQ] = ACTIONS(309),
    [anon_sym_PIPE_EQ] = ACTIONS(309),
    [anon_sym_CARET_EQ] = ACTIONS(309),
    [anon_sym_LT_LT_EQ] = ACTIONS(309),
    [anon_sym_GT_GT_EQ] = ACTIONS(309),
    [anon_sym_DOT] = ACTIONS(309),
    [anon_sym_true] = ACTIONS(311),
    [anon_sym_false] = ACTIONS(311),
    [anon_sym_DASH] = ACTIONS(311),
    [anon_sym_BANG] = ACTIONS(311),
    [anon_sym_AMP_AMP] = ACTIONS(309),
    [anon_sym_PIPE_PIPE] = ACTIONS(309),
    [anon_sym_AMP] = ACTIONS(311),
    [anon_sym_PIPE] = ACTIONS(311),
    [anon_sym_CARET] = ACTIONS(311),
    [anon_sym_EQ_EQ] = ACTIONS(309),
    [anon_sym_BANG_EQ] = ACTIONS(309),
    [anon_sym_LT_EQ] = ACTIONS(311),
    [anon_sym_GT_EQ] = ACTIONS(309),
    [anon_sym_LT_LT] = ACTIONS(311),
    [anon_sym_GT_GT] = ACTIONS(311),
    [anon_sym_PLUS] = ACTIONS(311),
    [anon_sym_SLASH] = ACTIONS(311),
    [anon_sym_QMARK] = ACTIONS(309),
    [anon_sym_DQUOTE] = ACTIONS(309),
    [anon_sym_SQUOTE] = ACTIONS(309),
    [sym__ident_reg] = ACTIONS(311),
    [anon_sym_POUND] = ACTIONS(309),
    [sym_int_literal] = ACTIONS(311),
    [sym_float_literal] = ACTIONS(309),
    [anon_sym_ease] = ACTIONS(311),
    [anon_sym_ease_DASHin] = ACTIONS(311),
    [anon_sym_ease_in] = ACTIONS(311),
    [anon_sym_ease_in_out] = ACTIONS(311),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(311),
    [anon_sym_ease_out] = ACTIONS(311),
    [anon_sym_ease_DASHout] = ACTIONS(311),
    [anon_sym_start] = ACTIONS(311),
    [anon_sym_end] = ACTIONS(311),
    [anon_sym_black] = ACTIONS(311),
    [anon_sym_blue] = ACTIONS(311),
    [anon_sym_green] = ACTIONS(311),
    [anon_sym_red] = ACTIONS(311),
    [anon_sym_yellow] = ACTIONS(311),
    [anon_sym_white] = ACTIONS(311),
    [anon_sym_gray] = ACTIONS(311),
    [anon_sym_transparent] = ACTIONS(311),
    [anon_sym_angle] = ACTIONS(311),
    [anon_sym_bool] = ACTIONS(311),
    [anon_sym_brush] = ACTIONS(311),
    [anon_sym_color] = ACTIONS(311),
    [anon_sym_float] = ACTIONS(311),
    [anon_sym_image] = ACTIONS(311),
    [anon_sym_int] = ACTIONS(311),
    [anon_sym_length] = ACTIONS(311),
    [anon_sym_percent] = ACTIONS(311),
    [anon_sym_physical_DASHlength] = ACTIONS(311),
    [anon_sym_physical_length] = ACTIONS(311),
    [anon_sym_string] = ACTIONS(311),
    [anon_sym_debug] = ACTIONS(311),
    [anon_sym_animation_DASHtick] = ACTIONS(311),
    [anon_sym_min] = ACTIONS(311),
    [anon_sym_max] = ACTIONS(311),
    [anon_sym_mod] = ACTIONS(311),
    [anon_sym_abs] = ACTIONS(311),
    [anon_sym_round] = ACTIONS(311),
    [anon_sym_ceil] = ACTIONS(311),
    [anon_sym_floor] = ACTIONS(311),
    [anon_sym_sin] = ACTIONS(311),
    [anon_sym_cos] = ACTIONS(311),
    [anon_sym_tan] = ACTIONS(311),
    [anon_sym_asin] = ACTIONS(311),
    [anon_sym_acos] = ACTIONS(311),
    [anon_sym_atan] = ACTIONS(311),
    [anon_sym_sqrt] = ACTIONS(311),
    [anon_sym_pow] = ACTIONS(311),
    [anon_sym_log] = ACTIONS(311),
    [anon_sym_rgb] = ACTIONS(311),
    [anon_sym_easing] = ACTIONS(311),
    [anon_sym_duration] = ACTIONS(311),
    [anon_sym_parent] = ACTIONS(311),
    [anon_sym_root] = ACTIONS(311),
    [sym_comment] = ACTIONS(3),
  },
  [65] = {
    [anon_sym_LBRACE] = ACTIONS(325),
    [anon_sym_COLON] = ACTIONS(325),
    [anon_sym_COMMA] = ACTIONS(325),
    [anon_sym_RBRACE] = ACTIONS(325),
    [anon_sym_SEMI] = ACTIONS(325),
    [anon_sym_if] = ACTIONS(327),
    [anon_sym_AT] = ACTIONS(325),
    [anon_sym_LBRACK] = ACTIONS(325),
    [anon_sym_STAR] = ACTIONS(327),
    [anon_sym_LT_EQ_GT] = ACTIONS(325),
    [anon_sym_LPAREN] = ACTIONS(325),
    [anon_sym_RPAREN] = ACTIONS(325),
    [anon_sym_LT] = ACTIONS(327),
    [anon_sym_GT] = ACTIONS(327),
    [anon_sym_EQ] = ACTIONS(327),
    [anon_sym_PLUS_EQ] = ACTIONS(325),
    [anon_sym_DASH_EQ] = ACTIONS(325),
    [anon_sym_STAR_EQ] = ACTIONS(325),
    [anon_sym_SLASH_EQ] = ACTIONS(325),
    [anon_sym_PERCENT_EQ] = ACTIONS(325),
    [anon_sym_AMP_EQ] = ACTIONS(325),
    [anon_sym_PIPE_EQ] = ACTIONS(325),
    [anon_sym_CARET_EQ] = ACTIONS(325),
    [anon_sym_LT_LT_EQ] = ACTIONS(325),
    [anon_sym_GT_GT_EQ] = ACTIONS(325),
    [anon_sym_DOT] = ACTIONS(325),
    [anon_sym_true] = ACTIONS(327),
    [anon_sym_false] = ACTIONS(327),
    [anon_sym_DASH] = ACTIONS(327),
    [anon_sym_BANG] = ACTIONS(327),
    [anon_sym_AMP_AMP] = ACTIONS(325),
    [anon_sym_PIPE_PIPE] = ACTIONS(325),
    [anon_sym_AMP] = ACTIONS(327),
    [anon_sym_PIPE] = ACTIONS(327),
    [anon_sym_CARET] = ACTIONS(327),
    [anon_sym_EQ_EQ] = ACTIONS(325),
    [anon_sym_BANG_EQ] = ACTIONS(325),
    [anon_sym_LT_EQ] = ACTIONS(327),
    [anon_sym_GT_EQ] = ACTIONS(325),
    [anon_sym_LT_LT] = ACTIONS(327),
    [anon_sym_GT_GT] = ACTIONS(327),
    [anon_sym_PLUS] = ACTIONS(327),
    [anon_sym_SLASH] = ACTIONS(327),
    [anon_sym_QMARK] = ACTIONS(325),
    [anon_sym_DQUOTE] = ACTIONS(325),
    [anon_sym_SQUOTE] = ACTIONS(325),
    [sym__ident_reg] = ACTIONS(327),
    [anon_sym_POUND] = ACTIONS(325),
    [sym_int_literal] = ACTIONS(327),
    [sym_float_literal] = ACTIONS(325),
    [anon_sym_ease] = ACTIONS(327),
    [anon_sym_ease_DASHin] = ACTIONS(327),
    [anon_sym_ease_in] = ACTIONS(327),
    [anon_sym_ease_in_out] = ACTIONS(327),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(327),
    [anon_sym_ease_out] = ACTIONS(327),
    [anon_sym_ease_DASHout] = ACTIONS(327),
    [anon_sym_start] = ACTIONS(327),
    [anon_sym_end] = ACTIONS(327),
    [anon_sym_black] = ACTIONS(327),
    [anon_sym_blue] = ACTIONS(327),
    [anon_sym_green] = ACTIONS(327),
    [anon_sym_red] = ACTIONS(327),
    [anon_sym_yellow] = ACTIONS(327),
    [anon_sym_white] = ACTIONS(327),
    [anon_sym_gray] = ACTIONS(327),
    [anon_sym_transparent] = ACTIONS(327),
    [anon_sym_angle] = ACTIONS(327),
    [anon_sym_bool] = ACTIONS(327),
    [anon_sym_brush] = ACTIONS(327),
    [anon_sym_color] = ACTIONS(327),
    [anon_sym_float] = ACTIONS(327),
    [anon_sym_image] = ACTIONS(327),
    [anon_sym_int] = ACTIONS(327),
    [anon_sym_length] = ACTIONS(327),
    [anon_sym_percent] = ACTIONS(327),
    [anon_sym_physical_DASHlength] = ACTIONS(327),
    [anon_sym_physical_length] = ACTIONS(327),
    [anon_sym_string] = ACTIONS(327),
    [anon_sym_debug] = ACTIONS(327),
    [anon_sym_animation_DASHtick] = ACTIONS(327),
    [anon_sym_min] = ACTIONS(327),
    [anon_sym_max] = ACTIONS(327),
    [anon_sym_mod] = ACTIONS(327),
    [anon_sym_abs] = ACTIONS(327),
    [anon_sym_round] = ACTIONS(327),
    [anon_sym_ceil] = ACTIONS(327),
    [anon_sym_floor] = ACTIONS(327),
    [anon_sym_sin] = ACTIONS(327),
    [anon_sym_cos] = ACTIONS(327),
    [anon_sym_tan] = ACTIONS(327),
    [anon_sym_asin] = ACTIONS(327),
    [anon_sym_acos] = ACTIONS(327),
    [anon_sym_atan] = ACTIONS(327),
    [anon_sym_sqrt] = ACTIONS(327),
    [anon_sym_pow] = ACTIONS(327),
    [anon_sym_log] = ACTIONS(327),
    [anon_sym_rgb] = ACTIONS(327),
    [anon_sym_easing] = ACTIONS(327),
    [anon_sym_duration] = ACTIONS(327),
    [anon_sym_parent] = ACTIONS(327),
    [anon_sym_root] = ACTIONS(327),
    [sym_comment] = ACTIONS(3),
  },
  [66] = {
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_COLON] = ACTIONS(435),
    [anon_sym_COMMA] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(435),
    [anon_sym_SEMI] = ACTIONS(435),
    [anon_sym_if] = ACTIONS(437),
    [anon_sym_AT] = ACTIONS(435),
    [anon_sym_LBRACK] = ACTIONS(435),
    [anon_sym_STAR] = ACTIONS(437),
    [anon_sym_LT_EQ_GT] = ACTIONS(435),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_RPAREN] = ACTIONS(435),
    [anon_sym_LT] = ACTIONS(437),
    [anon_sym_GT] = ACTIONS(437),
    [anon_sym_EQ] = ACTIONS(437),
    [anon_sym_PLUS_EQ] = ACTIONS(435),
    [anon_sym_DASH_EQ] = ACTIONS(435),
    [anon_sym_STAR_EQ] = ACTIONS(435),
    [anon_sym_SLASH_EQ] = ACTIONS(435),
    [anon_sym_PERCENT_EQ] = ACTIONS(435),
    [anon_sym_AMP_EQ] = ACTIONS(435),
    [anon_sym_PIPE_EQ] = ACTIONS(435),
    [anon_sym_CARET_EQ] = ACTIONS(435),
    [anon_sym_LT_LT_EQ] = ACTIONS(435),
    [anon_sym_GT_GT_EQ] = ACTIONS(435),
    [anon_sym_DOT] = ACTIONS(435),
    [anon_sym_true] = ACTIONS(437),
    [anon_sym_false] = ACTIONS(437),
    [anon_sym_DASH] = ACTIONS(437),
    [anon_sym_BANG] = ACTIONS(437),
    [anon_sym_AMP_AMP] = ACTIONS(435),
    [anon_sym_PIPE_PIPE] = ACTIONS(435),
    [anon_sym_AMP] = ACTIONS(437),
    [anon_sym_PIPE] = ACTIONS(437),
    [anon_sym_CARET] = ACTIONS(437),
    [anon_sym_EQ_EQ] = ACTIONS(435),
    [anon_sym_BANG_EQ] = ACTIONS(435),
    [anon_sym_LT_EQ] = ACTIONS(437),
    [anon_sym_GT_EQ] = ACTIONS(435),
    [anon_sym_LT_LT] = ACTIONS(437),
    [anon_sym_GT_GT] = ACTIONS(437),
    [anon_sym_PLUS] = ACTIONS(437),
    [anon_sym_SLASH] = ACTIONS(437),
    [anon_sym_QMARK] = ACTIONS(435),
    [anon_sym_DQUOTE] = ACTIONS(435),
    [anon_sym_SQUOTE] = ACTIONS(435),
    [sym__ident_reg] = ACTIONS(437),
    [anon_sym_POUND] = ACTIONS(435),
    [sym_int_literal] = ACTIONS(437),
    [sym_float_literal] = ACTIONS(435),
    [anon_sym_ease] = ACTIONS(437),
    [anon_sym_ease_DASHin] = ACTIONS(437),
    [anon_sym_ease_in] = ACTIONS(437),
    [anon_sym_ease_in_out] = ACTIONS(437),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(437),
    [anon_sym_ease_out] = ACTIONS(437),
    [anon_sym_ease_DASHout] = ACTIONS(437),
    [anon_sym_start] = ACTIONS(437),
    [anon_sym_end] = ACTIONS(437),
    [anon_sym_black] = ACTIONS(437),
    [anon_sym_blue] = ACTIONS(437),
    [anon_sym_green] = ACTIONS(437),
    [anon_sym_red] = ACTIONS(437),
    [anon_sym_yellow] = ACTIONS(437),
    [anon_sym_white] = ACTIONS(437),
    [anon_sym_gray] = ACTIONS(437),
    [anon_sym_transparent] = ACTIONS(437),
    [anon_sym_angle] = ACTIONS(437),
    [anon_sym_bool] = ACTIONS(437),
    [anon_sym_brush] = ACTIONS(437),
    [anon_sym_color] = ACTIONS(437),
    [anon_sym_float] = ACTIONS(437),
    [anon_sym_image] = ACTIONS(437),
    [anon_sym_int] = ACTIONS(437),
    [anon_sym_length] = ACTIONS(437),
    [anon_sym_percent] = ACTIONS(437),
    [anon_sym_physical_DASHlength] = ACTIONS(437),
    [anon_sym_physical_length] = ACTIONS(437),
    [anon_sym_string] = ACTIONS(437),
    [anon_sym_debug] = ACTIONS(437),
    [anon_sym_animation_DASHtick] = ACTIONS(437),
    [anon_sym_min] = ACTIONS(437),
    [anon_sym_max] = ACTIONS(437),
    [anon_sym_mod] = ACTIONS(437),
    [anon_sym_abs] = ACTIONS(437),
    [anon_sym_round] = ACTIONS(437),
    [anon_sym_ceil] = ACTIONS(437),
    [anon_sym_floor] = ACTIONS(437),
    [anon_sym_sin] = ACTIONS(437),
    [anon_sym_cos] = ACTIONS(437),
    [anon_sym_tan] = ACTIONS(437),
    [anon_sym_asin] = ACTIONS(437),
    [anon_sym_acos] = ACTIONS(437),
    [anon_sym_atan] = ACTIONS(437),
    [anon_sym_sqrt] = ACTIONS(437),
    [anon_sym_pow] = ACTIONS(437),
    [anon_sym_log] = ACTIONS(437),
    [anon_sym_rgb] = ACTIONS(437),
    [anon_sym_easing] = ACTIONS(437),
    [anon_sym_duration] = ACTIONS(437),
    [anon_sym_parent] = ACTIONS(437),
    [anon_sym_root] = ACTIONS(437),
    [sym_comment] = ACTIONS(3),
  },
  [67] = {
    [anon_sym_LBRACE] = ACTIONS(439),
    [anon_sym_COLON] = ACTIONS(439),
    [anon_sym_COMMA] = ACTIONS(439),
    [anon_sym_RBRACE] = ACTIONS(439),
    [anon_sym_SEMI] = ACTIONS(439),
    [anon_sym_if] = ACTIONS(441),
    [anon_sym_AT] = ACTIONS(439),
    [anon_sym_LBRACK] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(441),
    [anon_sym_LT_EQ_GT] = ACTIONS(439),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_RPAREN] = ACTIONS(439),
    [anon_sym_LT] = ACTIONS(441),
    [anon_sym_GT] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(441),
    [anon_sym_PLUS_EQ] = ACTIONS(439),
    [anon_sym_DASH_EQ] = ACTIONS(439),
    [anon_sym_STAR_EQ] = ACTIONS(439),
    [anon_sym_SLASH_EQ] = ACTIONS(439),
    [anon_sym_PERCENT_EQ] = ACTIONS(439),
    [anon_sym_AMP_EQ] = ACTIONS(439),
    [anon_sym_PIPE_EQ] = ACTIONS(439),
    [anon_sym_CARET_EQ] = ACTIONS(439),
    [anon_sym_LT_LT_EQ] = ACTIONS(439),
    [anon_sym_GT_GT_EQ] = ACTIONS(439),
    [anon_sym_DOT] = ACTIONS(439),
    [anon_sym_true] = ACTIONS(441),
    [anon_sym_false] = ACTIONS(441),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_BANG] = ACTIONS(441),
    [anon_sym_AMP_AMP] = ACTIONS(439),
    [anon_sym_PIPE_PIPE] = ACTIONS(439),
    [anon_sym_AMP] = ACTIONS(441),
    [anon_sym_PIPE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_EQ_EQ] = ACTIONS(439),
    [anon_sym_BANG_EQ] = ACTIONS(439),
    [anon_sym_LT_EQ] = ACTIONS(441),
    [anon_sym_GT_EQ] = ACTIONS(439),
    [anon_sym_LT_LT] = ACTIONS(441),
    [anon_sym_GT_GT] = ACTIONS(441),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_SLASH] = ACTIONS(441),
    [anon_sym_QMARK] = ACTIONS(439),
    [anon_sym_DQUOTE] = ACTIONS(439),
    [anon_sym_SQUOTE] = ACTIONS(439),
    [sym__ident_reg] = ACTIONS(441),
    [anon_sym_POUND] = ACTIONS(439),
    [sym_int_literal] = ACTIONS(441),
    [sym_float_literal] = ACTIONS(439),
    [anon_sym_ease] = ACTIONS(441),
    [anon_sym_ease_DASHin] = ACTIONS(441),
    [anon_sym_ease_in] = ACTIONS(441),
    [anon_sym_ease_in_out] = ACTIONS(441),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(441),
    [anon_sym_ease_out] = ACTIONS(441),
    [anon_sym_ease_DASHout] = ACTIONS(441),
    [anon_sym_start] = ACTIONS(441),
    [anon_sym_end] = ACTIONS(441),
    [anon_sym_black] = ACTIONS(441),
    [anon_sym_blue] = ACTIONS(441),
    [anon_sym_green] = ACTIONS(441),
    [anon_sym_red] = ACTIONS(441),
    [anon_sym_yellow] = ACTIONS(441),
    [anon_sym_white] = ACTIONS(441),
    [anon_sym_gray] = ACTIONS(441),
    [anon_sym_transparent] = ACTIONS(441),
    [anon_sym_angle] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_brush] = ACTIONS(441),
    [anon_sym_color] = ACTIONS(441),
    [anon_sym_float] = ACTIONS(441),
    [anon_sym_image] = ACTIONS(441),
    [anon_sym_int] = ACTIONS(441),
    [anon_sym_length] = ACTIONS(441),
    [anon_sym_percent] = ACTIONS(441),
    [anon_sym_physical_DASHlength] = ACTIONS(441),
    [anon_sym_physical_length] = ACTIONS(441),
    [anon_sym_string] = ACTIONS(441),
    [anon_sym_debug] = ACTIONS(441),
    [anon_sym_animation_DASHtick] = ACTIONS(441),
    [anon_sym_min] = ACTIONS(441),
    [anon_sym_max] = ACTIONS(441),
    [anon_sym_mod] = ACTIONS(441),
    [anon_sym_abs] = ACTIONS(441),
    [anon_sym_round] = ACTIONS(441),
    [anon_sym_ceil] = ACTIONS(441),
    [anon_sym_floor] = ACTIONS(441),
    [anon_sym_sin] = ACTIONS(441),
    [anon_sym_cos] = ACTIONS(441),
    [anon_sym_tan] = ACTIONS(441),
    [anon_sym_asin] = ACTIONS(441),
    [anon_sym_acos] = ACTIONS(441),
    [anon_sym_atan] = ACTIONS(441),
    [anon_sym_sqrt] = ACTIONS(441),
    [anon_sym_pow] = ACTIONS(441),
    [anon_sym_log] = ACTIONS(441),
    [anon_sym_rgb] = ACTIONS(441),
    [anon_sym_easing] = ACTIONS(441),
    [anon_sym_duration] = ACTIONS(441),
    [anon_sym_parent] = ACTIONS(441),
    [anon_sym_root] = ACTIONS(441),
    [sym_comment] = ACTIONS(3),
  },
  [68] = {
    [anon_sym_LBRACE] = ACTIONS(208),
    [anon_sym_COLON] = ACTIONS(208),
    [anon_sym_COMMA] = ACTIONS(208),
    [anon_sym_RBRACE] = ACTIONS(208),
    [anon_sym_SEMI] = ACTIONS(208),
    [anon_sym_if] = ACTIONS(210),
    [anon_sym_AT] = ACTIONS(208),
    [anon_sym_LBRACK] = ACTIONS(208),
    [anon_sym_STAR] = ACTIONS(210),
    [anon_sym_LT_EQ_GT] = ACTIONS(208),
    [anon_sym_LPAREN] = ACTIONS(208),
    [anon_sym_RPAREN] = ACTIONS(208),
    [anon_sym_LT] = ACTIONS(210),
    [anon_sym_GT] = ACTIONS(210),
    [anon_sym_EQ] = ACTIONS(210),
    [anon_sym_PLUS_EQ] = ACTIONS(208),
    [anon_sym_DASH_EQ] = ACTIONS(208),
    [anon_sym_STAR_EQ] = ACTIONS(208),
    [anon_sym_SLASH_EQ] = ACTIONS(208),
    [anon_sym_PERCENT_EQ] = ACTIONS(208),
    [anon_sym_AMP_EQ] = ACTIONS(208),
    [anon_sym_PIPE_EQ] = ACTIONS(208),
    [anon_sym_CARET_EQ] = ACTIONS(208),
    [anon_sym_LT_LT_EQ] = ACTIONS(208),
    [anon_sym_GT_GT_EQ] = ACTIONS(208),
    [anon_sym_DOT] = ACTIONS(208),
    [anon_sym_true] = ACTIONS(210),
    [anon_sym_false] = ACTIONS(210),
    [anon_sym_DASH] = ACTIONS(210),
    [anon_sym_BANG] = ACTIONS(210),
    [anon_sym_AMP_AMP] = ACTIONS(208),
    [anon_sym_PIPE_PIPE] = ACTIONS(208),
    [anon_sym_AMP] = ACTIONS(210),
    [anon_sym_PIPE] = ACTIONS(210),
    [anon_sym_CARET] = ACTIONS(210),
    [anon_sym_EQ_EQ] = ACTIONS(208),
    [anon_sym_BANG_EQ] = ACTIONS(208),
    [anon_sym_LT_EQ] = ACTIONS(210),
    [anon_sym_GT_EQ] = ACTIONS(208),
    [anon_sym_LT_LT] = ACTIONS(210),
    [anon_sym_GT_GT] = ACTIONS(210),
    [anon_sym_PLUS] = ACTIONS(210),
    [anon_sym_SLASH] = ACTIONS(210),
    [anon_sym_QMARK] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(208),
    [anon_sym_SQUOTE] = ACTIONS(208),
    [sym__ident_reg] = ACTIONS(210),
    [anon_sym_POUND] = ACTIONS(208),
    [sym_int_literal] = ACTIONS(210),
    [sym_float_literal] = ACTIONS(208),
    [anon_sym_ease] = ACTIONS(210),
    [anon_sym_ease_DASHin] = ACTIONS(210),
    [anon_sym_ease_in] = ACTIONS(210),
    [anon_sym_ease_in_out] = ACTIONS(210),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(210),
    [anon_sym_ease_out] = ACTIONS(210),
    [anon_sym_ease_DASHout] = ACTIONS(210),
    [anon_sym_start] = ACTIONS(210),
    [anon_sym_end] = ACTIONS(210),
    [anon_sym_black] = ACTIONS(210),
    [anon_sym_blue] = ACTIONS(210),
    [anon_sym_green] = ACTIONS(210),
    [anon_sym_red] = ACTIONS(210),
    [anon_sym_yellow] = ACTIONS(210),
    [anon_sym_white] = ACTIONS(210),
    [anon_sym_gray] = ACTIONS(210),
    [anon_sym_transparent] = ACTIONS(210),
    [anon_sym_angle] = ACTIONS(210),
    [anon_sym_bool] = ACTIONS(210),
    [anon_sym_brush] = ACTIONS(210),
    [anon_sym_color] = ACTIONS(210),
    [anon_sym_float] = ACTIONS(210),
    [anon_sym_image] = ACTIONS(210),
    [anon_sym_int] = ACTIONS(210),
    [anon_sym_length] = ACTIONS(210),
    [anon_sym_percent] = ACTIONS(210),
    [anon_sym_physical_DASHlength] = ACTIONS(210),
    [anon_sym_physical_length] = ACTIONS(210),
    [anon_sym_string] = ACTIONS(210),
    [anon_sym_debug] = ACTIONS(210),
    [anon_sym_animation_DASHtick] = ACTIONS(210),
    [anon_sym_min] = ACTIONS(210),
    [anon_sym_max] = ACTIONS(210),
    [anon_sym_mod] = ACTIONS(210),
    [anon_sym_abs] = ACTIONS(210),
    [anon_sym_round] = ACTIONS(210),
    [anon_sym_ceil] = ACTIONS(210),
    [anon_sym_floor] = ACTIONS(210),
    [anon_sym_sin] = ACTIONS(210),
    [anon_sym_cos] = ACTIONS(210),
    [anon_sym_tan] = ACTIONS(210),
    [anon_sym_asin] = ACTIONS(210),
    [anon_sym_acos] = ACTIONS(210),
    [anon_sym_atan] = ACTIONS(210),
    [anon_sym_sqrt] = ACTIONS(210),
    [anon_sym_pow] = ACTIONS(210),
    [anon_sym_log] = ACTIONS(210),
    [anon_sym_rgb] = ACTIONS(210),
    [anon_sym_easing] = ACTIONS(210),
    [anon_sym_duration] = ACTIONS(210),
    [anon_sym_parent] = ACTIONS(210),
    [anon_sym_root] = ACTIONS(210),
    [sym_comment] = ACTIONS(3),
  },
  [69] = {
    [anon_sym_LBRACE] = ACTIONS(443),
    [anon_sym_COLON] = ACTIONS(443),
    [anon_sym_COMMA] = ACTIONS(443),
    [anon_sym_RBRACE] = ACTIONS(443),
    [anon_sym_SEMI] = ACTIONS(443),
    [anon_sym_if] = ACTIONS(445),
    [anon_sym_AT] = ACTIONS(443),
    [anon_sym_LBRACK] = ACTIONS(443),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_LT_EQ_GT] = ACTIONS(443),
    [anon_sym_LPAREN] = ACTIONS(443),
    [anon_sym_RPAREN] = ACTIONS(443),
    [anon_sym_LT] = ACTIONS(445),
    [anon_sym_GT] = ACTIONS(445),
    [anon_sym_EQ] = ACTIONS(445),
    [anon_sym_PLUS_EQ] = ACTIONS(443),
    [anon_sym_DASH_EQ] = ACTIONS(443),
    [anon_sym_STAR_EQ] = ACTIONS(443),
    [anon_sym_SLASH_EQ] = ACTIONS(443),
    [anon_sym_PERCENT_EQ] = ACTIONS(443),
    [anon_sym_AMP_EQ] = ACTIONS(443),
    [anon_sym_PIPE_EQ] = ACTIONS(443),
    [anon_sym_CARET_EQ] = ACTIONS(443),
    [anon_sym_LT_LT_EQ] = ACTIONS(443),
    [anon_sym_GT_GT_EQ] = ACTIONS(443),
    [anon_sym_DOT] = ACTIONS(443),
    [anon_sym_true] = ACTIONS(445),
    [anon_sym_false] = ACTIONS(445),
    [anon_sym_DASH] = ACTIONS(445),
    [anon_sym_BANG] = ACTIONS(445),
    [anon_sym_AMP_AMP] = ACTIONS(443),
    [anon_sym_PIPE_PIPE] = ACTIONS(443),
    [anon_sym_AMP] = ACTIONS(445),
    [anon_sym_PIPE] = ACTIONS(445),
    [anon_sym_CARET] = ACTIONS(445),
    [anon_sym_EQ_EQ] = ACTIONS(443),
    [anon_sym_BANG_EQ] = ACTIONS(443),
    [anon_sym_LT_EQ] = ACTIONS(445),
    [anon_sym_GT_EQ] = ACTIONS(443),
    [anon_sym_LT_LT] = ACTIONS(445),
    [anon_sym_GT_GT] = ACTIONS(445),
    [anon_sym_PLUS] = ACTIONS(445),
    [anon_sym_SLASH] = ACTIONS(445),
    [anon_sym_QMARK] = ACTIONS(443),
    [anon_sym_DQUOTE] = ACTIONS(443),
    [anon_sym_SQUOTE] = ACTIONS(443),
    [sym__ident_reg] = ACTIONS(445),
    [anon_sym_POUND] = ACTIONS(443),
    [sym_int_literal] = ACTIONS(445),
    [sym_float_literal] = ACTIONS(443),
    [anon_sym_ease] = ACTIONS(445),
    [anon_sym_ease_DASHin] = ACTIONS(445),
    [anon_sym_ease_in] = ACTIONS(445),
    [anon_sym_ease_in_out] = ACTIONS(445),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(445),
    [anon_sym_ease_out] = ACTIONS(445),
    [anon_sym_ease_DASHout] = ACTIONS(445),
    [anon_sym_start] = ACTIONS(445),
    [anon_sym_end] = ACTIONS(445),
    [anon_sym_black] = ACTIONS(445),
    [anon_sym_blue] = ACTIONS(445),
    [anon_sym_green] = ACTIONS(445),
    [anon_sym_red] = ACTIONS(445),
    [anon_sym_yellow] = ACTIONS(445),
    [anon_sym_white] = ACTIONS(445),
    [anon_sym_gray] = ACTIONS(445),
    [anon_sym_transparent] = ACTIONS(445),
    [anon_sym_angle] = ACTIONS(445),
    [anon_sym_bool] = ACTIONS(445),
    [anon_sym_brush] = ACTIONS(445),
    [anon_sym_color] = ACTIONS(445),
    [anon_sym_float] = ACTIONS(445),
    [anon_sym_image] = ACTIONS(445),
    [anon_sym_int] = ACTIONS(445),
    [anon_sym_length] = ACTIONS(445),
    [anon_sym_percent] = ACTIONS(445),
    [anon_sym_physical_DASHlength] = ACTIONS(445),
    [anon_sym_physical_length] = ACTIONS(445),
    [anon_sym_string] = ACTIONS(445),
    [anon_sym_debug] = ACTIONS(445),
    [anon_sym_animation_DASHtick] = ACTIONS(445),
    [anon_sym_min] = ACTIONS(445),
    [anon_sym_max] = ACTIONS(445),
    [anon_sym_mod] = ACTIONS(445),
    [anon_sym_abs] = ACTIONS(445),
    [anon_sym_round] = ACTIONS(445),
    [anon_sym_ceil] = ACTIONS(445),
    [anon_sym_floor] = ACTIONS(445),
    [anon_sym_sin] = ACTIONS(445),
    [anon_sym_cos] = ACTIONS(445),
    [anon_sym_tan] = ACTIONS(445),
    [anon_sym_asin] = ACTIONS(445),
    [anon_sym_acos] = ACTIONS(445),
    [anon_sym_atan] = ACTIONS(445),
    [anon_sym_sqrt] = ACTIONS(445),
    [anon_sym_pow] = ACTIONS(445),
    [anon_sym_log] = ACTIONS(445),
    [anon_sym_rgb] = ACTIONS(445),
    [anon_sym_easing] = ACTIONS(445),
    [anon_sym_duration] = ACTIONS(445),
    [anon_sym_parent] = ACTIONS(445),
    [anon_sym_root] = ACTIONS(445),
    [sym_comment] = ACTIONS(3),
  },
  [70] = {
    [anon_sym_LBRACE] = ACTIONS(447),
    [anon_sym_COLON] = ACTIONS(447),
    [anon_sym_COMMA] = ACTIONS(447),
    [anon_sym_RBRACE] = ACTIONS(447),
    [anon_sym_SEMI] = ACTIONS(447),
    [anon_sym_if] = ACTIONS(449),
    [anon_sym_AT] = ACTIONS(447),
    [anon_sym_LBRACK] = ACTIONS(447),
    [anon_sym_STAR] = ACTIONS(449),
    [anon_sym_LT_EQ_GT] = ACTIONS(447),
    [anon_sym_LPAREN] = ACTIONS(447),
    [anon_sym_RPAREN] = ACTIONS(447),
    [anon_sym_LT] = ACTIONS(449),
    [anon_sym_GT] = ACTIONS(449),
    [anon_sym_EQ] = ACTIONS(449),
    [anon_sym_PLUS_EQ] = ACTIONS(447),
    [anon_sym_DASH_EQ] = ACTIONS(447),
    [anon_sym_STAR_EQ] = ACTIONS(447),
    [anon_sym_SLASH_EQ] = ACTIONS(447),
    [anon_sym_PERCENT_EQ] = ACTIONS(447),
    [anon_sym_AMP_EQ] = ACTIONS(447),
    [anon_sym_PIPE_EQ] = ACTIONS(447),
    [anon_sym_CARET_EQ] = ACTIONS(447),
    [anon_sym_LT_LT_EQ] = ACTIONS(447),
    [anon_sym_GT_GT_EQ] = ACTIONS(447),
    [anon_sym_DOT] = ACTIONS(447),
    [anon_sym_true] = ACTIONS(449),
    [anon_sym_false] = ACTIONS(449),
    [anon_sym_DASH] = ACTIONS(449),
    [anon_sym_BANG] = ACTIONS(449),
    [anon_sym_AMP_AMP] = ACTIONS(447),
    [anon_sym_PIPE_PIPE] = ACTIONS(447),
    [anon_sym_AMP] = ACTIONS(449),
    [anon_sym_PIPE] = ACTIONS(449),
    [anon_sym_CARET] = ACTIONS(449),
    [anon_sym_EQ_EQ] = ACTIONS(447),
    [anon_sym_BANG_EQ] = ACTIONS(447),
    [anon_sym_LT_EQ] = ACTIONS(449),
    [anon_sym_GT_EQ] = ACTIONS(447),
    [anon_sym_LT_LT] = ACTIONS(449),
    [anon_sym_GT_GT] = ACTIONS(449),
    [anon_sym_PLUS] = ACTIONS(449),
    [anon_sym_SLASH] = ACTIONS(449),
    [anon_sym_QMARK] = ACTIONS(447),
    [anon_sym_DQUOTE] = ACTIONS(447),
    [anon_sym_SQUOTE] = ACTIONS(447),
    [sym__ident_reg] = ACTIONS(449),
    [anon_sym_POUND] = ACTIONS(447),
    [sym_int_literal] = ACTIONS(449),
    [sym_float_literal] = ACTIONS(447),
    [anon_sym_ease] = ACTIONS(449),
    [anon_sym_ease_DASHin] = ACTIONS(449),
    [anon_sym_ease_in] = ACTIONS(449),
    [anon_sym_ease_in_out] = ACTIONS(449),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(449),
    [anon_sym_ease_out] = ACTIONS(449),
    [anon_sym_ease_DASHout] = ACTIONS(449),
    [anon_sym_start] = ACTIONS(449),
    [anon_sym_end] = ACTIONS(449),
    [anon_sym_black] = ACTIONS(449),
    [anon_sym_blue] = ACTIONS(449),
    [anon_sym_green] = ACTIONS(449),
    [anon_sym_red] = ACTIONS(449),
    [anon_sym_yellow] = ACTIONS(449),
    [anon_sym_white] = ACTIONS(449),
    [anon_sym_gray] = ACTIONS(449),
    [anon_sym_transparent] = ACTIONS(449),
    [anon_sym_angle] = ACTIONS(449),
    [anon_sym_bool] = ACTIONS(449),
    [anon_sym_brush] = ACTIONS(449),
    [anon_sym_color] = ACTIONS(449),
    [anon_sym_float] = ACTIONS(449),
    [anon_sym_image] = ACTIONS(449),
    [anon_sym_int] = ACTIONS(449),
    [anon_sym_length] = ACTIONS(449),
    [anon_sym_percent] = ACTIONS(449),
    [anon_sym_physical_DASHlength] = ACTIONS(449),
    [anon_sym_physical_length] = ACTIONS(449),
    [anon_sym_string] = ACTIONS(449),
    [anon_sym_debug] = ACTIONS(449),
    [anon_sym_animation_DASHtick] = ACTIONS(449),
    [anon_sym_min] = ACTIONS(449),
    [anon_sym_max] = ACTIONS(449),
    [anon_sym_mod] = ACTIONS(449),
    [anon_sym_abs] = ACTIONS(449),
    [anon_sym_round] = ACTIONS(449),
    [anon_sym_ceil] = ACTIONS(449),
    [anon_sym_floor] = ACTIONS(449),
    [anon_sym_sin] = ACTIONS(449),
    [anon_sym_cos] = ACTIONS(449),
    [anon_sym_tan] = ACTIONS(449),
    [anon_sym_asin] = ACTIONS(449),
    [anon_sym_acos] = ACTIONS(449),
    [anon_sym_atan] = ACTIONS(449),
    [anon_sym_sqrt] = ACTIONS(449),
    [anon_sym_pow] = ACTIONS(449),
    [anon_sym_log] = ACTIONS(449),
    [anon_sym_rgb] = ACTIONS(449),
    [anon_sym_easing] = ACTIONS(449),
    [anon_sym_duration] = ACTIONS(449),
    [anon_sym_parent] = ACTIONS(449),
    [anon_sym_root] = ACTIONS(449),
    [sym_comment] = ACTIONS(3),
  },
  [71] = {
    [anon_sym_LBRACE] = ACTIONS(451),
    [anon_sym_COLON] = ACTIONS(451),
    [anon_sym_COMMA] = ACTIONS(451),
    [anon_sym_RBRACE] = ACTIONS(451),
    [anon_sym_SEMI] = ACTIONS(451),
    [anon_sym_if] = ACTIONS(453),
    [anon_sym_AT] = ACTIONS(451),
    [anon_sym_LBRACK] = ACTIONS(451),
    [anon_sym_STAR] = ACTIONS(453),
    [anon_sym_LT_EQ_GT] = ACTIONS(451),
    [anon_sym_LPAREN] = ACTIONS(451),
    [anon_sym_RPAREN] = ACTIONS(451),
    [anon_sym_LT] = ACTIONS(453),
    [anon_sym_GT] = ACTIONS(453),
    [anon_sym_EQ] = ACTIONS(453),
    [anon_sym_PLUS_EQ] = ACTIONS(451),
    [anon_sym_DASH_EQ] = ACTIONS(451),
    [anon_sym_STAR_EQ] = ACTIONS(451),
    [anon_sym_SLASH_EQ] = ACTIONS(451),
    [anon_sym_PERCENT_EQ] = ACTIONS(451),
    [anon_sym_AMP_EQ] = ACTIONS(451),
    [anon_sym_PIPE_EQ] = ACTIONS(451),
    [anon_sym_CARET_EQ] = ACTIONS(451),
    [anon_sym_LT_LT_EQ] = ACTIONS(451),
    [anon_sym_GT_GT_EQ] = ACTIONS(451),
    [anon_sym_DOT] = ACTIONS(451),
    [anon_sym_true] = ACTIONS(453),
    [anon_sym_false] = ACTIONS(453),
    [anon_sym_DASH] = ACTIONS(453),
    [anon_sym_BANG] = ACTIONS(453),
    [anon_sym_AMP_AMP] = ACTIONS(451),
    [anon_sym_PIPE_PIPE] = ACTIONS(451),
    [anon_sym_AMP] = ACTIONS(453),
    [anon_sym_PIPE] = ACTIONS(453),
    [anon_sym_CARET] = ACTIONS(453),
    [anon_sym_EQ_EQ] = ACTIONS(451),
    [anon_sym_BANG_EQ] = ACTIONS(451),
    [anon_sym_LT_EQ] = ACTIONS(453),
    [anon_sym_GT_EQ] = ACTIONS(451),
    [anon_sym_LT_LT] = ACTIONS(453),
    [anon_sym_GT_GT] = ACTIONS(453),
    [anon_sym_PLUS] = ACTIONS(453),
    [anon_sym_SLASH] = ACTIONS(453),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_DQUOTE] = ACTIONS(451),
    [anon_sym_SQUOTE] = ACTIONS(451),
    [sym__ident_reg] = ACTIONS(453),
    [anon_sym_POUND] = ACTIONS(451),
    [sym_int_literal] = ACTIONS(453),
    [sym_float_literal] = ACTIONS(451),
    [anon_sym_ease] = ACTIONS(453),
    [anon_sym_ease_DASHin] = ACTIONS(453),
    [anon_sym_ease_in] = ACTIONS(453),
    [anon_sym_ease_in_out] = ACTIONS(453),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(453),
    [anon_sym_ease_out] = ACTIONS(453),
    [anon_sym_ease_DASHout] = ACTIONS(453),
    [anon_sym_start] = ACTIONS(453),
    [anon_sym_end] = ACTIONS(453),
    [anon_sym_black] = ACTIONS(453),
    [anon_sym_blue] = ACTIONS(453),
    [anon_sym_green] = ACTIONS(453),
    [anon_sym_red] = ACTIONS(453),
    [anon_sym_yellow] = ACTIONS(453),
    [anon_sym_white] = ACTIONS(453),
    [anon_sym_gray] = ACTIONS(453),
    [anon_sym_transparent] = ACTIONS(453),
    [anon_sym_angle] = ACTIONS(453),
    [anon_sym_bool] = ACTIONS(453),
    [anon_sym_brush] = ACTIONS(453),
    [anon_sym_color] = ACTIONS(453),
    [anon_sym_float] = ACTIONS(453),
    [anon_sym_image] = ACTIONS(453),
    [anon_sym_int] = ACTIONS(453),
    [anon_sym_length] = ACTIONS(453),
    [anon_sym_percent] = ACTIONS(453),
    [anon_sym_physical_DASHlength] = ACTIONS(453),
    [anon_sym_physical_length] = ACTIONS(453),
    [anon_sym_string] = ACTIONS(453),
    [anon_sym_debug] = ACTIONS(453),
    [anon_sym_animation_DASHtick] = ACTIONS(453),
    [anon_sym_min] = ACTIONS(453),
    [anon_sym_max] = ACTIONS(453),
    [anon_sym_mod] = ACTIONS(453),
    [anon_sym_abs] = ACTIONS(453),
    [anon_sym_round] = ACTIONS(453),
    [anon_sym_ceil] = ACTIONS(453),
    [anon_sym_floor] = ACTIONS(453),
    [anon_sym_sin] = ACTIONS(453),
    [anon_sym_cos] = ACTIONS(453),
    [anon_sym_tan] = ACTIONS(453),
    [anon_sym_asin] = ACTIONS(453),
    [anon_sym_acos] = ACTIONS(453),
    [anon_sym_atan] = ACTIONS(453),
    [anon_sym_sqrt] = ACTIONS(453),
    [anon_sym_pow] = ACTIONS(453),
    [anon_sym_log] = ACTIONS(453),
    [anon_sym_rgb] = ACTIONS(453),
    [anon_sym_easing] = ACTIONS(453),
    [anon_sym_duration] = ACTIONS(453),
    [anon_sym_parent] = ACTIONS(453),
    [anon_sym_root] = ACTIONS(453),
    [sym_comment] = ACTIONS(3),
  },
  [72] = {
    [anon_sym_LBRACE] = ACTIONS(455),
    [anon_sym_COLON] = ACTIONS(455),
    [anon_sym_COMMA] = ACTIONS(455),
    [anon_sym_RBRACE] = ACTIONS(455),
    [anon_sym_SEMI] = ACTIONS(455),
    [anon_sym_if] = ACTIONS(457),
    [anon_sym_AT] = ACTIONS(455),
    [anon_sym_LBRACK] = ACTIONS(455),
    [anon_sym_STAR] = ACTIONS(457),
    [anon_sym_LT_EQ_GT] = ACTIONS(455),
    [anon_sym_LPAREN] = ACTIONS(455),
    [anon_sym_RPAREN] = ACTIONS(455),
    [anon_sym_LT] = ACTIONS(457),
    [anon_sym_GT] = ACTIONS(457),
    [anon_sym_EQ] = ACTIONS(457),
    [anon_sym_PLUS_EQ] = ACTIONS(455),
    [anon_sym_DASH_EQ] = ACTIONS(455),
    [anon_sym_STAR_EQ] = ACTIONS(455),
    [anon_sym_SLASH_EQ] = ACTIONS(455),
    [anon_sym_PERCENT_EQ] = ACTIONS(455),
    [anon_sym_AMP_EQ] = ACTIONS(455),
    [anon_sym_PIPE_EQ] = ACTIONS(455),
    [anon_sym_CARET_EQ] = ACTIONS(455),
    [anon_sym_LT_LT_EQ] = ACTIONS(455),
    [anon_sym_GT_GT_EQ] = ACTIONS(455),
    [anon_sym_DOT] = ACTIONS(455),
    [anon_sym_true] = ACTIONS(457),
    [anon_sym_false] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [anon_sym_BANG] = ACTIONS(457),
    [anon_sym_AMP_AMP] = ACTIONS(455),
    [anon_sym_PIPE_PIPE] = ACTIONS(455),
    [anon_sym_AMP] = ACTIONS(457),
    [anon_sym_PIPE] = ACTIONS(457),
    [anon_sym_CARET] = ACTIONS(457),
    [anon_sym_EQ_EQ] = ACTIONS(455),
    [anon_sym_BANG_EQ] = ACTIONS(455),
    [anon_sym_LT_EQ] = ACTIONS(457),
    [anon_sym_GT_EQ] = ACTIONS(455),
    [anon_sym_LT_LT] = ACTIONS(457),
    [anon_sym_GT_GT] = ACTIONS(457),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_SLASH] = ACTIONS(457),
    [anon_sym_QMARK] = ACTIONS(455),
    [anon_sym_DQUOTE] = ACTIONS(455),
    [anon_sym_SQUOTE] = ACTIONS(455),
    [sym__ident_reg] = ACTIONS(457),
    [anon_sym_POUND] = ACTIONS(455),
    [sym_int_literal] = ACTIONS(457),
    [sym_float_literal] = ACTIONS(455),
    [anon_sym_ease] = ACTIONS(457),
    [anon_sym_ease_DASHin] = ACTIONS(457),
    [anon_sym_ease_in] = ACTIONS(457),
    [anon_sym_ease_in_out] = ACTIONS(457),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(457),
    [anon_sym_ease_out] = ACTIONS(457),
    [anon_sym_ease_DASHout] = ACTIONS(457),
    [anon_sym_start] = ACTIONS(457),
    [anon_sym_end] = ACTIONS(457),
    [anon_sym_black] = ACTIONS(457),
    [anon_sym_blue] = ACTIONS(457),
    [anon_sym_green] = ACTIONS(457),
    [anon_sym_red] = ACTIONS(457),
    [anon_sym_yellow] = ACTIONS(457),
    [anon_sym_white] = ACTIONS(457),
    [anon_sym_gray] = ACTIONS(457),
    [anon_sym_transparent] = ACTIONS(457),
    [anon_sym_angle] = ACTIONS(457),
    [anon_sym_bool] = ACTIONS(457),
    [anon_sym_brush] = ACTIONS(457),
    [anon_sym_color] = ACTIONS(457),
    [anon_sym_float] = ACTIONS(457),
    [anon_sym_image] = ACTIONS(457),
    [anon_sym_int] = ACTIONS(457),
    [anon_sym_length] = ACTIONS(457),
    [anon_sym_percent] = ACTIONS(457),
    [anon_sym_physical_DASHlength] = ACTIONS(457),
    [anon_sym_physical_length] = ACTIONS(457),
    [anon_sym_string] = ACTIONS(457),
    [anon_sym_debug] = ACTIONS(457),
    [anon_sym_animation_DASHtick] = ACTIONS(457),
    [anon_sym_min] = ACTIONS(457),
    [anon_sym_max] = ACTIONS(457),
    [anon_sym_mod] = ACTIONS(457),
    [anon_sym_abs] = ACTIONS(457),
    [anon_sym_round] = ACTIONS(457),
    [anon_sym_ceil] = ACTIONS(457),
    [anon_sym_floor] = ACTIONS(457),
    [anon_sym_sin] = ACTIONS(457),
    [anon_sym_cos] = ACTIONS(457),
    [anon_sym_tan] = ACTIONS(457),
    [anon_sym_asin] = ACTIONS(457),
    [anon_sym_acos] = ACTIONS(457),
    [anon_sym_atan] = ACTIONS(457),
    [anon_sym_sqrt] = ACTIONS(457),
    [anon_sym_pow] = ACTIONS(457),
    [anon_sym_log] = ACTIONS(457),
    [anon_sym_rgb] = ACTIONS(457),
    [anon_sym_easing] = ACTIONS(457),
    [anon_sym_duration] = ACTIONS(457),
    [anon_sym_parent] = ACTIONS(457),
    [anon_sym_root] = ACTIONS(457),
    [sym_comment] = ACTIONS(3),
  },
  [73] = {
    [anon_sym_LBRACE] = ACTIONS(459),
    [anon_sym_COLON] = ACTIONS(459),
    [anon_sym_COMMA] = ACTIONS(459),
    [anon_sym_RBRACE] = ACTIONS(459),
    [anon_sym_SEMI] = ACTIONS(459),
    [anon_sym_if] = ACTIONS(461),
    [anon_sym_AT] = ACTIONS(459),
    [anon_sym_LBRACK] = ACTIONS(459),
    [anon_sym_STAR] = ACTIONS(461),
    [anon_sym_LT_EQ_GT] = ACTIONS(459),
    [anon_sym_LPAREN] = ACTIONS(459),
    [anon_sym_RPAREN] = ACTIONS(459),
    [anon_sym_LT] = ACTIONS(461),
    [anon_sym_GT] = ACTIONS(461),
    [anon_sym_EQ] = ACTIONS(461),
    [anon_sym_PLUS_EQ] = ACTIONS(459),
    [anon_sym_DASH_EQ] = ACTIONS(459),
    [anon_sym_STAR_EQ] = ACTIONS(459),
    [anon_sym_SLASH_EQ] = ACTIONS(459),
    [anon_sym_PERCENT_EQ] = ACTIONS(459),
    [anon_sym_AMP_EQ] = ACTIONS(459),
    [anon_sym_PIPE_EQ] = ACTIONS(459),
    [anon_sym_CARET_EQ] = ACTIONS(459),
    [anon_sym_LT_LT_EQ] = ACTIONS(459),
    [anon_sym_GT_GT_EQ] = ACTIONS(459),
    [anon_sym_DOT] = ACTIONS(459),
    [anon_sym_true] = ACTIONS(461),
    [anon_sym_false] = ACTIONS(461),
    [anon_sym_DASH] = ACTIONS(461),
    [anon_sym_BANG] = ACTIONS(461),
    [anon_sym_AMP_AMP] = ACTIONS(459),
    [anon_sym_PIPE_PIPE] = ACTIONS(459),
    [anon_sym_AMP] = ACTIONS(461),
    [anon_sym_PIPE] = ACTIONS(461),
    [anon_sym_CARET] = ACTIONS(461),
    [anon_sym_EQ_EQ] = ACTIONS(459),
    [anon_sym_BANG_EQ] = ACTIONS(459),
    [anon_sym_LT_EQ] = ACTIONS(461),
    [anon_sym_GT_EQ] = ACTIONS(459),
    [anon_sym_LT_LT] = ACTIONS(461),
    [anon_sym_GT_GT] = ACTIONS(461),
    [anon_sym_PLUS] = ACTIONS(461),
    [anon_sym_SLASH] = ACTIONS(461),
    [anon_sym_QMARK] = ACTIONS(459),
    [anon_sym_DQUOTE] = ACTIONS(459),
    [anon_sym_SQUOTE] = ACTIONS(459),
    [sym__ident_reg] = ACTIONS(461),
    [anon_sym_POUND] = ACTIONS(459),
    [sym_int_literal] = ACTIONS(461),
    [sym_float_literal] = ACTIONS(459),
    [anon_sym_ease] = ACTIONS(461),
    [anon_sym_ease_DASHin] = ACTIONS(461),
    [anon_sym_ease_in] = ACTIONS(461),
    [anon_sym_ease_in_out] = ACTIONS(461),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(461),
    [anon_sym_ease_out] = ACTIONS(461),
    [anon_sym_ease_DASHout] = ACTIONS(461),
    [anon_sym_start] = ACTIONS(461),
    [anon_sym_end] = ACTIONS(461),
    [anon_sym_black] = ACTIONS(461),
    [anon_sym_blue] = ACTIONS(461),
    [anon_sym_green] = ACTIONS(461),
    [anon_sym_red] = ACTIONS(461),
    [anon_sym_yellow] = ACTIONS(461),
    [anon_sym_white] = ACTIONS(461),
    [anon_sym_gray] = ACTIONS(461),
    [anon_sym_transparent] = ACTIONS(461),
    [anon_sym_angle] = ACTIONS(461),
    [anon_sym_bool] = ACTIONS(461),
    [anon_sym_brush] = ACTIONS(461),
    [anon_sym_color] = ACTIONS(461),
    [anon_sym_float] = ACTIONS(461),
    [anon_sym_image] = ACTIONS(461),
    [anon_sym_int] = ACTIONS(461),
    [anon_sym_length] = ACTIONS(461),
    [anon_sym_percent] = ACTIONS(461),
    [anon_sym_physical_DASHlength] = ACTIONS(461),
    [anon_sym_physical_length] = ACTIONS(461),
    [anon_sym_string] = ACTIONS(461),
    [anon_sym_debug] = ACTIONS(461),
    [anon_sym_animation_DASHtick] = ACTIONS(461),
    [anon_sym_min] = ACTIONS(461),
    [anon_sym_max] = ACTIONS(461),
    [anon_sym_mod] = ACTIONS(461),
    [anon_sym_abs] = ACTIONS(461),
    [anon_sym_round] = ACTIONS(461),
    [anon_sym_ceil] = ACTIONS(461),
    [anon_sym_floor] = ACTIONS(461),
    [anon_sym_sin] = ACTIONS(461),
    [anon_sym_cos] = ACTIONS(461),
    [anon_sym_tan] = ACTIONS(461),
    [anon_sym_asin] = ACTIONS(461),
    [anon_sym_acos] = ACTIONS(461),
    [anon_sym_atan] = ACTIONS(461),
    [anon_sym_sqrt] = ACTIONS(461),
    [anon_sym_pow] = ACTIONS(461),
    [anon_sym_log] = ACTIONS(461),
    [anon_sym_rgb] = ACTIONS(461),
    [anon_sym_easing] = ACTIONS(461),
    [anon_sym_duration] = ACTIONS(461),
    [anon_sym_parent] = ACTIONS(461),
    [anon_sym_root] = ACTIONS(461),
    [sym_comment] = ACTIONS(3),
  },
  [74] = {
    [anon_sym_LBRACE] = ACTIONS(463),
    [anon_sym_COLON] = ACTIONS(463),
    [anon_sym_COMMA] = ACTIONS(463),
    [anon_sym_RBRACE] = ACTIONS(463),
    [anon_sym_SEMI] = ACTIONS(463),
    [anon_sym_if] = ACTIONS(465),
    [anon_sym_AT] = ACTIONS(463),
    [anon_sym_LBRACK] = ACTIONS(463),
    [anon_sym_STAR] = ACTIONS(465),
    [anon_sym_LT_EQ_GT] = ACTIONS(463),
    [anon_sym_LPAREN] = ACTIONS(463),
    [anon_sym_RPAREN] = ACTIONS(463),
    [anon_sym_LT] = ACTIONS(465),
    [anon_sym_GT] = ACTIONS(465),
    [anon_sym_EQ] = ACTIONS(465),
    [anon_sym_PLUS_EQ] = ACTIONS(463),
    [anon_sym_DASH_EQ] = ACTIONS(463),
    [anon_sym_STAR_EQ] = ACTIONS(463),
    [anon_sym_SLASH_EQ] = ACTIONS(463),
    [anon_sym_PERCENT_EQ] = ACTIONS(463),
    [anon_sym_AMP_EQ] = ACTIONS(463),
    [anon_sym_PIPE_EQ] = ACTIONS(463),
    [anon_sym_CARET_EQ] = ACTIONS(463),
    [anon_sym_LT_LT_EQ] = ACTIONS(463),
    [anon_sym_GT_GT_EQ] = ACTIONS(463),
    [anon_sym_DOT] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(465),
    [anon_sym_false] = ACTIONS(465),
    [anon_sym_DASH] = ACTIONS(465),
    [anon_sym_BANG] = ACTIONS(465),
    [anon_sym_AMP_AMP] = ACTIONS(463),
    [anon_sym_PIPE_PIPE] = ACTIONS(463),
    [anon_sym_AMP] = ACTIONS(465),
    [anon_sym_PIPE] = ACTIONS(465),
    [anon_sym_CARET] = ACTIONS(465),
    [anon_sym_EQ_EQ] = ACTIONS(463),
    [anon_sym_BANG_EQ] = ACTIONS(463),
    [anon_sym_LT_EQ] = ACTIONS(465),
    [anon_sym_GT_EQ] = ACTIONS(463),
    [anon_sym_LT_LT] = ACTIONS(465),
    [anon_sym_GT_GT] = ACTIONS(465),
    [anon_sym_PLUS] = ACTIONS(465),
    [anon_sym_SLASH] = ACTIONS(465),
    [anon_sym_QMARK] = ACTIONS(463),
    [anon_sym_DQUOTE] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(463),
    [sym__ident_reg] = ACTIONS(465),
    [anon_sym_POUND] = ACTIONS(463),
    [sym_int_literal] = ACTIONS(465),
    [sym_float_literal] = ACTIONS(463),
    [anon_sym_ease] = ACTIONS(465),
    [anon_sym_ease_DASHin] = ACTIONS(465),
    [anon_sym_ease_in] = ACTIONS(465),
    [anon_sym_ease_in_out] = ACTIONS(465),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(465),
    [anon_sym_ease_out] = ACTIONS(465),
    [anon_sym_ease_DASHout] = ACTIONS(465),
    [anon_sym_start] = ACTIONS(465),
    [anon_sym_end] = ACTIONS(465),
    [anon_sym_black] = ACTIONS(465),
    [anon_sym_blue] = ACTIONS(465),
    [anon_sym_green] = ACTIONS(465),
    [anon_sym_red] = ACTIONS(465),
    [anon_sym_yellow] = ACTIONS(465),
    [anon_sym_white] = ACTIONS(465),
    [anon_sym_gray] = ACTIONS(465),
    [anon_sym_transparent] = ACTIONS(465),
    [anon_sym_angle] = ACTIONS(465),
    [anon_sym_bool] = ACTIONS(465),
    [anon_sym_brush] = ACTIONS(465),
    [anon_sym_color] = ACTIONS(465),
    [anon_sym_float] = ACTIONS(465),
    [anon_sym_image] = ACTIONS(465),
    [anon_sym_int] = ACTIONS(465),
    [anon_sym_length] = ACTIONS(465),
    [anon_sym_percent] = ACTIONS(465),
    [anon_sym_physical_DASHlength] = ACTIONS(465),
    [anon_sym_physical_length] = ACTIONS(465),
    [anon_sym_string] = ACTIONS(465),
    [anon_sym_debug] = ACTIONS(465),
    [anon_sym_animation_DASHtick] = ACTIONS(465),
    [anon_sym_min] = ACTIONS(465),
    [anon_sym_max] = ACTIONS(465),
    [anon_sym_mod] = ACTIONS(465),
    [anon_sym_abs] = ACTIONS(465),
    [anon_sym_round] = ACTIONS(465),
    [anon_sym_ceil] = ACTIONS(465),
    [anon_sym_floor] = ACTIONS(465),
    [anon_sym_sin] = ACTIONS(465),
    [anon_sym_cos] = ACTIONS(465),
    [anon_sym_tan] = ACTIONS(465),
    [anon_sym_asin] = ACTIONS(465),
    [anon_sym_acos] = ACTIONS(465),
    [anon_sym_atan] = ACTIONS(465),
    [anon_sym_sqrt] = ACTIONS(465),
    [anon_sym_pow] = ACTIONS(465),
    [anon_sym_log] = ACTIONS(465),
    [anon_sym_rgb] = ACTIONS(465),
    [anon_sym_easing] = ACTIONS(465),
    [anon_sym_duration] = ACTIONS(465),
    [anon_sym_parent] = ACTIONS(465),
    [anon_sym_root] = ACTIONS(465),
    [sym_comment] = ACTIONS(3),
  },
  [75] = {
    [anon_sym_LBRACE] = ACTIONS(467),
    [anon_sym_COLON] = ACTIONS(467),
    [anon_sym_COMMA] = ACTIONS(467),
    [anon_sym_RBRACE] = ACTIONS(467),
    [anon_sym_SEMI] = ACTIONS(467),
    [anon_sym_if] = ACTIONS(469),
    [anon_sym_AT] = ACTIONS(467),
    [anon_sym_LBRACK] = ACTIONS(467),
    [anon_sym_STAR] = ACTIONS(469),
    [anon_sym_LT_EQ_GT] = ACTIONS(467),
    [anon_sym_LPAREN] = ACTIONS(467),
    [anon_sym_RPAREN] = ACTIONS(467),
    [anon_sym_LT] = ACTIONS(469),
    [anon_sym_GT] = ACTIONS(469),
    [anon_sym_EQ] = ACTIONS(469),
    [anon_sym_PLUS_EQ] = ACTIONS(467),
    [anon_sym_DASH_EQ] = ACTIONS(467),
    [anon_sym_STAR_EQ] = ACTIONS(467),
    [anon_sym_SLASH_EQ] = ACTIONS(467),
    [anon_sym_PERCENT_EQ] = ACTIONS(467),
    [anon_sym_AMP_EQ] = ACTIONS(467),
    [anon_sym_PIPE_EQ] = ACTIONS(467),
    [anon_sym_CARET_EQ] = ACTIONS(467),
    [anon_sym_LT_LT_EQ] = ACTIONS(467),
    [anon_sym_GT_GT_EQ] = ACTIONS(467),
    [anon_sym_DOT] = ACTIONS(467),
    [anon_sym_true] = ACTIONS(469),
    [anon_sym_false] = ACTIONS(469),
    [anon_sym_DASH] = ACTIONS(469),
    [anon_sym_BANG] = ACTIONS(469),
    [anon_sym_AMP_AMP] = ACTIONS(467),
    [anon_sym_PIPE_PIPE] = ACTIONS(467),
    [anon_sym_AMP] = ACTIONS(469),
    [anon_sym_PIPE] = ACTIONS(469),
    [anon_sym_CARET] = ACTIONS(469),
    [anon_sym_EQ_EQ] = ACTIONS(467),
    [anon_sym_BANG_EQ] = ACTIONS(467),
    [anon_sym_LT_EQ] = ACTIONS(469),
    [anon_sym_GT_EQ] = ACTIONS(467),
    [anon_sym_LT_LT] = ACTIONS(469),
    [anon_sym_GT_GT] = ACTIONS(469),
    [anon_sym_PLUS] = ACTIONS(469),
    [anon_sym_SLASH] = ACTIONS(469),
    [anon_sym_QMARK] = ACTIONS(467),
    [anon_sym_DQUOTE] = ACTIONS(467),
    [anon_sym_SQUOTE] = ACTIONS(467),
    [sym__ident_reg] = ACTIONS(469),
    [anon_sym_POUND] = ACTIONS(467),
    [sym_int_literal] = ACTIONS(469),
    [sym_float_literal] = ACTIONS(467),
    [anon_sym_ease] = ACTIONS(469),
    [anon_sym_ease_DASHin] = ACTIONS(469),
    [anon_sym_ease_in] = ACTIONS(469),
    [anon_sym_ease_in_out] = ACTIONS(469),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(469),
    [anon_sym_ease_out] = ACTIONS(469),
    [anon_sym_ease_DASHout] = ACTIONS(469),
    [anon_sym_start] = ACTIONS(469),
    [anon_sym_end] = ACTIONS(469),
    [anon_sym_black] = ACTIONS(469),
    [anon_sym_blue] = ACTIONS(469),
    [anon_sym_green] = ACTIONS(469),
    [anon_sym_red] = ACTIONS(469),
    [anon_sym_yellow] = ACTIONS(469),
    [anon_sym_white] = ACTIONS(469),
    [anon_sym_gray] = ACTIONS(469),
    [anon_sym_transparent] = ACTIONS(469),
    [anon_sym_angle] = ACTIONS(469),
    [anon_sym_bool] = ACTIONS(469),
    [anon_sym_brush] = ACTIONS(469),
    [anon_sym_color] = ACTIONS(469),
    [anon_sym_float] = ACTIONS(469),
    [anon_sym_image] = ACTIONS(469),
    [anon_sym_int] = ACTIONS(469),
    [anon_sym_length] = ACTIONS(469),
    [anon_sym_percent] = ACTIONS(469),
    [anon_sym_physical_DASHlength] = ACTIONS(469),
    [anon_sym_physical_length] = ACTIONS(469),
    [anon_sym_string] = ACTIONS(469),
    [anon_sym_debug] = ACTIONS(469),
    [anon_sym_animation_DASHtick] = ACTIONS(469),
    [anon_sym_min] = ACTIONS(469),
    [anon_sym_max] = ACTIONS(469),
    [anon_sym_mod] = ACTIONS(469),
    [anon_sym_abs] = ACTIONS(469),
    [anon_sym_round] = ACTIONS(469),
    [anon_sym_ceil] = ACTIONS(469),
    [anon_sym_floor] = ACTIONS(469),
    [anon_sym_sin] = ACTIONS(469),
    [anon_sym_cos] = ACTIONS(469),
    [anon_sym_tan] = ACTIONS(469),
    [anon_sym_asin] = ACTIONS(469),
    [anon_sym_acos] = ACTIONS(469),
    [anon_sym_atan] = ACTIONS(469),
    [anon_sym_sqrt] = ACTIONS(469),
    [anon_sym_pow] = ACTIONS(469),
    [anon_sym_log] = ACTIONS(469),
    [anon_sym_rgb] = ACTIONS(469),
    [anon_sym_easing] = ACTIONS(469),
    [anon_sym_duration] = ACTIONS(469),
    [anon_sym_parent] = ACTIONS(469),
    [anon_sym_root] = ACTIONS(469),
    [sym_comment] = ACTIONS(3),
  },
  [76] = {
    [sym_function_call_args] = STATE(50),
    [anon_sym_LBRACE] = ACTIONS(471),
    [anon_sym_COLON] = ACTIONS(471),
    [anon_sym_SEMI] = ACTIONS(471),
    [anon_sym_if] = ACTIONS(473),
    [anon_sym_AT] = ACTIONS(471),
    [anon_sym_LBRACK] = ACTIONS(305),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_LT_EQ_GT] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(307),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(41),
    [anon_sym_EQ] = ACTIONS(475),
    [anon_sym_PLUS_EQ] = ACTIONS(45),
    [anon_sym_DASH_EQ] = ACTIONS(45),
    [anon_sym_STAR_EQ] = ACTIONS(45),
    [anon_sym_SLASH_EQ] = ACTIONS(45),
    [anon_sym_PERCENT_EQ] = ACTIONS(45),
    [anon_sym_AMP_EQ] = ACTIONS(45),
    [anon_sym_PIPE_EQ] = ACTIONS(45),
    [anon_sym_CARET_EQ] = ACTIONS(45),
    [anon_sym_LT_LT_EQ] = ACTIONS(45),
    [anon_sym_GT_GT_EQ] = ACTIONS(45),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(473),
    [anon_sym_false] = ACTIONS(473),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(473),
    [anon_sym_AMP_AMP] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_CARET] = ACTIONS(63),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT_EQ] = ACTIONS(41),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(37),
    [anon_sym_QMARK] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(471),
    [anon_sym_SQUOTE] = ACTIONS(471),
    [sym__ident_reg] = ACTIONS(473),
    [anon_sym_POUND] = ACTIONS(471),
    [sym_int_literal] = ACTIONS(473),
    [sym_float_literal] = ACTIONS(471),
    [anon_sym_ease] = ACTIONS(473),
    [anon_sym_ease_DASHin] = ACTIONS(473),
    [anon_sym_ease_in] = ACTIONS(473),
    [anon_sym_ease_in_out] = ACTIONS(473),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(473),
    [anon_sym_ease_out] = ACTIONS(473),
    [anon_sym_ease_DASHout] = ACTIONS(473),
    [anon_sym_start] = ACTIONS(473),
    [anon_sym_end] = ACTIONS(473),
    [anon_sym_black] = ACTIONS(473),
    [anon_sym_blue] = ACTIONS(473),
    [anon_sym_green] = ACTIONS(473),
    [anon_sym_red] = ACTIONS(473),
    [anon_sym_yellow] = ACTIONS(473),
    [anon_sym_white] = ACTIONS(473),
    [anon_sym_gray] = ACTIONS(473),
    [anon_sym_transparent] = ACTIONS(473),
    [anon_sym_angle] = ACTIONS(473),
    [anon_sym_bool] = ACTIONS(473),
    [anon_sym_brush] = ACTIONS(473),
    [anon_sym_color] = ACTIONS(473),
    [anon_sym_float] = ACTIONS(473),
    [anon_sym_image] = ACTIONS(473),
    [anon_sym_int] = ACTIONS(473),
    [anon_sym_length] = ACTIONS(473),
    [anon_sym_percent] = ACTIONS(473),
    [anon_sym_physical_DASHlength] = ACTIONS(473),
    [anon_sym_physical_length] = ACTIONS(473),
    [anon_sym_string] = ACTIONS(473),
    [anon_sym_debug] = ACTIONS(473),
    [anon_sym_animation_DASHtick] = ACTIONS(473),
    [anon_sym_min] = ACTIONS(473),
    [anon_sym_max] = ACTIONS(473),
    [anon_sym_mod] = ACTIONS(473),
    [anon_sym_abs] = ACTIONS(473),
    [anon_sym_round] = ACTIONS(473),
    [anon_sym_ceil] = ACTIONS(473),
    [anon_sym_floor] = ACTIONS(473),
    [anon_sym_sin] = ACTIONS(473),
    [anon_sym_cos] = ACTIONS(473),
    [anon_sym_tan] = ACTIONS(473),
    [anon_sym_asin] = ACTIONS(473),
    [anon_sym_acos] = ACTIONS(473),
    [anon_sym_atan] = ACTIONS(473),
    [anon_sym_sqrt] = ACTIONS(473),
    [anon_sym_pow] = ACTIONS(473),
    [anon_sym_log] = ACTIONS(473),
    [anon_sym_rgb] = ACTIONS(473),
    [anon_sym_easing] = ACTIONS(473),
    [anon_sym_duration] = ACTIONS(473),
    [anon_sym_parent] = ACTIONS(473),
    [anon_sym_root] = ACTIONS(473),
    [sym_comment] = ACTIONS(3),
  },
  [77] = {
    [sym_function_call_args] = STATE(50),
    [anon_sym_LBRACE] = ACTIONS(313),
    [anon_sym_COMMA] = ACTIONS(313),
    [anon_sym_SEMI] = ACTIONS(477),
    [anon_sym_if] = ACTIONS(315),
    [anon_sym_AT] = ACTIONS(313),
    [anon_sym_LBRACK] = ACTIONS(305),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(307),
    [anon_sym_RPAREN] = ACTIONS(313),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(41),
    [anon_sym_EQ] = ACTIONS(315),
    [anon_sym_PLUS_EQ] = ACTIONS(313),
    [anon_sym_DASH_EQ] = ACTIONS(313),
    [anon_sym_STAR_EQ] = ACTIONS(313),
    [anon_sym_SLASH_EQ] = ACTIONS(313),
    [anon_sym_PERCENT_EQ] = ACTIONS(313),
    [anon_sym_AMP_EQ] = ACTIONS(313),
    [anon_sym_PIPE_EQ] = ACTIONS(313),
    [anon_sym_CARET_EQ] = ACTIONS(313),
    [anon_sym_LT_LT_EQ] = ACTIONS(313),
    [anon_sym_GT_GT_EQ] = ACTIONS(313),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(315),
    [anon_sym_false] = ACTIONS(315),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(315),
    [anon_sym_AMP_AMP] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_CARET] = ACTIONS(63),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(37),
    [anon_sym_QMARK] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(313),
    [anon_sym_SQUOTE] = ACTIONS(313),
    [sym__ident_reg] = ACTIONS(315),
    [anon_sym_POUND] = ACTIONS(313),
    [sym_int_literal] = ACTIONS(315),
    [sym_float_literal] = ACTIONS(313),
    [anon_sym_ease] = ACTIONS(315),
    [anon_sym_ease_DASHin] = ACTIONS(315),
    [anon_sym_ease_in] = ACTIONS(315),
    [anon_sym_ease_in_out] = ACTIONS(315),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(315),
    [anon_sym_ease_out] = ACTIONS(315),
    [anon_sym_ease_DASHout] = ACTIONS(315),
    [anon_sym_start] = ACTIONS(315),
    [anon_sym_end] = ACTIONS(315),
    [anon_sym_black] = ACTIONS(315),
    [anon_sym_blue] = ACTIONS(315),
    [anon_sym_green] = ACTIONS(315),
    [anon_sym_red] = ACTIONS(315),
    [anon_sym_yellow] = ACTIONS(315),
    [anon_sym_white] = ACTIONS(315),
    [anon_sym_gray] = ACTIONS(315),
    [anon_sym_transparent] = ACTIONS(315),
    [anon_sym_angle] = ACTIONS(315),
    [anon_sym_bool] = ACTIONS(315),
    [anon_sym_brush] = ACTIONS(315),
    [anon_sym_color] = ACTIONS(315),
    [anon_sym_float] = ACTIONS(315),
    [anon_sym_image] = ACTIONS(315),
    [anon_sym_int] = ACTIONS(315),
    [anon_sym_length] = ACTIONS(315),
    [anon_sym_percent] = ACTIONS(315),
    [anon_sym_physical_DASHlength] = ACTIONS(315),
    [anon_sym_physical_length] = ACTIONS(315),
    [anon_sym_string] = ACTIONS(315),
    [anon_sym_debug] = ACTIONS(315),
    [anon_sym_animation_DASHtick] = ACTIONS(315),
    [anon_sym_min] = ACTIONS(315),
    [anon_sym_max] = ACTIONS(315),
    [anon_sym_mod] = ACTIONS(315),
    [anon_sym_abs] = ACTIONS(315),
    [anon_sym_round] = ACTIONS(315),
    [anon_sym_ceil] = ACTIONS(315),
    [anon_sym_floor] = ACTIONS(315),
    [anon_sym_sin] = ACTIONS(315),
    [anon_sym_cos] = ACTIONS(315),
    [anon_sym_tan] = ACTIONS(315),
    [anon_sym_asin] = ACTIONS(315),
    [anon_sym_acos] = ACTIONS(315),
    [anon_sym_atan] = ACTIONS(315),
    [anon_sym_sqrt] = ACTIONS(315),
    [anon_sym_pow] = ACTIONS(315),
    [anon_sym_log] = ACTIONS(315),
    [anon_sym_rgb] = ACTIONS(315),
    [anon_sym_easing] = ACTIONS(315),
    [anon_sym_duration] = ACTIONS(315),
    [anon_sym_parent] = ACTIONS(315),
    [anon_sym_root] = ACTIONS(315),
    [sym_comment] = ACTIONS(3),
  },
  [78] = {
    [sym_function_call_args] = STATE(50),
    [anon_sym_LBRACE] = ACTIONS(479),
    [anon_sym_COLON] = ACTIONS(479),
    [anon_sym_SEMI] = ACTIONS(479),
    [anon_sym_if] = ACTIONS(481),
    [anon_sym_AT] = ACTIONS(479),
    [anon_sym_LBRACK] = ACTIONS(305),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_LT_EQ_GT] = ACTIONS(479),
    [anon_sym_LPAREN] = ACTIONS(307),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(41),
    [anon_sym_EQ] = ACTIONS(475),
    [anon_sym_PLUS_EQ] = ACTIONS(45),
    [anon_sym_DASH_EQ] = ACTIONS(45),
    [anon_sym_STAR_EQ] = ACTIONS(45),
    [anon_sym_SLASH_EQ] = ACTIONS(45),
    [anon_sym_PERCENT_EQ] = ACTIONS(45),
    [anon_sym_AMP_EQ] = ACTIONS(45),
    [anon_sym_PIPE_EQ] = ACTIONS(45),
    [anon_sym_CARET_EQ] = ACTIONS(45),
    [anon_sym_LT_LT_EQ] = ACTIONS(45),
    [anon_sym_GT_GT_EQ] = ACTIONS(45),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(481),
    [anon_sym_false] = ACTIONS(481),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(481),
    [anon_sym_AMP_AMP] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_CARET] = ACTIONS(63),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT_EQ] = ACTIONS(41),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(37),
    [anon_sym_QMARK] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(479),
    [anon_sym_SQUOTE] = ACTIONS(479),
    [sym__ident_reg] = ACTIONS(481),
    [anon_sym_POUND] = ACTIONS(479),
    [sym_int_literal] = ACTIONS(481),
    [sym_float_literal] = ACTIONS(479),
    [anon_sym_ease] = ACTIONS(481),
    [anon_sym_ease_DASHin] = ACTIONS(481),
    [anon_sym_ease_in] = ACTIONS(481),
    [anon_sym_ease_in_out] = ACTIONS(481),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(481),
    [anon_sym_ease_out] = ACTIONS(481),
    [anon_sym_ease_DASHout] = ACTIONS(481),
    [anon_sym_start] = ACTIONS(481),
    [anon_sym_end] = ACTIONS(481),
    [anon_sym_black] = ACTIONS(481),
    [anon_sym_blue] = ACTIONS(481),
    [anon_sym_green] = ACTIONS(481),
    [anon_sym_red] = ACTIONS(481),
    [anon_sym_yellow] = ACTIONS(481),
    [anon_sym_white] = ACTIONS(481),
    [anon_sym_gray] = ACTIONS(481),
    [anon_sym_transparent] = ACTIONS(481),
    [anon_sym_angle] = ACTIONS(481),
    [anon_sym_bool] = ACTIONS(481),
    [anon_sym_brush] = ACTIONS(481),
    [anon_sym_color] = ACTIONS(481),
    [anon_sym_float] = ACTIONS(481),
    [anon_sym_image] = ACTIONS(481),
    [anon_sym_int] = ACTIONS(481),
    [anon_sym_length] = ACTIONS(481),
    [anon_sym_percent] = ACTIONS(481),
    [anon_sym_physical_DASHlength] = ACTIONS(481),
    [anon_sym_physical_length] = ACTIONS(481),
    [anon_sym_string] = ACTIONS(481),
    [anon_sym_debug] = ACTIONS(481),
    [anon_sym_animation_DASHtick] = ACTIONS(481),
    [anon_sym_min] = ACTIONS(481),
    [anon_sym_max] = ACTIONS(481),
    [anon_sym_mod] = ACTIONS(481),
    [anon_sym_abs] = ACTIONS(481),
    [anon_sym_round] = ACTIONS(481),
    [anon_sym_ceil] = ACTIONS(481),
    [anon_sym_floor] = ACTIONS(481),
    [anon_sym_sin] = ACTIONS(481),
    [anon_sym_cos] = ACTIONS(481),
    [anon_sym_tan] = ACTIONS(481),
    [anon_sym_asin] = ACTIONS(481),
    [anon_sym_acos] = ACTIONS(481),
    [anon_sym_atan] = ACTIONS(481),
    [anon_sym_sqrt] = ACTIONS(481),
    [anon_sym_pow] = ACTIONS(481),
    [anon_sym_log] = ACTIONS(481),
    [anon_sym_rgb] = ACTIONS(481),
    [anon_sym_easing] = ACTIONS(481),
    [anon_sym_duration] = ACTIONS(481),
    [anon_sym_parent] = ACTIONS(481),
    [anon_sym_root] = ACTIONS(481),
    [sym_comment] = ACTIONS(3),
  },
  [79] = {
    [sym_function_call_args] = STATE(50),
    [anon_sym_LBRACE] = ACTIONS(483),
    [anon_sym_COLON] = ACTIONS(483),
    [anon_sym_SEMI] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_AT] = ACTIONS(483),
    [anon_sym_LBRACK] = ACTIONS(305),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_LT_EQ_GT] = ACTIONS(483),
    [anon_sym_LPAREN] = ACTIONS(307),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(41),
    [anon_sym_EQ] = ACTIONS(475),
    [anon_sym_PLUS_EQ] = ACTIONS(45),
    [anon_sym_DASH_EQ] = ACTIONS(45),
    [anon_sym_STAR_EQ] = ACTIONS(45),
    [anon_sym_SLASH_EQ] = ACTIONS(45),
    [anon_sym_PERCENT_EQ] = ACTIONS(45),
    [anon_sym_AMP_EQ] = ACTIONS(45),
    [anon_sym_PIPE_EQ] = ACTIONS(45),
    [anon_sym_CARET_EQ] = ACTIONS(45),
    [anon_sym_LT_LT_EQ] = ACTIONS(45),
    [anon_sym_GT_GT_EQ] = ACTIONS(45),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(485),
    [anon_sym_false] = ACTIONS(485),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(485),
    [anon_sym_AMP_AMP] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_CARET] = ACTIONS(63),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT_EQ] = ACTIONS(41),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(37),
    [anon_sym_QMARK] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(483),
    [anon_sym_SQUOTE] = ACTIONS(483),
    [sym__ident_reg] = ACTIONS(485),
    [anon_sym_POUND] = ACTIONS(483),
    [sym_int_literal] = ACTIONS(485),
    [sym_float_literal] = ACTIONS(483),
    [anon_sym_ease] = ACTIONS(485),
    [anon_sym_ease_DASHin] = ACTIONS(485),
    [anon_sym_ease_in] = ACTIONS(485),
    [anon_sym_ease_in_out] = ACTIONS(485),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(485),
    [anon_sym_ease_out] = ACTIONS(485),
    [anon_sym_ease_DASHout] = ACTIONS(485),
    [anon_sym_start] = ACTIONS(485),
    [anon_sym_end] = ACTIONS(485),
    [anon_sym_black] = ACTIONS(485),
    [anon_sym_blue] = ACTIONS(485),
    [anon_sym_green] = ACTIONS(485),
    [anon_sym_red] = ACTIONS(485),
    [anon_sym_yellow] = ACTIONS(485),
    [anon_sym_white] = ACTIONS(485),
    [anon_sym_gray] = ACTIONS(485),
    [anon_sym_transparent] = ACTIONS(485),
    [anon_sym_angle] = ACTIONS(485),
    [anon_sym_bool] = ACTIONS(485),
    [anon_sym_brush] = ACTIONS(485),
    [anon_sym_color] = ACTIONS(485),
    [anon_sym_float] = ACTIONS(485),
    [anon_sym_image] = ACTIONS(485),
    [anon_sym_int] = ACTIONS(485),
    [anon_sym_length] = ACTIONS(485),
    [anon_sym_percent] = ACTIONS(485),
    [anon_sym_physical_DASHlength] = ACTIONS(485),
    [anon_sym_physical_length] = ACTIONS(485),
    [anon_sym_string] = ACTIONS(485),
    [anon_sym_debug] = ACTIONS(485),
    [anon_sym_animation_DASHtick] = ACTIONS(485),
    [anon_sym_min] = ACTIONS(485),
    [anon_sym_max] = ACTIONS(485),
    [anon_sym_mod] = ACTIONS(485),
    [anon_sym_abs] = ACTIONS(485),
    [anon_sym_round] = ACTIONS(485),
    [anon_sym_ceil] = ACTIONS(485),
    [anon_sym_floor] = ACTIONS(485),
    [anon_sym_sin] = ACTIONS(485),
    [anon_sym_cos] = ACTIONS(485),
    [anon_sym_tan] = ACTIONS(485),
    [anon_sym_asin] = ACTIONS(485),
    [anon_sym_acos] = ACTIONS(485),
    [anon_sym_atan] = ACTIONS(485),
    [anon_sym_sqrt] = ACTIONS(485),
    [anon_sym_pow] = ACTIONS(485),
    [anon_sym_log] = ACTIONS(485),
    [anon_sym_rgb] = ACTIONS(485),
    [anon_sym_easing] = ACTIONS(485),
    [anon_sym_duration] = ACTIONS(485),
    [anon_sym_parent] = ACTIONS(485),
    [anon_sym_root] = ACTIONS(485),
    [sym_comment] = ACTIONS(3),
  },
  [80] = {
    [sym_function_call_args] = STATE(50),
    [anon_sym_LBRACE] = ACTIONS(487),
    [anon_sym_COLON] = ACTIONS(487),
    [anon_sym_SEMI] = ACTIONS(487),
    [anon_sym_if] = ACTIONS(489),
    [anon_sym_AT] = ACTIONS(487),
    [anon_sym_LBRACK] = ACTIONS(305),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_LT_EQ_GT] = ACTIONS(487),
    [anon_sym_LPAREN] = ACTIONS(307),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(41),
    [anon_sym_EQ] = ACTIONS(475),
    [anon_sym_PLUS_EQ] = ACTIONS(45),
    [anon_sym_DASH_EQ] = ACTIONS(45),
    [anon_sym_STAR_EQ] = ACTIONS(45),
    [anon_sym_SLASH_EQ] = ACTIONS(45),
    [anon_sym_PERCENT_EQ] = ACTIONS(45),
    [anon_sym_AMP_EQ] = ACTIONS(45),
    [anon_sym_PIPE_EQ] = ACTIONS(45),
    [anon_sym_CARET_EQ] = ACTIONS(45),
    [anon_sym_LT_LT_EQ] = ACTIONS(45),
    [anon_sym_GT_GT_EQ] = ACTIONS(45),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(489),
    [anon_sym_false] = ACTIONS(489),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(489),
    [anon_sym_AMP_AMP] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_CARET] = ACTIONS(63),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT_EQ] = ACTIONS(41),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(37),
    [anon_sym_QMARK] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(487),
    [anon_sym_SQUOTE] = ACTIONS(487),
    [sym__ident_reg] = ACTIONS(489),
    [anon_sym_POUND] = ACTIONS(487),
    [sym_int_literal] = ACTIONS(489),
    [sym_float_literal] = ACTIONS(487),
    [anon_sym_ease] = ACTIONS(489),
    [anon_sym_ease_DASHin] = ACTIONS(489),
    [anon_sym_ease_in] = ACTIONS(489),
    [anon_sym_ease_in_out] = ACTIONS(489),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(489),
    [anon_sym_ease_out] = ACTIONS(489),
    [anon_sym_ease_DASHout] = ACTIONS(489),
    [anon_sym_start] = ACTIONS(489),
    [anon_sym_end] = ACTIONS(489),
    [anon_sym_black] = ACTIONS(489),
    [anon_sym_blue] = ACTIONS(489),
    [anon_sym_green] = ACTIONS(489),
    [anon_sym_red] = ACTIONS(489),
    [anon_sym_yellow] = ACTIONS(489),
    [anon_sym_white] = ACTIONS(489),
    [anon_sym_gray] = ACTIONS(489),
    [anon_sym_transparent] = ACTIONS(489),
    [anon_sym_angle] = ACTIONS(489),
    [anon_sym_bool] = ACTIONS(489),
    [anon_sym_brush] = ACTIONS(489),
    [anon_sym_color] = ACTIONS(489),
    [anon_sym_float] = ACTIONS(489),
    [anon_sym_image] = ACTIONS(489),
    [anon_sym_int] = ACTIONS(489),
    [anon_sym_length] = ACTIONS(489),
    [anon_sym_percent] = ACTIONS(489),
    [anon_sym_physical_DASHlength] = ACTIONS(489),
    [anon_sym_physical_length] = ACTIONS(489),
    [anon_sym_string] = ACTIONS(489),
    [anon_sym_debug] = ACTIONS(489),
    [anon_sym_animation_DASHtick] = ACTIONS(489),
    [anon_sym_min] = ACTIONS(489),
    [anon_sym_max] = ACTIONS(489),
    [anon_sym_mod] = ACTIONS(489),
    [anon_sym_abs] = ACTIONS(489),
    [anon_sym_round] = ACTIONS(489),
    [anon_sym_ceil] = ACTIONS(489),
    [anon_sym_floor] = ACTIONS(489),
    [anon_sym_sin] = ACTIONS(489),
    [anon_sym_cos] = ACTIONS(489),
    [anon_sym_tan] = ACTIONS(489),
    [anon_sym_asin] = ACTIONS(489),
    [anon_sym_acos] = ACTIONS(489),
    [anon_sym_atan] = ACTIONS(489),
    [anon_sym_sqrt] = ACTIONS(489),
    [anon_sym_pow] = ACTIONS(489),
    [anon_sym_log] = ACTIONS(489),
    [anon_sym_rgb] = ACTIONS(489),
    [anon_sym_easing] = ACTIONS(489),
    [anon_sym_duration] = ACTIONS(489),
    [anon_sym_parent] = ACTIONS(489),
    [anon_sym_root] = ACTIONS(489),
    [sym_comment] = ACTIONS(3),
  },
  [81] = {
    [sym_function_call_args] = STATE(50),
    [anon_sym_LBRACE] = ACTIONS(491),
    [anon_sym_RBRACE] = ACTIONS(491),
    [anon_sym_SEMI] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(495),
    [anon_sym_AT] = ACTIONS(491),
    [anon_sym_LBRACK] = ACTIONS(305),
    [anon_sym_STAR] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(307),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(41),
    [anon_sym_EQ] = ACTIONS(475),
    [anon_sym_PLUS_EQ] = ACTIONS(45),
    [anon_sym_DASH_EQ] = ACTIONS(45),
    [anon_sym_STAR_EQ] = ACTIONS(45),
    [anon_sym_SLASH_EQ] = ACTIONS(45),
    [anon_sym_PERCENT_EQ] = ACTIONS(45),
    [anon_sym_AMP_EQ] = ACTIONS(45),
    [anon_sym_PIPE_EQ] = ACTIONS(45),
    [anon_sym_CARET_EQ] = ACTIONS(45),
    [anon_sym_LT_LT_EQ] = ACTIONS(45),
    [anon_sym_GT_GT_EQ] = ACTIONS(45),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(495),
    [anon_sym_false] = ACTIONS(495),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_AMP_AMP] = ACTIONS(55),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_PIPE] = ACTIONS(61),
    [anon_sym_CARET] = ACTIONS(63),
    [anon_sym_EQ_EQ] = ACTIONS(65),
    [anon_sym_BANG_EQ] = ACTIONS(65),
    [anon_sym_LT_EQ] = ACTIONS(65),
    [anon_sym_GT_EQ] = ACTIONS(65),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(37),
    [anon_sym_QMARK] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [sym__ident_reg] = ACTIONS(495),
    [anon_sym_POUND] = ACTIONS(491),
    [sym_int_literal] = ACTIONS(495),
    [sym_float_literal] = ACTIONS(491),
    [anon_sym_ease] = ACTIONS(495),
    [anon_sym_ease_DASHin] = ACTIONS(495),
    [anon_sym_ease_in] = ACTIONS(495),
    [anon_sym_ease_in_out] = ACTIONS(495),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(495),
    [anon_sym_ease_out] = ACTIONS(495),
    [anon_sym_ease_DASHout] = ACTIONS(495),
    [anon_sym_start] = ACTIONS(495),
    [anon_sym_end] = ACTIONS(495),
    [anon_sym_black] = ACTIONS(495),
    [anon_sym_blue] = ACTIONS(495),
    [anon_sym_green] = ACTIONS(495),
    [anon_sym_red] = ACTIONS(495),
    [anon_sym_yellow] = ACTIONS(495),
    [anon_sym_white] = ACTIONS(495),
    [anon_sym_gray] = ACTIONS(495),
    [anon_sym_transparent] = ACTIONS(495),
    [anon_sym_angle] = ACTIONS(495),
    [anon_sym_bool] = ACTIONS(495),
    [anon_sym_brush] = ACTIONS(495),
    [anon_sym_color] = ACTIONS(495),
    [anon_sym_float] = ACTIONS(495),
    [anon_sym_image] = ACTIONS(495),
    [anon_sym_int] = ACTIONS(495),
    [anon_sym_length] = ACTIONS(495),
    [anon_sym_percent] = ACTIONS(495),
    [anon_sym_physical_DASHlength] = ACTIONS(495),
    [anon_sym_physical_length] = ACTIONS(495),
    [anon_sym_string] = ACTIONS(495),
    [anon_sym_debug] = ACTIONS(495),
    [anon_sym_animation_DASHtick] = ACTIONS(495),
    [anon_sym_min] = ACTIONS(495),
    [anon_sym_max] = ACTIONS(495),
    [anon_sym_mod] = ACTIONS(495),
    [anon_sym_abs] = ACTIONS(495),
    [anon_sym_round] = ACTIONS(495),
    [anon_sym_ceil] = ACTIONS(495),
    [anon_sym_floor] = ACTIONS(495),
    [anon_sym_sin] = ACTIONS(495),
    [anon_sym_cos] = ACTIONS(495),
    [anon_sym_tan] = ACTIONS(495),
    [anon_sym_asin] = ACTIONS(495),
    [anon_sym_acos] = ACTIONS(495),
    [anon_sym_atan] = ACTIONS(495),
    [anon_sym_sqrt] = ACTIONS(495),
    [anon_sym_pow] = ACTIONS(495),
    [anon_sym_log] = ACTIONS(495),
    [anon_sym_rgb] = ACTIONS(495),
    [anon_sym_easing] = ACTIONS(495),
    [anon_sym_duration] = ACTIONS(495),
    [anon_sym_parent] = ACTIONS(495),
    [anon_sym_root] = ACTIONS(495),
    [sym_comment] = ACTIONS(3),
  },
  [82] = {
    [sym_function_call_args] = STATE(50),
    [anon_sym_LBRACE] = ACTIONS(301),
    [anon_sym_COMMA] = ACTIONS(329),
    [anon_sym_if] = ACTIONS(303),
    [anon_sym_AT] = ACTIONS(301),
    [anon_sym_LBRACK] = ACTIONS(305),
    [anon_sym_STAR] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(307),
    [anon_sym_RPAREN] = ACTIONS(329),
    [anon_sym_LT] = ACTIONS(331),
    [anon_sym_GT] = ACTIONS(331),
    [anon_sym_EQ] = ACTIONS(331),
    [anon_sym_PLUS_EQ] = ACTIONS(329),
    [anon_sym_DASH_EQ] = ACTIONS(329),
    [anon_sym_STAR_EQ] = ACTIONS(329),
    [anon_sym_SLASH_EQ] = ACTIONS(329),
    [anon_sym_PERCENT_EQ] = ACTIONS(329),
    [anon_sym_AMP_EQ] = ACTIONS(329),
    [anon_sym_PIPE_EQ] = ACTIONS(329),
    [anon_sym_CARET_EQ] = ACTIONS(329),
    [anon_sym_LT_LT_EQ] = ACTIONS(329),
    [anon_sym_GT_GT_EQ] = ACTIONS(329),
    [anon_sym_DOT] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(303),
    [anon_sym_false] = ACTIONS(303),
    [anon_sym_DASH] = ACTIONS(331),
    [anon_sym_BANG] = ACTIONS(303),
    [anon_sym_AMP_AMP] = ACTIONS(329),
    [anon_sym_PIPE_PIPE] = ACTIONS(329),
    [anon_sym_AMP] = ACTIONS(331),
    [anon_sym_PIPE] = ACTIONS(331),
    [anon_sym_CARET] = ACTIONS(331),
    [anon_sym_EQ_EQ] = ACTIONS(329),
    [anon_sym_BANG_EQ] = ACTIONS(329),
    [anon_sym_LT_EQ] = ACTIONS(329),
    [anon_sym_GT_EQ] = ACTIONS(329),
    [anon_sym_LT_LT] = ACTIONS(331),
    [anon_sym_GT_GT] = ACTIONS(331),
    [anon_sym_PLUS] = ACTIONS(331),
    [anon_sym_SLASH] = ACTIONS(331),
    [anon_sym_QMARK] = ACTIONS(329),
    [anon_sym_DQUOTE] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(301),
    [sym__ident_reg] = ACTIONS(303),
    [anon_sym_POUND] = ACTIONS(301),
    [sym_int_literal] = ACTIONS(303),
    [sym_float_literal] = ACTIONS(301),
    [anon_sym_ease] = ACTIONS(303),
    [anon_sym_ease_DASHin] = ACTIONS(303),
    [anon_sym_ease_in] = ACTIONS(303),
    [anon_sym_ease_in_out] = ACTIONS(303),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(303),
    [anon_sym_ease_out] = ACTIONS(303),
    [anon_sym_ease_DASHout] = ACTIONS(303),
    [anon_sym_start] = ACTIONS(303),
    [anon_sym_end] = ACTIONS(303),
    [anon_sym_black] = ACTIONS(303),
    [anon_sym_blue] = ACTIONS(303),
    [anon_sym_green] = ACTIONS(303),
    [anon_sym_red] = ACTIONS(303),
    [anon_sym_yellow] = ACTIONS(303),
    [anon_sym_white] = ACTIONS(303),
    [anon_sym_gray] = ACTIONS(303),
    [anon_sym_transparent] = ACTIONS(303),
    [anon_sym_angle] = ACTIONS(303),
    [anon_sym_bool] = ACTIONS(303),
    [anon_sym_brush] = ACTIONS(303),
    [anon_sym_color] = ACTIONS(303),
    [anon_sym_float] = ACTIONS(303),
    [anon_sym_image] = ACTIONS(303),
    [anon_sym_int] = ACTIONS(303),
    [anon_sym_length] = ACTIONS(303),
    [anon_sym_percent] = ACTIONS(303),
    [anon_sym_physical_DASHlength] = ACTIONS(303),
    [anon_sym_physical_length] = ACTIONS(303),
    [anon_sym_string] = ACTIONS(303),
    [anon_sym_debug] = ACTIONS(303),
    [anon_sym_animation_DASHtick] = ACTIONS(303),
    [anon_sym_min] = ACTIONS(303),
    [anon_sym_max] = ACTIONS(303),
    [anon_sym_mod] = ACTIONS(303),
    [anon_sym_abs] = ACTIONS(303),
    [anon_sym_round] = ACTIONS(303),
    [anon_sym_ceil] = ACTIONS(303),
    [anon_sym_floor] = ACTIONS(303),
    [anon_sym_sin] = ACTIONS(303),
    [anon_sym_cos] = ACTIONS(303),
    [anon_sym_tan] = ACTIONS(303),
    [anon_sym_asin] = ACTIONS(303),
    [anon_sym_acos] = ACTIONS(303),
    [anon_sym_atan] = ACTIONS(303),
    [anon_sym_sqrt] = ACTIONS(303),
    [anon_sym_pow] = ACTIONS(303),
    [anon_sym_log] = ACTIONS(303),
    [anon_sym_rgb] = ACTIONS(303),
    [anon_sym_easing] = ACTIONS(303),
    [anon_sym_duration] = ACTIONS(303),
    [anon_sym_parent] = ACTIONS(303),
    [anon_sym_root] = ACTIONS(303),
    [sym_comment] = ACTIONS(3),
  },
  [83] = {
    [ts_builtin_sym_end] = ACTIONS(435),
    [anon_sym_export] = ACTIONS(437),
    [anon_sym_struct] = ACTIONS(437),
    [anon_sym_LBRACE] = ACTIONS(435),
    [anon_sym_COLON] = ACTIONS(435),
    [anon_sym_COMMA] = ACTIONS(435),
    [anon_sym_RBRACE] = ACTIONS(435),
    [anon_sym_global] = ACTIONS(437),
    [anon_sym_import] = ACTIONS(437),
    [anon_sym_SEMI] = ACTIONS(435),
    [anon_sym_component] = ACTIONS(437),
    [anon_sym_if] = ACTIONS(437),
    [anon_sym_LBRACK] = ACTIONS(435),
    [anon_sym_RBRACK] = ACTIONS(435),
    [anon_sym_STAR] = ACTIONS(437),
    [anon_sym_LPAREN] = ACTIONS(435),
    [anon_sym_RPAREN] = ACTIONS(435),
    [anon_sym_LT] = ACTIONS(437),
    [anon_sym_GT] = ACTIONS(437),
    [anon_sym_EQ] = ACTIONS(437),
    [anon_sym_PLUS_EQ] = ACTIONS(435),
    [anon_sym_DASH_EQ] = ACTIONS(435),
    [anon_sym_STAR_EQ] = ACTIONS(435),
    [anon_sym_SLASH_EQ] = ACTIONS(435),
    [anon_sym_PERCENT_EQ] = ACTIONS(435),
    [anon_sym_AMP_EQ] = ACTIONS(435),
    [anon_sym_PIPE_EQ] = ACTIONS(435),
    [anon_sym_CARET_EQ] = ACTIONS(435),
    [anon_sym_LT_LT_EQ] = ACTIONS(435),
    [anon_sym_GT_GT_EQ] = ACTIONS(435),
    [anon_sym_DOT] = ACTIONS(435),
    [anon_sym_DASH] = ACTIONS(437),
    [anon_sym_AMP_AMP] = ACTIONS(435),
    [anon_sym_PIPE_PIPE] = ACTIONS(435),
    [anon_sym_AMP] = ACTIONS(437),
    [anon_sym_PIPE] = ACTIONS(437),
    [anon_sym_CARET] = ACTIONS(437),
    [anon_sym_EQ_EQ] = ACTIONS(435),
    [anon_sym_BANG_EQ] = ACTIONS(435),
    [anon_sym_LT_EQ] = ACTIONS(435),
    [anon_sym_GT_EQ] = ACTIONS(435),
    [anon_sym_LT_LT] = ACTIONS(437),
    [anon_sym_GT_GT] = ACTIONS(437),
    [anon_sym_PLUS] = ACTIONS(437),
    [anon_sym_SLASH] = ACTIONS(437),
    [anon_sym_QMARK] = ACTIONS(435),
    [sym__ident_reg] = ACTIONS(437),
    [anon_sym_ease] = ACTIONS(437),
    [anon_sym_ease_DASHin] = ACTIONS(437),
    [anon_sym_ease_in] = ACTIONS(437),
    [anon_sym_ease_in_out] = ACTIONS(437),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(437),
    [anon_sym_ease_out] = ACTIONS(437),
    [anon_sym_ease_DASHout] = ACTIONS(437),
    [anon_sym_start] = ACTIONS(437),
    [anon_sym_end] = ACTIONS(437),
    [anon_sym_black] = ACTIONS(437),
    [anon_sym_blue] = ACTIONS(437),
    [anon_sym_green] = ACTIONS(437),
    [anon_sym_red] = ACTIONS(437),
    [anon_sym_yellow] = ACTIONS(437),
    [anon_sym_white] = ACTIONS(437),
    [anon_sym_gray] = ACTIONS(437),
    [anon_sym_transparent] = ACTIONS(437),
    [anon_sym_angle] = ACTIONS(437),
    [anon_sym_bool] = ACTIONS(437),
    [anon_sym_brush] = ACTIONS(437),
    [anon_sym_color] = ACTIONS(437),
    [anon_sym_float] = ACTIONS(437),
    [anon_sym_image] = ACTIONS(437),
    [anon_sym_int] = ACTIONS(437),
    [anon_sym_length] = ACTIONS(437),
    [anon_sym_percent] = ACTIONS(437),
    [anon_sym_physical_DASHlength] = ACTIONS(437),
    [anon_sym_physical_length] = ACTIONS(437),
    [anon_sym_string] = ACTIONS(437),
    [anon_sym_debug] = ACTIONS(437),
    [anon_sym_animation_DASHtick] = ACTIONS(437),
    [anon_sym_min] = ACTIONS(437),
    [anon_sym_max] = ACTIONS(437),
    [anon_sym_mod] = ACTIONS(437),
    [anon_sym_abs] = ACTIONS(437),
    [anon_sym_round] = ACTIONS(437),
    [anon_sym_ceil] = ACTIONS(437),
    [anon_sym_floor] = ACTIONS(437),
    [anon_sym_sin] = ACTIONS(437),
    [anon_sym_cos] = ACTIONS(437),
    [anon_sym_tan] = ACTIONS(437),
    [anon_sym_asin] = ACTIONS(437),
    [anon_sym_acos] = ACTIONS(437),
    [anon_sym_atan] = ACTIONS(437),
    [anon_sym_sqrt] = ACTIONS(437),
    [anon_sym_pow] = ACTIONS(437),
    [anon_sym_log] = ACTIONS(437),
    [anon_sym_rgb] = ACTIONS(437),
    [anon_sym_easing] = ACTIONS(437),
    [anon_sym_duration] = ACTIONS(437),
    [anon_sym_parent] = ACTIONS(437),
    [anon_sym_root] = ACTIONS(437),
    [sym_comment] = ACTIONS(3),
  },
  [84] = {
    [ts_builtin_sym_end] = ACTIONS(208),
    [anon_sym_export] = ACTIONS(210),
    [anon_sym_struct] = ACTIONS(210),
    [anon_sym_LBRACE] = ACTIONS(208),
    [anon_sym_COLON] = ACTIONS(208),
    [anon_sym_COMMA] = ACTIONS(208),
    [anon_sym_RBRACE] = ACTIONS(208),
    [anon_sym_global] = ACTIONS(210),
    [anon_sym_import] = ACTIONS(210),
    [anon_sym_SEMI] = ACTIONS(208),
    [anon_sym_component] = ACTIONS(210),
    [anon_sym_if] = ACTIONS(210),
    [anon_sym_LBRACK] = ACTIONS(208),
    [anon_sym_RBRACK] = ACTIONS(208),
    [anon_sym_STAR] = ACTIONS(210),
    [anon_sym_LPAREN] = ACTIONS(208),
    [anon_sym_RPAREN] = ACTIONS(208),
    [anon_sym_LT] = ACTIONS(210),
    [anon_sym_GT] = ACTIONS(210),
    [anon_sym_EQ] = ACTIONS(210),
    [anon_sym_PLUS_EQ] = ACTIONS(208),
    [anon_sym_DASH_EQ] = ACTIONS(208),
    [anon_sym_STAR_EQ] = ACTIONS(208),
    [anon_sym_SLASH_EQ] = ACTIONS(208),
    [anon_sym_PERCENT_EQ] = ACTIONS(208),
    [anon_sym_AMP_EQ] = ACTIONS(208),
    [anon_sym_PIPE_EQ] = ACTIONS(208),
    [anon_sym_CARET_EQ] = ACTIONS(208),
    [anon_sym_LT_LT_EQ] = ACTIONS(208),
    [anon_sym_GT_GT_EQ] = ACTIONS(208),
    [anon_sym_DOT] = ACTIONS(208),
    [anon_sym_DASH] = ACTIONS(210),
    [anon_sym_AMP_AMP] = ACTIONS(208),
    [anon_sym_PIPE_PIPE] = ACTIONS(208),
    [anon_sym_AMP] = ACTIONS(210),
    [anon_sym_PIPE] = ACTIONS(210),
    [anon_sym_CARET] = ACTIONS(210),
    [anon_sym_EQ_EQ] = ACTIONS(208),
    [anon_sym_BANG_EQ] = ACTIONS(208),
    [anon_sym_LT_EQ] = ACTIONS(208),
    [anon_sym_GT_EQ] = ACTIONS(208),
    [anon_sym_LT_LT] = ACTIONS(210),
    [anon_sym_GT_GT] = ACTIONS(210),
    [anon_sym_PLUS] = ACTIONS(210),
    [anon_sym_SLASH] = ACTIONS(210),
    [anon_sym_QMARK] = ACTIONS(208),
    [sym__ident_reg] = ACTIONS(210),
    [anon_sym_ease] = ACTIONS(210),
    [anon_sym_ease_DASHin] = ACTIONS(210),
    [anon_sym_ease_in] = ACTIONS(210),
    [anon_sym_ease_in_out] = ACTIONS(210),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(210),
    [anon_sym_ease_out] = ACTIONS(210),
    [anon_sym_ease_DASHout] = ACTIONS(210),
    [anon_sym_start] = ACTIONS(210),
    [anon_sym_end] = ACTIONS(210),
    [anon_sym_black] = ACTIONS(210),
    [anon_sym_blue] = ACTIONS(210),
    [anon_sym_green] = ACTIONS(210),
    [anon_sym_red] = ACTIONS(210),
    [anon_sym_yellow] = ACTIONS(210),
    [anon_sym_white] = ACTIONS(210),
    [anon_sym_gray] = ACTIONS(210),
    [anon_sym_transparent] = ACTIONS(210),
    [anon_sym_angle] = ACTIONS(210),
    [anon_sym_bool] = ACTIONS(210),
    [anon_sym_brush] = ACTIONS(210),
    [anon_sym_color] = ACTIONS(210),
    [anon_sym_float] = ACTIONS(210),
    [anon_sym_image] = ACTIONS(210),
    [anon_sym_int] = ACTIONS(210),
    [anon_sym_length] = ACTIONS(210),
    [anon_sym_percent] = ACTIONS(210),
    [anon_sym_physical_DASHlength] = ACTIONS(210),
    [anon_sym_physical_length] = ACTIONS(210),
    [anon_sym_string] = ACTIONS(210),
    [anon_sym_debug] = ACTIONS(210),
    [anon_sym_animation_DASHtick] = ACTIONS(210),
    [anon_sym_min] = ACTIONS(210),
    [anon_sym_max] = ACTIONS(210),
    [anon_sym_mod] = ACTIONS(210),
    [anon_sym_abs] = ACTIONS(210),
    [anon_sym_round] = ACTIONS(210),
    [anon_sym_ceil] = ACTIONS(210),
    [anon_sym_floor] = ACTIONS(210),
    [anon_sym_sin] = ACTIONS(210),
    [anon_sym_cos] = ACTIONS(210),
    [anon_sym_tan] = ACTIONS(210),
    [anon_sym_asin] = ACTIONS(210),
    [anon_sym_acos] = ACTIONS(210),
    [anon_sym_atan] = ACTIONS(210),
    [anon_sym_sqrt] = ACTIONS(210),
    [anon_sym_pow] = ACTIONS(210),
    [anon_sym_log] = ACTIONS(210),
    [anon_sym_rgb] = ACTIONS(210),
    [anon_sym_easing] = ACTIONS(210),
    [anon_sym_duration] = ACTIONS(210),
    [anon_sym_parent] = ACTIONS(210),
    [anon_sym_root] = ACTIONS(210),
    [sym_comment] = ACTIONS(3),
  },
  [85] = {
    [ts_builtin_sym_end] = ACTIONS(439),
    [anon_sym_export] = ACTIONS(441),
    [anon_sym_struct] = ACTIONS(441),
    [anon_sym_LBRACE] = ACTIONS(439),
    [anon_sym_COLON] = ACTIONS(439),
    [anon_sym_COMMA] = ACTIONS(439),
    [anon_sym_RBRACE] = ACTIONS(439),
    [anon_sym_global] = ACTIONS(441),
    [anon_sym_import] = ACTIONS(441),
    [anon_sym_SEMI] = ACTIONS(439),
    [anon_sym_component] = ACTIONS(441),
    [anon_sym_if] = ACTIONS(441),
    [anon_sym_LBRACK] = ACTIONS(439),
    [anon_sym_RBRACK] = ACTIONS(439),
    [anon_sym_STAR] = ACTIONS(441),
    [anon_sym_LPAREN] = ACTIONS(439),
    [anon_sym_RPAREN] = ACTIONS(439),
    [anon_sym_LT] = ACTIONS(441),
    [anon_sym_GT] = ACTIONS(441),
    [anon_sym_EQ] = ACTIONS(441),
    [anon_sym_PLUS_EQ] = ACTIONS(439),
    [anon_sym_DASH_EQ] = ACTIONS(439),
    [anon_sym_STAR_EQ] = ACTIONS(439),
    [anon_sym_SLASH_EQ] = ACTIONS(439),
    [anon_sym_PERCENT_EQ] = ACTIONS(439),
    [anon_sym_AMP_EQ] = ACTIONS(439),
    [anon_sym_PIPE_EQ] = ACTIONS(439),
    [anon_sym_CARET_EQ] = ACTIONS(439),
    [anon_sym_LT_LT_EQ] = ACTIONS(439),
    [anon_sym_GT_GT_EQ] = ACTIONS(439),
    [anon_sym_DOT] = ACTIONS(439),
    [anon_sym_DASH] = ACTIONS(441),
    [anon_sym_AMP_AMP] = ACTIONS(439),
    [anon_sym_PIPE_PIPE] = ACTIONS(439),
    [anon_sym_AMP] = ACTIONS(441),
    [anon_sym_PIPE] = ACTIONS(441),
    [anon_sym_CARET] = ACTIONS(441),
    [anon_sym_EQ_EQ] = ACTIONS(439),
    [anon_sym_BANG_EQ] = ACTIONS(439),
    [anon_sym_LT_EQ] = ACTIONS(439),
    [anon_sym_GT_EQ] = ACTIONS(439),
    [anon_sym_LT_LT] = ACTIONS(441),
    [anon_sym_GT_GT] = ACTIONS(441),
    [anon_sym_PLUS] = ACTIONS(441),
    [anon_sym_SLASH] = ACTIONS(441),
    [anon_sym_QMARK] = ACTIONS(439),
    [sym__ident_reg] = ACTIONS(441),
    [anon_sym_ease] = ACTIONS(441),
    [anon_sym_ease_DASHin] = ACTIONS(441),
    [anon_sym_ease_in] = ACTIONS(441),
    [anon_sym_ease_in_out] = ACTIONS(441),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(441),
    [anon_sym_ease_out] = ACTIONS(441),
    [anon_sym_ease_DASHout] = ACTIONS(441),
    [anon_sym_start] = ACTIONS(441),
    [anon_sym_end] = ACTIONS(441),
    [anon_sym_black] = ACTIONS(441),
    [anon_sym_blue] = ACTIONS(441),
    [anon_sym_green] = ACTIONS(441),
    [anon_sym_red] = ACTIONS(441),
    [anon_sym_yellow] = ACTIONS(441),
    [anon_sym_white] = ACTIONS(441),
    [anon_sym_gray] = ACTIONS(441),
    [anon_sym_transparent] = ACTIONS(441),
    [anon_sym_angle] = ACTIONS(441),
    [anon_sym_bool] = ACTIONS(441),
    [anon_sym_brush] = ACTIONS(441),
    [anon_sym_color] = ACTIONS(441),
    [anon_sym_float] = ACTIONS(441),
    [anon_sym_image] = ACTIONS(441),
    [anon_sym_int] = ACTIONS(441),
    [anon_sym_length] = ACTIONS(441),
    [anon_sym_percent] = ACTIONS(441),
    [anon_sym_physical_DASHlength] = ACTIONS(441),
    [anon_sym_physical_length] = ACTIONS(441),
    [anon_sym_string] = ACTIONS(441),
    [anon_sym_debug] = ACTIONS(441),
    [anon_sym_animation_DASHtick] = ACTIONS(441),
    [anon_sym_min] = ACTIONS(441),
    [anon_sym_max] = ACTIONS(441),
    [anon_sym_mod] = ACTIONS(441),
    [anon_sym_abs] = ACTIONS(441),
    [anon_sym_round] = ACTIONS(441),
    [anon_sym_ceil] = ACTIONS(441),
    [anon_sym_floor] = ACTIONS(441),
    [anon_sym_sin] = ACTIONS(441),
    [anon_sym_cos] = ACTIONS(441),
    [anon_sym_tan] = ACTIONS(441),
    [anon_sym_asin] = ACTIONS(441),
    [anon_sym_acos] = ACTIONS(441),
    [anon_sym_atan] = ACTIONS(441),
    [anon_sym_sqrt] = ACTIONS(441),
    [anon_sym_pow] = ACTIONS(441),
    [anon_sym_log] = ACTIONS(441),
    [anon_sym_rgb] = ACTIONS(441),
    [anon_sym_easing] = ACTIONS(441),
    [anon_sym_duration] = ACTIONS(441),
    [anon_sym_parent] = ACTIONS(441),
    [anon_sym_root] = ACTIONS(441),
    [sym_comment] = ACTIONS(3),
  },
  [86] = {
    [anon_sym_LBRACE] = ACTIONS(411),
    [anon_sym_COMMA] = ACTIONS(387),
    [anon_sym_if] = ACTIONS(413),
    [anon_sym_AT] = ACTIONS(411),
    [anon_sym_LBRACK] = ACTIONS(411),
    [anon_sym_STAR] = ACTIONS(413),
    [anon_sym_LPAREN] = ACTIONS(411),
    [anon_sym_RPAREN] = ACTIONS(387),
    [anon_sym_LT] = ACTIONS(413),
    [anon_sym_GT] = ACTIONS(413),
    [anon_sym_EQ] = ACTIONS(413),
    [anon_sym_PLUS_EQ] = ACTIONS(411),
    [anon_sym_DASH_EQ] = ACTIONS(411),
    [anon_sym_STAR_EQ] = ACTIONS(411),
    [anon_sym_SLASH_EQ] = ACTIONS(411),
    [anon_sym_PERCENT_EQ] = ACTIONS(411),
    [anon_sym_AMP_EQ] = ACTIONS(411),
    [anon_sym_PIPE_EQ] = ACTIONS(411),
    [anon_sym_CARET_EQ] = ACTIONS(411),
    [anon_sym_LT_LT_EQ] = ACTIONS(411),
    [anon_sym_GT_GT_EQ] = ACTIONS(411),
    [anon_sym_DOT] = ACTIONS(411),
    [anon_sym_true] = ACTIONS(413),
    [anon_sym_false] = ACTIONS(413),
    [anon_sym_DASH] = ACTIONS(413),
    [anon_sym_BANG] = ACTIONS(413),
    [anon_sym_AMP_AMP] = ACTIONS(411),
    [anon_sym_PIPE_PIPE] = ACTIONS(411),
    [anon_sym_AMP] = ACTIONS(413),
    [anon_sym_PIPE] = ACTIONS(413),
    [anon_sym_CARET] = ACTIONS(413),
    [anon_sym_EQ_EQ] = ACTIONS(411),
    [anon_sym_BANG_EQ] = ACTIONS(411),
    [anon_sym_LT_EQ] = ACTIONS(411),
    [anon_sym_GT_EQ] = ACTIONS(411),
    [anon_sym_LT_LT] = ACTIONS(413),
    [anon_sym_GT_GT] = ACTIONS(413),
    [anon_sym_PLUS] = ACTIONS(413),
    [anon_sym_SLASH] = ACTIONS(413),
    [anon_sym_QMARK] = ACTIONS(411),
    [anon_sym_DQUOTE] = ACTIONS(411),
    [anon_sym_SQUOTE] = ACTIONS(411),
    [sym__ident_reg] = ACTIONS(413),
    [anon_sym_POUND] = ACTIONS(411),
    [sym_int_literal] = ACTIONS(413),
    [sym_float_literal] = ACTIONS(411),
    [anon_sym_ease] = ACTIONS(413),
    [anon_sym_ease_DASHin] = ACTIONS(413),
    [anon_sym_ease_in] = ACTIONS(413),
    [anon_sym_ease_in_out] = ACTIONS(413),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(413),
    [anon_sym_ease_out] = ACTIONS(413),
    [anon_sym_ease_DASHout] = ACTIONS(413),
    [anon_sym_start] = ACTIONS(413),
    [anon_sym_end] = ACTIONS(413),
    [anon_sym_black] = ACTIONS(413),
    [anon_sym_blue] = ACTIONS(413),
    [anon_sym_green] = ACTIONS(413),
    [anon_sym_red] = ACTIONS(413),
    [anon_sym_yellow] = ACTIONS(413),
    [anon_sym_white] = ACTIONS(413),
    [anon_sym_gray] = ACTIONS(413),
    [anon_sym_transparent] = ACTIONS(413),
    [anon_sym_angle] = ACTIONS(413),
    [anon_sym_bool] = ACTIONS(413),
    [anon_sym_brush] = ACTIONS(413),
    [anon_sym_color] = ACTIONS(413),
    [anon_sym_float] = ACTIONS(413),
    [anon_sym_image] = ACTIONS(413),
    [anon_sym_int] = ACTIONS(413),
    [anon_sym_length] = ACTIONS(413),
    [anon_sym_percent] = ACTIONS(413),
    [anon_sym_physical_DASHlength] = ACTIONS(413),
    [anon_sym_physical_length] = ACTIONS(413),
    [anon_sym_string] = ACTIONS(413),
    [anon_sym_debug] = ACTIONS(413),
    [anon_sym_animation_DASHtick] = ACTIONS(413),
    [anon_sym_min] = ACTIONS(413),
    [anon_sym_max] = ACTIONS(413),
    [anon_sym_mod] = ACTIONS(413),
    [anon_sym_abs] = ACTIONS(413),
    [anon_sym_round] = ACTIONS(413),
    [anon_sym_ceil] = ACTIONS(413),
    [anon_sym_floor] = ACTIONS(413),
    [anon_sym_sin] = ACTIONS(413),
    [anon_sym_cos] = ACTIONS(413),
    [anon_sym_tan] = ACTIONS(413),
    [anon_sym_asin] = ACTIONS(413),
    [anon_sym_acos] = ACTIONS(413),
    [anon_sym_atan] = ACTIONS(413),
    [anon_sym_sqrt] = ACTIONS(413),
    [anon_sym_pow] = ACTIONS(413),
    [anon_sym_log] = ACTIONS(413),
    [anon_sym_rgb] = ACTIONS(413),
    [anon_sym_easing] = ACTIONS(413),
    [anon_sym_duration] = ACTIONS(413),
    [anon_sym_parent] = ACTIONS(413),
    [anon_sym_root] = ACTIONS(413),
    [sym_comment] = ACTIONS(3),
  },
  [87] = {
    [sym_struct_block_definition] = STATE(410),
    [sym__assign_property] = STATE(238),
    [sym__expression] = STATE(410),
    [sym__all_expressions] = STATE(410),
    [sym_if_expression] = STATE(410),
    [sym_index_expression] = STATE(410),
    [sym_assign_expression] = STATE(410),
    [sym_comp_assign_expression] = STATE(410),
    [sym_call_expression] = STATE(410),
    [sym_field_expression] = STATE(410),
    [sym_bool_literal] = STATE(410),
    [sym_unary_expression] = STATE(410),
    [sym_binary_expression] = STATE(410),
    [sym_ternary_expression] = STATE(410),
    [sym__macro] = STATE(410),
    [sym__literal] = STATE(410),
    [sym_array_literal] = STATE(410),
    [sym_string_literal] = STATE(410),
    [sym_identifier] = STATE(410),
    [sym_color_literal] = STATE(410),
    [sym__number] = STATE(410),
    [sym_num_units] = STATE(410),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_COLON] = ACTIONS(212),
    [anon_sym_SEMI] = ACTIONS(497),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LT_EQ_GT] = ACTIONS(499),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [88] = {
    [sym_struct_block_definition] = STATE(408),
    [sym__assign_property] = STATE(195),
    [sym__expression] = STATE(408),
    [sym__all_expressions] = STATE(408),
    [sym_if_expression] = STATE(408),
    [sym_index_expression] = STATE(408),
    [sym_assign_expression] = STATE(408),
    [sym_comp_assign_expression] = STATE(408),
    [sym_call_expression] = STATE(408),
    [sym_field_expression] = STATE(408),
    [sym_bool_literal] = STATE(408),
    [sym_unary_expression] = STATE(408),
    [sym_binary_expression] = STATE(408),
    [sym_ternary_expression] = STATE(408),
    [sym__macro] = STATE(408),
    [sym__literal] = STATE(408),
    [sym_array_literal] = STATE(408),
    [sym_string_literal] = STATE(408),
    [sym_identifier] = STATE(408),
    [sym_color_literal] = STATE(408),
    [sym__number] = STATE(408),
    [sym_num_units] = STATE(408),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_COLON] = ACTIONS(85),
    [anon_sym_SEMI] = ACTIONS(501),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LT_EQ_GT] = ACTIONS(503),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [89] = {
    [sym_struct_block_definition] = STATE(374),
    [sym__expression] = STATE(374),
    [sym__all_expressions] = STATE(374),
    [sym_if_expression] = STATE(374),
    [sym_index_expression] = STATE(374),
    [sym_assign_expression] = STATE(374),
    [sym_comp_assign_expression] = STATE(374),
    [sym_call_expression] = STATE(374),
    [sym_field_expression] = STATE(374),
    [sym_bool_literal] = STATE(374),
    [sym_unary_expression] = STATE(374),
    [sym_binary_expression] = STATE(374),
    [sym_ternary_expression] = STATE(374),
    [sym__macro] = STATE(374),
    [sym__literal] = STATE(374),
    [sym_array_literal] = STATE(374),
    [sym_string_literal] = STATE(374),
    [sym_identifier] = STATE(374),
    [sym_color_literal] = STATE(374),
    [sym__number] = STATE(374),
    [sym_num_units] = STATE(374),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_COMMA] = ACTIONS(505),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_RBRACK] = ACTIONS(505),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_RPAREN] = ACTIONS(505),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [90] = {
    [sym_struct_block_definition] = STATE(81),
    [sym__expression] = STATE(81),
    [sym__all_expressions] = STATE(81),
    [sym_if_expression] = STATE(81),
    [sym_index_expression] = STATE(81),
    [sym_assign_expression] = STATE(81),
    [sym_comp_assign_expression] = STATE(81),
    [sym_call_expression] = STATE(81),
    [sym_field_expression] = STATE(81),
    [sym_bool_literal] = STATE(81),
    [sym_unary_expression] = STATE(81),
    [sym_binary_expression] = STATE(81),
    [sym_ternary_expression] = STATE(81),
    [sym__macro] = STATE(81),
    [sym__literal] = STATE(81),
    [sym_array_literal] = STATE(81),
    [sym_string_literal] = STATE(81),
    [sym_identifier] = STATE(81),
    [sym_color_literal] = STATE(81),
    [sym__number] = STATE(81),
    [sym_num_units] = STATE(81),
    [sym__builtin] = STATE(63),
    [sym_constant_builtin] = STATE(63),
    [sym_type_builtin] = STATE(63),
    [sym_function_builtin] = STATE(63),
    [sym_variable_builtin] = STATE(63),
    [aux_sym_consequence_body_repeat1] = STATE(98),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_RBRACE] = ACTIONS(509),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_true] = ACTIONS(519),
    [anon_sym_false] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [sym__ident_reg] = ACTIONS(527),
    [anon_sym_POUND] = ACTIONS(529),
    [sym_int_literal] = ACTIONS(531),
    [sym_float_literal] = ACTIONS(533),
    [anon_sym_ease] = ACTIONS(535),
    [anon_sym_ease_DASHin] = ACTIONS(535),
    [anon_sym_ease_in] = ACTIONS(535),
    [anon_sym_ease_in_out] = ACTIONS(535),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(535),
    [anon_sym_ease_out] = ACTIONS(535),
    [anon_sym_ease_DASHout] = ACTIONS(535),
    [anon_sym_start] = ACTIONS(535),
    [anon_sym_end] = ACTIONS(535),
    [anon_sym_black] = ACTIONS(535),
    [anon_sym_blue] = ACTIONS(535),
    [anon_sym_green] = ACTIONS(535),
    [anon_sym_red] = ACTIONS(535),
    [anon_sym_yellow] = ACTIONS(535),
    [anon_sym_white] = ACTIONS(535),
    [anon_sym_gray] = ACTIONS(535),
    [anon_sym_transparent] = ACTIONS(535),
    [anon_sym_angle] = ACTIONS(537),
    [anon_sym_bool] = ACTIONS(537),
    [anon_sym_brush] = ACTIONS(537),
    [anon_sym_color] = ACTIONS(537),
    [anon_sym_float] = ACTIONS(537),
    [anon_sym_image] = ACTIONS(537),
    [anon_sym_int] = ACTIONS(537),
    [anon_sym_length] = ACTIONS(537),
    [anon_sym_percent] = ACTIONS(537),
    [anon_sym_physical_DASHlength] = ACTIONS(537),
    [anon_sym_physical_length] = ACTIONS(537),
    [anon_sym_string] = ACTIONS(537),
    [anon_sym_debug] = ACTIONS(539),
    [anon_sym_animation_DASHtick] = ACTIONS(539),
    [anon_sym_min] = ACTIONS(539),
    [anon_sym_max] = ACTIONS(539),
    [anon_sym_mod] = ACTIONS(539),
    [anon_sym_abs] = ACTIONS(539),
    [anon_sym_round] = ACTIONS(539),
    [anon_sym_ceil] = ACTIONS(539),
    [anon_sym_floor] = ACTIONS(539),
    [anon_sym_sin] = ACTIONS(539),
    [anon_sym_cos] = ACTIONS(539),
    [anon_sym_tan] = ACTIONS(539),
    [anon_sym_asin] = ACTIONS(539),
    [anon_sym_acos] = ACTIONS(539),
    [anon_sym_atan] = ACTIONS(539),
    [anon_sym_sqrt] = ACTIONS(539),
    [anon_sym_pow] = ACTIONS(539),
    [anon_sym_log] = ACTIONS(539),
    [anon_sym_rgb] = ACTIONS(539),
    [anon_sym_easing] = ACTIONS(541),
    [anon_sym_duration] = ACTIONS(541),
    [anon_sym_parent] = ACTIONS(541),
    [anon_sym_root] = ACTIONS(541),
    [sym_comment] = ACTIONS(3),
  },
  [91] = {
    [sym_struct_block_definition] = STATE(81),
    [sym__expression] = STATE(81),
    [sym__all_expressions] = STATE(81),
    [sym_if_expression] = STATE(81),
    [sym_index_expression] = STATE(81),
    [sym_assign_expression] = STATE(81),
    [sym_comp_assign_expression] = STATE(81),
    [sym_call_expression] = STATE(81),
    [sym_field_expression] = STATE(81),
    [sym_bool_literal] = STATE(81),
    [sym_unary_expression] = STATE(81),
    [sym_binary_expression] = STATE(81),
    [sym_ternary_expression] = STATE(81),
    [sym__macro] = STATE(81),
    [sym__literal] = STATE(81),
    [sym_array_literal] = STATE(81),
    [sym_string_literal] = STATE(81),
    [sym_identifier] = STATE(81),
    [sym_color_literal] = STATE(81),
    [sym__number] = STATE(81),
    [sym_num_units] = STATE(81),
    [sym__builtin] = STATE(63),
    [sym_constant_builtin] = STATE(63),
    [sym_type_builtin] = STATE(63),
    [sym_function_builtin] = STATE(63),
    [sym_variable_builtin] = STATE(63),
    [aux_sym_consequence_body_repeat1] = STATE(91),
    [anon_sym_LBRACE] = ACTIONS(543),
    [anon_sym_RBRACE] = ACTIONS(546),
    [anon_sym_if] = ACTIONS(548),
    [anon_sym_AT] = ACTIONS(551),
    [anon_sym_LBRACK] = ACTIONS(554),
    [anon_sym_LPAREN] = ACTIONS(557),
    [anon_sym_true] = ACTIONS(560),
    [anon_sym_false] = ACTIONS(560),
    [anon_sym_DASH] = ACTIONS(563),
    [anon_sym_BANG] = ACTIONS(563),
    [anon_sym_DQUOTE] = ACTIONS(566),
    [anon_sym_SQUOTE] = ACTIONS(569),
    [sym__ident_reg] = ACTIONS(572),
    [anon_sym_POUND] = ACTIONS(575),
    [sym_int_literal] = ACTIONS(578),
    [sym_float_literal] = ACTIONS(581),
    [anon_sym_ease] = ACTIONS(584),
    [anon_sym_ease_DASHin] = ACTIONS(584),
    [anon_sym_ease_in] = ACTIONS(584),
    [anon_sym_ease_in_out] = ACTIONS(584),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(584),
    [anon_sym_ease_out] = ACTIONS(584),
    [anon_sym_ease_DASHout] = ACTIONS(584),
    [anon_sym_start] = ACTIONS(584),
    [anon_sym_end] = ACTIONS(584),
    [anon_sym_black] = ACTIONS(584),
    [anon_sym_blue] = ACTIONS(584),
    [anon_sym_green] = ACTIONS(584),
    [anon_sym_red] = ACTIONS(584),
    [anon_sym_yellow] = ACTIONS(584),
    [anon_sym_white] = ACTIONS(584),
    [anon_sym_gray] = ACTIONS(584),
    [anon_sym_transparent] = ACTIONS(584),
    [anon_sym_angle] = ACTIONS(587),
    [anon_sym_bool] = ACTIONS(587),
    [anon_sym_brush] = ACTIONS(587),
    [anon_sym_color] = ACTIONS(587),
    [anon_sym_float] = ACTIONS(587),
    [anon_sym_image] = ACTIONS(587),
    [anon_sym_int] = ACTIONS(587),
    [anon_sym_length] = ACTIONS(587),
    [anon_sym_percent] = ACTIONS(587),
    [anon_sym_physical_DASHlength] = ACTIONS(587),
    [anon_sym_physical_length] = ACTIONS(587),
    [anon_sym_string] = ACTIONS(587),
    [anon_sym_debug] = ACTIONS(590),
    [anon_sym_animation_DASHtick] = ACTIONS(590),
    [anon_sym_min] = ACTIONS(590),
    [anon_sym_max] = ACTIONS(590),
    [anon_sym_mod] = ACTIONS(590),
    [anon_sym_abs] = ACTIONS(590),
    [anon_sym_round] = ACTIONS(590),
    [anon_sym_ceil] = ACTIONS(590),
    [anon_sym_floor] = ACTIONS(590),
    [anon_sym_sin] = ACTIONS(590),
    [anon_sym_cos] = ACTIONS(590),
    [anon_sym_tan] = ACTIONS(590),
    [anon_sym_asin] = ACTIONS(590),
    [anon_sym_acos] = ACTIONS(590),
    [anon_sym_atan] = ACTIONS(590),
    [anon_sym_sqrt] = ACTIONS(590),
    [anon_sym_pow] = ACTIONS(590),
    [anon_sym_log] = ACTIONS(590),
    [anon_sym_rgb] = ACTIONS(590),
    [anon_sym_easing] = ACTIONS(593),
    [anon_sym_duration] = ACTIONS(593),
    [anon_sym_parent] = ACTIONS(593),
    [anon_sym_root] = ACTIONS(593),
    [sym_comment] = ACTIONS(3),
  },
  [92] = {
    [sym_struct_block_definition] = STATE(81),
    [sym__expression] = STATE(81),
    [sym__all_expressions] = STATE(81),
    [sym_if_expression] = STATE(81),
    [sym_index_expression] = STATE(81),
    [sym_assign_expression] = STATE(81),
    [sym_comp_assign_expression] = STATE(81),
    [sym_call_expression] = STATE(81),
    [sym_field_expression] = STATE(81),
    [sym_bool_literal] = STATE(81),
    [sym_unary_expression] = STATE(81),
    [sym_binary_expression] = STATE(81),
    [sym_ternary_expression] = STATE(81),
    [sym__macro] = STATE(81),
    [sym__literal] = STATE(81),
    [sym_array_literal] = STATE(81),
    [sym_string_literal] = STATE(81),
    [sym_identifier] = STATE(81),
    [sym_color_literal] = STATE(81),
    [sym__number] = STATE(81),
    [sym_num_units] = STATE(81),
    [sym__builtin] = STATE(63),
    [sym_constant_builtin] = STATE(63),
    [sym_type_builtin] = STATE(63),
    [sym_function_builtin] = STATE(63),
    [sym_variable_builtin] = STATE(63),
    [aux_sym_consequence_body_repeat1] = STATE(91),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_RBRACE] = ACTIONS(596),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_true] = ACTIONS(519),
    [anon_sym_false] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [sym__ident_reg] = ACTIONS(527),
    [anon_sym_POUND] = ACTIONS(529),
    [sym_int_literal] = ACTIONS(531),
    [sym_float_literal] = ACTIONS(533),
    [anon_sym_ease] = ACTIONS(535),
    [anon_sym_ease_DASHin] = ACTIONS(535),
    [anon_sym_ease_in] = ACTIONS(535),
    [anon_sym_ease_in_out] = ACTIONS(535),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(535),
    [anon_sym_ease_out] = ACTIONS(535),
    [anon_sym_ease_DASHout] = ACTIONS(535),
    [anon_sym_start] = ACTIONS(535),
    [anon_sym_end] = ACTIONS(535),
    [anon_sym_black] = ACTIONS(535),
    [anon_sym_blue] = ACTIONS(535),
    [anon_sym_green] = ACTIONS(535),
    [anon_sym_red] = ACTIONS(535),
    [anon_sym_yellow] = ACTIONS(535),
    [anon_sym_white] = ACTIONS(535),
    [anon_sym_gray] = ACTIONS(535),
    [anon_sym_transparent] = ACTIONS(535),
    [anon_sym_angle] = ACTIONS(537),
    [anon_sym_bool] = ACTIONS(537),
    [anon_sym_brush] = ACTIONS(537),
    [anon_sym_color] = ACTIONS(537),
    [anon_sym_float] = ACTIONS(537),
    [anon_sym_image] = ACTIONS(537),
    [anon_sym_int] = ACTIONS(537),
    [anon_sym_length] = ACTIONS(537),
    [anon_sym_percent] = ACTIONS(537),
    [anon_sym_physical_DASHlength] = ACTIONS(537),
    [anon_sym_physical_length] = ACTIONS(537),
    [anon_sym_string] = ACTIONS(537),
    [anon_sym_debug] = ACTIONS(539),
    [anon_sym_animation_DASHtick] = ACTIONS(539),
    [anon_sym_min] = ACTIONS(539),
    [anon_sym_max] = ACTIONS(539),
    [anon_sym_mod] = ACTIONS(539),
    [anon_sym_abs] = ACTIONS(539),
    [anon_sym_round] = ACTIONS(539),
    [anon_sym_ceil] = ACTIONS(539),
    [anon_sym_floor] = ACTIONS(539),
    [anon_sym_sin] = ACTIONS(539),
    [anon_sym_cos] = ACTIONS(539),
    [anon_sym_tan] = ACTIONS(539),
    [anon_sym_asin] = ACTIONS(539),
    [anon_sym_acos] = ACTIONS(539),
    [anon_sym_atan] = ACTIONS(539),
    [anon_sym_sqrt] = ACTIONS(539),
    [anon_sym_pow] = ACTIONS(539),
    [anon_sym_log] = ACTIONS(539),
    [anon_sym_rgb] = ACTIONS(539),
    [anon_sym_easing] = ACTIONS(541),
    [anon_sym_duration] = ACTIONS(541),
    [anon_sym_parent] = ACTIONS(541),
    [anon_sym_root] = ACTIONS(541),
    [sym_comment] = ACTIONS(3),
  },
  [93] = {
    [sym_struct_block_definition] = STATE(81),
    [sym__expression] = STATE(81),
    [sym__all_expressions] = STATE(81),
    [sym_if_expression] = STATE(81),
    [sym_index_expression] = STATE(81),
    [sym_assign_expression] = STATE(81),
    [sym_comp_assign_expression] = STATE(81),
    [sym_call_expression] = STATE(81),
    [sym_field_expression] = STATE(81),
    [sym_bool_literal] = STATE(81),
    [sym_unary_expression] = STATE(81),
    [sym_binary_expression] = STATE(81),
    [sym_ternary_expression] = STATE(81),
    [sym__macro] = STATE(81),
    [sym__literal] = STATE(81),
    [sym_array_literal] = STATE(81),
    [sym_string_literal] = STATE(81),
    [sym_identifier] = STATE(81),
    [sym_color_literal] = STATE(81),
    [sym__number] = STATE(81),
    [sym_num_units] = STATE(81),
    [sym__builtin] = STATE(63),
    [sym_constant_builtin] = STATE(63),
    [sym_type_builtin] = STATE(63),
    [sym_function_builtin] = STATE(63),
    [sym_variable_builtin] = STATE(63),
    [aux_sym_consequence_body_repeat1] = STATE(92),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_RBRACE] = ACTIONS(598),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_true] = ACTIONS(519),
    [anon_sym_false] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [sym__ident_reg] = ACTIONS(527),
    [anon_sym_POUND] = ACTIONS(529),
    [sym_int_literal] = ACTIONS(531),
    [sym_float_literal] = ACTIONS(533),
    [anon_sym_ease] = ACTIONS(535),
    [anon_sym_ease_DASHin] = ACTIONS(535),
    [anon_sym_ease_in] = ACTIONS(535),
    [anon_sym_ease_in_out] = ACTIONS(535),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(535),
    [anon_sym_ease_out] = ACTIONS(535),
    [anon_sym_ease_DASHout] = ACTIONS(535),
    [anon_sym_start] = ACTIONS(535),
    [anon_sym_end] = ACTIONS(535),
    [anon_sym_black] = ACTIONS(535),
    [anon_sym_blue] = ACTIONS(535),
    [anon_sym_green] = ACTIONS(535),
    [anon_sym_red] = ACTIONS(535),
    [anon_sym_yellow] = ACTIONS(535),
    [anon_sym_white] = ACTIONS(535),
    [anon_sym_gray] = ACTIONS(535),
    [anon_sym_transparent] = ACTIONS(535),
    [anon_sym_angle] = ACTIONS(537),
    [anon_sym_bool] = ACTIONS(537),
    [anon_sym_brush] = ACTIONS(537),
    [anon_sym_color] = ACTIONS(537),
    [anon_sym_float] = ACTIONS(537),
    [anon_sym_image] = ACTIONS(537),
    [anon_sym_int] = ACTIONS(537),
    [anon_sym_length] = ACTIONS(537),
    [anon_sym_percent] = ACTIONS(537),
    [anon_sym_physical_DASHlength] = ACTIONS(537),
    [anon_sym_physical_length] = ACTIONS(537),
    [anon_sym_string] = ACTIONS(537),
    [anon_sym_debug] = ACTIONS(539),
    [anon_sym_animation_DASHtick] = ACTIONS(539),
    [anon_sym_min] = ACTIONS(539),
    [anon_sym_max] = ACTIONS(539),
    [anon_sym_mod] = ACTIONS(539),
    [anon_sym_abs] = ACTIONS(539),
    [anon_sym_round] = ACTIONS(539),
    [anon_sym_ceil] = ACTIONS(539),
    [anon_sym_floor] = ACTIONS(539),
    [anon_sym_sin] = ACTIONS(539),
    [anon_sym_cos] = ACTIONS(539),
    [anon_sym_tan] = ACTIONS(539),
    [anon_sym_asin] = ACTIONS(539),
    [anon_sym_acos] = ACTIONS(539),
    [anon_sym_atan] = ACTIONS(539),
    [anon_sym_sqrt] = ACTIONS(539),
    [anon_sym_pow] = ACTIONS(539),
    [anon_sym_log] = ACTIONS(539),
    [anon_sym_rgb] = ACTIONS(539),
    [anon_sym_easing] = ACTIONS(541),
    [anon_sym_duration] = ACTIONS(541),
    [anon_sym_parent] = ACTIONS(541),
    [anon_sym_root] = ACTIONS(541),
    [sym_comment] = ACTIONS(3),
  },
  [94] = {
    [sym_struct_block_definition] = STATE(81),
    [sym__expression] = STATE(81),
    [sym__all_expressions] = STATE(81),
    [sym_if_expression] = STATE(81),
    [sym_index_expression] = STATE(81),
    [sym_assign_expression] = STATE(81),
    [sym_comp_assign_expression] = STATE(81),
    [sym_call_expression] = STATE(81),
    [sym_field_expression] = STATE(81),
    [sym_bool_literal] = STATE(81),
    [sym_unary_expression] = STATE(81),
    [sym_binary_expression] = STATE(81),
    [sym_ternary_expression] = STATE(81),
    [sym__macro] = STATE(81),
    [sym__literal] = STATE(81),
    [sym_array_literal] = STATE(81),
    [sym_string_literal] = STATE(81),
    [sym_identifier] = STATE(81),
    [sym_color_literal] = STATE(81),
    [sym__number] = STATE(81),
    [sym_num_units] = STATE(81),
    [sym__builtin] = STATE(63),
    [sym_constant_builtin] = STATE(63),
    [sym_type_builtin] = STATE(63),
    [sym_function_builtin] = STATE(63),
    [sym_variable_builtin] = STATE(63),
    [aux_sym_consequence_body_repeat1] = STATE(91),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_RBRACE] = ACTIONS(600),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_true] = ACTIONS(519),
    [anon_sym_false] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [sym__ident_reg] = ACTIONS(527),
    [anon_sym_POUND] = ACTIONS(529),
    [sym_int_literal] = ACTIONS(531),
    [sym_float_literal] = ACTIONS(533),
    [anon_sym_ease] = ACTIONS(535),
    [anon_sym_ease_DASHin] = ACTIONS(535),
    [anon_sym_ease_in] = ACTIONS(535),
    [anon_sym_ease_in_out] = ACTIONS(535),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(535),
    [anon_sym_ease_out] = ACTIONS(535),
    [anon_sym_ease_DASHout] = ACTIONS(535),
    [anon_sym_start] = ACTIONS(535),
    [anon_sym_end] = ACTIONS(535),
    [anon_sym_black] = ACTIONS(535),
    [anon_sym_blue] = ACTIONS(535),
    [anon_sym_green] = ACTIONS(535),
    [anon_sym_red] = ACTIONS(535),
    [anon_sym_yellow] = ACTIONS(535),
    [anon_sym_white] = ACTIONS(535),
    [anon_sym_gray] = ACTIONS(535),
    [anon_sym_transparent] = ACTIONS(535),
    [anon_sym_angle] = ACTIONS(537),
    [anon_sym_bool] = ACTIONS(537),
    [anon_sym_brush] = ACTIONS(537),
    [anon_sym_color] = ACTIONS(537),
    [anon_sym_float] = ACTIONS(537),
    [anon_sym_image] = ACTIONS(537),
    [anon_sym_int] = ACTIONS(537),
    [anon_sym_length] = ACTIONS(537),
    [anon_sym_percent] = ACTIONS(537),
    [anon_sym_physical_DASHlength] = ACTIONS(537),
    [anon_sym_physical_length] = ACTIONS(537),
    [anon_sym_string] = ACTIONS(537),
    [anon_sym_debug] = ACTIONS(539),
    [anon_sym_animation_DASHtick] = ACTIONS(539),
    [anon_sym_min] = ACTIONS(539),
    [anon_sym_max] = ACTIONS(539),
    [anon_sym_mod] = ACTIONS(539),
    [anon_sym_abs] = ACTIONS(539),
    [anon_sym_round] = ACTIONS(539),
    [anon_sym_ceil] = ACTIONS(539),
    [anon_sym_floor] = ACTIONS(539),
    [anon_sym_sin] = ACTIONS(539),
    [anon_sym_cos] = ACTIONS(539),
    [anon_sym_tan] = ACTIONS(539),
    [anon_sym_asin] = ACTIONS(539),
    [anon_sym_acos] = ACTIONS(539),
    [anon_sym_atan] = ACTIONS(539),
    [anon_sym_sqrt] = ACTIONS(539),
    [anon_sym_pow] = ACTIONS(539),
    [anon_sym_log] = ACTIONS(539),
    [anon_sym_rgb] = ACTIONS(539),
    [anon_sym_easing] = ACTIONS(541),
    [anon_sym_duration] = ACTIONS(541),
    [anon_sym_parent] = ACTIONS(541),
    [anon_sym_root] = ACTIONS(541),
    [sym_comment] = ACTIONS(3),
  },
  [95] = {
    [sym_struct_block_definition] = STATE(403),
    [sym__expression] = STATE(403),
    [sym__all_expressions] = STATE(403),
    [sym_if_expression] = STATE(403),
    [sym_index_expression] = STATE(403),
    [sym_assign_expression] = STATE(403),
    [sym_comp_assign_expression] = STATE(403),
    [sym_call_expression] = STATE(403),
    [sym_field_expression] = STATE(403),
    [sym_bool_literal] = STATE(403),
    [sym_unary_expression] = STATE(403),
    [sym_binary_expression] = STATE(403),
    [sym_ternary_expression] = STATE(403),
    [sym__macro] = STATE(403),
    [sym__literal] = STATE(403),
    [sym_array_literal] = STATE(403),
    [sym_string_literal] = STATE(403),
    [sym_identifier] = STATE(403),
    [sym_color_literal] = STATE(403),
    [sym__number] = STATE(403),
    [sym_num_units] = STATE(403),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(602),
    [anon_sym_SEMI] = ACTIONS(604),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [96] = {
    [sym_struct_block_definition] = STATE(81),
    [sym__expression] = STATE(81),
    [sym__all_expressions] = STATE(81),
    [sym_if_expression] = STATE(81),
    [sym_index_expression] = STATE(81),
    [sym_assign_expression] = STATE(81),
    [sym_comp_assign_expression] = STATE(81),
    [sym_call_expression] = STATE(81),
    [sym_field_expression] = STATE(81),
    [sym_bool_literal] = STATE(81),
    [sym_unary_expression] = STATE(81),
    [sym_binary_expression] = STATE(81),
    [sym_ternary_expression] = STATE(81),
    [sym__macro] = STATE(81),
    [sym__literal] = STATE(81),
    [sym_array_literal] = STATE(81),
    [sym_string_literal] = STATE(81),
    [sym_identifier] = STATE(81),
    [sym_color_literal] = STATE(81),
    [sym__number] = STATE(81),
    [sym_num_units] = STATE(81),
    [sym__builtin] = STATE(63),
    [sym_constant_builtin] = STATE(63),
    [sym_type_builtin] = STATE(63),
    [sym_function_builtin] = STATE(63),
    [sym_variable_builtin] = STATE(63),
    [aux_sym_consequence_body_repeat1] = STATE(94),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_RBRACE] = ACTIONS(606),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_true] = ACTIONS(519),
    [anon_sym_false] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [sym__ident_reg] = ACTIONS(527),
    [anon_sym_POUND] = ACTIONS(529),
    [sym_int_literal] = ACTIONS(531),
    [sym_float_literal] = ACTIONS(533),
    [anon_sym_ease] = ACTIONS(535),
    [anon_sym_ease_DASHin] = ACTIONS(535),
    [anon_sym_ease_in] = ACTIONS(535),
    [anon_sym_ease_in_out] = ACTIONS(535),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(535),
    [anon_sym_ease_out] = ACTIONS(535),
    [anon_sym_ease_DASHout] = ACTIONS(535),
    [anon_sym_start] = ACTIONS(535),
    [anon_sym_end] = ACTIONS(535),
    [anon_sym_black] = ACTIONS(535),
    [anon_sym_blue] = ACTIONS(535),
    [anon_sym_green] = ACTIONS(535),
    [anon_sym_red] = ACTIONS(535),
    [anon_sym_yellow] = ACTIONS(535),
    [anon_sym_white] = ACTIONS(535),
    [anon_sym_gray] = ACTIONS(535),
    [anon_sym_transparent] = ACTIONS(535),
    [anon_sym_angle] = ACTIONS(537),
    [anon_sym_bool] = ACTIONS(537),
    [anon_sym_brush] = ACTIONS(537),
    [anon_sym_color] = ACTIONS(537),
    [anon_sym_float] = ACTIONS(537),
    [anon_sym_image] = ACTIONS(537),
    [anon_sym_int] = ACTIONS(537),
    [anon_sym_length] = ACTIONS(537),
    [anon_sym_percent] = ACTIONS(537),
    [anon_sym_physical_DASHlength] = ACTIONS(537),
    [anon_sym_physical_length] = ACTIONS(537),
    [anon_sym_string] = ACTIONS(537),
    [anon_sym_debug] = ACTIONS(539),
    [anon_sym_animation_DASHtick] = ACTIONS(539),
    [anon_sym_min] = ACTIONS(539),
    [anon_sym_max] = ACTIONS(539),
    [anon_sym_mod] = ACTIONS(539),
    [anon_sym_abs] = ACTIONS(539),
    [anon_sym_round] = ACTIONS(539),
    [anon_sym_ceil] = ACTIONS(539),
    [anon_sym_floor] = ACTIONS(539),
    [anon_sym_sin] = ACTIONS(539),
    [anon_sym_cos] = ACTIONS(539),
    [anon_sym_tan] = ACTIONS(539),
    [anon_sym_asin] = ACTIONS(539),
    [anon_sym_acos] = ACTIONS(539),
    [anon_sym_atan] = ACTIONS(539),
    [anon_sym_sqrt] = ACTIONS(539),
    [anon_sym_pow] = ACTIONS(539),
    [anon_sym_log] = ACTIONS(539),
    [anon_sym_rgb] = ACTIONS(539),
    [anon_sym_easing] = ACTIONS(541),
    [anon_sym_duration] = ACTIONS(541),
    [anon_sym_parent] = ACTIONS(541),
    [anon_sym_root] = ACTIONS(541),
    [sym_comment] = ACTIONS(3),
  },
  [97] = {
    [sym_struct_block_definition] = STATE(402),
    [sym__expression] = STATE(402),
    [sym__all_expressions] = STATE(402),
    [sym_if_expression] = STATE(402),
    [sym_index_expression] = STATE(402),
    [sym_assign_expression] = STATE(402),
    [sym_comp_assign_expression] = STATE(402),
    [sym_call_expression] = STATE(402),
    [sym_field_expression] = STATE(402),
    [sym_bool_literal] = STATE(402),
    [sym_unary_expression] = STATE(402),
    [sym_binary_expression] = STATE(402),
    [sym_ternary_expression] = STATE(402),
    [sym__macro] = STATE(402),
    [sym__literal] = STATE(402),
    [sym_array_literal] = STATE(402),
    [sym_string_literal] = STATE(402),
    [sym_identifier] = STATE(402),
    [sym_color_literal] = STATE(402),
    [sym__number] = STATE(402),
    [sym_num_units] = STATE(402),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_RBRACE] = ACTIONS(608),
    [anon_sym_SEMI] = ACTIONS(610),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [98] = {
    [sym_struct_block_definition] = STATE(81),
    [sym__expression] = STATE(81),
    [sym__all_expressions] = STATE(81),
    [sym_if_expression] = STATE(81),
    [sym_index_expression] = STATE(81),
    [sym_assign_expression] = STATE(81),
    [sym_comp_assign_expression] = STATE(81),
    [sym_call_expression] = STATE(81),
    [sym_field_expression] = STATE(81),
    [sym_bool_literal] = STATE(81),
    [sym_unary_expression] = STATE(81),
    [sym_binary_expression] = STATE(81),
    [sym_ternary_expression] = STATE(81),
    [sym__macro] = STATE(81),
    [sym__literal] = STATE(81),
    [sym_array_literal] = STATE(81),
    [sym_string_literal] = STATE(81),
    [sym_identifier] = STATE(81),
    [sym_color_literal] = STATE(81),
    [sym__number] = STATE(81),
    [sym_num_units] = STATE(81),
    [sym__builtin] = STATE(63),
    [sym_constant_builtin] = STATE(63),
    [sym_type_builtin] = STATE(63),
    [sym_function_builtin] = STATE(63),
    [sym_variable_builtin] = STATE(63),
    [aux_sym_consequence_body_repeat1] = STATE(91),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_RBRACE] = ACTIONS(612),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_true] = ACTIONS(519),
    [anon_sym_false] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [sym__ident_reg] = ACTIONS(527),
    [anon_sym_POUND] = ACTIONS(529),
    [sym_int_literal] = ACTIONS(531),
    [sym_float_literal] = ACTIONS(533),
    [anon_sym_ease] = ACTIONS(535),
    [anon_sym_ease_DASHin] = ACTIONS(535),
    [anon_sym_ease_in] = ACTIONS(535),
    [anon_sym_ease_in_out] = ACTIONS(535),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(535),
    [anon_sym_ease_out] = ACTIONS(535),
    [anon_sym_ease_DASHout] = ACTIONS(535),
    [anon_sym_start] = ACTIONS(535),
    [anon_sym_end] = ACTIONS(535),
    [anon_sym_black] = ACTIONS(535),
    [anon_sym_blue] = ACTIONS(535),
    [anon_sym_green] = ACTIONS(535),
    [anon_sym_red] = ACTIONS(535),
    [anon_sym_yellow] = ACTIONS(535),
    [anon_sym_white] = ACTIONS(535),
    [anon_sym_gray] = ACTIONS(535),
    [anon_sym_transparent] = ACTIONS(535),
    [anon_sym_angle] = ACTIONS(537),
    [anon_sym_bool] = ACTIONS(537),
    [anon_sym_brush] = ACTIONS(537),
    [anon_sym_color] = ACTIONS(537),
    [anon_sym_float] = ACTIONS(537),
    [anon_sym_image] = ACTIONS(537),
    [anon_sym_int] = ACTIONS(537),
    [anon_sym_length] = ACTIONS(537),
    [anon_sym_percent] = ACTIONS(537),
    [anon_sym_physical_DASHlength] = ACTIONS(537),
    [anon_sym_physical_length] = ACTIONS(537),
    [anon_sym_string] = ACTIONS(537),
    [anon_sym_debug] = ACTIONS(539),
    [anon_sym_animation_DASHtick] = ACTIONS(539),
    [anon_sym_min] = ACTIONS(539),
    [anon_sym_max] = ACTIONS(539),
    [anon_sym_mod] = ACTIONS(539),
    [anon_sym_abs] = ACTIONS(539),
    [anon_sym_round] = ACTIONS(539),
    [anon_sym_ceil] = ACTIONS(539),
    [anon_sym_floor] = ACTIONS(539),
    [anon_sym_sin] = ACTIONS(539),
    [anon_sym_cos] = ACTIONS(539),
    [anon_sym_tan] = ACTIONS(539),
    [anon_sym_asin] = ACTIONS(539),
    [anon_sym_acos] = ACTIONS(539),
    [anon_sym_atan] = ACTIONS(539),
    [anon_sym_sqrt] = ACTIONS(539),
    [anon_sym_pow] = ACTIONS(539),
    [anon_sym_log] = ACTIONS(539),
    [anon_sym_rgb] = ACTIONS(539),
    [anon_sym_easing] = ACTIONS(541),
    [anon_sym_duration] = ACTIONS(541),
    [anon_sym_parent] = ACTIONS(541),
    [anon_sym_root] = ACTIONS(541),
    [sym_comment] = ACTIONS(3),
  },
  [99] = {
    [sym_struct_block_definition] = STATE(2),
    [sym__expression] = STATE(2),
    [sym__all_expressions] = STATE(2),
    [sym_if_expression] = STATE(2),
    [sym_index_expression] = STATE(2),
    [sym_assign_expression] = STATE(2),
    [sym_comp_assign_expression] = STATE(2),
    [sym_call_expression] = STATE(2),
    [sym_field_expression] = STATE(2),
    [sym_bool_literal] = STATE(2),
    [sym_unary_expression] = STATE(2),
    [sym_binary_expression] = STATE(2),
    [sym_ternary_expression] = STATE(2),
    [sym__macro] = STATE(2),
    [sym__literal] = STATE(2),
    [sym_array_literal] = STATE(2),
    [sym_string_literal] = STATE(2),
    [sym_identifier] = STATE(2),
    [sym_color_literal] = STATE(2),
    [sym__number] = STATE(2),
    [sym_num_units] = STATE(2),
    [sym__builtin] = STATE(63),
    [sym_constant_builtin] = STATE(63),
    [sym_type_builtin] = STATE(63),
    [sym_function_builtin] = STATE(63),
    [sym_variable_builtin] = STATE(63),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_COMMA] = ACTIONS(614),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_RPAREN] = ACTIONS(614),
    [anon_sym_true] = ACTIONS(519),
    [anon_sym_false] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [sym__ident_reg] = ACTIONS(527),
    [anon_sym_POUND] = ACTIONS(529),
    [sym_int_literal] = ACTIONS(531),
    [sym_float_literal] = ACTIONS(533),
    [anon_sym_ease] = ACTIONS(535),
    [anon_sym_ease_DASHin] = ACTIONS(535),
    [anon_sym_ease_in] = ACTIONS(535),
    [anon_sym_ease_in_out] = ACTIONS(535),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(535),
    [anon_sym_ease_out] = ACTIONS(535),
    [anon_sym_ease_DASHout] = ACTIONS(535),
    [anon_sym_start] = ACTIONS(535),
    [anon_sym_end] = ACTIONS(535),
    [anon_sym_black] = ACTIONS(535),
    [anon_sym_blue] = ACTIONS(535),
    [anon_sym_green] = ACTIONS(535),
    [anon_sym_red] = ACTIONS(535),
    [anon_sym_yellow] = ACTIONS(535),
    [anon_sym_white] = ACTIONS(535),
    [anon_sym_gray] = ACTIONS(535),
    [anon_sym_transparent] = ACTIONS(535),
    [anon_sym_angle] = ACTIONS(537),
    [anon_sym_bool] = ACTIONS(537),
    [anon_sym_brush] = ACTIONS(537),
    [anon_sym_color] = ACTIONS(537),
    [anon_sym_float] = ACTIONS(537),
    [anon_sym_image] = ACTIONS(537),
    [anon_sym_int] = ACTIONS(537),
    [anon_sym_length] = ACTIONS(537),
    [anon_sym_percent] = ACTIONS(537),
    [anon_sym_physical_DASHlength] = ACTIONS(537),
    [anon_sym_physical_length] = ACTIONS(537),
    [anon_sym_string] = ACTIONS(537),
    [anon_sym_debug] = ACTIONS(539),
    [anon_sym_animation_DASHtick] = ACTIONS(539),
    [anon_sym_min] = ACTIONS(539),
    [anon_sym_max] = ACTIONS(539),
    [anon_sym_mod] = ACTIONS(539),
    [anon_sym_abs] = ACTIONS(539),
    [anon_sym_round] = ACTIONS(539),
    [anon_sym_ceil] = ACTIONS(539),
    [anon_sym_floor] = ACTIONS(539),
    [anon_sym_sin] = ACTIONS(539),
    [anon_sym_cos] = ACTIONS(539),
    [anon_sym_tan] = ACTIONS(539),
    [anon_sym_asin] = ACTIONS(539),
    [anon_sym_acos] = ACTIONS(539),
    [anon_sym_atan] = ACTIONS(539),
    [anon_sym_sqrt] = ACTIONS(539),
    [anon_sym_pow] = ACTIONS(539),
    [anon_sym_log] = ACTIONS(539),
    [anon_sym_rgb] = ACTIONS(539),
    [anon_sym_easing] = ACTIONS(541),
    [anon_sym_duration] = ACTIONS(541),
    [anon_sym_parent] = ACTIONS(541),
    [anon_sym_root] = ACTIONS(541),
    [sym_comment] = ACTIONS(3),
  },
  [100] = {
    [sym_struct_block_definition] = STATE(385),
    [sym__expression] = STATE(385),
    [sym__all_expressions] = STATE(385),
    [sym_if_expression] = STATE(385),
    [sym_index_expression] = STATE(385),
    [sym_assign_expression] = STATE(385),
    [sym_comp_assign_expression] = STATE(385),
    [sym_call_expression] = STATE(385),
    [sym_field_expression] = STATE(385),
    [sym_bool_literal] = STATE(385),
    [sym_unary_expression] = STATE(385),
    [sym_binary_expression] = STATE(385),
    [sym_ternary_expression] = STATE(385),
    [sym__macro] = STATE(385),
    [sym__literal] = STATE(385),
    [sym_array_literal] = STATE(385),
    [sym_string_literal] = STATE(385),
    [sym_identifier] = STATE(385),
    [sym_color_literal] = STATE(385),
    [sym__number] = STATE(385),
    [sym_num_units] = STATE(385),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_RBRACK] = ACTIONS(616),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [101] = {
    [sym_struct_block_definition] = STATE(376),
    [sym__expression] = STATE(376),
    [sym__all_expressions] = STATE(376),
    [sym_if_expression] = STATE(376),
    [sym_index_expression] = STATE(376),
    [sym_assign_expression] = STATE(376),
    [sym_comp_assign_expression] = STATE(376),
    [sym_call_expression] = STATE(376),
    [sym_field_expression] = STATE(376),
    [sym_bool_literal] = STATE(376),
    [sym_unary_expression] = STATE(376),
    [sym_binary_expression] = STATE(376),
    [sym_ternary_expression] = STATE(376),
    [sym__macro] = STATE(376),
    [sym__literal] = STATE(376),
    [sym_array_literal] = STATE(376),
    [sym_string_literal] = STATE(376),
    [sym_identifier] = STATE(376),
    [sym_color_literal] = STATE(376),
    [sym__number] = STATE(376),
    [sym_num_units] = STATE(376),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_RPAREN] = ACTIONS(618),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [102] = {
    [sym_struct_block_definition] = STATE(378),
    [sym__expression] = STATE(378),
    [sym__all_expressions] = STATE(378),
    [sym_if_expression] = STATE(378),
    [sym_index_expression] = STATE(378),
    [sym_assign_expression] = STATE(378),
    [sym_comp_assign_expression] = STATE(378),
    [sym_call_expression] = STATE(378),
    [sym_field_expression] = STATE(378),
    [sym_bool_literal] = STATE(378),
    [sym_unary_expression] = STATE(378),
    [sym_binary_expression] = STATE(378),
    [sym_ternary_expression] = STATE(378),
    [sym__macro] = STATE(378),
    [sym__literal] = STATE(378),
    [sym_array_literal] = STATE(378),
    [sym_string_literal] = STATE(378),
    [sym_identifier] = STATE(378),
    [sym_color_literal] = STATE(378),
    [sym__number] = STATE(378),
    [sym_num_units] = STATE(378),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_RBRACK] = ACTIONS(620),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [103] = {
    [sym_struct_block_definition] = STATE(380),
    [sym__expression] = STATE(380),
    [sym__all_expressions] = STATE(380),
    [sym_if_expression] = STATE(380),
    [sym_index_expression] = STATE(380),
    [sym_assign_expression] = STATE(380),
    [sym_comp_assign_expression] = STATE(380),
    [sym_call_expression] = STATE(380),
    [sym_field_expression] = STATE(380),
    [sym_bool_literal] = STATE(380),
    [sym_unary_expression] = STATE(380),
    [sym_binary_expression] = STATE(380),
    [sym_ternary_expression] = STATE(380),
    [sym__macro] = STATE(380),
    [sym__literal] = STATE(380),
    [sym_array_literal] = STATE(380),
    [sym_string_literal] = STATE(380),
    [sym_identifier] = STATE(380),
    [sym_color_literal] = STATE(380),
    [sym__number] = STATE(380),
    [sym_num_units] = STATE(380),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_RBRACK] = ACTIONS(620),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [104] = {
    [sym_struct_block_definition] = STATE(7),
    [sym__expression] = STATE(7),
    [sym__all_expressions] = STATE(7),
    [sym_if_expression] = STATE(7),
    [sym_index_expression] = STATE(7),
    [sym_assign_expression] = STATE(7),
    [sym_comp_assign_expression] = STATE(7),
    [sym_call_expression] = STATE(7),
    [sym_field_expression] = STATE(7),
    [sym_bool_literal] = STATE(7),
    [sym_unary_expression] = STATE(7),
    [sym_binary_expression] = STATE(7),
    [sym_ternary_expression] = STATE(7),
    [sym__macro] = STATE(7),
    [sym__literal] = STATE(7),
    [sym_array_literal] = STATE(7),
    [sym_string_literal] = STATE(7),
    [sym_identifier] = STATE(7),
    [sym_color_literal] = STATE(7),
    [sym__number] = STATE(7),
    [sym_num_units] = STATE(7),
    [sym__builtin] = STATE(63),
    [sym_constant_builtin] = STATE(63),
    [sym_type_builtin] = STATE(63),
    [sym_function_builtin] = STATE(63),
    [sym_variable_builtin] = STATE(63),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_RPAREN] = ACTIONS(622),
    [anon_sym_true] = ACTIONS(519),
    [anon_sym_false] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [sym__ident_reg] = ACTIONS(527),
    [anon_sym_POUND] = ACTIONS(529),
    [sym_int_literal] = ACTIONS(531),
    [sym_float_literal] = ACTIONS(533),
    [anon_sym_ease] = ACTIONS(535),
    [anon_sym_ease_DASHin] = ACTIONS(535),
    [anon_sym_ease_in] = ACTIONS(535),
    [anon_sym_ease_in_out] = ACTIONS(535),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(535),
    [anon_sym_ease_out] = ACTIONS(535),
    [anon_sym_ease_DASHout] = ACTIONS(535),
    [anon_sym_start] = ACTIONS(535),
    [anon_sym_end] = ACTIONS(535),
    [anon_sym_black] = ACTIONS(535),
    [anon_sym_blue] = ACTIONS(535),
    [anon_sym_green] = ACTIONS(535),
    [anon_sym_red] = ACTIONS(535),
    [anon_sym_yellow] = ACTIONS(535),
    [anon_sym_white] = ACTIONS(535),
    [anon_sym_gray] = ACTIONS(535),
    [anon_sym_transparent] = ACTIONS(535),
    [anon_sym_angle] = ACTIONS(537),
    [anon_sym_bool] = ACTIONS(537),
    [anon_sym_brush] = ACTIONS(537),
    [anon_sym_color] = ACTIONS(537),
    [anon_sym_float] = ACTIONS(537),
    [anon_sym_image] = ACTIONS(537),
    [anon_sym_int] = ACTIONS(537),
    [anon_sym_length] = ACTIONS(537),
    [anon_sym_percent] = ACTIONS(537),
    [anon_sym_physical_DASHlength] = ACTIONS(537),
    [anon_sym_physical_length] = ACTIONS(537),
    [anon_sym_string] = ACTIONS(537),
    [anon_sym_debug] = ACTIONS(539),
    [anon_sym_animation_DASHtick] = ACTIONS(539),
    [anon_sym_min] = ACTIONS(539),
    [anon_sym_max] = ACTIONS(539),
    [anon_sym_mod] = ACTIONS(539),
    [anon_sym_abs] = ACTIONS(539),
    [anon_sym_round] = ACTIONS(539),
    [anon_sym_ceil] = ACTIONS(539),
    [anon_sym_floor] = ACTIONS(539),
    [anon_sym_sin] = ACTIONS(539),
    [anon_sym_cos] = ACTIONS(539),
    [anon_sym_tan] = ACTIONS(539),
    [anon_sym_asin] = ACTIONS(539),
    [anon_sym_acos] = ACTIONS(539),
    [anon_sym_atan] = ACTIONS(539),
    [anon_sym_sqrt] = ACTIONS(539),
    [anon_sym_pow] = ACTIONS(539),
    [anon_sym_log] = ACTIONS(539),
    [anon_sym_rgb] = ACTIONS(539),
    [anon_sym_easing] = ACTIONS(541),
    [anon_sym_duration] = ACTIONS(541),
    [anon_sym_parent] = ACTIONS(541),
    [anon_sym_root] = ACTIONS(541),
    [sym_comment] = ACTIONS(3),
  },
  [105] = {
    [sym_struct_block_definition] = STATE(8),
    [sym__expression] = STATE(8),
    [sym__all_expressions] = STATE(8),
    [sym_if_expression] = STATE(8),
    [sym_index_expression] = STATE(8),
    [sym_assign_expression] = STATE(8),
    [sym_comp_assign_expression] = STATE(8),
    [sym_call_expression] = STATE(8),
    [sym_field_expression] = STATE(8),
    [sym_bool_literal] = STATE(8),
    [sym_unary_expression] = STATE(8),
    [sym_binary_expression] = STATE(8),
    [sym_ternary_expression] = STATE(8),
    [sym__macro] = STATE(8),
    [sym__literal] = STATE(8),
    [sym_array_literal] = STATE(8),
    [sym_string_literal] = STATE(8),
    [sym_identifier] = STATE(8),
    [sym_color_literal] = STATE(8),
    [sym__number] = STATE(8),
    [sym_num_units] = STATE(8),
    [sym__builtin] = STATE(63),
    [sym_constant_builtin] = STATE(63),
    [sym_type_builtin] = STATE(63),
    [sym_function_builtin] = STATE(63),
    [sym_variable_builtin] = STATE(63),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_RPAREN] = ACTIONS(624),
    [anon_sym_true] = ACTIONS(519),
    [anon_sym_false] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [sym__ident_reg] = ACTIONS(527),
    [anon_sym_POUND] = ACTIONS(529),
    [sym_int_literal] = ACTIONS(531),
    [sym_float_literal] = ACTIONS(533),
    [anon_sym_ease] = ACTIONS(535),
    [anon_sym_ease_DASHin] = ACTIONS(535),
    [anon_sym_ease_in] = ACTIONS(535),
    [anon_sym_ease_in_out] = ACTIONS(535),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(535),
    [anon_sym_ease_out] = ACTIONS(535),
    [anon_sym_ease_DASHout] = ACTIONS(535),
    [anon_sym_start] = ACTIONS(535),
    [anon_sym_end] = ACTIONS(535),
    [anon_sym_black] = ACTIONS(535),
    [anon_sym_blue] = ACTIONS(535),
    [anon_sym_green] = ACTIONS(535),
    [anon_sym_red] = ACTIONS(535),
    [anon_sym_yellow] = ACTIONS(535),
    [anon_sym_white] = ACTIONS(535),
    [anon_sym_gray] = ACTIONS(535),
    [anon_sym_transparent] = ACTIONS(535),
    [anon_sym_angle] = ACTIONS(537),
    [anon_sym_bool] = ACTIONS(537),
    [anon_sym_brush] = ACTIONS(537),
    [anon_sym_color] = ACTIONS(537),
    [anon_sym_float] = ACTIONS(537),
    [anon_sym_image] = ACTIONS(537),
    [anon_sym_int] = ACTIONS(537),
    [anon_sym_length] = ACTIONS(537),
    [anon_sym_percent] = ACTIONS(537),
    [anon_sym_physical_DASHlength] = ACTIONS(537),
    [anon_sym_physical_length] = ACTIONS(537),
    [anon_sym_string] = ACTIONS(537),
    [anon_sym_debug] = ACTIONS(539),
    [anon_sym_animation_DASHtick] = ACTIONS(539),
    [anon_sym_min] = ACTIONS(539),
    [anon_sym_max] = ACTIONS(539),
    [anon_sym_mod] = ACTIONS(539),
    [anon_sym_abs] = ACTIONS(539),
    [anon_sym_round] = ACTIONS(539),
    [anon_sym_ceil] = ACTIONS(539),
    [anon_sym_floor] = ACTIONS(539),
    [anon_sym_sin] = ACTIONS(539),
    [anon_sym_cos] = ACTIONS(539),
    [anon_sym_tan] = ACTIONS(539),
    [anon_sym_asin] = ACTIONS(539),
    [anon_sym_acos] = ACTIONS(539),
    [anon_sym_atan] = ACTIONS(539),
    [anon_sym_sqrt] = ACTIONS(539),
    [anon_sym_pow] = ACTIONS(539),
    [anon_sym_log] = ACTIONS(539),
    [anon_sym_rgb] = ACTIONS(539),
    [anon_sym_easing] = ACTIONS(541),
    [anon_sym_duration] = ACTIONS(541),
    [anon_sym_parent] = ACTIONS(541),
    [anon_sym_root] = ACTIONS(541),
    [sym_comment] = ACTIONS(3),
  },
  [106] = {
    [sym_struct_block_definition] = STATE(6),
    [sym__expression] = STATE(6),
    [sym__all_expressions] = STATE(6),
    [sym_if_expression] = STATE(6),
    [sym_index_expression] = STATE(6),
    [sym_assign_expression] = STATE(6),
    [sym_comp_assign_expression] = STATE(6),
    [sym_call_expression] = STATE(6),
    [sym_field_expression] = STATE(6),
    [sym_bool_literal] = STATE(6),
    [sym_unary_expression] = STATE(6),
    [sym_binary_expression] = STATE(6),
    [sym_ternary_expression] = STATE(6),
    [sym__macro] = STATE(6),
    [sym__literal] = STATE(6),
    [sym_array_literal] = STATE(6),
    [sym_string_literal] = STATE(6),
    [sym_identifier] = STATE(6),
    [sym_color_literal] = STATE(6),
    [sym__number] = STATE(6),
    [sym_num_units] = STATE(6),
    [sym__builtin] = STATE(63),
    [sym_constant_builtin] = STATE(63),
    [sym_type_builtin] = STATE(63),
    [sym_function_builtin] = STATE(63),
    [sym_variable_builtin] = STATE(63),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_RPAREN] = ACTIONS(626),
    [anon_sym_true] = ACTIONS(519),
    [anon_sym_false] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [sym__ident_reg] = ACTIONS(527),
    [anon_sym_POUND] = ACTIONS(529),
    [sym_int_literal] = ACTIONS(531),
    [sym_float_literal] = ACTIONS(533),
    [anon_sym_ease] = ACTIONS(535),
    [anon_sym_ease_DASHin] = ACTIONS(535),
    [anon_sym_ease_in] = ACTIONS(535),
    [anon_sym_ease_in_out] = ACTIONS(535),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(535),
    [anon_sym_ease_out] = ACTIONS(535),
    [anon_sym_ease_DASHout] = ACTIONS(535),
    [anon_sym_start] = ACTIONS(535),
    [anon_sym_end] = ACTIONS(535),
    [anon_sym_black] = ACTIONS(535),
    [anon_sym_blue] = ACTIONS(535),
    [anon_sym_green] = ACTIONS(535),
    [anon_sym_red] = ACTIONS(535),
    [anon_sym_yellow] = ACTIONS(535),
    [anon_sym_white] = ACTIONS(535),
    [anon_sym_gray] = ACTIONS(535),
    [anon_sym_transparent] = ACTIONS(535),
    [anon_sym_angle] = ACTIONS(537),
    [anon_sym_bool] = ACTIONS(537),
    [anon_sym_brush] = ACTIONS(537),
    [anon_sym_color] = ACTIONS(537),
    [anon_sym_float] = ACTIONS(537),
    [anon_sym_image] = ACTIONS(537),
    [anon_sym_int] = ACTIONS(537),
    [anon_sym_length] = ACTIONS(537),
    [anon_sym_percent] = ACTIONS(537),
    [anon_sym_physical_DASHlength] = ACTIONS(537),
    [anon_sym_physical_length] = ACTIONS(537),
    [anon_sym_string] = ACTIONS(537),
    [anon_sym_debug] = ACTIONS(539),
    [anon_sym_animation_DASHtick] = ACTIONS(539),
    [anon_sym_min] = ACTIONS(539),
    [anon_sym_max] = ACTIONS(539),
    [anon_sym_mod] = ACTIONS(539),
    [anon_sym_abs] = ACTIONS(539),
    [anon_sym_round] = ACTIONS(539),
    [anon_sym_ceil] = ACTIONS(539),
    [anon_sym_floor] = ACTIONS(539),
    [anon_sym_sin] = ACTIONS(539),
    [anon_sym_cos] = ACTIONS(539),
    [anon_sym_tan] = ACTIONS(539),
    [anon_sym_asin] = ACTIONS(539),
    [anon_sym_acos] = ACTIONS(539),
    [anon_sym_atan] = ACTIONS(539),
    [anon_sym_sqrt] = ACTIONS(539),
    [anon_sym_pow] = ACTIONS(539),
    [anon_sym_log] = ACTIONS(539),
    [anon_sym_rgb] = ACTIONS(539),
    [anon_sym_easing] = ACTIONS(541),
    [anon_sym_duration] = ACTIONS(541),
    [anon_sym_parent] = ACTIONS(541),
    [anon_sym_root] = ACTIONS(541),
    [sym_comment] = ACTIONS(3),
  },
  [107] = {
    [sym_struct_block_definition] = STATE(376),
    [sym__expression] = STATE(376),
    [sym__all_expressions] = STATE(376),
    [sym_if_expression] = STATE(376),
    [sym_index_expression] = STATE(376),
    [sym_assign_expression] = STATE(376),
    [sym_comp_assign_expression] = STATE(376),
    [sym_call_expression] = STATE(376),
    [sym_field_expression] = STATE(376),
    [sym_bool_literal] = STATE(376),
    [sym_unary_expression] = STATE(376),
    [sym_binary_expression] = STATE(376),
    [sym_ternary_expression] = STATE(376),
    [sym__macro] = STATE(376),
    [sym__literal] = STATE(376),
    [sym_array_literal] = STATE(376),
    [sym_string_literal] = STATE(376),
    [sym_identifier] = STATE(376),
    [sym_color_literal] = STATE(376),
    [sym__number] = STATE(376),
    [sym_num_units] = STATE(376),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_RPAREN] = ACTIONS(618),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [108] = {
    [sym_struct_block_definition] = STATE(9),
    [sym__expression] = STATE(9),
    [sym__all_expressions] = STATE(9),
    [sym_if_expression] = STATE(9),
    [sym_index_expression] = STATE(9),
    [sym_assign_expression] = STATE(9),
    [sym_comp_assign_expression] = STATE(9),
    [sym_call_expression] = STATE(9),
    [sym_field_expression] = STATE(9),
    [sym_bool_literal] = STATE(9),
    [sym_unary_expression] = STATE(9),
    [sym_binary_expression] = STATE(9),
    [sym_ternary_expression] = STATE(9),
    [sym__macro] = STATE(9),
    [sym__literal] = STATE(9),
    [sym_array_literal] = STATE(9),
    [sym_string_literal] = STATE(9),
    [sym_identifier] = STATE(9),
    [sym_color_literal] = STATE(9),
    [sym__number] = STATE(9),
    [sym_num_units] = STATE(9),
    [sym__builtin] = STATE(63),
    [sym_constant_builtin] = STATE(63),
    [sym_type_builtin] = STATE(63),
    [sym_function_builtin] = STATE(63),
    [sym_variable_builtin] = STATE(63),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_RPAREN] = ACTIONS(628),
    [anon_sym_true] = ACTIONS(519),
    [anon_sym_false] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [sym__ident_reg] = ACTIONS(527),
    [anon_sym_POUND] = ACTIONS(529),
    [sym_int_literal] = ACTIONS(531),
    [sym_float_literal] = ACTIONS(533),
    [anon_sym_ease] = ACTIONS(535),
    [anon_sym_ease_DASHin] = ACTIONS(535),
    [anon_sym_ease_in] = ACTIONS(535),
    [anon_sym_ease_in_out] = ACTIONS(535),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(535),
    [anon_sym_ease_out] = ACTIONS(535),
    [anon_sym_ease_DASHout] = ACTIONS(535),
    [anon_sym_start] = ACTIONS(535),
    [anon_sym_end] = ACTIONS(535),
    [anon_sym_black] = ACTIONS(535),
    [anon_sym_blue] = ACTIONS(535),
    [anon_sym_green] = ACTIONS(535),
    [anon_sym_red] = ACTIONS(535),
    [anon_sym_yellow] = ACTIONS(535),
    [anon_sym_white] = ACTIONS(535),
    [anon_sym_gray] = ACTIONS(535),
    [anon_sym_transparent] = ACTIONS(535),
    [anon_sym_angle] = ACTIONS(537),
    [anon_sym_bool] = ACTIONS(537),
    [anon_sym_brush] = ACTIONS(537),
    [anon_sym_color] = ACTIONS(537),
    [anon_sym_float] = ACTIONS(537),
    [anon_sym_image] = ACTIONS(537),
    [anon_sym_int] = ACTIONS(537),
    [anon_sym_length] = ACTIONS(537),
    [anon_sym_percent] = ACTIONS(537),
    [anon_sym_physical_DASHlength] = ACTIONS(537),
    [anon_sym_physical_length] = ACTIONS(537),
    [anon_sym_string] = ACTIONS(537),
    [anon_sym_debug] = ACTIONS(539),
    [anon_sym_animation_DASHtick] = ACTIONS(539),
    [anon_sym_min] = ACTIONS(539),
    [anon_sym_max] = ACTIONS(539),
    [anon_sym_mod] = ACTIONS(539),
    [anon_sym_abs] = ACTIONS(539),
    [anon_sym_round] = ACTIONS(539),
    [anon_sym_ceil] = ACTIONS(539),
    [anon_sym_floor] = ACTIONS(539),
    [anon_sym_sin] = ACTIONS(539),
    [anon_sym_cos] = ACTIONS(539),
    [anon_sym_tan] = ACTIONS(539),
    [anon_sym_asin] = ACTIONS(539),
    [anon_sym_acos] = ACTIONS(539),
    [anon_sym_atan] = ACTIONS(539),
    [anon_sym_sqrt] = ACTIONS(539),
    [anon_sym_pow] = ACTIONS(539),
    [anon_sym_log] = ACTIONS(539),
    [anon_sym_rgb] = ACTIONS(539),
    [anon_sym_easing] = ACTIONS(541),
    [anon_sym_duration] = ACTIONS(541),
    [anon_sym_parent] = ACTIONS(541),
    [anon_sym_root] = ACTIONS(541),
    [sym_comment] = ACTIONS(3),
  },
  [109] = {
    [sym_struct_block_definition] = STATE(382),
    [sym__expression] = STATE(382),
    [sym__all_expressions] = STATE(382),
    [sym_if_expression] = STATE(382),
    [sym_index_expression] = STATE(382),
    [sym_assign_expression] = STATE(382),
    [sym_comp_assign_expression] = STATE(382),
    [sym_call_expression] = STATE(382),
    [sym_field_expression] = STATE(382),
    [sym_bool_literal] = STATE(382),
    [sym_unary_expression] = STATE(382),
    [sym_binary_expression] = STATE(382),
    [sym_ternary_expression] = STATE(382),
    [sym__macro] = STATE(382),
    [sym__literal] = STATE(382),
    [sym_array_literal] = STATE(382),
    [sym_string_literal] = STATE(382),
    [sym_identifier] = STATE(382),
    [sym_color_literal] = STATE(382),
    [sym__number] = STATE(382),
    [sym_num_units] = STATE(382),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(630),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_STAR] = ACTIONS(632),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [110] = {
    [sym_struct_block_definition] = STATE(80),
    [sym__expression] = STATE(80),
    [sym__all_expressions] = STATE(80),
    [sym_if_expression] = STATE(80),
    [sym_index_expression] = STATE(80),
    [sym_assign_expression] = STATE(80),
    [sym_comp_assign_expression] = STATE(80),
    [sym_call_expression] = STATE(80),
    [sym_field_expression] = STATE(80),
    [sym_bool_literal] = STATE(80),
    [sym_unary_expression] = STATE(80),
    [sym_binary_expression] = STATE(80),
    [sym_ternary_expression] = STATE(80),
    [sym__macro] = STATE(80),
    [sym__literal] = STATE(80),
    [sym_array_literal] = STATE(80),
    [sym_string_literal] = STATE(80),
    [sym_identifier] = STATE(80),
    [sym_color_literal] = STATE(80),
    [sym__number] = STATE(80),
    [sym_num_units] = STATE(80),
    [sym__builtin] = STATE(63),
    [sym_constant_builtin] = STATE(63),
    [sym_type_builtin] = STATE(63),
    [sym_function_builtin] = STATE(63),
    [sym_variable_builtin] = STATE(63),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_true] = ACTIONS(519),
    [anon_sym_false] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [sym__ident_reg] = ACTIONS(527),
    [anon_sym_POUND] = ACTIONS(529),
    [sym_int_literal] = ACTIONS(531),
    [sym_float_literal] = ACTIONS(533),
    [anon_sym_ease] = ACTIONS(535),
    [anon_sym_ease_DASHin] = ACTIONS(535),
    [anon_sym_ease_in] = ACTIONS(535),
    [anon_sym_ease_in_out] = ACTIONS(535),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(535),
    [anon_sym_ease_out] = ACTIONS(535),
    [anon_sym_ease_DASHout] = ACTIONS(535),
    [anon_sym_start] = ACTIONS(535),
    [anon_sym_end] = ACTIONS(535),
    [anon_sym_black] = ACTIONS(535),
    [anon_sym_blue] = ACTIONS(535),
    [anon_sym_green] = ACTIONS(535),
    [anon_sym_red] = ACTIONS(535),
    [anon_sym_yellow] = ACTIONS(535),
    [anon_sym_white] = ACTIONS(535),
    [anon_sym_gray] = ACTIONS(535),
    [anon_sym_transparent] = ACTIONS(535),
    [anon_sym_angle] = ACTIONS(537),
    [anon_sym_bool] = ACTIONS(537),
    [anon_sym_brush] = ACTIONS(537),
    [anon_sym_color] = ACTIONS(537),
    [anon_sym_float] = ACTIONS(537),
    [anon_sym_image] = ACTIONS(537),
    [anon_sym_int] = ACTIONS(537),
    [anon_sym_length] = ACTIONS(537),
    [anon_sym_percent] = ACTIONS(537),
    [anon_sym_physical_DASHlength] = ACTIONS(537),
    [anon_sym_physical_length] = ACTIONS(537),
    [anon_sym_string] = ACTIONS(537),
    [anon_sym_debug] = ACTIONS(539),
    [anon_sym_animation_DASHtick] = ACTIONS(539),
    [anon_sym_min] = ACTIONS(539),
    [anon_sym_max] = ACTIONS(539),
    [anon_sym_mod] = ACTIONS(539),
    [anon_sym_abs] = ACTIONS(539),
    [anon_sym_round] = ACTIONS(539),
    [anon_sym_ceil] = ACTIONS(539),
    [anon_sym_floor] = ACTIONS(539),
    [anon_sym_sin] = ACTIONS(539),
    [anon_sym_cos] = ACTIONS(539),
    [anon_sym_tan] = ACTIONS(539),
    [anon_sym_asin] = ACTIONS(539),
    [anon_sym_acos] = ACTIONS(539),
    [anon_sym_atan] = ACTIONS(539),
    [anon_sym_sqrt] = ACTIONS(539),
    [anon_sym_pow] = ACTIONS(539),
    [anon_sym_log] = ACTIONS(539),
    [anon_sym_rgb] = ACTIONS(539),
    [anon_sym_easing] = ACTIONS(541),
    [anon_sym_duration] = ACTIONS(541),
    [anon_sym_parent] = ACTIONS(541),
    [anon_sym_root] = ACTIONS(541),
    [sym_comment] = ACTIONS(3),
  },
  [111] = {
    [sym_struct_block_definition] = STATE(79),
    [sym__expression] = STATE(79),
    [sym__all_expressions] = STATE(79),
    [sym_if_expression] = STATE(79),
    [sym_index_expression] = STATE(79),
    [sym_assign_expression] = STATE(79),
    [sym_comp_assign_expression] = STATE(79),
    [sym_call_expression] = STATE(79),
    [sym_field_expression] = STATE(79),
    [sym_bool_literal] = STATE(79),
    [sym_unary_expression] = STATE(79),
    [sym_binary_expression] = STATE(79),
    [sym_ternary_expression] = STATE(79),
    [sym__macro] = STATE(79),
    [sym__literal] = STATE(79),
    [sym_array_literal] = STATE(79),
    [sym_string_literal] = STATE(79),
    [sym_identifier] = STATE(79),
    [sym_color_literal] = STATE(79),
    [sym__number] = STATE(79),
    [sym_num_units] = STATE(79),
    [sym__builtin] = STATE(63),
    [sym_constant_builtin] = STATE(63),
    [sym_type_builtin] = STATE(63),
    [sym_function_builtin] = STATE(63),
    [sym_variable_builtin] = STATE(63),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_LT] = ACTIONS(636),
    [anon_sym_true] = ACTIONS(519),
    [anon_sym_false] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [sym__ident_reg] = ACTIONS(527),
    [anon_sym_POUND] = ACTIONS(529),
    [sym_int_literal] = ACTIONS(531),
    [sym_float_literal] = ACTIONS(533),
    [anon_sym_ease] = ACTIONS(535),
    [anon_sym_ease_DASHin] = ACTIONS(535),
    [anon_sym_ease_in] = ACTIONS(535),
    [anon_sym_ease_in_out] = ACTIONS(535),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(535),
    [anon_sym_ease_out] = ACTIONS(535),
    [anon_sym_ease_DASHout] = ACTIONS(535),
    [anon_sym_start] = ACTIONS(535),
    [anon_sym_end] = ACTIONS(535),
    [anon_sym_black] = ACTIONS(535),
    [anon_sym_blue] = ACTIONS(535),
    [anon_sym_green] = ACTIONS(535),
    [anon_sym_red] = ACTIONS(535),
    [anon_sym_yellow] = ACTIONS(535),
    [anon_sym_white] = ACTIONS(535),
    [anon_sym_gray] = ACTIONS(535),
    [anon_sym_transparent] = ACTIONS(535),
    [anon_sym_angle] = ACTIONS(537),
    [anon_sym_bool] = ACTIONS(537),
    [anon_sym_brush] = ACTIONS(537),
    [anon_sym_color] = ACTIONS(537),
    [anon_sym_float] = ACTIONS(537),
    [anon_sym_image] = ACTIONS(537),
    [anon_sym_int] = ACTIONS(537),
    [anon_sym_length] = ACTIONS(537),
    [anon_sym_percent] = ACTIONS(537),
    [anon_sym_physical_DASHlength] = ACTIONS(537),
    [anon_sym_physical_length] = ACTIONS(537),
    [anon_sym_string] = ACTIONS(537),
    [anon_sym_debug] = ACTIONS(539),
    [anon_sym_animation_DASHtick] = ACTIONS(539),
    [anon_sym_min] = ACTIONS(539),
    [anon_sym_max] = ACTIONS(539),
    [anon_sym_mod] = ACTIONS(539),
    [anon_sym_abs] = ACTIONS(539),
    [anon_sym_round] = ACTIONS(539),
    [anon_sym_ceil] = ACTIONS(539),
    [anon_sym_floor] = ACTIONS(539),
    [anon_sym_sin] = ACTIONS(539),
    [anon_sym_cos] = ACTIONS(539),
    [anon_sym_tan] = ACTIONS(539),
    [anon_sym_asin] = ACTIONS(539),
    [anon_sym_acos] = ACTIONS(539),
    [anon_sym_atan] = ACTIONS(539),
    [anon_sym_sqrt] = ACTIONS(539),
    [anon_sym_pow] = ACTIONS(539),
    [anon_sym_log] = ACTIONS(539),
    [anon_sym_rgb] = ACTIONS(539),
    [anon_sym_easing] = ACTIONS(541),
    [anon_sym_duration] = ACTIONS(541),
    [anon_sym_parent] = ACTIONS(541),
    [anon_sym_root] = ACTIONS(541),
    [sym_comment] = ACTIONS(3),
  },
  [112] = {
    [sym_struct_block_definition] = STATE(387),
    [sym__expression] = STATE(387),
    [sym__all_expressions] = STATE(387),
    [sym_if_expression] = STATE(387),
    [sym_index_expression] = STATE(387),
    [sym_assign_expression] = STATE(387),
    [sym_comp_assign_expression] = STATE(387),
    [sym_call_expression] = STATE(387),
    [sym_field_expression] = STATE(387),
    [sym_bool_literal] = STATE(387),
    [sym_unary_expression] = STATE(387),
    [sym_binary_expression] = STATE(387),
    [sym_ternary_expression] = STATE(387),
    [sym__macro] = STATE(387),
    [sym__literal] = STATE(387),
    [sym_array_literal] = STATE(387),
    [sym_string_literal] = STATE(387),
    [sym_identifier] = STATE(387),
    [sym_color_literal] = STATE(387),
    [sym__number] = STATE(387),
    [sym_num_units] = STATE(387),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_RPAREN] = ACTIONS(638),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [113] = {
    [sym_struct_block_definition] = STATE(374),
    [sym__expression] = STATE(374),
    [sym__all_expressions] = STATE(374),
    [sym_if_expression] = STATE(374),
    [sym_index_expression] = STATE(374),
    [sym_assign_expression] = STATE(374),
    [sym_comp_assign_expression] = STATE(374),
    [sym_call_expression] = STATE(374),
    [sym_field_expression] = STATE(374),
    [sym_bool_literal] = STATE(374),
    [sym_unary_expression] = STATE(374),
    [sym_binary_expression] = STATE(374),
    [sym_ternary_expression] = STATE(374),
    [sym__macro] = STATE(374),
    [sym__literal] = STATE(374),
    [sym_array_literal] = STATE(374),
    [sym_string_literal] = STATE(374),
    [sym_identifier] = STATE(374),
    [sym_color_literal] = STATE(374),
    [sym__number] = STATE(374),
    [sym_num_units] = STATE(374),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(640),
    [anon_sym_COMMA] = ACTIONS(505),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [114] = {
    [sym_struct_block_definition] = STATE(382),
    [sym__expression] = STATE(382),
    [sym__all_expressions] = STATE(382),
    [sym_if_expression] = STATE(382),
    [sym_index_expression] = STATE(382),
    [sym_assign_expression] = STATE(382),
    [sym_comp_assign_expression] = STATE(382),
    [sym_call_expression] = STATE(382),
    [sym_field_expression] = STATE(382),
    [sym_bool_literal] = STATE(382),
    [sym_unary_expression] = STATE(382),
    [sym_binary_expression] = STATE(382),
    [sym_ternary_expression] = STATE(382),
    [sym__macro] = STATE(382),
    [sym__literal] = STATE(382),
    [sym_array_literal] = STATE(382),
    [sym_string_literal] = STATE(382),
    [sym_identifier] = STATE(382),
    [sym_color_literal] = STATE(382),
    [sym__number] = STATE(382),
    [sym_num_units] = STATE(382),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(643),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_STAR] = ACTIONS(632),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [115] = {
    [sym_struct_block_definition] = STATE(428),
    [sym__expression] = STATE(428),
    [sym__all_expressions] = STATE(428),
    [sym_if_expression] = STATE(428),
    [sym_index_expression] = STATE(428),
    [sym_assign_expression] = STATE(428),
    [sym_comp_assign_expression] = STATE(428),
    [sym_call_expression] = STATE(428),
    [sym_field_expression] = STATE(428),
    [sym_bool_literal] = STATE(428),
    [sym_unary_expression] = STATE(428),
    [sym_binary_expression] = STATE(428),
    [sym_ternary_expression] = STATE(428),
    [sym__macro] = STATE(428),
    [sym__literal] = STATE(428),
    [sym_array_literal] = STATE(428),
    [sym_string_literal] = STATE(428),
    [sym_identifier] = STATE(428),
    [sym_color_literal] = STATE(428),
    [sym__number] = STATE(428),
    [sym_num_units] = STATE(428),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(645),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [116] = {
    [sym_struct_block_definition] = STATE(337),
    [sym__expression] = STATE(337),
    [sym__all_expressions] = STATE(337),
    [sym_if_expression] = STATE(337),
    [sym_index_expression] = STATE(337),
    [sym_assign_expression] = STATE(337),
    [sym_comp_assign_expression] = STATE(337),
    [sym_call_expression] = STATE(337),
    [sym_field_expression] = STATE(337),
    [sym_bool_literal] = STATE(337),
    [sym_unary_expression] = STATE(337),
    [sym_binary_expression] = STATE(337),
    [sym_ternary_expression] = STATE(337),
    [sym__macro] = STATE(337),
    [sym__literal] = STATE(337),
    [sym_array_literal] = STATE(337),
    [sym_string_literal] = STATE(337),
    [sym_identifier] = STATE(337),
    [sym_color_literal] = STATE(337),
    [sym__number] = STATE(337),
    [sym_num_units] = STATE(337),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [117] = {
    [sym_struct_block_definition] = STATE(35),
    [sym__expression] = STATE(35),
    [sym__all_expressions] = STATE(35),
    [sym_if_expression] = STATE(35),
    [sym_index_expression] = STATE(35),
    [sym_assign_expression] = STATE(35),
    [sym_comp_assign_expression] = STATE(35),
    [sym_call_expression] = STATE(35),
    [sym_field_expression] = STATE(35),
    [sym_bool_literal] = STATE(35),
    [sym_unary_expression] = STATE(35),
    [sym_binary_expression] = STATE(35),
    [sym_ternary_expression] = STATE(35),
    [sym__macro] = STATE(35),
    [sym__literal] = STATE(35),
    [sym_array_literal] = STATE(35),
    [sym_string_literal] = STATE(35),
    [sym_identifier] = STATE(35),
    [sym_color_literal] = STATE(35),
    [sym__number] = STATE(35),
    [sym_num_units] = STATE(35),
    [sym__builtin] = STATE(63),
    [sym_constant_builtin] = STATE(63),
    [sym_type_builtin] = STATE(63),
    [sym_function_builtin] = STATE(63),
    [sym_variable_builtin] = STATE(63),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_true] = ACTIONS(519),
    [anon_sym_false] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [sym__ident_reg] = ACTIONS(527),
    [anon_sym_POUND] = ACTIONS(529),
    [sym_int_literal] = ACTIONS(531),
    [sym_float_literal] = ACTIONS(533),
    [anon_sym_ease] = ACTIONS(535),
    [anon_sym_ease_DASHin] = ACTIONS(535),
    [anon_sym_ease_in] = ACTIONS(535),
    [anon_sym_ease_in_out] = ACTIONS(535),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(535),
    [anon_sym_ease_out] = ACTIONS(535),
    [anon_sym_ease_DASHout] = ACTIONS(535),
    [anon_sym_start] = ACTIONS(535),
    [anon_sym_end] = ACTIONS(535),
    [anon_sym_black] = ACTIONS(535),
    [anon_sym_blue] = ACTIONS(535),
    [anon_sym_green] = ACTIONS(535),
    [anon_sym_red] = ACTIONS(535),
    [anon_sym_yellow] = ACTIONS(535),
    [anon_sym_white] = ACTIONS(535),
    [anon_sym_gray] = ACTIONS(535),
    [anon_sym_transparent] = ACTIONS(535),
    [anon_sym_angle] = ACTIONS(537),
    [anon_sym_bool] = ACTIONS(537),
    [anon_sym_brush] = ACTIONS(537),
    [anon_sym_color] = ACTIONS(537),
    [anon_sym_float] = ACTIONS(537),
    [anon_sym_image] = ACTIONS(537),
    [anon_sym_int] = ACTIONS(537),
    [anon_sym_length] = ACTIONS(537),
    [anon_sym_percent] = ACTIONS(537),
    [anon_sym_physical_DASHlength] = ACTIONS(537),
    [anon_sym_physical_length] = ACTIONS(537),
    [anon_sym_string] = ACTIONS(537),
    [anon_sym_debug] = ACTIONS(539),
    [anon_sym_animation_DASHtick] = ACTIONS(539),
    [anon_sym_min] = ACTIONS(539),
    [anon_sym_max] = ACTIONS(539),
    [anon_sym_mod] = ACTIONS(539),
    [anon_sym_abs] = ACTIONS(539),
    [anon_sym_round] = ACTIONS(539),
    [anon_sym_ceil] = ACTIONS(539),
    [anon_sym_floor] = ACTIONS(539),
    [anon_sym_sin] = ACTIONS(539),
    [anon_sym_cos] = ACTIONS(539),
    [anon_sym_tan] = ACTIONS(539),
    [anon_sym_asin] = ACTIONS(539),
    [anon_sym_acos] = ACTIONS(539),
    [anon_sym_atan] = ACTIONS(539),
    [anon_sym_sqrt] = ACTIONS(539),
    [anon_sym_pow] = ACTIONS(539),
    [anon_sym_log] = ACTIONS(539),
    [anon_sym_rgb] = ACTIONS(539),
    [anon_sym_easing] = ACTIONS(541),
    [anon_sym_duration] = ACTIONS(541),
    [anon_sym_parent] = ACTIONS(541),
    [anon_sym_root] = ACTIONS(541),
    [sym_comment] = ACTIONS(3),
  },
  [118] = {
    [sym_struct_block_definition] = STATE(414),
    [sym__expression] = STATE(414),
    [sym__all_expressions] = STATE(414),
    [sym_if_expression] = STATE(414),
    [sym_index_expression] = STATE(414),
    [sym_assign_expression] = STATE(414),
    [sym_comp_assign_expression] = STATE(414),
    [sym_call_expression] = STATE(414),
    [sym_field_expression] = STATE(414),
    [sym_bool_literal] = STATE(414),
    [sym_unary_expression] = STATE(414),
    [sym_binary_expression] = STATE(414),
    [sym_ternary_expression] = STATE(414),
    [sym__macro] = STATE(414),
    [sym__literal] = STATE(414),
    [sym_array_literal] = STATE(414),
    [sym_string_literal] = STATE(414),
    [sym_identifier] = STATE(414),
    [sym_color_literal] = STATE(414),
    [sym__number] = STATE(414),
    [sym_num_units] = STATE(414),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [119] = {
    [sym_struct_block_definition] = STATE(37),
    [sym__expression] = STATE(37),
    [sym__all_expressions] = STATE(37),
    [sym_if_expression] = STATE(37),
    [sym_index_expression] = STATE(37),
    [sym_assign_expression] = STATE(37),
    [sym_comp_assign_expression] = STATE(37),
    [sym_call_expression] = STATE(37),
    [sym_field_expression] = STATE(37),
    [sym_bool_literal] = STATE(37),
    [sym_unary_expression] = STATE(37),
    [sym_binary_expression] = STATE(37),
    [sym_ternary_expression] = STATE(37),
    [sym__macro] = STATE(37),
    [sym__literal] = STATE(37),
    [sym_array_literal] = STATE(37),
    [sym_string_literal] = STATE(37),
    [sym_identifier] = STATE(37),
    [sym_color_literal] = STATE(37),
    [sym__number] = STATE(37),
    [sym_num_units] = STATE(37),
    [sym__builtin] = STATE(63),
    [sym_constant_builtin] = STATE(63),
    [sym_type_builtin] = STATE(63),
    [sym_function_builtin] = STATE(63),
    [sym_variable_builtin] = STATE(63),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_true] = ACTIONS(519),
    [anon_sym_false] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [sym__ident_reg] = ACTIONS(527),
    [anon_sym_POUND] = ACTIONS(529),
    [sym_int_literal] = ACTIONS(531),
    [sym_float_literal] = ACTIONS(533),
    [anon_sym_ease] = ACTIONS(535),
    [anon_sym_ease_DASHin] = ACTIONS(535),
    [anon_sym_ease_in] = ACTIONS(535),
    [anon_sym_ease_in_out] = ACTIONS(535),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(535),
    [anon_sym_ease_out] = ACTIONS(535),
    [anon_sym_ease_DASHout] = ACTIONS(535),
    [anon_sym_start] = ACTIONS(535),
    [anon_sym_end] = ACTIONS(535),
    [anon_sym_black] = ACTIONS(535),
    [anon_sym_blue] = ACTIONS(535),
    [anon_sym_green] = ACTIONS(535),
    [anon_sym_red] = ACTIONS(535),
    [anon_sym_yellow] = ACTIONS(535),
    [anon_sym_white] = ACTIONS(535),
    [anon_sym_gray] = ACTIONS(535),
    [anon_sym_transparent] = ACTIONS(535),
    [anon_sym_angle] = ACTIONS(537),
    [anon_sym_bool] = ACTIONS(537),
    [anon_sym_brush] = ACTIONS(537),
    [anon_sym_color] = ACTIONS(537),
    [anon_sym_float] = ACTIONS(537),
    [anon_sym_image] = ACTIONS(537),
    [anon_sym_int] = ACTIONS(537),
    [anon_sym_length] = ACTIONS(537),
    [anon_sym_percent] = ACTIONS(537),
    [anon_sym_physical_DASHlength] = ACTIONS(537),
    [anon_sym_physical_length] = ACTIONS(537),
    [anon_sym_string] = ACTIONS(537),
    [anon_sym_debug] = ACTIONS(539),
    [anon_sym_animation_DASHtick] = ACTIONS(539),
    [anon_sym_min] = ACTIONS(539),
    [anon_sym_max] = ACTIONS(539),
    [anon_sym_mod] = ACTIONS(539),
    [anon_sym_abs] = ACTIONS(539),
    [anon_sym_round] = ACTIONS(539),
    [anon_sym_ceil] = ACTIONS(539),
    [anon_sym_floor] = ACTIONS(539),
    [anon_sym_sin] = ACTIONS(539),
    [anon_sym_cos] = ACTIONS(539),
    [anon_sym_tan] = ACTIONS(539),
    [anon_sym_asin] = ACTIONS(539),
    [anon_sym_acos] = ACTIONS(539),
    [anon_sym_atan] = ACTIONS(539),
    [anon_sym_sqrt] = ACTIONS(539),
    [anon_sym_pow] = ACTIONS(539),
    [anon_sym_log] = ACTIONS(539),
    [anon_sym_rgb] = ACTIONS(539),
    [anon_sym_easing] = ACTIONS(541),
    [anon_sym_duration] = ACTIONS(541),
    [anon_sym_parent] = ACTIONS(541),
    [anon_sym_root] = ACTIONS(541),
    [sym_comment] = ACTIONS(3),
  },
  [120] = {
    [sym_struct_block_definition] = STATE(25),
    [sym__expression] = STATE(25),
    [sym__all_expressions] = STATE(25),
    [sym_if_expression] = STATE(25),
    [sym_index_expression] = STATE(25),
    [sym_assign_expression] = STATE(25),
    [sym_comp_assign_expression] = STATE(25),
    [sym_call_expression] = STATE(25),
    [sym_field_expression] = STATE(25),
    [sym_bool_literal] = STATE(25),
    [sym_unary_expression] = STATE(25),
    [sym_binary_expression] = STATE(25),
    [sym_ternary_expression] = STATE(25),
    [sym__macro] = STATE(25),
    [sym__literal] = STATE(25),
    [sym_array_literal] = STATE(25),
    [sym_string_literal] = STATE(25),
    [sym_identifier] = STATE(25),
    [sym_color_literal] = STATE(25),
    [sym__number] = STATE(25),
    [sym_num_units] = STATE(25),
    [sym__builtin] = STATE(63),
    [sym_constant_builtin] = STATE(63),
    [sym_type_builtin] = STATE(63),
    [sym_function_builtin] = STATE(63),
    [sym_variable_builtin] = STATE(63),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_true] = ACTIONS(519),
    [anon_sym_false] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [sym__ident_reg] = ACTIONS(527),
    [anon_sym_POUND] = ACTIONS(529),
    [sym_int_literal] = ACTIONS(531),
    [sym_float_literal] = ACTIONS(533),
    [anon_sym_ease] = ACTIONS(535),
    [anon_sym_ease_DASHin] = ACTIONS(535),
    [anon_sym_ease_in] = ACTIONS(535),
    [anon_sym_ease_in_out] = ACTIONS(535),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(535),
    [anon_sym_ease_out] = ACTIONS(535),
    [anon_sym_ease_DASHout] = ACTIONS(535),
    [anon_sym_start] = ACTIONS(535),
    [anon_sym_end] = ACTIONS(535),
    [anon_sym_black] = ACTIONS(535),
    [anon_sym_blue] = ACTIONS(535),
    [anon_sym_green] = ACTIONS(535),
    [anon_sym_red] = ACTIONS(535),
    [anon_sym_yellow] = ACTIONS(535),
    [anon_sym_white] = ACTIONS(535),
    [anon_sym_gray] = ACTIONS(535),
    [anon_sym_transparent] = ACTIONS(535),
    [anon_sym_angle] = ACTIONS(537),
    [anon_sym_bool] = ACTIONS(537),
    [anon_sym_brush] = ACTIONS(537),
    [anon_sym_color] = ACTIONS(537),
    [anon_sym_float] = ACTIONS(537),
    [anon_sym_image] = ACTIONS(537),
    [anon_sym_int] = ACTIONS(537),
    [anon_sym_length] = ACTIONS(537),
    [anon_sym_percent] = ACTIONS(537),
    [anon_sym_physical_DASHlength] = ACTIONS(537),
    [anon_sym_physical_length] = ACTIONS(537),
    [anon_sym_string] = ACTIONS(537),
    [anon_sym_debug] = ACTIONS(539),
    [anon_sym_animation_DASHtick] = ACTIONS(539),
    [anon_sym_min] = ACTIONS(539),
    [anon_sym_max] = ACTIONS(539),
    [anon_sym_mod] = ACTIONS(539),
    [anon_sym_abs] = ACTIONS(539),
    [anon_sym_round] = ACTIONS(539),
    [anon_sym_ceil] = ACTIONS(539),
    [anon_sym_floor] = ACTIONS(539),
    [anon_sym_sin] = ACTIONS(539),
    [anon_sym_cos] = ACTIONS(539),
    [anon_sym_tan] = ACTIONS(539),
    [anon_sym_asin] = ACTIONS(539),
    [anon_sym_acos] = ACTIONS(539),
    [anon_sym_atan] = ACTIONS(539),
    [anon_sym_sqrt] = ACTIONS(539),
    [anon_sym_pow] = ACTIONS(539),
    [anon_sym_log] = ACTIONS(539),
    [anon_sym_rgb] = ACTIONS(539),
    [anon_sym_easing] = ACTIONS(541),
    [anon_sym_duration] = ACTIONS(541),
    [anon_sym_parent] = ACTIONS(541),
    [anon_sym_root] = ACTIONS(541),
    [sym_comment] = ACTIONS(3),
  },
  [121] = {
    [sym_struct_block_definition] = STATE(417),
    [sym__expression] = STATE(417),
    [sym__all_expressions] = STATE(417),
    [sym_if_expression] = STATE(417),
    [sym_index_expression] = STATE(417),
    [sym_assign_expression] = STATE(417),
    [sym_comp_assign_expression] = STATE(417),
    [sym_call_expression] = STATE(417),
    [sym_field_expression] = STATE(417),
    [sym_bool_literal] = STATE(417),
    [sym_unary_expression] = STATE(417),
    [sym_binary_expression] = STATE(417),
    [sym_ternary_expression] = STATE(417),
    [sym__macro] = STATE(417),
    [sym__literal] = STATE(417),
    [sym_array_literal] = STATE(417),
    [sym_string_literal] = STATE(417),
    [sym_identifier] = STATE(417),
    [sym_color_literal] = STATE(417),
    [sym__number] = STATE(417),
    [sym_num_units] = STATE(417),
    [sym__builtin] = STATE(419),
    [sym_constant_builtin] = STATE(419),
    [sym_type_builtin] = STATE(419),
    [sym_function_builtin] = STATE(419),
    [sym_variable_builtin] = STATE(419),
    [anon_sym_LBRACE] = ACTIONS(647),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(649),
    [anon_sym_BANG] = ACTIONS(649),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(651),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(653),
    [anon_sym_ease_DASHin] = ACTIONS(653),
    [anon_sym_ease_in] = ACTIONS(653),
    [anon_sym_ease_in_out] = ACTIONS(653),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(653),
    [anon_sym_ease_out] = ACTIONS(653),
    [anon_sym_ease_DASHout] = ACTIONS(653),
    [anon_sym_start] = ACTIONS(653),
    [anon_sym_end] = ACTIONS(653),
    [anon_sym_black] = ACTIONS(653),
    [anon_sym_blue] = ACTIONS(653),
    [anon_sym_green] = ACTIONS(653),
    [anon_sym_red] = ACTIONS(653),
    [anon_sym_yellow] = ACTIONS(653),
    [anon_sym_white] = ACTIONS(653),
    [anon_sym_gray] = ACTIONS(653),
    [anon_sym_transparent] = ACTIONS(653),
    [anon_sym_angle] = ACTIONS(655),
    [anon_sym_bool] = ACTIONS(655),
    [anon_sym_brush] = ACTIONS(655),
    [anon_sym_color] = ACTIONS(655),
    [anon_sym_float] = ACTIONS(655),
    [anon_sym_image] = ACTIONS(655),
    [anon_sym_int] = ACTIONS(655),
    [anon_sym_length] = ACTIONS(655),
    [anon_sym_percent] = ACTIONS(655),
    [anon_sym_physical_DASHlength] = ACTIONS(655),
    [anon_sym_physical_length] = ACTIONS(655),
    [anon_sym_string] = ACTIONS(655),
    [anon_sym_debug] = ACTIONS(657),
    [anon_sym_animation_DASHtick] = ACTIONS(657),
    [anon_sym_min] = ACTIONS(657),
    [anon_sym_max] = ACTIONS(657),
    [anon_sym_mod] = ACTIONS(657),
    [anon_sym_abs] = ACTIONS(657),
    [anon_sym_round] = ACTIONS(657),
    [anon_sym_ceil] = ACTIONS(657),
    [anon_sym_floor] = ACTIONS(657),
    [anon_sym_sin] = ACTIONS(657),
    [anon_sym_cos] = ACTIONS(657),
    [anon_sym_tan] = ACTIONS(657),
    [anon_sym_asin] = ACTIONS(657),
    [anon_sym_acos] = ACTIONS(657),
    [anon_sym_atan] = ACTIONS(657),
    [anon_sym_sqrt] = ACTIONS(657),
    [anon_sym_pow] = ACTIONS(657),
    [anon_sym_log] = ACTIONS(657),
    [anon_sym_rgb] = ACTIONS(657),
    [anon_sym_easing] = ACTIONS(659),
    [anon_sym_duration] = ACTIONS(659),
    [anon_sym_parent] = ACTIONS(659),
    [anon_sym_root] = ACTIONS(659),
    [sym_comment] = ACTIONS(3),
  },
  [122] = {
    [sym_struct_block_definition] = STATE(420),
    [sym__expression] = STATE(420),
    [sym__all_expressions] = STATE(420),
    [sym_if_expression] = STATE(420),
    [sym_index_expression] = STATE(420),
    [sym_assign_expression] = STATE(420),
    [sym_comp_assign_expression] = STATE(420),
    [sym_call_expression] = STATE(420),
    [sym_field_expression] = STATE(420),
    [sym_bool_literal] = STATE(420),
    [sym_unary_expression] = STATE(420),
    [sym_binary_expression] = STATE(420),
    [sym_ternary_expression] = STATE(420),
    [sym__macro] = STATE(420),
    [sym__literal] = STATE(420),
    [sym_array_literal] = STATE(420),
    [sym_string_literal] = STATE(420),
    [sym_identifier] = STATE(420),
    [sym_color_literal] = STATE(420),
    [sym__number] = STATE(420),
    [sym_num_units] = STATE(420),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [123] = {
    [sym_struct_block_definition] = STATE(386),
    [sym__expression] = STATE(386),
    [sym__all_expressions] = STATE(386),
    [sym_if_expression] = STATE(386),
    [sym_index_expression] = STATE(386),
    [sym_assign_expression] = STATE(386),
    [sym_comp_assign_expression] = STATE(386),
    [sym_call_expression] = STATE(386),
    [sym_field_expression] = STATE(386),
    [sym_bool_literal] = STATE(386),
    [sym_unary_expression] = STATE(386),
    [sym_binary_expression] = STATE(386),
    [sym_ternary_expression] = STATE(386),
    [sym__macro] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_array_literal] = STATE(386),
    [sym_string_literal] = STATE(386),
    [sym_identifier] = STATE(386),
    [sym_color_literal] = STATE(386),
    [sym__number] = STATE(386),
    [sym_num_units] = STATE(386),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [124] = {
    [sym_struct_block_definition] = STATE(428),
    [sym__expression] = STATE(428),
    [sym__all_expressions] = STATE(428),
    [sym_if_expression] = STATE(428),
    [sym_index_expression] = STATE(428),
    [sym_assign_expression] = STATE(428),
    [sym_comp_assign_expression] = STATE(428),
    [sym_call_expression] = STATE(428),
    [sym_field_expression] = STATE(428),
    [sym_bool_literal] = STATE(428),
    [sym_unary_expression] = STATE(428),
    [sym_binary_expression] = STATE(428),
    [sym_ternary_expression] = STATE(428),
    [sym__macro] = STATE(428),
    [sym__literal] = STATE(428),
    [sym_array_literal] = STATE(428),
    [sym_string_literal] = STATE(428),
    [sym_identifier] = STATE(428),
    [sym_color_literal] = STATE(428),
    [sym__number] = STATE(428),
    [sym_num_units] = STATE(428),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [125] = {
    [sym_struct_block_definition] = STATE(441),
    [sym__expression] = STATE(441),
    [sym__all_expressions] = STATE(441),
    [sym_if_expression] = STATE(441),
    [sym_index_expression] = STATE(441),
    [sym_assign_expression] = STATE(441),
    [sym_comp_assign_expression] = STATE(441),
    [sym_call_expression] = STATE(441),
    [sym_field_expression] = STATE(443),
    [sym_bool_literal] = STATE(441),
    [sym_unary_expression] = STATE(441),
    [sym_binary_expression] = STATE(441),
    [sym_ternary_expression] = STATE(441),
    [sym__macro] = STATE(441),
    [sym__literal] = STATE(441),
    [sym_array_literal] = STATE(441),
    [sym_string_literal] = STATE(441),
    [sym_identifier] = STATE(441),
    [sym_color_literal] = STATE(441),
    [sym__number] = STATE(441),
    [sym_num_units] = STATE(441),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [126] = {
    [sym_struct_block_definition] = STATE(76),
    [sym__expression] = STATE(76),
    [sym__all_expressions] = STATE(76),
    [sym_if_expression] = STATE(76),
    [sym_index_expression] = STATE(76),
    [sym_assign_expression] = STATE(76),
    [sym_comp_assign_expression] = STATE(76),
    [sym_call_expression] = STATE(76),
    [sym_field_expression] = STATE(76),
    [sym_bool_literal] = STATE(76),
    [sym_unary_expression] = STATE(76),
    [sym_binary_expression] = STATE(76),
    [sym_ternary_expression] = STATE(76),
    [sym__macro] = STATE(76),
    [sym__literal] = STATE(76),
    [sym_array_literal] = STATE(76),
    [sym_string_literal] = STATE(76),
    [sym_identifier] = STATE(76),
    [sym_color_literal] = STATE(76),
    [sym__number] = STATE(76),
    [sym_num_units] = STATE(76),
    [sym__builtin] = STATE(63),
    [sym_constant_builtin] = STATE(63),
    [sym_type_builtin] = STATE(63),
    [sym_function_builtin] = STATE(63),
    [sym_variable_builtin] = STATE(63),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_true] = ACTIONS(519),
    [anon_sym_false] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [sym__ident_reg] = ACTIONS(527),
    [anon_sym_POUND] = ACTIONS(529),
    [sym_int_literal] = ACTIONS(531),
    [sym_float_literal] = ACTIONS(533),
    [anon_sym_ease] = ACTIONS(535),
    [anon_sym_ease_DASHin] = ACTIONS(535),
    [anon_sym_ease_in] = ACTIONS(535),
    [anon_sym_ease_in_out] = ACTIONS(535),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(535),
    [anon_sym_ease_out] = ACTIONS(535),
    [anon_sym_ease_DASHout] = ACTIONS(535),
    [anon_sym_start] = ACTIONS(535),
    [anon_sym_end] = ACTIONS(535),
    [anon_sym_black] = ACTIONS(535),
    [anon_sym_blue] = ACTIONS(535),
    [anon_sym_green] = ACTIONS(535),
    [anon_sym_red] = ACTIONS(535),
    [anon_sym_yellow] = ACTIONS(535),
    [anon_sym_white] = ACTIONS(535),
    [anon_sym_gray] = ACTIONS(535),
    [anon_sym_transparent] = ACTIONS(535),
    [anon_sym_angle] = ACTIONS(537),
    [anon_sym_bool] = ACTIONS(537),
    [anon_sym_brush] = ACTIONS(537),
    [anon_sym_color] = ACTIONS(537),
    [anon_sym_float] = ACTIONS(537),
    [anon_sym_image] = ACTIONS(537),
    [anon_sym_int] = ACTIONS(537),
    [anon_sym_length] = ACTIONS(537),
    [anon_sym_percent] = ACTIONS(537),
    [anon_sym_physical_DASHlength] = ACTIONS(537),
    [anon_sym_physical_length] = ACTIONS(537),
    [anon_sym_string] = ACTIONS(537),
    [anon_sym_debug] = ACTIONS(539),
    [anon_sym_animation_DASHtick] = ACTIONS(539),
    [anon_sym_min] = ACTIONS(539),
    [anon_sym_max] = ACTIONS(539),
    [anon_sym_mod] = ACTIONS(539),
    [anon_sym_abs] = ACTIONS(539),
    [anon_sym_round] = ACTIONS(539),
    [anon_sym_ceil] = ACTIONS(539),
    [anon_sym_floor] = ACTIONS(539),
    [anon_sym_sin] = ACTIONS(539),
    [anon_sym_cos] = ACTIONS(539),
    [anon_sym_tan] = ACTIONS(539),
    [anon_sym_asin] = ACTIONS(539),
    [anon_sym_acos] = ACTIONS(539),
    [anon_sym_atan] = ACTIONS(539),
    [anon_sym_sqrt] = ACTIONS(539),
    [anon_sym_pow] = ACTIONS(539),
    [anon_sym_log] = ACTIONS(539),
    [anon_sym_rgb] = ACTIONS(539),
    [anon_sym_easing] = ACTIONS(541),
    [anon_sym_duration] = ACTIONS(541),
    [anon_sym_parent] = ACTIONS(541),
    [anon_sym_root] = ACTIONS(541),
    [sym_comment] = ACTIONS(3),
  },
  [127] = {
    [sym_struct_block_definition] = STATE(441),
    [sym__expression] = STATE(441),
    [sym__all_expressions] = STATE(441),
    [sym_if_expression] = STATE(441),
    [sym_index_expression] = STATE(441),
    [sym_assign_expression] = STATE(441),
    [sym_comp_assign_expression] = STATE(441),
    [sym_call_expression] = STATE(441),
    [sym_field_expression] = STATE(442),
    [sym_bool_literal] = STATE(441),
    [sym_unary_expression] = STATE(441),
    [sym_binary_expression] = STATE(441),
    [sym_ternary_expression] = STATE(441),
    [sym__macro] = STATE(441),
    [sym__literal] = STATE(441),
    [sym_array_literal] = STATE(441),
    [sym_string_literal] = STATE(441),
    [sym_identifier] = STATE(441),
    [sym_color_literal] = STATE(441),
    [sym__number] = STATE(441),
    [sym_num_units] = STATE(441),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [128] = {
    [sym_struct_block_definition] = STATE(78),
    [sym__expression] = STATE(78),
    [sym__all_expressions] = STATE(78),
    [sym_if_expression] = STATE(78),
    [sym_index_expression] = STATE(78),
    [sym_assign_expression] = STATE(78),
    [sym_comp_assign_expression] = STATE(78),
    [sym_call_expression] = STATE(78),
    [sym_field_expression] = STATE(78),
    [sym_bool_literal] = STATE(78),
    [sym_unary_expression] = STATE(78),
    [sym_binary_expression] = STATE(78),
    [sym_ternary_expression] = STATE(78),
    [sym__macro] = STATE(78),
    [sym__literal] = STATE(78),
    [sym_array_literal] = STATE(78),
    [sym_string_literal] = STATE(78),
    [sym_identifier] = STATE(78),
    [sym_color_literal] = STATE(78),
    [sym__number] = STATE(78),
    [sym_num_units] = STATE(78),
    [sym__builtin] = STATE(63),
    [sym_constant_builtin] = STATE(63),
    [sym_type_builtin] = STATE(63),
    [sym_function_builtin] = STATE(63),
    [sym_variable_builtin] = STATE(63),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_true] = ACTIONS(519),
    [anon_sym_false] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [sym__ident_reg] = ACTIONS(527),
    [anon_sym_POUND] = ACTIONS(529),
    [sym_int_literal] = ACTIONS(531),
    [sym_float_literal] = ACTIONS(533),
    [anon_sym_ease] = ACTIONS(535),
    [anon_sym_ease_DASHin] = ACTIONS(535),
    [anon_sym_ease_in] = ACTIONS(535),
    [anon_sym_ease_in_out] = ACTIONS(535),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(535),
    [anon_sym_ease_out] = ACTIONS(535),
    [anon_sym_ease_DASHout] = ACTIONS(535),
    [anon_sym_start] = ACTIONS(535),
    [anon_sym_end] = ACTIONS(535),
    [anon_sym_black] = ACTIONS(535),
    [anon_sym_blue] = ACTIONS(535),
    [anon_sym_green] = ACTIONS(535),
    [anon_sym_red] = ACTIONS(535),
    [anon_sym_yellow] = ACTIONS(535),
    [anon_sym_white] = ACTIONS(535),
    [anon_sym_gray] = ACTIONS(535),
    [anon_sym_transparent] = ACTIONS(535),
    [anon_sym_angle] = ACTIONS(537),
    [anon_sym_bool] = ACTIONS(537),
    [anon_sym_brush] = ACTIONS(537),
    [anon_sym_color] = ACTIONS(537),
    [anon_sym_float] = ACTIONS(537),
    [anon_sym_image] = ACTIONS(537),
    [anon_sym_int] = ACTIONS(537),
    [anon_sym_length] = ACTIONS(537),
    [anon_sym_percent] = ACTIONS(537),
    [anon_sym_physical_DASHlength] = ACTIONS(537),
    [anon_sym_physical_length] = ACTIONS(537),
    [anon_sym_string] = ACTIONS(537),
    [anon_sym_debug] = ACTIONS(539),
    [anon_sym_animation_DASHtick] = ACTIONS(539),
    [anon_sym_min] = ACTIONS(539),
    [anon_sym_max] = ACTIONS(539),
    [anon_sym_mod] = ACTIONS(539),
    [anon_sym_abs] = ACTIONS(539),
    [anon_sym_round] = ACTIONS(539),
    [anon_sym_ceil] = ACTIONS(539),
    [anon_sym_floor] = ACTIONS(539),
    [anon_sym_sin] = ACTIONS(539),
    [anon_sym_cos] = ACTIONS(539),
    [anon_sym_tan] = ACTIONS(539),
    [anon_sym_asin] = ACTIONS(539),
    [anon_sym_acos] = ACTIONS(539),
    [anon_sym_atan] = ACTIONS(539),
    [anon_sym_sqrt] = ACTIONS(539),
    [anon_sym_pow] = ACTIONS(539),
    [anon_sym_log] = ACTIONS(539),
    [anon_sym_rgb] = ACTIONS(539),
    [anon_sym_easing] = ACTIONS(541),
    [anon_sym_duration] = ACTIONS(541),
    [anon_sym_parent] = ACTIONS(541),
    [anon_sym_root] = ACTIONS(541),
    [sym_comment] = ACTIONS(3),
  },
  [129] = {
    [sym_struct_block_definition] = STATE(430),
    [sym__expression] = STATE(430),
    [sym__all_expressions] = STATE(430),
    [sym_if_expression] = STATE(430),
    [sym_index_expression] = STATE(430),
    [sym_assign_expression] = STATE(430),
    [sym_comp_assign_expression] = STATE(430),
    [sym_call_expression] = STATE(430),
    [sym_field_expression] = STATE(430),
    [sym_bool_literal] = STATE(430),
    [sym_unary_expression] = STATE(430),
    [sym_binary_expression] = STATE(430),
    [sym_ternary_expression] = STATE(430),
    [sym__macro] = STATE(430),
    [sym__literal] = STATE(430),
    [sym_array_literal] = STATE(430),
    [sym_string_literal] = STATE(430),
    [sym_identifier] = STATE(430),
    [sym_color_literal] = STATE(430),
    [sym__number] = STATE(430),
    [sym_num_units] = STATE(430),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [130] = {
    [sym_struct_block_definition] = STATE(381),
    [sym__expression] = STATE(381),
    [sym__all_expressions] = STATE(381),
    [sym_if_expression] = STATE(381),
    [sym_index_expression] = STATE(381),
    [sym_assign_expression] = STATE(381),
    [sym_comp_assign_expression] = STATE(381),
    [sym_call_expression] = STATE(381),
    [sym_field_expression] = STATE(381),
    [sym_bool_literal] = STATE(381),
    [sym_unary_expression] = STATE(381),
    [sym_binary_expression] = STATE(381),
    [sym_ternary_expression] = STATE(381),
    [sym__macro] = STATE(381),
    [sym__literal] = STATE(381),
    [sym_array_literal] = STATE(381),
    [sym_string_literal] = STATE(381),
    [sym_identifier] = STATE(381),
    [sym_color_literal] = STATE(381),
    [sym__number] = STATE(381),
    [sym_num_units] = STATE(381),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [131] = {
    [sym_struct_block_definition] = STATE(433),
    [sym__expression] = STATE(433),
    [sym__all_expressions] = STATE(433),
    [sym_if_expression] = STATE(433),
    [sym_index_expression] = STATE(433),
    [sym_assign_expression] = STATE(433),
    [sym_comp_assign_expression] = STATE(433),
    [sym_call_expression] = STATE(433),
    [sym_field_expression] = STATE(433),
    [sym_bool_literal] = STATE(433),
    [sym_unary_expression] = STATE(433),
    [sym_binary_expression] = STATE(433),
    [sym_ternary_expression] = STATE(433),
    [sym__macro] = STATE(433),
    [sym__literal] = STATE(433),
    [sym_array_literal] = STATE(433),
    [sym_string_literal] = STATE(433),
    [sym_identifier] = STATE(433),
    [sym_color_literal] = STATE(433),
    [sym__number] = STATE(433),
    [sym_num_units] = STATE(433),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [132] = {
    [sym_struct_block_definition] = STATE(39),
    [sym__expression] = STATE(39),
    [sym__all_expressions] = STATE(39),
    [sym_if_expression] = STATE(39),
    [sym_index_expression] = STATE(39),
    [sym_assign_expression] = STATE(39),
    [sym_comp_assign_expression] = STATE(39),
    [sym_call_expression] = STATE(39),
    [sym_field_expression] = STATE(39),
    [sym_bool_literal] = STATE(39),
    [sym_unary_expression] = STATE(39),
    [sym_binary_expression] = STATE(39),
    [sym_ternary_expression] = STATE(39),
    [sym__macro] = STATE(39),
    [sym__literal] = STATE(39),
    [sym_array_literal] = STATE(39),
    [sym_string_literal] = STATE(39),
    [sym_identifier] = STATE(39),
    [sym_color_literal] = STATE(39),
    [sym__number] = STATE(39),
    [sym_num_units] = STATE(39),
    [sym__builtin] = STATE(63),
    [sym_constant_builtin] = STATE(63),
    [sym_type_builtin] = STATE(63),
    [sym_function_builtin] = STATE(63),
    [sym_variable_builtin] = STATE(63),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_true] = ACTIONS(519),
    [anon_sym_false] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [sym__ident_reg] = ACTIONS(527),
    [anon_sym_POUND] = ACTIONS(529),
    [sym_int_literal] = ACTIONS(531),
    [sym_float_literal] = ACTIONS(533),
    [anon_sym_ease] = ACTIONS(535),
    [anon_sym_ease_DASHin] = ACTIONS(535),
    [anon_sym_ease_in] = ACTIONS(535),
    [anon_sym_ease_in_out] = ACTIONS(535),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(535),
    [anon_sym_ease_out] = ACTIONS(535),
    [anon_sym_ease_DASHout] = ACTIONS(535),
    [anon_sym_start] = ACTIONS(535),
    [anon_sym_end] = ACTIONS(535),
    [anon_sym_black] = ACTIONS(535),
    [anon_sym_blue] = ACTIONS(535),
    [anon_sym_green] = ACTIONS(535),
    [anon_sym_red] = ACTIONS(535),
    [anon_sym_yellow] = ACTIONS(535),
    [anon_sym_white] = ACTIONS(535),
    [anon_sym_gray] = ACTIONS(535),
    [anon_sym_transparent] = ACTIONS(535),
    [anon_sym_angle] = ACTIONS(537),
    [anon_sym_bool] = ACTIONS(537),
    [anon_sym_brush] = ACTIONS(537),
    [anon_sym_color] = ACTIONS(537),
    [anon_sym_float] = ACTIONS(537),
    [anon_sym_image] = ACTIONS(537),
    [anon_sym_int] = ACTIONS(537),
    [anon_sym_length] = ACTIONS(537),
    [anon_sym_percent] = ACTIONS(537),
    [anon_sym_physical_DASHlength] = ACTIONS(537),
    [anon_sym_physical_length] = ACTIONS(537),
    [anon_sym_string] = ACTIONS(537),
    [anon_sym_debug] = ACTIONS(539),
    [anon_sym_animation_DASHtick] = ACTIONS(539),
    [anon_sym_min] = ACTIONS(539),
    [anon_sym_max] = ACTIONS(539),
    [anon_sym_mod] = ACTIONS(539),
    [anon_sym_abs] = ACTIONS(539),
    [anon_sym_round] = ACTIONS(539),
    [anon_sym_ceil] = ACTIONS(539),
    [anon_sym_floor] = ACTIONS(539),
    [anon_sym_sin] = ACTIONS(539),
    [anon_sym_cos] = ACTIONS(539),
    [anon_sym_tan] = ACTIONS(539),
    [anon_sym_asin] = ACTIONS(539),
    [anon_sym_acos] = ACTIONS(539),
    [anon_sym_atan] = ACTIONS(539),
    [anon_sym_sqrt] = ACTIONS(539),
    [anon_sym_pow] = ACTIONS(539),
    [anon_sym_log] = ACTIONS(539),
    [anon_sym_rgb] = ACTIONS(539),
    [anon_sym_easing] = ACTIONS(541),
    [anon_sym_duration] = ACTIONS(541),
    [anon_sym_parent] = ACTIONS(541),
    [anon_sym_root] = ACTIONS(541),
    [sym_comment] = ACTIONS(3),
  },
  [133] = {
    [sym_struct_block_definition] = STATE(416),
    [sym__expression] = STATE(416),
    [sym__all_expressions] = STATE(416),
    [sym_if_expression] = STATE(416),
    [sym_index_expression] = STATE(416),
    [sym_assign_expression] = STATE(416),
    [sym_comp_assign_expression] = STATE(416),
    [sym_call_expression] = STATE(416),
    [sym_field_expression] = STATE(416),
    [sym_bool_literal] = STATE(416),
    [sym_unary_expression] = STATE(416),
    [sym_binary_expression] = STATE(416),
    [sym_ternary_expression] = STATE(416),
    [sym__macro] = STATE(416),
    [sym__literal] = STATE(416),
    [sym_array_literal] = STATE(416),
    [sym_string_literal] = STATE(416),
    [sym_identifier] = STATE(416),
    [sym_color_literal] = STATE(416),
    [sym__number] = STATE(416),
    [sym_num_units] = STATE(416),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [134] = {
    [sym_struct_block_definition] = STATE(429),
    [sym__expression] = STATE(429),
    [sym__all_expressions] = STATE(429),
    [sym_if_expression] = STATE(429),
    [sym_index_expression] = STATE(429),
    [sym_assign_expression] = STATE(429),
    [sym_comp_assign_expression] = STATE(429),
    [sym_call_expression] = STATE(429),
    [sym_field_expression] = STATE(429),
    [sym_bool_literal] = STATE(429),
    [sym_unary_expression] = STATE(429),
    [sym_binary_expression] = STATE(429),
    [sym_ternary_expression] = STATE(429),
    [sym__macro] = STATE(429),
    [sym__literal] = STATE(429),
    [sym_array_literal] = STATE(429),
    [sym_string_literal] = STATE(429),
    [sym_identifier] = STATE(429),
    [sym_color_literal] = STATE(429),
    [sym__number] = STATE(429),
    [sym_num_units] = STATE(429),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [135] = {
    [sym_struct_block_definition] = STATE(431),
    [sym__expression] = STATE(431),
    [sym__all_expressions] = STATE(431),
    [sym_if_expression] = STATE(431),
    [sym_index_expression] = STATE(431),
    [sym_assign_expression] = STATE(431),
    [sym_comp_assign_expression] = STATE(431),
    [sym_call_expression] = STATE(431),
    [sym_field_expression] = STATE(431),
    [sym_bool_literal] = STATE(431),
    [sym_unary_expression] = STATE(431),
    [sym_binary_expression] = STATE(431),
    [sym_ternary_expression] = STATE(431),
    [sym__macro] = STATE(431),
    [sym__literal] = STATE(431),
    [sym_array_literal] = STATE(431),
    [sym_string_literal] = STATE(431),
    [sym_identifier] = STATE(431),
    [sym_color_literal] = STATE(431),
    [sym__number] = STATE(431),
    [sym_num_units] = STATE(431),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [136] = {
    [sym_struct_block_definition] = STATE(34),
    [sym__expression] = STATE(34),
    [sym__all_expressions] = STATE(34),
    [sym_if_expression] = STATE(34),
    [sym_index_expression] = STATE(34),
    [sym_assign_expression] = STATE(34),
    [sym_comp_assign_expression] = STATE(34),
    [sym_call_expression] = STATE(34),
    [sym_field_expression] = STATE(34),
    [sym_bool_literal] = STATE(34),
    [sym_unary_expression] = STATE(34),
    [sym_binary_expression] = STATE(34),
    [sym_ternary_expression] = STATE(34),
    [sym__macro] = STATE(34),
    [sym__literal] = STATE(34),
    [sym_array_literal] = STATE(34),
    [sym_string_literal] = STATE(34),
    [sym_identifier] = STATE(34),
    [sym_color_literal] = STATE(34),
    [sym__number] = STATE(34),
    [sym_num_units] = STATE(34),
    [sym__builtin] = STATE(63),
    [sym_constant_builtin] = STATE(63),
    [sym_type_builtin] = STATE(63),
    [sym_function_builtin] = STATE(63),
    [sym_variable_builtin] = STATE(63),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_true] = ACTIONS(519),
    [anon_sym_false] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [sym__ident_reg] = ACTIONS(527),
    [anon_sym_POUND] = ACTIONS(529),
    [sym_int_literal] = ACTIONS(531),
    [sym_float_literal] = ACTIONS(533),
    [anon_sym_ease] = ACTIONS(535),
    [anon_sym_ease_DASHin] = ACTIONS(535),
    [anon_sym_ease_in] = ACTIONS(535),
    [anon_sym_ease_in_out] = ACTIONS(535),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(535),
    [anon_sym_ease_out] = ACTIONS(535),
    [anon_sym_ease_DASHout] = ACTIONS(535),
    [anon_sym_start] = ACTIONS(535),
    [anon_sym_end] = ACTIONS(535),
    [anon_sym_black] = ACTIONS(535),
    [anon_sym_blue] = ACTIONS(535),
    [anon_sym_green] = ACTIONS(535),
    [anon_sym_red] = ACTIONS(535),
    [anon_sym_yellow] = ACTIONS(535),
    [anon_sym_white] = ACTIONS(535),
    [anon_sym_gray] = ACTIONS(535),
    [anon_sym_transparent] = ACTIONS(535),
    [anon_sym_angle] = ACTIONS(537),
    [anon_sym_bool] = ACTIONS(537),
    [anon_sym_brush] = ACTIONS(537),
    [anon_sym_color] = ACTIONS(537),
    [anon_sym_float] = ACTIONS(537),
    [anon_sym_image] = ACTIONS(537),
    [anon_sym_int] = ACTIONS(537),
    [anon_sym_length] = ACTIONS(537),
    [anon_sym_percent] = ACTIONS(537),
    [anon_sym_physical_DASHlength] = ACTIONS(537),
    [anon_sym_physical_length] = ACTIONS(537),
    [anon_sym_string] = ACTIONS(537),
    [anon_sym_debug] = ACTIONS(539),
    [anon_sym_animation_DASHtick] = ACTIONS(539),
    [anon_sym_min] = ACTIONS(539),
    [anon_sym_max] = ACTIONS(539),
    [anon_sym_mod] = ACTIONS(539),
    [anon_sym_abs] = ACTIONS(539),
    [anon_sym_round] = ACTIONS(539),
    [anon_sym_ceil] = ACTIONS(539),
    [anon_sym_floor] = ACTIONS(539),
    [anon_sym_sin] = ACTIONS(539),
    [anon_sym_cos] = ACTIONS(539),
    [anon_sym_tan] = ACTIONS(539),
    [anon_sym_asin] = ACTIONS(539),
    [anon_sym_acos] = ACTIONS(539),
    [anon_sym_atan] = ACTIONS(539),
    [anon_sym_sqrt] = ACTIONS(539),
    [anon_sym_pow] = ACTIONS(539),
    [anon_sym_log] = ACTIONS(539),
    [anon_sym_rgb] = ACTIONS(539),
    [anon_sym_easing] = ACTIONS(541),
    [anon_sym_duration] = ACTIONS(541),
    [anon_sym_parent] = ACTIONS(541),
    [anon_sym_root] = ACTIONS(541),
    [sym_comment] = ACTIONS(3),
  },
  [137] = {
    [sym_struct_block_definition] = STATE(27),
    [sym__expression] = STATE(27),
    [sym__all_expressions] = STATE(27),
    [sym_if_expression] = STATE(27),
    [sym_index_expression] = STATE(27),
    [sym_assign_expression] = STATE(27),
    [sym_comp_assign_expression] = STATE(27),
    [sym_call_expression] = STATE(27),
    [sym_field_expression] = STATE(27),
    [sym_bool_literal] = STATE(27),
    [sym_unary_expression] = STATE(27),
    [sym_binary_expression] = STATE(27),
    [sym_ternary_expression] = STATE(27),
    [sym__macro] = STATE(27),
    [sym__literal] = STATE(27),
    [sym_array_literal] = STATE(27),
    [sym_string_literal] = STATE(27),
    [sym_identifier] = STATE(27),
    [sym_color_literal] = STATE(27),
    [sym__number] = STATE(27),
    [sym_num_units] = STATE(27),
    [sym__builtin] = STATE(63),
    [sym_constant_builtin] = STATE(63),
    [sym_type_builtin] = STATE(63),
    [sym_function_builtin] = STATE(63),
    [sym_variable_builtin] = STATE(63),
    [anon_sym_LBRACE] = ACTIONS(507),
    [anon_sym_if] = ACTIONS(511),
    [anon_sym_AT] = ACTIONS(513),
    [anon_sym_LBRACK] = ACTIONS(515),
    [anon_sym_LPAREN] = ACTIONS(517),
    [anon_sym_true] = ACTIONS(519),
    [anon_sym_false] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_SQUOTE] = ACTIONS(525),
    [sym__ident_reg] = ACTIONS(527),
    [anon_sym_POUND] = ACTIONS(529),
    [sym_int_literal] = ACTIONS(531),
    [sym_float_literal] = ACTIONS(533),
    [anon_sym_ease] = ACTIONS(535),
    [anon_sym_ease_DASHin] = ACTIONS(535),
    [anon_sym_ease_in] = ACTIONS(535),
    [anon_sym_ease_in_out] = ACTIONS(535),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(535),
    [anon_sym_ease_out] = ACTIONS(535),
    [anon_sym_ease_DASHout] = ACTIONS(535),
    [anon_sym_start] = ACTIONS(535),
    [anon_sym_end] = ACTIONS(535),
    [anon_sym_black] = ACTIONS(535),
    [anon_sym_blue] = ACTIONS(535),
    [anon_sym_green] = ACTIONS(535),
    [anon_sym_red] = ACTIONS(535),
    [anon_sym_yellow] = ACTIONS(535),
    [anon_sym_white] = ACTIONS(535),
    [anon_sym_gray] = ACTIONS(535),
    [anon_sym_transparent] = ACTIONS(535),
    [anon_sym_angle] = ACTIONS(537),
    [anon_sym_bool] = ACTIONS(537),
    [anon_sym_brush] = ACTIONS(537),
    [anon_sym_color] = ACTIONS(537),
    [anon_sym_float] = ACTIONS(537),
    [anon_sym_image] = ACTIONS(537),
    [anon_sym_int] = ACTIONS(537),
    [anon_sym_length] = ACTIONS(537),
    [anon_sym_percent] = ACTIONS(537),
    [anon_sym_physical_DASHlength] = ACTIONS(537),
    [anon_sym_physical_length] = ACTIONS(537),
    [anon_sym_string] = ACTIONS(537),
    [anon_sym_debug] = ACTIONS(539),
    [anon_sym_animation_DASHtick] = ACTIONS(539),
    [anon_sym_min] = ACTIONS(539),
    [anon_sym_max] = ACTIONS(539),
    [anon_sym_mod] = ACTIONS(539),
    [anon_sym_abs] = ACTIONS(539),
    [anon_sym_round] = ACTIONS(539),
    [anon_sym_ceil] = ACTIONS(539),
    [anon_sym_floor] = ACTIONS(539),
    [anon_sym_sin] = ACTIONS(539),
    [anon_sym_cos] = ACTIONS(539),
    [anon_sym_tan] = ACTIONS(539),
    [anon_sym_asin] = ACTIONS(539),
    [anon_sym_acos] = ACTIONS(539),
    [anon_sym_atan] = ACTIONS(539),
    [anon_sym_sqrt] = ACTIONS(539),
    [anon_sym_pow] = ACTIONS(539),
    [anon_sym_log] = ACTIONS(539),
    [anon_sym_rgb] = ACTIONS(539),
    [anon_sym_easing] = ACTIONS(541),
    [anon_sym_duration] = ACTIONS(541),
    [anon_sym_parent] = ACTIONS(541),
    [anon_sym_root] = ACTIONS(541),
    [sym_comment] = ACTIONS(3),
  },
  [138] = {
    [sym_struct_block_definition] = STATE(415),
    [sym__expression] = STATE(415),
    [sym__all_expressions] = STATE(415),
    [sym_if_expression] = STATE(415),
    [sym_index_expression] = STATE(415),
    [sym_assign_expression] = STATE(415),
    [sym_comp_assign_expression] = STATE(415),
    [sym_call_expression] = STATE(415),
    [sym_field_expression] = STATE(415),
    [sym_bool_literal] = STATE(415),
    [sym_unary_expression] = STATE(415),
    [sym_binary_expression] = STATE(415),
    [sym_ternary_expression] = STATE(415),
    [sym__macro] = STATE(415),
    [sym__literal] = STATE(415),
    [sym_array_literal] = STATE(415),
    [sym_string_literal] = STATE(415),
    [sym_identifier] = STATE(415),
    [sym_color_literal] = STATE(415),
    [sym__number] = STATE(415),
    [sym_num_units] = STATE(415),
    [sym__builtin] = STATE(329),
    [sym_constant_builtin] = STATE(329),
    [sym_type_builtin] = STATE(329),
    [sym_function_builtin] = STATE(329),
    [sym_variable_builtin] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_AT] = ACTIONS(33),
    [anon_sym_LBRACK] = ACTIONS(97),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(73),
    [anon_sym_SQUOTE] = ACTIONS(75),
    [sym__ident_reg] = ACTIONS(19),
    [anon_sym_POUND] = ACTIONS(77),
    [sym_int_literal] = ACTIONS(79),
    [sym_float_literal] = ACTIONS(81),
    [anon_sym_ease] = ACTIONS(21),
    [anon_sym_ease_DASHin] = ACTIONS(21),
    [anon_sym_ease_in] = ACTIONS(21),
    [anon_sym_ease_in_out] = ACTIONS(21),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(21),
    [anon_sym_ease_out] = ACTIONS(21),
    [anon_sym_ease_DASHout] = ACTIONS(21),
    [anon_sym_start] = ACTIONS(21),
    [anon_sym_end] = ACTIONS(21),
    [anon_sym_black] = ACTIONS(21),
    [anon_sym_blue] = ACTIONS(21),
    [anon_sym_green] = ACTIONS(21),
    [anon_sym_red] = ACTIONS(21),
    [anon_sym_yellow] = ACTIONS(21),
    [anon_sym_white] = ACTIONS(21),
    [anon_sym_gray] = ACTIONS(21),
    [anon_sym_transparent] = ACTIONS(21),
    [anon_sym_angle] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_brush] = ACTIONS(23),
    [anon_sym_color] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_image] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_length] = ACTIONS(23),
    [anon_sym_percent] = ACTIONS(23),
    [anon_sym_physical_DASHlength] = ACTIONS(23),
    [anon_sym_physical_length] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_debug] = ACTIONS(25),
    [anon_sym_animation_DASHtick] = ACTIONS(25),
    [anon_sym_min] = ACTIONS(25),
    [anon_sym_max] = ACTIONS(25),
    [anon_sym_mod] = ACTIONS(25),
    [anon_sym_abs] = ACTIONS(25),
    [anon_sym_round] = ACTIONS(25),
    [anon_sym_ceil] = ACTIONS(25),
    [anon_sym_floor] = ACTIONS(25),
    [anon_sym_sin] = ACTIONS(25),
    [anon_sym_cos] = ACTIONS(25),
    [anon_sym_tan] = ACTIONS(25),
    [anon_sym_asin] = ACTIONS(25),
    [anon_sym_acos] = ACTIONS(25),
    [anon_sym_atan] = ACTIONS(25),
    [anon_sym_sqrt] = ACTIONS(25),
    [anon_sym_pow] = ACTIONS(25),
    [anon_sym_log] = ACTIONS(25),
    [anon_sym_rgb] = ACTIONS(25),
    [anon_sym_easing] = ACTIONS(27),
    [anon_sym_duration] = ACTIONS(27),
    [anon_sym_parent] = ACTIONS(27),
    [anon_sym_root] = ACTIONS(27),
    [sym_comment] = ACTIONS(3),
  },
  [139] = {
    [sym_struct_block_definition] = STATE(405),
    [sym__expression] = STATE(405),
    [sym__all_expressions] = STATE(405),
    [sym_if_expression] = STATE(405),
    [sym_index_expression] = STATE(405),
    [sym_assign_expression] = STATE(405),
    [sym_comp_assign_expression] = STATE(405),
    [sym_call_expression] = STATE(405),
    [sym_field_expression] = STATE(405),
    [sym_bool_literal] = STATE(405),
  